#ifndef TEXTANALYSE_H
#define TEXTANALYSE_H

//#define USE_DXLIB
#include "stdlib.h"

//͗pNX
class TextAnalyse
{
public:
	TextAnalyse();
	~TextAnalyse();

	bool load( const char *path );						//eLXgt@C̓ǂݍ
	bool setmem( const char *string, int size = -1 );	//̃eLXg̉͂ݒ

	bool release( void );							//ǂݍ񂾃eLXgt@CJ
	void reset( void );								//͈ʒu擪ɖ߂
	bool move( const char *pos );					//w̍WɈړ
	char *getpos( void );							//݂̍W擾
	bool search( const char *str );					//w̕񂪂ʒûPoCg܂ňړ(ꍇ͈ړȂ)
	char *check( const char *str );					//w̕񂪂ʒûPoCg̍W擾(ꍇ0)
	bool getint( int *buf );						//̐l擾
	bool getint16( int *buf );						//̐lPUiƂĎ擾
	bool getfloat( float *buf );					//̐l𕂓_ƂĎ擾
	bool getstr( char *buf, bool nomove = false );	//̕擾

	bool next( void );								//Ӗ̂P܂Ŕ( true:Ӗ̂Pꂪ  false:Ӗ̂Pꂪ )
	char *nextpos( void );							//ɈӖ̂P̃|C^擾(W͈Ӗ̂P̍ŏ̕Ɉړ)
	char nextchar( void );							//ɈӖ̂P̍ŏ̕擾(W͈Ӗ̂P̍ŏ̕Ɉړ)( -1:t@C̏I[ )
	const char *nextstr();							//ɈӖ̂P(t@C̏I[ɗĂꍇ̓k݂̂̕񂪕Ԃ)
	bool nextline( void );							//̍sɈړ
	bool skipgroup( const char *groupPre, const char *groupPost );	//O[vXLbv
	void comment_skip_enable( bool flag );			//RgXLbv邩ǂݒ肷(true:XLbv false:XLbvȂ)
	void setaddskip( const char *str );				//ǉӖȂݒ肷
	void setnotskip_space_tab( bool flag );			//Xy[Xƃ^uXLbvȂǂ(true:XLbvȂ false:XLbv)

	static int checksize( const char *str );		//̃oCg𓾂

protected:
	bool enable;			//Lȃf[^Ԃ
	bool mem;				//̃eLXg͂Ă邩
	bool commentNoSkip;		//RgXLbvȂǂ( true:Ȃ false: )
	char *buffer;			//obt@̐擪
	char *last;				//obt@̏I[̂PoCg
	int strsize;			//̃TCY
	char *pos;				//݂̈ʒu
	char addskip[16];		//ǉӖȂ
	bool notskip_space_tab;	//Xy[Xƃ^uXLbvȂǂ(true:XLbvȂ false:XLbv)

	bool checkC( char str );		//Ӗ̂镶ׂ(true:Ӗ镶)
};

//Unicode͗pNX
class TextAnalyseW
{
public:
	TextAnalyseW();
	~TextAnalyseW();

	static bool checkUnicode( const char *path );			//w̃eLXgt@CjR[hǂ𔻒肷(true:jR[h  false:}`oCg)
	static bool checkUnicodeMem( void *string );			//w̃̃eLXgjR[hǂ𔻒肷(true:jR[h  false:}`oCg)

	bool load( const char *path );							//eLXgt@C̓ǂݍ
	bool setmem( const wchar_t *string, int size = -1 );	//̃eLXg̉͂ݒ(size ̓oCg)

	bool release( void );									//ǂݍ񂾃eLXgt@CJ
	void reset( void );										//͈ʒu擪ɖ߂
	bool move( const wchar_t *pos );						//w̍WɈړ
	wchar_t *getpos( void );								//݂̍W擾
	bool search( const wchar_t *str );						//w̕񂪂ʒûPoCg܂ňړ(ꍇ͈ړȂ)
	wchar_t *check( const wchar_t *str );					//w̕񂪂ʒûPoCg̍W擾(ꍇ0)
	bool getint( int *buf );								//̐l擾
	bool getint16( int *buf );								//̐lPUiƂĎ擾
	bool getstr( wchar_t *buf, bool nomove = false );		//̕擾

	bool next( void );										//Ӗ̂P܂Ŕ
	wchar_t *nextpos( void );								//ɈӖ̂P̃|C^擾(W͈Ӗ̂P̍ŏ̕Ɉړ)
	wchar_t nextchar( void );								//ɈӖ̂P̍ŏ̕擾(W͈Ӗ̂P̍ŏ̕Ɉړ)
	const wchar_t *nextstr();								//ɈӖ̂P(t@C̏I[ɗĂꍇ̓k݂̂̕񂪕Ԃ)
	bool nextline( void );									//̍sɈړ
	bool skipgroup( const wchar_t *groupPre, const wchar_t *groupPost );	//O[vXLbv
	void comment_skip_enable( bool flag );					//RgXLbv邩ǂݒ肷
	void setaddskip( const wchar_t *str );					//ǉӖȂݒ肷
	void setnotskip_space_tab( bool flag );					//Xy[Xƃ^uXLbvȂǂ(true:XLbvȂ false:XLbv)

protected:
	bool enable;		//Lȃf[^Ԃ
	bool mem;			//̃eLXg͂Ă邩
	bool commentNoSkip;	//RgXLbvȂǂ( true:Ȃ false: )
	wchar_t *buffer;	//obt@̐擪
	wchar_t *last;		//obt@̏I[̂PoCg
	int strsize;		//̃TCY
	wchar_t *pos;		//݂̈ʒu
	wchar_t addskip[16];		//ǉӖȂ
	bool notskip_space_tab;	//Xy[Xƃ^uXLbvȂǂ(true:XLbvȂ false:XLbv)

	bool checkC( wchar_t str );		//Ӗ̂镶ׂ(true:Ӗ镶)
};

#endif
