using System.Runtime.InteropServices;
namespace DxLibDLL
{
	public static class DX
	{
		public const int TRUE  = 1;
		public const int FALSE = 0;
		public const int MAX_IMAGE_NUM = 262144;
		public const int MAX_IMAGE_DIVNUM = 64;
		public const int MAX_SHADOWMAP_NUM = 8192;
		public const int MAX_SOFTIMAGE_NUM = 8192;
		public const int MAX_SOUND_NUM = 32768;
		public const int MAX_SOFTSOUND_NUM = 8192;
		public const int MAX_MUSIC_NUM = 256;
		public const int MAX_MOVIE_NUM = 100;
		public const int MAX_MASK_NUM = 32768;
		public const int MAX_FONT_NUM = 256;
		public const int MAX_INPUT_NUM = 256;
		public const int MAX_SOCKET_NUM = 8192;
		public const int MAX_LIGHT_NUM = 4096;
		public const int MAX_SHADER_NUM = 4096;
		public const int MAX_CONSTANT_BUFFER_NUM = 32768;
		public const int MAX_MODEL_BASE_NUM = 32768;
		public const int MAX_MODEL_NUM = 32768;
		public const int MAX_VERTEX_BUFFER_NUM = 16384;
		public const int MAX_INDEX_BUFFER_NUM = 16384;
		public const int MAX_FILE_NUM = 32768;
		public const int MAX_LIVE2D_CUBISM4_MODEL_NUM = 32768;
		public const int DX_HANDLETYPE_NONE = 0;
		public const int DX_HANDLETYPE_GRAPH = 1;
		public const int DX_HANDLETYPE_SOFTIMAGE = 2;
		public const int DX_HANDLETYPE_SOUND = 3;
		public const int DX_HANDLETYPE_SOFTSOUND = 4;
		public const int DX_HANDLETYPE_MUSIC = 5;
		public const int DX_HANDLETYPE_MOVIE = 6;
		public const int DX_HANDLETYPE_GMASK = 7;
		public const int DX_HANDLETYPE_FONT = 8;
		public const int DX_HANDLETYPE_KEYINPUT = 9;
		public const int DX_HANDLETYPE_NETWORK = 10;
		public const int DX_HANDLETYPE_LIGHT = 11;
		public const int DX_HANDLETYPE_SHADER = 12;
		public const int DX_HANDLETYPE_MODEL_BASE = 13;
		public const int DX_HANDLETYPE_MODEL = 14;
		public const int DX_HANDLETYPE_VERTEX_BUFFER = 15;
		public const int DX_HANDLETYPE_INDEX_BUFFER = 16;
		public const int DX_HANDLETYPE_FILE = 17;
		public const int DX_HANDLETYPE_SHADOWMAP = 18;
		public const int DX_HANDLETYPE_SHADER_CONSTANT_BUFFER = 19;
		public const int DX_HANDLETYPE_LIVE2D_CUBISM4_MODEL = 20;
		public const int MAX_JOYPAD_NUM = 16;
		public const int DEFAULT_SCREEN_SIZE_X = 640;
		public const int DEFAULT_SCREEN_SIZE_Y = 480;
		public const int DEFAULT_COLOR_BITDEPTH = 16;
		public const int DEFAULT_ZBUFFER_BITDEPTH = 16;
		public const int DX_DEFAULT_FONT_HANDLE = 2;
		public const int MAX_USERIMAGEREAD_FUNCNUM = 10;
		public const int DX_WINDOWSVERSION_31 = 0;
		public const int DX_WINDOWSVERSION_95 = 1;
		public const int DX_WINDOWSVERSION_98 = 2;
		public const int DX_WINDOWSVERSION_ME = 3;
		public const int DX_WINDOWSVERSION_NT31 = 260;
		public const int DX_WINDOWSVERSION_NT40 = 261;
		public const int DX_WINDOWSVERSION_2000 = 262;
		public const int DX_WINDOWSVERSION_XP = 263;
		public const int DX_WINDOWSVERSION_VISTA = 264;
		public const int DX_WINDOWSVERSION_7 = 265;
		public const int DX_WINDOWSVERSION_8 = 266;
		public const int DX_WINDOWSVERSION_8_1 = 267;
		public const int DX_WINDOWSVERSION_10 = 268;
		public const int DX_WINDOWSVERSION_11 = 269;
		public const int DX_WINDOWSVERSION_NT_TYPE = 256;
		public const int DX_DIRECTXVERSION_NON = 0;
		public const int DX_DIRECTXVERSION_1 = 65536;
		public const int DX_DIRECTXVERSION_2 = 131072;
		public const int DX_DIRECTXVERSION_3 = 196608;
		public const int DX_DIRECTXVERSION_4 = 262144;
		public const int DX_DIRECTXVERSION_5 = 327680;
		public const int DX_DIRECTXVERSION_6 = 393216;
		public const int DX_DIRECTXVERSION_6_1 = 393472;
		public const int DX_DIRECTXVERSION_7 = 458752;
		public const int DX_DIRECTXVERSION_8 = 524288;
		public const int DX_DIRECTXVERSION_8_1 = 524544;
		public const int DX_DIRECT3D_NONE = 0;
		public const int DX_DIRECT3D_9 = 1;
		public const int DX_DIRECT3D_9EX = 2;
		public const int DX_DIRECT3D_11 = 3;
		public const int DX_DIRECT3D_11_FEATURE_LEVEL_9_1 = 37120;
		public const int DX_DIRECT3D_11_FEATURE_LEVEL_9_2 = 37376;
		public const int DX_DIRECT3D_11_FEATURE_LEVEL_9_3 = 37632;
		public const int DX_DIRECT3D_11_FEATURE_LEVEL_10_0 = 40960;
		public const int DX_DIRECT3D_11_FEATURE_LEVEL_10_1 = 41216;
		public const int DX_DIRECT3D_11_FEATURE_LEVEL_11_0 = 45056;
		public const int DX_DIRECT3D_11_FEATURE_LEVEL_11_1 = 45312;
		public const int DX_CHARSET_DEFAULT = 0;
		public const int DX_CHARSET_SHFTJIS = 1;
		public const int DX_CHARSET_HANGEUL = 2;
		public const int DX_CHARSET_BIG5 = 3;
		public const int DX_CHARSET_GB2312 = 4;
		public const int DX_CHARSET_WINDOWS_1252 = 5;
		public const int DX_CHARSET_ISO_IEC_8859_15 = 6;
		public const int DX_CHARSET_UTF8 = 7;
		public const int DX_CHARSET_NUM = 8;
		public const int DX_CHARCODEFORMAT_SHIFTJIS = 932;
		public const int DX_CHARCODEFORMAT_GB2312 = 936;
		public const int DX_CHARCODEFORMAT_UHC = 949;
		public const int DX_CHARCODEFORMAT_BIG5 = 950;
		public const int DX_CHARCODEFORMAT_UTF16LE = 1200;
		public const int DX_CHARCODEFORMAT_UTF16BE = 1201;
		public const int DX_CHARCODEFORMAT_WINDOWS_1252 = 1252;
		public const int DX_CHARCODEFORMAT_ISO_IEC_8859_15 = 32764;
		public const int DX_CHARCODEFORMAT_UTF8 = 65001;
		public const int DX_CHARCODEFORMAT_ASCII = 32765;
		public const int DX_CHARCODEFORMAT_UTF32LE = 32766;
		public const int DX_CHARCODEFORMAT_UTF32BE = 32767;
		public const int DX_MIDIMODE_MCI = 0;
		public const int DX_MIDIMODE_DM = 1;
		public const int DX_MIDIMODE_DIRECT_MUSIC_REVERB = 1;
		public const int DX_MIDIMODE_DIRECT_MUSIC_NORMAL = 2;
		public const int DX_MIDIMODE_NUM = 3;
		public const int DX_DRAWMODE_NEAREST = 0;
		public const int DX_DRAWMODE_BILINEAR = 1;
		public const int DX_DRAWMODE_ANISOTROPIC = 2;
		public const int DX_DRAWMODE_OTHER = 3;
		public const int DX_DRAWMODE_NUM = 4;
		public const int DX_FONTTYPE_NORMAL = 0;
		public const int DX_FONTTYPE_EDGE = 1;
		public const int DX_FONTTYPE_ANTIALIASING = 2;
		public const int DX_FONTTYPE_ANTIALIASING_4X4 = 18;
		public const int DX_FONTTYPE_ANTIALIASING_8X8 = 34;
		public const int DX_FONTTYPE_ANTIALIASING_16X16 = 50;
		public const int DX_FONTTYPE_ANTIALIASING_EDGE = 3;
		public const int DX_FONTTYPE_ANTIALIASING_EDGE_4X4 = 19;
		public const int DX_FONTTYPE_ANTIALIASING_EDGE_8X8 = 35;
		public const int DX_FONTTYPE_ANTIALIASING_EDGE_16X16 = 51;
		public const int DX_FONTIMAGE_BIT_1 = 0;
		public const int DX_FONTIMAGE_BIT_4 = 1;
		public const int DX_FONTIMAGE_BIT_8 = 2;
		public const int DX_BLENDMODE_NOBLEND = 0;
		public const int DX_BLENDMODE_ALPHA = 1;
		public const int DX_BLENDMODE_ADD = 2;
		public const int DX_BLENDMODE_SUB = 3;
		public const int DX_BLENDMODE_MUL = 4;
		public const int DX_BLENDMODE_SUB2 = 5;
		public const int DX_BLENDMODE_XOR = 6;
		public const int DX_BLENDMODE_DESTCOLOR = 8;
		public const int DX_BLENDMODE_INVDESTCOLOR = 9;
		public const int DX_BLENDMODE_INVSRC = 10;
		public const int DX_BLENDMODE_MULA = 11;
		public const int DX_BLENDMODE_ALPHA_X4 = 12;
		public const int DX_BLENDMODE_ADD_X4 = 13;
		public const int DX_BLENDMODE_SRCCOLOR = 14;
		public const int DX_BLENDMODE_HALF_ADD = 15;
		public const int DX_BLENDMODE_SUB1 = 16;
		public const int DX_BLENDMODE_PMA_ALPHA = 17;
		public const int DX_BLENDMODE_PMA_ADD = 18;
		public const int DX_BLENDMODE_PMA_SUB = 19;
		public const int DX_BLENDMODE_PMA_INVSRC = 20;
		public const int DX_BLENDMODE_PMA_ALPHA_X4 = 21;
		public const int DX_BLENDMODE_PMA_ADD_X4 = 22;
		public const int DX_BLENDMODE_LIVE2D_ZERO = 23;
		public const int DX_BLENDMODE_LIVE2D_NORMAL = 24;
		public const int DX_BLENDMODE_LIVE2D_ADD = 25;
		public const int DX_BLENDMODE_LIVE2D_MULT = 26;
		public const int DX_BLENDMODE_LIVE2D_MASK = 27;
		public const int DX_BLENDMODE_SPINE_NORMAL = 28;
		public const int DX_BLENDMODE_SPINE_ADDITIVE = 29;
		public const int DX_BLENDMODE_SPINE_MULTIPLY = 30;
		public const int DX_BLENDMODE_SPINE_SCREEN = 31;
		public const int DX_BLENDMODE_CUSTOM = 32;
		public const int DX_BLENDMODE_DST_RGB_SRC_A = 33;
		public const int DX_BLENDMODE_INVDESTCOLOR_A = 34;
		public const int DX_BLENDMODE_MUL_A = 35;
		public const int DX_BLENDMODE_PMA_INVDESTCOLOR_A = 36;
		public const int DX_BLENDMODE_PMA_MUL_A = 37;
		public const int DX_BLENDMODE_NUM = 38;
		public const int DX_BLEND_ZERO = 0;
		public const int DX_BLEND_ONE = 1;
		public const int DX_BLEND_SRC_COLOR = 2;
		public const int DX_BLEND_INV_SRC_COLOR = 3;
		public const int DX_BLEND_SRC_ALPHA = 4;
		public const int DX_BLEND_INV_SRC_ALPHA = 5;
		public const int DX_BLEND_DEST_COLOR = 6;
		public const int DX_BLEND_INV_DEST_COLOR = 7;
		public const int DX_BLEND_DEST_ALPHA = 8;
		public const int DX_BLEND_INV_DEST_ALPHA = 9;
		public const int DX_BLEND_SRC_ALPHA_SAT = 10;
		public const int DX_BLEND_NUM = 11;
		public const int DX_BLENDOP_ADD = 0;
		public const int DX_BLENDOP_SUBTRACT = 1;
		public const int DX_BLENDOP_REV_SUBTRACT = 2;
		public const int DX_BLENDOP_MIX = 3;
		public const int DX_BLENDOP_MAX = 4;
		public const int DX_BLENDOP_NUM = 5;
		public const int DX_DRAWFLOATCOORDTYPE_DIRECT3D9 = 0;
		public const int DX_DRAWFLOATCOORDTYPE_DIRECT3D10 = 1;
		public const int DX_BLENDGRAPHTYPE_NORMAL = 0;
		public const int DX_BLENDGRAPHTYPE_WIPE = 1;
		public const int DX_BLENDGRAPHTYPE_ALPHA = 2;
		public const int DX_BLENDGRAPHTYPE_NUM = 3;
		public const int DX_BLENDGRAPH_POSMODE_DRAWGRAPH = 0;
		public const int DX_BLENDGRAPH_POSMODE_SCREEN = 1;
		public const int DX_BLENDGRAPH_POSMODE_NUM = 2;
		public const int DX_GRAPH_FILTER_MONO = 0;
		public const int DX_GRAPH_FILTER_GAUSS = 1;
		public const int DX_GRAPH_FILTER_DOWN_SCALE = 2;
		public const int DX_GRAPH_FILTER_BRIGHT_CLIP = 3;
		public const int DX_GRAPH_FILTER_BRIGHT_SCALE = 4;
		public const int DX_GRAPH_FILTER_HSB = 5;
		public const int DX_GRAPH_FILTER_INVERT = 6;
		public const int DX_GRAPH_FILTER_LEVEL = 7;
		public const int DX_GRAPH_FILTER_TWO_COLOR = 8;
		public const int DX_GRAPH_FILTER_GRADIENT_MAP = 9;
		public const int DX_GRAPH_FILTER_REPLACEMENT = 10;
		public const int DX_GRAPH_FILTER_BILATERAL_BLUR = 11;
		public const int DX_GRAPH_FILTER_PREMUL_ALPHA = 12;
		public const int DX_GRAPH_FILTER_INTERP_ALPHA = 13;
		public const int DX_GRAPH_FILTER_YUV_TO_RGB = 14;
		public const int DX_GRAPH_FILTER_Y2UV1_TO_RGB = 15;
		public const int DX_GRAPH_FILTER_YUV_TO_RGB_RRA = 16;
		public const int DX_GRAPH_FILTER_Y2UV1_TO_RGB_RRA = 17;
		public const int DX_GRAPH_FILTER_BICUBIC_SCALE = 18;
		public const int DX_GRAPH_FILTER_LANCZOS3_SCALE = 19;
		public const int DX_GRAPH_FILTER_SSAO = 20;
		public const int DX_GRAPH_FILTER_FLOAT_COLOR_SCALE = 21;
		public const int DX_GRAPH_FILTER_PMA_BRIGHT_CLIP = 22;
		public const int DX_GRAPH_FILTER_PMA_BRIGHT_SCALE = 23;
		public const int DX_GRAPH_FILTER_PMA_HSB = 24;
		public const int DX_GRAPH_FILTER_PMA_INVERT = 25;
		public const int DX_GRAPH_FILTER_PMA_LEVEL = 26;
		public const int DX_GRAPH_FILTER_PMA_TWO_COLOR = 27;
		public const int DX_GRAPH_FILTER_PMA_GRADIENT_MAP = 28;
		public const int DX_GRAPH_FILTER_PMA_REPLACEMENT = 29;
		public const int DX_GRAPH_FILTER_PMA_BILATERAL_BLUR = 30;
		public const int DX_GRAPH_FILTER_NUM = 31;
		public const int DX_GRAPH_BLEND_NORMAL = 0;
		public const int DX_GRAPH_BLEND_RGBA_SELECT_MIX = 1;
		public const int DX_GRAPH_BLEND_MULTIPLE = 2;
		public const int DX_GRAPH_BLEND_DIFFERENCE = 3;
		public const int DX_GRAPH_BLEND_ADD = 4;
		public const int DX_GRAPH_BLEND_SCREEN = 5;
		public const int DX_GRAPH_BLEND_OVERLAY = 6;
		public const int DX_GRAPH_BLEND_DODGE = 7;
		public const int DX_GRAPH_BLEND_BURN = 8;
		public const int DX_GRAPH_BLEND_DARKEN = 9;
		public const int DX_GRAPH_BLEND_LIGHTEN = 10;
		public const int DX_GRAPH_BLEND_SOFTLIGHT = 11;
		public const int DX_GRAPH_BLEND_HARDLIGHT = 12;
		public const int DX_GRAPH_BLEND_EXCLUSION = 13;
		public const int DX_GRAPH_BLEND_NORMAL_ALPHACH = 14;
		public const int DX_GRAPH_BLEND_ADD_ALPHACH = 15;
		public const int DX_GRAPH_BLEND_MULTIPLE_A_ONLY = 16;
		public const int DX_GRAPH_BLEND_PMA_NORMAL = 17;
		public const int DX_GRAPH_BLEND_PMA_RGBA_SELECT_MIX = 18;
		public const int DX_GRAPH_BLEND_PMA_MULTIPLE = 19;
		public const int DX_GRAPH_BLEND_PMA_DIFFERENCE = 20;
		public const int DX_GRAPH_BLEND_PMA_ADD = 21;
		public const int DX_GRAPH_BLEND_PMA_SCREEN = 22;
		public const int DX_GRAPH_BLEND_PMA_OVERLAY = 23;
		public const int DX_GRAPH_BLEND_PMA_DODGE = 24;
		public const int DX_GRAPH_BLEND_PMA_BURN = 25;
		public const int DX_GRAPH_BLEND_PMA_DARKEN = 26;
		public const int DX_GRAPH_BLEND_PMA_LIGHTEN = 27;
		public const int DX_GRAPH_BLEND_PMA_SOFTLIGHT = 28;
		public const int DX_GRAPH_BLEND_PMA_HARDLIGHT = 29;
		public const int DX_GRAPH_BLEND_PMA_EXCLUSION = 30;
		public const int DX_GRAPH_BLEND_PMA_NORMAL_ALPHACH = 31;
		public const int DX_GRAPH_BLEND_PMA_ADD_ALPHACH = 32;
		public const int DX_GRAPH_BLEND_PMA_MULTIPLE_A_ONLY = 33;
		public const int DX_GRAPH_BLEND_MASK = 34;
		public const int DX_GRAPH_BLEND_PMA_MASK = 35;
		public const int DX_GRAPH_BLEND_NUM = 36;
		public const int DX_RGBA_SELECT_SRC_R = 0;
		public const int DX_RGBA_SELECT_SRC_G = 1;
		public const int DX_RGBA_SELECT_SRC_B = 2;
		public const int DX_RGBA_SELECT_SRC_A = 3;
		public const int DX_RGBA_SELECT_BLEND_R = 4;
		public const int DX_RGBA_SELECT_BLEND_G = 5;
		public const int DX_RGBA_SELECT_BLEND_B = 6;
		public const int DX_RGBA_SELECT_BLEND_A = 7;
		public const int DX_RGBA_SELECT_SRC_INV_R = 8;
		public const int DX_RGBA_SELECT_SRC_INV_G = 9;
		public const int DX_RGBA_SELECT_SRC_INV_B = 10;
		public const int DX_RGBA_SELECT_SRC_INV_A = 11;
		public const int DX_RGBA_SELECT_BLEND_INV_R = 12;
		public const int DX_RGBA_SELECT_BLEND_INV_G = 13;
		public const int DX_RGBA_SELECT_BLEND_INV_B = 14;
		public const int DX_RGBA_SELECT_BLEND_INV_A = 15;
		public const int DX_FILL_WIREFRAME = 2;
		public const int DX_FILL_SOLID = 3;
		public const int DX_CULLING_NONE = 0;
		public const int DX_CULLING_LEFT = 1;
		public const int DX_CULLING_RIGHT = 2;
		public const int DX_CULLING_NUM = 3;
		public const int DX_CAMERACLIP_LEFT = 1;
		public const int DX_CAMERACLIP_RIGHT = 2;
		public const int DX_CAMERACLIP_BOTTOM = 4;
		public const int DX_CAMERACLIP_TOP = 8;
		public const int DX_CAMERACLIP_BACK = 16;
		public const int DX_CAMERACLIP_FRONT = 32;
		public const int DX_MV1_DRAWMODE_NORMAL = 0;
		public const int DX_MV1_DRAWMODE_NORMAL_DEPTH = 1;
		public const int DX_MV1_VERTEX_TYPE_1FRAME = 0;
		public const int DX_MV1_VERTEX_TYPE_4FRAME = 1;
		public const int DX_MV1_VERTEX_TYPE_8FRAME = 2;
		public const int DX_MV1_VERTEX_TYPE_FREE_FRAME = 3;
		public const int DX_MV1_VERTEX_TYPE_NMAP_1FRAME = 4;
		public const int DX_MV1_VERTEX_TYPE_NMAP_4FRAME = 5;
		public const int DX_MV1_VERTEX_TYPE_NMAP_8FRAME = 6;
		public const int DX_MV1_VERTEX_TYPE_NMAP_FREE_FRAME = 7;
		public const int DX_MV1_VERTEX_TYPE_NUM = 8;
		public const int DX_MV1_MESHCATEGORY_NORMAL = 0;
		public const int DX_MV1_MESHCATEGORY_OUTLINE = 1;
		public const int DX_MV1_MESHCATEGORY_OUTLINE_ORIG_SHADER = 2;
		public const int DX_MV1_MESHCATEGORY_NUM = 3;
		public const int DX_MV1_SHAPERATE_ADD = 0;
		public const int DX_MV1_SHAPERATE_OVERWRITE = 1;
		public const int MV1_SAVETYPE_MESH = 1;
		public const int MV1_SAVETYPE_ANIM = 2;
		public const int MV1_SAVETYPE_NORMAL = ( MV1_SAVETYPE_MESH | MV1_SAVETYPE_ANIM  );
		public const int MV1_ANIMKEY_DATATYPE_ROTATE = 0;
		public const int MV1_ANIMKEY_DATATYPE_ROTATE_X = 1;
		public const int MV1_ANIMKEY_DATATYPE_ROTATE_Y = 2;
		public const int MV1_ANIMKEY_DATATYPE_ROTATE_Z = 3;
		public const int MV1_ANIMKEY_DATATYPE_SCALE = 5;
		public const int MV1_ANIMKEY_DATATYPE_SCALE_X = 6;
		public const int MV1_ANIMKEY_DATATYPE_SCALE_Y = 7;
		public const int MV1_ANIMKEY_DATATYPE_SCALE_Z = 8;
		public const int MV1_ANIMKEY_DATATYPE_TRANSLATE = 10;
		public const int MV1_ANIMKEY_DATATYPE_TRANSLATE_X = 11;
		public const int MV1_ANIMKEY_DATATYPE_TRANSLATE_Y = 12;
		public const int MV1_ANIMKEY_DATATYPE_TRANSLATE_Z = 13;
		public const int MV1_ANIMKEY_DATATYPE_MATRIX4X4C = 15;
		public const int MV1_ANIMKEY_DATATYPE_MATRIX3X3 = 17;
		public const int MV1_ANIMKEY_DATATYPE_SHAPE = 18;
		public const int MV1_ANIMKEY_DATATYPE_OTHRE = 20;
		public const int MV1_ANIMKEY_TIME_TYPE_ONE = 0;
		public const int MV1_ANIMKEY_TIME_TYPE_KEY = 1;
		public const int MV1_ANIMKEY_TYPE_QUATERNION_X = 0;
		public const int MV1_ANIMKEY_TYPE_VECTOR = 1;
		public const int MV1_ANIMKEY_TYPE_MATRIX4X4C = 2;
		public const int MV1_ANIMKEY_TYPE_MATRIX3X3 = 3;
		public const int MV1_ANIMKEY_TYPE_FLAT = 4;
		public const int MV1_ANIMKEY_TYPE_LINEAR = 5;
		public const int MV1_ANIMKEY_TYPE_BLEND = 6;
		public const int MV1_ANIMKEY_TYPE_QUATERNION_VMD = 7;
		public const int DX_SCREEN_FRONT = -4;
		public const int DX_SCREEN_BACK = -2;
		public const int DX_SCREEN_WORK = -3;
		public const int DX_SCREEN_TEMPFRONT = -16;
		public const int DX_SCREEN_OTHER = -6;
		public const int DX_NONE_GRAPH = -5;
		public const int DX_SHAVEDMODE_NONE = 0;
		public const int DX_SHAVEDMODE_DITHER = 1;
		public const int DX_SHAVEDMODE_DIFFUS = 2;
		public const int DX_IMAGESAVETYPE_BMP = 0;
		public const int DX_IMAGESAVETYPE_JPEG = 1;
		public const int DX_IMAGESAVETYPE_PNG = 2;
		public const int DX_IMAGESAVETYPE_DDS = 3;
		public const int DX_PLAYTYPE_LOOPBIT = 2;
		public const int DX_PLAYTYPE_BACKBIT = 1;
		public const int DX_PLAYTYPE_NORMAL = 0;
		public const int DX_PLAYTYPE_BACK = ( DX_PLAYTYPE_BACKBIT  );
		public const int DX_PLAYTYPE_LOOP = ( DX_PLAYTYPE_LOOPBIT | DX_PLAYTYPE_BACKBIT  );
		public const int DX_MOVIEPLAYTYPE_BCANCEL = 0;
		public const int DX_MOVIEPLAYTYPE_NORMAL = 1;
		public const int DX_SOUNDTYPE_NORMAL = 0;
		public const int DX_SOUNDTYPE_STREAMSTYLE = 1;
		public const int DX_SOUNDDATATYPE_MEMNOPRESS = 0;
		public const int DX_SOUNDDATATYPE_MEMNOPRESS_PLUS = 1;
		public const int DX_SOUNDDATATYPE_MEMPRESS = 2;
		public const int DX_SOUNDDATATYPE_FILE = 3;
		public const int DX_SOUNDCURRENTTIME_TYPE_LOW_LEVEL = 0;
		public const int DX_SOUNDCURRENTTIME_TYPE_SOFT = 1;
		public const int DX_READSOUNDFUNCTION_PCM = 1;
		public const int DX_READSOUNDFUNCTION_OGG = 1;
		public const int DX_READSOUNDFUNCTION_OPUS = 1;
		public const int DX_READSOUNDFUNCTION_DEFAULT_NUM = 3;
		public const int DX_REVERB_PRESET_DEFAULT = 0;
		public const int DX_REVERB_PRESET_GENERIC = 1;
		public const int DX_REVERB_PRESET_PADDEDCELL = 2;
		public const int DX_REVERB_PRESET_ROOM = 3;
		public const int DX_REVERB_PRESET_BATHROOM = 4;
		public const int DX_REVERB_PRESET_LIVINGROOM = 5;
		public const int DX_REVERB_PRESET_STONEROOM = 6;
		public const int DX_REVERB_PRESET_AUDITORIUM = 7;
		public const int DX_REVERB_PRESET_CONCERTHALL = 8;
		public const int DX_REVERB_PRESET_CAVE = 9;
		public const int DX_REVERB_PRESET_ARENA = 10;
		public const int DX_REVERB_PRESET_HANGAR = 11;
		public const int DX_REVERB_PRESET_CARPETEDHALLWAY = 12;
		public const int DX_REVERB_PRESET_HALLWAY = 13;
		public const int DX_REVERB_PRESET_STONECORRIDOR = 14;
		public const int DX_REVERB_PRESET_ALLEY = 15;
		public const int DX_REVERB_PRESET_FOREST = 16;
		public const int DX_REVERB_PRESET_CITY = 17;
		public const int DX_REVERB_PRESET_MOUNTAINS = 18;
		public const int DX_REVERB_PRESET_QUARRY = 19;
		public const int DX_REVERB_PRESET_PLAIN = 20;
		public const int DX_REVERB_PRESET_PARKINGLOT = 21;
		public const int DX_REVERB_PRESET_SEWERPIPE = 22;
		public const int DX_REVERB_PRESET_UNDERWATER = 23;
		public const int DX_REVERB_PRESET_SMALLROOM = 24;
		public const int DX_REVERB_PRESET_MEDIUMROOM = 25;
		public const int DX_REVERB_PRESET_LARGEROOM = 26;
		public const int DX_REVERB_PRESET_MEDIUMHALL = 27;
		public const int DX_REVERB_PRESET_LARGEHALL = 28;
		public const int DX_REVERB_PRESET_PLATE = 29;
		public const int DX_REVERB_PRESET_NUM = 30;
		public const int DX_MASKTRANS_WHITE = 0;
		public const int DX_MASKTRANS_BLACK = 1;
		public const int DX_MASKTRANS_NONE = 2;
		public const int DX_MASKGRAPH_CH_A = 0;
		public const int DX_MASKGRAPH_CH_R = 1;
		public const int DX_MASKGRAPH_CH_G = 2;
		public const int DX_MASKGRAPH_CH_B = 3;
		public const int DX_ZWRITE_MASK = 0;
		public const int DX_ZWRITE_CLEAR = 1;
		public const int DX_CMP_NEVER = 1;
		public const int DX_CMP_LESS = 2;
		public const int DX_CMP_EQUAL = 3;
		public const int DX_CMP_LESSEQUAL = 4;
		public const int DX_CMP_GREATER = 5;
		public const int DX_CMP_NOTEQUAL = 6;
		public const int DX_CMP_GREATEREQUAL = 7;
		public const int DX_CMP_ALWAYS = 8;
		public const int DX_ZCMP_DEFAULT = ( DX_CMP_LESSEQUAL  );
		public const int DX_ZCMP_REVERSE = ( DX_CMP_GREATEREQUAL  );
		public const int DX_SHADEMODE_FLAT = 1;
		public const int DX_SHADEMODE_GOURAUD = 2;
		public const int DX_FOGMODE_NONE = 0;
		public const int DX_FOGMODE_EXP = 1;
		public const int DX_FOGMODE_EXP2 = 2;
		public const int DX_FOGMODE_LINEAR = 3;
		public const int DX_MATERIAL_TYPE_NORMAL = 0;
		public const int DX_MATERIAL_TYPE_TOON = 1;
		public const int DX_MATERIAL_TYPE_TOON_2 = 2;
		public const int DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_UNORM = 3;
		public const int DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_CLIP_UNORM = 4;
		public const int DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_CMP_GREATEREQUAL = 5;
		public const int DX_MATERIAL_TYPE_MAT_SPEC_POWER_UNORM = 6;
		public const int DX_MATERIAL_TYPE_MAT_SPEC_POWER_CLIP_UNORM = 7;
		public const int DX_MATERIAL_TYPE_MAT_SPEC_POWER_CMP_GREATEREQUAL = 8;
		public const int DX_MATERIAL_TYPE_NUM = 9;
		public const int DX_MATERIAL_BLENDTYPE_TRANSLUCENT = 0;
		public const int DX_MATERIAL_BLENDTYPE_ADDITIVE = 1;
		public const int DX_MATERIAL_BLENDTYPE_MODULATE = 2;
		public const int DX_MATERIAL_BLENDTYPE_NONE = 3;
		public const int DX_TEXADDRESS_WRAP = 1;
		public const int DX_TEXADDRESS_MIRROR = 2;
		public const int DX_TEXADDRESS_CLAMP = 3;
		public const int DX_TEXADDRESS_BORDER = 4;
		public const int DX_TEXADDRESS_NUM = 5;
		public const int DX_SHADERTYPE_VERTEX = 0;
		public const int DX_SHADERTYPE_PIXEL = 1;
		public const int DX_SHADERTYPE_GEOMETRY = 2;
		public const int DX_SHADERTYPE_COMPUTE = 3;
		public const int DX_SHADERTYPE_DOMAIN = 4;
		public const int DX_SHADERTYPE_HULL = 5;
		public const int DX_VERTEX_TYPE_NORMAL_3D = 0;
		public const int DX_VERTEX_TYPE_SHADER_3D = 1;
		public const int DX_VERTEX_TYPE_NUM = 2;
		public const int DX_INDEX_TYPE_16BIT = 0;
		public const int DX_INDEX_TYPE_32BIT = 1;
		public const int DX_LOADMODEL_PHYSICS_DISABLE = 1;
		public const int DX_LOADMODEL_PHYSICS_LOADCALC = 0;
		public const int DX_LOADMODEL_PHYSICS_REALTIME = 2;
		public const int DX_LOADMODEL_PHYSICS_DISABLENAMEWORD_ALWAYS = 0;
		public const int DX_LOADMODEL_PHYSICS_DISABLENAMEWORD_DISABLEPHYSICSFILEONLY = 1;
		public const int DX_LOADMODEL_PHYSICS_DISABLENAMEWORD_NUM = 2;
		public const int DX_LOADMODEL_PMD_PMX_ANIMATION_FPSMODE_30 = 0;
		public const int DX_LOADMODEL_PMD_PMX_ANIMATION_FPSMODE_60 = 1;
		public const int DX_SEMITRANSDRAWMODE_ALWAYS = 0;
		public const int DX_SEMITRANSDRAWMODE_SEMITRANS_ONLY = 1;
		public const int DX_SEMITRANSDRAWMODE_NOT_SEMITRANS_ONLY = 2;
		public const int DX_CUBEMAP_FACE_POSITIVE_X = 0;
		public const int DX_CUBEMAP_FACE_NEGATIVE_X = 1;
		public const int DX_CUBEMAP_FACE_POSITIVE_Y = 2;
		public const int DX_CUBEMAP_FACE_NEGATIVE_Y = 3;
		public const int DX_CUBEMAP_FACE_POSITIVE_Z = 4;
		public const int DX_CUBEMAP_FACE_NEGATIVE_Z = 5;
		public const int DX_PRIMTYPE_POINTLIST = 1;
		public const int DX_PRIMTYPE_LINELIST = 2;
		public const int DX_PRIMTYPE_LINESTRIP = 3;
		public const int DX_PRIMTYPE_TRIANGLELIST = 4;
		public const int DX_PRIMTYPE_TRIANGLESTRIP = 5;
		public const int DX_PRIMTYPE_TRIANGLEFAN = 6;
		public const int DX_PRIMTYPE_MIN = 1;
		public const int DX_PRIMTYPE_MAX = 6;
		public const int DX_LIGHTTYPE_D3DLIGHT_POINT = 1;
		public const int DX_LIGHTTYPE_D3DLIGHT_SPOT = 2;
		public const int DX_LIGHTTYPE_D3DLIGHT_DIRECTIONAL = 3;
		public const int DX_LIGHTTYPE_POINT = 1;
		public const int DX_LIGHTTYPE_SPOT = 2;
		public const int DX_LIGHTTYPE_DIRECTIONAL = 3;
		public const int DX_LIVE2D_SHADER_SETUP_MASK_VERTEX = 0;
		public const int DX_LIVE2D_SHADER_SETUP_MASK_PIXEL = 1;
		public const int DX_LIVE2D_SHADER_NORMAL_VERTEX = 2;
		public const int DX_LIVE2D_SHADER_NORMAL_VERTEX_MASKED = 3;
		public const int DX_LIVE2D_SHADER_NORMAL_PIXEL = 4;
		public const int DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED = 5;
		public const int DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED_INVERTED = 6;
		public const int DX_LIVE2D_SHADER_NORMAL_PIXEL_PREMULALPHA = 7;
		public const int DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED_PREMULALPHA = 8;
		public const int DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED_INVERTEX_PREMULALPHA = 9;
		public const int DX_LIVE2D_SHADER_NUM = 10;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_PAL4 = 0;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_PAL8 = 1;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_PAL4 = 2;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_PAL8 = 3;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_PAL4 = 4;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_PAL8 = 5;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_RGB16 = 6;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_RGB32 = 7;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_RGB16 = 8;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_RGB32 = 9;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_RGB16 = 10;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_RGB32 = 11;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DXT1 = 12;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DXT2 = 13;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DXT3 = 14;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DXT4 = 15;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DXT5 = 16;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_BC7_UNORM = 17;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_BC7_UNORM_SRGB = 18;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM0 = 19;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM1 = 20;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM2 = 21;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM3 = 22;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_YUV = 23;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ABGR_I16 = 24;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ABGR_F16 = 25;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ABGR_F32 = 26;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ONE_I8 = 27;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ONE_I16 = 28;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ONE_F16 = 29;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_ONE_F32 = 30;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_TWO_I8 = 31;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_TWO_I16 = 32;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_TWO_F16 = 33;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_TWO_F32 = 34;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_RGB16 = 35;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_RGB32 = 36;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ALPHA_RGB32 = 37;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ABGR_I16 = 38;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ABGR_F16 = 39;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ABGR_F32 = 40;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_I8 = 41;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_I16 = 42;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_F16 = 43;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_F32 = 44;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_I8 = 45;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_I16 = 46;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_F16 = 47;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_F32 = 48;
		public const int DX_GRAPHICSIMAGE_FORMAT_3D_NUM = 49;
		public const int DX_GRAPHICSIMAGE_FORMAT_2D = 50;
		public const int DX_GRAPHICSIMAGE_FORMAT_R5G6B5 = 51;
		public const int DX_GRAPHICSIMAGE_FORMAT_X8A8R5G6B5 = 52;
		public const int DX_GRAPHICSIMAGE_FORMAT_X8R8G8B8 = 53;
		public const int DX_GRAPHICSIMAGE_FORMAT_A8R8G8B8 = 54;
		public const int DX_GRAPHICSIMAGE_FORMAT_NUM = 55;
		public const int DX_BASEIMAGE_FORMAT_NORMAL = 0;
		public const int DX_BASEIMAGE_FORMAT_DXT1 = 1;
		public const int DX_BASEIMAGE_FORMAT_DXT2 = 2;
		public const int DX_BASEIMAGE_FORMAT_DXT3 = 3;
		public const int DX_BASEIMAGE_FORMAT_DXT4 = 4;
		public const int DX_BASEIMAGE_FORMAT_DXT5 = 5;
		public const int DX_BASEIMAGE_FORMAT_BC7_UNORM = 6;
		public const int DX_BASEIMAGE_FORMAT_BC7_UNORM_SRGB = 7;
		public const int DX_BASEIMAGE_FORMAT_PLATFORM0 = 8;
		public const int DX_BASEIMAGE_FORMAT_PLATFORM1 = 9;
		public const int DX_BASEIMAGE_FORMAT_PLATFORM2 = 10;
		public const int DX_BASEIMAGE_FORMAT_PLATFORM3 = 11;
		public const int DX_BASEIMAGE_FORMAT_YUV = 12;
		public const int DX_MOVIESURFACE_NORMAL = 0;
		public const int DX_MOVIESURFACE_OVERLAY = 1;
		public const int DX_MOVIESURFACE_FULLCOLOR = 2;
		public const int DX_USER_SCREEN_PIXEL_FORMAT_R5G6B5 = 0;
		public const int DX_USER_SCREEN_PIXEL_FORMAT_R5G5B5X1 = 1;
		public const int DX_USER_SCREEN_PIXEL_FORMAT_X1R5G5B5 = 2;
		public const int DX_USER_SCREEN_PIXEL_FORMAT_X8B8G8R8 = 3;
		public const int DX_USER_SCREEN_PIXEL_FORMAT_X8R8G8B8 = 4;
		public const int DX_USER_SCREEN_PIXEL_FORMAT_NUM = 5;
		public const int DX_WIN_ZTYPE_NORMAL = 0;
		public const int DX_WIN_ZTYPE_BOTTOM = 1;
		public const int DX_WIN_ZTYPE_TOP = 2;
		public const int DX_WIN_ZTYPE_TOPMOST = 3;
		public const int TOOLBUTTON_STATE_ENABLE = 0;
		public const int TOOLBUTTON_STATE_PRESSED = 1;
		public const int TOOLBUTTON_STATE_DISABLE = 2;
		public const int TOOLBUTTON_STATE_PRESSED_DISABLE = 3;
		public const int TOOLBUTTON_STATE_NUM = 4;
		public const int TOOLBUTTON_TYPE_NORMAL = 0;
		public const int TOOLBUTTON_TYPE_CHECK = 1;
		public const int TOOLBUTTON_TYPE_GROUP = 2;
		public const int TOOLBUTTON_TYPE_SEP = 3;
		public const int TOOLBUTTON_TYPE_NUM = 4;
		public const int MENUITEM_IDTOP = -1414812757;
		public const int MENUITEM_ADD_CHILD = 0;
		public const int MENUITEM_ADD_INSERT = 1;
		public const int MENUITEM_MARK_NONE = 0;
		public const int MENUITEM_MARK_CHECK = 1;
		public const int MENUITEM_MARK_RADIO = 2;
		public const int DX_NUMMODE_10 = 0;
		public const int DX_NUMMODE_16 = 1;
		public const int DX_STRMODE_NOT0 = 2;
		public const int DX_STRMODE_USE0 = 3;
		public const int DX_CHECKINPUT_KEY = 1;
		public const int DX_CHECKINPUT_PAD = 2;
		public const int DX_CHECKINPUT_MOUSE = 4;
		public const int DX_CHECKINPUT_ALL = DX_CHECKINPUT_KEY;
		public const int DX_INPUT_KEY_PAD1 = 4097;
		public const int DX_INPUT_PAD1 = 1;
		public const int DX_INPUT_PAD2 = 2;
		public const int DX_INPUT_PAD3 = 3;
		public const int DX_INPUT_PAD4 = 4;
		public const int DX_INPUT_PAD5 = 5;
		public const int DX_INPUT_PAD6 = 6;
		public const int DX_INPUT_PAD7 = 7;
		public const int DX_INPUT_PAD8 = 8;
		public const int DX_INPUT_PAD9 = 9;
		public const int DX_INPUT_PAD10 = 10;
		public const int DX_INPUT_PAD11 = 11;
		public const int DX_INPUT_PAD12 = 12;
		public const int DX_INPUT_PAD13 = 13;
		public const int DX_INPUT_PAD14 = 14;
		public const int DX_INPUT_PAD15 = 15;
		public const int DX_INPUT_PAD16 = 16;
		public const int DX_INPUT_KEY = 4096;
		public const int DX_PADTYPE_OTHER = 0;
		public const int DX_PADTYPE_XBOX_360 = 1;
		public const int DX_PADTYPE_XBOX_ONE = 2;
		public const int DX_PADTYPE_DUAL_SHOCK_3 = 3;
		public const int DX_PADTYPE_DUAL_SHOCK_4 = 4;
		public const int DX_PADTYPE_DUAL_SENSE = 5;
		public const int DX_PADTYPE_SWITCH_JOY_CON_L = 6;
		public const int DX_PADTYPE_SWITCH_JOY_CON_R = 7;
		public const int DX_PADTYPE_SWITCH_PRO_CTRL = 8;
		public const int DX_PADTYPE_SWITCH_HORI_PAD = 9;
		public const int DX_PADTYPE_NUM = 10;
		public const int TOUCHINPUTPOINT_MAX = 16;
		public const int PAD_INPUT_DOWN = 1;
		public const int PAD_INPUT_LEFT = 2;
		public const int PAD_INPUT_RIGHT = 4;
		public const int PAD_INPUT_UP = 8;
		public const int PAD_INPUT_A = 16;
		public const int PAD_INPUT_B = 32;
		public const int PAD_INPUT_C = 64;
		public const int PAD_INPUT_X = 128;
		public const int PAD_INPUT_Y = 256;
		public const int PAD_INPUT_Z = 512;
		public const int PAD_INPUT_L = 1024;
		public const int PAD_INPUT_R = 2048;
		public const int PAD_INPUT_START = 4096;
		public const int PAD_INPUT_M = 8192;
		public const int PAD_INPUT_D = 16384;
		public const int PAD_INPUT_F = 32768;
		public const int PAD_INPUT_G = 65536;
		public const int PAD_INPUT_H = 131072;
		public const int PAD_INPUT_I = 262144;
		public const int PAD_INPUT_J = 524288;
		public const int PAD_INPUT_K = 1048576;
		public const int PAD_INPUT_LL = 2097152;
		public const int PAD_INPUT_N = 4194304;
		public const int PAD_INPUT_O = 8388608;
		public const int PAD_INPUT_P = 16777216;
		public const int PAD_INPUT_RR = 33554432;
		public const int PAD_INPUT_S = 67108864;
		public const int PAD_INPUT_T = 134217728;
		public const int PAD_INPUT_U = 268435456;
		public const int PAD_INPUT_V = 536870912;
		public const int PAD_INPUT_W = 1073741824;
		public const int PAD_INPUT_XX = -2147483648;
		public const int PAD_INPUT_1 = 16;
		public const int PAD_INPUT_2 = 32;
		public const int PAD_INPUT_3 = 64;
		public const int PAD_INPUT_4 = 128;
		public const int PAD_INPUT_5 = 256;
		public const int PAD_INPUT_6 = 512;
		public const int PAD_INPUT_7 = 1024;
		public const int PAD_INPUT_8 = 2048;
		public const int PAD_INPUT_9 = 4096;
		public const int PAD_INPUT_10 = 8192;
		public const int PAD_INPUT_11 = 16384;
		public const int PAD_INPUT_12 = 32768;
		public const int PAD_INPUT_13 = 65536;
		public const int PAD_INPUT_14 = 131072;
		public const int PAD_INPUT_15 = 262144;
		public const int PAD_INPUT_16 = 524288;
		public const int PAD_INPUT_17 = 1048576;
		public const int PAD_INPUT_18 = 2097152;
		public const int PAD_INPUT_19 = 4194304;
		public const int PAD_INPUT_20 = 8388608;
		public const int PAD_INPUT_21 = 16777216;
		public const int PAD_INPUT_22 = 33554432;
		public const int PAD_INPUT_23 = 67108864;
		public const int PAD_INPUT_24 = 134217728;
		public const int PAD_INPUT_25 = 268435456;
		public const int PAD_INPUT_26 = 536870912;
		public const int PAD_INPUT_27 = 1073741824;
		public const int PAD_INPUT_28 = -2147483648;
		public const int XINPUT_BUTTON_DPAD_UP = 0;
		public const int XINPUT_BUTTON_DPAD_DOWN = 1;
		public const int XINPUT_BUTTON_DPAD_LEFT = 2;
		public const int XINPUT_BUTTON_DPAD_RIGHT = 3;
		public const int XINPUT_BUTTON_START = 4;
		public const int XINPUT_BUTTON_BACK = 5;
		public const int XINPUT_BUTTON_LEFT_THUMB = 6;
		public const int XINPUT_BUTTON_RIGHT_THUMB = 7;
		public const int XINPUT_BUTTON_LEFT_SHOULDER = 8;
		public const int XINPUT_BUTTON_RIGHT_SHOULDER = 9;
		public const int XINPUT_BUTTON_A = 12;
		public const int XINPUT_BUTTON_B = 13;
		public const int XINPUT_BUTTON_X = 14;
		public const int XINPUT_BUTTON_Y = 15;
		public const int MOUSE_INPUT_LEFT = 1;
		public const int MOUSE_INPUT_RIGHT = 2;
		public const int MOUSE_INPUT_MIDDLE = 4;
		public const int MOUSE_INPUT_1 = 1;
		public const int MOUSE_INPUT_2 = 2;
		public const int MOUSE_INPUT_3 = 4;
		public const int MOUSE_INPUT_4 = 8;
		public const int MOUSE_INPUT_5 = 16;
		public const int MOUSE_INPUT_6 = 32;
		public const int MOUSE_INPUT_7 = 64;
		public const int MOUSE_INPUT_8 = 128;
		public const int MOUSE_INPUT_LOG_DOWN = 0;
		public const int MOUSE_INPUT_LOG_UP = 1;
		public const int KEY_INPUT_BACK = 14;
		public const int KEY_INPUT_TAB = 15;
		public const int KEY_INPUT_RETURN = 28;
		public const int KEY_INPUT_LSHIFT = 42;
		public const int KEY_INPUT_RSHIFT = 54;
		public const int KEY_INPUT_LCONTROL = 29;
		public const int KEY_INPUT_RCONTROL = 157;
		public const int KEY_INPUT_ESCAPE = 1;
		public const int KEY_INPUT_SPACE = 57;
		public const int KEY_INPUT_PGUP = 201;
		public const int KEY_INPUT_PGDN = 209;
		public const int KEY_INPUT_END = 207;
		public const int KEY_INPUT_HOME = 199;
		public const int KEY_INPUT_LEFT = 203;
		public const int KEY_INPUT_UP = 200;
		public const int KEY_INPUT_RIGHT = 205;
		public const int KEY_INPUT_DOWN = 208;
		public const int KEY_INPUT_INSERT = 210;
		public const int KEY_INPUT_DELETE = 211;
		public const int KEY_INPUT_MINUS = 12;
		public const int KEY_INPUT_YEN = 125;
		public const int KEY_INPUT_PREVTRACK = 144;
		public const int KEY_INPUT_PERIOD = 52;
		public const int KEY_INPUT_SLASH = 53;
		public const int KEY_INPUT_LALT = 56;
		public const int KEY_INPUT_RALT = 184;
		public const int KEY_INPUT_SCROLL = 70;
		public const int KEY_INPUT_SEMICOLON = 39;
		public const int KEY_INPUT_COLON = 146;
		public const int KEY_INPUT_LBRACKET = 26;
		public const int KEY_INPUT_RBRACKET = 27;
		public const int KEY_INPUT_AT = 145;
		public const int KEY_INPUT_BACKSLASH = 43;
		public const int KEY_INPUT_COMMA = 51;
		public const int KEY_INPUT_KANJI = 148;
		public const int KEY_INPUT_CONVERT = 121;
		public const int KEY_INPUT_NOCONVERT = 123;
		public const int KEY_INPUT_KANA = 112;
		public const int KEY_INPUT_APPS = 221;
		public const int KEY_INPUT_CAPSLOCK = 58;
		public const int KEY_INPUT_SYSRQ = 183;
		public const int KEY_INPUT_PAUSE = 197;
		public const int KEY_INPUT_LWIN = 219;
		public const int KEY_INPUT_RWIN = 220;
		public const int KEY_INPUT_NUMLOCK = 69;
		public const int KEY_INPUT_NUMPAD0 = 82;
		public const int KEY_INPUT_NUMPAD1 = 79;
		public const int KEY_INPUT_NUMPAD2 = 80;
		public const int KEY_INPUT_NUMPAD3 = 81;
		public const int KEY_INPUT_NUMPAD4 = 75;
		public const int KEY_INPUT_NUMPAD5 = 76;
		public const int KEY_INPUT_NUMPAD6 = 77;
		public const int KEY_INPUT_NUMPAD7 = 71;
		public const int KEY_INPUT_NUMPAD8 = 72;
		public const int KEY_INPUT_NUMPAD9 = 73;
		public const int KEY_INPUT_MULTIPLY = 55;
		public const int KEY_INPUT_ADD = 78;
		public const int KEY_INPUT_SUBTRACT = 74;
		public const int KEY_INPUT_DECIMAL = 83;
		public const int KEY_INPUT_DIVIDE = 181;
		public const int KEY_INPUT_NUMPADENTER = 156;
		public const int KEY_INPUT_F1 = 59;
		public const int KEY_INPUT_F2 = 60;
		public const int KEY_INPUT_F3 = 61;
		public const int KEY_INPUT_F4 = 62;
		public const int KEY_INPUT_F5 = 63;
		public const int KEY_INPUT_F6 = 64;
		public const int KEY_INPUT_F7 = 65;
		public const int KEY_INPUT_F8 = 66;
		public const int KEY_INPUT_F9 = 67;
		public const int KEY_INPUT_F10 = 68;
		public const int KEY_INPUT_F11 = 87;
		public const int KEY_INPUT_F12 = 88;
		public const int KEY_INPUT_A = 30;
		public const int KEY_INPUT_B = 48;
		public const int KEY_INPUT_C = 46;
		public const int KEY_INPUT_D = 32;
		public const int KEY_INPUT_E = 18;
		public const int KEY_INPUT_F = 33;
		public const int KEY_INPUT_G = 34;
		public const int KEY_INPUT_H = 35;
		public const int KEY_INPUT_I = 23;
		public const int KEY_INPUT_J = 36;
		public const int KEY_INPUT_K = 37;
		public const int KEY_INPUT_L = 38;
		public const int KEY_INPUT_M = 50;
		public const int KEY_INPUT_N = 49;
		public const int KEY_INPUT_O = 24;
		public const int KEY_INPUT_P = 25;
		public const int KEY_INPUT_Q = 16;
		public const int KEY_INPUT_R = 19;
		public const int KEY_INPUT_S = 31;
		public const int KEY_INPUT_T = 20;
		public const int KEY_INPUT_U = 22;
		public const int KEY_INPUT_V = 47;
		public const int KEY_INPUT_W = 17;
		public const int KEY_INPUT_X = 45;
		public const int KEY_INPUT_Y = 21;
		public const int KEY_INPUT_Z = 44;
		public const int KEY_INPUT_0 = 11;
		public const int KEY_INPUT_1 = 2;
		public const int KEY_INPUT_2 = 3;
		public const int KEY_INPUT_3 = 4;
		public const int KEY_INPUT_4 = 5;
		public const int KEY_INPUT_5 = 6;
		public const int KEY_INPUT_6 = 7;
		public const int KEY_INPUT_7 = 8;
		public const int KEY_INPUT_8 = 9;
		public const int KEY_INPUT_9 = 10;
		public const int CTRL_CODE_BS = 8;
		public const int CTRL_CODE_TAB = 9;
		public const int CTRL_CODE_CR = 13;
		public const int CTRL_CODE_DEL = 16;
		public const int CTRL_CODE_COPY = 3;
		public const int CTRL_CODE_PASTE = 22;
		public const int CTRL_CODE_CUT = 24;
		public const int CTRL_CODE_ALL = 1;
		public const int CTRL_CODE_LEFT = 29;
		public const int CTRL_CODE_RIGHT = 28;
		public const int CTRL_CODE_UP = 30;
		public const int CTRL_CODE_DOWN = 31;
		public const int CTRL_CODE_HOME = 26;
		public const int CTRL_CODE_END = 25;
		public const int CTRL_CODE_PAGE_UP = 23;
		public const int CTRL_CODE_PAGE_DOWN = 21;
		public const int CTRL_CODE_ESC = 27;
		public const int CTRL_CODE_CMP = 32;
		public const int DX_KEYINPSTRCOLOR_NORMAL_STR = 0;
		public const int DX_KEYINPSTRCOLOR_NORMAL_STR_EDGE = 1;
		public const int DX_KEYINPSTRCOLOR_NORMAL_CURSOR = 2;
		public const int DX_KEYINPSTRCOLOR_SELECT_STR = 3;
		public const int DX_KEYINPSTRCOLOR_SELECT_STR_EDGE = 4;
		public const int DX_KEYINPSTRCOLOR_SELECT_STR_BACK = 5;
		public const int DX_KEYINPSTRCOLOR_IME_STR = 6;
		public const int DX_KEYINPSTRCOLOR_IME_STR_EDGE = 7;
		public const int DX_KEYINPSTRCOLOR_IME_STR_BACK = 8;
		public const int DX_KEYINPSTRCOLOR_IME_CURSOR = 9;
		public const int DX_KEYINPSTRCOLOR_IME_LINE = 10;
		public const int DX_KEYINPSTRCOLOR_IME_SELECT_STR = 11;
		public const int DX_KEYINPSTRCOLOR_IME_SELECT_STR_EDGE = 12;
		public const int DX_KEYINPSTRCOLOR_IME_SELECT_STR_BACK = 13;
		public const int DX_KEYINPSTRCOLOR_IME_CONV_WIN_STR = 14;
		public const int DX_KEYINPSTRCOLOR_IME_CONV_WIN_STR_EDGE = 15;
		public const int DX_KEYINPSTRCOLOR_IME_CONV_WIN_SELECT_STR = 16;
		public const int DX_KEYINPSTRCOLOR_IME_CONV_WIN_SELECT_STR_EDGE = 17;
		public const int DX_KEYINPSTRCOLOR_IME_CONV_WIN_SELECT_STR_BACK = 18;
		public const int DX_KEYINPSTRCOLOR_IME_CONV_WIN_EDGE = 19;
		public const int DX_KEYINPSTRCOLOR_IME_CONV_WIN_BACK = 20;
		public const int DX_KEYINPSTRCOLOR_IME_MODE_STR = 21;
		public const int DX_KEYINPSTRCOLOR_IME_MODE_STR_EDGE = 22;
		public const int DX_KEYINPSTRCOLOR_NUM = 23;
		public const int DX_KEYINPSTR_ENDCHARAMODE_OVERWRITE = 0;
		public const int DX_KEYINPSTR_ENDCHARAMODE_NOTCHANGE = 1;
		public const int DX_TOUCHINPUT_TOOL_TYPE_UNKNOWN = 0;
		public const int DX_TOUCHINPUT_TOOL_TYPE_FINGER = 1;
		public const int DX_TOUCHINPUT_TOOL_TYPE_STYLUS = 2;
		public const int DX_TOUCHINPUT_TOOL_TYPE_MOUSE = 3;
		public const int DX_TOUCHINPUT_TOOL_TYPE_ERASER = 4;
		public const int DX_FSRESOLUTIONMODE_BORDERLESS_WINDOW = 0;
		public const int DX_FSRESOLUTIONMODE_DESKTOP = 1;
		public const int DX_FSRESOLUTIONMODE_NATIVE = 2;
		public const int DX_FSRESOLUTIONMODE_MAXIMUM = 3;
		public const int DX_FSSCALINGMODE_BILINEAR = 0;
		public const int DX_FSSCALINGMODE_NEAREST = 1;
		public const int DX_CHANGESCREEN_OK = 0;
		public const int DX_CHANGESCREEN_RETURN = 1;
		public const int DX_CHANGESCREEN_DEFAULT = 2;
		public const int DX_CHANGESCREEN_REFRESHNORMAL = 3;
		public const int LOADIMAGE_TYPE_FILE = 0;
		public const int LOADIMAGE_TYPE_MEM = 1;
		public const int LOADIMAGE_TYPE_NONE = 1;
		public const int HTTP_ERR_SERVER = 0;
		public const int HTTP_ERR_NOTFOUND = 1;
		public const int HTTP_ERR_MEMORY = 2;
		public const int HTTP_ERR_LOST = 3;
		public const int HTTP_ERR_NONE = 1;
		public const int HTTP_RES_COMPLETE = 0;
		public const int HTTP_RES_STOP = 1;
		public const int HTTP_RES_ERROR = 2;
		public const int HTTP_RES_NOW = 1;

		[StructLayout(LayoutKind.Explicit)]
		public struct IPDATA_IPv6
		{
			[FieldOffset(0)] public byte Byte00;
			[FieldOffset(1)] public byte Byte01;
			[FieldOffset(2)] public byte Byte02;
			[FieldOffset(3)] public byte Byte03;
			[FieldOffset(4)] public byte Byte04;
			[FieldOffset(5)] public byte Byte05;
			[FieldOffset(6)] public byte Byte06;
			[FieldOffset(7)] public byte Byte07;
			[FieldOffset(8)] public byte Byte08;
			[FieldOffset(9)] public byte Byte09;
			[FieldOffset(10)] public byte Byte10;
			[FieldOffset(11)] public byte Byte11;
			[FieldOffset(12)] public byte Byte12;
			[FieldOffset(13)] public byte Byte13;
			[FieldOffset(14)] public byte Byte14;
			[FieldOffset(15)] public byte Byte15;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct RECT
		{
			[FieldOffset(0)] public int left;
			[FieldOffset(4)] public int top;
			[FieldOffset(8)] public int right;
			[FieldOffset(12)] public int bottom;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct MATRIX
		{
			[FieldOffset(0)] public float m00;
			[FieldOffset(4)] public float m01;
			[FieldOffset(8)] public float m02;
			[FieldOffset(12)] public float m03;
			[FieldOffset(16)] public float m10;
			[FieldOffset(20)] public float m11;
			[FieldOffset(24)] public float m12;
			[FieldOffset(28)] public float m13;
			[FieldOffset(32)] public float m20;
			[FieldOffset(36)] public float m21;
			[FieldOffset(40)] public float m22;
			[FieldOffset(44)] public float m23;
			[FieldOffset(48)] public float m30;
			[FieldOffset(52)] public float m31;
			[FieldOffset(56)] public float m32;
			[FieldOffset(60)] public float m33;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct MATRIX_D
		{
			[FieldOffset(0)] public double m00;
			[FieldOffset(8)] public double m01;
			[FieldOffset(16)] public double m02;
			[FieldOffset(24)] public double m03;
			[FieldOffset(32)] public double m10;
			[FieldOffset(40)] public double m11;
			[FieldOffset(48)] public double m12;
			[FieldOffset(56)] public double m13;
			[FieldOffset(64)] public double m20;
			[FieldOffset(72)] public double m21;
			[FieldOffset(80)] public double m22;
			[FieldOffset(88)] public double m23;
			[FieldOffset(96)] public double m30;
			[FieldOffset(104)] public double m31;
			[FieldOffset(112)] public double m32;
			[FieldOffset(120)] public double m33;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct COLORDATA
		{
			[FieldOffset(0)] public byte Format ;
			[FieldOffset(1)] public byte ChannelNum ;
			[FieldOffset(2)] public byte ChannelBitDepth ;
			[FieldOffset(3)] public byte FloatTypeFlag ;
			[FieldOffset(4)] public byte PixelByte;
			[FieldOffset(5)] public byte ColorBitDepth;
			[FieldOffset(6)] public byte NoneLoc ;
			[FieldOffset(7)] public byte NoneWidth ;
			[FieldOffset(8)] public byte RedWidth ;
			[FieldOffset(9)] public byte GreenWidth ;
			[FieldOffset(10)] public byte BlueWidth ;
			[FieldOffset(11)] public byte AlphaWidth ;
			[FieldOffset(12)] public byte RedLoc ;
			[FieldOffset(13)] public byte GreenLoc ;
			[FieldOffset(14)] public byte BlueLoc ;
			[FieldOffset(15)] public byte AlphaLoc ;
			[FieldOffset(16)] public uint RedMask ;
			[FieldOffset(20)] public uint GreenMask ;
			[FieldOffset(24)] public uint BlueMask ;
			[FieldOffset(28)] public uint AlphaMask ;
			[FieldOffset(32)] public uint NoneMask ;
			[FieldOffset(36)] public int MaxPaletteNo ;
			[FieldOffset(40)] public COLORPALETTEDATA Palette0 ;
			[FieldOffset(1060)] public COLORPALETTEDATA Palette255 ;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct MV1_COLL_RESULT_POLY
		{
			[FieldOffset(0)] public int HitFlag;
			[FieldOffset(4)] public VECTOR HitPosition;
			[FieldOffset(16)] public int FrameIndex;
			[FieldOffset(20)] public int MeshIndex;
			[FieldOffset(24)] public int PolyIndex;
			[FieldOffset(28)] public int MaterialIndex;
			[FieldOffset(32)] public VECTOR Position0;
			[FieldOffset(44)] public VECTOR Position1;
			[FieldOffset(56)] public VECTOR Position2;
			[FieldOffset(68)] public VECTOR Normal;
			[FieldOffset(80)] public float PositionWeight0;
			[FieldOffset(84)] public float PositionWeight1;
			[FieldOffset(88)] public float PositionWeight2;
			[FieldOffset(92)] public int PosMaxWeightFrameIndex0;
			[FieldOffset(96)] public int PosMaxWeightFrameIndex1;
			[FieldOffset(100)] public int PosMaxWeightFrameIndex2;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct MV1_REF_POLYGON
		{
			[FieldOffset(0)] public ushort FrameIndex;
			[FieldOffset(2)] public ushort MeshIndex;
			[FieldOffset(4)] public ushort MaterialIndex;
			[FieldOffset(6)] public ushort VIndexTarget;
			[FieldOffset(8)] public int VIndex0;
			[FieldOffset(12)] public int VIndex1;
			[FieldOffset(16)] public int VIndex2;
			[FieldOffset(20)] public VECTOR MinPosition;
			[FieldOffset(32)] public VECTOR MaxPosition;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct MV1_REF_VERTEX
		{
			[FieldOffset(0)] public VECTOR Position;
			[FieldOffset(12)] public VECTOR Normal;
			[FieldOffset(24)] public FLOAT2 TexCoord0;
			[FieldOffset(32)] public FLOAT2 TexCoord1;
			[FieldOffset(40)] public COLOR_U8 DiffuseColor;
			[FieldOffset(44)] public COLOR_U8 SpecularColor;
			[FieldOffset(48)] public int MaxWeightFrameIndex;
		};

		[StructLayout(LayoutKind.Sequential)]
		public struct MV1_REF_POLYGONLIST_NT
		{
			public int PolygonNum;
			public int VertexNum;
			public VECTOR MinPosition;
			public VECTOR MaxPosition;
			public System.IntPtr Polygons;
			public System.IntPtr Vertexs;
		};

		public struct MV1_REF_POLYGONLIST
		{
			public int PolygonNum;
			public int VertexNum;
			public VECTOR MinPosition;
			public VECTOR MaxPosition;
			public MV1_REF_POLYGON[] Polygons;
			public MV1_REF_VERTEX[] Vertexs;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct DINPUT_JOYSTATE
		{
			[FieldOffset(0)] public int X;
			[FieldOffset(4)] public int Y;
			[FieldOffset(8)] public int Z;
			[FieldOffset(12)] public int Rx;
			[FieldOffset(16)] public int Ry;
			[FieldOffset(20)] public int Rz;
			[FieldOffset(24)] public int Slider0;
			[FieldOffset(28)] public int Slider1;
			[FieldOffset(32)] public uint POV0;
			[FieldOffset(36)] public uint POV1;
			[FieldOffset(40)] public uint POV2;
			[FieldOffset(44)] public uint POV3;
			[FieldOffset(48)] public byte Buttons0;
			[FieldOffset(49)] public byte Buttons1;
			[FieldOffset(50)] public byte Buttons2;
			[FieldOffset(51)] public byte Buttons3;
			[FieldOffset(52)] public byte Buttons4;
			[FieldOffset(53)] public byte Buttons5;
			[FieldOffset(54)] public byte Buttons6;
			[FieldOffset(55)] public byte Buttons7;
			[FieldOffset(56)] public byte Buttons8;
			[FieldOffset(57)] public byte Buttons9;
			[FieldOffset(58)] public byte Buttons10;
			[FieldOffset(59)] public byte Buttons11;
			[FieldOffset(60)] public byte Buttons12;
			[FieldOffset(61)] public byte Buttons13;
			[FieldOffset(62)] public byte Buttons14;
			[FieldOffset(63)] public byte Buttons15;
			[FieldOffset(64)] public byte Buttons16;
			[FieldOffset(65)] public byte Buttons17;
			[FieldOffset(66)] public byte Buttons18;
			[FieldOffset(67)] public byte Buttons19;
			[FieldOffset(68)] public byte Buttons20;
			[FieldOffset(69)] public byte Buttons21;
			[FieldOffset(70)] public byte Buttons22;
			[FieldOffset(71)] public byte Buttons23;
			[FieldOffset(72)] public byte Buttons24;
			[FieldOffset(73)] public byte Buttons25;
			[FieldOffset(74)] public byte Buttons26;
			[FieldOffset(75)] public byte Buttons27;
			[FieldOffset(76)] public byte Buttons28;
			[FieldOffset(77)] public byte Buttons29;
			[FieldOffset(78)] public byte Buttons30;
			[FieldOffset(79)] public byte Buttons31;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct XINPUT_STATE
		{
			[FieldOffset(0)] public byte Buttons0;
			[FieldOffset(1)] public byte Buttons1;
			[FieldOffset(2)] public byte Buttons2;
			[FieldOffset(3)] public byte Buttons3;
			[FieldOffset(4)] public byte Buttons4;
			[FieldOffset(5)] public byte Buttons5;
			[FieldOffset(6)] public byte Buttons6;
			[FieldOffset(7)] public byte Buttons7;
			[FieldOffset(8)] public byte Buttons8;
			[FieldOffset(9)] public byte Buttons9;
			[FieldOffset(10)] public byte Buttons10;
			[FieldOffset(11)] public byte Buttons11;
			[FieldOffset(12)] public byte Buttons12;
			[FieldOffset(13)] public byte Buttons13;
			[FieldOffset(14)] public byte Buttons14;
			[FieldOffset(15)] public byte Buttons15;
			[FieldOffset(16)] public byte LeftTrigger;
			[FieldOffset(17)] public byte RightTrigger;
			[FieldOffset(18)] public short ThumbLX;
			[FieldOffset(20)] public short ThumbLY;
			[FieldOffset(22)] public short ThumbRX;
			[FieldOffset(24)] public short ThumbRY;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct TOUCHINPUTDATA
		{
			[FieldOffset(0)] public int Time;
			[FieldOffset(4)] public int PointNum;
			[FieldOffset(8)] public TOUCHINPUTPOINT Point0;
			[FieldOffset(24)] public TOUCHINPUTPOINT Point1;
			[FieldOffset(40)] public TOUCHINPUTPOINT Point2;
			[FieldOffset(56)] public TOUCHINPUTPOINT Point3;
			[FieldOffset(72)] public TOUCHINPUTPOINT Point4;
			[FieldOffset(88)] public TOUCHINPUTPOINT Point5;
			[FieldOffset(104)] public TOUCHINPUTPOINT Point6;
			[FieldOffset(120)] public TOUCHINPUTPOINT Point7;
			[FieldOffset(136)] public TOUCHINPUTPOINT Point8;
			[FieldOffset(152)] public TOUCHINPUTPOINT Point9;
			[FieldOffset(168)] public TOUCHINPUTPOINT Point10;
			[FieldOffset(184)] public TOUCHINPUTPOINT Point11;
			[FieldOffset(200)] public TOUCHINPUTPOINT Point12;
			[FieldOffset(216)] public TOUCHINPUTPOINT Point13;
			[FieldOffset(232)] public TOUCHINPUTPOINT Point14;
			[FieldOffset(248)] public TOUCHINPUTPOINT Point15;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct IMEINPUTCLAUSEDATA
		{
			[FieldOffset(0)] public int  Position;
			[FieldOffset(4)] public int  Length;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct IMEINPUTDATA
		{
			[FieldOffset(0)] public uint  InputString;
			[FieldOffset(4)] public int  CursorPosition;
			[FieldOffset(8)] public uint  ClauseData;
			[FieldOffset(12)] public int  ClauseNum;
			[FieldOffset(16)] public int  SelectClause;
			[FieldOffset(20)] public int  CandidateNum;
			[FieldOffset(24)] public uint  CandidateList;
			[FieldOffset(28)] public int  SelectCandidate;
			[FieldOffset(32)] public int  ConvertFlag;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct DISPLAYMODEDATA
		{
			[FieldOffset(0)] public int  Width;
			[FieldOffset(4)] public int  Height;
			[FieldOffset(8)] public int  ColorBitDepth;
			[FieldOffset(12)] public int  RefreshRate;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct DATEDATA
		{
			[FieldOffset(0)] public int  Year;
			[FieldOffset(4)] public int  Mon;
			[FieldOffset(8)] public int  Day;
			[FieldOffset(12)] public int  Hour;
			[FieldOffset(16)] public int  Min;
			[FieldOffset(20)] public int  Sec;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VECTOR
		{
			[FieldOffset(0)] public float  x;
			[FieldOffset(4)] public float  y;
			[FieldOffset(8)] public float  z;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VECTOR_D
		{
			[FieldOffset(0)] public double  x;
			[FieldOffset(8)] public double  y;
			[FieldOffset(16)] public double  z;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct FLOAT2
		{
			[FieldOffset(0)] public float  u;
			[FieldOffset(4)] public float  v;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct COLOR_F
		{
			[FieldOffset(0)] public float  r;
			[FieldOffset(4)] public float  g;
			[FieldOffset(8)] public float  b;
			[FieldOffset(12)] public float  a;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct COLOR_U8
		{
			[FieldOffset(0)] public byte  b;
			[FieldOffset(1)] public byte  g;
			[FieldOffset(2)] public byte  r;
			[FieldOffset(3)] public byte  a;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct FLOAT4
		{
			[FieldOffset(0)] public float  x;
			[FieldOffset(4)] public float  y;
			[FieldOffset(8)] public float  z;
			[FieldOffset(12)] public float  w;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct DOUBLE4
		{
			[FieldOffset(0)] public double  x;
			[FieldOffset(8)] public double  y;
			[FieldOffset(16)] public double  z;
			[FieldOffset(24)] public double  w;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct INT4
		{
			[FieldOffset(0)] public int  x;
			[FieldOffset(4)] public int  y;
			[FieldOffset(8)] public int  z;
			[FieldOffset(12)] public int  w;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VERTEX2D
		{
			[FieldOffset(0)] public VECTOR  pos;
			[FieldOffset(12)] public float  rhw;
			[FieldOffset(16)] public COLOR_U8  dif;
			[FieldOffset(20)] public float  u;
			[FieldOffset(24)] public float  v;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VERTEX2DSHADER
		{
			[FieldOffset(0)] public VECTOR  pos;
			[FieldOffset(12)] public float  rhw;
			[FieldOffset(16)] public COLOR_U8  dif;
			[FieldOffset(20)] public COLOR_U8  spc;
			[FieldOffset(24)] public float  u;
			[FieldOffset(28)] public float  v;
			[FieldOffset(32)] public float  su;
			[FieldOffset(36)] public float  sv;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VERTEX
		{
			[FieldOffset(0)] public float  x;
			[FieldOffset(4)] public float  y;
			[FieldOffset(8)] public float  u;
			[FieldOffset(12)] public float  v;
			[FieldOffset(16)] public byte  b;
			[FieldOffset(17)] public byte  g;
			[FieldOffset(18)] public byte  r;
			[FieldOffset(19)] public byte  a;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VERTEX_3D
		{
			[FieldOffset(0)] public VECTOR  pos;
			[FieldOffset(12)] public byte  b;
			[FieldOffset(13)] public byte  g;
			[FieldOffset(14)] public byte  r;
			[FieldOffset(15)] public byte  a;
			[FieldOffset(16)] public float  u;
			[FieldOffset(20)] public float  v;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VERTEX3D
		{
			[FieldOffset(0)] public VECTOR  pos;
			[FieldOffset(12)] public VECTOR  norm;
			[FieldOffset(24)] public COLOR_U8  dif;
			[FieldOffset(28)] public COLOR_U8  spc;
			[FieldOffset(32)] public float  u;
			[FieldOffset(36)] public float  v;
			[FieldOffset(40)] public float  su;
			[FieldOffset(44)] public float  sv;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct VERTEX3DSHADER
		{
			[FieldOffset(0)] public VECTOR  pos;
			[FieldOffset(12)] public FLOAT4  spos;
			[FieldOffset(28)] public VECTOR  norm;
			[FieldOffset(40)] public VECTOR  tan;
			[FieldOffset(52)] public VECTOR  binorm;
			[FieldOffset(64)] public COLOR_U8  dif;
			[FieldOffset(68)] public COLOR_U8  spc;
			[FieldOffset(72)] public float  u;
			[FieldOffset(76)] public float  v;
			[FieldOffset(80)] public float  su;
			[FieldOffset(84)] public float  sv;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct LIGHTPARAM
		{
			[FieldOffset(0)] public int  LightType;
			[FieldOffset(4)] public COLOR_F  Diffuse;
			[FieldOffset(20)] public COLOR_F  Specular;
			[FieldOffset(36)] public COLOR_F  Ambient;
			[FieldOffset(52)] public VECTOR  Position;
			[FieldOffset(64)] public VECTOR  Direction;
			[FieldOffset(76)] public float  Range;
			[FieldOffset(80)] public float  Falloff;
			[FieldOffset(84)] public float  Attenuation0;
			[FieldOffset(88)] public float  Attenuation1;
			[FieldOffset(92)] public float  Attenuation2;
			[FieldOffset(96)] public float  Theta;
			[FieldOffset(100)] public float  Phi;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct MATERIALPARAM
		{
			[FieldOffset(0)] public COLOR_F  Diffuse;
			[FieldOffset(16)] public COLOR_F  Ambient;
			[FieldOffset(32)] public COLOR_F  Specular;
			[FieldOffset(48)] public COLOR_F  Emissive;
			[FieldOffset(64)] public float  Power;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct HITRESULT_LINE
		{
			[FieldOffset(0)] public int  HitFlag;
			[FieldOffset(4)] public VECTOR  Position;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct HITRESULT_LINE_D
		{
			[FieldOffset(0)] public int  HitFlag;
			[FieldOffset(4)] public VECTOR_D  Position;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct SEGMENT_SEGMENT_RESULT
		{
			[FieldOffset(0)] public float  SegA_SegB_MinDist_Square;
			[FieldOffset(4)] public float  SegA_MinDist_Pos1_Pos2_t;
			[FieldOffset(8)] public float  SegB_MinDist_Pos1_Pos2_t;
			[FieldOffset(12)] public VECTOR  SegA_MinDist_Pos;
			[FieldOffset(24)] public VECTOR  SegB_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct SEGMENT_SEGMENT_RESULT_D
		{
			[FieldOffset(0)] public double  SegA_SegB_MinDist_Square;
			[FieldOffset(8)] public double  SegA_MinDist_Pos1_Pos2_t;
			[FieldOffset(16)] public double  SegB_MinDist_Pos1_Pos2_t;
			[FieldOffset(24)] public VECTOR_D  SegA_MinDist_Pos;
			[FieldOffset(48)] public VECTOR_D  SegB_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct SEGMENT_POINT_RESULT
		{
			[FieldOffset(0)] public float  Seg_Point_MinDist_Square;
			[FieldOffset(4)] public float  Seg_MinDist_Pos1_Pos2_t;
			[FieldOffset(8)] public VECTOR  Seg_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct SEGMENT_POINT_RESULT_D
		{
			[FieldOffset(0)] public double  Seg_Point_MinDist_Square;
			[FieldOffset(8)] public double  Seg_MinDist_Pos1_Pos2_t;
			[FieldOffset(16)] public VECTOR_D  Seg_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct SEGMENT_TRIANGLE_RESULT
		{
			[FieldOffset(0)] public float  Seg_Tri_MinDist_Square;
			[FieldOffset(4)] public float  Seg_MinDist_Pos1_Pos2_t;
			[FieldOffset(8)] public VECTOR  Seg_MinDist_Pos;
			[FieldOffset(20)] public float  Tri_MinDist_Pos1_w;
			[FieldOffset(24)] public float  Tri_MinDist_Pos2_w;
			[FieldOffset(28)] public float  Tri_MinDist_Pos3_w;
			[FieldOffset(32)] public VECTOR  Tri_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct SEGMENT_TRIANGLE_RESULT_D
		{
			[FieldOffset(0)] public double  Seg_Tri_MinDist_Square;
			[FieldOffset(8)] public double  Seg_MinDist_Pos1_Pos2_t;
			[FieldOffset(16)] public VECTOR_D  Seg_MinDist_Pos;
			[FieldOffset(40)] public double  Tri_MinDist_Pos1_w;
			[FieldOffset(48)] public double  Tri_MinDist_Pos2_w;
			[FieldOffset(56)] public double  Tri_MinDist_Pos3_w;
			[FieldOffset(64)] public VECTOR_D  Tri_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct TRIANGLE_POINT_RESULT
		{
			[FieldOffset(0)] public float  Tri_Pnt_MinDist_Square;
			[FieldOffset(4)] public float  Tri_MinDist_Pos1_w;
			[FieldOffset(8)] public float  Tri_MinDist_Pos2_w;
			[FieldOffset(12)] public float  Tri_MinDist_Pos3_w;
			[FieldOffset(16)] public VECTOR  Tri_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct TRIANGLE_POINT_RESULT_D
		{
			[FieldOffset(0)] public double  Tri_Pnt_MinDist_Square;
			[FieldOffset(8)] public double  Tri_MinDist_Pos1_w;
			[FieldOffset(16)] public double  Tri_MinDist_Pos2_w;
			[FieldOffset(24)] public double  Tri_MinDist_Pos3_w;
			[FieldOffset(32)] public VECTOR_D  Tri_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct PLANE_POINT_RESULT
		{
			[FieldOffset(0)] public int  Pnt_Plane_Normal_Side;
			[FieldOffset(4)] public float  Plane_Pnt_MinDist_Square;
			[FieldOffset(8)] public VECTOR  Plane_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct PLANE_POINT_RESULT_D
		{
			[FieldOffset(0)] public int  Pnt_Plane_Normal_Side;
			[FieldOffset(4)] public double  Plane_Pnt_MinDist_Square;
			[FieldOffset(12)] public VECTOR_D  Plane_MinDist_Pos;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct MV1_COLL_RESULT_POLY_DIM
		{
			[FieldOffset(0)] public int  HitNum;
			[FieldOffset(4)] public uint  Dim;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct SOUND3D_REVERB_PARAM
		{
			[FieldOffset(0)] public float  WetDryMix;
			[FieldOffset(4)] public uint  ReflectionsDelay;
			[FieldOffset(8)] public byte  ReverbDelay;
			[FieldOffset(9)] public byte  RearDelay;
			[FieldOffset(10)] public byte  PositionLeft;
			[FieldOffset(11)] public byte  PositionRight;
			[FieldOffset(12)] public byte  PositionMatrixLeft;
			[FieldOffset(13)] public byte  PositionMatrixRight;
			[FieldOffset(14)] public byte  EarlyDiffusion;
			[FieldOffset(15)] public byte  LateDiffusion;
			[FieldOffset(16)] public byte  LowEQGain;
			[FieldOffset(17)] public byte  LowEQCutoff;
			[FieldOffset(18)] public byte  HighEQGain;
			[FieldOffset(19)] public byte  HighEQCutoff;
			[FieldOffset(20)] public float  RoomFilterFreq;
			[FieldOffset(24)] public float  RoomFilterMain;
			[FieldOffset(28)] public float  RoomFilterHF;
			[FieldOffset(32)] public float  ReflectionsGain;
			[FieldOffset(36)] public float  ReverbGain;
			[FieldOffset(40)] public float  DecayTime;
			[FieldOffset(44)] public float  Density;
			[FieldOffset(48)] public float  RoomSize;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct COLORPALETTEDATA
		{
			[FieldOffset(0)] public byte  Blue;
			[FieldOffset(1)] public byte  Green;
			[FieldOffset(2)] public byte  Red;
			[FieldOffset(3)] public byte  Alpha;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct BASEIMAGE
		{
			[FieldOffset(0)] public COLORDATA  ColorData;
			[FieldOffset(1064)] public int  Width;
			[FieldOffset(1068)] public int  Height;
			[FieldOffset(1072)] public int  Pitch;
			[FieldOffset(1076)] public uint  GraphData;
			[FieldOffset(1080)] public int  MipMapCount;
			[FieldOffset(1084)] public int  GraphDataCount;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct RECTDATA
		{
			[FieldOffset(0)] public int  x1;
			[FieldOffset(4)] public int  y1;
			[FieldOffset(8)] public int  x2;
			[FieldOffset(12)] public int  y2;
			[FieldOffset(16)] public uint  color;
			[FieldOffset(20)] public int  pal;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct LINEDATA
		{
			[FieldOffset(0)] public int  x1;
			[FieldOffset(4)] public int  y1;
			[FieldOffset(8)] public int  x2;
			[FieldOffset(12)] public int  y2;
			[FieldOffset(16)] public uint  color;
			[FieldOffset(20)] public int  pal;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct POINTDATA
		{
			[FieldOffset(0)] public int  x;
			[FieldOffset(4)] public int  y;
			[FieldOffset(8)] public uint  color;
			[FieldOffset(12)] public int  pal;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct CUBEDATA
		{
			[FieldOffset(0)] public VECTOR  Pos1;
			[FieldOffset(12)] public VECTOR  Pos2;
			[FieldOffset(24)] public COLOR_U8  DifColor;
			[FieldOffset(28)] public COLOR_U8  SpcColor;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct IMAGEFORMATDESC
		{
			[FieldOffset(0)] public byte  TextureFlag;
			[FieldOffset(1)] public byte  CubeMapTextureFlag;
			[FieldOffset(2)] public byte  AlphaChFlag;
			[FieldOffset(3)] public byte  DrawValidFlag;
			[FieldOffset(4)] public byte  SystemMemFlag;
			[FieldOffset(5)] public byte  UseManagedTextureFlag;
			[FieldOffset(6)] public byte  UseLinearMapTextureFlag;
			[FieldOffset(7)] public byte  PlatformTextureFormat;
			[FieldOffset(8)] public byte  BaseFormat;
			[FieldOffset(9)] public byte  MipMapCount;
			[FieldOffset(10)] public byte  AlphaTestFlag;
			[FieldOffset(11)] public byte  FloatTypeFlag;
			[FieldOffset(12)] public byte  ColorBitDepth;
			[FieldOffset(13)] public byte  ChannelNum;
			[FieldOffset(14)] public byte  ChannelBitDepth;
			[FieldOffset(15)] public byte  BlendGraphFlag;
			[FieldOffset(16)] public byte  UsePaletteFlag;
			[FieldOffset(17)] public byte  MSSamples;
			[FieldOffset(18)] public byte  MSQuality;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct TOUCHINPUTPOINT
		{
			[FieldOffset(0)] public uint  Device;
			[FieldOffset(4)] public uint  ID;
			[FieldOffset(8)] public int  PositionX;
			[FieldOffset(12)] public int  PositionY;
			[FieldOffset(16)] public float  Pressure;
			[FieldOffset(20)] public float  Orientation;
			[FieldOffset(24)] public float  Tilt;
			[FieldOffset(28)] public int  ToolType;
		};

		[StructLayout(LayoutKind.Explicit)]
		public struct IPDATA
		{
			[FieldOffset(0)] public byte  d1;
			[FieldOffset(1)] public byte  d2;
			[FieldOffset(2)] public byte  d3;
			[FieldOffset(3)] public byte  d4;
		};


		public static VECTOR MGetTranslateElem( MATRIX InM )
		{
			VECTOR Result ;
			Result.x = InM.m30 ;
			Result.y = InM.m31 ;
			Result.z = InM.m32 ;
			return Result ;
		}

		public static VECTOR_D MGetTranslateElemD( MATRIX_D InM )
		{
			VECTOR_D Result ;
			Result.x = InM.m30 ;
			Result.y = InM.m31 ;
			Result.z = InM.m32 ;
			return Result ;
		}

		public static VECTOR_D VConvFtoD( VECTOR In )
		{
			VECTOR_D Result ;
			Result.x = In.x ;
			Result.y = In.y ;
			Result.z = In.z ;
			return Result ;
		}

		public static VECTOR VConvDtoF( VECTOR_D In )
		{
			VECTOR Result ;
			Result.x = ( float )In.x ;
			Result.y = ( float )In.y ;
			Result.z = ( float )In.z ;
			return Result ;
		}

		public static VECTOR VGet( float x, float y, float z )
		{
			VECTOR Result ;
			Result.x = x ;
			Result.y = y ;
			Result.z = z ;
			return Result ;
		}

		public static VECTOR_D VGetD( double x, double y, double z )
		{
			VECTOR_D Result ;
			Result.x = x ;
			Result.y = y ;
			Result.z = z ;
			return Result ;
		}

		public static FLOAT2 F2Get( float u, float v )
		{
			FLOAT2 Result ;
			Result.u = u ;
			Result.v = v ;
			return Result ;
		}

		public static FLOAT4 F4Get( float x, float y, float z, float w )
		{
			FLOAT4 Result ;
			Result.x = x ;
			Result.y = y ;
			Result.z = z ;
			Result.w = w ;
			return Result ;
		}

		public static DOUBLE4 D4Get( double x, double y, double z, double w )
		{
			DOUBLE4 Result ;
			Result.x = x ;
			Result.y = y ;
			Result.z = z ;
			Result.w = w ;
			return Result ;
		}

		public static VECTOR VAdd( VECTOR In1, VECTOR In2 )
		{
			VECTOR Result ;
			Result.x = In1.x + In2.x ;
			Result.y = In1.y + In2.y ;
			Result.z = In1.z + In2.z ;
			return Result ;
		}

		public static VECTOR_D VAddD( VECTOR_D In1, VECTOR_D In2 )
		{
			VECTOR_D Result ;
			Result.x = In1.x + In2.x ;
			Result.y = In1.y + In2.y ;
			Result.z = In1.z + In2.z ;
			return Result ;
		}

		public static VECTOR VSub( VECTOR In1, VECTOR In2 )
		{
			VECTOR Result ;
			Result.x = In1.x - In2.x ;
			Result.y = In1.y - In2.y ;
			Result.z = In1.z - In2.z ;
			return Result ;
		}

		public static VECTOR_D VSubD( VECTOR_D In1, VECTOR_D In2 )
		{
			VECTOR_D Result ;
			Result.x = In1.x - In2.x ;
			Result.y = In1.y - In2.y ;
			Result.z = In1.z - In2.z ;
			return Result ;
		}

		public static FLOAT2 F2Add( FLOAT2 In1, FLOAT2 In2 )
		{
			FLOAT2 Result ;
			Result.u = In1.u + In2.u ;
			Result.v = In1.v + In2.v ;
			return Result ;
		}

		public static FLOAT4 F4Add( FLOAT4 In1, FLOAT4 In2 )
		{
			FLOAT4 Result ;
			Result.x = In1.x + In2.x ;
			Result.y = In1.y + In2.y ;
			Result.z = In1.z + In2.z ;
			Result.w = In1.w + In2.w ;
			return Result ;
		}

		public static DOUBLE4	D4Add( DOUBLE4 In1, DOUBLE4 In2 )
		{
			DOUBLE4 Result ;
			Result.x = In1.x + In2.x ;
			Result.y = In1.y + In2.y ;
			Result.z = In1.z + In2.z ;
			Result.w = In1.w + In2.w ;
			return Result ;
		}

		public static FLOAT2 F2Sub( FLOAT2 In1, FLOAT2 In2 )
		{
			FLOAT2 Result ;
			Result.u = In1.u - In2.u ;
			Result.v = In1.v - In2.v ;
			return Result ;
		}

		public static FLOAT4 F4Sub( FLOAT4 In1, FLOAT4 In2 )
		{
			FLOAT4 Result ;
			Result.x = In1.x - In2.x ;
			Result.y = In1.y - In2.y ;
			Result.z = In1.z - In2.z ;
			Result.w = In1.w - In2.w ;
			return Result ;
		}

		public static DOUBLE4	D4Sub( DOUBLE4 In1, DOUBLE4 In2 )
		{
			DOUBLE4 Result ;
			Result.x = In1.x - In2.x ;
			Result.y = In1.y - In2.y ;
			Result.z = In1.z - In2.z ;
			Result.w = In1.w - In2.w ;
			return Result ;
		}

		public static float VDot( VECTOR In1, VECTOR In2 )
		{
			return In1.x * In2.x + In1.y * In2.y + In1.z * In2.z ;
		}

		public static double VDotD( VECTOR_D In1, VECTOR_D In2 )
		{
			return In1.x * In2.x + In1.y * In2.y + In1.z * In2.z ;
		}

		public static VECTOR VCross( VECTOR In1, VECTOR In2 )
		{
			VECTOR Result ;
			Result.x = In1.y * In2.z - In1.z * In2.y ;
			Result.y = In1.z * In2.x - In1.x * In2.z ;
			Result.z = In1.x * In2.y - In1.y * In2.x ;
			return Result ;
		}

		public static VECTOR_D VCrossD( VECTOR_D In1, VECTOR_D In2 )
		{
			VECTOR_D Result ;
			Result.x = In1.y * In2.z - In1.z * In2.y ;
			Result.y = In1.z * In2.x - In1.x * In2.z ;
			Result.z = In1.x * In2.y - In1.y * In2.x ;
			return Result ;
		}

		public static VECTOR VScale( VECTOR In, float Scale )
		{
			VECTOR Result ;
			Result.x = In.x * Scale ;
			Result.y = In.y * Scale ;
			Result.z = In.z * Scale ;
			return Result ;
		}

		public static VECTOR_D VScaleD( VECTOR_D In, double Scale )
		{
			VECTOR_D Result ;
			Result.x = In.x * Scale ;
			Result.y = In.y * Scale ;
			Result.z = In.z * Scale ;
			return Result ;
		}

		public static FLOAT2 F2Scale( FLOAT2 In, float Scale )
		{
			FLOAT2 Result ;
			Result.u = In.u * Scale ;
			Result.v = In.v * Scale ;
			return Result ;
		}

		public static FLOAT4 F4Scale( FLOAT4 In, float Scale )
		{
			FLOAT4 Result ;
			Result.x = In.x * Scale ;
			Result.y = In.y * Scale ;
			Result.z = In.z * Scale ;
			Result.w = In.w * Scale ;
			return Result ;
		}

		public static DOUBLE4	D4Scale( DOUBLE4 In, double Scale )
		{
			DOUBLE4 Result ;
			Result.x = In.x * Scale ;
			Result.y = In.y * Scale ;
			Result.z = In.z * Scale ;
			Result.w = In.w * Scale ;
			return Result ;
		}

		public static float VSquareSize( VECTOR In )
		{
			return In.x * In.x + In.y * In.y + In.z * In.z ;
		}

		public static double VSquareSizeD( VECTOR_D In )
		{
			return In.x * In.x + In.y * In.y + In.z * In.z ;
		}

		public static VECTOR VTransform( VECTOR InV, MATRIX InM )
		{
			VECTOR Result ;
			Result.x = InV.x * InM.m00 + InV.y * InM.m10 + InV.z * InM.m20 + InM.m30 ;
			Result.y = InV.x * InM.m01 + InV.y * InM.m11 + InV.z * InM.m21 + InM.m31 ;
			Result.z = InV.x * InM.m02 + InV.y * InM.m12 + InV.z * InM.m22 + InM.m32 ;
			return Result ;
		}

		public static VECTOR_D VTransformD( VECTOR_D InV, MATRIX_D InM )
		{
			VECTOR_D Result ;
			Result.x = InV.x * InM.m00 + InV.y * InM.m10 + InV.z * InM.m20 + InM.m30 ;
			Result.y = InV.x * InM.m01 + InV.y * InM.m11 + InV.z * InM.m21 + InM.m31 ;
			Result.z = InV.x * InM.m02 + InV.y * InM.m12 + InV.z * InM.m22 + InM.m32 ;
			return Result ;
		}

		public static VECTOR VTransformSR( VECTOR InV, MATRIX InM )
		{
			VECTOR Result ;
			Result.x = InV.x * InM.m00 + InV.y * InM.m10 + InV.z * InM.m20 ;
			Result.y = InV.x * InM.m01 + InV.y * InM.m11 + InV.z * InM.m21 ;
			Result.z = InV.x * InM.m02 + InV.y * InM.m12 + InV.z * InM.m22 ;
			return Result ;
		}

		public static VECTOR_D VTransformSRD( VECTOR_D InV, MATRIX_D InM )
		{
			VECTOR_D Result ;
			Result.x = InV.x * InM.m00 + InV.y * InM.m10 + InV.z * InM.m20 ;
			Result.y = InV.x * InM.m01 + InV.y * InM.m11 + InV.z * InM.m21 ;
			Result.z = InV.x * InM.m02 + InV.y * InM.m12 + InV.z * InM.m22 ;
			return Result ;
		}

		public static FLOAT4 QTCross( FLOAT4 A, FLOAT4 B )
		{
			FLOAT4 Result ;
			Result.w = A.w * B.w - ( A.x * B.x + A.y * B.y + A.z * B.z ) ;
			Result.x = B.x * A.w + A.x * B.w + ( A.y * B.z - A.z * B.y ) ;
			Result.y = B.y * A.w + A.y * B.w + ( A.z * B.x - A.x * B.z ) ;
			Result.z = B.z * A.w + A.z * B.w + ( A.x * B.y - A.y * B.x ) ;
			return Result ;
		}
		public static DOUBLE4 QTCrossD( DOUBLE4 A, DOUBLE4 B )
		{
			DOUBLE4 Result ;
			Result.w = A.w * B.w - ( A.x * B.x + A.y * B.y + A.z * B.z ) ;
			Result.x = B.x * A.w + A.x * B.w + ( A.y * B.z - A.z * B.y ) ;
			Result.y = B.y * A.w + A.y * B.w + ( A.z * B.x - A.x * B.z ) ;
			Result.z = B.z * A.w + A.z * B.w + ( A.x * B.y - A.y * B.x ) ;
			return Result ;
		}
		public static FLOAT4 QTConj( FLOAT4 A )
		{
			FLOAT4 Result ;
			Result.w =  A.w ;
			Result.x = -A.x ;
			Result.y = -A.y ;
			Result.z = -A.z ;
			return Result ;
		}
		public static DOUBLE4 QTConjD( DOUBLE4 A )
		{
			DOUBLE4 Result ;
			Result.w =  A.w ;
			Result.x = -A.x ;
			Result.y = -A.y ;
			Result.z = -A.z ;
			return Result ;
		}


		[DllImport("DxLib.dll", EntryPoint = "dx_MV1GetReferenceMesh")]
		extern static MV1_REF_POLYGONLIST_NT dx_MV1GetReferenceMesh_x86(int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly);
		[DllImport("DxLib_x64.dll", EntryPoint = "dx_MV1GetReferenceMesh")]
		extern static MV1_REF_POLYGONLIST_NT dx_MV1GetReferenceMesh_x64(int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly);
		public static MV1_REF_POLYGONLIST MV1GetReferenceMeshBase(int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly)
		{
			MV1_REF_POLYGONLIST_NT Native;
			MV1_REF_POLYGONLIST Result;
			if( System.IntPtr.Size == 4 )
			{
				Native = dx_MV1GetReferenceMesh_x86( MHandle, FrameIndex, IsTransform, IsPositionOnly );
			}
			else
			{
				Native = dx_MV1GetReferenceMesh_x64( MHandle, FrameIndex, IsTransform, IsPositionOnly );
			}
			Result.PolygonNum  = Native.PolygonNum;
			Result.VertexNum   = Native.VertexNum;
			Result.MinPosition = Native.MinPosition;
			Result.MaxPosition = Native.MaxPosition;
			Result.Polygons    = null;
			Result.Vertexs     = null;
			if( Native.PolygonNum > 0 )
			{
				Result.Polygons = new MV1_REF_POLYGON[ Native.PolygonNum ];
				int MV1_REF_POLYGON_Size = Marshal.SizeOf( Result.Polygons[ 0 ] );
				long Addr = Native.Polygons.ToInt64();
				for( int i = 0; i < Native.PolygonNum; i++, Addr += MV1_REF_POLYGON_Size )
				{
					Result.Polygons[ i ] = ( MV1_REF_POLYGON )Marshal.PtrToStructure( ( System.IntPtr )Addr, typeof( MV1_REF_POLYGON ) );
				}
			}
			if( Native.VertexNum > 0 )
			{
				Result.Vertexs = new MV1_REF_VERTEX[ Native.VertexNum ];
				int MV1_REF_VERTEX_Size = Marshal.SizeOf( Result.Vertexs[ 0 ] );
				long Addr = Native.Vertexs.ToInt64();
				for( int i = 0; i < Native.VertexNum; i++, Addr += MV1_REF_VERTEX_Size )
				{
					Result.Vertexs[ i ] = ( MV1_REF_VERTEX )Marshal.PtrToStructure( ( System.IntPtr )Addr, typeof( MV1_REF_VERTEX ) );
				}
			}
			return Result;
		}
		public static MV1_REF_POLYGONLIST MV1GetReferenceMesh(int MHandle, int FrameIndex, int IsTransform)
		{
			return MV1GetReferenceMeshBase( MHandle, FrameIndex, IsTransform, FALSE );
		}
		public static MV1_REF_POLYGONLIST MV1GetReferenceMesh(int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly)
		{
			return MV1GetReferenceMeshBase( MHandle, FrameIndex, IsTransform, IsPositionOnly );
		}


#if DX_USE_UNSAFE
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		public unsafe delegate int SetActiveStateChangeCallBackFunctionCallback(int ActiveState, void* UserData);
		[DllImport("DxLibW.dll",     EntryPoint="dx_SetActiveStateChangeCallBackFunction", CharSet=CharSet.Unicode)]
		extern unsafe static int dx_SetActiveStateChangeCallBackFunction_x86(SetActiveStateChangeCallBackFunctionCallback Callback, void* UserData);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetActiveStateChangeCallBackFunction", CharSet=CharSet.Unicode)]
		extern unsafe static int dx_SetActiveStateChangeCallBackFunction_x64(SetActiveStateChangeCallBackFunctionCallback Callback, void* UserData);
		public unsafe static int SetActiveStateChangeCallBackFunction(SetActiveStateChangeCallBackFunctionCallback Callback, void* UserData)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetActiveStateChangeCallBackFunction_x86(Callback, UserData);
			}
			else
			{
				return dx_SetActiveStateChangeCallBackFunction_x64(Callback, UserData);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		public unsafe delegate void SetUseASyncChangeWindowModeFunctionCallback( void *Data );
		[DllImport("DxLibW.dll",     EntryPoint="dx_SetUseASyncChangeWindowModeFunction", CharSet=CharSet.Unicode)]
		extern unsafe static int dx_SetUseASyncChangeWindowModeFunction_x86( int Flag , SetUseASyncChangeWindowModeFunctionCallback CallBackFunction, void *Data );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseASyncChangeWindowModeFunction", CharSet=CharSet.Unicode)]
		extern unsafe static int dx_SetUseASyncChangeWindowModeFunction_x64( int Flag , SetUseASyncChangeWindowModeFunctionCallback CallBackFunction, void *Data );
		public unsafe static int SetUseASyncChangeWindowModeFunction( int Flag , SetUseASyncChangeWindowModeFunctionCallback CallBackFunction, void *Data )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseASyncChangeWindowModeFunction_x86( Flag , CallBackFunction, Data );
			}
			else
			{
				return dx_SetUseASyncChangeWindowModeFunction_x64( Flag , CallBackFunction, Data );
			}
		}
#endif
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		public delegate void SetMenuItemSelectCallBackFunctionCallback( string ItemName, int ItemID );
		[DllImport("DxLibW.dll",     EntryPoint="dx_SetMenuItemSelectCallBackFunction", CharSet=CharSet.Unicode)]
		extern static int dx_SetMenuItemSelectCallBackFunction_x86( SetMenuItemSelectCallBackFunctionCallback CallBackFunction );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetMenuItemSelectCallBackFunction", CharSet=CharSet.Unicode)]
		extern static int dx_SetMenuItemSelectCallBackFunction_x64( SetMenuItemSelectCallBackFunctionCallback CallBackFunction );
		public static int SetMenuItemSelectCallBackFunction( SetMenuItemSelectCallBackFunctionCallback CallBackFunction )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetMenuItemSelectCallBackFunction_x86( CallBackFunction );
			}
			else
			{
				return dx_SetMenuItemSelectCallBackFunction_x64( CallBackFunction );
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		public delegate void SetWindowMenuCallback( ushort ID );
		[DllImport("DxLibW.dll",     EntryPoint="dx_SetWindowMenu", CharSet=CharSet.Unicode)]
		extern static int dx_SetWindowMenu_x86( int MenuID, SetWindowMenuCallback MenuProc );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetWindowMenu", CharSet=CharSet.Unicode)]
		extern static int dx_SetWindowMenu_x64( int MenuID, SetWindowMenuCallback MenuProc );
		public static int SetWindowMenu( int MenuID, SetWindowMenuCallback MenuProc )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetWindowMenu_x86( MenuID, MenuProc );
			}
			else
			{
				return dx_SetWindowMenu_x64( MenuID, MenuProc );
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		public delegate void SetRestoreShredPointCallback();
		[DllImport("DxLibW.dll",     EntryPoint="dx_SetRestoreShredPoint", CharSet=CharSet.Unicode)]
		extern static int dx_SetRestoreShredPoint_x86( SetRestoreShredPointCallback ShredPoint );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetRestoreShredPoint", CharSet=CharSet.Unicode)]
		extern static int dx_SetRestoreShredPoint_x64( SetRestoreShredPointCallback ShredPoint );
		public static int SetRestoreShredPoint( SetRestoreShredPointCallback ShredPoint )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetRestoreShredPoint_x86( ShredPoint );
			}
			else
			{
				return dx_SetRestoreShredPoint_x64( ShredPoint );
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		public delegate void SetRestoreGraphCallbackCallback();
		[DllImport("DxLibW.dll",     EntryPoint="dx_SetRestoreGraphCallback", CharSet=CharSet.Unicode)]
		extern static int dx_SetRestoreGraphCallback_x86( SetRestoreGraphCallbackCallback Callback );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetRestoreGraphCallback", CharSet=CharSet.Unicode)]
		extern static int dx_SetRestoreGraphCallback_x64( SetRestoreGraphCallbackCallback Callback );
		public static int SetRestoreGraphCallback( SetRestoreGraphCallbackCallback Callback )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetRestoreGraphCallback_x86( Callback );
			}
			else
			{
				return dx_SetRestoreGraphCallback_x64( Callback );
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_ClearDrawScreen", CharSet=CharSet.Unicode)]
		extern static int dx_ClearDrawScreen_x86( out RECT  ClearRect);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ClearDrawScreen", CharSet=CharSet.Unicode)]
		extern static int dx_ClearDrawScreen_x64( out RECT  ClearRect);
		public static int  ClearDrawScreen( out RECT  ClearRect)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearDrawScreen_x86( out ClearRect );
			}
			else
			{
				return dx_ClearDrawScreen_x64( out ClearRect );
			}
		}
		public static int  ClearDrawScreen()
		{
			RECT temp;
		
			temp.left = -1;
			temp.top = -1;
			temp.right = -1;
			temp.bottom = -1;
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearDrawScreen_x86( out temp );
			}
			else
			{
				return dx_ClearDrawScreen_x64( out temp );
			}
		}
		
		[DllImport("DxLibW.dll",     EntryPoint="dx_ClearDrawScreenZBuffer", CharSet=CharSet.Unicode)]
		extern static int dx_ClearDrawScreenZBuffer_x86( out RECT  ClearRect);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ClearDrawScreenZBuffer", CharSet=CharSet.Unicode)]
		extern static int dx_ClearDrawScreenZBuffer_x64( out RECT  ClearRect);
		public static int  ClearDrawScreenZBuffer( out RECT  ClearRect)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearDrawScreenZBuffer_x86( out ClearRect );
			}
			else
			{
				return dx_ClearDrawScreenZBuffer_x64( out ClearRect );
			}
		}
		public static int ClearDrawScreenZBuffer()
		{
			RECT temp;
		
			temp.left = -1;
			temp.top = -1;
			temp.right = -1;
			temp.bottom = -1;
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearDrawScreenZBuffer_x86( out temp );
			}
			else
			{
				return dx_ClearDrawScreenZBuffer_x64( out temp );
			}
		}
		
		[DllImport("DxLibW.dll",     EntryPoint="dx_SetKeyInputStringColor", CharSet=CharSet.Unicode)]
		extern static int dx_SetKeyInputStringColor_x86( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE, ulong  IMESelectWinE, ulong  IMESelectWinF, ulong  SelectStrBackColor, ulong  SelectStrColor, ulong  SelectStrEdgeColor);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputStringColor", CharSet=CharSet.Unicode)]
		extern static int dx_SetKeyInputStringColor_x64( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE, ulong  IMESelectWinE, ulong  IMESelectWinF, ulong  SelectStrBackColor, ulong  SelectStrColor, ulong  SelectStrEdgeColor);
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , 0 , 0 , 0 , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , 0 , 0 , 0 , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , 0 , 0 , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , 0 , 0 , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , 0 , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , 0 , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE, ulong  IMESelectWinE)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE, ulong  IMESelectWinE, ulong  IMESelectWinF)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , 0xffffffffffffffff , 0xffffffffffffffff , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE, ulong  IMESelectWinE, ulong  IMESelectWinF, ulong  SelectStrBackColor)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , SelectStrBackColor , 0xffffffffffffffff , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , SelectStrBackColor , 0xffffffffffffffff , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE, ulong  IMESelectWinE, ulong  IMESelectWinF, ulong  SelectStrBackColor, ulong  SelectStrColor)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , SelectStrBackColor , SelectStrColor , 0xffffffffffffffff );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , SelectStrBackColor , SelectStrColor , 0xffffffffffffffff );
			}
		}
		public static int  SetKeyInputStringColor( ulong  NmlStr, ulong  NmlCur, ulong  IMEStr, ulong  IMECur, ulong  IMELine, ulong  IMESelectStr, ulong  IMEModeStr, ulong  NmlStrE, ulong  IMESelectStrE, ulong  IMEModeStrE, ulong  IMESelectWinE, ulong  IMESelectWinF, ulong  SelectStrBackColor, ulong  SelectStrColor, ulong  SelectStrEdgeColor)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor_x86( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , SelectStrBackColor , SelectStrColor , SelectStrEdgeColor );
			}
			else
			{
				return dx_SetKeyInputStringColor_x64( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , IMEModeStrE , IMESelectWinE , IMESelectWinF , SelectStrBackColor , SelectStrColor , SelectStrEdgeColor );
			}
		}


		[DllImport("DxLibW.dll",     EntryPoint="dx_Paint", CharSet=CharSet.Unicode)]
		extern static int dx_Paint_x86( int  x, int  y, uint  FillColor, ulong  BoundaryColor);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_Paint", CharSet=CharSet.Unicode)]
		extern static int dx_Paint_x64( int  x, int  y, uint  FillColor, ulong  BoundaryColor);
		public static int  Paint( int  x, int  y, uint  FillColor)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_Paint_x86( x , y , FillColor , 0xffffffffffffffffUL );
			}
			else
			{
				return dx_Paint_x64( x , y , FillColor , 0xffffffffffffffffUL );
			}
		}
		public static int  Paint( int  x, int  y, uint  FillColor, ulong  BoundaryColor)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_Paint_x86( x , y , FillColor , BoundaryColor );
			}
			else
			{
				return dx_Paint_x64( x , y , FillColor , BoundaryColor );
			}
		}


		[DllImport("DxLibW.dll",     EntryPoint="dx_MV1SetMaterialTypeParamAllS", CharSet=CharSet.Unicode)]
		extern static int dx_MV1SetMaterialTypeParamAllS_x86( int MHandle, float Param0, float Param1, float Param2, float Param3, float Param4, float Param5);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MV1SetMaterialTypeParamAllS", CharSet=CharSet.Unicode)]
		extern static int dx_MV1SetMaterialTypeParamAllS_x64( int MHandle, float Param0, float Param1, float Param2, float Param3, float Param4, float Param5);
		public static int  MV1SetMaterialTypeParamAll( int MHandle, float Param0, float Param1, float Param2, float Param3, float Param4, float Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamAllS_x86( MHandle, Param0, Param1, Param2, Param3, Param4, Param5);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamAllS_x64( MHandle, Param0, Param1, Param2, Param3, Param4, Param5);
			}
		}
		public static int  MV1SetMaterialTypeParamAll( int MHandle, float Param0, float Param1, float Param2, float Param3, float Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamAllS_x86( MHandle, Param0, Param1, Param2, Param3, Param4, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamAllS_x64( MHandle, Param0, Param1, Param2, Param3, Param4, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParamAll( int MHandle, float Param0, float Param1, float Param2, float Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamAllS_x86( MHandle, Param0, Param1, Param2, Param3, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamAllS_x64( MHandle, Param0, Param1, Param2, Param3, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParamAll( int MHandle, float Param0, float Param1, float Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamAllS_x86( MHandle, Param0, Param1, Param2, 0.0f, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamAllS_x64( MHandle, Param0, Param1, Param2, 0.0f, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParamAll( int MHandle, float Param0, float Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamAllS_x86( MHandle, Param0, Param1, 0.0f, 0.0f, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamAllS_x64( MHandle, Param0, Param1, 0.0f, 0.0f, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParamAll( int MHandle, float Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamAllS_x86( MHandle, Param0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamAllS_x64( MHandle, Param0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParamAll( int MHandle, int FilterType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamAllS_x86( MHandle, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f );
			}
			else
			{
				return dx_MV1SetMaterialTypeParamAllS_x64( MHandle, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f );
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_MV1SetMaterialTypeParamS", CharSet=CharSet.Unicode)]
		extern static int dx_MV1SetMaterialTypeParamS_x86( int MHandle, int MaterialIndex, float Param0, float Param1, float Param2, float Param3, float Param4, float Param5);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MV1SetMaterialTypeParamS", CharSet=CharSet.Unicode)]
		extern static int dx_MV1SetMaterialTypeParamS_x64( int MHandle, int MaterialIndex, float Param0, float Param1, float Param2, float Param3, float Param4, float Param5);
		public static int  MV1SetMaterialTypeParam( int MHandle, int MaterialIndex, float Param0, float Param1, float Param2, float Param3, float Param4, float Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamS_x86( MHandle, MaterialIndex, Param0, Param1, Param2, Param3, Param4, Param5);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamS_x64( MHandle, MaterialIndex, Param0, Param1, Param2, Param3, Param4, Param5);
			}
		}
		public static int  MV1SetMaterialTypeParam( int MHandle, int MaterialIndex, float Param0, float Param1, float Param2, float Param3, float Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamS_x86( MHandle, MaterialIndex, Param0, Param1, Param2, Param3, Param4, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamS_x64( MHandle, MaterialIndex, Param0, Param1, Param2, Param3, Param4, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParam( int MHandle, int MaterialIndex, float Param0, float Param1, float Param2, float Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamS_x86( MHandle, MaterialIndex, Param0, Param1, Param2, Param3, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamS_x64( MHandle, MaterialIndex, Param0, Param1, Param2, Param3, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParam( int MHandle, int MaterialIndex, float Param0, float Param1, float Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamS_x86( MHandle, MaterialIndex, Param0, Param1, Param2, 0.0f, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamS_x64( MHandle, MaterialIndex, Param0, Param1, Param2, 0.0f, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParam( int MHandle, int MaterialIndex, float Param0, float Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamS_x86( MHandle, MaterialIndex, Param0, Param1, 0.0f, 0.0f, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamS_x64( MHandle, MaterialIndex, Param0, Param1, 0.0f, 0.0f, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParam( int MHandle, int MaterialIndex, float Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamS_x86( MHandle, MaterialIndex, Param0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
			}
			else
			{
				return dx_MV1SetMaterialTypeParamS_x64( MHandle, MaterialIndex, Param0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
			}
		}
		public static int  MV1SetMaterialTypeParam( int MHandle, int MaterialIndex, int FilterType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MV1SetMaterialTypeParamS_x86( MHandle, MaterialIndex, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f );
			}
			else
			{
				return dx_MV1SetMaterialTypeParamS_x64( MHandle, MaterialIndex, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f );
			}
		}


		[DllImport("DxLibW.dll",     EntryPoint="dx_GraphFilterS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphFilterS_x86( int GrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphFilterS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphFilterS_x64( int GrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilter( int GrHandle, int FilterType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterS_x86( GrHandle, FilterType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
			else
			{
				return dx_GraphFilterS_x64( GrHandle, FilterType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_GraphFilterBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphFilterBltS_x86( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphFilterBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphFilterBltS_x64( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterBlt( int SrcGrHandle, int DestGrHandle, int FilterType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterBltS_x86( SrcGrHandle, DestGrHandle, FilterType, 0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterBltS_x64( SrcGrHandle, DestGrHandle, FilterType, 0, 0, 0, 0, 0, 0, 0, 0);
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_GraphFilterRectBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphFilterRectBltS_x86( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphFilterRectBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphFilterRectBltS_x64( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphFilterRectBlt( int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX, int DestY, int FilterType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphFilterRectBltS_x86( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, 0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphFilterRectBltS_x64( SrcGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, DestX, DestY, FilterType, 0, 0, 0, 0, 0, 0, 0, 0);
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_GraphBlendS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendS_x86( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphBlendS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendS_x64( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendS_x86( GrHandle, BlendGrHandle, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
			else
			{
				return dx_GraphBlendS_x64( GrHandle, BlendGrHandle, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_GraphBlendBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendBltS_x86( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphBlendBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendBltS_x64( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int BlendRatio, int BlendType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
			else
			{
				return dx_GraphBlendBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_GraphBlendRectBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendRectBltS_x86( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphBlendRectBltS", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendRectBltS_x64( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX, int BlendY, int DestX, int DestY, int BlendRatio, int BlendType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBltS_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
			else
			{
				return dx_GraphBlendRectBltS_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX, BlendY, DestX, DestY, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
		}

		[DllImport("DxLibW.dll",     EntryPoint="dx_GraphBlendRectBlt2S", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendRectBlt2S_x86( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphBlendRectBlt2S", CharSet=CharSet.Unicode)]
		extern static int dx_GraphBlendRectBlt2S_x64( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7);
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6, int Param7)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, Param7);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5, int Param6)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, Param6, 0);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, Param5, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, Param4, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, Param3, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, Param2, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, Param1, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, Param0, 0, 0, 0, 0, 0, 0, 0);
			}
		}
		public static int  GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio, int BlendType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphBlendRectBlt2S_x86( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
			else
			{
				return dx_GraphBlendRectBlt2S_x64( SrcGrHandle, BlendGrHandle, DestGrHandle, SrcX1, SrcY1, SrcX2, SrcY2, BlendX1, BlendY1, BlendX2, BlendY2, DestX, DestY, BlendRatio, BlendType, 0, 0, 0, 0, 0, 0, 0, 0 );
			}
		}


		[DllImport("DxLibW.dll",     EntryPoint="dx_SetBlendGraphParamS", CharSet=CharSet.Unicode)]
		extern static int dx_SetBlendGraphParamS_x86( int BlendGraph, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetBlendGraphParamS", CharSet=CharSet.Unicode)]
		extern static int dx_SetBlendGraphParamS_x64( int BlendGraph, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5);
		public static int  SetBlendGraphParam( int BlendGraph, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4, int Param5)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphParamS_x86( BlendGraph, BlendType, Param0, Param1, Param2, Param3, Param4, Param5);
			}
			else
			{
				return dx_SetBlendGraphParamS_x64( BlendGraph, BlendType, Param0, Param1, Param2, Param3, Param4, Param5);
			}
		}
		public static int  SetBlendGraphParam( int BlendGraph, int BlendType, int Param0, int Param1, int Param2, int Param3, int Param4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphParamS_x86( BlendGraph, BlendType, Param0, Param1, Param2, Param3, Param4, 0);
			}
			else
			{
				return dx_SetBlendGraphParamS_x64( BlendGraph, BlendType, Param0, Param1, Param2, Param3, Param4, 0);
			}
		}
		public static int  SetBlendGraphParam( int BlendGraph, int BlendType, int Param0, int Param1, int Param2, int Param3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphParamS_x86( BlendGraph, BlendType, Param0, Param1, Param2, Param3, 0, 0);
			}
			else
			{
				return dx_SetBlendGraphParamS_x64( BlendGraph, BlendType, Param0, Param1, Param2, Param3, 0, 0);
			}
		}
		public static int  SetBlendGraphParam( int BlendGraph, int BlendType, int Param0, int Param1, int Param2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphParamS_x86( BlendGraph, BlendType, Param0, Param1, Param2, 0, 0, 0);
			}
			else
			{
				return dx_SetBlendGraphParamS_x64( BlendGraph, BlendType, Param0, Param1, Param2, 0, 0, 0);
			}
		}
		public static int  SetBlendGraphParam( int BlendGraph, int BlendType, int Param0, int Param1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphParamS_x86( BlendGraph, BlendType, Param0, Param1, 0, 0, 0, 0);
			}
			else
			{
				return dx_SetBlendGraphParamS_x64( BlendGraph, BlendType, Param0, Param1, 0, 0, 0, 0);
			}
		}
		public static int  SetBlendGraphParam( int BlendGraph, int BlendType, int Param0)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphParamS_x86( BlendGraph, BlendType, Param0, 0, 0, 0, 0, 0);
			}
			else
			{
				return dx_SetBlendGraphParamS_x64( BlendGraph, BlendType, Param0, 0, 0, 0, 0, 0);
			}
		}
		public static int  SetBlendGraphParam( int BlendGraph, int BlendType )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphParamS_x86( BlendGraph, BlendType, 0, 0, 0, 0, 0, 0 );
			}
			else
			{
				return dx_SetBlendGraphParamS_x64( BlendGraph, BlendType, 0, 0, 0, 0, 0, 0 );
			}
		}



		[DllImport("DxLibW.dll", EntryPoint="dx_DxLib_Init", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_Init_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxLib_Init", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_Init_x64( );
		public static int  DxLib_Init( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxLib_Init_x86( );
			}
			else
			{
				return dx_DxLib_Init_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxLib_End", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_End_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxLib_End", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_End_x64( );
		public static int  DxLib_End( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxLib_End_x86( );
			}
			else
			{
				return dx_DxLib_End_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxLib_GlobalStructInitialize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_GlobalStructInitialize_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxLib_GlobalStructInitialize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_GlobalStructInitialize_x64( );
		public static int  DxLib_GlobalStructInitialize( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxLib_GlobalStructInitialize_x86( );
			}
			else
			{
				return dx_DxLib_GlobalStructInitialize_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxLib_IsInit", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_IsInit_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxLib_IsInit", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxLib_IsInit_x64( );
		public static int  DxLib_IsInit( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxLib_IsInit_x86( );
			}
			else
			{
				return dx_DxLib_IsInit_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetLastErrorCode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLastErrorCode_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetLastErrorCode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLastErrorCode_x64( );
		public static int  GetLastErrorCode( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetLastErrorCode_x86( );
			}
			else
			{
				return dx_GetLastErrorCode_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetLastErrorMessage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLastErrorMessage_x86( System.Text.StringBuilder  StringBuffer, int  StringBufferBytes);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetLastErrorMessage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLastErrorMessage_x64( System.Text.StringBuilder  StringBuffer, int  StringBufferBytes);
		public static int  GetLastErrorMessage( System.Text.StringBuilder  StringBuffer, int  StringBufferBytes)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetLastErrorMessage_x86( StringBuffer , StringBufferBytes );
			}
			else
			{
				return dx_GetLastErrorMessage_x64( StringBuffer , StringBufferBytes );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ProcessMessage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ProcessMessage_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ProcessMessage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ProcessMessage_x64( );
		public static int  ProcessMessage( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ProcessMessage_x86( );
			}
			else
			{
				return dx_ProcessMessage_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetAlwaysRunFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetAlwaysRunFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetAlwaysRunFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetAlwaysRunFlag_x64( int  Flag);
		public static int  SetAlwaysRunFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetAlwaysRunFlag_x86( Flag );
			}
			else
			{
				return dx_SetAlwaysRunFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetNotDrawFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotDrawFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetNotDrawFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotDrawFlag_x64( int  Flag);
		public static int  SetNotDrawFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetNotDrawFlag_x86( Flag );
			}
			else
			{
				return dx_SetNotDrawFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetNotSoundFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotSoundFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetNotSoundFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotSoundFlag_x64( int  Flag);
		public static int  SetNotSoundFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetNotSoundFlag_x86( Flag );
			}
			else
			{
				return dx_SetNotSoundFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetNotInputFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotInputFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetNotInputFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotInputFlag_x64( int  Flag);
		public static int  SetNotInputFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetNotInputFlag_x86( Flag );
			}
			else
			{
				return dx_SetNotInputFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_WaitTimer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitTimer_x86( int  WaitTime);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_WaitTimer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitTimer_x64( int  WaitTime);
		public static int  WaitTimer( int  WaitTime)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_WaitTimer_x86( WaitTime );
			}
			else
			{
				return dx_WaitTimer_x64( WaitTime );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_WaitKey", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitKey_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_WaitKey", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitKey_x64( );
		public static int  WaitKey( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_WaitKey_x86( );
			}
			else
			{
				return dx_WaitKey_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SleepThread", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SleepThread_x86( int  WaitTime);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SleepThread", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SleepThread_x64( int  WaitTime);
		public static int  SleepThread( int  WaitTime)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SleepThread_x86( WaitTime );
			}
			else
			{
				return dx_SleepThread_x64( WaitTime );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNowCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNowCount_x86( int  UseRDTSCFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNowCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNowCount_x64( int  UseRDTSCFlag);
		public static int  GetNowCount( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNowCount_x86( FALSE );
			}
			else
			{
				return dx_GetNowCount_x64( FALSE );
			}
		}
		public static int  GetNowCount( int  UseRDTSCFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNowCount_x86( UseRDTSCFlag );
			}
			else
			{
				return dx_GetNowCount_x64( UseRDTSCFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNowHiPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_GetNowHiPerformanceCount_x86( int  UseRDTSCFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNowHiPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_GetNowHiPerformanceCount_x64( int  UseRDTSCFlag);
		public static long  GetNowHiPerformanceCount( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNowHiPerformanceCount_x86( FALSE );
			}
			else
			{
				return dx_GetNowHiPerformanceCount_x64( FALSE );
			}
		}
		public static long  GetNowHiPerformanceCount( int  UseRDTSCFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNowHiPerformanceCount_x86( UseRDTSCFlag );
			}
			else
			{
				return dx_GetNowHiPerformanceCount_x64( UseRDTSCFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNowSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_GetNowSysPerformanceCount_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNowSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_GetNowSysPerformanceCount_x64( );
		public static ulong  GetNowSysPerformanceCount( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNowSysPerformanceCount_x86( );
			}
			else
			{
				return dx_GetNowSysPerformanceCount_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetSysPerformanceFrequency", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_GetSysPerformanceFrequency_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetSysPerformanceFrequency", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_GetSysPerformanceFrequency_x64( );
		public static ulong  GetSysPerformanceFrequency( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetSysPerformanceFrequency_x86( );
			}
			else
			{
				return dx_GetSysPerformanceFrequency_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvSysPerformanceCountToSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToSeconds_x86( ulong  Count);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvSysPerformanceCountToSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToSeconds_x64( ulong  Count);
		public static ulong  ConvSysPerformanceCountToSeconds( ulong  Count)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvSysPerformanceCountToSeconds_x86( Count );
			}
			else
			{
				return dx_ConvSysPerformanceCountToSeconds_x64( Count );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvSysPerformanceCountToMilliSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToMilliSeconds_x86( ulong  Count);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvSysPerformanceCountToMilliSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToMilliSeconds_x64( ulong  Count);
		public static ulong  ConvSysPerformanceCountToMilliSeconds( ulong  Count)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvSysPerformanceCountToMilliSeconds_x86( Count );
			}
			else
			{
				return dx_ConvSysPerformanceCountToMilliSeconds_x64( Count );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvSysPerformanceCountToMicroSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToMicroSeconds_x86( ulong  Count);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvSysPerformanceCountToMicroSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToMicroSeconds_x64( ulong  Count);
		public static ulong  ConvSysPerformanceCountToMicroSeconds( ulong  Count)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvSysPerformanceCountToMicroSeconds_x86( Count );
			}
			else
			{
				return dx_ConvSysPerformanceCountToMicroSeconds_x64( Count );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvSysPerformanceCountToNanoSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToNanoSeconds_x86( ulong  Count);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvSysPerformanceCountToNanoSeconds", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSysPerformanceCountToNanoSeconds_x64( ulong  Count);
		public static ulong  ConvSysPerformanceCountToNanoSeconds( ulong  Count)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvSysPerformanceCountToNanoSeconds_x86( Count );
			}
			else
			{
				return dx_ConvSysPerformanceCountToNanoSeconds_x64( Count );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSecondsToSysPerformanceCount_x86( ulong  Seconds);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvSecondsToSysPerformanceCount_x64( ulong  Seconds);
		public static ulong  ConvSecondsToSysPerformanceCount( ulong  Seconds)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvSecondsToSysPerformanceCount_x86( Seconds );
			}
			else
			{
				return dx_ConvSecondsToSysPerformanceCount_x64( Seconds );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvMilliSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvMilliSecondsToSysPerformanceCount_x86( ulong  MilliSeconds);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvMilliSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvMilliSecondsToSysPerformanceCount_x64( ulong  MilliSeconds);
		public static ulong  ConvMilliSecondsToSysPerformanceCount( ulong  MilliSeconds)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvMilliSecondsToSysPerformanceCount_x86( MilliSeconds );
			}
			else
			{
				return dx_ConvMilliSecondsToSysPerformanceCount_x64( MilliSeconds );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvMicroSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvMicroSecondsToSysPerformanceCount_x86( ulong  MicroSeconds);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvMicroSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvMicroSecondsToSysPerformanceCount_x64( ulong  MicroSeconds);
		public static ulong  ConvMicroSecondsToSysPerformanceCount( ulong  MicroSeconds)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvMicroSecondsToSysPerformanceCount_x86( MicroSeconds );
			}
			else
			{
				return dx_ConvMicroSecondsToSysPerformanceCount_x64( MicroSeconds );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvNanoSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvNanoSecondsToSysPerformanceCount_x86( ulong  NanoSeconds);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvNanoSecondsToSysPerformanceCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong  dx_ConvNanoSecondsToSysPerformanceCount_x64( ulong  NanoSeconds);
		public static ulong  ConvNanoSecondsToSysPerformanceCount( ulong  NanoSeconds)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvNanoSecondsToSysPerformanceCount_x86( NanoSeconds );
			}
			else
			{
				return dx_ConvNanoSecondsToSysPerformanceCount_x64( NanoSeconds );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDateTime", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDateTime_x86( out DATEDATA  DateBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDateTime", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDateTime_x64( out DATEDATA  DateBuf);
		public static int  GetDateTime( out DATEDATA  DateBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDateTime_x86( out DateBuf );
			}
			else
			{
				return dx_GetDateTime_x64( out DateBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetRand", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetRand_x86( int  RandMax);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetRand", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetRand_x64( int  RandMax);
		public static int  GetRand( int  RandMax)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetRand_x86( RandMax );
			}
			else
			{
				return dx_GetRand_x64( RandMax );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SRand", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SRand_x86( int  Seed);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SRand", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SRand_x64( int  Seed);
		public static int  SRand( int  Seed)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SRand_x86( Seed );
			}
			else
			{
				return dx_SRand_x64( Seed );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMersenneTwisterRand", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetMersenneTwisterRand_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMersenneTwisterRand", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetMersenneTwisterRand_x64( );
		public static uint  GetMersenneTwisterRand( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMersenneTwisterRand_x86( );
			}
			else
			{
				return dx_GetMersenneTwisterRand_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_CreateRandHandle_x86( int  Seed);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_CreateRandHandle_x64( int  Seed);
		public static uint  CreateRandHandle( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateRandHandle_x86( -1 );
			}
			else
			{
				return dx_CreateRandHandle_x64( -1 );
			}
		}
		public static uint  CreateRandHandle( int  Seed)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateRandHandle_x86( Seed );
			}
			else
			{
				return dx_CreateRandHandle_x64( Seed );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteRandHandle_x86( uint  RandHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteRandHandle_x64( uint  RandHandle);
		public static int  DeleteRandHandle( uint  RandHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteRandHandle_x86( RandHandle );
			}
			else
			{
				return dx_DeleteRandHandle_x64( RandHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SRandHandle_x86( uint  RandHandle, int  Seed);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SRandHandle_x64( uint  RandHandle, int  Seed);
		public static int  SRandHandle( uint  RandHandle, int  Seed)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SRandHandle_x86( RandHandle , Seed );
			}
			else
			{
				return dx_SRandHandle_x64( RandHandle , Seed );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetRandHandle_x86( uint  RandHandle, int  RandMax);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetRandHandle_x64( uint  RandHandle, int  RandMax);
		public static int  GetRandHandle( uint  RandHandle, int  RandMax)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetRandHandle_x86( RandHandle , RandMax );
			}
			else
			{
				return dx_GetRandHandle_x64( RandHandle , RandMax );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMersenneTwisterRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetMersenneTwisterRandHandle_x86( uint  RandHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMersenneTwisterRandHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetMersenneTwisterRandHandle_x64( uint  RandHandle);
		public static uint  GetMersenneTwisterRandHandle( uint  RandHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMersenneTwisterRandHandle_x86( RandHandle );
			}
			else
			{
				return dx_GetMersenneTwisterRandHandle_x64( RandHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetBatteryLifePercent", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetBatteryLifePercent_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetBatteryLifePercent", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetBatteryLifePercent_x64( );
		public static int  GetBatteryLifePercent( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetBatteryLifePercent_x86( );
			}
			else
			{
				return dx_GetBatteryLifePercent_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetClipboardText", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetClipboardText_x86( System.Text.StringBuilder  DestBuffer, int  DestBufferBytes);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetClipboardText", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetClipboardText_x64( System.Text.StringBuilder  DestBuffer, int  DestBufferBytes);
		public static int  GetClipboardText( System.Text.StringBuilder  DestBuffer)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetClipboardText_x86( DestBuffer , -1 );
			}
			else
			{
				return dx_GetClipboardText_x64( DestBuffer , -1 );
			}
		}
		public static int  GetClipboardText( System.Text.StringBuilder  DestBuffer, int  DestBufferBytes)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetClipboardText_x86( DestBuffer , DestBufferBytes );
			}
			else
			{
				return dx_GetClipboardText_x64( DestBuffer , DestBufferBytes );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetClipboardText", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetClipboardText_x86( string  Text);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetClipboardText", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetClipboardText_x64( string  Text);
		public static int  SetClipboardText( string  Text)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetClipboardText_x86( Text );
			}
			else
			{
				return dx_SetClipboardText_x64( Text );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetClipboardTextWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetClipboardTextWithStrLen_x86( string  Text, uint TextLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetClipboardTextWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetClipboardTextWithStrLen_x64( string  Text, ulong TextLength);
		public static int  SetClipboardTextWithStrLen( string  Text, ulong TextLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetClipboardTextWithStrLen_x86( Text , ( uint )TextLength );
			}
			else
			{
				return dx_SetClipboardTextWithStrLen_x64( Text , TextLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileStringDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDx_x86( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, uint ReturnedStringBufferBytes, string  IniFilePath, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileStringDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDx_x64( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, string  IniFilePath, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileStringDx( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, string  IniFilePath)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDx_x86( AppName , KeyName , Default , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFilePath , -1 );
			}
			else
			{
				return dx_GetPrivateProfileStringDx_x64( AppName , KeyName , Default , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFilePath , -1 );
			}
		}
		public static int  GetPrivateProfileStringDx( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, string  IniFilePath, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDx_x86( AppName , KeyName , Default , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFilePath , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileStringDx_x64( AppName , KeyName , Default , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFilePath , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileStringDxWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDxWithStrLen_x86( string  AppName, uint AppNameLength, string  KeyName, uint KeyNameLength, string  Default, uint DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, uint ReturnedStringBufferBytes, string  IniFilePath, uint IniFilePathLength, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileStringDxWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDxWithStrLen_x64( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, string  Default, ulong DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, string  IniFilePath, ulong IniFilePathLength, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileStringDxWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, string  Default, ulong DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, string  IniFilePath, ulong IniFilePathLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDxWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , ( uint )DefaultLength , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFilePath , ( uint )IniFilePathLength , -1 );
			}
			else
			{
				return dx_GetPrivateProfileStringDxWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , DefaultLength , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFilePath , IniFilePathLength , -1 );
			}
		}
		public static int  GetPrivateProfileStringDxWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, string  Default, ulong DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, string  IniFilePath, ulong IniFilePathLength, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDxWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , ( uint )DefaultLength , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFilePath , ( uint )IniFilePathLength , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileStringDxWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , DefaultLength , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFilePath , IniFilePathLength , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileIntDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDx_x86( string  AppName, string  KeyName, int  Default, string  IniFilePath, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileIntDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDx_x64( string  AppName, string  KeyName, int  Default, string  IniFilePath, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileIntDx( string  AppName, string  KeyName, int  Default, string  IniFilePath)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDx_x86( AppName , KeyName , Default , IniFilePath , -1 );
			}
			else
			{
				return dx_GetPrivateProfileIntDx_x64( AppName , KeyName , Default , IniFilePath , -1 );
			}
		}
		public static int  GetPrivateProfileIntDx( string  AppName, string  KeyName, int  Default, string  IniFilePath, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDx_x86( AppName , KeyName , Default , IniFilePath , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileIntDx_x64( AppName , KeyName , Default , IniFilePath , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileIntDxWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDxWithStrLen_x86( string  AppName, uint AppNameLength, string  KeyName, uint KeyNameLength, int  Default, string  IniFilePath, uint IniFilePathLength, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileIntDxWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDxWithStrLen_x64( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, int  Default, string  IniFilePath, ulong IniFilePathLength, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileIntDxWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, int  Default, string  IniFilePath, ulong IniFilePathLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDxWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , IniFilePath , ( uint )IniFilePathLength , -1 );
			}
			else
			{
				return dx_GetPrivateProfileIntDxWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , IniFilePath , IniFilePathLength , -1 );
			}
		}
		public static int  GetPrivateProfileIntDxWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, int  Default, string  IniFilePath, ulong IniFilePathLength, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDxWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , IniFilePath , ( uint )IniFilePathLength , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileIntDxWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , IniFilePath , IniFilePathLength , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileStringDxForMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDxForMem_x86( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, uint ReturnedStringBufferBytes, System.IntPtr  IniFileImage, uint IniFileImageBytes, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileStringDxForMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDxForMem_x64( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileStringDxForMem( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, System.IntPtr  IniFileImage, ulong IniFileImageBytes)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDxForMem_x86( AppName , KeyName , Default , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFileImage , ( uint )IniFileImageBytes , -1 );
			}
			else
			{
				return dx_GetPrivateProfileStringDxForMem_x64( AppName , KeyName , Default , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFileImage , IniFileImageBytes , -1 );
			}
		}
		public static int  GetPrivateProfileStringDxForMem( string  AppName, string  KeyName, string  Default, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDxForMem_x86( AppName , KeyName , Default , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFileImage , ( uint )IniFileImageBytes , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileStringDxForMem_x64( AppName , KeyName , Default , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFileImage , IniFileImageBytes , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileStringDxForMemWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDxForMemWithStrLen_x86( string  AppName, uint AppNameLength, string  KeyName, uint KeyNameLength, string  Default, uint DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, uint ReturnedStringBufferBytes, System.IntPtr  IniFileImage, uint IniFileImageBytes, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileStringDxForMemWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileStringDxForMemWithStrLen_x64( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, string  Default, ulong DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileStringDxForMemWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, string  Default, ulong DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, System.IntPtr  IniFileImage, ulong IniFileImageBytes)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDxForMemWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , ( uint )DefaultLength , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFileImage , ( uint )IniFileImageBytes , -1 );
			}
			else
			{
				return dx_GetPrivateProfileStringDxForMemWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , DefaultLength , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFileImage , IniFileImageBytes , -1 );
			}
		}
		public static int  GetPrivateProfileStringDxForMemWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, string  Default, ulong DefaultLength, System.Text.StringBuilder  ReturnedStringBuffer, ulong ReturnedStringBufferBytes, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileStringDxForMemWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , ( uint )DefaultLength , ReturnedStringBuffer , ( uint )ReturnedStringBufferBytes , IniFileImage , ( uint )IniFileImageBytes , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileStringDxForMemWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , DefaultLength , ReturnedStringBuffer , ReturnedStringBufferBytes , IniFileImage , IniFileImageBytes , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileIntDxForMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDxForMem_x86( string  AppName, string  KeyName, int  Default, System.IntPtr  IniFileImage, uint IniFileImageBytes, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileIntDxForMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDxForMem_x64( string  AppName, string  KeyName, int  Default, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileIntDxForMem( string  AppName, string  KeyName, int  Default, System.IntPtr  IniFileImage, ulong IniFileImageBytes)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDxForMem_x86( AppName , KeyName , Default , IniFileImage , ( uint )IniFileImageBytes , -1 );
			}
			else
			{
				return dx_GetPrivateProfileIntDxForMem_x64( AppName , KeyName , Default , IniFileImage , IniFileImageBytes , -1 );
			}
		}
		public static int  GetPrivateProfileIntDxForMem( string  AppName, string  KeyName, int  Default, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDxForMem_x86( AppName , KeyName , Default , IniFileImage , ( uint )IniFileImageBytes , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileIntDxForMem_x64( AppName , KeyName , Default , IniFileImage , IniFileImageBytes , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPrivateProfileIntDxForMemWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDxForMemWithStrLen_x86( string  AppName, uint AppNameLength, string  KeyName, uint KeyNameLength, int  Default, System.IntPtr  IniFileImage, uint IniFileImageBytes, int  IniFileCharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPrivateProfileIntDxForMemWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetPrivateProfileIntDxForMemWithStrLen_x64( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, int  Default, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat);
		public static int  GetPrivateProfileIntDxForMemWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, int  Default, System.IntPtr  IniFileImage, ulong IniFileImageBytes)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDxForMemWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , IniFileImage , ( uint )IniFileImageBytes , -1 );
			}
			else
			{
				return dx_GetPrivateProfileIntDxForMemWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , IniFileImage , IniFileImageBytes , -1 );
			}
		}
		public static int  GetPrivateProfileIntDxForMemWithStrLen( string  AppName, ulong AppNameLength, string  KeyName, ulong KeyNameLength, int  Default, System.IntPtr  IniFileImage, ulong IniFileImageBytes, int  IniFileCharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPrivateProfileIntDxForMemWithStrLen_x86( AppName , ( uint )AppNameLength , KeyName , ( uint )KeyNameLength , Default , IniFileImage , ( uint )IniFileImageBytes , IniFileCharCodeFormat );
			}
			else
			{
				return dx_GetPrivateProfileIntDxForMemWithStrLen_x64( AppName , AppNameLength , KeyName , KeyNameLength , Default , IniFileImage , IniFileImageBytes , IniFileCharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LogFileAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileAdd_x86( string  String);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LogFileAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileAdd_x64( string  String);
		public static int  LogFileAdd( string  String)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LogFileAdd_x86( String );
			}
			else
			{
				return dx_LogFileAdd_x64( String );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LogFileAddWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileAddWithStrLen_x86( string  String, uint StringLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LogFileAddWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileAddWithStrLen_x64( string  String, ulong StringLength);
		public static int  LogFileAddWithStrLen( string  String, ulong StringLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LogFileAddWithStrLen_x86( String , ( uint )StringLength );
			}
			else
			{
				return dx_LogFileAddWithStrLen_x64( String , StringLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LogFileTabAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileTabAdd_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LogFileTabAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileTabAdd_x64( );
		public static int  LogFileTabAdd( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LogFileTabAdd_x86( );
			}
			else
			{
				return dx_LogFileTabAdd_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LogFileTabSub", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileTabSub_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LogFileTabSub", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LogFileTabSub_x64( );
		public static int  LogFileTabSub( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LogFileTabSub_x86( );
			}
			else
			{
				return dx_LogFileTabSub_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ErrorLogAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ErrorLogAdd_x86( string  String);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ErrorLogAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ErrorLogAdd_x64( string  String);
		public static int  ErrorLogAdd( string  String)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ErrorLogAdd_x86( String );
			}
			else
			{
				return dx_ErrorLogAdd_x64( String );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ErrorLogTabAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ErrorLogTabAdd_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ErrorLogTabAdd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ErrorLogTabAdd_x64( );
		public static int  ErrorLogTabAdd( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ErrorLogTabAdd_x86( );
			}
			else
			{
				return dx_ErrorLogTabAdd_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ErrorLogTabSub", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ErrorLogTabSub_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ErrorLogTabSub", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ErrorLogTabSub_x64( );
		public static int  ErrorLogTabSub( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ErrorLogTabSub_x86( );
			}
			else
			{
				return dx_ErrorLogTabSub_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseTimeStampFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTimeStampFlag_x86( int  UseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseTimeStampFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTimeStampFlag_x64( int  UseFlag);
		public static int  SetUseTimeStampFlag( int  UseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseTimeStampFlag_x86( UseFlag );
			}
			else
			{
				return dx_SetUseTimeStampFlag_x64( UseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetOutApplicationLogValidFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetOutApplicationLogValidFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetOutApplicationLogValidFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetOutApplicationLogValidFlag_x64( int  Flag);
		public static int  SetOutApplicationLogValidFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetOutApplicationLogValidFlag_x86( Flag );
			}
			else
			{
				return dx_SetOutApplicationLogValidFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetOutApplicationSystemLogValidFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetOutApplicationSystemLogValidFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetOutApplicationSystemLogValidFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetOutApplicationSystemLogValidFlag_x64( int  Flag);
		public static int  SetOutApplicationSystemLogValidFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetOutApplicationSystemLogValidFlag_x86( Flag );
			}
			else
			{
				return dx_SetOutApplicationSystemLogValidFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetApplicationLogFileName", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogFileName_x86( string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetApplicationLogFileName", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogFileName_x64( string  FileName);
		public static int  SetApplicationLogFileName( string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetApplicationLogFileName_x86( FileName );
			}
			else
			{
				return dx_SetApplicationLogFileName_x64( FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetApplicationLogFileNameWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogFileNameWithStrLen_x86( string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetApplicationLogFileNameWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogFileNameWithStrLen_x64( string  FileName, ulong FileNameLength);
		public static int  SetApplicationLogFileNameWithStrLen( string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetApplicationLogFileNameWithStrLen_x86( FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_SetApplicationLogFileNameWithStrLen_x64( FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetApplicationLogSaveDirectory", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogSaveDirectory_x86( string  DirectoryPath);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetApplicationLogSaveDirectory", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogSaveDirectory_x64( string  DirectoryPath);
		public static int  SetApplicationLogSaveDirectory( string  DirectoryPath)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetApplicationLogSaveDirectory_x86( DirectoryPath );
			}
			else
			{
				return dx_SetApplicationLogSaveDirectory_x64( DirectoryPath );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetApplicationLogSaveDirectoryWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogSaveDirectoryWithStrLen_x86( string  DirectoryPath, uint DirectoryPathLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetApplicationLogSaveDirectoryWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetApplicationLogSaveDirectoryWithStrLen_x64( string  DirectoryPath, ulong DirectoryPathLength);
		public static int  SetApplicationLogSaveDirectoryWithStrLen( string  DirectoryPath, ulong DirectoryPathLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetApplicationLogSaveDirectoryWithStrLen_x86( DirectoryPath , ( uint )DirectoryPathLength );
			}
			else
			{
				return dx_SetApplicationLogSaveDirectoryWithStrLen_x64( DirectoryPath , DirectoryPathLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseDateNameLogFile", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDateNameLogFile_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseDateNameLogFile", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDateNameLogFile_x64( int  Flag);
		public static int  SetUseDateNameLogFile( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseDateNameLogFile_x86( Flag );
			}
			else
			{
				return dx_SetUseDateNameLogFile_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetLogDrawOutFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogDrawOutFlag_x86( int  DrawFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetLogDrawOutFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogDrawOutFlag_x64( int  DrawFlag);
		public static int  SetLogDrawOutFlag( int  DrawFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetLogDrawOutFlag_x86( DrawFlag );
			}
			else
			{
				return dx_SetLogDrawOutFlag_x64( DrawFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetLogDrawFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLogDrawFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetLogDrawFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLogDrawFlag_x64( );
		public static int  GetLogDrawFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetLogDrawFlag_x86( );
			}
			else
			{
				return dx_GetLogDrawFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetLogFontSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogFontSize_x86( int  Size);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetLogFontSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogFontSize_x64( int  Size);
		public static int  SetLogFontSize( int  Size)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetLogFontSize_x86( Size );
			}
			else
			{
				return dx_SetLogFontSize_x64( Size );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetLogFontHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogFontHandle_x86( int  FontHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetLogFontHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogFontHandle_x64( int  FontHandle);
		public static int  SetLogFontHandle( int  FontHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetLogFontHandle_x86( FontHandle );
			}
			else
			{
				return dx_SetLogFontHandle_x64( FontHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetLogDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogDrawArea_x86( int  x1, int  y1, int  x2, int  y2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetLogDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLogDrawArea_x64( int  x1, int  y1, int  x2, int  y2);
		public static int  SetLogDrawArea( int  x1, int  y1, int  x2, int  y2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetLogDrawArea_x86( x1 , y1 , x2 , y2 );
			}
			else
			{
				return dx_SetLogDrawArea_x64( x1 , y1 , x2 , y2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_putsDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_putsDx_x86( string  String, int  NewLine);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_putsDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_putsDx_x64( string  String, int  NewLine);
		public static int  putsDx( string  String)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_putsDx_x86( String , TRUE );
			}
			else
			{
				return dx_putsDx_x64( String , TRUE );
			}
		}
		public static int  putsDx( string  String, int  NewLine)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_putsDx_x86( String , NewLine );
			}
			else
			{
				return dx_putsDx_x64( String , NewLine );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_putsDxWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_putsDxWithStrLen_x86( string  String, uint StringLength, int  NewLine);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_putsDxWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_putsDxWithStrLen_x64( string  String, ulong StringLength, int  NewLine);
		public static int  putsDxWithStrLen( string  String, ulong StringLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_putsDxWithStrLen_x86( String , ( uint )StringLength , TRUE );
			}
			else
			{
				return dx_putsDxWithStrLen_x64( String , StringLength , TRUE );
			}
		}
		public static int  putsDxWithStrLen( string  String, ulong StringLength, int  NewLine)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_putsDxWithStrLen_x86( String , ( uint )StringLength , NewLine );
			}
			else
			{
				return dx_putsDxWithStrLen_x64( String , StringLength , NewLine );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_clsDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_clsDx_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_clsDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_clsDx_x64( );
		public static int  clsDx( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_clsDx_x86( );
			}
			else
			{
				return dx_clsDx_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_setPrintColorDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_setPrintColorDx_x86( int  Color, int  EdgeColor);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_setPrintColorDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_setPrintColorDx_x64( int  Color, int  EdgeColor);
		public static int  setPrintColorDx( int  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_setPrintColorDx_x86( Color , 0 );
			}
			else
			{
				return dx_setPrintColorDx_x64( Color , 0 );
			}
		}
		public static int  setPrintColorDx( int  Color, int  EdgeColor)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_setPrintColorDx_x86( Color , EdgeColor );
			}
			else
			{
				return dx_setPrintColorDx_x64( Color , EdgeColor );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseASyncLoadFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseASyncLoadFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseASyncLoadFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseASyncLoadFlag_x64( int  Flag);
		public static int  SetUseASyncLoadFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseASyncLoadFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseASyncLoadFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseASyncLoadFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseASyncLoadFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseASyncLoadFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseASyncLoadFlag_x64( );
		public static int  GetUseASyncLoadFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseASyncLoadFlag_x86( );
			}
			else
			{
				return dx_GetUseASyncLoadFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckHandleASyncLoad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckHandleASyncLoad_x86( int  Handle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckHandleASyncLoad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckHandleASyncLoad_x64( int  Handle);
		public static int  CheckHandleASyncLoad( int  Handle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckHandleASyncLoad_x86( Handle );
			}
			else
			{
				return dx_CheckHandleASyncLoad_x64( Handle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetHandleASyncLoadResult", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHandleASyncLoadResult_x86( int  Handle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHandleASyncLoadResult", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHandleASyncLoadResult_x64( int  Handle);
		public static int  GetHandleASyncLoadResult( int  Handle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHandleASyncLoadResult_x86( Handle );
			}
			else
			{
				return dx_GetHandleASyncLoadResult_x64( Handle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetASyncLoadFinishDeleteFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetASyncLoadFinishDeleteFlag_x86( int  Handle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetASyncLoadFinishDeleteFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetASyncLoadFinishDeleteFlag_x64( int  Handle);
		public static int  SetASyncLoadFinishDeleteFlag( int  Handle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetASyncLoadFinishDeleteFlag_x86( Handle );
			}
			else
			{
				return dx_SetASyncLoadFinishDeleteFlag_x64( Handle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_WaitHandleASyncLoad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitHandleASyncLoad_x86( int  Handle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_WaitHandleASyncLoad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitHandleASyncLoad_x64( int  Handle);
		public static int  WaitHandleASyncLoad( int  Handle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_WaitHandleASyncLoad_x86( Handle );
			}
			else
			{
				return dx_WaitHandleASyncLoad_x64( Handle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_WaitHandleASyncLoadAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitHandleASyncLoadAll_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_WaitHandleASyncLoadAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitHandleASyncLoadAll_x64( );
		public static int  WaitHandleASyncLoadAll( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_WaitHandleASyncLoadAll_x86( );
			}
			else
			{
				return dx_WaitHandleASyncLoadAll_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetASyncLoadNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetASyncLoadNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetASyncLoadNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetASyncLoadNum_x64( );
		public static int  GetASyncLoadNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetASyncLoadNum_x86( );
			}
			else
			{
				return dx_GetASyncLoadNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetASyncLoadThreadNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetASyncLoadThreadNum_x86( int  ThreadNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetASyncLoadThreadNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetASyncLoadThreadNum_x64( int  ThreadNum);
		public static int  SetASyncLoadThreadNum( int  ThreadNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetASyncLoadThreadNum_x86( ThreadNum );
			}
			else
			{
				return dx_SetASyncLoadThreadNum_x64( ThreadNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDeleteHandleFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDeleteHandleFlag_x86( int  Handle, out int  DeleteFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDeleteHandleFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDeleteHandleFlag_x64( int  Handle, out int  DeleteFlag);
		public static int  SetDeleteHandleFlag( int  Handle, out int  DeleteFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDeleteHandleFlag_x86( Handle , out DeleteFlag );
			}
			else
			{
				return dx_SetDeleteHandleFlag_x64( Handle , out DeleteFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetHandleNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHandleNum_x86( int  HandleType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHandleNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHandleNum_x64( int  HandleType);
		public static int  GetHandleNum( int  HandleType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHandleNum_x86( HandleType );
			}
			else
			{
				return dx_GetHandleNum_x64( HandleType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMaxHandleNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxHandleNum_x86( int  HandleType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMaxHandleNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxHandleNum_x64( int  HandleType);
		public static int  GetMaxHandleNum( int  HandleType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMaxHandleNum_x86( HandleType );
			}
			else
			{
				return dx_GetMaxHandleNum_x64( HandleType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DumpHandleInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DumpHandleInfo_x86( int  HandleType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DumpHandleInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DumpHandleInfo_x64( int  HandleType);
		public static int  DumpHandleInfo( int  HandleType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DumpHandleInfo_x86( HandleType );
			}
			else
			{
				return dx_DumpHandleInfo_x64( HandleType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetMouseDispFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMouseDispFlag_x86( int  DispFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetMouseDispFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMouseDispFlag_x64( int  DispFlag);
		public static int  SetMouseDispFlag( int  DispFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetMouseDispFlag_x86( DispFlag );
			}
			else
			{
				return dx_SetMouseDispFlag_x64( DispFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetMouseDispIgnoreMenuFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMouseDispIgnoreMenuFlag_x86( int  IgnoreMenuFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetMouseDispIgnoreMenuFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMouseDispIgnoreMenuFlag_x64( int  IgnoreMenuFlag);
		public static int  SetMouseDispIgnoreMenuFlag( int  IgnoreMenuFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetMouseDispIgnoreMenuFlag_x86( IgnoreMenuFlag );
			}
			else
			{
				return dx_SetMouseDispIgnoreMenuFlag_x64( IgnoreMenuFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMousePoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMousePoint_x86( out int  XBuf, out int  YBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMousePoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMousePoint_x64( out int  XBuf, out int  YBuf);
		public static int  GetMousePoint( out int  XBuf, out int  YBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMousePoint_x86( out XBuf , out YBuf );
			}
			else
			{
				return dx_GetMousePoint_x64( out XBuf , out YBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetMousePoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMousePoint_x86( int  PointX, int  PointY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetMousePoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMousePoint_x64( int  PointX, int  PointY);
		public static int  SetMousePoint( int  PointX, int  PointY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetMousePoint_x86( PointX , PointY );
			}
			else
			{
				return dx_SetMousePoint_x64( PointX , PointY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMouseInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseInput_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMouseInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseInput_x64( );
		public static int  GetMouseInput( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseInput_x86( );
			}
			else
			{
				return dx_GetMouseInput_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMouseWheelRotVol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseWheelRotVol_x86( int  CounterReset);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMouseWheelRotVol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseWheelRotVol_x64( int  CounterReset);
		public static int  GetMouseWheelRotVol( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseWheelRotVol_x86( TRUE );
			}
			else
			{
				return dx_GetMouseWheelRotVol_x64( TRUE );
			}
		}
		public static int  GetMouseWheelRotVol( int  CounterReset)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseWheelRotVol_x86( CounterReset );
			}
			else
			{
				return dx_GetMouseWheelRotVol_x64( CounterReset );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMouseHWheelRotVol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseHWheelRotVol_x86( int  CounterReset);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMouseHWheelRotVol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseHWheelRotVol_x64( int  CounterReset);
		public static int  GetMouseHWheelRotVol( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseHWheelRotVol_x86( TRUE );
			}
			else
			{
				return dx_GetMouseHWheelRotVol_x64( TRUE );
			}
		}
		public static int  GetMouseHWheelRotVol( int  CounterReset)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseHWheelRotVol_x86( CounterReset );
			}
			else
			{
				return dx_GetMouseHWheelRotVol_x64( CounterReset );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMouseWheelRotVolF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetMouseWheelRotVolF_x86( int  CounterReset);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMouseWheelRotVolF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetMouseWheelRotVolF_x64( int  CounterReset);
		public static float  GetMouseWheelRotVolF( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseWheelRotVolF_x86( TRUE );
			}
			else
			{
				return dx_GetMouseWheelRotVolF_x64( TRUE );
			}
		}
		public static float  GetMouseWheelRotVolF( int  CounterReset)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseWheelRotVolF_x86( CounterReset );
			}
			else
			{
				return dx_GetMouseWheelRotVolF_x64( CounterReset );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMouseHWheelRotVolF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetMouseHWheelRotVolF_x86( int  CounterReset);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMouseHWheelRotVolF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetMouseHWheelRotVolF_x64( int  CounterReset);
		public static float  GetMouseHWheelRotVolF( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseHWheelRotVolF_x86( TRUE );
			}
			else
			{
				return dx_GetMouseHWheelRotVolF_x64( TRUE );
			}
		}
		public static float  GetMouseHWheelRotVolF( int  CounterReset)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseHWheelRotVolF_x86( CounterReset );
			}
			else
			{
				return dx_GetMouseHWheelRotVolF_x64( CounterReset );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMouseInputLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseInputLog_x86( out int  Button, out int  ClickX, out int  ClickY, int  LogDelete);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMouseInputLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseInputLog_x64( out int  Button, out int  ClickX, out int  ClickY, int  LogDelete);
		public static int  GetMouseInputLog( out int  Button, out int  ClickX, out int  ClickY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseInputLog_x86( out Button , out ClickX , out ClickY , TRUE );
			}
			else
			{
				return dx_GetMouseInputLog_x64( out Button , out ClickX , out ClickY , TRUE );
			}
		}
		public static int  GetMouseInputLog( out int  Button, out int  ClickX, out int  ClickY, int  LogDelete)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseInputLog_x86( out Button , out ClickX , out ClickY , LogDelete );
			}
			else
			{
				return dx_GetMouseInputLog_x64( out Button , out ClickX , out ClickY , LogDelete );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMouseInputLog2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseInputLog2_x86( out int  Button, out int  ClickX, out int  ClickY, out int  LogType, int  LogDelete);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMouseInputLog2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMouseInputLog2_x64( out int  Button, out int  ClickX, out int  ClickY, out int  LogType, int  LogDelete);
		public static int  GetMouseInputLog2( out int  Button, out int  ClickX, out int  ClickY, out int  LogType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseInputLog2_x86( out Button , out ClickX , out ClickY , out LogType , TRUE );
			}
			else
			{
				return dx_GetMouseInputLog2_x64( out Button , out ClickX , out ClickY , out LogType , TRUE );
			}
		}
		public static int  GetMouseInputLog2( out int  Button, out int  ClickX, out int  ClickY, out int  LogType, int  LogDelete)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMouseInputLog2_x86( out Button , out ClickX , out ClickY , out LogType , LogDelete );
			}
			else
			{
				return dx_GetMouseInputLog2_x64( out Button , out ClickX , out ClickY , out LogType , LogDelete );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInputNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInputNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputNum_x64( );
		public static int  GetTouchInputNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputNum_x86( );
			}
			else
			{
				return dx_GetTouchInputNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInput_x86( int  InputNo, out int  PositionX, out int  PositionY, out int  ID, out int  Device, out float  Pressure);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInput_x64( int  InputNo, out int  PositionX, out int  PositionY, out int  ID, out int  Device, out float  Pressure);
		public static int  GetTouchInput( int  InputNo, out int  PositionX, out int  PositionY, out int  ID, out int  Device, out float  Pressure)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInput_x86( InputNo , out PositionX , out PositionY , out ID , out Device , out Pressure );
			}
			else
			{
				return dx_GetTouchInput_x64( InputNo , out PositionX , out PositionY , out ID , out Device , out Pressure );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInputLogNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputLogNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInputLogNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputLogNum_x64( );
		public static int  GetTouchInputLogNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputLogNum_x86( );
			}
			else
			{
				return dx_GetTouchInputLogNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ClearTouchInputLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearTouchInputLog_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ClearTouchInputLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearTouchInputLog_x64( );
		public static int  ClearTouchInputLog( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearTouchInputLog_x86( );
			}
			else
			{
				return dx_ClearTouchInputLog_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInputLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputLog_x86( out TOUCHINPUTDATA  TouchData, int  GetNum, int  PeekFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInputLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputLog_x64( out TOUCHINPUTDATA  TouchData, int  GetNum, int  PeekFlag);
		public static int  GetTouchInputLog( out TOUCHINPUTDATA  TouchData, int  GetNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputLog_x86( out TouchData , GetNum , FALSE );
			}
			else
			{
				return dx_GetTouchInputLog_x64( out TouchData , GetNum , FALSE );
			}
		}
		public static int  GetTouchInputLog( out TOUCHINPUTDATA  TouchData, int  GetNum, int  PeekFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputLog_x86( out TouchData , GetNum , PeekFlag );
			}
			else
			{
				return dx_GetTouchInputLog_x64( out TouchData , GetNum , PeekFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInputDownLogNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputDownLogNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInputDownLogNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputDownLogNum_x64( );
		public static int  GetTouchInputDownLogNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputDownLogNum_x86( );
			}
			else
			{
				return dx_GetTouchInputDownLogNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ClearTouchInputDownLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearTouchInputDownLog_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ClearTouchInputDownLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearTouchInputDownLog_x64( );
		public static int  ClearTouchInputDownLog( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearTouchInputDownLog_x86( );
			}
			else
			{
				return dx_ClearTouchInputDownLog_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInputDownLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputDownLog_x86( out TOUCHINPUTPOINT  PointData, int  GetNum, int  PeekFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInputDownLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputDownLog_x64( out TOUCHINPUTPOINT  PointData, int  GetNum, int  PeekFlag);
		public static int  GetTouchInputDownLog( out TOUCHINPUTPOINT  PointData, int  GetNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputDownLog_x86( out PointData , GetNum , FALSE );
			}
			else
			{
				return dx_GetTouchInputDownLog_x64( out PointData , GetNum , FALSE );
			}
		}
		public static int  GetTouchInputDownLog( out TOUCHINPUTPOINT  PointData, int  GetNum, int  PeekFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputDownLog_x86( out PointData , GetNum , PeekFlag );
			}
			else
			{
				return dx_GetTouchInputDownLog_x64( out PointData , GetNum , PeekFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInputUpLogNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputUpLogNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInputUpLogNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputUpLogNum_x64( );
		public static int  GetTouchInputUpLogNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputUpLogNum_x86( );
			}
			else
			{
				return dx_GetTouchInputUpLogNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ClearTouchInputUpLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearTouchInputUpLog_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ClearTouchInputUpLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearTouchInputUpLog_x64( );
		public static int  ClearTouchInputUpLog( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearTouchInputUpLog_x86( );
			}
			else
			{
				return dx_ClearTouchInputUpLog_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTouchInputUpLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputUpLog_x86( out TOUCHINPUTPOINT  PointData, int  GetNum, int  PeekFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTouchInputUpLog", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTouchInputUpLog_x64( out TOUCHINPUTPOINT  PointData, int  GetNum, int  PeekFlag);
		public static int  GetTouchInputUpLog( out TOUCHINPUTPOINT  PointData, int  GetNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputUpLog_x86( out PointData , GetNum , FALSE );
			}
			else
			{
				return dx_GetTouchInputUpLog_x64( out PointData , GetNum , FALSE );
			}
		}
		public static int  GetTouchInputUpLog( out TOUCHINPUTPOINT  PointData, int  GetNum, int  PeekFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTouchInputUpLog_x86( out PointData , GetNum , PeekFlag );
			}
			else
			{
				return dx_GetTouchInputUpLog_x64( out PointData , GetNum , PeekFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxAlloc_x86( uint AllocSize, string  File, int  Line);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxAlloc_x64( ulong AllocSize, string  File, int  Line);
		public static System.IntPtr  DxAlloc( ulong AllocSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxAlloc_x86( ( uint )AllocSize , null , -1 );
			}
			else
			{
				return dx_DxAlloc_x64( AllocSize , null , -1 );
			}
		}
		public static System.IntPtr  DxAlloc( ulong AllocSize, string  File)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxAlloc_x86( ( uint )AllocSize , File , -1 );
			}
			else
			{
				return dx_DxAlloc_x64( AllocSize , File , -1 );
			}
		}
		public static System.IntPtr  DxAlloc( ulong AllocSize, string  File, int  Line)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxAlloc_x86( ( uint )AllocSize , File , Line );
			}
			else
			{
				return dx_DxAlloc_x64( AllocSize , File , Line );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxAllocAligned", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxAllocAligned_x86( uint AllocSize, uint Alignment, string  File, int  Line);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxAllocAligned", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxAllocAligned_x64( ulong AllocSize, ulong Alignment, string  File, int  Line);
		public static System.IntPtr  DxAllocAligned( ulong AllocSize, ulong Alignment)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxAllocAligned_x86( ( uint )AllocSize , ( uint )Alignment , null , -1 );
			}
			else
			{
				return dx_DxAllocAligned_x64( AllocSize , Alignment , null , -1 );
			}
		}
		public static System.IntPtr  DxAllocAligned( ulong AllocSize, ulong Alignment, string  File)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxAllocAligned_x86( ( uint )AllocSize , ( uint )Alignment , File , -1 );
			}
			else
			{
				return dx_DxAllocAligned_x64( AllocSize , Alignment , File , -1 );
			}
		}
		public static System.IntPtr  DxAllocAligned( ulong AllocSize, ulong Alignment, string  File, int  Line)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxAllocAligned_x86( ( uint )AllocSize , ( uint )Alignment , File , Line );
			}
			else
			{
				return dx_DxAllocAligned_x64( AllocSize , Alignment , File , Line );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxCalloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxCalloc_x86( uint AllocSize, string  File, int  Line);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxCalloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxCalloc_x64( ulong AllocSize, string  File, int  Line);
		public static System.IntPtr  DxCalloc( ulong AllocSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxCalloc_x86( ( uint )AllocSize , null , -1 );
			}
			else
			{
				return dx_DxCalloc_x64( AllocSize , null , -1 );
			}
		}
		public static System.IntPtr  DxCalloc( ulong AllocSize, string  File)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxCalloc_x86( ( uint )AllocSize , File , -1 );
			}
			else
			{
				return dx_DxCalloc_x64( AllocSize , File , -1 );
			}
		}
		public static System.IntPtr  DxCalloc( ulong AllocSize, string  File, int  Line)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxCalloc_x86( ( uint )AllocSize , File , Line );
			}
			else
			{
				return dx_DxCalloc_x64( AllocSize , File , Line );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxCallocAligned", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxCallocAligned_x86( uint AllocSize, uint Alignment, string  File, int  Line);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxCallocAligned", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxCallocAligned_x64( ulong AllocSize, ulong Alignment, string  File, int  Line);
		public static System.IntPtr  DxCallocAligned( ulong AllocSize, ulong Alignment)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxCallocAligned_x86( ( uint )AllocSize , ( uint )Alignment , null , -1 );
			}
			else
			{
				return dx_DxCallocAligned_x64( AllocSize , Alignment , null , -1 );
			}
		}
		public static System.IntPtr  DxCallocAligned( ulong AllocSize, ulong Alignment, string  File)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxCallocAligned_x86( ( uint )AllocSize , ( uint )Alignment , File , -1 );
			}
			else
			{
				return dx_DxCallocAligned_x64( AllocSize , Alignment , File , -1 );
			}
		}
		public static System.IntPtr  DxCallocAligned( ulong AllocSize, ulong Alignment, string  File, int  Line)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxCallocAligned_x86( ( uint )AllocSize , ( uint )Alignment , File , Line );
			}
			else
			{
				return dx_DxCallocAligned_x64( AllocSize , Alignment , File , Line );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxRealloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxRealloc_x86( System.IntPtr  Memory, uint AllocSize, string  File, int  Line);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxRealloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxRealloc_x64( System.IntPtr  Memory, ulong AllocSize, string  File, int  Line);
		public static System.IntPtr  DxRealloc( System.IntPtr  Memory, ulong AllocSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxRealloc_x86( Memory , ( uint )AllocSize , null , -1 );
			}
			else
			{
				return dx_DxRealloc_x64( Memory , AllocSize , null , -1 );
			}
		}
		public static System.IntPtr  DxRealloc( System.IntPtr  Memory, ulong AllocSize, string  File)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxRealloc_x86( Memory , ( uint )AllocSize , File , -1 );
			}
			else
			{
				return dx_DxRealloc_x64( Memory , AllocSize , File , -1 );
			}
		}
		public static System.IntPtr  DxRealloc( System.IntPtr  Memory, ulong AllocSize, string  File, int  Line)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxRealloc_x86( Memory , ( uint )AllocSize , File , Line );
			}
			else
			{
				return dx_DxRealloc_x64( Memory , AllocSize , File , Line );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxReallocAligned", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxReallocAligned_x86( System.IntPtr  Memory, uint AllocSize, uint Alignment, string  File, int  Line);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxReallocAligned", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_DxReallocAligned_x64( System.IntPtr  Memory, ulong AllocSize, ulong Alignment, string  File, int  Line);
		public static System.IntPtr  DxReallocAligned( System.IntPtr  Memory, ulong AllocSize, ulong Alignment)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxReallocAligned_x86( Memory , ( uint )AllocSize , ( uint )Alignment , null , -1 );
			}
			else
			{
				return dx_DxReallocAligned_x64( Memory , AllocSize , Alignment , null , -1 );
			}
		}
		public static System.IntPtr  DxReallocAligned( System.IntPtr  Memory, ulong AllocSize, ulong Alignment, string  File)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxReallocAligned_x86( Memory , ( uint )AllocSize , ( uint )Alignment , File , -1 );
			}
			else
			{
				return dx_DxReallocAligned_x64( Memory , AllocSize , Alignment , File , -1 );
			}
		}
		public static System.IntPtr  DxReallocAligned( System.IntPtr  Memory, ulong AllocSize, ulong Alignment, string  File, int  Line)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxReallocAligned_x86( Memory , ( uint )AllocSize , ( uint )Alignment , File , Line );
			}
			else
			{
				return dx_DxReallocAligned_x64( Memory , AllocSize , Alignment , File , Line );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxFree", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_DxFree_x86( System.IntPtr  Memory);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxFree", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_DxFree_x64( System.IntPtr  Memory);
		public static void  DxFree( System.IntPtr  Memory)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_DxFree_x86( Memory );
			}
			else
			{
				dx_DxFree_x64( Memory );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxSetAllocSizeTrap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint dx_DxSetAllocSizeTrap_x86( uint Size);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxSetAllocSizeTrap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong dx_DxSetAllocSizeTrap_x64( ulong Size);
		public static ulong  DxSetAllocSizeTrap( ulong Size)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxSetAllocSizeTrap_x86( ( uint )Size );
			}
			else
			{
				return dx_DxSetAllocSizeTrap_x64( Size );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxSetAllocPrintFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxSetAllocPrintFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxSetAllocPrintFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxSetAllocPrintFlag_x64( int  Flag);
		public static int  DxSetAllocPrintFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxSetAllocPrintFlag_x86( Flag );
			}
			else
			{
				return dx_DxSetAllocPrintFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxGetAllocSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint dx_DxGetAllocSize_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxGetAllocSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong dx_DxGetAllocSize_x64( );
		public static ulong  DxGetAllocSize( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxGetAllocSize_x86( );
			}
			else
			{
				return dx_DxGetAllocSize_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxGetAllocNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxGetAllocNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxGetAllocNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxGetAllocNum_x64( );
		public static int  DxGetAllocNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxGetAllocNum_x86( );
			}
			else
			{
				return dx_DxGetAllocNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxDumpAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_DxDumpAlloc_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxDumpAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_DxDumpAlloc_x64( );
		public static void  DxDumpAlloc( )
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_DxDumpAlloc_x86( );
			}
			else
			{
				dx_DxDumpAlloc_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxDrawAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_DxDrawAlloc_x86( int  x, int  y, int  Width, int  Height);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxDrawAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_DxDrawAlloc_x64( int  x, int  y, int  Width, int  Height);
		public static void  DxDrawAlloc( int  x, int  y, int  Width, int  Height)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_DxDrawAlloc_x86( x , y , Width , Height );
			}
			else
			{
				dx_DxDrawAlloc_x64( x , y , Width , Height );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxErrorCheckAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxErrorCheckAlloc_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxErrorCheckAlloc", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxErrorCheckAlloc_x64( );
		public static int  DxErrorCheckAlloc( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxErrorCheckAlloc_x86( );
			}
			else
			{
				return dx_DxErrorCheckAlloc_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxSetAllocSizeOutFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxSetAllocSizeOutFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxSetAllocSizeOutFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxSetAllocSizeOutFlag_x64( int  Flag);
		public static int  DxSetAllocSizeOutFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxSetAllocSizeOutFlag_x86( Flag );
			}
			else
			{
				return dx_DxSetAllocSizeOutFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DxSetAllocMemoryErrorCheckFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxSetAllocMemoryErrorCheckFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DxSetAllocMemoryErrorCheckFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DxSetAllocMemoryErrorCheckFlag_x64( int  Flag);
		public static int  DxSetAllocMemoryErrorCheckFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DxSetAllocMemoryErrorCheckFlag_x86( Flag );
			}
			else
			{
				return dx_DxSetAllocMemoryErrorCheckFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCharBytes", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCharBytes_x86( int  CharCodeFormat, System.IntPtr  String);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCharBytes", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCharBytes_x64( int  CharCodeFormat, System.IntPtr  String);
		public static int  GetCharBytes( int  CharCodeFormat, System.IntPtr  String)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCharBytes_x86( CharCodeFormat , String );
			}
			else
			{
				return dx_GetCharBytes_x64( CharCodeFormat , String );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvertStringCharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConvertStringCharCodeFormat_x86( int  SrcCharCodeFormat, System.IntPtr  SrcString, int  DestCharCodeFormat, System.IntPtr  DestStringBuffer);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvertStringCharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConvertStringCharCodeFormat_x64( int  SrcCharCodeFormat, System.IntPtr  SrcString, int  DestCharCodeFormat, System.IntPtr  DestStringBuffer);
		public static int  ConvertStringCharCodeFormat( int  SrcCharCodeFormat, System.IntPtr  SrcString, int  DestCharCodeFormat, System.IntPtr  DestStringBuffer)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvertStringCharCodeFormat_x86( SrcCharCodeFormat , SrcString , DestCharCodeFormat , DestStringBuffer );
			}
			else
			{
				return dx_ConvertStringCharCodeFormat_x64( SrcCharCodeFormat , SrcString , DestCharCodeFormat , DestStringBuffer );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseCharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseCharCodeFormat_x86( int  CharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseCharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseCharCodeFormat_x64( int  CharCodeFormat);
		public static int  SetUseCharCodeFormat( int  CharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseCharCodeFormat_x86( CharCodeFormat );
			}
			else
			{
				return dx_SetUseCharCodeFormat_x64( CharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseCharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseCharCodeFormat_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseCharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseCharCodeFormat_x64( );
		public static int  GetUseCharCodeFormat( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseCharCodeFormat_x86( );
			}
			else
			{
				return dx_GetUseCharCodeFormat_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_Get_wchar_t_CharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_Get_wchar_t_CharCodeFormat_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_Get_wchar_t_CharCodeFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_Get_wchar_t_CharCodeFormat_x64( );
		public static int  Get_wchar_t_CharCodeFormat( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_Get_wchar_t_CharCodeFormat_x86( );
			}
			else
			{
				return dx_Get_wchar_t_CharCodeFormat_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strcpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcpyDx_x86( System.Text.StringBuilder  Dest, string  Src);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strcpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcpyDx_x64( System.Text.StringBuilder  Dest, string  Src);
		public static void  strcpyDx( System.Text.StringBuilder  Dest, string  Src)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strcpyDx_x86( Dest , Src );
			}
			else
			{
				dx_strcpyDx_x64( Dest , Src );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strcpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcpy_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strcpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcpy_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src);
		public static void  strcpy_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strcpy_sDx_x86( Dest , ( uint )DestBytes , Src );
			}
			else
			{
				dx_strcpy_sDx_x64( Dest , DestBytes , Src );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpcpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpyDx_x86( System.Text.StringBuilder  Dest, string  Src, int  Pos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpcpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpyDx_x64( System.Text.StringBuilder  Dest, string  Src, int  Pos);
		public static void  strpcpyDx( System.Text.StringBuilder  Dest, string  Src, int  Pos)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpcpyDx_x86( Dest , Src , Pos );
			}
			else
			{
				dx_strpcpyDx_x64( Dest , Src , Pos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpcpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpy_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Pos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpcpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpy_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos);
		public static void  strpcpy_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpcpy_sDx_x86( Dest , ( uint )DestBytes , Src , Pos );
			}
			else
			{
				dx_strpcpy_sDx_x64( Dest , DestBytes , Src , Pos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpcpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpy2Dx_x86( System.Text.StringBuilder  Dest, string  Src, int  Pos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpcpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpy2Dx_x64( System.Text.StringBuilder  Dest, string  Src, int  Pos);
		public static void  strpcpy2Dx( System.Text.StringBuilder  Dest, string  Src, int  Pos)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpcpy2Dx_x86( Dest , Src , Pos );
			}
			else
			{
				dx_strpcpy2Dx_x64( Dest , Src , Pos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpcpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpy2_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Pos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpcpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpcpy2_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos);
		public static void  strpcpy2_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpcpy2_sDx_x86( Dest , ( uint )DestBytes , Src , Pos );
			}
			else
			{
				dx_strpcpy2_sDx_x64( Dest , DestBytes , Src , Pos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strncpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpyDx_x86( System.Text.StringBuilder  Dest, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strncpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpyDx_x64( System.Text.StringBuilder  Dest, string  Src, int  Num);
		public static void  strncpyDx( System.Text.StringBuilder  Dest, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strncpyDx_x86( Dest , Src , Num );
			}
			else
			{
				dx_strncpyDx_x64( Dest , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strncpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpy_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strncpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpy_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num);
		public static void  strncpy_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strncpy_sDx_x86( Dest , ( uint )DestBytes , Src , Num );
			}
			else
			{
				dx_strncpy_sDx_x64( Dest , DestBytes , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strncpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpy2Dx_x86( System.Text.StringBuilder  Dest, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strncpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpy2Dx_x64( System.Text.StringBuilder  Dest, string  Src, int  Num);
		public static void  strncpy2Dx( System.Text.StringBuilder  Dest, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strncpy2Dx_x86( Dest , Src , Num );
			}
			else
			{
				dx_strncpy2Dx_x64( Dest , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strncpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpy2_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strncpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strncpy2_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num);
		public static void  strncpy2_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strncpy2_sDx_x86( Dest , ( uint )DestBytes , Src , Num );
			}
			else
			{
				dx_strncpy2_sDx_x64( Dest , DestBytes , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrncpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpyDx_x86( System.Text.StringBuilder  Dest, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrncpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpyDx_x64( System.Text.StringBuilder  Dest, string  Src, int  Num);
		public static void  strrncpyDx( System.Text.StringBuilder  Dest, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strrncpyDx_x86( Dest , Src , Num );
			}
			else
			{
				dx_strrncpyDx_x64( Dest , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrncpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpy_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrncpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpy_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num);
		public static void  strrncpy_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strrncpy_sDx_x86( Dest , ( uint )DestBytes , Src , Num );
			}
			else
			{
				dx_strrncpy_sDx_x64( Dest , DestBytes , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrncpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpy2Dx_x86( System.Text.StringBuilder  Dest, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrncpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpy2Dx_x64( System.Text.StringBuilder  Dest, string  Src, int  Num);
		public static void  strrncpy2Dx( System.Text.StringBuilder  Dest, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strrncpy2Dx_x86( Dest , Src , Num );
			}
			else
			{
				dx_strrncpy2Dx_x64( Dest , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrncpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpy2_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrncpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strrncpy2_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num);
		public static void  strrncpy2_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strrncpy2_sDx_x86( Dest , ( uint )DestBytes , Src , Num );
			}
			else
			{
				dx_strrncpy2_sDx_x64( Dest , DestBytes , Src , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpncpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpyDx_x86( System.Text.StringBuilder  Dest, string  Src, int  Pos, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpncpyDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpyDx_x64( System.Text.StringBuilder  Dest, string  Src, int  Pos, int  Num);
		public static void  strpncpyDx( System.Text.StringBuilder  Dest, string  Src, int  Pos, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpncpyDx_x86( Dest , Src , Pos , Num );
			}
			else
			{
				dx_strpncpyDx_x64( Dest , Src , Pos , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpncpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpy_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Pos, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpncpy_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpy_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos, int  Num);
		public static void  strpncpy_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpncpy_sDx_x86( Dest , ( uint )DestBytes , Src , Pos , Num );
			}
			else
			{
				dx_strpncpy_sDx_x64( Dest , DestBytes , Src , Pos , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpncpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpy2Dx_x86( System.Text.StringBuilder  Dest, string  Src, int  Pos, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpncpy2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpy2Dx_x64( System.Text.StringBuilder  Dest, string  Src, int  Pos, int  Num);
		public static void  strpncpy2Dx( System.Text.StringBuilder  Dest, string  Src, int  Pos, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpncpy2Dx_x86( Dest , Src , Pos , Num );
			}
			else
			{
				dx_strpncpy2Dx_x64( Dest , Src , Pos , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpncpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpy2_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src, int  Pos, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpncpy2_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strpncpy2_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos, int  Num);
		public static void  strpncpy2_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src, int  Pos, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strpncpy2_sDx_x86( Dest , ( uint )DestBytes , Src , Pos , Num );
			}
			else
			{
				dx_strpncpy2_sDx_x64( Dest , DestBytes , Src , Pos , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strcatDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcatDx_x86( System.Text.StringBuilder  Dest, string  Src);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strcatDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcatDx_x64( System.Text.StringBuilder  Dest, string  Src);
		public static void  strcatDx( System.Text.StringBuilder  Dest, string  Src)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strcatDx_x86( Dest , Src );
			}
			else
			{
				dx_strcatDx_x64( Dest , Src );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strcat_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcat_sDx_x86( System.Text.StringBuilder  Dest, uint DestBytes, string  Src);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strcat_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static void  dx_strcat_sDx_x64( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src);
		public static void  strcat_sDx( System.Text.StringBuilder  Dest, ulong DestBytes, string  Src)
		{
			if( System.IntPtr.Size == 4 )
			{
				dx_strcat_sDx_x86( Dest , ( uint )DestBytes , Src );
			}
			else
			{
				dx_strcat_sDx_x64( Dest , DestBytes , Src );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strlenDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint dx_strlenDx_x86( string  Str);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strlenDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong dx_strlenDx_x64( string  Str);
		public static ulong  strlenDx( string  Str)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strlenDx_x86( Str );
			}
			else
			{
				return dx_strlenDx_x64( Str );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strlen2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint dx_strlen2Dx_x86( string  Str);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strlen2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static ulong dx_strlen2Dx_x64( string  Str);
		public static ulong  strlen2Dx( string  Str)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strlen2Dx_x86( Str );
			}
			else
			{
				return dx_strlen2Dx_x64( Str );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strcmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strcmpDx_x86( string  Str1, string  Str2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strcmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strcmpDx_x64( string  Str1, string  Str2);
		public static int  strcmpDx( string  Str1, string  Str2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strcmpDx_x86( Str1 , Str2 );
			}
			else
			{
				return dx_strcmpDx_x64( Str1 , Str2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_stricmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_stricmpDx_x86( string  Str1, string  Str2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_stricmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_stricmpDx_x64( string  Str1, string  Str2);
		public static int  stricmpDx( string  Str1, string  Str2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_stricmpDx_x86( Str1 , Str2 );
			}
			else
			{
				return dx_stricmpDx_x64( Str1 , Str2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strncmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strncmpDx_x86( string  Str1, string  Str2, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strncmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strncmpDx_x64( string  Str1, string  Str2, int  Num);
		public static int  strncmpDx( string  Str1, string  Str2, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strncmpDx_x86( Str1 , Str2 , Num );
			}
			else
			{
				return dx_strncmpDx_x64( Str1 , Str2 , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strncmp2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strncmp2Dx_x86( string  Str1, string  Str2, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strncmp2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strncmp2Dx_x64( string  Str1, string  Str2, int  Num);
		public static int  strncmp2Dx( string  Str1, string  Str2, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strncmp2Dx_x86( Str1 , Str2 , Num );
			}
			else
			{
				return dx_strncmp2Dx_x64( Str1 , Str2 , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpncmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strpncmpDx_x86( string  Str1, string  Str2, int  Pos, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpncmpDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strpncmpDx_x64( string  Str1, string  Str2, int  Pos, int  Num);
		public static int  strpncmpDx( string  Str1, string  Str2, int  Pos, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strpncmpDx_x86( Str1 , Str2 , Pos , Num );
			}
			else
			{
				return dx_strpncmpDx_x64( Str1 , Str2 , Pos , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpncmp2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strpncmp2Dx_x86( string  Str1, string  Str2, int  Pos, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpncmp2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strpncmp2Dx_x64( string  Str1, string  Str2, int  Pos, int  Num);
		public static int  strpncmp2Dx( string  Str1, string  Str2, int  Pos, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strpncmp2Dx_x86( Str1 , Str2 , Pos , Num );
			}
			else
			{
				return dx_strpncmp2Dx_x64( Str1 , Str2 , Pos , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strgetchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_strgetchrDx_x86( string  Str, int  Pos, out int  CharNums);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strgetchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_strgetchrDx_x64( string  Str, int  Pos, out int  CharNums);
		public static uint  strgetchrDx( string  Str, int  Pos, out int  CharNums)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strgetchrDx_x86( Str , Pos , out CharNums );
			}
			else
			{
				return dx_strgetchrDx_x64( Str , Pos , out CharNums );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strgetchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_strgetchr2Dx_x86( string  Str, int  Pos, out int  CharNums);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strgetchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_strgetchr2Dx_x64( string  Str, int  Pos, out int  CharNums);
		public static uint  strgetchr2Dx( string  Str, int  Pos, out int  CharNums)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strgetchr2Dx_x86( Str , Pos , out CharNums );
			}
			else
			{
				return dx_strgetchr2Dx_x64( Str , Pos , out CharNums );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strputchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strputchrDx_x86( System.Text.StringBuilder  Str, int  Pos, uint  CharCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strputchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strputchrDx_x64( System.Text.StringBuilder  Str, int  Pos, uint  CharCode);
		public static int  strputchrDx( System.Text.StringBuilder  Str, int  Pos, uint  CharCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strputchrDx_x86( Str , Pos , CharCode );
			}
			else
			{
				return dx_strputchrDx_x64( Str , Pos , CharCode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strputchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strputchr2Dx_x86( System.Text.StringBuilder  Str, int  Pos, uint  CharCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strputchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strputchr2Dx_x64( System.Text.StringBuilder  Str, int  Pos, uint  CharCode);
		public static int  strputchr2Dx( System.Text.StringBuilder  Str, int  Pos, uint  CharCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strputchr2Dx_x86( Str , Pos , CharCode );
			}
			else
			{
				return dx_strputchr2Dx_x64( Str , Pos , CharCode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strposDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strposDx_x86( string  Str, int  Pos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strposDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strposDx_x64( string  Str, int  Pos);
		public static string  strposDx( string  Str, int  Pos)
		{
			if( System.IntPtr.Size == 4 )
			{
				System.IntPtr resultIntPtr = dx_strposDx_x86( Str , Pos );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
			else
			{
				System.IntPtr resultIntPtr = dx_strposDx_x64( Str , Pos );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strpos2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strpos2Dx_x86( string  Str, int  Pos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strpos2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strpos2Dx_x64( string  Str, int  Pos);
		public static string  strpos2Dx( string  Str, int  Pos)
		{
			if( System.IntPtr.Size == 4 )
			{
				System.IntPtr resultIntPtr = dx_strpos2Dx_x86( Str , Pos );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
			else
			{
				System.IntPtr resultIntPtr = dx_strpos2Dx_x64( Str , Pos );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strstrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strstrDx_x86( string  Str1, string  Str2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strstrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strstrDx_x64( string  Str1, string  Str2);
		public static string  strstrDx( string  Str1, string  Str2)
		{
			if( System.IntPtr.Size == 4 )
			{
				System.IntPtr resultIntPtr = dx_strstrDx_x86( Str1 , Str2 );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
			else
			{
				System.IntPtr resultIntPtr = dx_strstrDx_x64( Str1 , Str2 );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strstr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strstr2Dx_x86( string  Str1, string  Str2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strstr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strstr2Dx_x64( string  Str1, string  Str2);
		public static int  strstr2Dx( string  Str1, string  Str2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strstr2Dx_x86( Str1 , Str2 );
			}
			else
			{
				return dx_strstr2Dx_x64( Str1 , Str2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrstrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strrstrDx_x86( string  Str1, string  Str2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrstrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strrstrDx_x64( string  Str1, string  Str2);
		public static string  strrstrDx( string  Str1, string  Str2)
		{
			if( System.IntPtr.Size == 4 )
			{
				System.IntPtr resultIntPtr = dx_strrstrDx_x86( Str1 , Str2 );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
			else
			{
				System.IntPtr resultIntPtr = dx_strrstrDx_x64( Str1 , Str2 );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrstr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strrstr2Dx_x86( string  Str1, string  Str2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrstr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strrstr2Dx_x64( string  Str1, string  Str2);
		public static int  strrstr2Dx( string  Str1, string  Str2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strrstr2Dx_x86( Str1 , Str2 );
			}
			else
			{
				return dx_strrstr2Dx_x64( Str1 , Str2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strchrDx_x86( string  Str, uint  CharCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strchrDx_x64( string  Str, uint  CharCode);
		public static string  strchrDx( string  Str, uint  CharCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				System.IntPtr resultIntPtr = dx_strchrDx_x86( Str , CharCode );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
			else
			{
				System.IntPtr resultIntPtr = dx_strchrDx_x64( Str , CharCode );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strchr2Dx_x86( string  Str, uint  CharCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strchr2Dx_x64( string  Str, uint  CharCode);
		public static int  strchr2Dx( string  Str, uint  CharCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strchr2Dx_x86( Str , CharCode );
			}
			else
			{
				return dx_strchr2Dx_x64( Str , CharCode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strrchrDx_x86( string  Str, uint  CharCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrchrDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_strrchrDx_x64( string  Str, uint  CharCode);
		public static string  strrchrDx( string  Str, uint  CharCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				System.IntPtr resultIntPtr = dx_strrchrDx_x86( Str , CharCode );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
			else
			{
				System.IntPtr resultIntPtr = dx_strrchrDx_x64( Str , CharCode );
				if( resultIntPtr == System.IntPtr.Zero )
				{
					return "";
				}
				else
				{
					return System.Runtime.InteropServices.Marshal.PtrToStringUni( resultIntPtr );
				}
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_strrchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strrchr2Dx_x86( string  Str, uint  CharCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_strrchr2Dx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_strrchr2Dx_x64( string  Str, uint  CharCode);
		public static int  strrchr2Dx( string  Str, uint  CharCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_strrchr2Dx_x86( Str , CharCode );
			}
			else
			{
				return dx_strrchr2Dx_x64( Str , CharCode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_struprDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.Text.StringBuilder  dx_struprDx_x86( System.Text.StringBuilder  Str);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_struprDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.Text.StringBuilder  dx_struprDx_x64( System.Text.StringBuilder  Str);
		public static System.Text.StringBuilder  struprDx( System.Text.StringBuilder  Str)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_struprDx_x86( Str );
			}
			else
			{
				return dx_struprDx_x64( Str );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_itoaDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.Text.StringBuilder  dx_itoaDx_x86( int  Value, System.Text.StringBuilder  Buffer, int  Radix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_itoaDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.Text.StringBuilder  dx_itoaDx_x64( int  Value, System.Text.StringBuilder  Buffer, int  Radix);
		public static System.Text.StringBuilder  itoaDx( int  Value, System.Text.StringBuilder  Buffer, int  Radix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_itoaDx_x86( Value , Buffer , Radix );
			}
			else
			{
				return dx_itoaDx_x64( Value , Buffer , Radix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_itoa_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.Text.StringBuilder  dx_itoa_sDx_x86( int  Value, System.Text.StringBuilder  Buffer, uint BufferBytes, int  Radix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_itoa_sDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.Text.StringBuilder  dx_itoa_sDx_x64( int  Value, System.Text.StringBuilder  Buffer, ulong BufferBytes, int  Radix);
		public static System.Text.StringBuilder  itoa_sDx( int  Value, System.Text.StringBuilder  Buffer, ulong BufferBytes, int  Radix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_itoa_sDx_x86( Value , Buffer , ( uint )BufferBytes , Radix );
			}
			else
			{
				return dx_itoa_sDx_x64( Value , Buffer , BufferBytes , Radix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_atoiDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_atoiDx_x86( string  Str);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_atoiDx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_atoiDx_x64( string  Str);
		public static int  atoiDx( string  Str)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_atoiDx_x86( Str );
			}
			else
			{
				return dx_atoiDx_x64( Str );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ProcessNetMessage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ProcessNetMessage_x86( int  RunReleaseProcess);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ProcessNetMessage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ProcessNetMessage_x64( int  RunReleaseProcess);
		public static int  ProcessNetMessage( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ProcessNetMessage_x86( FALSE );
			}
			else
			{
				return dx_ProcessNetMessage_x64( FALSE );
			}
		}
		public static int  ProcessNetMessage( int  RunReleaseProcess)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ProcessNetMessage_x86( RunReleaseProcess );
			}
			else
			{
				return dx_ProcessNetMessage_x64( RunReleaseProcess );
			}
		}

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetHostIPbyName", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyName_x86( string  HostName, IPDATA *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHostIPbyName", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyName_x64( string  HostName, IPDATA *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		public unsafe static int  GetHostIPbyName( string  HostName, IPDATA *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHostIPbyName_x86( HostName , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
			else
			{
				return dx_GetHostIPbyName_x64( HostName , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetHostIPbyNameWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyNameWithStrLen_x86( string  HostName, uint HostNameLength, IPDATA *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHostIPbyNameWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyNameWithStrLen_x64( string  HostName, ulong HostNameLength, IPDATA *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		public unsafe static int  GetHostIPbyNameWithStrLen( string  HostName, ulong HostNameLength, IPDATA *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHostIPbyNameWithStrLen_x86( HostName , ( uint )HostNameLength , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
			else
			{
				return dx_GetHostIPbyNameWithStrLen_x64( HostName , HostNameLength , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetHostIPbyName_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyName_IPv6_x86( string  HostName, IPDATA_IPv6 *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHostIPbyName_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyName_IPv6_x64( string  HostName, IPDATA_IPv6 *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		public unsafe static int  GetHostIPbyName_IPv6( string  HostName, IPDATA_IPv6 *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHostIPbyName_IPv6_x86( HostName , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
			else
			{
				return dx_GetHostIPbyName_IPv6_x64( HostName , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetHostIPbyName_IPv6WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyName_IPv6WithStrLen_x86( string  HostName, uint HostNameLength, IPDATA_IPv6 *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHostIPbyName_IPv6WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetHostIPbyName_IPv6WithStrLen_x64( string  HostName, ulong HostNameLength, IPDATA_IPv6 *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum);
		public unsafe static int  GetHostIPbyName_IPv6WithStrLen( string  HostName, ulong HostNameLength, IPDATA_IPv6 *  IPDataBuf, int  IPDataBufLength, int *  IPDataGetNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHostIPbyName_IPv6WithStrLen_x86( HostName , ( uint )HostNameLength , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
			else
			{
				return dx_GetHostIPbyName_IPv6WithStrLen_x64( HostName , HostNameLength , IPDataBuf , IPDataBufLength , IPDataGetNum );
			}
		}
#endif

		[DllImport("DxLibW.dll", EntryPoint="dx_ConnectNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_x86( IPDATA  IPData, int  Port);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConnectNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_x64( IPDATA  IPData, int  Port);
		public static int  ConnectNetWork( IPDATA  IPData)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_x86( IPData , -1 );
			}
			else
			{
				return dx_ConnectNetWork_x64( IPData , -1 );
			}
		}
		public static int  ConnectNetWork( IPDATA  IPData, int  Port)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_x86( IPData , Port );
			}
			else
			{
				return dx_ConnectNetWork_x64( IPData , Port );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConnectNetWork_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_IPv6_x86( IPDATA_IPv6  IPData, int  Port);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConnectNetWork_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_IPv6_x64( IPDATA_IPv6  IPData, int  Port);
		public static int  ConnectNetWork_IPv6( IPDATA_IPv6  IPData)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_IPv6_x86( IPData , -1 );
			}
			else
			{
				return dx_ConnectNetWork_IPv6_x64( IPData , -1 );
			}
		}
		public static int  ConnectNetWork_IPv6( IPDATA_IPv6  IPData, int  Port)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_IPv6_x86( IPData , Port );
			}
			else
			{
				return dx_ConnectNetWork_IPv6_x64( IPData , Port );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConnectNetWork_ASync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_ASync_x86( IPDATA  IPData, int  Port);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConnectNetWork_ASync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_ASync_x64( IPDATA  IPData, int  Port);
		public static int  ConnectNetWork_ASync( IPDATA  IPData)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_ASync_x86( IPData , -1 );
			}
			else
			{
				return dx_ConnectNetWork_ASync_x64( IPData , -1 );
			}
		}
		public static int  ConnectNetWork_ASync( IPDATA  IPData, int  Port)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_ASync_x86( IPData , Port );
			}
			else
			{
				return dx_ConnectNetWork_ASync_x64( IPData , Port );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConnectNetWork_IPv6_ASync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_IPv6_ASync_x86( IPDATA_IPv6  IPData, int  Port);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConnectNetWork_IPv6_ASync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConnectNetWork_IPv6_ASync_x64( IPDATA_IPv6  IPData, int  Port);
		public static int  ConnectNetWork_IPv6_ASync( IPDATA_IPv6  IPData)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_IPv6_ASync_x86( IPData , -1 );
			}
			else
			{
				return dx_ConnectNetWork_IPv6_ASync_x64( IPData , -1 );
			}
		}
		public static int  ConnectNetWork_IPv6_ASync( IPDATA_IPv6  IPData, int  Port)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConnectNetWork_IPv6_ASync_x86( IPData , Port );
			}
			else
			{
				return dx_ConnectNetWork_IPv6_ASync_x64( IPData , Port );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_PreparationListenNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_PreparationListenNetWork_x86( int  Port);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_PreparationListenNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_PreparationListenNetWork_x64( int  Port);
		public static int  PreparationListenNetWork( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_PreparationListenNetWork_x86( -1 );
			}
			else
			{
				return dx_PreparationListenNetWork_x64( -1 );
			}
		}
		public static int  PreparationListenNetWork( int  Port)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_PreparationListenNetWork_x86( Port );
			}
			else
			{
				return dx_PreparationListenNetWork_x64( Port );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_PreparationListenNetWork_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_PreparationListenNetWork_IPv6_x86( int  Port);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_PreparationListenNetWork_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_PreparationListenNetWork_IPv6_x64( int  Port);
		public static int  PreparationListenNetWork_IPv6( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_PreparationListenNetWork_IPv6_x86( -1 );
			}
			else
			{
				return dx_PreparationListenNetWork_IPv6_x64( -1 );
			}
		}
		public static int  PreparationListenNetWork_IPv6( int  Port)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_PreparationListenNetWork_IPv6_x86( Port );
			}
			else
			{
				return dx_PreparationListenNetWork_IPv6_x64( Port );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_StopListenNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StopListenNetWork_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_StopListenNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StopListenNetWork_x64( );
		public static int  StopListenNetWork( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_StopListenNetWork_x86( );
			}
			else
			{
				return dx_StopListenNetWork_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CloseNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CloseNetWork_x86( int  NetHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CloseNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CloseNetWork_x64( int  NetHandle);
		public static int  CloseNetWork( int  NetHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CloseNetWork_x86( NetHandle );
			}
			else
			{
				return dx_CloseNetWork_x64( NetHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNetWorkAcceptState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkAcceptState_x86( int  NetHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNetWorkAcceptState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkAcceptState_x64( int  NetHandle);
		public static int  GetNetWorkAcceptState( int  NetHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNetWorkAcceptState_x86( NetHandle );
			}
			else
			{
				return dx_GetNetWorkAcceptState_x64( NetHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNetWorkDataLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkDataLength_x86( int  NetHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNetWorkDataLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkDataLength_x64( int  NetHandle);
		public static int  GetNetWorkDataLength( int  NetHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNetWorkDataLength_x86( NetHandle );
			}
			else
			{
				return dx_GetNetWorkDataLength_x64( NetHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNetWorkSendDataLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkSendDataLength_x86( int  NetHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNetWorkSendDataLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkSendDataLength_x64( int  NetHandle);
		public static int  GetNetWorkSendDataLength( int  NetHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNetWorkSendDataLength_x86( NetHandle );
			}
			else
			{
				return dx_GetNetWorkSendDataLength_x64( NetHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNewAcceptNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNewAcceptNetWork_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNewAcceptNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNewAcceptNetWork_x64( );
		public static int  GetNewAcceptNetWork( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNewAcceptNetWork_x86( );
			}
			else
			{
				return dx_GetNewAcceptNetWork_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetLostNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLostNetWork_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetLostNetWork", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetLostNetWork_x64( );
		public static int  GetLostNetWork( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetLostNetWork_x86( );
			}
			else
			{
				return dx_GetLostNetWork_x64( );
			}
		}

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetNetWorkIP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetNetWorkIP_x86( int  NetHandle, IPDATA *  IpBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNetWorkIP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetNetWorkIP_x64( int  NetHandle, IPDATA *  IpBuf);
		public unsafe static int  GetNetWorkIP( int  NetHandle, IPDATA *  IpBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNetWorkIP_x86( NetHandle , IpBuf );
			}
			else
			{
				return dx_GetNetWorkIP_x64( NetHandle , IpBuf );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetNetWorkIP_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetNetWorkIP_IPv6_x86( int  NetHandle, IPDATA_IPv6 *  IpBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNetWorkIP_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetNetWorkIP_IPv6_x64( int  NetHandle, IPDATA_IPv6 *  IpBuf);
		public unsafe static int  GetNetWorkIP_IPv6( int  NetHandle, IPDATA_IPv6 *  IpBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNetWorkIP_IPv6_x86( NetHandle , IpBuf );
			}
			else
			{
				return dx_GetNetWorkIP_IPv6_x64( NetHandle , IpBuf );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetMyIPAddress", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetMyIPAddress_x86( IPDATA *  IpBuf, int  IpBufLength, int *  IpNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMyIPAddress", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetMyIPAddress_x64( IPDATA *  IpBuf, int  IpBufLength, int *  IpNum);
		public unsafe static int  GetMyIPAddress( IPDATA *  IpBuf, int  IpBufLength, int *  IpNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMyIPAddress_x86( IpBuf , IpBufLength , IpNum );
			}
			else
			{
				return dx_GetMyIPAddress_x64( IpBuf , IpBufLength , IpNum );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetMyIPAddress_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetMyIPAddress_IPv6_x86( IPDATA_IPv6 *  IpBuf, int  IpBufLength, int *  IpNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMyIPAddress_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_GetMyIPAddress_IPv6_x64( IPDATA_IPv6 *  IpBuf, int  IpBufLength, int *  IpNum);
		public unsafe static int  GetMyIPAddress_IPv6( IPDATA_IPv6 *  IpBuf, int  IpBufLength, int *  IpNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMyIPAddress_IPv6_x86( IpBuf , IpBufLength , IpNum );
			}
			else
			{
				return dx_GetMyIPAddress_IPv6_x64( IpBuf , IpBufLength , IpNum );
			}
		}
#endif

		[DllImport("DxLibW.dll", EntryPoint="dx_SetConnectTimeOutWait", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetConnectTimeOutWait_x86( int  Time);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetConnectTimeOutWait", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetConnectTimeOutWait_x64( int  Time);
		public static int  SetConnectTimeOutWait( int  Time)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetConnectTimeOutWait_x86( Time );
			}
			else
			{
				return dx_SetConnectTimeOutWait_x64( Time );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseDXNetWorkProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDXNetWorkProtocol_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseDXNetWorkProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDXNetWorkProtocol_x64( int  Flag);
		public static int  SetUseDXNetWorkProtocol( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseDXNetWorkProtocol_x86( Flag );
			}
			else
			{
				return dx_SetUseDXNetWorkProtocol_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseDXNetWorkProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseDXNetWorkProtocol_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseDXNetWorkProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseDXNetWorkProtocol_x64( );
		public static int  GetUseDXNetWorkProtocol( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseDXNetWorkProtocol_x86( );
			}
			else
			{
				return dx_GetUseDXNetWorkProtocol_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseDXProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDXProtocol_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseDXProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDXProtocol_x64( int  Flag);
		public static int  SetUseDXProtocol( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseDXProtocol_x86( Flag );
			}
			else
			{
				return dx_SetUseDXProtocol_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseDXProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseDXProtocol_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseDXProtocol", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseDXProtocol_x64( );
		public static int  GetUseDXProtocol( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseDXProtocol_x86( );
			}
			else
			{
				return dx_GetUseDXProtocol_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetNetWorkCloseAfterLostFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNetWorkCloseAfterLostFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetNetWorkCloseAfterLostFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNetWorkCloseAfterLostFlag_x64( int  Flag);
		public static int  SetNetWorkCloseAfterLostFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetNetWorkCloseAfterLostFlag_x86( Flag );
			}
			else
			{
				return dx_SetNetWorkCloseAfterLostFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetNetWorkCloseAfterLostFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkCloseAfterLostFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetNetWorkCloseAfterLostFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetNetWorkCloseAfterLostFlag_x64( );
		public static int  GetNetWorkCloseAfterLostFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetNetWorkCloseAfterLostFlag_x86( );
			}
			else
			{
				return dx_GetNetWorkCloseAfterLostFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkRecv", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkRecv_x86( int  NetHandle, System.IntPtr  Buffer, int  Length);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkRecv", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkRecv_x64( int  NetHandle, System.IntPtr  Buffer, int  Length);
		public static int  NetWorkRecv( int  NetHandle, System.IntPtr  Buffer, int  Length)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkRecv_x86( NetHandle , Buffer , Length );
			}
			else
			{
				return dx_NetWorkRecv_x64( NetHandle , Buffer , Length );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkRecvToPeek", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkRecvToPeek_x86( int  NetHandle, System.IntPtr  Buffer, int  Length);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkRecvToPeek", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkRecvToPeek_x64( int  NetHandle, System.IntPtr  Buffer, int  Length);
		public static int  NetWorkRecvToPeek( int  NetHandle, System.IntPtr  Buffer, int  Length)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkRecvToPeek_x86( NetHandle , Buffer , Length );
			}
			else
			{
				return dx_NetWorkRecvToPeek_x64( NetHandle , Buffer , Length );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkRecvBufferClear", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkRecvBufferClear_x86( int  NetHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkRecvBufferClear", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkRecvBufferClear_x64( int  NetHandle);
		public static int  NetWorkRecvBufferClear( int  NetHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkRecvBufferClear_x86( NetHandle );
			}
			else
			{
				return dx_NetWorkRecvBufferClear_x64( NetHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkSend", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkSend_x86( int  NetHandle, System.IntPtr  Buffer, int  Length);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkSend", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkSend_x64( int  NetHandle, System.IntPtr  Buffer, int  Length);
		public static int  NetWorkSend( int  NetHandle, System.IntPtr  Buffer, int  Length)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkSend_x86( NetHandle , Buffer , Length );
			}
			else
			{
				return dx_NetWorkSend_x64( NetHandle , Buffer , Length );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_MakeUDPSocket", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeUDPSocket_x86( int  RecvPort);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MakeUDPSocket", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeUDPSocket_x64( int  RecvPort);
		public static int  MakeUDPSocket( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeUDPSocket_x86( -1 );
			}
			else
			{
				return dx_MakeUDPSocket_x64( -1 );
			}
		}
		public static int  MakeUDPSocket( int  RecvPort)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeUDPSocket_x86( RecvPort );
			}
			else
			{
				return dx_MakeUDPSocket_x64( RecvPort );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_MakeUDPSocket_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeUDPSocket_IPv6_x86( int  RecvPort);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MakeUDPSocket_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeUDPSocket_IPv6_x64( int  RecvPort);
		public static int  MakeUDPSocket_IPv6( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeUDPSocket_IPv6_x86( -1 );
			}
			else
			{
				return dx_MakeUDPSocket_IPv6_x64( -1 );
			}
		}
		public static int  MakeUDPSocket_IPv6( int  RecvPort)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeUDPSocket_IPv6_x86( RecvPort );
			}
			else
			{
				return dx_MakeUDPSocket_IPv6_x64( RecvPort );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteUDPSocket", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteUDPSocket_x86( int  NetUDPHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteUDPSocket", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteUDPSocket_x64( int  NetUDPHandle);
		public static int  DeleteUDPSocket( int  NetUDPHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteUDPSocket_x86( NetUDPHandle );
			}
			else
			{
				return dx_DeleteUDPSocket_x64( NetUDPHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkSendUDP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkSendUDP_x86( int  NetUDPHandle, IPDATA  SendIP, int  SendPort, System.IntPtr  Buffer, int  Length);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkSendUDP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkSendUDP_x64( int  NetUDPHandle, IPDATA  SendIP, int  SendPort, System.IntPtr  Buffer, int  Length);
		public static int  NetWorkSendUDP( int  NetUDPHandle, IPDATA  SendIP, int  SendPort, System.IntPtr  Buffer, int  Length)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkSendUDP_x86( NetUDPHandle , SendIP , SendPort , Buffer , Length );
			}
			else
			{
				return dx_NetWorkSendUDP_x64( NetUDPHandle , SendIP , SendPort , Buffer , Length );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkSendUDP_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkSendUDP_IPv6_x86( int  NetUDPHandle, IPDATA_IPv6  SendIP, int  SendPort, System.IntPtr  Buffer, int  Length);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkSendUDP_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_NetWorkSendUDP_IPv6_x64( int  NetUDPHandle, IPDATA_IPv6  SendIP, int  SendPort, System.IntPtr  Buffer, int  Length);
		public static int  NetWorkSendUDP_IPv6( int  NetUDPHandle, IPDATA_IPv6  SendIP, int  SendPort, System.IntPtr  Buffer, int  Length)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkSendUDP_IPv6_x86( NetUDPHandle , SendIP , SendPort , Buffer , Length );
			}
			else
			{
				return dx_NetWorkSendUDP_IPv6_x64( NetUDPHandle , SendIP , SendPort , Buffer , Length );
			}
		}

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkRecvUDP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_NetWorkRecvUDP_x86( int  NetUDPHandle, IPDATA *  RecvIP, int *  RecvPort, System.IntPtr  Buffer, int  Length, int  Peek);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkRecvUDP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_NetWorkRecvUDP_x64( int  NetUDPHandle, IPDATA *  RecvIP, int *  RecvPort, System.IntPtr  Buffer, int  Length, int  Peek);
		public unsafe static int  NetWorkRecvUDP( int  NetUDPHandle, IPDATA *  RecvIP, int *  RecvPort, System.IntPtr  Buffer, int  Length, int  Peek)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkRecvUDP_x86( NetUDPHandle , RecvIP , RecvPort , Buffer , Length , Peek );
			}
			else
			{
				return dx_NetWorkRecvUDP_x64( NetUDPHandle , RecvIP , RecvPort , Buffer , Length , Peek );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_NetWorkRecvUDP_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_NetWorkRecvUDP_IPv6_x86( int  NetUDPHandle, IPDATA_IPv6 *  RecvIP, int *  RecvPort, System.IntPtr  Buffer, int  Length, int  Peek);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_NetWorkRecvUDP_IPv6", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static int  dx_NetWorkRecvUDP_IPv6_x64( int  NetUDPHandle, IPDATA_IPv6 *  RecvIP, int *  RecvPort, System.IntPtr  Buffer, int  Length, int  Peek);
		public unsafe static int  NetWorkRecvUDP_IPv6( int  NetUDPHandle, IPDATA_IPv6 *  RecvIP, int *  RecvPort, System.IntPtr  Buffer, int  Length, int  Peek)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_NetWorkRecvUDP_IPv6_x86( NetUDPHandle , RecvIP , RecvPort , Buffer , Length , Peek );
			}
			else
			{
				return dx_NetWorkRecvUDP_IPv6_x64( NetUDPHandle , RecvIP , RecvPort , Buffer , Length , Peek );
			}
		}
#endif

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckNetWorkRecvUDP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckNetWorkRecvUDP_x86( int  NetUDPHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckNetWorkRecvUDP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckNetWorkRecvUDP_x64( int  NetUDPHandle);
		public static int  CheckNetWorkRecvUDP( int  NetUDPHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckNetWorkRecvUDP_x86( NetUDPHandle );
			}
			else
			{
				return dx_CheckNetWorkRecvUDP_x64( NetUDPHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_StockInputChar", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StockInputChar_x86( char  CharCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_StockInputChar", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StockInputChar_x64( char  CharCode);
		public static int  StockInputChar( char  CharCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_StockInputChar_x86( CharCode );
			}
			else
			{
				return dx_StockInputChar_x64( CharCode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ClearInputCharBuf", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearInputCharBuf_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ClearInputCharBuf", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClearInputCharBuf_x64( );
		public static int  ClearInputCharBuf( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClearInputCharBuf_x86( );
			}
			else
			{
				return dx_ClearInputCharBuf_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetOneChar", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetOneChar_x86( System.Text.StringBuilder  CharBuffer, int  DeleteFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetOneChar", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetOneChar_x64( System.Text.StringBuilder  CharBuffer, int  DeleteFlag);
		public static int  GetOneChar( System.Text.StringBuilder  CharBuffer, int  DeleteFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetOneChar_x86( CharBuffer , DeleteFlag );
			}
			else
			{
				return dx_GetOneChar_x64( CharBuffer , DeleteFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetOneCharWait", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetOneCharWait_x86( System.Text.StringBuilder  CharBuffer, int  DeleteFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetOneCharWait", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetOneCharWait_x64( System.Text.StringBuilder  CharBuffer, int  DeleteFlag);
		public static int  GetOneCharWait( System.Text.StringBuilder  CharBuffer, int  DeleteFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetOneCharWait_x86( CharBuffer , DeleteFlag );
			}
			else
			{
				return dx_GetOneCharWait_x64( CharBuffer , DeleteFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCtrlCodeCmp", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCtrlCodeCmp_x86( char  Char);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCtrlCodeCmp", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCtrlCodeCmp_x64( char  Char);
		public static int  GetCtrlCodeCmp( char  Char)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCtrlCodeCmp_x86( Char );
			}
			else
			{
				return dx_GetCtrlCodeCmp_x64( Char );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawIMEInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawIMEInputString_x86( int  x, int  y, int  SelectStringNum, int  DrawCandidateList);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawIMEInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawIMEInputString_x64( int  x, int  y, int  SelectStringNum, int  DrawCandidateList);
		public static int  DrawIMEInputString( int  x, int  y, int  SelectStringNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawIMEInputString_x86( x , y , SelectStringNum , TRUE );
			}
			else
			{
				return dx_DrawIMEInputString_x64( x , y , SelectStringNum , TRUE );
			}
		}
		public static int  DrawIMEInputString( int  x, int  y, int  SelectStringNum, int  DrawCandidateList)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawIMEInputString_x86( x , y , SelectStringNum , DrawCandidateList );
			}
			else
			{
				return dx_DrawIMEInputString_x64( x , y , SelectStringNum , DrawCandidateList );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawIMEInputExtendString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawIMEInputExtendString_x86( int  x, int  y, double  ExRateX, double  ExRateY, int  SelectStringNum, int  DrawCandidateList);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawIMEInputExtendString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawIMEInputExtendString_x64( int  x, int  y, double  ExRateX, double  ExRateY, int  SelectStringNum, int  DrawCandidateList);
		public static int  DrawIMEInputExtendString( int  x, int  y, double  ExRateX, double  ExRateY, int  SelectStringNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawIMEInputExtendString_x86( x , y , ExRateX , ExRateY , SelectStringNum , TRUE );
			}
			else
			{
				return dx_DrawIMEInputExtendString_x64( x , y , ExRateX , ExRateY , SelectStringNum , TRUE );
			}
		}
		public static int  DrawIMEInputExtendString( int  x, int  y, double  ExRateX, double  ExRateY, int  SelectStringNum, int  DrawCandidateList)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawIMEInputExtendString_x86( x , y , ExRateX , ExRateY , SelectStringNum , DrawCandidateList );
			}
			else
			{
				return dx_DrawIMEInputExtendString_x64( x , y , ExRateX , ExRateY , SelectStringNum , DrawCandidateList );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseIMEFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseIMEFlag_x86( int  UseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseIMEFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseIMEFlag_x64( int  UseFlag);
		public static int  SetUseIMEFlag( int  UseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseIMEFlag_x86( UseFlag );
			}
			else
			{
				return dx_SetUseIMEFlag_x64( UseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseIMEFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseIMEFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseIMEFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseIMEFlag_x64( );
		public static int  GetUseIMEFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseIMEFlag_x86( );
			}
			else
			{
				return dx_GetUseIMEFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetInputStringMaxLengthIMESync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetInputStringMaxLengthIMESync_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetInputStringMaxLengthIMESync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetInputStringMaxLengthIMESync_x64( int  Flag);
		public static int  SetInputStringMaxLengthIMESync( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetInputStringMaxLengthIMESync_x86( Flag );
			}
			else
			{
				return dx_SetInputStringMaxLengthIMESync_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetIMEInputStringMaxLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIMEInputStringMaxLength_x86( int  Length);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetIMEInputStringMaxLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIMEInputStringMaxLength_x64( int  Length);
		public static int  SetIMEInputStringMaxLength( int  Length)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetIMEInputStringMaxLength_x86( Length );
			}
			else
			{
				return dx_SetIMEInputStringMaxLength_x64( Length );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetStringPoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPoint_x86( string  String, int  Point);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetStringPoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPoint_x64( string  String, int  Point);
		public static int  GetStringPoint( string  String, int  Point)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetStringPoint_x86( String , Point );
			}
			else
			{
				return dx_GetStringPoint_x64( String , Point );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetStringPointWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPointWithStrLen_x86( string  String, uint StringLength, int  Point);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetStringPointWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPointWithStrLen_x64( string  String, ulong StringLength, int  Point);
		public static int  GetStringPointWithStrLen( string  String, ulong StringLength, int  Point)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetStringPointWithStrLen_x86( String , ( uint )StringLength , Point );
			}
			else
			{
				return dx_GetStringPointWithStrLen_x64( String , StringLength , Point );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetStringPoint2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPoint2_x86( string  String, int  Point);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetStringPoint2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPoint2_x64( string  String, int  Point);
		public static int  GetStringPoint2( string  String, int  Point)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetStringPoint2_x86( String , Point );
			}
			else
			{
				return dx_GetStringPoint2_x64( String , Point );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetStringPoint2WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPoint2WithStrLen_x86( string  String, uint StringLength, int  Point);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetStringPoint2WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringPoint2WithStrLen_x64( string  String, ulong StringLength, int  Point);
		public static int  GetStringPoint2WithStrLen( string  String, ulong StringLength, int  Point)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetStringPoint2WithStrLen_x86( String , ( uint )StringLength , Point );
			}
			else
			{
				return dx_GetStringPoint2WithStrLen_x64( String , StringLength , Point );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetStringLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringLength_x86( string  String);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetStringLength", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStringLength_x64( string  String);
		public static int  GetStringLength( string  String)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetStringLength_x86( String );
			}
			else
			{
				return dx_GetStringLength_x64( String );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawObtainsString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsString_x86( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawObtainsString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsString_x64( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		public static int  DrawObtainsString( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawObtainsString_x86( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
			else
			{
				return dx_DrawObtainsString_x64( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawObtainsNString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsNString_x86( int  x, int  y, int  AddY, string  String, uint StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawObtainsNString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsNString_x64( int  x, int  y, int  AddY, string  String, ulong StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		public static int  DrawObtainsNString( int  x, int  y, int  AddY, string  String, ulong StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawObtainsNString_x86( x , y , AddY , String , ( uint )StringLength , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
			else
			{
				return dx_DrawObtainsNString_x64( x , y , AddY , String , StringLength , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawObtainsString_CharClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsString_CharClip_x86( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawObtainsString_CharClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsString_CharClip_x64( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		public static int  DrawObtainsString_CharClip( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawObtainsString_CharClip_x86( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
			else
			{
				return dx_DrawObtainsString_CharClip_x64( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawObtainsNString_CharClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsNString_CharClip_x86( int  x, int  y, int  AddY, string  String, uint StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawObtainsNString_CharClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsNString_CharClip_x64( int  x, int  y, int  AddY, string  String, ulong StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		public static int  DrawObtainsNString_CharClip( int  x, int  y, int  AddY, string  String, ulong StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawObtainsNString_CharClip_x86( x , y , AddY , String , ( uint )StringLength , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
			else
			{
				return dx_DrawObtainsNString_CharClip_x64( x , y , AddY , String , StringLength , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawObtainsString_WordClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsString_WordClip_x86( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawObtainsString_WordClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsString_WordClip_x64( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		public static int  DrawObtainsString_WordClip( int  x, int  y, int  AddY, string  String, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawObtainsString_WordClip_x86( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
			else
			{
				return dx_DrawObtainsString_WordClip_x64( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawObtainsNString_WordClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsNString_WordClip_x86( int  x, int  y, int  AddY, string  String, uint StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawObtainsNString_WordClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsNString_WordClip_x64( int  x, int  y, int  AddY, string  String, ulong StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount);
		public static int  DrawObtainsNString_WordClip( int  x, int  y, int  AddY, string  String, ulong StringLength, uint  StrColor, uint  StrEdgeColor, int  FontHandle, uint  SelectBackColor, uint  SelectStrColor, uint  SelectStrEdgeColor, int  SelectStart, int  SelectEnd, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawObtainsNString_WordClip_x86( x , y , AddY , String , ( uint )StringLength , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
			else
			{
				return dx_DrawObtainsNString_WordClip_x64( x , y , AddY , String , StringLength , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , SelectEnd , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetObtainsStringCharPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetObtainsStringCharPosition_x86( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetObtainsStringCharPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetObtainsStringCharPosition_x64( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount);
		public static int  GetObtainsStringCharPosition( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetObtainsStringCharPosition_x86( x , y , AddY , String , StrLen , out PosX , out PosY , FontHandle , out LineCount );
			}
			else
			{
				return dx_GetObtainsStringCharPosition_x64( x , y , AddY , String , StrLen , out PosX , out PosY , FontHandle , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetObtainsStringCharPosition_CharClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetObtainsStringCharPosition_CharClip_x86( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetObtainsStringCharPosition_CharClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetObtainsStringCharPosition_CharClip_x64( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount);
		public static int  GetObtainsStringCharPosition_CharClip( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetObtainsStringCharPosition_CharClip_x86( x , y , AddY , String , StrLen , out PosX , out PosY , FontHandle , out LineCount );
			}
			else
			{
				return dx_GetObtainsStringCharPosition_CharClip_x64( x , y , AddY , String , StrLen , out PosX , out PosY , FontHandle , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetObtainsStringCharPosition_WordClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetObtainsStringCharPosition_WordClip_x86( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetObtainsStringCharPosition_WordClip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetObtainsStringCharPosition_WordClip_x64( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount);
		public static int  GetObtainsStringCharPosition_WordClip( int  x, int  y, int  AddY, string  String, int  StrLen, out int  PosX, out int  PosY, int  FontHandle, out int  LineCount)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetObtainsStringCharPosition_WordClip_x86( x , y , AddY , String , StrLen , out PosX , out PosY , FontHandle , out LineCount );
			}
			else
			{
				return dx_GetObtainsStringCharPosition_WordClip_x64( x , y , AddY , String , StrLen , out PosX , out PosY , FontHandle , out LineCount );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawObtainsBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsBox_x86( int  x1, int  y1, int  x2, int  y2, int  AddY, uint  Color, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawObtainsBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawObtainsBox_x64( int  x1, int  y1, int  x2, int  y2, int  AddY, uint  Color, int  FillFlag);
		public static int  DrawObtainsBox( int  x1, int  y1, int  x2, int  y2, int  AddY, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawObtainsBox_x86( x1 , y1 , x2 , y2 , AddY , Color , FillFlag );
			}
			else
			{
				return dx_DrawObtainsBox_x64( x1 , y1 , x2 , y2 , AddY , Color , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_InputStringToCustom", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InputStringToCustom_x86( int  x, int  y, uint BufLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag, int  EnableNewLineFlag, int  DisplayCandidateList);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_InputStringToCustom", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InputStringToCustom_x64( int  x, int  y, ulong BufLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag, int  EnableNewLineFlag, int  DisplayCandidateList);
		public static int  InputStringToCustom( int  x, int  y, ulong BufLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InputStringToCustom_x86( x , y , ( uint )BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , FALSE , FALSE , TRUE );
			}
			else
			{
				return dx_InputStringToCustom_x64( x , y , BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , FALSE , FALSE , TRUE );
			}
		}
		public static int  InputStringToCustom( int  x, int  y, ulong BufLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InputStringToCustom_x86( x , y , ( uint )BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , FALSE , TRUE );
			}
			else
			{
				return dx_InputStringToCustom_x64( x , y , BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , FALSE , TRUE );
			}
		}
		public static int  InputStringToCustom( int  x, int  y, ulong BufLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag, int  EnableNewLineFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InputStringToCustom_x86( x , y , ( uint )BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , EnableNewLineFlag , TRUE );
			}
			else
			{
				return dx_InputStringToCustom_x64( x , y , BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , EnableNewLineFlag , TRUE );
			}
		}
		public static int  InputStringToCustom( int  x, int  y, ulong BufLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag, int  EnableNewLineFlag, int  DisplayCandidateList)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InputStringToCustom_x86( x , y , ( uint )BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , EnableNewLineFlag , DisplayCandidateList );
			}
			else
			{
				return dx_InputStringToCustom_x64( x , y , BufLength , StrBuffer , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , EnableNewLineFlag , DisplayCandidateList );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_KeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_KeyInputString_x86( int  x, int  y, uint CharMaxLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_KeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_KeyInputString_x64( int  x, int  y, ulong CharMaxLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag);
		public static int  KeyInputString( int  x, int  y, ulong CharMaxLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_KeyInputString_x86( x , y , ( uint )CharMaxLength , StrBuffer , CancelValidFlag );
			}
			else
			{
				return dx_KeyInputString_x64( x , y , CharMaxLength , StrBuffer , CancelValidFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_KeyInputSingleCharString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_KeyInputSingleCharString_x86( int  x, int  y, uint CharMaxLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_KeyInputSingleCharString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_KeyInputSingleCharString_x64( int  x, int  y, ulong CharMaxLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag);
		public static int  KeyInputSingleCharString( int  x, int  y, ulong CharMaxLength, System.Text.StringBuilder  StrBuffer, int  CancelValidFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_KeyInputSingleCharString_x86( x , y , ( uint )CharMaxLength , StrBuffer , CancelValidFlag );
			}
			else
			{
				return dx_KeyInputSingleCharString_x64( x , y , CharMaxLength , StrBuffer , CancelValidFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_KeyInputNumber", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_KeyInputNumber_x86( int  x, int  y, int  MaxNum, int  MinNum, int  CancelValidFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_KeyInputNumber", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_KeyInputNumber_x64( int  x, int  y, int  MaxNum, int  MinNum, int  CancelValidFlag);
		public static int  KeyInputNumber( int  x, int  y, int  MaxNum, int  MinNum, int  CancelValidFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_KeyInputNumber_x86( x , y , MaxNum , MinNum , CancelValidFlag );
			}
			else
			{
				return dx_KeyInputNumber_x64( x , y , MaxNum , MinNum , CancelValidFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetIMEInputModeStr", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetIMEInputModeStr_x86( System.Text.StringBuilder  GetBuffer);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetIMEInputModeStr", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetIMEInputModeStr_x64( System.Text.StringBuilder  GetBuffer);
		public static int  GetIMEInputModeStr( System.Text.StringBuilder  GetBuffer)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetIMEInputModeStr_x86( GetBuffer );
			}
			else
			{
				return dx_GetIMEInputModeStr_x64( GetBuffer );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetIMEInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIMEInputString_x86( string  String);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetIMEInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIMEInputString_x64( string  String);
		public static int  SetIMEInputString( string  String)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetIMEInputString_x86( String );
			}
			else
			{
				return dx_SetIMEInputString_x64( String );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetIMEInputStringWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIMEInputStringWithStrLen_x86( string  String, uint StringLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetIMEInputStringWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIMEInputStringWithStrLen_x64( string  String, ulong StringLength);
		public static int  SetIMEInputStringWithStrLen( string  String, ulong StringLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetIMEInputStringWithStrLen_x86( String , ( uint )StringLength );
			}
			else
			{
				return dx_SetIMEInputStringWithStrLen_x64( String , StringLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputStringColor2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringColor2_x86( int  TargetColor, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputStringColor2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringColor2_x64( int  TargetColor, uint  Color);
		public static int  SetKeyInputStringColor2( int  TargetColor, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringColor2_x86( TargetColor , Color );
			}
			else
			{
				return dx_SetKeyInputStringColor2_x64( TargetColor , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetKeyInputStringColor2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetKeyInputStringColor2_x86( int  TargetColor);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetKeyInputStringColor2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetKeyInputStringColor2_x64( int  TargetColor);
		public static int  ResetKeyInputStringColor2( int  TargetColor)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetKeyInputStringColor2_x86( TargetColor );
			}
			else
			{
				return dx_ResetKeyInputStringColor2_x64( TargetColor );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputStringFont", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringFont_x86( int  FontHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputStringFont", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringFont_x64( int  FontHandle);
		public static int  SetKeyInputStringFont( int  FontHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringFont_x86( FontHandle );
			}
			else
			{
				return dx_SetKeyInputStringFont_x64( FontHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputStringEndCharaMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringEndCharaMode_x86( int  EndCharaMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputStringEndCharaMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringEndCharaMode_x64( int  EndCharaMode);
		public static int  SetKeyInputStringEndCharaMode( int  EndCharaMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringEndCharaMode_x86( EndCharaMode );
			}
			else
			{
				return dx_SetKeyInputStringEndCharaMode_x64( EndCharaMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawKeyInputModeString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawKeyInputModeString_x86( int  x, int  y);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawKeyInputModeString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawKeyInputModeString_x64( int  x, int  y);
		public static int  DrawKeyInputModeString( int  x, int  y)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawKeyInputModeString_x86( x , y );
			}
			else
			{
				return dx_DrawKeyInputModeString_x64( x , y );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_InitKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitKeyInput_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_InitKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitKeyInput_x64( );
		public static int  InitKeyInput( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InitKeyInput_x86( );
			}
			else
			{
				return dx_InitKeyInput_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_MakeKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeKeyInput_x86( uint MaxStrLength, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag, int  EnableNewLineFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MakeKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeKeyInput_x64( ulong MaxStrLength, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag, int  EnableNewLineFlag);
		public static int  MakeKeyInput( ulong MaxStrLength, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeKeyInput_x86( ( uint )MaxStrLength , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , FALSE , FALSE );
			}
			else
			{
				return dx_MakeKeyInput_x64( MaxStrLength , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , FALSE , FALSE );
			}
		}
		public static int  MakeKeyInput( ulong MaxStrLength, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeKeyInput_x86( ( uint )MaxStrLength , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , FALSE );
			}
			else
			{
				return dx_MakeKeyInput_x64( MaxStrLength , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , FALSE );
			}
		}
		public static int  MakeKeyInput( ulong MaxStrLength, int  CancelValidFlag, int  SingleCharOnlyFlag, int  NumCharOnlyFlag, int  DoubleCharOnlyFlag, int  EnableNewLineFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeKeyInput_x86( ( uint )MaxStrLength , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , EnableNewLineFlag );
			}
			else
			{
				return dx_MakeKeyInput_x64( MaxStrLength , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag , DoubleCharOnlyFlag , EnableNewLineFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteKeyInput_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteKeyInput_x64( int  InputHandle);
		public static int  DeleteKeyInput( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteKeyInput_x86( InputHandle );
			}
			else
			{
				return dx_DeleteKeyInput_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetActiveKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetActiveKeyInput_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetActiveKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetActiveKeyInput_x64( int  InputHandle);
		public static int  SetActiveKeyInput( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetActiveKeyInput_x86( InputHandle );
			}
			else
			{
				return dx_SetActiveKeyInput_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetActiveKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetActiveKeyInput_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetActiveKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetActiveKeyInput_x64( );
		public static int  GetActiveKeyInput( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetActiveKeyInput_x86( );
			}
			else
			{
				return dx_GetActiveKeyInput_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckKeyInput_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckKeyInput_x64( int  InputHandle);
		public static int  CheckKeyInput( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckKeyInput_x86( InputHandle );
			}
			else
			{
				return dx_CheckKeyInput_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReStartKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReStartKeyInput_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReStartKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReStartKeyInput_x64( int  InputHandle);
		public static int  ReStartKeyInput( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReStartKeyInput_x86( InputHandle );
			}
			else
			{
				return dx_ReStartKeyInput_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ProcessActKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ProcessActKeyInput_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ProcessActKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ProcessActKeyInput_x64( );
		public static int  ProcessActKeyInput( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ProcessActKeyInput_x86( );
			}
			else
			{
				return dx_ProcessActKeyInput_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawKeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawKeyInputString_x86( int  x, int  y, int  InputHandle, int  DrawCandidateList);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawKeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawKeyInputString_x64( int  x, int  y, int  InputHandle, int  DrawCandidateList);
		public static int  DrawKeyInputString( int  x, int  y, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawKeyInputString_x86( x , y , InputHandle , TRUE );
			}
			else
			{
				return dx_DrawKeyInputString_x64( x , y , InputHandle , TRUE );
			}
		}
		public static int  DrawKeyInputString( int  x, int  y, int  InputHandle, int  DrawCandidateList)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawKeyInputString_x86( x , y , InputHandle , DrawCandidateList );
			}
			else
			{
				return dx_DrawKeyInputString_x64( x , y , InputHandle , DrawCandidateList );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawKeyInputExtendString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawKeyInputExtendString_x86( int  x, int  y, double  ExRateX, double  ExRateY, int  InputHandle, int  DrawCandidateList);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawKeyInputExtendString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawKeyInputExtendString_x64( int  x, int  y, double  ExRateX, double  ExRateY, int  InputHandle, int  DrawCandidateList);
		public static int  DrawKeyInputExtendString( int  x, int  y, double  ExRateX, double  ExRateY, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawKeyInputExtendString_x86( x , y , ExRateX , ExRateY , InputHandle , TRUE );
			}
			else
			{
				return dx_DrawKeyInputExtendString_x64( x , y , ExRateX , ExRateY , InputHandle , TRUE );
			}
		}
		public static int  DrawKeyInputExtendString( int  x, int  y, double  ExRateX, double  ExRateY, int  InputHandle, int  DrawCandidateList)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawKeyInputExtendString_x86( x , y , ExRateX , ExRateY , InputHandle , DrawCandidateList );
			}
			else
			{
				return dx_DrawKeyInputExtendString_x64( x , y , ExRateX , ExRateY , InputHandle , DrawCandidateList );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputDrawArea_x86( int  x1, int  y1, int  x2, int  y2, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputDrawArea_x64( int  x1, int  y1, int  x2, int  y2, int  InputHandle);
		public static int  SetKeyInputDrawArea( int  x1, int  y1, int  x2, int  y2, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputDrawArea_x86( x1 , y1 , x2 , y2 , InputHandle );
			}
			else
			{
				return dx_SetKeyInputDrawArea_x64( x1 , y1 , x2 , y2 , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputSelectArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputSelectArea_x86( int  SelectStart, int  SelectEnd, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputSelectArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputSelectArea_x64( int  SelectStart, int  SelectEnd, int  InputHandle);
		public static int  SetKeyInputSelectArea( int  SelectStart, int  SelectEnd, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputSelectArea_x86( SelectStart , SelectEnd , InputHandle );
			}
			else
			{
				return dx_SetKeyInputSelectArea_x64( SelectStart , SelectEnd , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetKeyInputSelectArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputSelectArea_x86( out int  SelectStart, out int  SelectEnd, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetKeyInputSelectArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputSelectArea_x64( out int  SelectStart, out int  SelectEnd, int  InputHandle);
		public static int  GetKeyInputSelectArea( out int  SelectStart, out int  SelectEnd, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetKeyInputSelectArea_x86( out SelectStart , out SelectEnd , InputHandle );
			}
			else
			{
				return dx_GetKeyInputSelectArea_x64( out SelectStart , out SelectEnd , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputDrawStartPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputDrawStartPos_x86( int  DrawStartPos, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputDrawStartPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputDrawStartPos_x64( int  DrawStartPos, int  InputHandle);
		public static int  SetKeyInputDrawStartPos( int  DrawStartPos, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputDrawStartPos_x86( DrawStartPos , InputHandle );
			}
			else
			{
				return dx_SetKeyInputDrawStartPos_x64( DrawStartPos , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetKeyInputDrawStartPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputDrawStartPos_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetKeyInputDrawStartPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputDrawStartPos_x64( int  InputHandle);
		public static int  GetKeyInputDrawStartPos( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetKeyInputDrawStartPos_x86( InputHandle );
			}
			else
			{
				return dx_GetKeyInputDrawStartPos_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputCursorBrinkTime", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputCursorBrinkTime_x86( int  Time);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputCursorBrinkTime", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputCursorBrinkTime_x64( int  Time);
		public static int  SetKeyInputCursorBrinkTime( int  Time)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputCursorBrinkTime_x86( Time );
			}
			else
			{
				return dx_SetKeyInputCursorBrinkTime_x64( Time );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputCursorBrinkFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputCursorBrinkFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputCursorBrinkFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputCursorBrinkFlag_x64( int  Flag);
		public static int  SetKeyInputCursorBrinkFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputCursorBrinkFlag_x86( Flag );
			}
			else
			{
				return dx_SetKeyInputCursorBrinkFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputString_x86( string  String, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputString_x64( string  String, int  InputHandle);
		public static int  SetKeyInputString( string  String, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputString_x86( String , InputHandle );
			}
			else
			{
				return dx_SetKeyInputString_x64( String , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputStringWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringWithStrLen_x86( string  String, uint StringLength, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputStringWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputStringWithStrLen_x64( string  String, ulong StringLength, int  InputHandle);
		public static int  SetKeyInputStringWithStrLen( string  String, ulong StringLength, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputStringWithStrLen_x86( String , ( uint )StringLength , InputHandle );
			}
			else
			{
				return dx_SetKeyInputStringWithStrLen_x64( String , StringLength , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputNumber", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputNumber_x86( int  Number, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputNumber", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputNumber_x64( int  Number, int  InputHandle);
		public static int  SetKeyInputNumber( int  Number, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputNumber_x86( Number , InputHandle );
			}
			else
			{
				return dx_SetKeyInputNumber_x64( Number , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputNumberToFloat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputNumberToFloat_x86( float  Number, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputNumberToFloat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputNumberToFloat_x64( float  Number, int  InputHandle);
		public static int  SetKeyInputNumberToFloat( float  Number, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputNumberToFloat_x86( Number , InputHandle );
			}
			else
			{
				return dx_SetKeyInputNumberToFloat_x64( Number , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetKeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputString_x86( System.Text.StringBuilder  StrBuffer, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetKeyInputString", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputString_x64( System.Text.StringBuilder  StrBuffer, int  InputHandle);
		public static int  GetKeyInputString( System.Text.StringBuilder  StrBuffer, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetKeyInputString_x86( StrBuffer , InputHandle );
			}
			else
			{
				return dx_GetKeyInputString_x64( StrBuffer , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetKeyInputNumber", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputNumber_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetKeyInputNumber", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputNumber_x64( int  InputHandle);
		public static int  GetKeyInputNumber( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetKeyInputNumber_x86( InputHandle );
			}
			else
			{
				return dx_GetKeyInputNumber_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetKeyInputNumberToFloat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetKeyInputNumberToFloat_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetKeyInputNumberToFloat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetKeyInputNumberToFloat_x64( int  InputHandle);
		public static float  GetKeyInputNumberToFloat( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetKeyInputNumberToFloat_x86( InputHandle );
			}
			else
			{
				return dx_GetKeyInputNumberToFloat_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetKeyInputCursorPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputCursorPosition_x86( int  Position, int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetKeyInputCursorPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetKeyInputCursorPosition_x64( int  Position, int  InputHandle);
		public static int  SetKeyInputCursorPosition( int  Position, int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetKeyInputCursorPosition_x86( Position , InputHandle );
			}
			else
			{
				return dx_SetKeyInputCursorPosition_x64( Position , InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetKeyInputCursorPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputCursorPosition_x86( int  InputHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetKeyInputCursorPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetKeyInputCursorPosition_x64( int  InputHandle);
		public static int  GetKeyInputCursorPosition( int  InputHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetKeyInputCursorPosition_x86( InputHandle );
			}
			else
			{
				return dx_GetKeyInputCursorPosition_x64( InputHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_open", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_open_x86( string  FilePath, int  ASync);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_open", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_open_x64( string  FilePath, int  ASync);
		public static int  FileRead_open( string  FilePath)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_open_x86( FilePath , FALSE );
			}
			else
			{
				return dx_FileRead_open_x64( FilePath , FALSE );
			}
		}
		public static int  FileRead_open( string  FilePath, int  ASync)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_open_x86( FilePath , ASync );
			}
			else
			{
				return dx_FileRead_open_x64( FilePath , ASync );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_open_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_open_WithStrLen_x86( string  FilePath, uint FilePathLength, int  ASync);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_open_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_open_WithStrLen_x64( string  FilePath, ulong FilePathLength, int  ASync);
		public static int  FileRead_open_WithStrLen( string  FilePath, ulong FilePathLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_open_WithStrLen_x86( FilePath , ( uint )FilePathLength , FALSE );
			}
			else
			{
				return dx_FileRead_open_WithStrLen_x64( FilePath , FilePathLength , FALSE );
			}
		}
		public static int  FileRead_open_WithStrLen( string  FilePath, ulong FilePathLength, int  ASync)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_open_WithStrLen_x86( FilePath , ( uint )FilePathLength , ASync );
			}
			else
			{
				return dx_FileRead_open_WithStrLen_x64( FilePath , FilePathLength , ASync );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_open_mem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_open_mem_x86( System.IntPtr  FileImage, uint FileImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_open_mem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_open_mem_x64( System.IntPtr  FileImage, ulong FileImageSize);
		public static int  FileRead_open_mem( System.IntPtr  FileImage, ulong FileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_open_mem_x86( FileImage , ( uint )FileImageSize );
			}
			else
			{
				return dx_FileRead_open_mem_x64( FileImage , FileImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_size", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_size_x86( string  FilePath);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_size", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_size_x64( string  FilePath);
		public static long  FileRead_size( string  FilePath)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_size_x86( FilePath );
			}
			else
			{
				return dx_FileRead_size_x64( FilePath );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_size_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_size_WithStrLen_x86( string  FilePath, uint FilePathLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_size_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_size_WithStrLen_x64( string  FilePath, ulong FilePathLength);
		public static long  FileRead_size_WithStrLen( string  FilePath, ulong FilePathLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_size_WithStrLen_x86( FilePath , ( uint )FilePathLength );
			}
			else
			{
				return dx_FileRead_size_WithStrLen_x64( FilePath , FilePathLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_size_handle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_size_handle_x86( int  FileHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_size_handle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_size_handle_x64( int  FileHandle);
		public static long  FileRead_size_handle( int  FileHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_size_handle_x86( FileHandle );
			}
			else
			{
				return dx_FileRead_size_handle_x64( FileHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_close", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_close_x86( int  FileHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_close", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_close_x64( int  FileHandle);
		public static int  FileRead_close( int  FileHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_close_x86( FileHandle );
			}
			else
			{
				return dx_FileRead_close_x64( FileHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_tell", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_tell_x86( int  FileHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_tell", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_tell_x64( int  FileHandle);
		public static long  FileRead_tell( int  FileHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_tell_x86( FileHandle );
			}
			else
			{
				return dx_FileRead_tell_x64( FileHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_seek", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_seek_x86( int  FileHandle, long  Offset, int  Origin);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_seek", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_seek_x64( int  FileHandle, long  Offset, int  Origin);
		public static int  FileRead_seek( int  FileHandle, long  Offset, int  Origin)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_seek_x86( FileHandle , Offset , Origin );
			}
			else
			{
				return dx_FileRead_seek_x64( FileHandle , Offset , Origin );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_read", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_read_x86( System.IntPtr  Buffer, int  ReadSize, int  FileHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_read", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_read_x64( System.IntPtr  Buffer, int  ReadSize, int  FileHandle);
		public static int  FileRead_read( System.IntPtr  Buffer, int  ReadSize, int  FileHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_read_x86( Buffer , ReadSize , FileHandle );
			}
			else
			{
				return dx_FileRead_read_x64( Buffer , ReadSize , FileHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_idle_chk", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_idle_chk_x86( int  FileHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_idle_chk", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_idle_chk_x64( int  FileHandle);
		public static int  FileRead_idle_chk( int  FileHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_idle_chk_x86( FileHandle );
			}
			else
			{
				return dx_FileRead_idle_chk_x64( FileHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_eof", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_eof_x86( int  FileHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_eof", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_eof_x64( int  FileHandle);
		public static int  FileRead_eof( int  FileHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_eof_x86( FileHandle );
			}
			else
			{
				return dx_FileRead_eof_x64( FileHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_set_format", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_set_format_x86( int  FileHandle, int  CharCodeFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_set_format", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_set_format_x64( int  FileHandle, int  CharCodeFormat);
		public static int  FileRead_set_format( int  FileHandle, int  CharCodeFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_set_format_x86( FileHandle , CharCodeFormat );
			}
			else
			{
				return dx_FileRead_set_format_x64( FileHandle , CharCodeFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_gets", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_gets_x86( System.Text.StringBuilder  Buffer, int  BufferSize, int  FileHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_gets", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_gets_x64( System.Text.StringBuilder  Buffer, int  BufferSize, int  FileHandle);
		public static int  FileRead_gets( System.Text.StringBuilder  Buffer, int  BufferSize, int  FileHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_gets_x86( Buffer , BufferSize , FileHandle );
			}
			else
			{
				return dx_FileRead_gets_x64( Buffer , BufferSize , FileHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_createInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_FileRead_createInfo_x86( string  ObjectPath);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_createInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_FileRead_createInfo_x64( string  ObjectPath);
		public static uint  FileRead_createInfo( string  ObjectPath)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_createInfo_x86( ObjectPath );
			}
			else
			{
				return dx_FileRead_createInfo_x64( ObjectPath );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_createInfo_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_FileRead_createInfo_WithStrLen_x86( string  ObjectPath, uint ObjectPathLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_createInfo_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_FileRead_createInfo_WithStrLen_x64( string  ObjectPath, ulong ObjectPathLength);
		public static uint  FileRead_createInfo_WithStrLen( string  ObjectPath, ulong ObjectPathLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_createInfo_WithStrLen_x86( ObjectPath , ( uint )ObjectPathLength );
			}
			else
			{
				return dx_FileRead_createInfo_WithStrLen_x64( ObjectPath , ObjectPathLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_getInfoNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_getInfoNum_x86( uint  FileInfoHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_getInfoNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_getInfoNum_x64( uint  FileInfoHandle);
		public static int  FileRead_getInfoNum( uint  FileInfoHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_getInfoNum_x86( FileInfoHandle );
			}
			else
			{
				return dx_FileRead_getInfoNum_x64( FileInfoHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_deleteInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_deleteInfo_x86( uint  FileInfoHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_deleteInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_deleteInfo_x64( uint  FileInfoHandle);
		public static int  FileRead_deleteInfo( uint  FileInfoHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_deleteInfo_x86( FileInfoHandle );
			}
			else
			{
				return dx_FileRead_deleteInfo_x64( FileInfoHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_fullyLoad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_fullyLoad_x86( string  FilePath);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_fullyLoad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_fullyLoad_x64( string  FilePath);
		public static int  FileRead_fullyLoad( string  FilePath)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_fullyLoad_x86( FilePath );
			}
			else
			{
				return dx_FileRead_fullyLoad_x64( FilePath );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_fullyLoad_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_fullyLoad_WithStrLen_x86( string  FilePath, uint FilePathLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_fullyLoad_WithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_fullyLoad_WithStrLen_x64( string  FilePath, ulong FilePathLength);
		public static int  FileRead_fullyLoad_WithStrLen( string  FilePath, ulong FilePathLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_fullyLoad_WithStrLen_x86( FilePath , ( uint )FilePathLength );
			}
			else
			{
				return dx_FileRead_fullyLoad_WithStrLen_x64( FilePath , FilePathLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_fullyLoad_delete", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_fullyLoad_delete_x86( int  FLoadHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_fullyLoad_delete", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FileRead_fullyLoad_delete_x64( int  FLoadHandle);
		public static int  FileRead_fullyLoad_delete( int  FLoadHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_fullyLoad_delete_x86( FLoadHandle );
			}
			else
			{
				return dx_FileRead_fullyLoad_delete_x64( FLoadHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_fullyLoad_getImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_FileRead_fullyLoad_getImage_x86( int  FLoadHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_fullyLoad_getImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_FileRead_fullyLoad_getImage_x64( int  FLoadHandle);
		public static System.IntPtr  FileRead_fullyLoad_getImage( int  FLoadHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_fullyLoad_getImage_x86( FLoadHandle );
			}
			else
			{
				return dx_FileRead_fullyLoad_getImage_x64( FLoadHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FileRead_fullyLoad_getSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_fullyLoad_getSize_x86( int  FLoadHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FileRead_fullyLoad_getSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static long  dx_FileRead_fullyLoad_getSize_x64( int  FLoadHandle);
		public static long  FileRead_fullyLoad_getSize( int  FLoadHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FileRead_fullyLoad_getSize_x86( FLoadHandle );
			}
			else
			{
				return dx_FileRead_fullyLoad_getSize_x64( FLoadHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetStreamFunctionDefault", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStreamFunctionDefault_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetStreamFunctionDefault", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetStreamFunctionDefault_x64( );
		public static int  GetStreamFunctionDefault( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetStreamFunctionDefault_x86( );
			}
			else
			{
				return dx_GetStreamFunctionDefault_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvertFullPath", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConvertFullPath_x86( string  Src, System.Text.StringBuilder  Dest, string  CurrentDir);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvertFullPath", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConvertFullPath_x64( string  Src, System.Text.StringBuilder  Dest, string  CurrentDir);
		public static int  ConvertFullPath( string  Src, System.Text.StringBuilder  Dest)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvertFullPath_x86( Src , Dest , null );
			}
			else
			{
				return dx_ConvertFullPath_x64( Src , Dest , null );
			}
		}
		public static int  ConvertFullPath( string  Src, System.Text.StringBuilder  Dest, string  CurrentDir)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvertFullPath_x86( Src , Dest , CurrentDir );
			}
			else
			{
				return dx_ConvertFullPath_x64( Src , Dest , CurrentDir );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvertFullPathWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConvertFullPathWithStrLen_x86( string  Src, uint SrcLength, System.Text.StringBuilder  Dest, string  CurrentDir, uint CurrentDirLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvertFullPathWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ConvertFullPathWithStrLen_x64( string  Src, ulong SrcLength, System.Text.StringBuilder  Dest, string  CurrentDir, ulong CurrentDirLength);
		public static int  ConvertFullPathWithStrLen( string  Src, ulong SrcLength, System.Text.StringBuilder  Dest)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvertFullPathWithStrLen_x86( Src , ( uint )SrcLength , Dest , null , ( uint )0 );
			}
			else
			{
				return dx_ConvertFullPathWithStrLen_x64( Src , SrcLength , Dest , null , 0 );
			}
		}
		public static int  ConvertFullPathWithStrLen( string  Src, ulong SrcLength, System.Text.StringBuilder  Dest, string  CurrentDir)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvertFullPathWithStrLen_x86( Src , ( uint )SrcLength , Dest , CurrentDir , ( uint )0 );
			}
			else
			{
				return dx_ConvertFullPathWithStrLen_x64( Src , SrcLength , Dest , CurrentDir , 0 );
			}
		}
		public static int  ConvertFullPathWithStrLen( string  Src, ulong SrcLength, System.Text.StringBuilder  Dest, string  CurrentDir, ulong CurrentDirLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvertFullPathWithStrLen_x86( Src , ( uint )SrcLength , Dest , CurrentDir , ( uint )CurrentDirLength );
			}
			else
			{
				return dx_ConvertFullPathWithStrLen_x64( Src , SrcLength , Dest , CurrentDir , CurrentDirLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckHitKey", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckHitKey_x86( int  KeyCode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckHitKey", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckHitKey_x64( int  KeyCode);
		public static int  CheckHitKey( int  KeyCode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckHitKey_x86( KeyCode );
			}
			else
			{
				return dx_CheckHitKey_x64( KeyCode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckHitKeyAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckHitKeyAll_x86( int  CheckType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckHitKeyAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckHitKeyAll_x64( int  CheckType);
		public static int  CheckHitKeyAll( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckHitKeyAll_x86( DX_CHECKINPUT_ALL );
			}
			else
			{
				return dx_CheckHitKeyAll_x64( DX_CHECKINPUT_ALL );
			}
		}
		public static int  CheckHitKeyAll( int  CheckType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckHitKeyAll_x86( CheckType );
			}
			else
			{
				return dx_CheckHitKeyAll_x64( CheckType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetHitKeyStateAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHitKeyStateAll_x86( [In, Out] byte[]  KeyStateArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHitKeyStateAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHitKeyStateAll_x64( [In, Out] byte[]  KeyStateArray);
		public static int  GetHitKeyStateAll( [In, Out] byte[]  KeyStateArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHitKeyStateAll_x86( KeyStateArray );
			}
			else
			{
				return dx_GetHitKeyStateAll_x64( KeyStateArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetHitKeyStateAllEx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHitKeyStateAllEx_x86( [In, Out] int[]  KeyStateArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetHitKeyStateAllEx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetHitKeyStateAllEx_x64( [In, Out] int[]  KeyStateArray);
		public static int  GetHitKeyStateAllEx( [In, Out] int[]  KeyStateArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetHitKeyStateAllEx_x86( KeyStateArray );
			}
			else
			{
				return dx_GetHitKeyStateAllEx_x64( KeyStateArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadNum_x64( );
		public static int  GetJoypadNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadNum_x86( );
			}
			else
			{
				return dx_GetJoypadNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadButtonNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadButtonNum_x86( int  InputType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadButtonNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadButtonNum_x64( int  InputType);
		public static int  GetJoypadButtonNum( int  InputType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadButtonNum_x86( InputType );
			}
			else
			{
				return dx_GetJoypadButtonNum_x64( InputType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadInputState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadInputState_x86( int  InputType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadInputState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadInputState_x64( int  InputType);
		public static int  GetJoypadInputState( int  InputType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadInputState_x86( InputType );
			}
			else
			{
				return dx_GetJoypadInputState_x64( InputType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadAnalogInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadAnalogInput_x86( out int  XBuf, out int  YBuf, int  InputType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadAnalogInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadAnalogInput_x64( out int  XBuf, out int  YBuf, int  InputType);
		public static int  GetJoypadAnalogInput( out int  XBuf, out int  YBuf, int  InputType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadAnalogInput_x86( out XBuf , out YBuf , InputType );
			}
			else
			{
				return dx_GetJoypadAnalogInput_x64( out XBuf , out YBuf , InputType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadAnalogInputRight", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadAnalogInputRight_x86( out int  XBuf, out int  YBuf, int  InputType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadAnalogInputRight", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadAnalogInputRight_x64( out int  XBuf, out int  YBuf, int  InputType);
		public static int  GetJoypadAnalogInputRight( out int  XBuf, out int  YBuf, int  InputType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadAnalogInputRight_x86( out XBuf , out YBuf , InputType );
			}
			else
			{
				return dx_GetJoypadAnalogInputRight_x64( out XBuf , out YBuf , InputType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadDirectInputState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadDirectInputState_x86( int  InputType, out DINPUT_JOYSTATE  DInputState);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadDirectInputState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadDirectInputState_x64( int  InputType, out DINPUT_JOYSTATE  DInputState);
		public static int  GetJoypadDirectInputState( int  InputType, out DINPUT_JOYSTATE  DInputState)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadDirectInputState_x86( InputType , out DInputState );
			}
			else
			{
				return dx_GetJoypadDirectInputState_x64( InputType , out DInputState );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckJoypadXInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckJoypadXInput_x86( int  InputType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckJoypadXInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckJoypadXInput_x64( int  InputType);
		public static int  CheckJoypadXInput( int  InputType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckJoypadXInput_x86( InputType );
			}
			else
			{
				return dx_CheckJoypadXInput_x64( InputType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadType", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadType_x86( int  InputType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadType", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadType_x64( int  InputType);
		public static int  GetJoypadType( int  InputType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadType_x86( InputType );
			}
			else
			{
				return dx_GetJoypadType_x64( InputType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadXInputState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadXInputState_x86( int  InputType, out XINPUT_STATE  XInputState);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadXInputState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadXInputState_x64( int  InputType, out XINPUT_STATE  XInputState);
		public static int  GetJoypadXInputState( int  InputType, out XINPUT_STATE  XInputState)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadXInputState_x86( InputType , out XInputState );
			}
			else
			{
				return dx_GetJoypadXInputState_x64( InputType , out XInputState );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetJoypadInputToKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetJoypadInputToKeyInput_x86( int  InputType, int  PadInput, int  KeyInput1, int  KeyInput2, int  KeyInput3, int  KeyInput4);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetJoypadInputToKeyInput", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetJoypadInputToKeyInput_x64( int  InputType, int  PadInput, int  KeyInput1, int  KeyInput2, int  KeyInput3, int  KeyInput4);
		public static int  SetJoypadInputToKeyInput( int  InputType, int  PadInput, int  KeyInput1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetJoypadInputToKeyInput_x86( InputType , PadInput , KeyInput1 , -1 , -1 , -1 );
			}
			else
			{
				return dx_SetJoypadInputToKeyInput_x64( InputType , PadInput , KeyInput1 , -1 , -1 , -1 );
			}
		}
		public static int  SetJoypadInputToKeyInput( int  InputType, int  PadInput, int  KeyInput1, int  KeyInput2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetJoypadInputToKeyInput_x86( InputType , PadInput , KeyInput1 , KeyInput2 , -1 , -1 );
			}
			else
			{
				return dx_SetJoypadInputToKeyInput_x64( InputType , PadInput , KeyInput1 , KeyInput2 , -1 , -1 );
			}
		}
		public static int  SetJoypadInputToKeyInput( int  InputType, int  PadInput, int  KeyInput1, int  KeyInput2, int  KeyInput3)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetJoypadInputToKeyInput_x86( InputType , PadInput , KeyInput1 , KeyInput2 , KeyInput3 , -1 );
			}
			else
			{
				return dx_SetJoypadInputToKeyInput_x64( InputType , PadInput , KeyInput1 , KeyInput2 , KeyInput3 , -1 );
			}
		}
		public static int  SetJoypadInputToKeyInput( int  InputType, int  PadInput, int  KeyInput1, int  KeyInput2, int  KeyInput3, int  KeyInput4)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetJoypadInputToKeyInput_x86( InputType , PadInput , KeyInput1 , KeyInput2 , KeyInput3 , KeyInput4 );
			}
			else
			{
				return dx_SetJoypadInputToKeyInput_x64( InputType , PadInput , KeyInput1 , KeyInput2 , KeyInput3 , KeyInput4 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetJoypadDeadZone", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetJoypadDeadZone_x86( int  InputType, double  Zone);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetJoypadDeadZone", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetJoypadDeadZone_x64( int  InputType, double  Zone);
		public static int  SetJoypadDeadZone( int  InputType, double  Zone)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetJoypadDeadZone_x86( InputType , Zone );
			}
			else
			{
				return dx_SetJoypadDeadZone_x64( InputType , Zone );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetJoypadDefaultDeadZoneAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetJoypadDefaultDeadZoneAll_x86( double  Zone);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetJoypadDefaultDeadZoneAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetJoypadDefaultDeadZoneAll_x64( double  Zone);
		public static int  SetJoypadDefaultDeadZoneAll( double  Zone)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetJoypadDefaultDeadZoneAll_x86( Zone );
			}
			else
			{
				return dx_SetJoypadDefaultDeadZoneAll_x64( Zone );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_StartJoypadVibration", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StartJoypadVibration_x86( int  InputType, int  Power, int  Time, int  EffectIndex);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_StartJoypadVibration", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StartJoypadVibration_x64( int  InputType, int  Power, int  Time, int  EffectIndex);
		public static int  StartJoypadVibration( int  InputType, int  Power, int  Time)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_StartJoypadVibration_x86( InputType , Power , Time , -1 );
			}
			else
			{
				return dx_StartJoypadVibration_x64( InputType , Power , Time , -1 );
			}
		}
		public static int  StartJoypadVibration( int  InputType, int  Power, int  Time, int  EffectIndex)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_StartJoypadVibration_x86( InputType , Power , Time , EffectIndex );
			}
			else
			{
				return dx_StartJoypadVibration_x64( InputType , Power , Time , EffectIndex );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_StopJoypadVibration", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StopJoypadVibration_x86( int  InputType, int  EffectIndex);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_StopJoypadVibration", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_StopJoypadVibration_x64( int  InputType, int  EffectIndex);
		public static int  StopJoypadVibration( int  InputType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_StopJoypadVibration_x86( InputType , -1 );
			}
			else
			{
				return dx_StopJoypadVibration_x64( InputType , -1 );
			}
		}
		public static int  StopJoypadVibration( int  InputType, int  EffectIndex)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_StopJoypadVibration_x86( InputType , EffectIndex );
			}
			else
			{
				return dx_StopJoypadVibration_x64( InputType , EffectIndex );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetJoypadPOVState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadPOVState_x86( int  InputType, int  POVNumber);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetJoypadPOVState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetJoypadPOVState_x64( int  InputType, int  POVNumber);
		public static int  GetJoypadPOVState( int  InputType, int  POVNumber)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetJoypadPOVState_x86( InputType , POVNumber );
			}
			else
			{
				return dx_GetJoypadPOVState_x64( InputType , POVNumber );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReSetupJoypad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReSetupJoypad_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReSetupJoypad", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReSetupJoypad_x64( );
		public static int  ReSetupJoypad( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReSetupJoypad_x86( );
			}
			else
			{
				return dx_ReSetupJoypad_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReSetupInputSystem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReSetupInputSystem_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReSetupInputSystem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReSetupInputSystem_x64( );
		public static int  ReSetupInputSystem( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReSetupInputSystem_x86( );
			}
			else
			{
				return dx_ReSetupInputSystem_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseJoypadVibrationFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseJoypadVibrationFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseJoypadVibrationFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseJoypadVibrationFlag_x64( int  Flag);
		public static int  SetUseJoypadVibrationFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseJoypadVibrationFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseJoypadVibrationFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_MakeGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeGraph_x86( int  SizeX, int  SizeY, int  NotUse3DFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MakeGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeGraph_x64( int  SizeX, int  SizeY, int  NotUse3DFlag);
		public static int  MakeGraph( int  SizeX, int  SizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeGraph_x86( SizeX , SizeY , FALSE );
			}
			else
			{
				return dx_MakeGraph_x64( SizeX , SizeY , FALSE );
			}
		}
		public static int  MakeGraph( int  SizeX, int  SizeY, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeGraph_x86( SizeX , SizeY , NotUse3DFlag );
			}
			else
			{
				return dx_MakeGraph_x64( SizeX , SizeY , NotUse3DFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_MakeScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeScreen_x86( int  SizeX, int  SizeY, int  UseAlphaChannel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MakeScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeScreen_x64( int  SizeX, int  SizeY, int  UseAlphaChannel);
		public static int  MakeScreen( int  SizeX, int  SizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeScreen_x86( SizeX , SizeY , FALSE );
			}
			else
			{
				return dx_MakeScreen_x64( SizeX , SizeY , FALSE );
			}
		}
		public static int  MakeScreen( int  SizeX, int  SizeY, int  UseAlphaChannel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeScreen_x86( SizeX , SizeY , UseAlphaChannel );
			}
			else
			{
				return dx_MakeScreen_x64( SizeX , SizeY , UseAlphaChannel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DerivationGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DerivationGraph_x86( int  SrcX, int  SrcY, int  Width, int  Height, int  SrcGraphHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DerivationGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DerivationGraph_x64( int  SrcX, int  SrcY, int  Width, int  Height, int  SrcGraphHandle);
		public static int  DerivationGraph( int  SrcX, int  SrcY, int  Width, int  Height, int  SrcGraphHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DerivationGraph_x86( SrcX , SrcY , Width , Height , SrcGraphHandle );
			}
			else
			{
				return dx_DerivationGraph_x64( SrcX , SrcY , Width , Height , SrcGraphHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DerivationGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DerivationGraphF_x86( float  SrcX, float  SrcY, float  Width, float  Height, int  SrcGraphHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DerivationGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DerivationGraphF_x64( float  SrcX, float  SrcY, float  Width, float  Height, int  SrcGraphHandle);
		public static int  DerivationGraphF( float  SrcX, float  SrcY, float  Width, float  Height, int  SrcGraphHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DerivationGraphF_x86( SrcX , SrcY , Width , Height , SrcGraphHandle );
			}
			else
			{
				return dx_DerivationGraphF_x64( SrcX , SrcY , Width , Height , SrcGraphHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteGraph_x86( int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteGraph_x64( int  GrHandle);
		public static int  DeleteGraph( int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteGraph_x86( GrHandle );
			}
			else
			{
				return dx_DeleteGraph_x64( GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteSharingGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteSharingGraph_x86( int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteSharingGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteSharingGraph_x64( int  GrHandle);
		public static int  DeleteSharingGraph( int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteSharingGraph_x86( GrHandle );
			}
			else
			{
				return dx_DeleteSharingGraph_x64( GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphNum_x64( );
		public static int  GetGraphNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphNum_x86( );
			}
			else
			{
				return dx_GetGraphNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FillGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FillGraph_x86( int  GrHandle, int  Red, int  Green, int  Blue, int  Alpha);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FillGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FillGraph_x64( int  GrHandle, int  Red, int  Green, int  Blue, int  Alpha);
		public static int  FillGraph( int  GrHandle, int  Red, int  Green, int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FillGraph_x86( GrHandle , Red , Green , Blue , 255 );
			}
			else
			{
				return dx_FillGraph_x64( GrHandle , Red , Green , Blue , 255 );
			}
		}
		public static int  FillGraph( int  GrHandle, int  Red, int  Green, int  Blue, int  Alpha)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FillGraph_x86( GrHandle , Red , Green , Blue , Alpha );
			}
			else
			{
				return dx_FillGraph_x64( GrHandle , Red , Green , Blue , Alpha );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_FillRectGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FillRectGraph_x86( int  GrHandle, int  x, int  y, int  Width, int  Height, int  Red, int  Green, int  Blue, int  Alpha);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_FillRectGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_FillRectGraph_x64( int  GrHandle, int  x, int  y, int  Width, int  Height, int  Red, int  Green, int  Blue, int  Alpha);
		public static int  FillRectGraph( int  GrHandle, int  x, int  y, int  Width, int  Height, int  Red, int  Green, int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FillRectGraph_x86( GrHandle , x , y , Width , Height , Red , Green , Blue , 255 );
			}
			else
			{
				return dx_FillRectGraph_x64( GrHandle , x , y , Width , Height , Red , Green , Blue , 255 );
			}
		}
		public static int  FillRectGraph( int  GrHandle, int  x, int  y, int  Width, int  Height, int  Red, int  Green, int  Blue, int  Alpha)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_FillRectGraph_x86( GrHandle , x , y , Width , Height , Red , Green , Blue , Alpha );
			}
			else
			{
				return dx_FillRectGraph_x64( GrHandle , x , y , Width , Height , Red , Green , Blue , Alpha );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetGraphLostFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphLostFlag_x86( int  GrHandle, out int  LostFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetGraphLostFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphLostFlag_x64( int  GrHandle, out int  LostFlag);
		public static int  SetGraphLostFlag( int  GrHandle, out int  LostFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetGraphLostFlag_x86( GrHandle , out LostFlag );
			}
			else
			{
				return dx_SetGraphLostFlag_x64( GrHandle , out LostFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_InitGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitGraph_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_InitGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitGraph_x64( );
		public static int  InitGraph( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InitGraph_x86( );
			}
			else
			{
				return dx_InitGraph_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadFileGraphAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadFileGraphAll_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadFileGraphAll", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadFileGraphAll_x64( );
		public static int  ReloadFileGraphAll( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadFileGraphAll_x86( );
			}
			else
			{
				return dx_ReloadFileGraphAll_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_MakeShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeShadowMap_x86( int  SizeX, int  SizeY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_MakeShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_MakeShadowMap_x64( int  SizeX, int  SizeY);
		public static int  MakeShadowMap( int  SizeX, int  SizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_MakeShadowMap_x86( SizeX , SizeY );
			}
			else
			{
				return dx_MakeShadowMap_x64( SizeX , SizeY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteShadowMap_x86( int  SmHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteShadowMap_x64( int  SmHandle);
		public static int  DeleteShadowMap( int  SmHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteShadowMap_x86( SmHandle );
			}
			else
			{
				return dx_DeleteShadowMap_x64( SmHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetShadowMapLightDirection", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetShadowMapLightDirection_x86( int  SmHandle, VECTOR  Direction);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetShadowMapLightDirection", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetShadowMapLightDirection_x64( int  SmHandle, VECTOR  Direction);
		public static int  SetShadowMapLightDirection( int  SmHandle, VECTOR  Direction)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetShadowMapLightDirection_x86( SmHandle , Direction );
			}
			else
			{
				return dx_SetShadowMapLightDirection_x64( SmHandle , Direction );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ShadowMap_DrawSetup", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ShadowMap_DrawSetup_x86( int  SmHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ShadowMap_DrawSetup", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ShadowMap_DrawSetup_x64( int  SmHandle);
		public static int  ShadowMap_DrawSetup( int  SmHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ShadowMap_DrawSetup_x86( SmHandle );
			}
			else
			{
				return dx_ShadowMap_DrawSetup_x64( SmHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ShadowMap_DrawEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ShadowMap_DrawEnd_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ShadowMap_DrawEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ShadowMap_DrawEnd_x64( );
		public static int  ShadowMap_DrawEnd( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ShadowMap_DrawEnd_x86( );
			}
			else
			{
				return dx_ShadowMap_DrawEnd_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseShadowMap_x86( int  SmSlotIndex, int  SmHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseShadowMap_x64( int  SmSlotIndex, int  SmHandle);
		public static int  SetUseShadowMap( int  SmSlotIndex, int  SmHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseShadowMap_x86( SmSlotIndex , SmHandle );
			}
			else
			{
				return dx_SetUseShadowMap_x64( SmSlotIndex , SmHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetShadowMapDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetShadowMapDrawArea_x86( int  SmHandle, VECTOR  MinPosition, VECTOR  MaxPosition);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetShadowMapDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetShadowMapDrawArea_x64( int  SmHandle, VECTOR  MinPosition, VECTOR  MaxPosition);
		public static int  SetShadowMapDrawArea( int  SmHandle, VECTOR  MinPosition, VECTOR  MaxPosition)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetShadowMapDrawArea_x86( SmHandle , MinPosition , MaxPosition );
			}
			else
			{
				return dx_SetShadowMapDrawArea_x64( SmHandle , MinPosition , MaxPosition );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetShadowMapDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetShadowMapDrawArea_x86( int  SmHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetShadowMapDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetShadowMapDrawArea_x64( int  SmHandle);
		public static int  ResetShadowMapDrawArea( int  SmHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetShadowMapDrawArea_x86( SmHandle );
			}
			else
			{
				return dx_ResetShadowMapDrawArea_x64( SmHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetShadowMapAdjustDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetShadowMapAdjustDepth_x86( int  SmHandle, float  Depth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetShadowMapAdjustDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetShadowMapAdjustDepth_x64( int  SmHandle, float  Depth);
		public static int  SetShadowMapAdjustDepth( int  SmHandle, float  Depth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetShadowMapAdjustDepth_x86( SmHandle , Depth );
			}
			else
			{
				return dx_SetShadowMapAdjustDepth_x64( SmHandle , Depth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetShadowMapViewProjectionMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetShadowMapViewProjectionMatrix_x86( int  SmHandle, out MATRIX  MatrixBuffer);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetShadowMapViewProjectionMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetShadowMapViewProjectionMatrix_x64( int  SmHandle, out MATRIX  MatrixBuffer);
		public static int  GetShadowMapViewProjectionMatrix( int  SmHandle, out MATRIX  MatrixBuffer)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetShadowMapViewProjectionMatrix_x86( SmHandle , out MatrixBuffer );
			}
			else
			{
				return dx_GetShadowMapViewProjectionMatrix_x64( SmHandle , out MatrixBuffer );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_TestDrawShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_TestDrawShadowMap_x86( int  SmHandle, int  x1, int  y1, int  x2, int  y2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_TestDrawShadowMap", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_TestDrawShadowMap_x64( int  SmHandle, int  x1, int  y1, int  x2, int  y2);
		public static int  TestDrawShadowMap( int  SmHandle, int  x1, int  y1, int  x2, int  y2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_TestDrawShadowMap_x86( SmHandle , x1 , y1 , x2 , y2 );
			}
			else
			{
				return dx_TestDrawShadowMap_x64( SmHandle , x1 , y1 , x2 , y2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadBmpToGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBmpToGraph_x86( string  FileName, int  TextureFlag, int  ReverseFlag, int  SurfaceMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadBmpToGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBmpToGraph_x64( string  FileName, int  TextureFlag, int  ReverseFlag, int  SurfaceMode);
		public static int  LoadBmpToGraph( string  FileName, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadBmpToGraph_x86( FileName , TextureFlag , ReverseFlag , DX_MOVIESURFACE_NORMAL );
			}
			else
			{
				return dx_LoadBmpToGraph_x64( FileName , TextureFlag , ReverseFlag , DX_MOVIESURFACE_NORMAL );
			}
		}
		public static int  LoadBmpToGraph( string  FileName, int  TextureFlag, int  ReverseFlag, int  SurfaceMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadBmpToGraph_x86( FileName , TextureFlag , ReverseFlag , SurfaceMode );
			}
			else
			{
				return dx_LoadBmpToGraph_x64( FileName , TextureFlag , ReverseFlag , SurfaceMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadBmpToGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBmpToGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  TextureFlag, int  ReverseFlag, int  SurfaceMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadBmpToGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBmpToGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  TextureFlag, int  ReverseFlag, int  SurfaceMode);
		public static int  LoadBmpToGraphWithStrLen( string  FileName, ulong FileNameLength, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadBmpToGraphWithStrLen_x86( FileName , ( uint )FileNameLength , TextureFlag , ReverseFlag , DX_MOVIESURFACE_NORMAL );
			}
			else
			{
				return dx_LoadBmpToGraphWithStrLen_x64( FileName , FileNameLength , TextureFlag , ReverseFlag , DX_MOVIESURFACE_NORMAL );
			}
		}
		public static int  LoadBmpToGraphWithStrLen( string  FileName, ulong FileNameLength, int  TextureFlag, int  ReverseFlag, int  SurfaceMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadBmpToGraphWithStrLen_x86( FileName , ( uint )FileNameLength , TextureFlag , ReverseFlag , SurfaceMode );
			}
			else
			{
				return dx_LoadBmpToGraphWithStrLen_x64( FileName , FileNameLength , TextureFlag , ReverseFlag , SurfaceMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraph_x86( string  FileName, int  NotUse3DFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraph_x64( string  FileName, int  NotUse3DFlag);
		public static int  LoadGraph( string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGraph_x86( FileName , FALSE );
			}
			else
			{
				return dx_LoadGraph_x64( FileName , FALSE );
			}
		}
		public static int  LoadGraph( string  FileName, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGraph_x86( FileName , NotUse3DFlag );
			}
			else
			{
				return dx_LoadGraph_x64( FileName , NotUse3DFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  NotUse3DFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  NotUse3DFlag);
		public static int  LoadGraphWithStrLen( string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGraphWithStrLen_x86( FileName , ( uint )FileNameLength , FALSE );
			}
			else
			{
				return dx_LoadGraphWithStrLen_x64( FileName , FileNameLength , FALSE );
			}
		}
		public static int  LoadGraphWithStrLen( string  FileName, ulong FileNameLength, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGraphWithStrLen_x86( FileName , ( uint )FileNameLength , NotUse3DFlag );
			}
			else
			{
				return dx_LoadGraphWithStrLen_x64( FileName , FileNameLength , NotUse3DFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadReverseGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseGraph_x86( string  FileName, int  NotUse3DFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadReverseGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseGraph_x64( string  FileName, int  NotUse3DFlag);
		public static int  LoadReverseGraph( string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseGraph_x86( FileName , FALSE );
			}
			else
			{
				return dx_LoadReverseGraph_x64( FileName , FALSE );
			}
		}
		public static int  LoadReverseGraph( string  FileName, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseGraph_x86( FileName , NotUse3DFlag );
			}
			else
			{
				return dx_LoadReverseGraph_x64( FileName , NotUse3DFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadReverseGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  NotUse3DFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadReverseGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  NotUse3DFlag);
		public static int  LoadReverseGraphWithStrLen( string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseGraphWithStrLen_x86( FileName , ( uint )FileNameLength , FALSE );
			}
			else
			{
				return dx_LoadReverseGraphWithStrLen_x64( FileName , FileNameLength , FALSE );
			}
		}
		public static int  LoadReverseGraphWithStrLen( string  FileName, ulong FileNameLength, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseGraphWithStrLen_x86( FileName , ( uint )FileNameLength , NotUse3DFlag );
			}
			else
			{
				return dx_LoadReverseGraphWithStrLen_x64( FileName , FileNameLength , NotUse3DFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraph_x86( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraph_x64( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		public static int  LoadDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		public static int  LoadDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraphF_x86( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraphF_x64( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		public static int  LoadDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraphFWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivGraphFWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		public static int  LoadDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivBmpToGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraph_x86( string  FileName, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride, int  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivBmpToGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraph_x64( string  FileName, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride, int  YStride);
		public static int  LoadDivBmpToGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraph_x86( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraph_x64( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
		}
		public static int  LoadDivBmpToGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraph_x86( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraph_x64( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
		}
		public static int  LoadDivBmpToGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride, int  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraph_x86( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivBmpToGraph_x64( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivBmpToGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride, int  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivBmpToGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride, int  YStride);
		public static int  LoadDivBmpToGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
		}
		public static int  LoadDivBmpToGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
		}
		public static int  LoadDivBmpToGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, int  XStride, int  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivBmpToGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivBmpToGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraphF_x86( string  FileName, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride, float  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivBmpToGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraphF_x64( string  FileName, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride, float  YStride);
		public static int  LoadDivBmpToGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphF_x86( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraphF_x64( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
		}
		public static int  LoadDivBmpToGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphF_x86( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraphF_x64( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
		}
		public static int  LoadDivBmpToGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride, float  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphF_x86( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivBmpToGraphF_x64( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadDivBmpToGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraphFWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride, float  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadDivBmpToGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadDivBmpToGraphFWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride, float  YStride);
		public static int  LoadDivBmpToGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , 0 , 0 );
			}
		}
		public static int  LoadDivBmpToGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadDivBmpToGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , 0 );
			}
		}
		public static int  LoadDivBmpToGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, float  XStride, float  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadDivBmpToGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadDivBmpToGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadReverseDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraph_x86( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadReverseDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraph_x64( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		public static int  LoadReverseDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadReverseDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadReverseDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadReverseDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadReverseDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride);
		public static int  LoadReverseDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadReverseDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, int  XStride, int  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadReverseDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadReverseDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraphF_x86( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadReverseDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraphF_x64( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		public static int  LoadReverseDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadReverseDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadReverseDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadReverseDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraphFWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadReverseDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadReverseDivGraphFWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride);
		public static int  LoadReverseDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , 0 , 0 );
			}
		}
		public static int  LoadReverseDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
			else
			{
				return dx_LoadReverseDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , 0 );
			}
		}
		public static int  LoadReverseDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  NotUse3DFlag, float  XStride, float  YStride)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadReverseDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
			else
			{
				return dx_LoadReverseDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , NotUse3DFlag , XStride , YStride );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadBlendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBlendGraph_x86( string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadBlendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBlendGraph_x64( string  FileName);
		public static int  LoadBlendGraph( string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadBlendGraph_x86( FileName );
			}
			else
			{
				return dx_LoadBlendGraph_x64( FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadBlendGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBlendGraphWithStrLen_x86( string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadBlendGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadBlendGraphWithStrLen_x64( string  FileName, ulong FileNameLength);
		public static int  LoadBlendGraphWithStrLen( string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadBlendGraphWithStrLen_x86( FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_LoadBlendGraphWithStrLen_x64( FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraphFromMem_x86( System.IntPtr  RGBFileImage, int  RGBFileImageSize, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraphFromMem_x64( System.IntPtr  RGBFileImage, int  RGBFileImageSize, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag, int  ReverseFlag);
		public static int  CreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , ( System.IntPtr )null , 0 , TRUE , FALSE );
			}
			else
			{
				return dx_CreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , ( System.IntPtr )null , 0 , TRUE , FALSE );
			}
		}
		public static int  CreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, System.IntPtr  AlphaFileImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AlphaFileImage , 0 , TRUE , FALSE );
			}
			else
			{
				return dx_CreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AlphaFileImage , 0 , TRUE , FALSE );
			}
		}
		public static int  CreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AlphaFileImage , AlphaFileImageSize , TRUE , FALSE );
			}
			else
			{
				return dx_CreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AlphaFileImage , AlphaFileImageSize , TRUE , FALSE );
			}
		}
		public static int  CreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AlphaFileImage , AlphaFileImageSize , TextureFlag , FALSE );
			}
			else
			{
				return dx_CreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AlphaFileImage , AlphaFileImageSize , TextureFlag , FALSE );
			}
		}
		public static int  CreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AlphaFileImage , AlphaFileImageSize , TextureFlag , ReverseFlag );
			}
			else
			{
				return dx_CreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AlphaFileImage , AlphaFileImageSize , TextureFlag , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraphFromMem_x86( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  GrHandle, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraphFromMem_x64( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  GrHandle, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag, int  ReverseFlag);
		public static int  ReCreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , GrHandle , ( System.IntPtr )null , 0 , TRUE , FALSE );
			}
			else
			{
				return dx_ReCreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , GrHandle , ( System.IntPtr )null , 0 , TRUE , FALSE );
			}
		}
		public static int  ReCreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  GrHandle, System.IntPtr  AlphaFileImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , 0 , TRUE , FALSE );
			}
			else
			{
				return dx_ReCreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , 0 , TRUE , FALSE );
			}
		}
		public static int  ReCreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  GrHandle, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , AlphaFileImageSize , TRUE , FALSE );
			}
			else
			{
				return dx_ReCreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , AlphaFileImageSize , TRUE , FALSE );
			}
		}
		public static int  ReCreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  GrHandle, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , AlphaFileImageSize , TextureFlag , FALSE );
			}
			else
			{
				return dx_ReCreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , AlphaFileImageSize , TextureFlag , FALSE );
			}
		}
		public static int  ReCreateGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  GrHandle, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraphFromMem_x86( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , AlphaFileImageSize , TextureFlag , ReverseFlag );
			}
			else
			{
				return dx_ReCreateGraphFromMem_x64( RGBFileImage , RGBFileImageSize , GrHandle , AlphaFileImage , AlphaFileImageSize , TextureFlag , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateDivGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFromMem_x86( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateDivGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFromMem_x64( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		public static int  CreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_CreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  CreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_CreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  CreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_CreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
		}
		public static int  CreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
			else
			{
				return dx_CreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
		}
		public static int  CreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
			else
			{
				return dx_CreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateDivGraphFFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFFromMem_x86( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateDivGraphFFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFFromMem_x64( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		public static int  CreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_CreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  CreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_CreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  CreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_CreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
		}
		public static int  CreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
			else
			{
				return dx_CreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
		}
		public static int  CreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
			else
			{
				return dx_CreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateDivGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFromMem_x86( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateDivGraphFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFromMem_x64( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		public static int  ReCreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  ReCreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  ReCreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
		}
		public static int  ReCreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
		}
		public static int  ReCreateDivGraphFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
			else
			{
				return dx_ReCreateDivGraphFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateDivGraphFFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFFromMem_x86( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateDivGraphFFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFFromMem_x64( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize);
		public static int  ReCreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TRUE , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  ReCreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , FALSE , ( System.IntPtr )null , 0 );
			}
		}
		public static int  ReCreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , ( System.IntPtr )null , 0 );
			}
		}
		public static int  ReCreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
			else
			{
				return dx_ReCreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , 0 );
			}
		}
		public static int  ReCreateDivGraphFFromMem( System.IntPtr  RGBFileImage, int  RGBFileImageSize, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, int  TextureFlag, int  ReverseFlag, System.IntPtr  AlphaFileImage, int  AlphaFileImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFFromMem_x86( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
			else
			{
				return dx_ReCreateDivGraphFFromMem_x64( RGBFileImage , RGBFileImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , TextureFlag , ReverseFlag , AlphaFileImage , AlphaFileImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraph_x86( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, System.IntPtr  AlphaImage, int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraph_x64( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, System.IntPtr  AlphaImage, int  GrHandle);
		public static int  CreateGraph( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraph_x86( Width , Height , Pitch , RGBImage , ( System.IntPtr )null , -1 );
			}
			else
			{
				return dx_CreateGraph_x64( Width , Height , Pitch , RGBImage , ( System.IntPtr )null , -1 );
			}
		}
		public static int  CreateGraph( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, System.IntPtr  AlphaImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraph_x86( Width , Height , Pitch , RGBImage , AlphaImage , -1 );
			}
			else
			{
				return dx_CreateGraph_x64( Width , Height , Pitch , RGBImage , AlphaImage , -1 );
			}
		}
		public static int  CreateGraph( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, System.IntPtr  AlphaImage, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraph_x86( Width , Height , Pitch , RGBImage , AlphaImage , GrHandle );
			}
			else
			{
				return dx_CreateGraph_x64( Width , Height , Pitch , RGBImage , AlphaImage , GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraph_x86( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, System.IntPtr  AlphaImage);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraph_x64( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, System.IntPtr  AlphaImage);
		public static int  CreateDivGraph( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraph_x86( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , ( System.IntPtr )null );
			}
			else
			{
				return dx_CreateDivGraph_x64( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , ( System.IntPtr )null );
			}
		}
		public static int  CreateDivGraph( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray, System.IntPtr  AlphaImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraph_x86( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , AlphaImage );
			}
			else
			{
				return dx_CreateDivGraph_x64( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , AlphaImage );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphF_x86( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, System.IntPtr  AlphaImage);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphF_x64( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, System.IntPtr  AlphaImage);
		public static int  CreateDivGraphF( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphF_x86( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , ( System.IntPtr )null );
			}
			else
			{
				return dx_CreateDivGraphF_x64( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , ( System.IntPtr )null );
			}
		}
		public static int  CreateDivGraphF( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray, System.IntPtr  AlphaImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphF_x86( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , AlphaImage );
			}
			else
			{
				return dx_CreateDivGraphF_x64( Width , Height , Pitch , RGBImage , AllNum , XNum , YNum , SizeX , SizeY , HandleArray , AlphaImage );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraph_x86( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  GrHandle, System.IntPtr  AlphaImage);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraph_x64( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  GrHandle, System.IntPtr  AlphaImage);
		public static int  ReCreateGraph( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraph_x86( Width , Height , Pitch , RGBImage , GrHandle , ( System.IntPtr )null );
			}
			else
			{
				return dx_ReCreateGraph_x64( Width , Height , Pitch , RGBImage , GrHandle , ( System.IntPtr )null );
			}
		}
		public static int  ReCreateGraph( int  Width, int  Height, int  Pitch, System.IntPtr  RGBImage, int  GrHandle, System.IntPtr  AlphaImage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraph_x86( Width , Height , Pitch , RGBImage , GrHandle , AlphaImage );
			}
			else
			{
				return dx_ReCreateGraph_x64( Width , Height , Pitch , RGBImage , GrHandle , AlphaImage );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateBlendGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateBlendGraphFromSoftImage_x86( int  SIHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateBlendGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateBlendGraphFromSoftImage_x64( int  SIHandle);
		public static int  CreateBlendGraphFromSoftImage( int  SIHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateBlendGraphFromSoftImage_x86( SIHandle );
			}
			else
			{
				return dx_CreateBlendGraphFromSoftImage_x64( SIHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraphFromSoftImage_x86( int  SIHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraphFromSoftImage_x64( int  SIHandle);
		public static int  CreateGraphFromSoftImage( int  SIHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraphFromSoftImage_x86( SIHandle );
			}
			else
			{
				return dx_CreateGraphFromSoftImage_x64( SIHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateGraphFromRectSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraphFromRectSoftImage_x86( int  SIHandle, int  x, int  y, int  SizeX, int  SizeY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateGraphFromRectSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateGraphFromRectSoftImage_x64( int  SIHandle, int  x, int  y, int  SizeX, int  SizeY);
		public static int  CreateGraphFromRectSoftImage( int  SIHandle, int  x, int  y, int  SizeX, int  SizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateGraphFromRectSoftImage_x86( SIHandle , x , y , SizeX , SizeY );
			}
			else
			{
				return dx_CreateGraphFromRectSoftImage_x64( SIHandle , x , y , SizeX , SizeY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraphFromSoftImage_x86( int  SIHandle, int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraphFromSoftImage_x64( int  SIHandle, int  GrHandle);
		public static int  ReCreateGraphFromSoftImage( int  SIHandle, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraphFromSoftImage_x86( SIHandle , GrHandle );
			}
			else
			{
				return dx_ReCreateGraphFromSoftImage_x64( SIHandle , GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateGraphFromRectSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraphFromRectSoftImage_x86( int  SIHandle, int  x, int  y, int  SizeX, int  SizeY, int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateGraphFromRectSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateGraphFromRectSoftImage_x64( int  SIHandle, int  x, int  y, int  SizeX, int  SizeY, int  GrHandle);
		public static int  ReCreateGraphFromRectSoftImage( int  SIHandle, int  x, int  y, int  SizeX, int  SizeY, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateGraphFromRectSoftImage_x86( SIHandle , x , y , SizeX , SizeY , GrHandle );
			}
			else
			{
				return dx_ReCreateGraphFromRectSoftImage_x64( SIHandle , x , y , SizeX , SizeY , GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateDivGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFromSoftImage_x86( int  SIHandle, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateDivGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFromSoftImage_x64( int  SIHandle, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray);
		public static int  CreateDivGraphFromSoftImage( int  SIHandle, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFromSoftImage_x86( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
			else
			{
				return dx_CreateDivGraphFromSoftImage_x64( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateDivGraphFFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFFromSoftImage_x86( int  SIHandle, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateDivGraphFFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateDivGraphFFromSoftImage_x64( int  SIHandle, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray);
		public static int  CreateDivGraphFFromSoftImage( int  SIHandle, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateDivGraphFFromSoftImage_x86( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
			else
			{
				return dx_CreateDivGraphFFromSoftImage_x64( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateDivGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFromSoftImage_x86( int  SIHandle, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateDivGraphFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFromSoftImage_x64( int  SIHandle, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray);
		public static int  ReCreateDivGraphFromSoftImage( int  SIHandle, int  AllNum, int  XNum, int  YNum, int  SizeX, int  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFromSoftImage_x86( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
			else
			{
				return dx_ReCreateDivGraphFromSoftImage_x64( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReCreateDivGraphFFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFFromSoftImage_x86( int  SIHandle, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReCreateDivGraphFFromSoftImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReCreateDivGraphFFromSoftImage_x64( int  SIHandle, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray);
		public static int  ReCreateDivGraphFFromSoftImage( int  SIHandle, int  AllNum, int  XNum, int  YNum, float  SizeX, float  SizeY, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReCreateDivGraphFFromSoftImage_x86( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
			else
			{
				return dx_ReCreateDivGraphFFromSoftImage_x64( SIHandle , AllNum , XNum , YNum , SizeX , SizeY , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadGraph_x86( string  FileName, int  GrHandle, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadGraph_x64( string  FileName, int  GrHandle, int  ReverseFlag);
		public static int  ReloadGraph( string  FileName, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadGraph_x86( FileName , GrHandle , FALSE );
			}
			else
			{
				return dx_ReloadGraph_x64( FileName , GrHandle , FALSE );
			}
		}
		public static int  ReloadGraph( string  FileName, int  GrHandle, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadGraph_x86( FileName , GrHandle , ReverseFlag );
			}
			else
			{
				return dx_ReloadGraph_x64( FileName , GrHandle , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  GrHandle, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  GrHandle, int  ReverseFlag);
		public static int  ReloadGraphWithStrLen( string  FileName, ulong FileNameLength, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadGraphWithStrLen_x86( FileName , ( uint )FileNameLength , GrHandle , FALSE );
			}
			else
			{
				return dx_ReloadGraphWithStrLen_x64( FileName , FileNameLength , GrHandle , FALSE );
			}
		}
		public static int  ReloadGraphWithStrLen( string  FileName, ulong FileNameLength, int  GrHandle, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadGraphWithStrLen_x86( FileName , ( uint )FileNameLength , GrHandle , ReverseFlag );
			}
			else
			{
				return dx_ReloadGraphWithStrLen_x64( FileName , FileNameLength , GrHandle , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraph_x86( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraph_x64( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		public static int  ReloadDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
			else
			{
				return dx_ReloadDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
		}
		public static int  ReloadDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
			else
			{
				return dx_ReloadDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		public static int  ReloadDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
			else
			{
				return dx_ReloadDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
		}
		public static int  ReloadDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
			else
			{
				return dx_ReloadDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraphF_x86( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraphF_x64( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		public static int  ReloadDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
			else
			{
				return dx_ReloadDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
		}
		public static int  ReloadDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
			else
			{
				return dx_ReloadDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraphFWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadDivGraphFWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag);
		public static int  ReloadDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
			else
			{
				return dx_ReloadDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , FALSE );
			}
		}
		public static int  ReloadDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray, int  ReverseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
			else
			{
				return dx_ReloadDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray , ReverseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadReverseGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseGraph_x86( string  FileName, int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadReverseGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseGraph_x64( string  FileName, int  GrHandle);
		public static int  ReloadReverseGraph( string  FileName, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadReverseGraph_x86( FileName , GrHandle );
			}
			else
			{
				return dx_ReloadReverseGraph_x64( FileName , GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadReverseGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadReverseGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  GrHandle);
		public static int  ReloadReverseGraphWithStrLen( string  FileName, ulong FileNameLength, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadReverseGraphWithStrLen_x86( FileName , ( uint )FileNameLength , GrHandle );
			}
			else
			{
				return dx_ReloadReverseGraphWithStrLen_x64( FileName , FileNameLength , GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadReverseDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraph_x86( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadReverseDivGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraph_x64( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray);
		public static int  ReloadReverseDivGraph( string  FileName, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadReverseDivGraph_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
			else
			{
				return dx_ReloadReverseDivGraph_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadReverseDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraphWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadReverseDivGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraphWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray);
		public static int  ReloadReverseDivGraphWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, int  XSize, int  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadReverseDivGraphWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
			else
			{
				return dx_ReloadReverseDivGraphWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadReverseDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraphF_x86( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadReverseDivGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraphF_x64( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray);
		public static int  ReloadReverseDivGraphF( string  FileName, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadReverseDivGraphF_x86( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
			else
			{
				return dx_ReloadReverseDivGraphF_x64( FileName , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ReloadReverseDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraphFWithStrLen_x86( string  FileName, uint FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ReloadReverseDivGraphFWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ReloadReverseDivGraphFWithStrLen_x64( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray);
		public static int  ReloadReverseDivGraphFWithStrLen( string  FileName, ulong FileNameLength, int  AllNum, int  XNum, int  YNum, float  XSize, float  YSize, [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ReloadReverseDivGraphFWithStrLen_x86( FileName , ( uint )FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
			else
			{
				return dx_ReloadReverseDivGraphFWithStrLen_x64( FileName , FileNameLength , AllNum , XNum , YNum , XSize , YSize , HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphColorBitDepth_x86( int  ColorBitDepth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphColorBitDepth_x64( int  ColorBitDepth);
		public static int  SetGraphColorBitDepth( int  ColorBitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetGraphColorBitDepth_x86( ColorBitDepth );
			}
			else
			{
				return dx_SetGraphColorBitDepth_x64( ColorBitDepth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphColorBitDepth_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphColorBitDepth_x64( );
		public static int  GetGraphColorBitDepth( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphColorBitDepth_x86( );
			}
			else
			{
				return dx_GetGraphColorBitDepth_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphColorBitDepth_x86( int  BitDepth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphColorBitDepth_x64( int  BitDepth);
		public static int  SetCreateGraphColorBitDepth( int  BitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateGraphColorBitDepth_x86( BitDepth );
			}
			else
			{
				return dx_SetCreateGraphColorBitDepth_x64( BitDepth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphColorBitDepth_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateGraphColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphColorBitDepth_x64( );
		public static int  GetCreateGraphColorBitDepth( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateGraphColorBitDepth_x86( );
			}
			else
			{
				return dx_GetCreateGraphColorBitDepth_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateGraphChannelBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphChannelBitDepth_x86( int  BitDepth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateGraphChannelBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphChannelBitDepth_x64( int  BitDepth);
		public static int  SetCreateGraphChannelBitDepth( int  BitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateGraphChannelBitDepth_x86( BitDepth );
			}
			else
			{
				return dx_SetCreateGraphChannelBitDepth_x64( BitDepth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateGraphChannelBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphChannelBitDepth_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateGraphChannelBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphChannelBitDepth_x64( );
		public static int  GetCreateGraphChannelBitDepth( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateGraphChannelBitDepth_x86( );
			}
			else
			{
				return dx_GetCreateGraphChannelBitDepth_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateGraphInitGraphDelete", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphInitGraphDelete_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateGraphInitGraphDelete", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphInitGraphDelete_x64( int  Flag);
		public static int  SetCreateGraphInitGraphDelete( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateGraphInitGraphDelete_x86( Flag );
			}
			else
			{
				return dx_SetCreateGraphInitGraphDelete_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateGraphInitGraphDelete", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphInitGraphDelete_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateGraphInitGraphDelete", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphInitGraphDelete_x64( );
		public static int  GetCreateGraphInitGraphDelete( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateGraphInitGraphDelete_x86( );
			}
			else
			{
				return dx_GetCreateGraphInitGraphDelete_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphHandle_x86( int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateGraphHandle_x64( int  GrHandle);
		public static int  SetCreateGraphHandle( int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateGraphHandle_x86( GrHandle );
			}
			else
			{
				return dx_SetCreateGraphHandle_x64( GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphHandle_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphHandle_x64( );
		public static int  GetCreateGraphHandle( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateGraphHandle_x86( );
			}
			else
			{
				return dx_GetCreateGraphHandle_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateDivGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDivGraphHandle_x86( [In, Out] int[]  HandleArray, int  HandleNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateDivGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDivGraphHandle_x64( [In, Out] int[]  HandleArray, int  HandleNum);
		public static int  SetCreateDivGraphHandle( [In, Out] int[]  HandleArray, int  HandleNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateDivGraphHandle_x86( HandleArray , HandleNum );
			}
			else
			{
				return dx_SetCreateDivGraphHandle_x64( HandleArray , HandleNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateDivGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDivGraphHandle_x86( [In, Out] int[]  HandleArray);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateDivGraphHandle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDivGraphHandle_x64( [In, Out] int[]  HandleArray);
		public static int  GetCreateDivGraphHandle( [In, Out] int[]  HandleArray)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateDivGraphHandle_x86( HandleArray );
			}
			else
			{
				return dx_GetCreateDivGraphHandle_x64( HandleArray );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawValidGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawValidGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidGraphCreateFlag_x64( int  Flag);
		public static int  SetDrawValidGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawValidGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetDrawValidGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawValidGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidGraphCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawValidGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidGraphCreateFlag_x64( );
		public static int  GetDrawValidGraphCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawValidGraphCreateFlag_x86( );
			}
			else
			{
				return dx_GetDrawValidGraphCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawValidFlagOf3DGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidFlagOf3DGraph_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawValidFlagOf3DGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidFlagOf3DGraph_x64( int  Flag);
		public static int  SetDrawValidFlagOf3DGraph( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawValidFlagOf3DGraph_x86( Flag );
			}
			else
			{
				return dx_SetDrawValidFlagOf3DGraph_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetLeftUpColorIsTransColorFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLeftUpColorIsTransColorFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetLeftUpColorIsTransColorFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetLeftUpColorIsTransColorFlag_x64( int  Flag);
		public static int  SetLeftUpColorIsTransColorFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetLeftUpColorIsTransColorFlag_x86( Flag );
			}
			else
			{
				return dx_SetLeftUpColorIsTransColorFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUsePaletteGraphFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePaletteGraphFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUsePaletteGraphFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePaletteGraphFlag_x64( int  Flag);
		public static int  SetUsePaletteGraphFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUsePaletteGraphFlag_x86( Flag );
			}
			else
			{
				return dx_SetUsePaletteGraphFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseBlendGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseBlendGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseBlendGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseBlendGraphCreateFlag_x64( int  Flag);
		public static int  SetUseBlendGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseBlendGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseBlendGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseBlendGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseBlendGraphCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseBlendGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseBlendGraphCreateFlag_x64( );
		public static int  GetUseBlendGraphCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseBlendGraphCreateFlag_x86( );
			}
			else
			{
				return dx_GetUseBlendGraphCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseAlphaTestGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaTestGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseAlphaTestGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaTestGraphCreateFlag_x64( int  Flag);
		public static int  SetUseAlphaTestGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseAlphaTestGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseAlphaTestGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseAlphaTestGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseAlphaTestGraphCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseAlphaTestGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseAlphaTestGraphCreateFlag_x64( );
		public static int  GetUseAlphaTestGraphCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseAlphaTestGraphCreateFlag_x86( );
			}
			else
			{
				return dx_GetUseAlphaTestGraphCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseAlphaTestFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaTestFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseAlphaTestFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaTestFlag_x64( int  Flag);
		public static int  SetUseAlphaTestFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseAlphaTestFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseAlphaTestFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseAlphaTestFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseAlphaTestFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseAlphaTestFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseAlphaTestFlag_x64( );
		public static int  GetUseAlphaTestFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseAlphaTestFlag_x86( );
			}
			else
			{
				return dx_GetUseAlphaTestFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCubeMapTextureCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCubeMapTextureCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCubeMapTextureCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCubeMapTextureCreateFlag_x64( int  Flag);
		public static int  SetCubeMapTextureCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCubeMapTextureCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetCubeMapTextureCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCubeMapTextureCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCubeMapTextureCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCubeMapTextureCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCubeMapTextureCreateFlag_x64( );
		public static int  GetCubeMapTextureCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCubeMapTextureCreateFlag_x86( );
			}
			else
			{
				return dx_GetCubeMapTextureCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseNoBlendModeParam", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseNoBlendModeParam_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseNoBlendModeParam", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseNoBlendModeParam_x64( int  Flag);
		public static int  SetUseNoBlendModeParam( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseNoBlendModeParam_x86( Flag );
			}
			else
			{
				return dx_SetUseNoBlendModeParam_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawValidAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidAlphaChannelGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawValidAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidAlphaChannelGraphCreateFlag_x64( int  Flag);
		public static int  SetDrawValidAlphaChannelGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawValidAlphaChannelGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetDrawValidAlphaChannelGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawValidAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidAlphaChannelGraphCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawValidAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidAlphaChannelGraphCreateFlag_x64( );
		public static int  GetDrawValidAlphaChannelGraphCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawValidAlphaChannelGraphCreateFlag_x86( );
			}
			else
			{
				return dx_GetDrawValidAlphaChannelGraphCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawValidFloatTypeGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidFloatTypeGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawValidFloatTypeGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidFloatTypeGraphCreateFlag_x64( int  Flag);
		public static int  SetDrawValidFloatTypeGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawValidFloatTypeGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetDrawValidFloatTypeGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawValidFloatTypeGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidFloatTypeGraphCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawValidFloatTypeGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidFloatTypeGraphCreateFlag_x64( );
		public static int  GetDrawValidFloatTypeGraphCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawValidFloatTypeGraphCreateFlag_x86( );
			}
			else
			{
				return dx_GetDrawValidFloatTypeGraphCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawValidGraphCreateZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidGraphCreateZBufferFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawValidGraphCreateZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidGraphCreateZBufferFlag_x64( int  Flag);
		public static int  SetDrawValidGraphCreateZBufferFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawValidGraphCreateZBufferFlag_x86( Flag );
			}
			else
			{
				return dx_SetDrawValidGraphCreateZBufferFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawValidGraphCreateZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidGraphCreateZBufferFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawValidGraphCreateZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawValidGraphCreateZBufferFlag_x64( );
		public static int  GetDrawValidGraphCreateZBufferFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawValidGraphCreateZBufferFlag_x86( );
			}
			else
			{
				return dx_GetDrawValidGraphCreateZBufferFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateDrawValidGraphZBufferBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphZBufferBitDepth_x86( int  BitDepth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateDrawValidGraphZBufferBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphZBufferBitDepth_x64( int  BitDepth);
		public static int  SetCreateDrawValidGraphZBufferBitDepth( int  BitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateDrawValidGraphZBufferBitDepth_x86( BitDepth );
			}
			else
			{
				return dx_SetCreateDrawValidGraphZBufferBitDepth_x64( BitDepth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateDrawValidGraphZBufferBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDrawValidGraphZBufferBitDepth_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateDrawValidGraphZBufferBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDrawValidGraphZBufferBitDepth_x64( );
		public static int  GetCreateDrawValidGraphZBufferBitDepth( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateDrawValidGraphZBufferBitDepth_x86( );
			}
			else
			{
				return dx_GetCreateDrawValidGraphZBufferBitDepth_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateDrawValidGraphMipLevels", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphMipLevels_x86( int  MipLevels);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateDrawValidGraphMipLevels", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphMipLevels_x64( int  MipLevels);
		public static int  SetCreateDrawValidGraphMipLevels( int  MipLevels)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateDrawValidGraphMipLevels_x86( MipLevels );
			}
			else
			{
				return dx_SetCreateDrawValidGraphMipLevels_x64( MipLevels );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateDrawValidGraphMipLevels", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDrawValidGraphMipLevels_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateDrawValidGraphMipLevels", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDrawValidGraphMipLevels_x64( );
		public static int  GetCreateDrawValidGraphMipLevels( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateDrawValidGraphMipLevels_x86( );
			}
			else
			{
				return dx_GetCreateDrawValidGraphMipLevels_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateDrawValidGraphChannelNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphChannelNum_x86( int  ChannelNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateDrawValidGraphChannelNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphChannelNum_x64( int  ChannelNum);
		public static int  SetCreateDrawValidGraphChannelNum( int  ChannelNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateDrawValidGraphChannelNum_x86( ChannelNum );
			}
			else
			{
				return dx_SetCreateDrawValidGraphChannelNum_x64( ChannelNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateDrawValidGraphChannelNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDrawValidGraphChannelNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateDrawValidGraphChannelNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateDrawValidGraphChannelNum_x64( );
		public static int  GetCreateDrawValidGraphChannelNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateDrawValidGraphChannelNum_x86( );
			}
			else
			{
				return dx_GetCreateDrawValidGraphChannelNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetCreateDrawValidGraphMultiSample", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphMultiSample_x86( int  Samples, int  Quality);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetCreateDrawValidGraphMultiSample", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetCreateDrawValidGraphMultiSample_x64( int  Samples, int  Quality);
		public static int  SetCreateDrawValidGraphMultiSample( int  Samples, int  Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetCreateDrawValidGraphMultiSample_x86( Samples , Quality );
			}
			else
			{
				return dx_SetCreateDrawValidGraphMultiSample_x64( Samples , Quality );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawValidMultiSample", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidMultiSample_x86( int  Samples, int  Quality);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawValidMultiSample", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawValidMultiSample_x64( int  Samples, int  Quality);
		public static int  SetDrawValidMultiSample( int  Samples, int  Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawValidMultiSample_x86( Samples , Quality );
			}
			else
			{
				return dx_SetDrawValidMultiSample_x64( Samples , Quality );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMultiSampleQuality", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMultiSampleQuality_x86( int  Samples);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMultiSampleQuality", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMultiSampleQuality_x64( int  Samples);
		public static int  GetMultiSampleQuality( int  Samples)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMultiSampleQuality_x86( Samples );
			}
			else
			{
				return dx_GetMultiSampleQuality_x64( Samples );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseTransColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTransColor_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseTransColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTransColor_x64( int  Flag);
		public static int  SetUseTransColor( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseTransColor_x86( Flag );
			}
			else
			{
				return dx_SetUseTransColor_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseTransColorGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTransColorGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseTransColorGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTransColorGraphCreateFlag_x64( int  Flag);
		public static int  SetUseTransColorGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseTransColorGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseTransColorGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseGraphAlphaChannel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGraphAlphaChannel_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseGraphAlphaChannel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGraphAlphaChannel_x64( int  Flag);
		public static int  SetUseGraphAlphaChannel( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseGraphAlphaChannel_x86( Flag );
			}
			else
			{
				return dx_SetUseGraphAlphaChannel_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseGraphAlphaChannel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseGraphAlphaChannel_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseGraphAlphaChannel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseGraphAlphaChannel_x64( );
		public static int  GetUseGraphAlphaChannel( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseGraphAlphaChannel_x86( );
			}
			else
			{
				return dx_GetUseGraphAlphaChannel_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaChannelGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaChannelGraphCreateFlag_x64( int  Flag);
		public static int  SetUseAlphaChannelGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseAlphaChannelGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseAlphaChannelGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseAlphaChannelGraphCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseAlphaChannelGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseAlphaChannelGraphCreateFlag_x64( );
		public static int  GetUseAlphaChannelGraphCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseAlphaChannelGraphCreateFlag_x86( );
			}
			else
			{
				return dx_GetUseAlphaChannelGraphCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseNotManageTextureFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseNotManageTextureFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseNotManageTextureFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseNotManageTextureFlag_x64( int  Flag);
		public static int  SetUseNotManageTextureFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseNotManageTextureFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseNotManageTextureFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseNotManageTextureFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseNotManageTextureFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseNotManageTextureFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseNotManageTextureFlag_x64( );
		public static int  GetUseNotManageTextureFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseNotManageTextureFlag_x86( );
			}
			else
			{
				return dx_GetUseNotManageTextureFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUsePlatformTextureFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePlatformTextureFormat_x86( int  PlatformTextureFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUsePlatformTextureFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePlatformTextureFormat_x64( int  PlatformTextureFormat);
		public static int  SetUsePlatformTextureFormat( int  PlatformTextureFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUsePlatformTextureFormat_x86( PlatformTextureFormat );
			}
			else
			{
				return dx_SetUsePlatformTextureFormat_x64( PlatformTextureFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUsePlatformTextureFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUsePlatformTextureFormat_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUsePlatformTextureFormat", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUsePlatformTextureFormat_x64( );
		public static int  GetUsePlatformTextureFormat( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUsePlatformTextureFormat_x86( );
			}
			else
			{
				return dx_GetUsePlatformTextureFormat_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransColor_x86( int  Red, int  Green, int  Blue);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransColor_x64( int  Red, int  Green, int  Blue);
		public static int  SetTransColor( int  Red, int  Green, int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransColor_x86( Red , Green , Blue );
			}
			else
			{
				return dx_SetTransColor_x64( Red , Green , Blue );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransColor_x86( out int  Red, out int  Green, out int  Blue);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransColor_x64( out int  Red, out int  Green, out int  Blue);
		public static int  GetTransColor( out int  Red, out int  Green, out int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransColor_x86( out Red , out Green , out Blue );
			}
			else
			{
				return dx_GetTransColor_x64( out Red , out Green , out Blue );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseDivGraphFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDivGraphFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseDivGraphFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDivGraphFlag_x64( int  Flag);
		public static int  SetUseDivGraphFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseDivGraphFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseDivGraphFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseAlphaImageLoadFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaImageLoadFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseAlphaImageLoadFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseAlphaImageLoadFlag_x64( int  Flag);
		public static int  SetUseAlphaImageLoadFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseAlphaImageLoadFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseAlphaImageLoadFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseMaxTextureSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseMaxTextureSize_x86( int  Size);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseMaxTextureSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseMaxTextureSize_x64( int  Size);
		public static int  SetUseMaxTextureSize( int  Size)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseMaxTextureSize_x86( Size );
			}
			else
			{
				return dx_SetUseMaxTextureSize_x64( Size );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseGraphBaseDataBackup", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGraphBaseDataBackup_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseGraphBaseDataBackup", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGraphBaseDataBackup_x64( int  Flag);
		public static int  SetUseGraphBaseDataBackup( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseGraphBaseDataBackup_x86( Flag );
			}
			else
			{
				return dx_SetUseGraphBaseDataBackup_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseGraphBaseDataBackup", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseGraphBaseDataBackup_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseGraphBaseDataBackup", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseGraphBaseDataBackup_x64( );
		public static int  GetUseGraphBaseDataBackup( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseGraphBaseDataBackup_x86( );
			}
			else
			{
				return dx_GetUseGraphBaseDataBackup_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseSystemMemGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseSystemMemGraphCreateFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseSystemMemGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseSystemMemGraphCreateFlag_x64( int  Flag);
		public static int  SetUseSystemMemGraphCreateFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseSystemMemGraphCreateFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseSystemMemGraphCreateFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseSystemMemGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseSystemMemGraphCreateFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseSystemMemGraphCreateFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseSystemMemGraphCreateFlag_x64( );
		public static int  GetUseSystemMemGraphCreateFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseSystemMemGraphCreateFlag_x86( );
			}
			else
			{
				return dx_GetUseSystemMemGraphCreateFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseLoadDivGraphSizeCheckFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseLoadDivGraphSizeCheckFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseLoadDivGraphSizeCheckFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseLoadDivGraphSizeCheckFlag_x64( int  Flag);
		public static int  SetUseLoadDivGraphSizeCheckFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseLoadDivGraphSizeCheckFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseLoadDivGraphSizeCheckFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseLoadDivGraphSizeCheckFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseLoadDivGraphSizeCheckFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseLoadDivGraphSizeCheckFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseLoadDivGraphSizeCheckFlag_x64( );
		public static int  GetUseLoadDivGraphSizeCheckFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseLoadDivGraphSizeCheckFlag_x86( );
			}
			else
			{
				return dx_GetUseLoadDivGraphSizeCheckFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GraphUnLock", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GraphUnLock_x86( int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GraphUnLock", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GraphUnLock_x64( int  GrHandle);
		public static int  GraphUnLock( int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GraphUnLock_x86( GrHandle );
			}
			else
			{
				return dx_GraphUnLock_x64( GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseGraphZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGraphZBuffer_x86( int  GrHandle, int  UseFlag, int  BitDepth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseGraphZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGraphZBuffer_x64( int  GrHandle, int  UseFlag, int  BitDepth);
		public static int  SetUseGraphZBuffer( int  GrHandle, int  UseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseGraphZBuffer_x86( GrHandle , UseFlag , -1 );
			}
			else
			{
				return dx_SetUseGraphZBuffer_x64( GrHandle , UseFlag , -1 );
			}
		}
		public static int  SetUseGraphZBuffer( int  GrHandle, int  UseFlag, int  BitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseGraphZBuffer_x86( GrHandle , UseFlag , BitDepth );
			}
			else
			{
				return dx_SetUseGraphZBuffer_x64( GrHandle , UseFlag , BitDepth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CopyGraphZBufferImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CopyGraphZBufferImage_x86( int  DestGrHandle, int  SrcGrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CopyGraphZBufferImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CopyGraphZBufferImage_x64( int  DestGrHandle, int  SrcGrHandle);
		public static int  CopyGraphZBufferImage( int  DestGrHandle, int  SrcGrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CopyGraphZBufferImage_x86( DestGrHandle , SrcGrHandle );
			}
			else
			{
				return dx_CopyGraphZBufferImage_x64( DestGrHandle , SrcGrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDeviceLostDeleteGraphFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDeviceLostDeleteGraphFlag_x86( int  GrHandle, int  DeleteFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDeviceLostDeleteGraphFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDeviceLostDeleteGraphFlag_x64( int  GrHandle, int  DeleteFlag);
		public static int  SetDeviceLostDeleteGraphFlag( int  GrHandle, int  DeleteFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDeviceLostDeleteGraphFlag_x86( GrHandle , DeleteFlag );
			}
			else
			{
				return dx_SetDeviceLostDeleteGraphFlag_x64( GrHandle , DeleteFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphSize_x86( int  GrHandle, out int  SizeXBuf, out int  SizeYBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphSize_x64( int  GrHandle, out int  SizeXBuf, out int  SizeYBuf);
		public static int  GetGraphSize( int  GrHandle, out int  SizeXBuf, out int  SizeYBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphSize_x86( GrHandle , out SizeXBuf , out SizeYBuf );
			}
			else
			{
				return dx_GetGraphSize_x64( GrHandle , out SizeXBuf , out SizeYBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphSizeF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphSizeF_x86( int  GrHandle, out float  SizeXBuf, out float  SizeYBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphSizeF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphSizeF_x64( int  GrHandle, out float  SizeXBuf, out float  SizeYBuf);
		public static int  GetGraphSizeF( int  GrHandle, out float  SizeXBuf, out float  SizeYBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphSizeF_x86( GrHandle , out SizeXBuf , out SizeYBuf );
			}
			else
			{
				return dx_GetGraphSizeF_x64( GrHandle , out SizeXBuf , out SizeYBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphTextureSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphTextureSize_x86( int  GrHandle, out int  SizeXBuf, out int  SizeYBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphTextureSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphTextureSize_x64( int  GrHandle, out int  SizeXBuf, out int  SizeYBuf);
		public static int  GetGraphTextureSize( int  GrHandle, out int  SizeXBuf, out int  SizeYBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphTextureSize_x86( GrHandle , out SizeXBuf , out SizeYBuf );
			}
			else
			{
				return dx_GetGraphTextureSize_x64( GrHandle , out SizeXBuf , out SizeYBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphUseBaseGraphArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphUseBaseGraphArea_x86( int  GrHandle, out int  UseX, out int  UseY, out int  UseSizeX, out int  UseSizeY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphUseBaseGraphArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphUseBaseGraphArea_x64( int  GrHandle, out int  UseX, out int  UseY, out int  UseSizeX, out int  UseSizeY);
		public static int  GetGraphUseBaseGraphArea( int  GrHandle, out int  UseX, out int  UseY, out int  UseSizeX, out int  UseSizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphUseBaseGraphArea_x86( GrHandle , out UseX , out UseY , out UseSizeX , out UseSizeY );
			}
			else
			{
				return dx_GetGraphUseBaseGraphArea_x64( GrHandle , out UseX , out UseY , out UseSizeX , out UseSizeY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphMipmapCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphMipmapCount_x86( int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphMipmapCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphMipmapCount_x64( int  GrHandle);
		public static int  GetGraphMipmapCount( int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphMipmapCount_x86( GrHandle );
			}
			else
			{
				return dx_GetGraphMipmapCount_x64( GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphFilePath", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphFilePath_x86( int  GrHandle, System.Text.StringBuilder  FilePathBuffer);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphFilePath", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphFilePath_x64( int  GrHandle, System.Text.StringBuilder  FilePathBuffer);
		public static int  GetGraphFilePath( int  GrHandle, System.Text.StringBuilder  FilePathBuffer)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphFilePath_x86( GrHandle , FilePathBuffer );
			}
			else
			{
				return dx_GetGraphFilePath_x64( GrHandle , FilePathBuffer );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckDrawValidGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckDrawValidGraph_x86( int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckDrawValidGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckDrawValidGraph_x64( int  GrHandle);
		public static int  CheckDrawValidGraph( int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckDrawValidGraph_x86( GrHandle );
			}
			else
			{
				return dx_CheckDrawValidGraph_x64( GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMaxGraphTextureSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxGraphTextureSize_x86( out int  SizeX, out int  SizeY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMaxGraphTextureSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxGraphTextureSize_x64( out int  SizeX, out int  SizeY);
		public static int  GetMaxGraphTextureSize( out int  SizeX, out int  SizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMaxGraphTextureSize_x86( out SizeX , out SizeY );
			}
			else
			{
				return dx_GetMaxGraphTextureSize_x64( out SizeX , out SizeY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetValidRestoreShredPoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetValidRestoreShredPoint_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetValidRestoreShredPoint", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetValidRestoreShredPoint_x64( );
		public static int  GetValidRestoreShredPoint( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetValidRestoreShredPoint_x86( );
			}
			else
			{
				return dx_GetValidRestoreShredPoint_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetCreateGraphColorData", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphColorData_x86( out COLORDATA  ColorData, out IMAGEFORMATDESC  Format);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetCreateGraphColorData", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetCreateGraphColorData_x64( out COLORDATA  ColorData, out IMAGEFORMATDESC  Format);
		public static int  GetCreateGraphColorData( out COLORDATA  ColorData, out IMAGEFORMATDESC  Format)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetCreateGraphColorData_x86( out ColorData , out Format );
			}
			else
			{
				return dx_GetCreateGraphColorData_x64( out ColorData , out Format );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphPalette_x86( int  GrHandle, int  ColorIndex, out int  Red, out int  Green, out int  Blue);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphPalette_x64( int  GrHandle, int  ColorIndex, out int  Red, out int  Green, out int  Blue);
		public static int  GetGraphPalette( int  GrHandle, int  ColorIndex, out int  Red, out int  Green, out int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphPalette_x86( GrHandle , ColorIndex , out Red , out Green , out Blue );
			}
			else
			{
				return dx_GetGraphPalette_x64( GrHandle , ColorIndex , out Red , out Green , out Blue );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetGraphOriginalPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphOriginalPalette_x86( int  GrHandle, int  ColorIndex, out int  Red, out int  Green, out int  Blue);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetGraphOriginalPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetGraphOriginalPalette_x64( int  GrHandle, int  ColorIndex, out int  Red, out int  Green, out int  Blue);
		public static int  GetGraphOriginalPalette( int  GrHandle, int  ColorIndex, out int  Red, out int  Green, out int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetGraphOriginalPalette_x86( GrHandle , ColorIndex , out Red , out Green , out Blue );
			}
			else
			{
				return dx_GetGraphOriginalPalette_x64( GrHandle , ColorIndex , out Red , out Green , out Blue );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetGraphPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphPalette_x86( int  GrHandle, int  ColorIndex, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetGraphPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphPalette_x64( int  GrHandle, int  ColorIndex, uint  Color);
		public static int  SetGraphPalette( int  GrHandle, int  ColorIndex, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetGraphPalette_x86( GrHandle , ColorIndex , Color );
			}
			else
			{
				return dx_SetGraphPalette_x64( GrHandle , ColorIndex , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetGraphPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetGraphPalette_x86( int  GrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetGraphPalette", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetGraphPalette_x64( int  GrHandle);
		public static int  ResetGraphPalette( int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetGraphPalette_x86( GrHandle );
			}
			else
			{
				return dx_ResetGraphPalette_x64( GrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawLine", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLine_x86( int  x1, int  y1, int  x2, int  y2, uint  Color, int  Thickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawLine", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLine_x64( int  x1, int  y1, int  x2, int  y2, uint  Color, int  Thickness);
		public static int  DrawLine( int  x1, int  y1, int  x2, int  y2, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLine_x86( x1 , y1 , x2 , y2 , Color , 1 );
			}
			else
			{
				return dx_DrawLine_x64( x1 , y1 , x2 , y2 , Color , 1 );
			}
		}
		public static int  DrawLine( int  x1, int  y1, int  x2, int  y2, uint  Color, int  Thickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLine_x86( x1 , y1 , x2 , y2 , Color , Thickness );
			}
			else
			{
				return dx_DrawLine_x64( x1 , y1 , x2 , y2 , Color , Thickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawLineAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLineAA_x86( float  x1, float  y1, float  x2, float  y2, uint  Color, float  Thickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawLineAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLineAA_x64( float  x1, float  y1, float  x2, float  y2, uint  Color, float  Thickness);
		public static int  DrawLineAA( float  x1, float  y1, float  x2, float  y2, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLineAA_x86( x1 , y1 , x2 , y2 , Color , 1.0f );
			}
			else
			{
				return dx_DrawLineAA_x64( x1 , y1 , x2 , y2 , Color , 1.0f );
			}
		}
		public static int  DrawLineAA( float  x1, float  y1, float  x2, float  y2, uint  Color, float  Thickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLineAA_x86( x1 , y1 , x2 , y2 , Color , Thickness );
			}
			else
			{
				return dx_DrawLineAA_x64( x1 , y1 , x2 , y2 , Color , Thickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBox_x86( int  x1, int  y1, int  x2, int  y2, uint  Color, int  FillFlag, int  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBox_x64( int  x1, int  y1, int  x2, int  y2, uint  Color, int  FillFlag, int  LineThickness);
		public static int  DrawBox( int  x1, int  y1, int  x2, int  y2, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBox_x86( x1 , y1 , x2 , y2 , Color , FillFlag , 1 );
			}
			else
			{
				return dx_DrawBox_x64( x1 , y1 , x2 , y2 , Color , FillFlag , 1 );
			}
		}
		public static int  DrawBox( int  x1, int  y1, int  x2, int  y2, uint  Color, int  FillFlag, int  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBox_x86( x1 , y1 , x2 , y2 , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawBox_x64( x1 , y1 , x2 , y2 , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBoxAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBoxAA_x86( float  x1, float  y1, float  x2, float  y2, uint  Color, int  FillFlag, float  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBoxAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBoxAA_x64( float  x1, float  y1, float  x2, float  y2, uint  Color, int  FillFlag, float  LineThickness);
		public static int  DrawBoxAA( float  x1, float  y1, float  x2, float  y2, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBoxAA_x86( x1 , y1 , x2 , y2 , Color , FillFlag , 1.0f );
			}
			else
			{
				return dx_DrawBoxAA_x64( x1 , y1 , x2 , y2 , Color , FillFlag , 1.0f );
			}
		}
		public static int  DrawBoxAA( float  x1, float  y1, float  x2, float  y2, uint  Color, int  FillFlag, float  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBoxAA_x86( x1 , y1 , x2 , y2 , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawBoxAA_x64( x1 , y1 , x2 , y2 , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawFillBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawFillBox_x86( int  x1, int  y1, int  x2, int  y2, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawFillBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawFillBox_x64( int  x1, int  y1, int  x2, int  y2, uint  Color);
		public static int  DrawFillBox( int  x1, int  y1, int  x2, int  y2, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawFillBox_x86( x1 , y1 , x2 , y2 , Color );
			}
			else
			{
				return dx_DrawFillBox_x64( x1 , y1 , x2 , y2 , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawLineBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLineBox_x86( int  x1, int  y1, int  x2, int  y2, uint  Color, int  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawLineBox", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLineBox_x64( int  x1, int  y1, int  x2, int  y2, uint  Color, int  LineThickness);
		public static int  DrawLineBox( int  x1, int  y1, int  x2, int  y2, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLineBox_x86( x1 , y1 , x2 , y2 , Color , 1 );
			}
			else
			{
				return dx_DrawLineBox_x64( x1 , y1 , x2 , y2 , Color , 1 );
			}
		}
		public static int  DrawLineBox( int  x1, int  y1, int  x2, int  y2, uint  Color, int  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLineBox_x86( x1 , y1 , x2 , y2 , Color , LineThickness );
			}
			else
			{
				return dx_DrawLineBox_x64( x1 , y1 , x2 , y2 , Color , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCircle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircle_x86( int  x, int  y, int  r, uint  Color, int  FillFlag, int  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCircle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircle_x64( int  x, int  y, int  r, uint  Color, int  FillFlag, int  LineThickness);
		public static int  DrawCircle( int  x, int  y, int  r, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircle_x86( x , y , r , Color , TRUE , 1 );
			}
			else
			{
				return dx_DrawCircle_x64( x , y , r , Color , TRUE , 1 );
			}
		}
		public static int  DrawCircle( int  x, int  y, int  r, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircle_x86( x , y , r , Color , FillFlag , 1 );
			}
			else
			{
				return dx_DrawCircle_x64( x , y , r , Color , FillFlag , 1 );
			}
		}
		public static int  DrawCircle( int  x, int  y, int  r, uint  Color, int  FillFlag, int  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircle_x86( x , y , r , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawCircle_x64( x , y , r , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCircleAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleAA_x86( float  x, float  y, float  r, int  posnum, uint  Color, int  FillFlag, float  LineThickness, double  Angle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCircleAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleAA_x64( float  x, float  y, float  r, int  posnum, uint  Color, int  FillFlag, float  LineThickness, double  Angle);
		public static int  DrawCircleAA( float  x, float  y, float  r, int  posnum, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleAA_x86( x , y , r , posnum , Color , TRUE , 1.0f , 0.0 );
			}
			else
			{
				return dx_DrawCircleAA_x64( x , y , r , posnum , Color , TRUE , 1.0f , 0.0 );
			}
		}
		public static int  DrawCircleAA( float  x, float  y, float  r, int  posnum, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleAA_x86( x , y , r , posnum , Color , FillFlag , 1.0f , 0.0 );
			}
			else
			{
				return dx_DrawCircleAA_x64( x , y , r , posnum , Color , FillFlag , 1.0f , 0.0 );
			}
		}
		public static int  DrawCircleAA( float  x, float  y, float  r, int  posnum, uint  Color, int  FillFlag, float  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleAA_x86( x , y , r , posnum , Color , FillFlag , LineThickness , 0.0 );
			}
			else
			{
				return dx_DrawCircleAA_x64( x , y , r , posnum , Color , FillFlag , LineThickness , 0.0 );
			}
		}
		public static int  DrawCircleAA( float  x, float  y, float  r, int  posnum, uint  Color, int  FillFlag, float  LineThickness, double  Angle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleAA_x86( x , y , r , posnum , Color , FillFlag , LineThickness , Angle );
			}
			else
			{
				return dx_DrawCircleAA_x64( x , y , r , posnum , Color , FillFlag , LineThickness , Angle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawOval", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawOval_x86( int  x, int  y, int  rx, int  ry, uint  Color, int  FillFlag, int  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawOval", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawOval_x64( int  x, int  y, int  rx, int  ry, uint  Color, int  FillFlag, int  LineThickness);
		public static int  DrawOval( int  x, int  y, int  rx, int  ry, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawOval_x86( x , y , rx , ry , Color , FillFlag , 1 );
			}
			else
			{
				return dx_DrawOval_x64( x , y , rx , ry , Color , FillFlag , 1 );
			}
		}
		public static int  DrawOval( int  x, int  y, int  rx, int  ry, uint  Color, int  FillFlag, int  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawOval_x86( x , y , rx , ry , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawOval_x64( x , y , rx , ry , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawOvalAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawOvalAA_x86( float  x, float  y, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag, float  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawOvalAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawOvalAA_x64( float  x, float  y, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag, float  LineThickness);
		public static int  DrawOvalAA( float  x, float  y, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawOvalAA_x86( x , y , rx , ry , posnum , Color , FillFlag , 1.0f );
			}
			else
			{
				return dx_DrawOvalAA_x64( x , y , rx , ry , posnum , Color , FillFlag , 1.0f );
			}
		}
		public static int  DrawOvalAA( float  x, float  y, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag, float  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawOvalAA_x86( x , y , rx , ry , posnum , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawOvalAA_x64( x , y , rx , ry , posnum , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawOval_Rect", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawOval_Rect_x86( int  x1, int  y1, int  x2, int  y2, uint  Color, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawOval_Rect", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawOval_Rect_x64( int  x1, int  y1, int  x2, int  y2, uint  Color, int  FillFlag);
		public static int  DrawOval_Rect( int  x1, int  y1, int  x2, int  y2, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawOval_Rect_x86( x1 , y1 , x2 , y2 , Color , FillFlag );
			}
			else
			{
				return dx_DrawOval_Rect_x64( x1 , y1 , x2 , y2 , Color , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTriangle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangle_x86( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, uint  Color, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTriangle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangle_x64( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, uint  Color, int  FillFlag);
		public static int  DrawTriangle( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTriangle_x86( x1 , y1 , x2 , y2 , x3 , y3 , Color , FillFlag );
			}
			else
			{
				return dx_DrawTriangle_x64( x1 , y1 , x2 , y2 , x3 , y3 , Color , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTriangleAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangleAA_x86( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, uint  Color, int  FillFlag, float  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTriangleAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangleAA_x64( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, uint  Color, int  FillFlag, float  LineThickness);
		public static int  DrawTriangleAA( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTriangleAA_x86( x1 , y1 , x2 , y2 , x3 , y3 , Color , FillFlag , 1.0f );
			}
			else
			{
				return dx_DrawTriangleAA_x64( x1 , y1 , x2 , y2 , x3 , y3 , Color , FillFlag , 1.0f );
			}
		}
		public static int  DrawTriangleAA( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, uint  Color, int  FillFlag, float  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTriangleAA_x86( x1 , y1 , x2 , y2 , x3 , y3 , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawTriangleAA_x64( x1 , y1 , x2 , y2 , x3 , y3 , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawQuadrangle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawQuadrangle_x86( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, uint  Color, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawQuadrangle", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawQuadrangle_x64( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, uint  Color, int  FillFlag);
		public static int  DrawQuadrangle( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawQuadrangle_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Color , FillFlag );
			}
			else
			{
				return dx_DrawQuadrangle_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Color , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawQuadrangleAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawQuadrangleAA_x86( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, uint  Color, int  FillFlag, float  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawQuadrangleAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawQuadrangleAA_x64( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, uint  Color, int  FillFlag, float  LineThickness);
		public static int  DrawQuadrangleAA( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawQuadrangleAA_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Color , FillFlag , 1.0f );
			}
			else
			{
				return dx_DrawQuadrangleAA_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Color , FillFlag , 1.0f );
			}
		}
		public static int  DrawQuadrangleAA( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, uint  Color, int  FillFlag, float  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawQuadrangleAA_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawQuadrangleAA_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRoundRect", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRoundRect_x86( int  x1, int  y1, int  x2, int  y2, int  rx, int  ry, uint  Color, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRoundRect", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRoundRect_x64( int  x1, int  y1, int  x2, int  y2, int  rx, int  ry, uint  Color, int  FillFlag);
		public static int  DrawRoundRect( int  x1, int  y1, int  x2, int  y2, int  rx, int  ry, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRoundRect_x86( x1 , y1 , x2 , y2 , rx , ry , Color , FillFlag );
			}
			else
			{
				return dx_DrawRoundRect_x64( x1 , y1 , x2 , y2 , rx , ry , Color , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRoundRectAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRoundRectAA_x86( float  x1, float  y1, float  x2, float  y2, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag, float  LineThickness);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRoundRectAA", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRoundRectAA_x64( float  x1, float  y1, float  x2, float  y2, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag, float  LineThickness);
		public static int  DrawRoundRectAA( float  x1, float  y1, float  x2, float  y2, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRoundRectAA_x86( x1 , y1 , x2 , y2 , rx , ry , posnum , Color , FillFlag , 1.0f );
			}
			else
			{
				return dx_DrawRoundRectAA_x64( x1 , y1 , x2 , y2 , rx , ry , posnum , Color , FillFlag , 1.0f );
			}
		}
		public static int  DrawRoundRectAA( float  x1, float  y1, float  x2, float  y2, float  rx, float  ry, int  posnum, uint  Color, int  FillFlag, float  LineThickness)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRoundRectAA_x86( x1 , y1 , x2 , y2 , rx , ry , posnum , Color , FillFlag , LineThickness );
			}
			else
			{
				return dx_DrawRoundRectAA_x64( x1 , y1 , x2 , y2 , rx , ry , posnum , Color , FillFlag , LineThickness );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_BeginAADraw", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_BeginAADraw_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_BeginAADraw", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_BeginAADraw_x64( );
		public static int  BeginAADraw( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_BeginAADraw_x86( );
			}
			else
			{
				return dx_BeginAADraw_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_EndAADraw", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_EndAADraw_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_EndAADraw", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_EndAADraw_x64( );
		public static int  EndAADraw( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_EndAADraw_x86( );
			}
			else
			{
				return dx_EndAADraw_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPixel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixel_x86( int  x, int  y, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPixel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixel_x64( int  x, int  y, uint  Color);
		public static int  DrawPixel( int  x, int  y, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPixel_x86( x , y , Color );
			}
			else
			{
				return dx_DrawPixel_x64( x , y , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPixelSet", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixelSet_x86( [In, Out] POINTDATA[]  PointDataArray, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPixelSet", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixelSet_x64( [In, Out] POINTDATA[]  PointDataArray, int  Num);
		public static int  DrawPixelSet( [In, Out] POINTDATA[]  PointDataArray, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPixelSet_x86( PointDataArray , Num );
			}
			else
			{
				return dx_DrawPixelSet_x64( PointDataArray , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawLineSet", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLineSet_x86( [In, Out] LINEDATA[]  LineDataArray, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawLineSet", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLineSet_x64( [In, Out] LINEDATA[]  LineDataArray, int  Num);
		public static int  DrawLineSet( [In, Out] LINEDATA[]  LineDataArray, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLineSet_x86( LineDataArray , Num );
			}
			else
			{
				return dx_DrawLineSet_x64( LineDataArray , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBoxSet", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBoxSet_x86( [In, Out] RECTDATA[]  RectDataArray, int  Num);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBoxSet", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBoxSet_x64( [In, Out] RECTDATA[]  RectDataArray, int  Num);
		public static int  DrawBoxSet( [In, Out] RECTDATA[]  RectDataArray, int  Num)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBoxSet_x86( RectDataArray , Num );
			}
			else
			{
				return dx_DrawBoxSet_x64( RectDataArray , Num );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPixel3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixel3D_x86( VECTOR  Pos, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPixel3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixel3D_x64( VECTOR  Pos, uint  Color);
		public static int  DrawPixel3D( VECTOR  Pos, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPixel3D_x86( Pos , Color );
			}
			else
			{
				return dx_DrawPixel3D_x64( Pos , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPixel3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixel3DD_x86( VECTOR_D  Pos, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPixel3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPixel3DD_x64( VECTOR_D  Pos, uint  Color);
		public static int  DrawPixel3DD( VECTOR_D  Pos, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPixel3DD_x86( Pos , Color );
			}
			else
			{
				return dx_DrawPixel3DD_x64( Pos , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawLine3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLine3D_x86( VECTOR  Pos1, VECTOR  Pos2, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawLine3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLine3D_x64( VECTOR  Pos1, VECTOR  Pos2, uint  Color);
		public static int  DrawLine3D( VECTOR  Pos1, VECTOR  Pos2, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLine3D_x86( Pos1 , Pos2 , Color );
			}
			else
			{
				return dx_DrawLine3D_x64( Pos1 , Pos2 , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawLine3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLine3DD_x86( VECTOR_D  Pos1, VECTOR_D  Pos2, uint  Color);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawLine3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawLine3DD_x64( VECTOR_D  Pos1, VECTOR_D  Pos2, uint  Color);
		public static int  DrawLine3DD( VECTOR_D  Pos1, VECTOR_D  Pos2, uint  Color)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawLine3DD_x86( Pos1 , Pos2 , Color );
			}
			else
			{
				return dx_DrawLine3DD_x64( Pos1 , Pos2 , Color );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTriangle3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangle3D_x86( VECTOR  Pos1, VECTOR  Pos2, VECTOR  Pos3, uint  Color, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTriangle3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangle3D_x64( VECTOR  Pos1, VECTOR  Pos2, VECTOR  Pos3, uint  Color, int  FillFlag);
		public static int  DrawTriangle3D( VECTOR  Pos1, VECTOR  Pos2, VECTOR  Pos3, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTriangle3D_x86( Pos1 , Pos2 , Pos3 , Color , FillFlag );
			}
			else
			{
				return dx_DrawTriangle3D_x64( Pos1 , Pos2 , Pos3 , Color , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTriangle3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangle3DD_x86( VECTOR_D  Pos1, VECTOR_D  Pos2, VECTOR_D  Pos3, uint  Color, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTriangle3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangle3DD_x64( VECTOR_D  Pos1, VECTOR_D  Pos2, VECTOR_D  Pos3, uint  Color, int  FillFlag);
		public static int  DrawTriangle3DD( VECTOR_D  Pos1, VECTOR_D  Pos2, VECTOR_D  Pos3, uint  Color, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTriangle3DD_x86( Pos1 , Pos2 , Pos3 , Color , FillFlag );
			}
			else
			{
				return dx_DrawTriangle3DD_x64( Pos1 , Pos2 , Pos3 , Color , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCube3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCube3D_x86( VECTOR  Pos1, VECTOR  Pos2, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCube3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCube3D_x64( VECTOR  Pos1, VECTOR  Pos2, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCube3D( VECTOR  Pos1, VECTOR  Pos2, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCube3D_x86( Pos1 , Pos2 , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCube3D_x64( Pos1 , Pos2 , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCube3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCube3DD_x86( VECTOR_D  Pos1, VECTOR_D  Pos2, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCube3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCube3DD_x64( VECTOR_D  Pos1, VECTOR_D  Pos2, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCube3DD( VECTOR_D  Pos1, VECTOR_D  Pos2, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCube3DD_x86( Pos1 , Pos2 , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCube3DD_x64( Pos1 , Pos2 , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCubeSet3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCubeSet3D_x86( [In, Out] CUBEDATA[]  CubeDataArray, int  Num, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCubeSet3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCubeSet3D_x64( [In, Out] CUBEDATA[]  CubeDataArray, int  Num, int  FillFlag);
		public static int  DrawCubeSet3D( [In, Out] CUBEDATA[]  CubeDataArray, int  Num, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCubeSet3D_x86( CubeDataArray , Num , FillFlag );
			}
			else
			{
				return dx_DrawCubeSet3D_x64( CubeDataArray , Num , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawSphere3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawSphere3D_x86( VECTOR  CenterPos, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawSphere3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawSphere3D_x64( VECTOR  CenterPos, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawSphere3D( VECTOR  CenterPos, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawSphere3D_x86( CenterPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawSphere3D_x64( CenterPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawSphere3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawSphere3DD_x86( VECTOR_D  CenterPos, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawSphere3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawSphere3DD_x64( VECTOR_D  CenterPos, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawSphere3DD( VECTOR_D  CenterPos, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawSphere3DD_x86( CenterPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawSphere3DD_x64( CenterPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCapsule3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCapsule3D_x86( VECTOR  Pos1, VECTOR  Pos2, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCapsule3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCapsule3D_x64( VECTOR  Pos1, VECTOR  Pos2, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCapsule3D( VECTOR  Pos1, VECTOR  Pos2, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCapsule3D_x86( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCapsule3D_x64( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCapsule3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCapsule3DD_x86( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCapsule3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCapsule3DD_x64( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCapsule3DD( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCapsule3DD_x86( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCapsule3DD_x64( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCylinder3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCylinder3D_x86( VECTOR  Pos1, VECTOR  Pos2, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCylinder3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCylinder3D_x64( VECTOR  Pos1, VECTOR  Pos2, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCylinder3D( VECTOR  Pos1, VECTOR  Pos2, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCylinder3D_x86( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCylinder3D_x64( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCylinder3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCylinder3DD_x86( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCylinder3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCylinder3DD_x64( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCylinder3DD( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCylinder3DD_x86( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCylinder3DD_x64( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTube3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTube3D_x86( VECTOR  Pos1, VECTOR  Pos2, float  r1, float  r2, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTube3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTube3D_x64( VECTOR  Pos1, VECTOR  Pos2, float  r1, float  r2, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawTube3D( VECTOR  Pos1, VECTOR  Pos2, float  r1, float  r2, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTube3D_x86( Pos1 , Pos2 , r1 , r2 , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawTube3D_x64( Pos1 , Pos2 , r1 , r2 , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTube3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTube3DD_x86( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r1, double  r2, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTube3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTube3DD_x64( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r1, double  r2, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawTube3DD( VECTOR_D  Pos1, VECTOR_D  Pos2, double  r1, double  r2, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTube3DD_x86( Pos1 , Pos2 , r1 , r2 , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawTube3DD_x64( Pos1 , Pos2 , r1 , r2 , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCone3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCone3D_x86( VECTOR  TopPos, VECTOR  BottomPos, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCone3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCone3D_x64( VECTOR  TopPos, VECTOR  BottomPos, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCone3D( VECTOR  TopPos, VECTOR  BottomPos, float  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCone3D_x86( TopPos , BottomPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCone3D_x64( TopPos , BottomPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCone3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCone3DD_x86( VECTOR_D  TopPos, VECTOR_D  BottomPos, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCone3DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCone3DD_x64( VECTOR_D  TopPos, VECTOR_D  BottomPos, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag);
		public static int  DrawCone3DD( VECTOR_D  TopPos, VECTOR_D  BottomPos, double  r, int  DivNum, uint  DifColor, uint  SpcColor, int  FillFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCone3DD_x86( TopPos , BottomPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
			else
			{
				return dx_DrawCone3DD_x64( TopPos , BottomPos , r , DivNum , DifColor , SpcColor , FillFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadGraphScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraphScreen_x86( int  x, int  y, string  GraphName, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadGraphScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraphScreen_x64( int  x, int  y, string  GraphName, int  TransFlag);
		public static int  LoadGraphScreen( int  x, int  y, string  GraphName, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGraphScreen_x86( x , y , GraphName , TransFlag );
			}
			else
			{
				return dx_LoadGraphScreen_x64( x , y , GraphName , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadGraphScreenWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraphScreenWithStrLen_x86( int  x, int  y, string  GraphName, uint GraphNameLength, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadGraphScreenWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGraphScreenWithStrLen_x64( int  x, int  y, string  GraphName, ulong GraphNameLength, int  TransFlag);
		public static int  LoadGraphScreenWithStrLen( int  x, int  y, string  GraphName, ulong GraphNameLength, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGraphScreenWithStrLen_x86( x , y , GraphName , ( uint )GraphNameLength , TransFlag );
			}
			else
			{
				return dx_LoadGraphScreenWithStrLen_x64( x , y , GraphName , GraphNameLength , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraph_x86( int  x, int  y, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraph_x64( int  x, int  y, int  GrHandle, int  TransFlag);
		public static int  DrawGraph( int  x, int  y, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawGraph_x86( x , y , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawGraph_x64( x , y , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawExtendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraph_x86( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawExtendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraph_x64( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  TransFlag);
		public static int  DrawExtendGraph( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawExtendGraph_x86( x1 , y1 , x2 , y2 , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawExtendGraph_x64( x1 , y1 , x2 , y2 , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph_x86( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph_x64( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph_x86( x , y , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph_x64( x , y , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph_x86( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph_x64( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph_x86( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph_x64( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph2_x86( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph2_x64( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph2( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph2_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph2( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph2_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph2( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph2_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3_x86( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3_x64( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph3( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph3( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph3( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph3_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFast", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast_x86( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFast", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast_x64( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFast( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast_x86( x , y , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast_x64( x , y , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFast( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast_x86( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast_x64( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFast( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast_x86( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFast_x64( x , y , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFast2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast2_x86( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFast2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast2_x64( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFast2( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast2_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFast2( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast2_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFast2( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFast2_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFast3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast3_x86( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFast3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast3_x64( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFast3( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast3_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFast3( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast3_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFast3( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFast3_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawModiGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiGraph_x86( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawModiGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiGraph_x64( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  GrHandle, int  TransFlag);
		public static int  DrawModiGraph( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawModiGraph_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawModiGraph_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTurnGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTurnGraph_x86( int  x, int  y, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTurnGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTurnGraph_x64( int  x, int  y, int  GrHandle, int  TransFlag);
		public static int  DrawTurnGraph( int  x, int  y, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTurnGraph_x86( x , y , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawTurnGraph_x64( x , y , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawReverseGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawReverseGraph_x86( int  x, int  y, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawReverseGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawReverseGraph_x64( int  x, int  y, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawReverseGraph( int  x, int  y, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraph_x86( x , y , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawReverseGraph_x64( x , y , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawReverseGraph( int  x, int  y, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraph_x86( x , y , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawReverseGraph_x64( x , y , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawReverseGraph( int  x, int  y, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraph_x86( x , y , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawReverseGraph_x64( x , y , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraphF_x86( float  xf, float  yf, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraphF_x64( float  xf, float  yf, int  GrHandle, int  TransFlag);
		public static int  DrawGraphF( float  xf, float  yf, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawGraphF_x86( xf , yf , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawGraphF_x64( xf , yf , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawExtendGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraphF_x86( float  x1f, float  y1f, float  x2f, float  y2f, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawExtendGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraphF_x64( float  x1f, float  y1f, float  x2f, float  y2f, int  GrHandle, int  TransFlag);
		public static int  DrawExtendGraphF( float  x1f, float  y1f, float  x2f, float  y2f, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawExtendGraphF_x86( x1f , y1f , x2f , y2f , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawExtendGraphF_x64( x1f , y1f , x2f , y2f , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphF_x86( float  xf, float  yf, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphF_x64( float  xf, float  yf, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphF( float  xf, float  yf, double  ExRate, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphF_x86( xf , yf , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphF_x64( xf , yf , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphF( float  xf, float  yf, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphF_x86( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphF_x64( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphF( float  xf, float  yf, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphF_x86( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphF_x64( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph2F_x86( float  xf, float  yf, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph2F_x64( float  xf, float  yf, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph2F( float  xf, float  yf, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2F_x86( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph2F_x64( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph2F( float  xf, float  yf, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2F_x86( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph2F_x64( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph2F( float  xf, float  yf, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2F_x86( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph2F_x64( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3F_x86( float  xf, float  yf, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3F_x64( float  xf, float  yf, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph3F( float  xf, float  yf, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3F_x86( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3F_x64( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph3F( float  xf, float  yf, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3F_x86( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3F_x64( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph3F( float  xf, float  yf, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3F_x86( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph3F_x64( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFastF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFastF_x86( float  xf, float  yf, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFastF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFastF_x64( float  xf, float  yf, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFastF( float  xf, float  yf, float  ExRate, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFastF_x86( xf , yf , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFastF_x64( xf , yf , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFastF( float  xf, float  yf, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFastF_x86( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFastF_x64( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFastF( float  xf, float  yf, float  ExRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFastF_x86( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFastF_x64( xf , yf , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFast2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast2F_x86( float  xf, float  yf, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFast2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast2F_x64( float  xf, float  yf, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFast2F( float  xf, float  yf, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2F_x86( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast2F_x64( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFast2F( float  xf, float  yf, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2F_x86( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast2F_x64( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFast2F( float  xf, float  yf, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2F_x86( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFast2F_x64( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFast3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast3F_x86( float  xf, float  yf, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFast3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast3F_x64( float  xf, float  yf, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFast3F( float  xf, float  yf, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3F_x86( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast3F_x64( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFast3F( float  xf, float  yf, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3F_x86( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast3F_x64( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFast3F( float  xf, float  yf, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3F_x86( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFast3F_x64( xf , yf , cxf , cyf , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawModiGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiGraphF_x86( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawModiGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiGraphF_x64( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  GrHandle, int  TransFlag);
		public static int  DrawModiGraphF( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawModiGraphF_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawModiGraphF_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTurnGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTurnGraphF_x86( float  xf, float  yf, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTurnGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTurnGraphF_x64( float  xf, float  yf, int  GrHandle, int  TransFlag);
		public static int  DrawTurnGraphF( float  xf, float  yf, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTurnGraphF_x86( xf , yf , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawTurnGraphF_x64( xf , yf , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawReverseGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawReverseGraphF_x86( float  xf, float  yf, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawReverseGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawReverseGraphF_x64( float  xf, float  yf, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawReverseGraphF( float  xf, float  yf, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraphF_x86( xf , yf , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawReverseGraphF_x64( xf , yf , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawReverseGraphF( float  xf, float  yf, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraphF_x86( xf , yf , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawReverseGraphF_x64( xf , yf , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawReverseGraphF( float  xf, float  yf, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraphF_x86( xf , yf , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawReverseGraphF_x64( xf , yf , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawChipMap2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawChipMap2_x86( int  MapWidth, int  MapHeight, out int  MapData, int  ChipTypeNum, out int  ChipGrHandle, int  TransFlag, int  MapDrawPointX, int  MapDrawPointY, int  MapDrawWidth, int  MapDrawHeight, int  ScreenX, int  ScreenY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawChipMap2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawChipMap2_x64( int  MapWidth, int  MapHeight, out int  MapData, int  ChipTypeNum, out int  ChipGrHandle, int  TransFlag, int  MapDrawPointX, int  MapDrawPointY, int  MapDrawWidth, int  MapDrawHeight, int  ScreenX, int  ScreenY);
		public static int  DrawChipMap2( int  MapWidth, int  MapHeight, out int  MapData, int  ChipTypeNum, out int  ChipGrHandle, int  TransFlag, int  MapDrawPointX, int  MapDrawPointY, int  MapDrawWidth, int  MapDrawHeight, int  ScreenX, int  ScreenY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawChipMap2_x86( MapWidth , MapHeight , out MapData , ChipTypeNum , out ChipGrHandle , TransFlag , MapDrawPointX , MapDrawPointY , MapDrawWidth , MapDrawHeight , ScreenX , ScreenY );
			}
			else
			{
				return dx_DrawChipMap2_x64( MapWidth , MapHeight , out MapData , ChipTypeNum , out ChipGrHandle , TransFlag , MapDrawPointX , MapDrawPointY , MapDrawWidth , MapDrawHeight , ScreenX , ScreenY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTile", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTile_x86( int  x1, int  y1, int  x2, int  y2, int  Tx, int  Ty, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTile", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTile_x64( int  x1, int  y1, int  x2, int  y2, int  Tx, int  Ty, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag);
		public static int  DrawTile( int  x1, int  y1, int  x2, int  y2, int  Tx, int  Ty, double  ExtRate, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTile_x86( x1 , y1 , x2 , y2 , Tx , Ty , ExtRate , Angle , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawTile_x64( x1 , y1 , x2 , y2 , Tx , Ty , ExtRate , Angle , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectGraph_x86( int  DestX, int  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectGraph_x64( int  DestX, int  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectGraph( int  DestX, int  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraph_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectGraph_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectGraph( int  DestX, int  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraph_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectGraph_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectGraph( int  DestX, int  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraph_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectGraph_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectExtendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectExtendGraph_x86( int  DestX1, int  DestY1, int  DestX2, int  DestY2, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, int  GraphHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectExtendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectExtendGraph_x64( int  DestX1, int  DestY1, int  DestX2, int  DestY2, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, int  GraphHandle, int  TransFlag);
		public static int  DrawRectExtendGraph( int  DestX1, int  DestY1, int  DestX2, int  DestY2, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectExtendGraph_x86( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , GraphHandle , TransFlag );
			}
			else
			{
				return dx_DrawRectExtendGraph_x64( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , GraphHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph_x86( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph_x64( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraph( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraph( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraph( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraph_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraph2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph2_x86( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraph2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph2_x64( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraph2( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph2_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph2_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraph2( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph2_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph2_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraph2( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph2_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraph2_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraph3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph3_x86( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraph3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph3_x64( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraph3( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph3_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph3_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraph3( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph3_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph3_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraph3( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph3_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraph3_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraphFast", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast_x86( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraphFast", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast_x64( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraphFast( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraphFast_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraphFast2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast2_x86( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraphFast2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast2_x64( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraphFast2( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast2_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast2_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast2( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast2_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast2_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast2( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast2_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraphFast2_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraphFast3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast3_x86( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraphFast3", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast3_x64( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraphFast3( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast3_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast3_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast3( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast3_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast3_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast3( int  x, int  y, int  SrcX, int  SrcY, int  Width, int  Height, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast3_x86( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraphFast3_x64( x , y , SrcX , SrcY , Width , Height , cx , cy , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectModiGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectModiGraph_x86( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectModiGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectModiGraph_x64( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag);
		public static int  DrawRectModiGraph( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectModiGraph_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , SrcX , SrcY , Width , Height , GraphHandle , TransFlag );
			}
			else
			{
				return dx_DrawRectModiGraph_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , SrcX , SrcY , Width , Height , GraphHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectGraphF_x86( float  DestX, float  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectGraphF_x64( float  DestX, float  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectGraphF( float  DestX, float  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraphF_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectGraphF_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectGraphF( float  DestX, float  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraphF_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectGraphF_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectGraphF( float  DestX, float  DestY, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraphF_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectGraphF_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectGraphF2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectGraphF2_x86( float  DestX, float  DestY, float  SrcX, float  SrcY, float  Width, float  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectGraphF2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectGraphF2_x64( float  DestX, float  DestY, float  SrcX, float  SrcY, float  Width, float  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectGraphF2( float  DestX, float  DestY, float  SrcX, float  SrcY, float  Width, float  Height, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraphF2_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectGraphF2_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectGraphF2( float  DestX, float  DestY, float  SrcX, float  SrcY, float  Width, float  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraphF2_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectGraphF2_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectGraphF2( float  DestX, float  DestY, float  SrcX, float  SrcY, float  Width, float  Height, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectGraphF2_x86( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectGraphF2_x64( DestX , DestY , SrcX , SrcY , Width , Height , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectExtendGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectExtendGraphF_x86( float  DestX1, float  DestY1, float  DestX2, float  DestY2, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, int  GraphHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectExtendGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectExtendGraphF_x64( float  DestX1, float  DestY1, float  DestX2, float  DestY2, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, int  GraphHandle, int  TransFlag);
		public static int  DrawRectExtendGraphF( float  DestX1, float  DestY1, float  DestX2, float  DestY2, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectExtendGraphF_x86( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , GraphHandle , TransFlag );
			}
			else
			{
				return dx_DrawRectExtendGraphF_x64( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , GraphHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectExtendGraphF2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectExtendGraphF2_x86( float  DestX1, float  DestY1, float  DestX2, float  DestY2, float  SrcX, float  SrcY, float  SrcWidth, float  SrcHeight, int  GraphHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectExtendGraphF2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectExtendGraphF2_x64( float  DestX1, float  DestY1, float  DestX2, float  DestY2, float  SrcX, float  SrcY, float  SrcWidth, float  SrcHeight, int  GraphHandle, int  TransFlag);
		public static int  DrawRectExtendGraphF2( float  DestX1, float  DestY1, float  DestX2, float  DestY2, float  SrcX, float  SrcY, float  SrcWidth, float  SrcHeight, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectExtendGraphF2_x86( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , GraphHandle , TransFlag );
			}
			else
			{
				return dx_DrawRectExtendGraphF2_x64( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , GraphHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphF_x86( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphF_x64( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraphF( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphF_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphF_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraphF( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphF_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphF_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraphF( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphF_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraphF_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraph2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph2F_x86( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraph2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph2F_x64( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraph2F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph2F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph2F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraph2F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph2F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph2F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraph2F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRate, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph2F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraph2F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraph3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph3F_x86( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraph3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraph3F_x64( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraph3F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph3F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph3F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraph3F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph3F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraph3F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraph3F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, double  ExtRateX, double  ExtRateY, double  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraph3F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraph3F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraphFastF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFastF_x86( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraphFastF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFastF_x64( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraphFastF( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFastF_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFastF_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFastF( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFastF_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFastF_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFastF( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFastF_x86( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraphFastF_x64( x , y , SrcX , SrcY , Width , Height , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraphFast2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast2F_x86( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraphFast2F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast2F_x64( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraphFast2F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast2F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast2F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast2F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast2F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast2F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast2F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRate, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast2F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraphFast2F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRate , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectRotaGraphFast3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast3F_x86( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectRotaGraphFast3F", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectRotaGraphFast3F_x64( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectRotaGraphFast3F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast3F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast3F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast3F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast3F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectRotaGraphFast3F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectRotaGraphFast3F( float  x, float  y, int  SrcX, int  SrcY, int  Width, int  Height, float  cxf, float  cyf, float  ExtRateX, float  ExtRateY, float  Angle, int  GraphHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectRotaGraphFast3F_x86( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectRotaGraphFast3F_x64( x , y , SrcX , SrcY , Width , Height , cxf , cyf , ExtRateX , ExtRateY , Angle , GraphHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectModiGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectModiGraphF_x86( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectModiGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectModiGraphF_x64( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag);
		public static int  DrawRectModiGraphF( float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  SrcX, int  SrcY, int  Width, int  Height, int  GraphHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectModiGraphF_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , SrcX , SrcY , Width , Height , GraphHandle , TransFlag );
			}
			else
			{
				return dx_DrawRectModiGraphF_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , SrcX , SrcY , Width , Height , GraphHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBlendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBlendGraph_x86( int  x, int  y, int  GrHandle, int  TransFlag, int  BlendGraph, int  BorderParam, int  BorderRange);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBlendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBlendGraph_x64( int  x, int  y, int  GrHandle, int  TransFlag, int  BlendGraph, int  BorderParam, int  BorderRange);
		public static int  DrawBlendGraph( int  x, int  y, int  GrHandle, int  TransFlag, int  BlendGraph, int  BorderParam, int  BorderRange)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBlendGraph_x86( x , y , GrHandle , TransFlag , BlendGraph , BorderParam , BorderRange );
			}
			else
			{
				return dx_DrawBlendGraph_x64( x , y , GrHandle , TransFlag , BlendGraph , BorderParam , BorderRange );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBlendGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBlendGraphF_x86( float  x, float  y, int  GrHandle, int  TransFlag, int  BlendGraph, int  BorderParam, int  BorderRange);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBlendGraphF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBlendGraphF_x64( float  x, float  y, int  GrHandle, int  TransFlag, int  BlendGraph, int  BorderParam, int  BorderRange);
		public static int  DrawBlendGraphF( float  x, float  y, int  GrHandle, int  TransFlag, int  BlendGraph, int  BorderParam, int  BorderRange)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBlendGraphF_x86( x , y , GrHandle , TransFlag , BlendGraph , BorderParam , BorderRange );
			}
			else
			{
				return dx_DrawBlendGraphF_x64( x , y , GrHandle , TransFlag , BlendGraph , BorderParam , BorderRange );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBlendGraphPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBlendGraphPos_x86( int  x, int  y, int  GrHandle, int  TransFlag, int  bx, int  by, int  BlendGraph, int  BorderParam, int  BorderRange);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBlendGraphPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBlendGraphPos_x64( int  x, int  y, int  GrHandle, int  TransFlag, int  bx, int  by, int  BlendGraph, int  BorderParam, int  BorderRange);
		public static int  DrawBlendGraphPos( int  x, int  y, int  GrHandle, int  TransFlag, int  bx, int  by, int  BlendGraph, int  BorderParam, int  BorderRange)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBlendGraphPos_x86( x , y , GrHandle , TransFlag , bx , by , BlendGraph , BorderParam , BorderRange );
			}
			else
			{
				return dx_DrawBlendGraphPos_x64( x , y , GrHandle , TransFlag , bx , by , BlendGraph , BorderParam , BorderRange );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCircleGauge", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleGauge_x86( int  CenterX, int  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX, int  ReverseY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCircleGauge", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleGauge_x64( int  CenterX, int  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX, int  ReverseY);
		public static int  DrawCircleGauge( int  CenterX, int  CenterY, double  Percent, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGauge_x86( CenterX , CenterY , Percent , GrHandle , 0.0 , 1.0 , FALSE , FALSE );
			}
			else
			{
				return dx_DrawCircleGauge_x64( CenterX , CenterY , Percent , GrHandle , 0.0 , 1.0 , FALSE , FALSE );
			}
		}
		public static int  DrawCircleGauge( int  CenterX, int  CenterY, double  Percent, int  GrHandle, double  StartPercent)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGauge_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , 1.0 , FALSE , FALSE );
			}
			else
			{
				return dx_DrawCircleGauge_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , 1.0 , FALSE , FALSE );
			}
		}
		public static int  DrawCircleGauge( int  CenterX, int  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGauge_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , FALSE , FALSE );
			}
			else
			{
				return dx_DrawCircleGauge_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , FALSE , FALSE );
			}
		}
		public static int  DrawCircleGauge( int  CenterX, int  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGauge_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , FALSE );
			}
			else
			{
				return dx_DrawCircleGauge_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , FALSE );
			}
		}
		public static int  DrawCircleGauge( int  CenterX, int  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX, int  ReverseY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGauge_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , ReverseY );
			}
			else
			{
				return dx_DrawCircleGauge_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , ReverseY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCircleGaugeF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleGaugeF_x86( float  CenterX, float  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX, int  ReverseY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCircleGaugeF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleGaugeF_x64( float  CenterX, float  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX, int  ReverseY);
		public static int  DrawCircleGaugeF( float  CenterX, float  CenterY, double  Percent, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGaugeF_x86( CenterX , CenterY , Percent , GrHandle , 0.0 , 1.0 , FALSE , FALSE );
			}
			else
			{
				return dx_DrawCircleGaugeF_x64( CenterX , CenterY , Percent , GrHandle , 0.0 , 1.0 , FALSE , FALSE );
			}
		}
		public static int  DrawCircleGaugeF( float  CenterX, float  CenterY, double  Percent, int  GrHandle, double  StartPercent)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGaugeF_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , 1.0 , FALSE , FALSE );
			}
			else
			{
				return dx_DrawCircleGaugeF_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , 1.0 , FALSE , FALSE );
			}
		}
		public static int  DrawCircleGaugeF( float  CenterX, float  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGaugeF_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , FALSE , FALSE );
			}
			else
			{
				return dx_DrawCircleGaugeF_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , FALSE , FALSE );
			}
		}
		public static int  DrawCircleGaugeF( float  CenterX, float  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGaugeF_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , FALSE );
			}
			else
			{
				return dx_DrawCircleGaugeF_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , FALSE );
			}
		}
		public static int  DrawCircleGaugeF( float  CenterX, float  CenterY, double  Percent, int  GrHandle, double  StartPercent, double  Scale, int  ReverseX, int  ReverseY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleGaugeF_x86( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , ReverseY );
			}
			else
			{
				return dx_DrawCircleGaugeF_x64( CenterX , CenterY , Percent , GrHandle , StartPercent , Scale , ReverseX , ReverseY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraphToZBuffer_x86( int  X, int  Y, int  GrHandle, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraphToZBuffer_x64( int  X, int  Y, int  GrHandle, int  WriteZMode);
		public static int  DrawGraphToZBuffer( int  X, int  Y, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawGraphToZBuffer_x86( X , Y , GrHandle , WriteZMode );
			}
			else
			{
				return dx_DrawGraphToZBuffer_x64( X , Y , GrHandle , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTurnGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTurnGraphToZBuffer_x86( int  x, int  y, int  GrHandle, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTurnGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTurnGraphToZBuffer_x64( int  x, int  y, int  GrHandle, int  WriteZMode);
		public static int  DrawTurnGraphToZBuffer( int  x, int  y, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTurnGraphToZBuffer_x86( x , y , GrHandle , WriteZMode );
			}
			else
			{
				return dx_DrawTurnGraphToZBuffer_x64( x , y , GrHandle , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawReverseGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawReverseGraphToZBuffer_x86( int  x, int  y, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawReverseGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawReverseGraphToZBuffer_x64( int  x, int  y, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawReverseGraphToZBuffer( int  x, int  y, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraphToZBuffer_x86( x , y , GrHandle , WriteZMode , FALSE , FALSE );
			}
			else
			{
				return dx_DrawReverseGraphToZBuffer_x64( x , y , GrHandle , WriteZMode , FALSE , FALSE );
			}
		}
		public static int  DrawReverseGraphToZBuffer( int  x, int  y, int  GrHandle, int  WriteZMode, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraphToZBuffer_x86( x , y , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawReverseGraphToZBuffer_x64( x , y , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawReverseGraphToZBuffer( int  x, int  y, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawReverseGraphToZBuffer_x86( x , y , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawReverseGraphToZBuffer_x64( x , y , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawExtendGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraphToZBuffer_x86( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawExtendGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraphToZBuffer_x64( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  WriteZMode);
		public static int  DrawExtendGraphToZBuffer( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawExtendGraphToZBuffer_x86( x1 , y1 , x2 , y2 , GrHandle , WriteZMode );
			}
			else
			{
				return dx_DrawExtendGraphToZBuffer_x64( x1 , y1 , x2 , y2 , GrHandle , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphToZBuffer_x86( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphToZBuffer_x64( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphToZBuffer( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphToZBuffer_x86( x , y , ExRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphToZBuffer_x64( x , y , ExRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphToZBuffer( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphToZBuffer_x86( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphToZBuffer_x64( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphToZBuffer( int  x, int  y, double  ExRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphToZBuffer_x86( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphToZBuffer_x64( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph2ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph2ToZBuffer_x86( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph2ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph2ToZBuffer_x64( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph2ToZBuffer( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2ToZBuffer_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph2ToZBuffer_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph2ToZBuffer( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2ToZBuffer_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph2ToZBuffer_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph2ToZBuffer( int  x, int  y, int  cx, int  cy, double  ExtRate, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph2ToZBuffer_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph2ToZBuffer_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph3ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3ToZBuffer_x86( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph3ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3ToZBuffer_x64( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph3ToZBuffer( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3ToZBuffer_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3ToZBuffer_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph3ToZBuffer( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3ToZBuffer_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3ToZBuffer_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph3ToZBuffer( int  x, int  y, int  cx, int  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3ToZBuffer_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph3ToZBuffer_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFastToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFastToZBuffer_x86( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFastToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFastToZBuffer_x64( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFastToZBuffer( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFastToZBuffer_x86( x , y , ExRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFastToZBuffer_x64( x , y , ExRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFastToZBuffer( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFastToZBuffer_x86( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFastToZBuffer_x64( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFastToZBuffer( int  x, int  y, float  ExRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFastToZBuffer_x86( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFastToZBuffer_x64( x , y , ExRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFast2ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast2ToZBuffer_x86( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFast2ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast2ToZBuffer_x64( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFast2ToZBuffer( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2ToZBuffer_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast2ToZBuffer_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFast2ToZBuffer( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2ToZBuffer_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast2ToZBuffer_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFast2ToZBuffer( int  x, int  y, int  cx, int  cy, float  ExtRate, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast2ToZBuffer_x86( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFast2ToZBuffer_x64( x , y , cx , cy , ExtRate , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraphFast3ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast3ToZBuffer_x86( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraphFast3ToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraphFast3ToZBuffer_x64( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraphFast3ToZBuffer( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3ToZBuffer_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast3ToZBuffer_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraphFast3ToZBuffer( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3ToZBuffer_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraphFast3ToZBuffer_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraphFast3ToZBuffer( int  x, int  y, int  cx, int  cy, float  ExtRateX, float  ExtRateY, float  Angle, int  GrHandle, int  WriteZMode, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraphFast3ToZBuffer_x86( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraphFast3ToZBuffer_x64( x , y , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , WriteZMode , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawModiGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiGraphToZBuffer_x86( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  GrHandle, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawModiGraphToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiGraphToZBuffer_x64( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  GrHandle, int  WriteZMode);
		public static int  DrawModiGraphToZBuffer( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  GrHandle, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawModiGraphToZBuffer_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , WriteZMode );
			}
			else
			{
				return dx_DrawModiGraphToZBuffer_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBoxToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBoxToZBuffer_x86( int  x1, int  y1, int  x2, int  y2, int  FillFlag, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBoxToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBoxToZBuffer_x64( int  x1, int  y1, int  x2, int  y2, int  FillFlag, int  WriteZMode);
		public static int  DrawBoxToZBuffer( int  x1, int  y1, int  x2, int  y2, int  FillFlag, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBoxToZBuffer_x86( x1 , y1 , x2 , y2 , FillFlag , WriteZMode );
			}
			else
			{
				return dx_DrawBoxToZBuffer_x64( x1 , y1 , x2 , y2 , FillFlag , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawCircleToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleToZBuffer_x86( int  x, int  y, int  r, int  FillFlag, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawCircleToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawCircleToZBuffer_x64( int  x, int  y, int  r, int  FillFlag, int  WriteZMode);
		public static int  DrawCircleToZBuffer( int  x, int  y, int  r, int  FillFlag, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawCircleToZBuffer_x86( x , y , r , FillFlag , WriteZMode );
			}
			else
			{
				return dx_DrawCircleToZBuffer_x64( x , y , r , FillFlag , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawTriangleToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangleToZBuffer_x86( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  FillFlag, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawTriangleToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawTriangleToZBuffer_x64( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  FillFlag, int  WriteZMode);
		public static int  DrawTriangleToZBuffer( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  FillFlag, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawTriangleToZBuffer_x86( x1 , y1 , x2 , y2 , x3 , y3 , FillFlag , WriteZMode );
			}
			else
			{
				return dx_DrawTriangleToZBuffer_x64( x1 , y1 , x2 , y2 , x3 , y3 , FillFlag , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawQuadrangleToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawQuadrangleToZBuffer_x86( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  FillFlag, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawQuadrangleToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawQuadrangleToZBuffer_x64( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  FillFlag, int  WriteZMode);
		public static int  DrawQuadrangleToZBuffer( int  x1, int  y1, int  x2, int  y2, int  x3, int  y3, int  x4, int  y4, int  FillFlag, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawQuadrangleToZBuffer_x86( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , FillFlag , WriteZMode );
			}
			else
			{
				return dx_DrawQuadrangleToZBuffer_x64( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , FillFlag , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRoundRectToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRoundRectToZBuffer_x86( int  x1, int  y1, int  x2, int  y2, int  rx, int  ry, int  FillFlag, int  WriteZMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRoundRectToZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRoundRectToZBuffer_x64( int  x1, int  y1, int  x2, int  y2, int  rx, int  ry, int  FillFlag, int  WriteZMode);
		public static int  DrawRoundRectToZBuffer( int  x1, int  y1, int  x2, int  y2, int  rx, int  ry, int  FillFlag, int  WriteZMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRoundRectToZBuffer_x86( x1 , y1 , x2 , y2 , rx , ry , FillFlag , WriteZMode );
			}
			else
			{
				return dx_DrawRoundRectToZBuffer_x64( x1 , y1 , x2 , y2 , rx , ry , FillFlag , WriteZMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon_x86( [In, Out] VERTEX[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag, int  UVScaling);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon_x64( [In, Out] VERTEX[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag, int  UVScaling);
		public static int  DrawPolygon( [In, Out] VERTEX[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon_x86( VertexArray , PolygonNum , GrHandle , TransFlag , FALSE );
			}
			else
			{
				return dx_DrawPolygon_x64( VertexArray , PolygonNum , GrHandle , TransFlag , FALSE );
			}
		}
		public static int  DrawPolygon( [In, Out] VERTEX[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag, int  UVScaling)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon_x86( VertexArray , PolygonNum , GrHandle , TransFlag , UVScaling );
			}
			else
			{
				return dx_DrawPolygon_x64( VertexArray , PolygonNum , GrHandle , TransFlag , UVScaling );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon2D_x86( [In, Out] VERTEX2D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon2D_x64( [In, Out] VERTEX2D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon2D( [In, Out] VERTEX2D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon2D_x86( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon2D_x64( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D_x86( [In, Out] VERTEX3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D_x64( [In, Out] VERTEX3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon3D( [In, Out] VERTEX3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon3D_x86( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon3D_x64( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed2D_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed2D_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygonIndexed2D( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed2D_x86( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygonIndexed2D_x64( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon32bitIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed2D_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon32bitIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed2D_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon32bitIndexed2D( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon32bitIndexed2D_x86( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon32bitIndexed2D_x64( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3D_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3D_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygonIndexed3D( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed3D_x86( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygonIndexed3D_x64( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon32bitIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3D_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon32bitIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3D_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon32bitIndexed3D( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon32bitIndexed3D_x86( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon32bitIndexed3D_x64( VertexArray , VertexNum , IndexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed3DBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3DBase_x86( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed3DBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3DBase_x64( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPolygonIndexed3DBase( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed3DBase_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygonIndexed3DBase_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon32bitIndexed3DBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3DBase_x86( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon32bitIndexed3DBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3DBase_x64( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon32bitIndexed3DBase( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon32bitIndexed3DBase_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon32bitIndexed3DBase_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3DBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DBase_x86( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3DBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DBase_x64( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon3DBase( [In, Out] VERTEX_3D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon3DBase_x86( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon3DBase_x64( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3D_2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D_2_x86( [In, Out] VERTEX_3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3D_2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D_2_x64( [In, Out] VERTEX_3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon3D( [In, Out] VERTEX_3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon3D_2_x86( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon3D_2_x64( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3D2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D2_x86( [In, Out] VERTEX_3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3D2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D2_x64( [In, Out] VERTEX_3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon3D2( [In, Out] VERTEX_3D[]  VertexArray, int  PolygonNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon3D2_x86( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon3D2_x64( VertexArray , PolygonNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonBase_x86( [In, Out] VERTEX[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag, int  UVScaling);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonBase", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonBase_x64( [In, Out] VERTEX[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag, int  UVScaling);
		public static int  DrawPolygonBase( [In, Out] VERTEX[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonBase_x86( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag , FALSE );
			}
			else
			{
				return dx_DrawPolygonBase_x64( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag , FALSE );
			}
		}
		public static int  DrawPolygonBase( [In, Out] VERTEX[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag, int  UVScaling)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonBase_x86( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag , UVScaling );
			}
			else
			{
				return dx_DrawPolygonBase_x64( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag , UVScaling );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive2D_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive2D_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitive2D( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive2D_x86( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitive2D_x64( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3D_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3D_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitive3D( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive3D_x86( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitive3D_x64( VertexArray , VertexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed2D_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed2D_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitiveIndexed2D( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed2D_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitiveIndexed2D_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive32bitIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed2D_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive32bitIndexed2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed2D_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitive32bitIndexed2D( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive32bitIndexed2D_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitive32bitIndexed2D_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3D_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3D_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitiveIndexed3D( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed3D_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitiveIndexed3D_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive32bitIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed3D_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive32bitIndexed3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed3D_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitive32bitIndexed3D( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive32bitIndexed3D_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitive32bitIndexed3D_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D_UseVertexBuffer_x86( int  VertexBufHandle, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3D_UseVertexBuffer_x64( int  VertexBufHandle, int  GrHandle, int  TransFlag);
		public static int  DrawPolygon3D_UseVertexBuffer( int  VertexBufHandle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon3D_UseVertexBuffer_x86( VertexBufHandle , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygon3D_UseVertexBuffer_x64( VertexBufHandle , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3D_UseVertexBuffer_x86( int  VertexBufHandle, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3D_UseVertexBuffer_x64( int  VertexBufHandle, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitive3D_UseVertexBuffer( int  VertexBufHandle, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive3D_UseVertexBuffer_x86( VertexBufHandle , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitive3D_UseVertexBuffer_x64( VertexBufHandle , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive3D_UseVertexBuffer2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3D_UseVertexBuffer2_x86( int  VertexBufHandle, int  PrimitiveType, int  StartVertex, int  UseVertexNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive3D_UseVertexBuffer2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3D_UseVertexBuffer2_x64( int  VertexBufHandle, int  PrimitiveType, int  StartVertex, int  UseVertexNum, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitive3D_UseVertexBuffer2( int  VertexBufHandle, int  PrimitiveType, int  StartVertex, int  UseVertexNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive3D_UseVertexBuffer2_x86( VertexBufHandle , PrimitiveType , StartVertex , UseVertexNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitive3D_UseVertexBuffer2_x64( VertexBufHandle , PrimitiveType , StartVertex , UseVertexNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3D_UseVertexBuffer_x86( int  VertexBufHandle, int  IndexBufHandle, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3D_UseVertexBuffer_x64( int  VertexBufHandle, int  IndexBufHandle, int  GrHandle, int  TransFlag);
		public static int  DrawPolygonIndexed3D_UseVertexBuffer( int  VertexBufHandle, int  IndexBufHandle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed3D_UseVertexBuffer_x86( VertexBufHandle , IndexBufHandle , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPolygonIndexed3D_UseVertexBuffer_x64( VertexBufHandle , IndexBufHandle , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3D_UseVertexBuffer_x86( int  VertexBufHandle, int  IndexBufHandle, int  PrimitiveType, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed3D_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3D_UseVertexBuffer_x64( int  VertexBufHandle, int  IndexBufHandle, int  PrimitiveType, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitiveIndexed3D_UseVertexBuffer( int  VertexBufHandle, int  IndexBufHandle, int  PrimitiveType, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed3D_UseVertexBuffer_x86( VertexBufHandle , IndexBufHandle , PrimitiveType , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitiveIndexed3D_UseVertexBuffer_x64( VertexBufHandle , IndexBufHandle , PrimitiveType , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed3D_UseVertexBuffer2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3D_UseVertexBuffer2_x86( int  VertexBufHandle, int  IndexBufHandle, int  PrimitiveType, int  BaseVertex, int  StartVertex, int  UseVertexNum, int  StartIndex, int  UseIndexNum, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed3D_UseVertexBuffer2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3D_UseVertexBuffer2_x64( int  VertexBufHandle, int  IndexBufHandle, int  PrimitiveType, int  BaseVertex, int  StartVertex, int  UseVertexNum, int  StartIndex, int  UseIndexNum, int  GrHandle, int  TransFlag);
		public static int  DrawPrimitiveIndexed3D_UseVertexBuffer2( int  VertexBufHandle, int  IndexBufHandle, int  PrimitiveType, int  BaseVertex, int  StartVertex, int  UseVertexNum, int  StartIndex, int  UseIndexNum, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed3D_UseVertexBuffer2_x86( VertexBufHandle , IndexBufHandle , PrimitiveType , BaseVertex , StartVertex , UseVertexNum , StartIndex , UseIndexNum , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawPrimitiveIndexed3D_UseVertexBuffer2_x64( VertexBufHandle , IndexBufHandle , PrimitiveType , BaseVertex , StartVertex , UseVertexNum , StartIndex , UseIndexNum , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawGraph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraph3D_x86( float  x, float  y, float  z, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawGraph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawGraph3D_x64( float  x, float  y, float  z, int  GrHandle, int  TransFlag);
		public static int  DrawGraph3D( float  x, float  y, float  z, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawGraph3D_x86( x , y , z , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawGraph3D_x64( x , y , z , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawExtendGraph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraph3D_x86( float  x, float  y, float  z, double  ExRateX, double  ExRateY, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawExtendGraph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawExtendGraph3D_x64( float  x, float  y, float  z, double  ExRateX, double  ExRateY, int  GrHandle, int  TransFlag);
		public static int  DrawExtendGraph3D( float  x, float  y, float  z, double  ExRateX, double  ExRateY, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawExtendGraph3D_x86( x , y , z , ExRateX , ExRateY , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawExtendGraph3D_x64( x , y , z , ExRateX , ExRateY , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRotaGraph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3D_x86( float  x, float  y, float  z, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRotaGraph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRotaGraph3D_x64( float  x, float  y, float  z, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRotaGraph3D( float  x, float  y, float  z, double  ExRate, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3D_x86( x , y , z , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3D_x64( x , y , z , ExRate , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRotaGraph3D( float  x, float  y, float  z, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3D_x86( x , y , z , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRotaGraph3D_x64( x , y , z , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRotaGraph3D( float  x, float  y, float  z, double  ExRate, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRotaGraph3D_x86( x , y , z , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRotaGraph3D_x64( x , y , z , ExRate , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRota2Graph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRota2Graph3D_x86( float  x, float  y, float  z, float  cx, float  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRota2Graph3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRota2Graph3D_x64( float  x, float  y, float  z, float  cx, float  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRota2Graph3D( float  x, float  y, float  z, float  cx, float  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRota2Graph3D_x86( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRota2Graph3D_x64( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRota2Graph3D( float  x, float  y, float  z, float  cx, float  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRota2Graph3D_x86( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRota2Graph3D_x64( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRota2Graph3D( float  x, float  y, float  z, float  cx, float  cy, double  ExtRateX, double  ExtRateY, double  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRota2Graph3D_x86( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRota2Graph3D_x64( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawModiBillboard3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiBillboard3D_x86( VECTOR  Pos, float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  GrHandle, int  TransFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawModiBillboard3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawModiBillboard3D_x64( VECTOR  Pos, float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  GrHandle, int  TransFlag);
		public static int  DrawModiBillboard3D( VECTOR  Pos, float  x1, float  y1, float  x2, float  y2, float  x3, float  y3, float  x4, float  y4, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawModiBillboard3D_x86( Pos , x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , TransFlag );
			}
			else
			{
				return dx_DrawModiBillboard3D_x64( Pos , x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , GrHandle , TransFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBillboard3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBillboard3D_x86( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBillboard3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBillboard3D_x64( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawBillboard3D( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBillboard3D_x86( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawBillboard3D_x64( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawBillboard3D( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBillboard3D_x86( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawBillboard3D_x64( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawBillboard3D( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBillboard3D_x86( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawBillboard3D_x64( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawRectBillboard3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectBillboard3D_x86( VECTOR  Pos, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawRectBillboard3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawRectBillboard3D_x64( VECTOR  Pos, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawRectBillboard3D( VECTOR  Pos, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectBillboard3D_x86( Pos , SrcX , SrcY , SrcWidth , SrcHeight , cx , cy , Size , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawRectBillboard3D_x64( Pos , SrcX , SrcY , SrcWidth , SrcHeight , cx , cy , Size , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawRectBillboard3D( VECTOR  Pos, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectBillboard3D_x86( Pos , SrcX , SrcY , SrcWidth , SrcHeight , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawRectBillboard3D_x64( Pos , SrcX , SrcY , SrcWidth , SrcHeight , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawRectBillboard3D( VECTOR  Pos, int  SrcX, int  SrcY, int  SrcWidth, int  SrcHeight, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawRectBillboard3D_x86( Pos , SrcX , SrcY , SrcWidth , SrcHeight , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawRectBillboard3D_x64( Pos , SrcX , SrcY , SrcWidth , SrcHeight , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawMode_x86( int  DrawMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawMode_x64( int  DrawMode);
		public static int  SetDrawMode( int  DrawMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawMode_x86( DrawMode );
			}
			else
			{
				return dx_SetDrawMode_x64( DrawMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawMode_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawMode_x64( );
		public static int  GetDrawMode( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawMode_x86( );
			}
			else
			{
				return dx_GetDrawMode_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawBlendMode_x86( int  BlendMode, int  BlendParam);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawBlendMode_x64( int  BlendMode, int  BlendParam);
		public static int  SetDrawBlendMode( int  BlendMode, int  BlendParam)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawBlendMode_x86( BlendMode , BlendParam );
			}
			else
			{
				return dx_SetDrawBlendMode_x64( BlendMode , BlendParam );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawBlendMode_x86( out int  BlendMode, out int  BlendParam);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawBlendMode_x64( out int  BlendMode, out int  BlendParam);
		public static int  GetDrawBlendMode( out int  BlendMode, out int  BlendParam)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawBlendMode_x86( out BlendMode , out BlendParam );
			}
			else
			{
				return dx_GetDrawBlendMode_x64( out BlendMode , out BlendParam );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawCustomBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawCustomBlendMode_x86( int  BlendEnable, int  SrcBlendRGB, int  DestBlendRGB, int  BlendOpRGB, int  SrcBlendA, int  DestBlendA, int  BlendOpA, int  BlendParam);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawCustomBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawCustomBlendMode_x64( int  BlendEnable, int  SrcBlendRGB, int  DestBlendRGB, int  BlendOpRGB, int  SrcBlendA, int  DestBlendA, int  BlendOpA, int  BlendParam);
		public static int  SetDrawCustomBlendMode( int  BlendEnable, int  SrcBlendRGB, int  DestBlendRGB, int  BlendOpRGB, int  SrcBlendA, int  DestBlendA, int  BlendOpA, int  BlendParam)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawCustomBlendMode_x86( BlendEnable , SrcBlendRGB , DestBlendRGB , BlendOpRGB , SrcBlendA , DestBlendA , BlendOpA , BlendParam );
			}
			else
			{
				return dx_SetDrawCustomBlendMode_x64( BlendEnable , SrcBlendRGB , DestBlendRGB , BlendOpRGB , SrcBlendA , DestBlendA , BlendOpA , BlendParam );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawCustomBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawCustomBlendMode_x86( out int  BlendEnable, out int  SrcBlendRGB, out int  DestBlendRGB, out int  BlendOpRGB, out int  SrcBlendA, out int  DestBlendA, out int  BlendOpA, out int  BlendParam);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawCustomBlendMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawCustomBlendMode_x64( out int  BlendEnable, out int  SrcBlendRGB, out int  DestBlendRGB, out int  BlendOpRGB, out int  SrcBlendA, out int  DestBlendA, out int  BlendOpA, out int  BlendParam);
		public static int  GetDrawCustomBlendMode( out int  BlendEnable, out int  SrcBlendRGB, out int  DestBlendRGB, out int  BlendOpRGB, out int  SrcBlendA, out int  DestBlendA, out int  BlendOpA, out int  BlendParam)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawCustomBlendMode_x86( out BlendEnable , out SrcBlendRGB , out DestBlendRGB , out BlendOpRGB , out SrcBlendA , out DestBlendA , out BlendOpA , out BlendParam );
			}
			else
			{
				return dx_GetDrawCustomBlendMode_x64( out BlendEnable , out SrcBlendRGB , out DestBlendRGB , out BlendOpRGB , out SrcBlendA , out DestBlendA , out BlendOpA , out BlendParam );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawAlphaTest", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawAlphaTest_x86( int  TestMode, int  TestParam);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawAlphaTest", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawAlphaTest_x64( int  TestMode, int  TestParam);
		public static int  SetDrawAlphaTest( int  TestMode, int  TestParam)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawAlphaTest_x86( TestMode , TestParam );
			}
			else
			{
				return dx_SetDrawAlphaTest_x64( TestMode , TestParam );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawAlphaTest", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawAlphaTest_x86( out int  TestMode, out int  TestParam);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawAlphaTest", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawAlphaTest_x64( out int  TestMode, out int  TestParam);
		public static int  GetDrawAlphaTest( out int  TestMode, out int  TestParam)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawAlphaTest_x86( out TestMode , out TestParam );
			}
			else
			{
				return dx_GetDrawAlphaTest_x64( out TestMode , out TestParam );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetBlendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBlendGraph_x86( int  BlendGraph, int  BorderParam, int  BorderRange);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetBlendGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBlendGraph_x64( int  BlendGraph, int  BorderParam, int  BorderRange);
		public static int  SetBlendGraph( int  BlendGraph, int  BorderParam, int  BorderRange)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraph_x86( BlendGraph , BorderParam , BorderRange );
			}
			else
			{
				return dx_SetBlendGraph_x64( BlendGraph , BorderParam , BorderRange );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetBlendGraphPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBlendGraphPosition_x86( int  x, int  y);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetBlendGraphPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBlendGraphPosition_x64( int  x, int  y);
		public static int  SetBlendGraphPosition( int  x, int  y)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphPosition_x86( x , y );
			}
			else
			{
				return dx_SetBlendGraphPosition_x64( x , y );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetBlendGraphPositionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBlendGraphPositionMode_x86( int  BlendGraphPositionMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetBlendGraphPositionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBlendGraphPositionMode_x64( int  BlendGraphPositionMode);
		public static int  SetBlendGraphPositionMode( int  BlendGraphPositionMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBlendGraphPositionMode_x86( BlendGraphPositionMode );
			}
			else
			{
				return dx_SetBlendGraphPositionMode_x64( BlendGraphPositionMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawBright", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawBright_x86( int  RedBright, int  GreenBright, int  BlueBright);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawBright", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawBright_x64( int  RedBright, int  GreenBright, int  BlueBright);
		public static int  SetDrawBright( int  RedBright, int  GreenBright, int  BlueBright)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawBright_x86( RedBright , GreenBright , BlueBright );
			}
			else
			{
				return dx_SetDrawBright_x64( RedBright , GreenBright , BlueBright );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawBright", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawBright_x86( out int  Red, out int  Green, out int  Blue);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawBright", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawBright_x64( out int  Red, out int  Green, out int  Blue);
		public static int  GetDrawBright( out int  Red, out int  Green, out int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawBright_x86( out Red , out Green , out Blue );
			}
			else
			{
				return dx_GetDrawBright_x64( out Red , out Green , out Blue );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawAddColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawAddColor_x86( int  Red, int  Green, int  Blue);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawAddColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawAddColor_x64( int  Red, int  Green, int  Blue);
		public static int  SetDrawAddColor( int  Red, int  Green, int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawAddColor_x86( Red , Green , Blue );
			}
			else
			{
				return dx_SetDrawAddColor_x64( Red , Green , Blue );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawAddColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawAddColor_x86( out int  Red, out int  Green, out int  Blue);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawAddColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawAddColor_x64( out int  Red, out int  Green, out int  Blue);
		public static int  GetDrawAddColor( out int  Red, out int  Green, out int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawAddColor_x86( out Red , out Green , out Blue );
			}
			else
			{
				return dx_GetDrawAddColor_x64( out Red , out Green , out Blue );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetWriteAlphaChannelFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWriteAlphaChannelFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetWriteAlphaChannelFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWriteAlphaChannelFlag_x64( int  Flag);
		public static int  SetWriteAlphaChannelFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetWriteAlphaChannelFlag_x86( Flag );
			}
			else
			{
				return dx_SetWriteAlphaChannelFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetWriteAlphaChannelFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetWriteAlphaChannelFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetWriteAlphaChannelFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetWriteAlphaChannelFlag_x64( );
		public static int  GetWriteAlphaChannelFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetWriteAlphaChannelFlag_x86( );
			}
			else
			{
				return dx_GetWriteAlphaChannelFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CheckSeparateAlphaBlendEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckSeparateAlphaBlendEnable_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CheckSeparateAlphaBlendEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CheckSeparateAlphaBlendEnable_x64( );
		public static int  CheckSeparateAlphaBlendEnable( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CheckSeparateAlphaBlendEnable_x86( );
			}
			else
			{
				return dx_CheckSeparateAlphaBlendEnable_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetIgnoreDrawGraphColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIgnoreDrawGraphColor_x86( int  EnableFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetIgnoreDrawGraphColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIgnoreDrawGraphColor_x64( int  EnableFlag);
		public static int  SetIgnoreDrawGraphColor( int  EnableFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetIgnoreDrawGraphColor_x86( EnableFlag );
			}
			else
			{
				return dx_SetIgnoreDrawGraphColor_x64( EnableFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetIgnoreDrawGraphColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetIgnoreDrawGraphColor_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetIgnoreDrawGraphColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetIgnoreDrawGraphColor_x64( );
		public static int  GetIgnoreDrawGraphColor( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetIgnoreDrawGraphColor_x86( );
			}
			else
			{
				return dx_GetIgnoreDrawGraphColor_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetMaxAnisotropy", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMaxAnisotropy_x86( int  MaxAnisotropy);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetMaxAnisotropy", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetMaxAnisotropy_x64( int  MaxAnisotropy);
		public static int  SetMaxAnisotropy( int  MaxAnisotropy)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetMaxAnisotropy_x86( MaxAnisotropy );
			}
			else
			{
				return dx_SetMaxAnisotropy_x64( MaxAnisotropy );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMaxAnisotropy", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxAnisotropy_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMaxAnisotropy", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxAnisotropy_x64( );
		public static int  GetMaxAnisotropy( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMaxAnisotropy_x86( );
			}
			else
			{
				return dx_GetMaxAnisotropy_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseLarge3DPositionSupport", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseLarge3DPositionSupport_x86( int  UseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseLarge3DPositionSupport", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseLarge3DPositionSupport_x64( int  UseFlag);
		public static int  SetUseLarge3DPositionSupport( int  UseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseLarge3DPositionSupport_x86( UseFlag );
			}
			else
			{
				return dx_SetUseLarge3DPositionSupport_x64( UseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseZBufferFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseZBufferFlag_x64( int  Flag);
		public static int  SetUseZBufferFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseZBufferFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseZBufferFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetWriteZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWriteZBufferFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetWriteZBufferFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWriteZBufferFlag_x64( int  Flag);
		public static int  SetWriteZBufferFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetWriteZBufferFlag_x86( Flag );
			}
			else
			{
				return dx_SetWriteZBufferFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetZBufferCmpType", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferCmpType_x86( int  CmpType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetZBufferCmpType", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferCmpType_x64( int  CmpType);
		public static int  SetZBufferCmpType( int  CmpType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetZBufferCmpType_x86( CmpType );
			}
			else
			{
				return dx_SetZBufferCmpType_x64( CmpType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetZBias", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBias_x86( int  Bias);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetZBias", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBias_x64( int  Bias);
		public static int  SetZBias( int  Bias)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetZBias_x86( Bias );
			}
			else
			{
				return dx_SetZBias_x64( Bias );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseZBuffer3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseZBuffer3D_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseZBuffer3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseZBuffer3D_x64( int  Flag);
		public static int  SetUseZBuffer3D( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseZBuffer3D_x86( Flag );
			}
			else
			{
				return dx_SetUseZBuffer3D_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetWriteZBuffer3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWriteZBuffer3D_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetWriteZBuffer3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWriteZBuffer3D_x64( int  Flag);
		public static int  SetWriteZBuffer3D( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetWriteZBuffer3D_x86( Flag );
			}
			else
			{
				return dx_SetWriteZBuffer3D_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetZBufferCmpType3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferCmpType3D_x86( int  CmpType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetZBufferCmpType3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferCmpType3D_x64( int  CmpType);
		public static int  SetZBufferCmpType3D( int  CmpType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetZBufferCmpType3D_x86( CmpType );
			}
			else
			{
				return dx_SetZBufferCmpType3D_x64( CmpType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetZBias3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBias3D_x86( int  Bias);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetZBias3D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBias3D_x64( int  Bias);
		public static int  SetZBias3D( int  Bias)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetZBias3D_x86( Bias );
			}
			else
			{
				return dx_SetZBias3D_x64( Bias );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawZ", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawZ_x86( float  Z);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawZ", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawZ_x64( float  Z);
		public static int  SetDrawZ( float  Z)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawZ_x86( Z );
			}
			else
			{
				return dx_SetDrawZ_x64( Z );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseReversedZ", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseReversedZ_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseReversedZ", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseReversedZ_x64( int  Flag);
		public static int  SetUseReversedZ( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseReversedZ_x86( Flag );
			}
			else
			{
				return dx_SetUseReversedZ_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawArea_x86( int  x1, int  y1, int  x2, int  y2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawArea_x64( int  x1, int  y1, int  x2, int  y2);
		public static int  SetDrawArea( int  x1, int  y1, int  x2, int  y2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawArea_x86( x1 , y1 , x2 , y2 );
			}
			else
			{
				return dx_SetDrawArea_x64( x1 , y1 , x2 , y2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawArea_x86( out RECT  Rect);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawArea_x64( out RECT  Rect);
		public static int  GetDrawArea( out RECT  Rect)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawArea_x86( out Rect );
			}
			else
			{
				return dx_GetDrawArea_x64( out Rect );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawAreaFull", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawAreaFull_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawAreaFull", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawAreaFull_x64( );
		public static int  SetDrawAreaFull( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawAreaFull_x86( );
			}
			else
			{
				return dx_SetDrawAreaFull_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDraw3DScale", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDraw3DScale_x86( float  Scale);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDraw3DScale", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDraw3DScale_x64( float  Scale);
		public static int  SetDraw3DScale( float  Scale)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDraw3DScale_x86( Scale );
			}
			else
			{
				return dx_SetDraw3DScale_x64( Scale );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_RunRestoreShred", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_RunRestoreShred_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_RunRestoreShred", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_RunRestoreShred_x64( );
		public static int  RunRestoreShred( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_RunRestoreShred_x86( );
			}
			else
			{
				return dx_RunRestoreShred_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformTo2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformTo2D_x86( out MATRIX  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformTo2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformTo2D_x64( out MATRIX  Matrix);
		public static int  SetTransformTo2D( out MATRIX  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformTo2D_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformTo2D_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformTo2DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformTo2DD_x86( out MATRIX_D  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformTo2DD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformTo2DD_x64( out MATRIX_D  Matrix);
		public static int  SetTransformTo2DD( out MATRIX_D  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformTo2DD_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformTo2DD_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetTransformTo2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetTransformTo2D_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetTransformTo2D", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetTransformTo2D_x64( );
		public static int  ResetTransformTo2D( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetTransformTo2D_x86( );
			}
			else
			{
				return dx_ResetTransformTo2D_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToWorld", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToWorld_x86( out MATRIX  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToWorld", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToWorld_x64( out MATRIX  Matrix);
		public static int  SetTransformToWorld( out MATRIX  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToWorld_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToWorld_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToWorldD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToWorldD_x86( out MATRIX_D  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToWorldD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToWorldD_x64( out MATRIX_D  Matrix);
		public static int  SetTransformToWorldD( out MATRIX_D  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToWorldD_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToWorldD_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToWorldMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToWorldMatrix_x86( out MATRIX  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToWorldMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToWorldMatrix_x64( out MATRIX  MatBuf);
		public static int  GetTransformToWorldMatrix( out MATRIX  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToWorldMatrix_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToWorldMatrix_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToWorldMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToWorldMatrixD_x86( out MATRIX_D  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToWorldMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToWorldMatrixD_x64( out MATRIX_D  MatBuf);
		public static int  GetTransformToWorldMatrixD( out MATRIX_D  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToWorldMatrixD_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToWorldMatrixD_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToView", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToView_x86( out MATRIX  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToView", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToView_x64( out MATRIX  Matrix);
		public static int  SetTransformToView( out MATRIX  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToView_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToView_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToViewD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToViewD_x86( out MATRIX_D  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToViewD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToViewD_x64( out MATRIX_D  Matrix);
		public static int  SetTransformToViewD( out MATRIX_D  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToViewD_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToViewD_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToViewMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewMatrix_x86( out MATRIX  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToViewMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewMatrix_x64( out MATRIX  MatBuf);
		public static int  GetTransformToViewMatrix( out MATRIX  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToViewMatrix_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToViewMatrix_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToViewMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewMatrixD_x86( out MATRIX_D  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToViewMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewMatrixD_x64( out MATRIX_D  MatBuf);
		public static int  GetTransformToViewMatrixD( out MATRIX_D  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToViewMatrixD_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToViewMatrixD_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToProjection", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToProjection_x86( out MATRIX  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToProjection", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToProjection_x64( out MATRIX  Matrix);
		public static int  SetTransformToProjection( out MATRIX  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToProjection_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToProjection_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToProjectionD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToProjectionD_x86( out MATRIX_D  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToProjectionD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToProjectionD_x64( out MATRIX_D  Matrix);
		public static int  SetTransformToProjectionD( out MATRIX_D  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToProjectionD_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToProjectionD_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToProjectionMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToProjectionMatrix_x86( out MATRIX  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToProjectionMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToProjectionMatrix_x64( out MATRIX  MatBuf);
		public static int  GetTransformToProjectionMatrix( out MATRIX  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToProjectionMatrix_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToProjectionMatrix_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToProjectionMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToProjectionMatrixD_x86( out MATRIX_D  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToProjectionMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToProjectionMatrixD_x64( out MATRIX_D  MatBuf);
		public static int  GetTransformToProjectionMatrixD( out MATRIX_D  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToProjectionMatrixD_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToProjectionMatrixD_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToViewport", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToViewport_x86( out MATRIX  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToViewport", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToViewport_x64( out MATRIX  Matrix);
		public static int  SetTransformToViewport( out MATRIX  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToViewport_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToViewport_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTransformToViewportD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToViewportD_x86( out MATRIX_D  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTransformToViewportD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTransformToViewportD_x64( out MATRIX_D  Matrix);
		public static int  SetTransformToViewportD( out MATRIX_D  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTransformToViewportD_x86( out Matrix );
			}
			else
			{
				return dx_SetTransformToViewportD_x64( out Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToViewportMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewportMatrix_x86( out MATRIX  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToViewportMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewportMatrix_x64( out MATRIX  MatBuf);
		public static int  GetTransformToViewportMatrix( out MATRIX  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToViewportMatrix_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToViewportMatrix_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToViewportMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewportMatrixD_x86( out MATRIX_D  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToViewportMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToViewportMatrixD_x64( out MATRIX_D  MatBuf);
		public static int  GetTransformToViewportMatrixD( out MATRIX_D  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToViewportMatrixD_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToViewportMatrixD_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToAPIViewportMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToAPIViewportMatrix_x86( out MATRIX  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToAPIViewportMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToAPIViewportMatrix_x64( out MATRIX  MatBuf);
		public static int  GetTransformToAPIViewportMatrix( out MATRIX  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToAPIViewportMatrix_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToAPIViewportMatrix_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformToAPIViewportMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToAPIViewportMatrixD_x86( out MATRIX_D  MatBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformToAPIViewportMatrixD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformToAPIViewportMatrixD_x64( out MATRIX_D  MatBuf);
		public static int  GetTransformToAPIViewportMatrixD( out MATRIX_D  MatBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformToAPIViewportMatrixD_x86( out MatBuf );
			}
			else
			{
				return dx_GetTransformToAPIViewportMatrixD_x64( out MatBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDefTransformMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDefTransformMatrix_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDefTransformMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDefTransformMatrix_x64( );
		public static int  SetDefTransformMatrix( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDefTransformMatrix_x86( );
			}
			else
			{
				return dx_SetDefTransformMatrix_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformPosition_x86( out VECTOR  LocalPos, out float  x, out float  y);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformPosition", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformPosition_x64( out VECTOR  LocalPos, out float  x, out float  y);
		public static int  GetTransformPosition( out VECTOR  LocalPos, out float  x, out float  y)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformPosition_x86( out LocalPos , out x , out y );
			}
			else
			{
				return dx_GetTransformPosition_x64( out LocalPos , out x , out y );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetTransformPositionD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformPositionD_x86( out VECTOR_D  LocalPos, out double  x, out double  y);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetTransformPositionD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetTransformPositionD_x64( out VECTOR_D  LocalPos, out double  x, out double  y);
		public static int  GetTransformPositionD( out VECTOR_D  LocalPos, out double  x, out double  y)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetTransformPositionD_x86( out LocalPos , out x , out y );
			}
			else
			{
				return dx_GetTransformPositionD_x64( out LocalPos , out x , out y );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetBillboardPixelSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetBillboardPixelSize_x86( VECTOR  WorldPos, float  WorldSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetBillboardPixelSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetBillboardPixelSize_x64( VECTOR  WorldPos, float  WorldSize);
		public static float  GetBillboardPixelSize( VECTOR  WorldPos, float  WorldSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetBillboardPixelSize_x86( WorldPos , WorldSize );
			}
			else
			{
				return dx_GetBillboardPixelSize_x64( WorldPos , WorldSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvWorldPosToViewPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvWorldPosToViewPos_x86( VECTOR  WorldPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvWorldPosToViewPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvWorldPosToViewPos_x64( VECTOR  WorldPos);
		public static VECTOR  ConvWorldPosToViewPos( VECTOR  WorldPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvWorldPosToViewPos_x86( WorldPos );
			}
			else
			{
				return dx_ConvWorldPosToViewPos_x64( WorldPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvWorldPosToViewPosD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvWorldPosToViewPosD_x86( VECTOR_D  WorldPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvWorldPosToViewPosD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvWorldPosToViewPosD_x64( VECTOR_D  WorldPos);
		public static VECTOR_D  ConvWorldPosToViewPosD( VECTOR_D  WorldPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvWorldPosToViewPosD_x86( WorldPos );
			}
			else
			{
				return dx_ConvWorldPosToViewPosD_x64( WorldPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvWorldPosToScreenPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvWorldPosToScreenPos_x86( VECTOR  WorldPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvWorldPosToScreenPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvWorldPosToScreenPos_x64( VECTOR  WorldPos);
		public static VECTOR  ConvWorldPosToScreenPos( VECTOR  WorldPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvWorldPosToScreenPos_x86( WorldPos );
			}
			else
			{
				return dx_ConvWorldPosToScreenPos_x64( WorldPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvWorldPosToScreenPosD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvWorldPosToScreenPosD_x86( VECTOR_D  WorldPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvWorldPosToScreenPosD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvWorldPosToScreenPosD_x64( VECTOR_D  WorldPos);
		public static VECTOR_D  ConvWorldPosToScreenPosD( VECTOR_D  WorldPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvWorldPosToScreenPosD_x86( WorldPos );
			}
			else
			{
				return dx_ConvWorldPosToScreenPosD_x64( WorldPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvWorldPosToScreenPosPlusW", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static FLOAT4  dx_ConvWorldPosToScreenPosPlusW_x86( VECTOR  WorldPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvWorldPosToScreenPosPlusW", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static FLOAT4  dx_ConvWorldPosToScreenPosPlusW_x64( VECTOR  WorldPos);
		public static FLOAT4  ConvWorldPosToScreenPosPlusW( VECTOR  WorldPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvWorldPosToScreenPosPlusW_x86( WorldPos );
			}
			else
			{
				return dx_ConvWorldPosToScreenPosPlusW_x64( WorldPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvWorldPosToScreenPosPlusWD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static DOUBLE4  dx_ConvWorldPosToScreenPosPlusWD_x86( VECTOR_D  WorldPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvWorldPosToScreenPosPlusWD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static DOUBLE4  dx_ConvWorldPosToScreenPosPlusWD_x64( VECTOR_D  WorldPos);
		public static DOUBLE4  ConvWorldPosToScreenPosPlusWD( VECTOR_D  WorldPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvWorldPosToScreenPosPlusWD_x86( WorldPos );
			}
			else
			{
				return dx_ConvWorldPosToScreenPosPlusWD_x64( WorldPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvScreenPosToWorldPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvScreenPosToWorldPos_x86( VECTOR  ScreenPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvScreenPosToWorldPos", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvScreenPosToWorldPos_x64( VECTOR  ScreenPos);
		public static VECTOR  ConvScreenPosToWorldPos( VECTOR  ScreenPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvScreenPosToWorldPos_x86( ScreenPos );
			}
			else
			{
				return dx_ConvScreenPosToWorldPos_x64( ScreenPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvScreenPosToWorldPosD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvScreenPosToWorldPosD_x86( VECTOR_D  ScreenPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvScreenPosToWorldPosD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvScreenPosToWorldPosD_x64( VECTOR_D  ScreenPos);
		public static VECTOR_D  ConvScreenPosToWorldPosD( VECTOR_D  ScreenPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvScreenPosToWorldPosD_x86( ScreenPos );
			}
			else
			{
				return dx_ConvScreenPosToWorldPosD_x64( ScreenPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvScreenPosToWorldPos_ZLinear", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvScreenPosToWorldPos_ZLinear_x86( VECTOR  ScreenPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvScreenPosToWorldPos_ZLinear", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR  dx_ConvScreenPosToWorldPos_ZLinear_x64( VECTOR  ScreenPos);
		public static VECTOR  ConvScreenPosToWorldPos_ZLinear( VECTOR  ScreenPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvScreenPosToWorldPos_ZLinear_x86( ScreenPos );
			}
			else
			{
				return dx_ConvScreenPosToWorldPos_ZLinear_x64( ScreenPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ConvScreenPosToWorldPos_ZLinearD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvScreenPosToWorldPos_ZLinearD_x86( VECTOR_D  ScreenPos);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ConvScreenPosToWorldPos_ZLinearD", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static VECTOR_D  dx_ConvScreenPosToWorldPos_ZLinearD_x64( VECTOR_D  ScreenPos);
		public static VECTOR_D  ConvScreenPosToWorldPos_ZLinearD( VECTOR_D  ScreenPos)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ConvScreenPosToWorldPos_ZLinearD_x86( ScreenPos );
			}
			else
			{
				return dx_ConvScreenPosToWorldPos_ZLinearD_x64( ScreenPos );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseCullingFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseCullingFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseCullingFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseCullingFlag_x64( int  Flag);
		public static int  SetUseCullingFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseCullingFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseCullingFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseBackCulling", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseBackCulling_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseBackCulling", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseBackCulling_x64( int  Flag);
		public static int  SetUseBackCulling( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseBackCulling_x86( Flag );
			}
			else
			{
				return dx_SetUseBackCulling_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseBackCulling", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseBackCulling_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseBackCulling", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseBackCulling_x64( );
		public static int  GetUseBackCulling( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseBackCulling_x86( );
			}
			else
			{
				return dx_GetUseBackCulling_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseRightHandClippingProcess", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseRightHandClippingProcess_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseRightHandClippingProcess", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseRightHandClippingProcess_x64( int  Flag);
		public static int  SetUseRightHandClippingProcess( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseRightHandClippingProcess_x86( Flag );
			}
			else
			{
				return dx_SetUseRightHandClippingProcess_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseRightHandClippingProcess", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseRightHandClippingProcess_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseRightHandClippingProcess", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseRightHandClippingProcess_x64( );
		public static int  GetUseRightHandClippingProcess( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseRightHandClippingProcess_x86( );
			}
			else
			{
				return dx_GetUseRightHandClippingProcess_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTextureAddressMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressMode_x86( int  Mode, int  Stage);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTextureAddressMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressMode_x64( int  Mode, int  Stage);
		public static int  SetTextureAddressMode( int  Mode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTextureAddressMode_x86( Mode , -1 );
			}
			else
			{
				return dx_SetTextureAddressMode_x64( Mode , -1 );
			}
		}
		public static int  SetTextureAddressMode( int  Mode, int  Stage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTextureAddressMode_x86( Mode , Stage );
			}
			else
			{
				return dx_SetTextureAddressMode_x64( Mode , Stage );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTextureAddressModeUV", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressModeUV_x86( int  ModeU, int  ModeV, int  Stage);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTextureAddressModeUV", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressModeUV_x64( int  ModeU, int  ModeV, int  Stage);
		public static int  SetTextureAddressModeUV( int  ModeU, int  ModeV)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTextureAddressModeUV_x86( ModeU , ModeV , -1 );
			}
			else
			{
				return dx_SetTextureAddressModeUV_x64( ModeU , ModeV , -1 );
			}
		}
		public static int  SetTextureAddressModeUV( int  ModeU, int  ModeV, int  Stage)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTextureAddressModeUV_x86( ModeU , ModeV , Stage );
			}
			else
			{
				return dx_SetTextureAddressModeUV_x64( ModeU , ModeV , Stage );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTextureAddressTransform", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressTransform_x86( float  TransU, float  TransV, float  ScaleU, float  ScaleV, float  RotCenterU, float  RotCenterV, float  Rotate);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTextureAddressTransform", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressTransform_x64( float  TransU, float  TransV, float  ScaleU, float  ScaleV, float  RotCenterU, float  RotCenterV, float  Rotate);
		public static int  SetTextureAddressTransform( float  TransU, float  TransV, float  ScaleU, float  ScaleV, float  RotCenterU, float  RotCenterV, float  Rotate)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTextureAddressTransform_x86( TransU , TransV , ScaleU , ScaleV , RotCenterU , RotCenterV , Rotate );
			}
			else
			{
				return dx_SetTextureAddressTransform_x64( TransU , TransV , ScaleU , ScaleV , RotCenterU , RotCenterV , Rotate );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetTextureAddressTransformMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressTransformMatrix_x86( MATRIX  Matrix);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetTextureAddressTransformMatrix", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetTextureAddressTransformMatrix_x64( MATRIX  Matrix);
		public static int  SetTextureAddressTransformMatrix( MATRIX  Matrix)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetTextureAddressTransformMatrix_x86( Matrix );
			}
			else
			{
				return dx_SetTextureAddressTransformMatrix_x64( Matrix );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetTextureAddressTransform", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetTextureAddressTransform_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetTextureAddressTransform", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetTextureAddressTransform_x64( );
		public static int  ResetTextureAddressTransform( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetTextureAddressTransform_x86( );
			}
			else
			{
				return dx_ResetTextureAddressTransform_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogEnable_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogEnable_x64( int  Flag);
		public static int  SetFogEnable( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFogEnable_x86( Flag );
			}
			else
			{
				return dx_SetFogEnable_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogEnable_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogEnable_x64( );
		public static int  GetFogEnable( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFogEnable_x86( );
			}
			else
			{
				return dx_GetFogEnable_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogMode_x86( int  Mode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogMode_x64( int  Mode);
		public static int  SetFogMode( int  Mode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFogMode_x86( Mode );
			}
			else
			{
				return dx_SetFogMode_x64( Mode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogMode_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogMode_x64( );
		public static int  GetFogMode( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFogMode_x86( );
			}
			else
			{
				return dx_GetFogMode_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogColor_x86( int  r, int  g, int  b);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogColor_x64( int  r, int  g, int  b);
		public static int  SetFogColor( int  r, int  g, int  b)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFogColor_x86( r , g , b );
			}
			else
			{
				return dx_SetFogColor_x64( r , g , b );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogColor_x86( out int  r, out int  g, out int  b);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogColor_x64( out int  r, out int  g, out int  b);
		public static int  GetFogColor( out int  r, out int  g, out int  b)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFogColor_x86( out r , out g , out b );
			}
			else
			{
				return dx_GetFogColor_x64( out r , out g , out b );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogStartEnd_x86( float  start, float  end);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogStartEnd_x64( float  start, float  end);
		public static int  SetFogStartEnd( float  start, float  end)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFogStartEnd_x86( start , end );
			}
			else
			{
				return dx_SetFogStartEnd_x64( start , end );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogStartEnd_x86( out float  start, out float  end);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFogStartEnd_x64( out float  start, out float  end);
		public static int  GetFogStartEnd( out float  start, out float  end)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFogStartEnd_x86( out start , out end );
			}
			else
			{
				return dx_GetFogStartEnd_x64( out start , out end );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogDensity_x86( float  density);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFogDensity_x64( float  density);
		public static int  SetFogDensity( float  density)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFogDensity_x86( density );
			}
			else
			{
				return dx_SetFogDensity_x64( density );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetFogDensity_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetFogDensity_x64( );
		public static float  GetFogDensity( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFogDensity_x86( );
			}
			else
			{
				return dx_GetFogDensity_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVerticalFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogEnable_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVerticalFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogEnable_x64( int  Flag);
		public static int  SetVerticalFogEnable( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVerticalFogEnable_x86( Flag );
			}
			else
			{
				return dx_SetVerticalFogEnable_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetVerticalFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogEnable_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetVerticalFogEnable", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogEnable_x64( );
		public static int  GetVerticalFogEnable( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetVerticalFogEnable_x86( );
			}
			else
			{
				return dx_GetVerticalFogEnable_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVerticalFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogMode_x86( int  Mode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVerticalFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogMode_x64( int  Mode);
		public static int  SetVerticalFogMode( int  Mode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVerticalFogMode_x86( Mode );
			}
			else
			{
				return dx_SetVerticalFogMode_x64( Mode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetVerticalFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogMode_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetVerticalFogMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogMode_x64( );
		public static int  GetVerticalFogMode( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetVerticalFogMode_x86( );
			}
			else
			{
				return dx_GetVerticalFogMode_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVerticalFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogColor_x86( int  r, int  g, int  b);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVerticalFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogColor_x64( int  r, int  g, int  b);
		public static int  SetVerticalFogColor( int  r, int  g, int  b)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVerticalFogColor_x86( r , g , b );
			}
			else
			{
				return dx_SetVerticalFogColor_x64( r , g , b );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetVerticalFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogColor_x86( out int  r, out int  g, out int  b);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetVerticalFogColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogColor_x64( out int  r, out int  g, out int  b);
		public static int  GetVerticalFogColor( out int  r, out int  g, out int  b)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetVerticalFogColor_x86( out r , out g , out b );
			}
			else
			{
				return dx_GetVerticalFogColor_x64( out r , out g , out b );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVerticalFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogStartEnd_x86( float  start, float  end);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVerticalFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogStartEnd_x64( float  start, float  end);
		public static int  SetVerticalFogStartEnd( float  start, float  end)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVerticalFogStartEnd_x86( start , end );
			}
			else
			{
				return dx_SetVerticalFogStartEnd_x64( start , end );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetVerticalFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogStartEnd_x86( out float  start, out float  end);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetVerticalFogStartEnd", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogStartEnd_x64( out float  start, out float  end);
		public static int  GetVerticalFogStartEnd( out float  start, out float  end)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetVerticalFogStartEnd_x86( out start , out end );
			}
			else
			{
				return dx_GetVerticalFogStartEnd_x64( out start , out end );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVerticalFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogDensity_x86( float  start, float  density);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVerticalFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVerticalFogDensity_x64( float  start, float  density);
		public static int  SetVerticalFogDensity( float  start, float  density)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVerticalFogDensity_x86( start , density );
			}
			else
			{
				return dx_SetVerticalFogDensity_x64( start , density );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetVerticalFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogDensity_x86( out float  start, out float  density);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetVerticalFogDensity", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVerticalFogDensity_x64( out float  start, out float  density);
		public static int  GetVerticalFogDensity( out float  start, out float  density)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetVerticalFogDensity_x86( out start , out density );
			}
			else
			{
				return dx_GetVerticalFogDensity_x64( out start , out density );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPixel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetPixel_x86( int  x, int  y);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPixel", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetPixel_x64( int  x, int  y);
		public static uint  GetPixel( int  x, int  y)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPixel_x86( x , y );
			}
			else
			{
				return dx_GetPixel_x64( x , y );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPixelDX", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetPixelDX_x86( int  x, int  y);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPixelDX", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static uint  dx_GetPixelDX_x64( int  x, int  y);
		public static uint  GetPixelDX( int  x, int  y)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPixelDX_x86( x , y );
			}
			else
			{
				return dx_GetPixelDX_x64( x , y );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetPixelF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static COLOR_F  dx_GetPixelF_x86( int  x, int  y);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetPixelF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static COLOR_F  dx_GetPixelF_x64( int  x, int  y);
		public static COLOR_F  GetPixelF( int  x, int  y)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetPixelF_x86( x , y );
			}
			else
			{
				return dx_GetPixelF_x64( x , y );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetBackgroundColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBackgroundColor_x86( int  Red, int  Green, int  Blue, int  Alpha);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetBackgroundColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBackgroundColor_x64( int  Red, int  Green, int  Blue, int  Alpha);
		public static int  SetBackgroundColor( int  Red, int  Green, int  Blue)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBackgroundColor_x86( Red , Green , Blue , 0 );
			}
			else
			{
				return dx_SetBackgroundColor_x64( Red , Green , Blue , 0 );
			}
		}
		public static int  SetBackgroundColor( int  Red, int  Green, int  Blue, int  Alpha)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBackgroundColor_x86( Red , Green , Blue , Alpha );
			}
			else
			{
				return dx_SetBackgroundColor_x64( Red , Green , Blue , Alpha );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetBackgroundColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetBackgroundColor_x86( out int  Red, out int  Green, out int  Blue, out int  Alpha);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetBackgroundColor", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetBackgroundColor_x64( out int  Red, out int  Green, out int  Blue, out int  Alpha);
		public static int  GetBackgroundColor( out int  Red, out int  Green, out int  Blue, out int  Alpha)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetBackgroundColor_x86( out Red , out Green , out Blue , out Alpha );
			}
			else
			{
				return dx_GetBackgroundColor_x64( out Red , out Green , out Blue , out Alpha );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawScreenGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawScreenGraph_x86( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  UseClientFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawScreenGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawScreenGraph_x64( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  UseClientFlag);
		public static int  GetDrawScreenGraph( int  x1, int  y1, int  x2, int  y2, int  GrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawScreenGraph_x86( x1 , y1 , x2 , y2 , GrHandle , TRUE );
			}
			else
			{
				return dx_GetDrawScreenGraph_x64( x1 , y1 , x2 , y2 , GrHandle , TRUE );
			}
		}
		public static int  GetDrawScreenGraph( int  x1, int  y1, int  x2, int  y2, int  GrHandle, int  UseClientFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawScreenGraph_x86( x1 , y1 , x2 , y2 , GrHandle , UseClientFlag );
			}
			else
			{
				return dx_GetDrawScreenGraph_x64( x1 , y1 , x2 , y2 , GrHandle , UseClientFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_BltDrawValidGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_BltDrawValidGraph_x86( int  TargetDrawValidGrHandle, int  x1, int  y1, int  x2, int  y2, int  DestX, int  DestY, int  DestGrHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_BltDrawValidGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_BltDrawValidGraph_x64( int  TargetDrawValidGrHandle, int  x1, int  y1, int  x2, int  y2, int  DestX, int  DestY, int  DestGrHandle);
		public static int  BltDrawValidGraph( int  TargetDrawValidGrHandle, int  x1, int  y1, int  x2, int  y2, int  DestX, int  DestY, int  DestGrHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_BltDrawValidGraph_x86( TargetDrawValidGrHandle , x1 , y1 , x2 , y2 , DestX , DestY , DestGrHandle );
			}
			else
			{
				return dx_BltDrawValidGraph_x64( TargetDrawValidGrHandle , x1 , y1 , x2 , y2 , DestX , DestY , DestGrHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ScreenFlip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ScreenFlip_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ScreenFlip", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ScreenFlip_x64( );
		public static int  ScreenFlip( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ScreenFlip_x86( );
			}
			else
			{
				return dx_ScreenFlip_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ScreenCopy", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ScreenCopy_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ScreenCopy", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ScreenCopy_x64( );
		public static int  ScreenCopy( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ScreenCopy_x86( );
			}
			else
			{
				return dx_ScreenCopy_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_WaitVSync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitVSync_x86( int  SyncNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_WaitVSync", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_WaitVSync_x64( int  SyncNum);
		public static int  WaitVSync( int  SyncNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_WaitVSync_x86( SyncNum );
			}
			else
			{
				return dx_WaitVSync_x64( SyncNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ClsDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClsDrawScreen_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ClsDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ClsDrawScreen_x64( );
		public static int  ClsDrawScreen( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ClsDrawScreen_x86( );
			}
			else
			{
				return dx_ClsDrawScreen_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawScreen_x86( int  DrawScreen);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawScreen_x64( int  DrawScreen);
		public static int  SetDrawScreen( int  DrawScreen)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawScreen_x86( DrawScreen );
			}
			else
			{
				return dx_SetDrawScreen_x64( DrawScreen );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawScreen_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawScreen_x64( );
		public static int  GetDrawScreen( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawScreen_x86( );
			}
			else
			{
				return dx_GetDrawScreen_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetActiveGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetActiveGraph_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetActiveGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetActiveGraph_x64( );
		public static int  GetActiveGraph( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetActiveGraph_x86( );
			}
			else
			{
				return dx_GetActiveGraph_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseSetDrawScreenSettingReset", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseSetDrawScreenSettingReset_x86( int  UseFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseSetDrawScreenSettingReset", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseSetDrawScreenSettingReset_x64( int  UseFlag);
		public static int  SetUseSetDrawScreenSettingReset( int  UseFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseSetDrawScreenSettingReset_x86( UseFlag );
			}
			else
			{
				return dx_SetUseSetDrawScreenSettingReset_x64( UseFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseSetDrawScreenSettingReset", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseSetDrawScreenSettingReset_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseSetDrawScreenSettingReset", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseSetDrawScreenSettingReset_x64( );
		public static int  GetUseSetDrawScreenSettingReset( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseSetDrawScreenSettingReset_x86( );
			}
			else
			{
				return dx_GetUseSetDrawScreenSettingReset_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetDrawZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawZBuffer_x86( int  DrawScreen);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetDrawZBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetDrawZBuffer_x64( int  DrawScreen);
		public static int  SetDrawZBuffer( int  DrawScreen)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetDrawZBuffer_x86( DrawScreen );
			}
			else
			{
				return dx_SetDrawZBuffer_x64( DrawScreen );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetGraphMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphMode_x86( int  ScreenSizeX, int  ScreenSizeY, int  ColorBitDepth, int  RefreshRate);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetGraphMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphMode_x64( int  ScreenSizeX, int  ScreenSizeY, int  ColorBitDepth, int  RefreshRate);
		public static int  SetGraphMode( int  ScreenSizeX, int  ScreenSizeY, int  ColorBitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetGraphMode_x86( ScreenSizeX , ScreenSizeY , ColorBitDepth , 60 );
			}
			else
			{
				return dx_SetGraphMode_x64( ScreenSizeX , ScreenSizeY , ColorBitDepth , 60 );
			}
		}
		public static int  SetGraphMode( int  ScreenSizeX, int  ScreenSizeY, int  ColorBitDepth, int  RefreshRate)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetGraphMode_x86( ScreenSizeX , ScreenSizeY , ColorBitDepth , RefreshRate );
			}
			else
			{
				return dx_SetGraphMode_x64( ScreenSizeX , ScreenSizeY , ColorBitDepth , RefreshRate );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUserScreenImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUserScreenImage_x86( System.IntPtr  Image, int  PixelFormat);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUserScreenImage", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUserScreenImage_x64( System.IntPtr  Image, int  PixelFormat);
		public static int  SetUserScreenImage( System.IntPtr  Image, int  PixelFormat)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUserScreenImage_x86( Image , PixelFormat );
			}
			else
			{
				return dx_SetUserScreenImage_x64( Image , PixelFormat );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFullScreenResolutionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFullScreenResolutionMode_x86( int  ResolutionMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFullScreenResolutionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFullScreenResolutionMode_x64( int  ResolutionMode);
		public static int  SetFullScreenResolutionMode( int  ResolutionMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFullScreenResolutionMode_x86( ResolutionMode );
			}
			else
			{
				return dx_SetFullScreenResolutionMode_x64( ResolutionMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFullScreenResolutionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFullScreenResolutionMode_x86( out int  ResolutionMode, out int  UseResolutionMode);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFullScreenResolutionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetFullScreenResolutionMode_x64( out int  ResolutionMode, out int  UseResolutionMode);
		public static int  GetFullScreenResolutionMode( out int  ResolutionMode, out int  UseResolutionMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFullScreenResolutionMode_x86( out ResolutionMode , out UseResolutionMode );
			}
			else
			{
				return dx_GetFullScreenResolutionMode_x64( out ResolutionMode , out UseResolutionMode );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseFullScreenResolutionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseFullScreenResolutionMode_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseFullScreenResolutionMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseFullScreenResolutionMode_x64( );
		public static int  GetUseFullScreenResolutionMode( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseFullScreenResolutionMode_x86( );
			}
			else
			{
				return dx_GetUseFullScreenResolutionMode_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFullScreenScalingMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFullScreenScalingMode_x86( int  ScalingMode, int  FitScaling);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFullScreenScalingMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFullScreenScalingMode_x64( int  ScalingMode, int  FitScaling);
		public static int  SetFullScreenScalingMode( int  ScalingMode)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFullScreenScalingMode_x86( ScalingMode , FALSE );
			}
			else
			{
				return dx_SetFullScreenScalingMode_x64( ScalingMode , FALSE );
			}
		}
		public static int  SetFullScreenScalingMode( int  ScalingMode, int  FitScaling)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFullScreenScalingMode_x86( ScalingMode , FitScaling );
			}
			else
			{
				return dx_SetFullScreenScalingMode_x64( ScalingMode , FitScaling );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetEmulation320x240", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetEmulation320x240_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetEmulation320x240", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetEmulation320x240_x64( int  Flag);
		public static int  SetEmulation320x240( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetEmulation320x240_x86( Flag );
			}
			else
			{
				return dx_SetEmulation320x240_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetZBufferSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferSize_x86( int  ZBufferSizeX, int  ZBufferSizeY);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetZBufferSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferSize_x64( int  ZBufferSizeX, int  ZBufferSizeY);
		public static int  SetZBufferSize( int  ZBufferSizeX, int  ZBufferSizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetZBufferSize_x86( ZBufferSizeX , ZBufferSizeY );
			}
			else
			{
				return dx_SetZBufferSize_x64( ZBufferSizeX , ZBufferSizeY );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetZBufferBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferBitDepth_x86( int  BitDepth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetZBufferBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetZBufferBitDepth_x64( int  BitDepth);
		public static int  SetZBufferBitDepth( int  BitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetZBufferBitDepth_x86( BitDepth );
			}
			else
			{
				return dx_SetZBufferBitDepth_x64( BitDepth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetWaitVSyncFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWaitVSyncFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetWaitVSyncFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWaitVSyncFlag_x64( int  Flag);
		public static int  SetWaitVSyncFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetWaitVSyncFlag_x86( Flag );
			}
			else
			{
				return dx_SetWaitVSyncFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetWaitVSyncFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetWaitVSyncFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetWaitVSyncFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetWaitVSyncFlag_x64( );
		public static int  GetWaitVSyncFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetWaitVSyncFlag_x86( );
			}
			else
			{
				return dx_GetWaitVSyncFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetFullSceneAntiAliasingMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFullSceneAntiAliasingMode_x86( int  Samples, int  Quality);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetFullSceneAntiAliasingMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetFullSceneAntiAliasingMode_x64( int  Samples, int  Quality);
		public static int  SetFullSceneAntiAliasingMode( int  Samples, int  Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetFullSceneAntiAliasingMode_x86( Samples , Quality );
			}
			else
			{
				return dx_SetFullSceneAntiAliasingMode_x64( Samples , Quality );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetGraphDisplayArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphDisplayArea_x86( int  x1, int  y1, int  x2, int  y2);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetGraphDisplayArea", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetGraphDisplayArea_x64( int  x1, int  y1, int  x2, int  y2);
		public static int  SetGraphDisplayArea( int  x1, int  y1, int  x2, int  y2)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetGraphDisplayArea_x86( x1 , y1 , x2 , y2 );
			}
			else
			{
				return dx_SetGraphDisplayArea_x64( x1 , y1 , x2 , y2 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetChangeScreenModeGraphicsSystemResetFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetChangeScreenModeGraphicsSystemResetFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetChangeScreenModeGraphicsSystemResetFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetChangeScreenModeGraphicsSystemResetFlag_x64( int  Flag);
		public static int  SetChangeScreenModeGraphicsSystemResetFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetChangeScreenModeGraphicsSystemResetFlag_x86( Flag );
			}
			else
			{
				return dx_SetChangeScreenModeGraphicsSystemResetFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetScreenState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetScreenState_x86( out int  SizeX, out int  SizeY, out int  ColorBitDepth);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetScreenState", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetScreenState_x64( out int  SizeX, out int  SizeY, out int  ColorBitDepth);
		public static int  GetScreenState( out int  SizeX, out int  SizeY, out int  ColorBitDepth)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetScreenState_x86( out SizeX , out SizeY , out ColorBitDepth );
			}
			else
			{
				return dx_GetScreenState_x64( out SizeX , out SizeY , out ColorBitDepth );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawScreenSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawScreenSize_x86( out int  XBuf, out int  YBuf);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawScreenSize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawScreenSize_x64( out int  XBuf, out int  YBuf);
		public static int  GetDrawScreenSize( out int  XBuf, out int  YBuf)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawScreenSize_x86( out XBuf , out YBuf );
			}
			else
			{
				return dx_GetDrawScreenSize_x64( out XBuf , out YBuf );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetScreenBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetScreenBitDepth_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetScreenBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetScreenBitDepth_x64( );
		public static int  GetScreenBitDepth( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetScreenBitDepth_x86( );
			}
			else
			{
				return dx_GetScreenBitDepth_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetColorBitDepth_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetColorBitDepth", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetColorBitDepth_x64( );
		public static int  GetColorBitDepth( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetColorBitDepth_x86( );
			}
			else
			{
				return dx_GetColorBitDepth_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetChangeDisplayFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetChangeDisplayFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetChangeDisplayFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetChangeDisplayFlag_x64( );
		public static int  GetChangeDisplayFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetChangeDisplayFlag_x86( );
			}
			else
			{
				return dx_GetChangeDisplayFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetVideoMemorySize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVideoMemorySize_x86( out int  AllSize, out int  FreeSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetVideoMemorySize", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVideoMemorySize_x64( out int  AllSize, out int  FreeSize);
		public static int  GetVideoMemorySize( out int  AllSize, out int  FreeSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetVideoMemorySize_x86( out AllSize , out FreeSize );
			}
			else
			{
				return dx_GetVideoMemorySize_x64( out AllSize , out FreeSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetVideoMemorySizeEx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVideoMemorySizeEx_x86( out ulong  TotalSize, out ulong  UseSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetVideoMemorySizeEx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetVideoMemorySizeEx_x64( out ulong  TotalSize, out ulong  UseSize);
		public static int  GetVideoMemorySizeEx( out ulong  TotalSize, out ulong  UseSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetVideoMemorySizeEx_x86( out TotalSize , out UseSize );
			}
			else
			{
				return dx_GetVideoMemorySizeEx_x64( out TotalSize , out UseSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetRefreshRate", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetRefreshRate_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetRefreshRate", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetRefreshRate_x64( );
		public static int  GetRefreshRate( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetRefreshRate_x86( );
			}
			else
			{
				return dx_GetRefreshRate_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDisplayNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDisplayNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayNum_x64( );
		public static int  GetDisplayNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayNum_x86( );
			}
			else
			{
				return dx_GetDisplayNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDisplayInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayInfo_x86( int  DisplayIndex, out int  DesktopRectX, out int  DesktopRectY, out int  DesktopSizeX, out int  DesktopSizeY, out int  IsPrimary, out int  DesktopRefreshRate);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDisplayInfo", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayInfo_x64( int  DisplayIndex, out int  DesktopRectX, out int  DesktopRectY, out int  DesktopSizeX, out int  DesktopSizeY, out int  IsPrimary, out int  DesktopRefreshRate);
		public static int  GetDisplayInfo( int  DisplayIndex, out int  DesktopRectX, out int  DesktopRectY, out int  DesktopSizeX, out int  DesktopSizeY, out int  IsPrimary, out int  DesktopRefreshRate)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayInfo_x86( DisplayIndex , out DesktopRectX , out DesktopRectY , out DesktopSizeX , out DesktopSizeY , out IsPrimary , out DesktopRefreshRate );
			}
			else
			{
				return dx_GetDisplayInfo_x64( DisplayIndex , out DesktopRectX , out DesktopRectY , out DesktopSizeX , out DesktopSizeY , out IsPrimary , out DesktopRefreshRate );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDisplayModeNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayModeNum_x86( int  DisplayIndex);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDisplayModeNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayModeNum_x64( int  DisplayIndex);
		public static int  GetDisplayModeNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayModeNum_x86( 0 );
			}
			else
			{
				return dx_GetDisplayModeNum_x64( 0 );
			}
		}
		public static int  GetDisplayModeNum( int  DisplayIndex)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayModeNum_x86( DisplayIndex );
			}
			else
			{
				return dx_GetDisplayModeNum_x64( DisplayIndex );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDisplayMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static DISPLAYMODEDATA  dx_GetDisplayMode_x86( int  ModeIndex, int  DisplayIndex);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDisplayMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static DISPLAYMODEDATA  dx_GetDisplayMode_x64( int  ModeIndex, int  DisplayIndex);
		public static DISPLAYMODEDATA  GetDisplayMode( int  ModeIndex)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayMode_x86( ModeIndex , 0 );
			}
			else
			{
				return dx_GetDisplayMode_x64( ModeIndex , 0 );
			}
		}
		public static DISPLAYMODEDATA  GetDisplayMode( int  ModeIndex, int  DisplayIndex)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayMode_x86( ModeIndex , DisplayIndex );
			}
			else
			{
				return dx_GetDisplayMode_x64( ModeIndex , DisplayIndex );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFullScreenUseDisplayMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static DISPLAYMODEDATA  dx_GetFullScreenUseDisplayMode_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFullScreenUseDisplayMode", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static DISPLAYMODEDATA  dx_GetFullScreenUseDisplayMode_x64( );
		public static DISPLAYMODEDATA  GetFullScreenUseDisplayMode( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFullScreenUseDisplayMode_x86( );
			}
			else
			{
				return dx_GetFullScreenUseDisplayMode_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDisplayMaxResolution", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayMaxResolution_x86( out int  SizeX, out int  SizeY, int  DisplayIndex);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDisplayMaxResolution", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDisplayMaxResolution_x64( out int  SizeX, out int  SizeY, int  DisplayIndex);
		public static int  GetDisplayMaxResolution( out int  SizeX, out int  SizeY)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayMaxResolution_x86( out SizeX , out SizeY , 0 );
			}
			else
			{
				return dx_GetDisplayMaxResolution_x64( out SizeX , out SizeY , 0 );
			}
		}
		public static int  GetDisplayMaxResolution( out int  SizeX, out int  SizeY, int  DisplayIndex)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDisplayMaxResolution_x86( out SizeX , out SizeY , DisplayIndex );
			}
			else
			{
				return dx_GetDisplayMaxResolution_x64( out SizeX , out SizeY , DisplayIndex );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMultiDrawScreenNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMultiDrawScreenNum_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMultiDrawScreenNum", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMultiDrawScreenNum_x64( );
		public static int  GetMultiDrawScreenNum( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMultiDrawScreenNum_x86( );
			}
			else
			{
				return dx_GetMultiDrawScreenNum_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawFloatCoordType", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawFloatCoordType_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawFloatCoordType", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawFloatCoordType_x64( );
		public static int  GetDrawFloatCoordType( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawFloatCoordType_x86( );
			}
			else
			{
				return dx_GetDrawFloatCoordType_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseNormalDrawShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseNormalDrawShader_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseNormalDrawShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseNormalDrawShader_x64( int  Flag);
		public static int  SetUseNormalDrawShader( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseNormalDrawShader_x86( Flag );
			}
			else
			{
				return dx_SetUseNormalDrawShader_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseSoftwareRenderModeFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseSoftwareRenderModeFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseSoftwareRenderModeFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseSoftwareRenderModeFlag_x64( int  Flag);
		public static int  SetUseSoftwareRenderModeFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseSoftwareRenderModeFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseSoftwareRenderModeFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetNotUse3DFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotUse3DFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetNotUse3DFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetNotUse3DFlag_x64( int  Flag);
		public static int  SetNotUse3DFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetNotUse3DFlag_x86( Flag );
			}
			else
			{
				return dx_SetNotUse3DFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUse3DFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUse3DFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUse3DFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUse3DFlag_x64( int  Flag);
		public static int  SetUse3DFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUse3DFlag_x86( Flag );
			}
			else
			{
				return dx_SetUse3DFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUse3DFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUse3DFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUse3DFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUse3DFlag_x64( );
		public static int  GetUse3DFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUse3DFlag_x86( );
			}
			else
			{
				return dx_GetUse3DFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetScreenMemToVramFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetScreenMemToVramFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetScreenMemToVramFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetScreenMemToVramFlag_x64( int  Flag);
		public static int  SetScreenMemToVramFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetScreenMemToVramFlag_x86( Flag );
			}
			else
			{
				return dx_SetScreenMemToVramFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetScreenMemToSystemMemFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetScreenMemToSystemMemFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetScreenMemToSystemMemFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetScreenMemToSystemMemFlag_x64( );
		public static int  GetScreenMemToSystemMemFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetScreenMemToSystemMemFlag_x86( );
			}
			else
			{
				return dx_GetScreenMemToSystemMemFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetWindowDrawRect", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWindowDrawRect_x86( out RECT  DrawRect);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetWindowDrawRect", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetWindowDrawRect_x64( out RECT  DrawRect);
		public static int  SetWindowDrawRect( out RECT  DrawRect)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetWindowDrawRect_x86( out DrawRect );
			}
			else
			{
				return dx_SetWindowDrawRect_x64( out DrawRect );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_RestoreGraphSystem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_RestoreGraphSystem_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_RestoreGraphSystem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_RestoreGraphSystem_x64( );
		public static int  RestoreGraphSystem( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_RestoreGraphSystem_x86( );
			}
			else
			{
				return dx_RestoreGraphSystem_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseHardwareVertexProcessing", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseHardwareVertexProcessing_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseHardwareVertexProcessing", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseHardwareVertexProcessing_x64( int  Flag);
		public static int  SetUseHardwareVertexProcessing( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseHardwareVertexProcessing_x86( Flag );
			}
			else
			{
				return dx_SetUseHardwareVertexProcessing_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUsePixelLighting", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePixelLighting_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUsePixelLighting", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePixelLighting_x64( int  Flag);
		public static int  SetUsePixelLighting( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUsePixelLighting_x86( Flag );
			}
			else
			{
				return dx_SetUsePixelLighting_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseOldDrawModiGraphCodeFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseOldDrawModiGraphCodeFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseOldDrawModiGraphCodeFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseOldDrawModiGraphCodeFlag_x64( int  Flag);
		public static int  SetUseOldDrawModiGraphCodeFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseOldDrawModiGraphCodeFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseOldDrawModiGraphCodeFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseVramFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseVramFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseVramFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseVramFlag_x64( int  Flag);
		public static int  SetUseVramFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseVramFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseVramFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetUseVramFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseVramFlag_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetUseVramFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetUseVramFlag_x64( );
		public static int  GetUseVramFlag( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetUseVramFlag_x86( );
			}
			else
			{
				return dx_GetUseVramFlag_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetBasicBlendFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBasicBlendFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetBasicBlendFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetBasicBlendFlag_x64( int  Flag);
		public static int  SetBasicBlendFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetBasicBlendFlag_x86( Flag );
			}
			else
			{
				return dx_SetBasicBlendFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseBasicGraphDraw3DDeviceMethodFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseBasicGraphDraw3DDeviceMethodFlag_x86( int  Flag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseBasicGraphDraw3DDeviceMethodFlag", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseBasicGraphDraw3DDeviceMethodFlag_x64( int  Flag);
		public static int  SetUseBasicGraphDraw3DDeviceMethodFlag( int  Flag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseBasicGraphDraw3DDeviceMethodFlag_x86( Flag );
			}
			else
			{
				return dx_SetUseBasicGraphDraw3DDeviceMethodFlag_x64( Flag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseDisplayIndex", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDisplayIndex_x86( int  Index);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseDisplayIndex", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseDisplayIndex_x64( int  Index);
		public static int  SetUseDisplayIndex( int  Index)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseDisplayIndex_x86( Index );
			}
			else
			{
				return dx_SetUseDisplayIndex_x64( Index );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_RenderVertex", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_RenderVertex_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_RenderVertex", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_RenderVertex_x64( );
		public static int  RenderVertex( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_RenderVertex_x86( );
			}
			else
			{
				return dx_RenderVertex_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetDrawCallCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawCallCount_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetDrawCallCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetDrawCallCount_x64( );
		public static int  GetDrawCallCount( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetDrawCallCount_x86( );
			}
			else
			{
				return dx_GetDrawCallCount_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetFPS", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetFPS_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetFPS", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static float  dx_GetFPS_x64( );
		public static float  GetFPS( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetFPS_x86( );
			}
			else
			{
				return dx_GetFPS_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreen_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreen_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		public static int  SaveDrawScreen( int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreen_x86( x1 , y1 , x2 , y2 , FileName , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawScreen_x64( x1 , y1 , x2 , y2 , FileName , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawScreen( int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreen_x86( x1 , y1 , x2 , y2 , FileName , SaveType , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawScreen_x64( x1 , y1 , x2 , y2 , FileName , SaveType , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawScreen( int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreen_x86( x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawScreen_x64( x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , TRUE , -1 );
			}
		}
		public static int  SaveDrawScreen( int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreen_x86( x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
			else
			{
				return dx_SaveDrawScreen_x64( x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
		}
		public static int  SaveDrawScreen( int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreen_x86( x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
			else
			{
				return dx_SaveDrawScreen_x64( x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenWithStrLen_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenWithStrLen_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		public static int  SaveDrawScreenWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawScreenWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawScreenWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawScreenWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawScreenWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , Jpeg_Quality , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawScreenWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , Jpeg_Quality , TRUE , -1 );
			}
		}
		public static int  SaveDrawScreenWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
			else
			{
				return dx_SaveDrawScreenWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
		}
		public static int  SaveDrawScreenWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
			else
			{
				return dx_SaveDrawScreenWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToBMP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToBMP_x86( int  x1, int  y1, int  x2, int  y2, string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToBMP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToBMP_x64( int  x1, int  y1, int  x2, int  y2, string  FileName);
		public static int  SaveDrawScreenToBMP( int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToBMP_x86( x1 , y1 , x2 , y2 , FileName );
			}
			else
			{
				return dx_SaveDrawScreenToBMP_x64( x1 , y1 , x2 , y2 , FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToBMPWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToBMPWithStrLen_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToBMPWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToBMPWithStrLen_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength);
		public static int  SaveDrawScreenToBMPWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToBMPWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_SaveDrawScreenToBMPWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToDDS", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToDDS_x86( int  x1, int  y1, int  x2, int  y2, string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToDDS", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToDDS_x64( int  x1, int  y1, int  x2, int  y2, string  FileName);
		public static int  SaveDrawScreenToDDS( int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToDDS_x86( x1 , y1 , x2 , y2 , FileName );
			}
			else
			{
				return dx_SaveDrawScreenToDDS_x64( x1 , y1 , x2 , y2 , FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToDDSWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToDDSWithStrLen_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToDDSWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToDDSWithStrLen_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength);
		public static int  SaveDrawScreenToDDSWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToDDSWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_SaveDrawScreenToDDSWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToJPEG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToJPEG_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality, int  Sample2x1);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToJPEG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToJPEG_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality, int  Sample2x1);
		public static int  SaveDrawScreenToJPEG( int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToJPEG_x86( x1 , y1 , x2 , y2 , FileName , 80 , TRUE );
			}
			else
			{
				return dx_SaveDrawScreenToJPEG_x64( x1 , y1 , x2 , y2 , FileName , 80 , TRUE );
			}
		}
		public static int  SaveDrawScreenToJPEG( int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToJPEG_x86( x1 , y1 , x2 , y2 , FileName , Quality , TRUE );
			}
			else
			{
				return dx_SaveDrawScreenToJPEG_x64( x1 , y1 , x2 , y2 , FileName , Quality , TRUE );
			}
		}
		public static int  SaveDrawScreenToJPEG( int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality, int  Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToJPEG_x86( x1 , y1 , x2 , y2 , FileName , Quality , Sample2x1 );
			}
			else
			{
				return dx_SaveDrawScreenToJPEG_x64( x1 , y1 , x2 , y2 , FileName , Quality , Sample2x1 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToJPEGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToJPEGWithStrLen_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength, int  Quality, int  Sample2x1);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToJPEGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToJPEGWithStrLen_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  Quality, int  Sample2x1);
		public static int  SaveDrawScreenToJPEGWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToJPEGWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , 80 , TRUE );
			}
			else
			{
				return dx_SaveDrawScreenToJPEGWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , 80 , TRUE );
			}
		}
		public static int  SaveDrawScreenToJPEGWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToJPEGWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , Quality , TRUE );
			}
			else
			{
				return dx_SaveDrawScreenToJPEGWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , Quality , TRUE );
			}
		}
		public static int  SaveDrawScreenToJPEGWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  Quality, int  Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToJPEGWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , Quality , Sample2x1 );
			}
			else
			{
				return dx_SaveDrawScreenToJPEGWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , Quality , Sample2x1 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToPNG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToPNG_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, int  CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToPNG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToPNG_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, int  CompressionLevel);
		public static int  SaveDrawScreenToPNG( int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToPNG_x86( x1 , y1 , x2 , y2 , FileName , -1 );
			}
			else
			{
				return dx_SaveDrawScreenToPNG_x64( x1 , y1 , x2 , y2 , FileName , -1 );
			}
		}
		public static int  SaveDrawScreenToPNG( int  x1, int  y1, int  x2, int  y2, string  FileName, int  CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToPNG_x86( x1 , y1 , x2 , y2 , FileName , CompressionLevel );
			}
			else
			{
				return dx_SaveDrawScreenToPNG_x64( x1 , y1 , x2 , y2 , FileName , CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawScreenToPNGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToPNGWithStrLen_x86( int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength, int  CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawScreenToPNGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawScreenToPNGWithStrLen_x64( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  CompressionLevel);
		public static int  SaveDrawScreenToPNGWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToPNGWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , -1 );
			}
			else
			{
				return dx_SaveDrawScreenToPNGWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , -1 );
			}
		}
		public static int  SaveDrawScreenToPNGWithStrLen( int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawScreenToPNGWithStrLen_x86( x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , CompressionLevel );
			}
			else
			{
				return dx_SaveDrawScreenToPNGWithStrLen_x64( x1 , y1 , x2 , y2 , FileName , FileNameLength , CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraph_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraph", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraph_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		public static int  SaveDrawValidGraph( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraph_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraph_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawValidGraph( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraph_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraph_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawValidGraph( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraph_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraph_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , TRUE , -1 );
			}
		}
		public static int  SaveDrawValidGraph( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraph_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraph_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
		}
		public static int  SaveDrawValidGraph( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraph_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
			else
			{
				return dx_SaveDrawValidGraph_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphWithStrLen_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphWithStrLen_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel);
		public static int  SaveDrawValidGraphWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraphWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , DX_IMAGESAVETYPE_BMP , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawValidGraphWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , 80 , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraphWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , 80 , TRUE , -1 );
			}
		}
		public static int  SaveDrawValidGraphWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , Jpeg_Quality , TRUE , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraphWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , Jpeg_Quality , TRUE , -1 );
			}
		}
		public static int  SaveDrawValidGraphWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraphWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , -1 );
			}
		}
		public static int  SaveDrawValidGraphWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  SaveType, int  Jpeg_Quality, int  Jpeg_Sample2x1, int  Png_CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
			else
			{
				return dx_SaveDrawValidGraphWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , SaveType , Jpeg_Quality , Jpeg_Sample2x1 , Png_CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToBMP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToBMP_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToBMP", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToBMP_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName);
		public static int  SaveDrawValidGraphToBMP( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToBMP_x86( GrHandle , x1 , y1 , x2 , y2 , FileName );
			}
			else
			{
				return dx_SaveDrawValidGraphToBMP_x64( GrHandle , x1 , y1 , x2 , y2 , FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToBMPWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToBMPWithStrLen_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToBMPWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToBMPWithStrLen_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength);
		public static int  SaveDrawValidGraphToBMPWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToBMPWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_SaveDrawValidGraphToBMPWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToDDS", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToDDS_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToDDS", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToDDS_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName);
		public static int  SaveDrawValidGraphToDDS( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToDDS_x86( GrHandle , x1 , y1 , x2 , y2 , FileName );
			}
			else
			{
				return dx_SaveDrawValidGraphToDDS_x64( GrHandle , x1 , y1 , x2 , y2 , FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToDDSWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToDDSWithStrLen_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToDDSWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToDDSWithStrLen_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength);
		public static int  SaveDrawValidGraphToDDSWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToDDSWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_SaveDrawValidGraphToDDSWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToJPEG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToJPEG_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality, int  Sample2x1);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToJPEG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToJPEG_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality, int  Sample2x1);
		public static int  SaveDrawValidGraphToJPEG( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToJPEG_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , 80 , TRUE );
			}
			else
			{
				return dx_SaveDrawValidGraphToJPEG_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , 80 , TRUE );
			}
		}
		public static int  SaveDrawValidGraphToJPEG( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToJPEG_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , Quality , TRUE );
			}
			else
			{
				return dx_SaveDrawValidGraphToJPEG_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , Quality , TRUE );
			}
		}
		public static int  SaveDrawValidGraphToJPEG( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  Quality, int  Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToJPEG_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , Quality , Sample2x1 );
			}
			else
			{
				return dx_SaveDrawValidGraphToJPEG_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , Quality , Sample2x1 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToJPEGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToJPEGWithStrLen_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength, int  Quality, int  Sample2x1);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToJPEGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToJPEGWithStrLen_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  Quality, int  Sample2x1);
		public static int  SaveDrawValidGraphToJPEGWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToJPEGWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , 80 , TRUE );
			}
			else
			{
				return dx_SaveDrawValidGraphToJPEGWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , 80 , TRUE );
			}
		}
		public static int  SaveDrawValidGraphToJPEGWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  Quality)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToJPEGWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , Quality , TRUE );
			}
			else
			{
				return dx_SaveDrawValidGraphToJPEGWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , Quality , TRUE );
			}
		}
		public static int  SaveDrawValidGraphToJPEGWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  Quality, int  Sample2x1)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToJPEGWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , Quality , Sample2x1 );
			}
			else
			{
				return dx_SaveDrawValidGraphToJPEGWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , Quality , Sample2x1 );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToPNG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToPNG_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToPNG", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToPNG_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  CompressionLevel);
		public static int  SaveDrawValidGraphToPNG( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToPNG_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraphToPNG_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , -1 );
			}
		}
		public static int  SaveDrawValidGraphToPNG( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, int  CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToPNG_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , CompressionLevel );
			}
			else
			{
				return dx_SaveDrawValidGraphToPNG_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SaveDrawValidGraphToPNGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToPNGWithStrLen_x86( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, uint FileNameLength, int  CompressionLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SaveDrawValidGraphToPNGWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SaveDrawValidGraphToPNGWithStrLen_x64( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  CompressionLevel);
		public static int  SaveDrawValidGraphToPNGWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToPNGWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , -1 );
			}
			else
			{
				return dx_SaveDrawValidGraphToPNGWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , -1 );
			}
		}
		public static int  SaveDrawValidGraphToPNGWithStrLen( int  GrHandle, int  x1, int  y1, int  x2, int  y2, string  FileName, ulong FileNameLength, int  CompressionLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SaveDrawValidGraphToPNGWithStrLen_x86( GrHandle , x1 , y1 , x2 , y2 , FileName , ( uint )FileNameLength , CompressionLevel );
			}
			else
			{
				return dx_SaveDrawValidGraphToPNGWithStrLen_x64( GrHandle , x1 , y1 , x2 , y2 , FileName , FileNameLength , CompressionLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateVertexBuffer_x86( int  VertexNum, int  VertexType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateVertexBuffer_x64( int  VertexNum, int  VertexType);
		public static int  CreateVertexBuffer( int  VertexNum, int  VertexType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateVertexBuffer_x86( VertexNum , VertexType );
			}
			else
			{
				return dx_CreateVertexBuffer_x64( VertexNum , VertexType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteVertexBuffer_x86( int  VertexBufHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteVertexBuffer_x64( int  VertexBufHandle);
		public static int  DeleteVertexBuffer( int  VertexBufHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteVertexBuffer_x86( VertexBufHandle );
			}
			else
			{
				return dx_DeleteVertexBuffer_x64( VertexBufHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_InitVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitVertexBuffer_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_InitVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitVertexBuffer_x64( );
		public static int  InitVertexBuffer( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InitVertexBuffer_x86( );
			}
			else
			{
				return dx_InitVertexBuffer_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVertexBufferData", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVertexBufferData_x86( int  SetIndex, System.IntPtr  VertexArray, int  VertexNum, int  VertexBufHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVertexBufferData", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVertexBufferData_x64( int  SetIndex, System.IntPtr  VertexArray, int  VertexNum, int  VertexBufHandle);
		public static int  SetVertexBufferData( int  SetIndex, System.IntPtr  VertexArray, int  VertexNum, int  VertexBufHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVertexBufferData_x86( SetIndex , VertexArray , VertexNum , VertexBufHandle );
			}
			else
			{
				return dx_SetVertexBufferData_x64( SetIndex , VertexArray , VertexNum , VertexBufHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetBufferVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_GetBufferVertexBuffer_x86( int  VertexBufHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetBufferVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_GetBufferVertexBuffer_x64( int  VertexBufHandle);
		public static System.IntPtr  GetBufferVertexBuffer( int  VertexBufHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetBufferVertexBuffer_x86( VertexBufHandle );
			}
			else
			{
				return dx_GetBufferVertexBuffer_x64( VertexBufHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_UpdateVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_UpdateVertexBuffer_x86( int  VertexBufHandle, int  UpdateStartIndex, int  UpdateVertexNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_UpdateVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_UpdateVertexBuffer_x64( int  VertexBufHandle, int  UpdateStartIndex, int  UpdateVertexNum);
		public static int  UpdateVertexBuffer( int  VertexBufHandle, int  UpdateStartIndex, int  UpdateVertexNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_UpdateVertexBuffer_x86( VertexBufHandle , UpdateStartIndex , UpdateVertexNum );
			}
			else
			{
				return dx_UpdateVertexBuffer_x64( VertexBufHandle , UpdateStartIndex , UpdateVertexNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CreateIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateIndexBuffer_x86( int  IndexNum, int  IndexType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CreateIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CreateIndexBuffer_x64( int  IndexNum, int  IndexType);
		public static int  CreateIndexBuffer( int  IndexNum, int  IndexType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CreateIndexBuffer_x86( IndexNum , IndexType );
			}
			else
			{
				return dx_CreateIndexBuffer_x64( IndexNum , IndexType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteIndexBuffer_x86( int  IndexBufHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteIndexBuffer_x64( int  IndexBufHandle);
		public static int  DeleteIndexBuffer( int  IndexBufHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteIndexBuffer_x86( IndexBufHandle );
			}
			else
			{
				return dx_DeleteIndexBuffer_x64( IndexBufHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_InitIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitIndexBuffer_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_InitIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitIndexBuffer_x64( );
		public static int  InitIndexBuffer( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InitIndexBuffer_x86( );
			}
			else
			{
				return dx_InitIndexBuffer_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetIndexBufferData", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIndexBufferData_x86( int  SetIndex, System.IntPtr  IndexArray, int  IndexNum, int  IndexBufHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetIndexBufferData", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetIndexBufferData_x64( int  SetIndex, System.IntPtr  IndexArray, int  IndexNum, int  IndexBufHandle);
		public static int  SetIndexBufferData( int  SetIndex, System.IntPtr  IndexArray, int  IndexNum, int  IndexBufHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetIndexBufferData_x86( SetIndex , IndexArray , IndexNum , IndexBufHandle );
			}
			else
			{
				return dx_SetIndexBufferData_x64( SetIndex , IndexArray , IndexNum , IndexBufHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetBufferIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_GetBufferIndexBuffer_x86( int  IndexBufHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetBufferIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static System.IntPtr  dx_GetBufferIndexBuffer_x64( int  IndexBufHandle);
		public static System.IntPtr  GetBufferIndexBuffer( int  IndexBufHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetBufferIndexBuffer_x86( IndexBufHandle );
			}
			else
			{
				return dx_GetBufferIndexBuffer_x64( IndexBufHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_UpdateIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_UpdateIndexBuffer_x86( int  IndexBufHandle, int  UpdateStartIndex, int  UpdateIndexNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_UpdateIndexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_UpdateIndexBuffer_x64( int  IndexBufHandle, int  UpdateStartIndex, int  UpdateIndexNum);
		public static int  UpdateIndexBuffer( int  IndexBufHandle, int  UpdateStartIndex, int  UpdateIndexNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_UpdateIndexBuffer_x86( IndexBufHandle , UpdateStartIndex , UpdateIndexNum );
			}
			else
			{
				return dx_UpdateIndexBuffer_x64( IndexBufHandle , UpdateStartIndex , UpdateIndexNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMaxPrimitiveCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxPrimitiveCount_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMaxPrimitiveCount", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxPrimitiveCount_x64( );
		public static int  GetMaxPrimitiveCount( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMaxPrimitiveCount_x86( );
			}
			else
			{
				return dx_GetMaxPrimitiveCount_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetMaxVertexIndex", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxVertexIndex_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetMaxVertexIndex", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetMaxVertexIndex_x64( );
		public static int  GetMaxVertexIndex( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetMaxVertexIndex_x86( );
			}
			else
			{
				return dx_GetMaxVertexIndex_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetValidShaderVersion", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetValidShaderVersion_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetValidShaderVersion", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetValidShaderVersion_x64( );
		public static int  GetValidShaderVersion( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetValidShaderVersion_x86( );
			}
			else
			{
				return dx_GetValidShaderVersion_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadVertexShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadVertexShader_x86( string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadVertexShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadVertexShader_x64( string  FileName);
		public static int  LoadVertexShader( string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadVertexShader_x86( FileName );
			}
			else
			{
				return dx_LoadVertexShader_x64( FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadVertexShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadVertexShaderWithStrLen_x86( string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadVertexShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadVertexShaderWithStrLen_x64( string  FileName, ulong FileNameLength);
		public static int  LoadVertexShaderWithStrLen( string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadVertexShaderWithStrLen_x86( FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_LoadVertexShaderWithStrLen_x64( FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadGeometryShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGeometryShader_x86( string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadGeometryShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGeometryShader_x64( string  FileName);
		public static int  LoadGeometryShader( string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGeometryShader_x86( FileName );
			}
			else
			{
				return dx_LoadGeometryShader_x64( FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadGeometryShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGeometryShaderWithStrLen_x86( string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadGeometryShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGeometryShaderWithStrLen_x64( string  FileName, ulong FileNameLength);
		public static int  LoadGeometryShaderWithStrLen( string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGeometryShaderWithStrLen_x86( FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_LoadGeometryShaderWithStrLen_x64( FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadPixelShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadPixelShader_x86( string  FileName);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadPixelShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadPixelShader_x64( string  FileName);
		public static int  LoadPixelShader( string  FileName)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadPixelShader_x86( FileName );
			}
			else
			{
				return dx_LoadPixelShader_x64( FileName );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadPixelShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadPixelShaderWithStrLen_x86( string  FileName, uint FileNameLength);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadPixelShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadPixelShaderWithStrLen_x64( string  FileName, ulong FileNameLength);
		public static int  LoadPixelShaderWithStrLen( string  FileName, ulong FileNameLength)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadPixelShaderWithStrLen_x86( FileName , ( uint )FileNameLength );
			}
			else
			{
				return dx_LoadPixelShaderWithStrLen_x64( FileName , FileNameLength );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadVertexShaderFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadVertexShaderFromMem_x86( System.IntPtr  ImageAddress, int  ImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadVertexShaderFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadVertexShaderFromMem_x64( System.IntPtr  ImageAddress, int  ImageSize);
		public static int  LoadVertexShaderFromMem( System.IntPtr  ImageAddress, int  ImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadVertexShaderFromMem_x86( ImageAddress , ImageSize );
			}
			else
			{
				return dx_LoadVertexShaderFromMem_x64( ImageAddress , ImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadGeometryShaderFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGeometryShaderFromMem_x86( System.IntPtr  ImageAddress, int  ImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadGeometryShaderFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadGeometryShaderFromMem_x64( System.IntPtr  ImageAddress, int  ImageSize);
		public static int  LoadGeometryShaderFromMem( System.IntPtr  ImageAddress, int  ImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadGeometryShaderFromMem_x86( ImageAddress , ImageSize );
			}
			else
			{
				return dx_LoadGeometryShaderFromMem_x64( ImageAddress , ImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_LoadPixelShaderFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadPixelShaderFromMem_x86( System.IntPtr  ImageAddress, int  ImageSize);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_LoadPixelShaderFromMem", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_LoadPixelShaderFromMem_x64( System.IntPtr  ImageAddress, int  ImageSize);
		public static int  LoadPixelShaderFromMem( System.IntPtr  ImageAddress, int  ImageSize)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_LoadPixelShaderFromMem_x86( ImageAddress , ImageSize );
			}
			else
			{
				return dx_LoadPixelShaderFromMem_x64( ImageAddress , ImageSize );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DeleteShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteShader_x86( int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DeleteShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DeleteShader_x64( int  ShaderHandle);
		public static int  DeleteShader( int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DeleteShader_x86( ShaderHandle );
			}
			else
			{
				return dx_DeleteShader_x64( ShaderHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_InitShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitShader_x86( );
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_InitShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_InitShader_x64( );
		public static int  InitShader( )
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_InitShader_x86( );
			}
			else
			{
				return dx_InitShader_x64( );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetConstIndexToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstIndexToShader_x86( string  ConstantName, int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetConstIndexToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstIndexToShader_x64( string  ConstantName, int  ShaderHandle);
		public static int  GetConstIndexToShader( string  ConstantName, int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetConstIndexToShader_x86( ConstantName , ShaderHandle );
			}
			else
			{
				return dx_GetConstIndexToShader_x64( ConstantName , ShaderHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetConstIndexToShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstIndexToShaderWithStrLen_x86( string  ConstantName, uint ConstantNameLength, int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetConstIndexToShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstIndexToShaderWithStrLen_x64( string  ConstantName, ulong ConstantNameLength, int  ShaderHandle);
		public static int  GetConstIndexToShaderWithStrLen( string  ConstantName, ulong ConstantNameLength, int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetConstIndexToShaderWithStrLen_x86( ConstantName , ( uint )ConstantNameLength , ShaderHandle );
			}
			else
			{
				return dx_GetConstIndexToShaderWithStrLen_x64( ConstantName , ConstantNameLength , ShaderHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetConstCountToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstCountToShader_x86( string  ConstantName, int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetConstCountToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstCountToShader_x64( string  ConstantName, int  ShaderHandle);
		public static int  GetConstCountToShader( string  ConstantName, int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetConstCountToShader_x86( ConstantName , ShaderHandle );
			}
			else
			{
				return dx_GetConstCountToShader_x64( ConstantName , ShaderHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_GetConstCountToShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstCountToShaderWithStrLen_x86( string  ConstantName, uint ConstantNameLength, int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetConstCountToShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_GetConstCountToShaderWithStrLen_x64( string  ConstantName, ulong ConstantNameLength, int  ShaderHandle);
		public static int  GetConstCountToShaderWithStrLen( string  ConstantName, ulong ConstantNameLength, int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetConstCountToShaderWithStrLen_x86( ConstantName , ( uint )ConstantNameLength , ShaderHandle );
			}
			else
			{
				return dx_GetConstCountToShaderWithStrLen_x64( ConstantName , ConstantNameLength , ShaderHandle );
			}
		}

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetConstDefaultParamFToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static FLOAT4 *  dx_GetConstDefaultParamFToShader_x86( string  ConstantName, int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetConstDefaultParamFToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static FLOAT4 *  dx_GetConstDefaultParamFToShader_x64( string  ConstantName, int  ShaderHandle);
		public unsafe static FLOAT4 *  GetConstDefaultParamFToShader( string  ConstantName, int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetConstDefaultParamFToShader_x86( ConstantName , ShaderHandle );
			}
			else
			{
				return dx_GetConstDefaultParamFToShader_x64( ConstantName , ShaderHandle );
			}
		}
#endif

#if DX_USE_UNSAFE
		[DllImport("DxLibW.dll", EntryPoint="dx_GetConstDefaultParamFToShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static FLOAT4 *  dx_GetConstDefaultParamFToShaderWithStrLen_x86( string  ConstantName, uint ConstantNameLength, int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_GetConstDefaultParamFToShaderWithStrLen", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern unsafe static FLOAT4 *  dx_GetConstDefaultParamFToShaderWithStrLen_x64( string  ConstantName, ulong ConstantNameLength, int  ShaderHandle);
		public unsafe static FLOAT4 *  GetConstDefaultParamFToShaderWithStrLen( string  ConstantName, ulong ConstantNameLength, int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_GetConstDefaultParamFToShaderWithStrLen_x86( ConstantName , ( uint )ConstantNameLength , ShaderHandle );
			}
			else
			{
				return dx_GetConstDefaultParamFToShaderWithStrLen_x64( ConstantName , ConstantNameLength , ShaderHandle );
			}
		}
#endif

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstSF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSF_x86( int  ConstantIndex, float  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstSF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSF_x64( int  ConstantIndex, float  Param);
		public static int  SetVSConstSF( int  ConstantIndex, float  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstSF_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetVSConstSF_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstF_x86( int  ConstantIndex, FLOAT4  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstF_x64( int  ConstantIndex, FLOAT4  Param);
		public static int  SetVSConstF( int  ConstantIndex, FLOAT4  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstF_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetVSConstF_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstFMtx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtx_x86( int  ConstantIndex, MATRIX  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstFMtx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtx_x64( int  ConstantIndex, MATRIX  Param);
		public static int  SetVSConstFMtx( int  ConstantIndex, MATRIX  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstFMtx_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetVSConstFMtx_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstFMtxT", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtxT_x86( int  ConstantIndex, MATRIX  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstFMtxT", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtxT_x64( int  ConstantIndex, MATRIX  Param);
		public static int  SetVSConstFMtxT( int  ConstantIndex, MATRIX  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstFMtxT_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetVSConstFMtxT_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstSI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSI_x86( int  ConstantIndex, int  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstSI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSI_x64( int  ConstantIndex, int  Param);
		public static int  SetVSConstSI( int  ConstantIndex, int  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstSI_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetVSConstSI_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstI_x86( int  ConstantIndex, INT4  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstI_x64( int  ConstantIndex, INT4  Param);
		public static int  SetVSConstI( int  ConstantIndex, INT4  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstI_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetVSConstI_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstB_x86( int  ConstantIndex, int  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstB_x64( int  ConstantIndex, int  Param);
		public static int  SetVSConstB( int  ConstantIndex, int  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstB_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetVSConstB_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstSFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSFArray_x86( int  ConstantIndex, [In, Out] float[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstSFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSFArray_x64( int  ConstantIndex, [In, Out] float[]  ParamArray, int  ParamNum);
		public static int  SetVSConstSFArray( int  ConstantIndex, [In, Out] float[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstSFArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetVSConstSFArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFArray_x86( int  ConstantIndex, [In, Out] FLOAT4[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFArray_x64( int  ConstantIndex, [In, Out] FLOAT4[]  ParamArray, int  ParamNum);
		public static int  SetVSConstFArray( int  ConstantIndex, [In, Out] FLOAT4[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstFArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetVSConstFArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstFMtxArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtxArray_x86( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstFMtxArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtxArray_x64( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		public static int  SetVSConstFMtxArray( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstFMtxArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetVSConstFMtxArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstFMtxTArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtxTArray_x86( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstFMtxTArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstFMtxTArray_x64( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		public static int  SetVSConstFMtxTArray( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstFMtxTArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetVSConstFMtxTArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstSIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSIArray_x86( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstSIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstSIArray_x64( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		public static int  SetVSConstSIArray( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstSIArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetVSConstSIArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstIArray_x86( int  ConstantIndex, [In, Out] INT4[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstIArray_x64( int  ConstantIndex, [In, Out] INT4[]  ParamArray, int  ParamNum);
		public static int  SetVSConstIArray( int  ConstantIndex, [In, Out] INT4[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstIArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetVSConstIArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetVSConstBArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstBArray_x86( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetVSConstBArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetVSConstBArray_x64( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		public static int  SetVSConstBArray( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetVSConstBArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetVSConstBArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetVSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetVSConstF_x86( int  ConstantIndex, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetVSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetVSConstF_x64( int  ConstantIndex, int  ParamNum);
		public static int  ResetVSConstF( int  ConstantIndex, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetVSConstF_x86( ConstantIndex , ParamNum );
			}
			else
			{
				return dx_ResetVSConstF_x64( ConstantIndex , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetVSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetVSConstI_x86( int  ConstantIndex, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetVSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetVSConstI_x64( int  ConstantIndex, int  ParamNum);
		public static int  ResetVSConstI( int  ConstantIndex, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetVSConstI_x86( ConstantIndex , ParamNum );
			}
			else
			{
				return dx_ResetVSConstI_x64( ConstantIndex , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetVSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetVSConstB_x86( int  ConstantIndex, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetVSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetVSConstB_x64( int  ConstantIndex, int  ParamNum);
		public static int  ResetVSConstB( int  ConstantIndex, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetVSConstB_x86( ConstantIndex , ParamNum );
			}
			else
			{
				return dx_ResetVSConstB_x64( ConstantIndex , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstSF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSF_x86( int  ConstantIndex, float  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstSF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSF_x64( int  ConstantIndex, float  Param);
		public static int  SetPSConstSF( int  ConstantIndex, float  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstSF_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetPSConstSF_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstF_x86( int  ConstantIndex, FLOAT4  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstF_x64( int  ConstantIndex, FLOAT4  Param);
		public static int  SetPSConstF( int  ConstantIndex, FLOAT4  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstF_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetPSConstF_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstFMtx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtx_x86( int  ConstantIndex, MATRIX  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstFMtx", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtx_x64( int  ConstantIndex, MATRIX  Param);
		public static int  SetPSConstFMtx( int  ConstantIndex, MATRIX  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstFMtx_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetPSConstFMtx_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstFMtxT", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtxT_x86( int  ConstantIndex, MATRIX  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstFMtxT", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtxT_x64( int  ConstantIndex, MATRIX  Param);
		public static int  SetPSConstFMtxT( int  ConstantIndex, MATRIX  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstFMtxT_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetPSConstFMtxT_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstSI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSI_x86( int  ConstantIndex, int  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstSI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSI_x64( int  ConstantIndex, int  Param);
		public static int  SetPSConstSI( int  ConstantIndex, int  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstSI_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetPSConstSI_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstI_x86( int  ConstantIndex, INT4  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstI_x64( int  ConstantIndex, INT4  Param);
		public static int  SetPSConstI( int  ConstantIndex, INT4  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstI_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetPSConstI_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstB_x86( int  ConstantIndex, int  Param);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstB_x64( int  ConstantIndex, int  Param);
		public static int  SetPSConstB( int  ConstantIndex, int  Param)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstB_x86( ConstantIndex , Param );
			}
			else
			{
				return dx_SetPSConstB_x64( ConstantIndex , Param );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstSFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSFArray_x86( int  ConstantIndex, [In, Out] float[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstSFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSFArray_x64( int  ConstantIndex, [In, Out] float[]  ParamArray, int  ParamNum);
		public static int  SetPSConstSFArray( int  ConstantIndex, [In, Out] float[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstSFArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetPSConstSFArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFArray_x86( int  ConstantIndex, [In, Out] FLOAT4[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstFArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFArray_x64( int  ConstantIndex, [In, Out] FLOAT4[]  ParamArray, int  ParamNum);
		public static int  SetPSConstFArray( int  ConstantIndex, [In, Out] FLOAT4[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstFArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetPSConstFArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstFMtxArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtxArray_x86( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstFMtxArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtxArray_x64( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		public static int  SetPSConstFMtxArray( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstFMtxArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetPSConstFMtxArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstFMtxTArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtxTArray_x86( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstFMtxTArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstFMtxTArray_x64( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum);
		public static int  SetPSConstFMtxTArray( int  ConstantIndex, [In, Out] MATRIX[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstFMtxTArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetPSConstFMtxTArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstSIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSIArray_x86( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstSIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstSIArray_x64( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		public static int  SetPSConstSIArray( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstSIArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetPSConstSIArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstIArray_x86( int  ConstantIndex, [In, Out] INT4[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstIArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstIArray_x64( int  ConstantIndex, [In, Out] INT4[]  ParamArray, int  ParamNum);
		public static int  SetPSConstIArray( int  ConstantIndex, [In, Out] INT4[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstIArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetPSConstIArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetPSConstBArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstBArray_x86( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetPSConstBArray", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetPSConstBArray_x64( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum);
		public static int  SetPSConstBArray( int  ConstantIndex, [In, Out] int[]  ParamArray, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetPSConstBArray_x86( ConstantIndex , ParamArray , ParamNum );
			}
			else
			{
				return dx_SetPSConstBArray_x64( ConstantIndex , ParamArray , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetPSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetPSConstF_x86( int  ConstantIndex, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetPSConstF", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetPSConstF_x64( int  ConstantIndex, int  ParamNum);
		public static int  ResetPSConstF( int  ConstantIndex, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetPSConstF_x86( ConstantIndex , ParamNum );
			}
			else
			{
				return dx_ResetPSConstF_x64( ConstantIndex , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetPSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetPSConstI_x86( int  ConstantIndex, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetPSConstI", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetPSConstI_x64( int  ConstantIndex, int  ParamNum);
		public static int  ResetPSConstI( int  ConstantIndex, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetPSConstI_x86( ConstantIndex , ParamNum );
			}
			else
			{
				return dx_ResetPSConstI_x64( ConstantIndex , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_ResetPSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetPSConstB_x86( int  ConstantIndex, int  ParamNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_ResetPSConstB", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_ResetPSConstB_x64( int  ConstantIndex, int  ParamNum);
		public static int  ResetPSConstB( int  ConstantIndex, int  ParamNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_ResetPSConstB_x86( ConstantIndex , ParamNum );
			}
			else
			{
				return dx_ResetPSConstB_x64( ConstantIndex , ParamNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetRenderTargetToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetRenderTargetToShader_x86( int  TargetIndex, int  DrawScreen, int  SurfaceIndex, int  MipLevel);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetRenderTargetToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetRenderTargetToShader_x64( int  TargetIndex, int  DrawScreen, int  SurfaceIndex, int  MipLevel);
		public static int  SetRenderTargetToShader( int  TargetIndex, int  DrawScreen)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetRenderTargetToShader_x86( TargetIndex , DrawScreen , 0 , 0 );
			}
			else
			{
				return dx_SetRenderTargetToShader_x64( TargetIndex , DrawScreen , 0 , 0 );
			}
		}
		public static int  SetRenderTargetToShader( int  TargetIndex, int  DrawScreen, int  SurfaceIndex)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetRenderTargetToShader_x86( TargetIndex , DrawScreen , SurfaceIndex , 0 );
			}
			else
			{
				return dx_SetRenderTargetToShader_x64( TargetIndex , DrawScreen , SurfaceIndex , 0 );
			}
		}
		public static int  SetRenderTargetToShader( int  TargetIndex, int  DrawScreen, int  SurfaceIndex, int  MipLevel)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetRenderTargetToShader_x86( TargetIndex , DrawScreen , SurfaceIndex , MipLevel );
			}
			else
			{
				return dx_SetRenderTargetToShader_x64( TargetIndex , DrawScreen , SurfaceIndex , MipLevel );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseTextureToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTextureToShader_x86( int  StageIndex, int  GraphHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseTextureToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseTextureToShader_x64( int  StageIndex, int  GraphHandle);
		public static int  SetUseTextureToShader( int  StageIndex, int  GraphHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseTextureToShader_x86( StageIndex , GraphHandle );
			}
			else
			{
				return dx_SetUseTextureToShader_x64( StageIndex , GraphHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseVertexShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseVertexShader_x86( int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseVertexShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseVertexShader_x64( int  ShaderHandle);
		public static int  SetUseVertexShader( int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseVertexShader_x86( ShaderHandle );
			}
			else
			{
				return dx_SetUseVertexShader_x64( ShaderHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUseGeometryShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGeometryShader_x86( int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUseGeometryShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUseGeometryShader_x64( int  ShaderHandle);
		public static int  SetUseGeometryShader( int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUseGeometryShader_x86( ShaderHandle );
			}
			else
			{
				return dx_SetUseGeometryShader_x64( ShaderHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_SetUsePixelShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePixelShader_x86( int  ShaderHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_SetUsePixelShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_SetUsePixelShader_x64( int  ShaderHandle);
		public static int  SetUsePixelShader( int  ShaderHandle)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_SetUsePixelShader_x86( ShaderHandle );
			}
			else
			{
				return dx_SetUsePixelShader_x64( ShaderHandle );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CalcPolygonBinormalAndTangentsToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CalcPolygonBinormalAndTangentsToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CalcPolygonBinormalAndTangentsToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CalcPolygonBinormalAndTangentsToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  PolygonNum);
		public static int  CalcPolygonBinormalAndTangentsToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CalcPolygonBinormalAndTangentsToShader_x86( VertexArray , PolygonNum );
			}
			else
			{
				return dx_CalcPolygonBinormalAndTangentsToShader_x64( VertexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CalcPolygonIndexedBinormalAndTangentsToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CalcPolygonIndexedBinormalAndTangentsToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CalcPolygonIndexedBinormalAndTangentsToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CalcPolygonIndexedBinormalAndTangentsToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		public static int  CalcPolygonIndexedBinormalAndTangentsToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CalcPolygonIndexedBinormalAndTangentsToShader_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_CalcPolygonIndexedBinormalAndTangentsToShader_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_CalcPolygon32bitIndexedBinormalAndTangentsToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CalcPolygon32bitIndexedBinormalAndTangentsToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_CalcPolygon32bitIndexedBinormalAndTangentsToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_CalcPolygon32bitIndexedBinormalAndTangentsToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		public static int  CalcPolygon32bitIndexedBinormalAndTangentsToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_CalcPolygon32bitIndexedBinormalAndTangentsToShader_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_CalcPolygon32bitIndexedBinormalAndTangentsToShader_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawBillboard3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBillboard3DToShader_x86( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawBillboard3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawBillboard3DToShader_x64( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag);
		public static int  DrawBillboard3DToShader( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBillboard3DToShader_x86( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
			else
			{
				return dx_DrawBillboard3DToShader_x64( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , FALSE , FALSE );
			}
		}
		public static int  DrawBillboard3DToShader( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBillboard3DToShader_x86( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
			else
			{
				return dx_DrawBillboard3DToShader_x64( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , FALSE );
			}
		}
		public static int  DrawBillboard3DToShader( VECTOR  Pos, float  cx, float  cy, float  Size, float  Angle, int  GrHandle, int  TransFlag, int  ReverseXFlag, int  ReverseYFlag)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawBillboard3DToShader_x86( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
			else
			{
				return dx_DrawBillboard3DToShader_x64( Pos , cx , cy , Size , Angle , GrHandle , TransFlag , ReverseXFlag , ReverseYFlag );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon2DToShader_x86( [In, Out] VERTEX2DSHADER[]  VertexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon2DToShader_x64( [In, Out] VERTEX2DSHADER[]  VertexArray, int  PolygonNum);
		public static int  DrawPolygon2DToShader( [In, Out] VERTEX2DSHADER[]  VertexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon2DToShader_x86( VertexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon2DToShader_x64( VertexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  PolygonNum);
		public static int  DrawPolygon3DToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon3DToShader_x86( VertexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon3DToShader_x64( VertexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed2DToShader_x86( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed2DToShader_x64( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygonIndexed2DToShader( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed2DToShader_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygonIndexed2DToShader_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon32bitIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed2DToShader_x86( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon32bitIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed2DToShader_x64( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygon32bitIndexed2DToShader( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon32bitIndexed2DToShader_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon32bitIndexed2DToShader_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3DToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3DToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygonIndexed3DToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed3DToShader_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygonIndexed3DToShader_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon32bitIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3DToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon32bitIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3DToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygon32bitIndexed3DToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon32bitIndexed3DToShader_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon32bitIndexed3DToShader_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive2DToShader_x86( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive2DToShader_x64( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, int  PrimitiveType);
		public static int  DrawPrimitive2DToShader( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive2DToShader_x86( VertexArray , VertexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive2DToShader_x64( VertexArray , VertexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3DToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3DToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, int  PrimitiveType);
		public static int  DrawPrimitive3DToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive3DToShader_x86( VertexArray , VertexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive3DToShader_x64( VertexArray , VertexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed2DToShader_x86( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed2DToShader_x64( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitiveIndexed2DToShader( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed2DToShader_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitiveIndexed2DToShader_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive32bitIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed2DToShader_x86( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive32bitIndexed2DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed2DToShader_x64( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitive32bitIndexed2DToShader( [In, Out] VERTEX2DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive32bitIndexed2DToShader_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive32bitIndexed2DToShader_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3DToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3DToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitiveIndexed3DToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed3DToShader_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitiveIndexed3DToShader_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive32bitIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed3DToShader_x86( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive32bitIndexed3DToShader", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed3DToShader_x64( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitive32bitIndexed3DToShader( [In, Out] VERTEX3DSHADER[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive32bitIndexed3DToShader_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive32bitIndexed3DToShader_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon2DToShader2_x86( [In, Out] VERTEX2D[]  VertexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon2DToShader2_x64( [In, Out] VERTEX2D[]  VertexArray, int  PolygonNum);
		public static int  DrawPolygon2DToShader2( [In, Out] VERTEX2D[]  VertexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon2DToShader2_x86( VertexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon2DToShader2_x64( VertexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DToShader2_x86( [In, Out] VERTEX3D[]  VertexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DToShader2_x64( [In, Out] VERTEX3D[]  VertexArray, int  PolygonNum);
		public static int  DrawPolygon3DToShader2( [In, Out] VERTEX3D[]  VertexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon3DToShader2_x86( VertexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon3DToShader2_x64( VertexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed2DToShader2_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed2DToShader2_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygonIndexed2DToShader2( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed2DToShader2_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygonIndexed2DToShader2_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon32bitIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed2DToShader2_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon32bitIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed2DToShader2_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygon32bitIndexed2DToShader2( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon32bitIndexed2DToShader2_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon32bitIndexed2DToShader2_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygonIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3DToShader2_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygonIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygonIndexed3DToShader2_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygonIndexed3DToShader2( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygonIndexed3DToShader2_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygonIndexed3DToShader2_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon32bitIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3DToShader2_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon32bitIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon32bitIndexed3DToShader2_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum);
		public static int  DrawPolygon32bitIndexed3DToShader2( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  PolygonNum)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPolygon32bitIndexed3DToShader2_x86( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
			else
			{
				return dx_DrawPolygon32bitIndexed3DToShader2_x64( VertexArray , VertexNum , IndexArray , PolygonNum );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive2DToShader2_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive2DToShader2_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, int  PrimitiveType);
		public static int  DrawPrimitive2DToShader2( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive2DToShader2_x86( VertexArray , VertexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive2DToShader2_x64( VertexArray , VertexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3DToShader2_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive3DToShader2_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, int  PrimitiveType);
		public static int  DrawPrimitive3DToShader2( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive3DToShader2_x86( VertexArray , VertexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive3DToShader2_x64( VertexArray , VertexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed2DToShader2_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed2DToShader2_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitiveIndexed2DToShader2( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed2DToShader2_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitiveIndexed2DToShader2_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive32bitIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed2DToShader2_x86( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive32bitIndexed2DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed2DToShader2_x64( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitive32bitIndexed2DToShader2( [In, Out] VERTEX2D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive32bitIndexed2DToShader2_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive32bitIndexed2DToShader2_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitiveIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3DToShader2_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitiveIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitiveIndexed3DToShader2_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitiveIndexed3DToShader2( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] ushort[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitiveIndexed3DToShader2_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitiveIndexed3DToShader2_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPrimitive32bitIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed3DToShader2_x86( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPrimitive32bitIndexed3DToShader2", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPrimitive32bitIndexed3DToShader2_x64( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType);
		public static int  DrawPrimitive32bitIndexed3DToShader2( [In, Out] VERTEX3D[]  VertexArray, int  VertexNum, [In, Out] uint[]  IndexArray, int  IndexNum, int  PrimitiveType)
		{
			if( System.IntPtr.Size == 4 )
			{
				return dx_DrawPrimitive32bitIndexed3DToShader2_x86( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
			else
			{
				return dx_DrawPrimitive32bitIndexed3DToShader2_x64( VertexArray , VertexNum , IndexArray , IndexNum , PrimitiveType );
			}
		}

		[DllImport("DxLibW.dll", EntryPoint="dx_DrawPolygon3DToShader_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DToShader_UseVertexBuffer_x86( int  VertexBufHandle);
		[DllImport("DxLibW_x64.dll", EntryPoint="dx_DrawPolygon3DToShader_UseVertexBuffer", CallingConvention=CallingConvention.StdCall, CharSet=CharSet.Unicode)]
		extern static int  dx_DrawPolygon3DToShader_UseVertexBuffer_x64( int  VertexBufHandle);
		publi