// -------------------------------------------------------------------------------
// 
// 		cwCu		wb_t@C
// 
// 				Ver 3.25 
// 
// -------------------------------------------------------------------------------

#ifndef DX_LIB_H
#define DX_LIB_H

#include "DxCompileConfig.h"

// cwCũo[W
#define DXLIB_VERSION 0x3250
#define DXLIB_VERSION_STR_T _T( "3.25 " )
#define DXLIB_VERSION_STR_W    L"3.25 "

// `---------------------------------------------------------------------------

// 
#define DX_PI										(3.1415926535897932384626433832795 )
#define DX_PI_F										(3.1415926535897932384626433832795f)
#define DX_TWO_PI									(3.1415926535897932384626433832795  * 2.0 )
#define DX_TWO_PI_F									(3.1415926535897932384626433832795f * 2.0f)

#define DX_CHAR										char

#define DX_DEFINE_START

#define MAX_IMAGE_NUM								(0x40000)			// ɎĂOtBbNnh̍ő吔( nhG[`FbÑ}XNɎgpĂ̂ 0x40000 ȉ 2 ׂ̂ɂĉ )
#define MAX_IMAGE_DIVNUM							(64)				// 摜̍ő吔
#define MAX_SHADOWMAP_NUM							(8192)				// VhE}bvf[^̍ő吔
#define MAX_SOFTIMAGE_NUM							(8192)				// ɎĂ\tgC[Wnh̍ő吔( nhG[`FbÑ}XNɎgpĂ̂ 0x40000 ȉ 2 ׂ̂ɂĉ )

#define MAX_SOUND_NUM								(32768)				// ɎĂTEhnh̍ő吔
#define MAX_SOFTSOUND_NUM							(8192)				// ɎĂ\tgEGATEhnh̍ő吔
#define MAX_MUSIC_NUM								(256)				// ɎĂ~[WbNnh̍ő吔
#define MAX_MOVIE_NUM								(100)				// ɎĂ郀[r[nh̍ő吔
#define MAX_MASK_NUM								(32768)				// ɎĂ}XNnh̍ő吔
#define MAX_FONT_NUM								(256)				// ɎĂtHgnh̍ő吔
#define MAX_INPUT_NUM								(256)				// ɎĂ镶̓nh̍ő吔
#define MAX_SOCKET_NUM								(8192)				// ɎĂʐMnh̍ő吔
#define MAX_LIGHT_NUM								(4096)				// ɎĂ郉Cgnh̍ő吔
#define MAX_SHADER_NUM								(4096)				// ɎĂVF[_[nh̍ő吔
#define MAX_CONSTANT_BUFFER_NUM						(32768)				// ɎĂ萔obt@nh̍ő吔
#define MAX_MODEL_BASE_NUM							(32768)				// ɎĂRcf{f[^nh̍ő吔
#define MAX_MODEL_NUM								(32768)				// ɎĂRcff[^nh̍ő吔
#define MAX_VERTEX_BUFFER_NUM						(16384)				// ɎĂ钸_obt@nh̍ő吔
#define MAX_INDEX_BUFFER_NUM						(16384)				// ɎĂCfbNXobt@̍ő吔
#define MAX_FILE_NUM								(32768)				// ɎĂt@Cnh̍ő吔
#define MAX_LIVE2D_CUBISM4_MODEL_NUM				(32768)				// ɎĂ Live2D Cubism 4 Model nh̍ő吔

// nh^Cv`
#define DX_HANDLETYPE_NONE							(0)					// nh^CvO͖gp
#define DX_HANDLETYPE_GRAPH							(1)					// OtBbNnh
#define DX_HANDLETYPE_SOFTIMAGE						(2)					// \tgEGAňC[Wnh
#define DX_HANDLETYPE_SOUND							(3)					// TEhnh
#define DX_HANDLETYPE_SOFTSOUND						(4)					// \tgTEhnh
#define DX_HANDLETYPE_MUSIC							(5)					// ~[WbNnh
#define DX_HANDLETYPE_MOVIE							(6)					// [r[nh
#define DX_HANDLETYPE_GMASK							(7)					// }XNnh
#define DX_HANDLETYPE_FONT							(8)					// tHgnh
#define DX_HANDLETYPE_KEYINPUT						(9)					// ̓nh
#define DX_HANDLETYPE_NETWORK						(10)				// lbg[Nnh
#define DX_HANDLETYPE_LIGHT							(11)				// Cg
#define DX_HANDLETYPE_SHADER						(12)				// VF[_[nh
#define DX_HANDLETYPE_MODEL_BASE					(13)				// Rcf{f[^
#define DX_HANDLETYPE_MODEL							(14)				// Rcf
#define DX_HANDLETYPE_VERTEX_BUFFER					(15)				// _obt@nh
#define DX_HANDLETYPE_INDEX_BUFFER					(16)				// CfbNXobt@nh
#define DX_HANDLETYPE_FILE							(17)				// t@Cnh
#define DX_HANDLETYPE_SHADOWMAP						(18)				// VhE}bvnh
#define DX_HANDLETYPE_SHADER_CONSTANT_BUFFER		(19)				// VF[_[p萔obt@nh
#define DX_HANDLETYPE_LIVE2D_CUBISM4_MODEL			(20)				// Live2D Cubism 4 fnh

#define MAX_JOYPAD_NUM								(16)				// WCpbh̍ő吔

#define DEFAULT_SCREEN_SIZE_X						(640)				// ftHg̉ʂ̕
#define DEFAULT_SCREEN_SIZE_Y						(480)				// ftHg̉ʂ̍
#define DEFAULT_COLOR_BITDEPTH						(16)				// ftHg̐Frbg[x
#define DEFAULT_ZBUFFER_BITDEPTH					(16)				// ftHĝyobt@rbg[x

#define DEFAULT_FOV									(60.0F * 3.1415926535897932384626433832795F / 180.0F)	// ftHg̎p
#define DEFAULT_TAN_FOV_HALF						(0.57735026918962576450914878050196F) // tan( FOV * 0.5 )
#define DEFAULT_NEAR								(0.0F)				// NEARNbv
#define DEFAULT_FAR									(20000.0F)			// FARNbv

#define DX_DEFAULT_FONT_HANDLE						(-2)				// ftHgtHgl

#define DEFAULT_FONT_SIZE							(16)				// tHg̃ftHg̃TCY
#define DEFAULT_FONT_THICKNESS						(6)					// tHg̃ftHg̑
#define DEFAULT_FONT_TYPE							( DX_FONTTYPE_NORMAL )	// tHg̃ftHǧ`
#define DEFAULT_FONT_EDGESIZE						(1)					// tHg̃ftHg̑

#define MAX_USERIMAGEREAD_FUNCNUM					(10)				// [U[o^łOtBbN[h֐̍ő吔

// vhmcnvr̃o[W}N
#define DX_WINDOWSVERSION_31						(0x000)
#define DX_WINDOWSVERSION_95						(0x001)
#define DX_WINDOWSVERSION_98						(0x002)
#define DX_WINDOWSVERSION_ME						(0x003)
#define DX_WINDOWSVERSION_NT31						(0x104)
#define DX_WINDOWSVERSION_NT40						(0x105)
#define DX_WINDOWSVERSION_2000						(0x106)
#define DX_WINDOWSVERSION_XP						(0x107)
#define DX_WINDOWSVERSION_VISTA						(0x108)
#define DX_WINDOWSVERSION_7							(0x109)
#define DX_WINDOWSVERSION_8							(0x10A)
#define DX_WINDOWSVERSION_8_1						(0x10B)
#define DX_WINDOWSVERSION_10						(0x10C)
#define DX_WINDOWSVERSION_11						(0x10D)
#define DX_WINDOWSVERSION_NT_TYPE					(0x100)

// DirectX̃o[W
#define DX_DIRECTXVERSION_NON						(0)
#define DX_DIRECTXVERSION_1							(0x10000)
#define DX_DIRECTXVERSION_2							(0x20000)
#define DX_DIRECTXVERSION_3							(0x30000)
#define DX_DIRECTXVERSION_4							(0x40000)
#define DX_DIRECTXVERSION_5							(0x50000)
#define DX_DIRECTXVERSION_6							(0x60000)
#define DX_DIRECTXVERSION_6_1						(0x60100)
#define DX_DIRECTXVERSION_7							(0x70000)
#define DX_DIRECTXVERSION_8							(0x80000)
#define DX_DIRECTXVERSION_8_1						(0x80100)

// Direct3D̃o[W
#define DX_DIRECT3D_NONE							(0)
#define DX_DIRECT3D_9								(1)
#define DX_DIRECT3D_9EX								(2)
#define DX_DIRECT3D_11								(3)

// Direct3D11  Feature Level
#define DX_DIRECT3D_11_FEATURE_LEVEL_9_1			(0x9100)
#define DX_DIRECT3D_11_FEATURE_LEVEL_9_2			(0x9200)
#define DX_DIRECT3D_11_FEATURE_LEVEL_9_3			(0x9300)
#define DX_DIRECT3D_11_FEATURE_LEVEL_10_0			(0xa000)
#define DX_DIRECT3D_11_FEATURE_LEVEL_10_1			(0xa100)
#define DX_DIRECT3D_11_FEATURE_LEVEL_11_0			(0xb000)
#define DX_DIRECT3D_11_FEATURE_LEVEL_11_1			(0xb100)

// Zbg
#define DX_CHARSET_DEFAULT							(0)				// ftHgZbg
#define DX_CHARSET_SHFTJIS							(1)				// VtgJIS
#define DX_CHARSET_HANGEUL							(2)				// nOZbg
#define DX_CHARSET_BIG5								(3)				// ɑ̕Zbg
#define DX_CHARSET_GB2312							(4)				// ȑ̕Zbg
#define DX_CHARSET_WINDOWS_1252						(5)				// (e̕R[h)
#define DX_CHARSET_ISO_IEC_8859_15					(6)				// (e̕R[h)
#define DX_CHARSET_UTF8								(7)				// UTF-8
#define DX_CHARSET_NUM								(8)				// Zbg̐

// R[h`
#define DX_CHARCODEFORMAT_SHIFTJIS					(932)			// VtgJISR[h
#define DX_CHARCODEFORMAT_GB2312					(936)			// ȑ̎R[h
#define DX_CHARCODEFORMAT_UHC						(949)			// nOR[h
#define DX_CHARCODEFORMAT_BIG5						(950)			// ɑ̕R[h
#define DX_CHARCODEFORMAT_UTF16LE					(1200)			// UTF-16 gGfBA
#define DX_CHARCODEFORMAT_UTF16BE					(1201)			// UTF-16 rbOGfBA
#define DX_CHARCODEFORMAT_WINDOWS_1252				(1252)			// (e̕R[h)
#define DX_CHARCODEFORMAT_ISO_IEC_8859_15			(32764)			// (e̕R[h)
#define DX_CHARCODEFORMAT_UTF8						(65001)			// UTF-8
#define DX_CHARCODEFORMAT_ASCII						(32765)			// AXL[R[h
#define DX_CHARCODEFORMAT_UTF32LE					(32766)			// UTF-32 gGfBA
#define DX_CHARCODEFORMAT_UTF32BE					(32767)			// UTF-32 rbOGfBA

// lhch̉t[h`
#define DX_MIDIMODE_MCI								(0)				// lbhɂ鉉t
#define DX_MIDIMODE_DM								(1)				// clɂ鉉t
#define DX_MIDIMODE_DIRECT_MUSIC_REVERB				(1)				// cl(o[u)ɂ鉉t
#define DX_MIDIMODE_DIRECT_MUSIC_NORMAL				(2)				// cl(o[uȂ)ɂ鉉t
#define DX_MIDIMODE_NUM								(3)				// lhch̉t[h̐

// `惂[h`
#define DX_DRAWMODE_NEAREST							(0)				// lAXglCo[@ŕ`
#define DX_DRAWMODE_BILINEAR						(1)				// oCjA@ŕ`悷
#define DX_DRAWMODE_ANISOTROPIC						(2)				// ٕtB^O@ŕ`悷
#define DX_DRAWMODE_OTHER							(3)				// ȊO
#define DX_DRAWMODE_NUM								(4)				// `惂[h̐

// tHg̃^Cv
#define DX_FONTTYPE_NORMAL							(0x00)			// m[}tHg
#define DX_FONTTYPE_EDGE							(0x01)			// GbWtHg
#define DX_FONTTYPE_ANTIALIASING					(0x02)			// A`GCAXtHg( W@\A`GCAX )
#define DX_FONTTYPE_ANTIALIASING_4X4				(0x12)			// A`GCAXtHg( 4x4TvO )
#define DX_FONTTYPE_ANTIALIASING_8X8				(0x22)			// A`GCAXtHg( 8x8TvO )
#define DX_FONTTYPE_ANTIALIASING_16X16				(0x32)			// A`GCAXtHg( 16x16TvO )
#define DX_FONTTYPE_ANTIALIASING_EDGE				(0x03)			// A`GCAXGbWttHg( W@\A`GCAX )
#define DX_FONTTYPE_ANTIALIASING_EDGE_4X4			(0x13)			// A`GCAXGbWttHg( 4x4TvO )
#define DX_FONTTYPE_ANTIALIASING_EDGE_8X8			(0x23)			// A`GCAXGbWttHg( 8x8TvO )
#define DX_FONTTYPE_ANTIALIASING_EDGE_16X16			(0x33)			// A`GCAXGbWttHg( 16x16TvO )

// tHg摜̊Krbg
#define DX_FONTIMAGE_BIT_1							(0)
#define DX_FONTIMAGE_BIT_4							(1)
#define DX_FONTIMAGE_BIT_8							(2)

// `uh[h`
#define DX_BLENDMODE_NOBLEND						(0)				// m[uh
#define DX_BLENDMODE_ALPHA							(1)				// uh
#define DX_BLENDMODE_ADD							(2)				// Zuh
#define DX_BLENDMODE_SUB							(3)				// Zuh
#define DX_BLENDMODE_MUL							(4)				// Zuh
   // (p)
#define DX_BLENDMODE_SUB2							(5)				// pZuhQ
//#define DX_BLENDMODE_BLINEALPHA					(7)				// Eڂ
#define DX_BLENDMODE_XOR							(6)				// XORuh( \tgEGA_O[hł̂ݗL )
#define DX_BLENDMODE_DESTCOLOR						(8)				// J[͍XVȂ
#define DX_BLENDMODE_INVDESTCOLOR					(9)				// `̐F̔]l|
#define DX_BLENDMODE_INVSRC							(10)			// `挳̐F𔽓]
#define DX_BLENDMODE_MULA							(11)			// At@`lltZuh
#define DX_BLENDMODE_ALPHA_X4						(12)			// uh̕`挳̋PxőS{ɂł郂[h
#define DX_BLENDMODE_ADD_X4							(13)			// Zuh̕`挳̋PxőS{ɂł郂[h
#define DX_BLENDMODE_SRCCOLOR						(14)			// `挳̃J[ł̂܂ܕ`悳
#define DX_BLENDMODE_HALF_ADD						(15)			// Zuh
#define DX_BLENDMODE_SUB1							(16)			// pZuhP
#define DX_BLENDMODE_PMA_ALPHA						(17)			// Zς݃uh[h̃uh
#define DX_BLENDMODE_PMA_ADD						(18)			// Zς݃uh[h̉Zuh
#define DX_BLENDMODE_PMA_SUB						(19)			// Zς݃uh[ȟZuh
#define DX_BLENDMODE_PMA_INVSRC						(20)			// Zς݃uh[h̕`挳̐F𔽓]
#define DX_BLENDMODE_PMA_ALPHA_X4					(21)			// Zς݃uh[h̃uh̕`挳̋PxőS{ɂł郂[h
#define DX_BLENDMODE_PMA_ADD_X4						(22)			// Zς݃uh[h̉Zuh̕`挳̋PxőS{ɂł郂[h
#define DX_BLENDMODE_LIVE2D_ZERO					(23)			// Live2D ̃uh[h Zero p
#define DX_BLENDMODE_LIVE2D_NORMAL					(24)			// Live2D ̃uh[h Normal p
#define DX_BLENDMODE_LIVE2D_ADD						(25)			// Live2D ̃uh[h Add p
#define DX_BLENDMODE_LIVE2D_MULT					(26)			// Live2D ̃uh[h Mult p
#define DX_BLENDMODE_LIVE2D_MASK					(27)			// Live2D ̃uh[h Mask p
#define DX_BLENDMODE_SPINE_NORMAL					(28)			// Spine ̃uh[h Normal p
#define DX_BLENDMODE_SPINE_ADDITIVE					(29)			// Spine ̃uh[h Additive p
#define DX_BLENDMODE_SPINE_MULTIPLY					(30)			// Spine ̃uh[h Multiply p
#define DX_BLENDMODE_SPINE_SCREEN					(31)			// Spine ̃uh[h Screen p
#define DX_BLENDMODE_CUSTOM							(32)			// JX^uh[h
#define DX_BLENDMODE_DST_RGB_SRC_A					(33)			// `挳 A ݂̂( ` RGB ͕ύXȂ )
#define DX_BLENDMODE_INVDESTCOLOR_A					(34)			// ` A ̔]l|( ` RGB ͕ύXȂ )
#define DX_BLENDMODE_MUL_A							(35)			// A ݂̂̏Zuh( ` RGB ͕ύXȂ )
#define DX_BLENDMODE_PMA_INVDESTCOLOR_A				(36)			// Zς݃p DX_BLENDMODE_INVDESTCOLOR_A
#define DX_BLENDMODE_PMA_MUL_A						(37)			// Zς݃p DX_BLENDMODE_MUL_A
#define DX_BLENDMODE_NUM							(38)			// uh[h̐

// JX^uh[hp̃uhvf^Cv
// Rs = `挳R   Rg = `挳G   Rb = `挳B   Ra = `挳A
// Rd = `R   Rd = `G   Rd = `B   Rd = `A
#define DX_BLEND_ZERO								(0)				// R = 0         G = 0         B = 0         A = 0
#define DX_BLEND_ONE								(1)				// R = 255       G = 255       B = 255       A = 255
#define DX_BLEND_SRC_COLOR							(2)				// R = Rs        G = Gs        B = Gs        A = As
#define DX_BLEND_INV_SRC_COLOR						(3)				// R = 255 - Rs  G = 255 - Gs  B = 255 - Gs  A = 255 - As
#define DX_BLEND_SRC_ALPHA							(4)				// R = As        G = As        B = As        A = As
#define DX_BLEND_INV_SRC_ALPHA						(5)				// R = 255 - As  G = 255 - As  B = 255 - As  A = 255 - As
#define DX_BLEND_DEST_COLOR							(6)				// R = Rd        G = Gd        B = Bd        A = Ad
#define DX_BLEND_INV_DEST_COLOR						(7)				// R = 255 - Rd  G = 255 - Gd  B = 255 - Bd  A = 255 - Ad
#define DX_BLEND_DEST_ALPHA							(8)				// R = Ad        G = Ad        B = Ad        A = Ad
#define DX_BLEND_INV_DEST_ALPHA						(9)				// R = 255 - Ad  G = 255 - Ad  B = 255 - Ad  A = 255 - Ad
#define DX_BLEND_SRC_ALPHA_SAT						(10)			// R = f         G = f         B = f         A = 255        f = min( As, 255 - Ad )
#define DX_BLEND_NUM								(11)			// uhvf^Cv̐

// JX^uh[hp̃uh^Cv
#define DX_BLENDOP_ADD								(0)				// uh\[X1ƃuh\[X2Z
#define DX_BLENDOP_SUBTRACT							(1)				// uh\[X1uh\[X2Z
#define DX_BLENDOP_REV_SUBTRACT						(2)				// uh\[X2uh\[X2Z
#define DX_BLENDOP_MIX								(3)				// uh\[X1ƃuh\[X2̍ŏl
#define DX_BLENDOP_MAX								(4)				// uh\[X1ƃuh\[X2̍ől
#define DX_BLENDOP_NUM								(5)				// uh^Cv̐

// DrawGraphF ̕_lōWw肷֐ɂW^Cv
#define DX_DRAWFLOATCOORDTYPE_DIRECT3D9				(0)				// Direct3D9^Cv( -0.5f ̕␳sȂƃeNX`̃sNZYɃ}bvȂ^Cv )
#define DX_DRAWFLOATCOORDTYPE_DIRECT3D10			(1)				// Direct3D10^Cv( -0.5f ̕␳sȂȂĂeNX`̃sNZYɃ}bv^Cv )

// 摜^Cv
#define DX_BLENDGRAPHTYPE_NORMAL					(0)				// ʏ퍇
#define DX_BLENDGRAPHTYPE_WIPE						(1)				// Cv
#define DX_BLENDGRAPHTYPE_ALPHA						(2)				// uh摜̃lƌ摜̃l|킹
#define DX_BLENDGRAPHTYPE_NUM						(3)

// 摜W^Cv
#define DX_BLENDGRAPH_POSMODE_DRAWGRAPH				(0)				// `悷摜ō摜̍W
#define DX_BLENDGRAPH_POSMODE_SCREEN				(1)				// XN[Wō摜̍W
#define DX_BLENDGRAPH_POSMODE_NUM					(2)

// OtBbNtB^[^Cv
#define DX_GRAPH_FILTER_MONO						(0)				// mg[tB^
#define DX_GRAPH_FILTER_GAUSS						(1)				// KEXtB^
#define DX_GRAPH_FILTER_DOWN_SCALE					(2)				// ktB^
#define DX_GRAPH_FILTER_BRIGHT_CLIP					(3)				// 邳NbvtB^
#define DX_GRAPH_FILTER_BRIGHT_SCALE				(4)				// w̖邳̈g傷tB^
#define DX_GRAPH_FILTER_HSB							(5)				// FEʓxExtB^
#define DX_GRAPH_FILTER_INVERT						(6)				// K̔]tB^
#define DX_GRAPH_FILTER_LEVEL						(7)				// x␳tB^
#define DX_GRAPH_FILTER_TWO_COLOR					(8)				// QKtB^
#define DX_GRAPH_FILTER_GRADIENT_MAP				(9)				// Of[V}bvtB^
#define DX_GRAPH_FILTER_REPLACEMENT					(10)			// F̒u
#define DX_GRAPH_FILTER_BILATERAL_BLUR				(11)			// oCeu[
#define DX_GRAPH_FILTER_PREMUL_ALPHA				(12)			// ʏ̃At@`lt摜Zς݃At@摜ɕϊtB^
#define DX_GRAPH_FILTER_INTERP_ALPHA				(13)			// Zς݃摜ʏ̃At@`lt摜ɕϊtB^
#define DX_GRAPH_FILTER_YUV_TO_RGB					(14)			// YUVJ[RGBJ[ɕϊtB^
#define DX_GRAPH_FILTER_Y2UV1_TO_RGB				(15)			// YUVJ[RGBJ[ɕϊtB^( UV Y̔E͂ŜP( EcЕႵ͗ )̉𑜓xȂꍇp )
#define DX_GRAPH_FILTER_YUV_TO_RGB_RRA				(16)			// YUVJ[RGBJ[ɕϊtB^( ER̒lAt@lƂĈ )
#define DX_GRAPH_FILTER_Y2UV1_TO_RGB_RRA			(17)			// YUVJ[RGBJ[ɕϊtB^( UV Y̔E͂ŜP( EcЕႵ͗ )̉𑜓xȂꍇp )( ER̒lAt@lƂĈ )
#define DX_GRAPH_FILTER_BICUBIC_SCALE				(18)			// oCL[rbNgpgEktB^
#define DX_GRAPH_FILTER_LANCZOS3_SCALE				(19)			// Lanczos-3gpgEktB^
#define DX_GRAPH_FILTER_SSAO						(20)			// Screen-Space Ambient OcclusiontB^
#define DX_GRAPH_FILTER_FLOAT_COLOR_SCALE			(21)			// float^̐F̃XP[O
#define DX_GRAPH_FILTER_PMA_BRIGHT_CLIP				(22)			// 邳NbvtB^(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_BRIGHT_SCALE			(23)			// w̖邳̈g傷tB^(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_HSB						(24)			// FEʓxExtB^(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_INVERT					(25)			// K̔]tB^(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_LEVEL					(26)			// x␳tB^(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_TWO_COLOR				(27)			// QKtB^(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_GRADIENT_MAP			(28)			// Of[V}bvtB^(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_REPLACEMENT				(29)			// F̒u(Zς݃At@摜p)
#define DX_GRAPH_FILTER_PMA_BILATERAL_BLUR			(30)			// oCeu[(Zς݃At@摜p)
#define DX_GRAPH_FILTER_NUM							(31)

// OtBbNuh^Cv
#define DX_GRAPH_BLEND_NORMAL						(0)				// ʏ
#define DX_GRAPH_BLEND_RGBA_SELECT_MIX				(1)				// RGBA̗vfIč
#define DX_GRAPH_BLEND_MULTIPLE						(2)				// Z
#define DX_GRAPH_BLEND_DIFFERENCE					(3)				// Z
#define DX_GRAPH_BLEND_ADD							(4)				// Z
#define DX_GRAPH_BLEND_SCREEN						(5)				// XN[
#define DX_GRAPH_BLEND_OVERLAY						(6)				// I[o[C
#define DX_GRAPH_BLEND_DODGE						(7)				// Ă
#define DX_GRAPH_BLEND_BURN							(8)				// Ă
#define DX_GRAPH_BLEND_DARKEN						(9)				// r()
#define DX_GRAPH_BLEND_LIGHTEN						(10)			// r()
#define DX_GRAPH_BLEND_SOFTLIGHT					(11)			// \tgCg
#define DX_GRAPH_BLEND_HARDLIGHT					(12)			// n[hCg
#define DX_GRAPH_BLEND_EXCLUSION					(13)			// O
#define DX_GRAPH_BLEND_NORMAL_ALPHACH				(14)			// `lt摜̒ʏ퍇
#define DX_GRAPH_BLEND_ADD_ALPHACH					(15)			// `lt摜̉Z
#define DX_GRAPH_BLEND_MULTIPLE_A_ONLY				(16)			// At@`l݂̂̏Z
#define DX_GRAPH_BLEND_PMA_NORMAL					(17)			// ʏ( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_RGBA_SELECT_MIX			(18)			// RGBA̗vfIč( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_MULTIPLE					(19)			// Z( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_DIFFERENCE				(20)			// Z( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_ADD						(21)			// Z( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_SCREEN					(22)			// XN[( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_OVERLAY					(23)			// I[o[C( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_DODGE					(24)			// Ă( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_BURN						(25)			// Ă( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_DARKEN					(26)			// r()( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_LIGHTEN					(27)			// r()( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_SOFTLIGHT				(28)			// \tgCg( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_HARDLIGHT				(29)			// n[hCg( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_EXCLUSION				(30)			// O( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_NORMAL_ALPHACH			(31)			// `lt摜̒ʏ퍇( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_ADD_ALPHACH				(32)			// `lt摜̉Z( Zς݃摜p )
#define DX_GRAPH_BLEND_PMA_MULTIPLE_A_ONLY			(33)			// At@`l݂̂̏Z( Zς݃摜p )
#define DX_GRAPH_BLEND_MASK							(34)			// }XN( SrcGrHandle  BlendGrHandle ʏ`悵ŁASrcGrHandle  A D )
#define DX_GRAPH_BLEND_PMA_MASK						(35)			// }XN( DX_GRAPH_BLEND_MASK ̏Zς݃摜p )
#define DX_GRAPH_BLEND_NUM							(36)

// DX_GRAPH_BLEND_RGBA_SELECT_MIX p̐FIp`
#define DX_RGBA_SELECT_SRC_R						(0)				// 摜̐Ԑ
#define DX_RGBA_SELECT_SRC_G						(1)				// 摜̗ΐ
#define DX_RGBA_SELECT_SRC_B						(2)				// 摜̐
#define DX_RGBA_SELECT_SRC_A						(3)				// 摜̃
#define DX_RGBA_SELECT_BLEND_R						(4)				// uh摜̐Ԑ
#define DX_RGBA_SELECT_BLEND_G						(5)				// uh摜̗ΐ
#define DX_RGBA_SELECT_BLEND_B						(6)				// uh摜̐
#define DX_RGBA_SELECT_BLEND_A						(7)				// uh摜̃
#define DX_RGBA_SELECT_SRC_INV_R					(8)				// 摜̐Ԑ𔽓]
#define DX_RGBA_SELECT_SRC_INV_G					(9)				// 摜̗ΐ𔽓]
#define DX_RGBA_SELECT_SRC_INV_B					(10)			// 摜̐𔽓]
#define DX_RGBA_SELECT_SRC_INV_A					(11)			// 摜̃𔽓]
#define DX_RGBA_SELECT_BLEND_INV_R					(12)			// uh摜̐Ԑ𔽓]
#define DX_RGBA_SELECT_BLEND_INV_G					(13)			// uh摜̗ΐ𔽓]
#define DX_RGBA_SELECT_BLEND_INV_B					(14)			// uh摜̐𔽓]
#define DX_RGBA_SELECT_BLEND_INV_A					(15)			// uh摜̃𔽓]

// tB[h
#define DX_FILL_WIREFRAME							(2)				// C[t[
#define DX_FILL_SOLID								(3)				// |S

// |SJO[h
#define DX_CULLING_NONE								(0)				// JOȂ
#define DX_CULLING_LEFT								(1)				// wʂŃJO
#define DX_CULLING_RIGHT							(2)				// wʂEŃJO
#define DX_CULLING_NUM								(3)				// JO[h̐

// NbsO
#define DX_CAMERACLIP_LEFT							(0x01)			// ʍɃNbv
#define DX_CAMERACLIP_RIGHT							(0x02)			// ʉEɃNbv
#define DX_CAMERACLIP_BOTTOM						(0x04)			// ʉɃNbv
#define DX_CAMERACLIP_TOP							(0x08)			// ʏɃNbv
#define DX_CAMERACLIP_BACK							(0x10)			// ʌɃNbv
#define DX_CAMERACLIP_FRONT							(0x20)			// ʑOɃNbv

// MV1f̕`惂[h
#define DX_MV1_DRAWMODE_NORMAL						(0)				// ʏ`
#define DX_MV1_DRAWMODE_NORMAL_DEPTH				(1)				// @Ɛ[x`

// MV1f̒_^Cv
#define DX_MV1_VERTEX_TYPE_1FRAME					(0)				// Pt[̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_4FRAME					(1)				// P`St[̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_8FRAME					(2)				// T`Wt[̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_FREE_FRAME				(3)				// Xt[ȏ̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_NMAP_1FRAME				(4)				// @}bvp̏񂪊܂܂Pt[̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_NMAP_4FRAME				(5)				// @}bvp̏񂪊܂܂P`St[̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_NMAP_8FRAME				(6)				// @}bvp̏񂪊܂܂T`Wt[̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_NMAP_FREE_FRAME			(7)				// @}bvp̏񂪊܂܂Xt[ȏ̉e󂯂钸_
#define DX_MV1_VERTEX_TYPE_NUM						(8)				// _^Cv̐

// bV̎
#define DX_MV1_MESHCATEGORY_NORMAL					(0)				// ʂ̃bV
#define DX_MV1_MESHCATEGORY_OUTLINE					(1)				// ֊s`pbV
#define DX_MV1_MESHCATEGORY_OUTLINE_ORIG_SHADER		(2)				// ֊s`pbV( IWiVF[_[ł̕`p )
#define DX_MV1_MESHCATEGORY_NUM						(3)				// bV̎ނ̐

// VFCv̓Kp^Cv
#define DX_MV1_SHAPERATE_ADD						(0)				// ̒lɉZ
#define DX_MV1_SHAPERATE_OVERWRITE					(1)				// ̒lɏ㏑

// MV1t@C̕ۑ^Cv
#define MV1_SAVETYPE_MESH							(0x0001)		// bV̂ݕۑ
#define MV1_SAVETYPE_ANIM							(0x0002)		// Aj[V̂ݕۑ
#define MV1_SAVETYPE_NORMAL							( MV1_SAVETYPE_MESH | MV1_SAVETYPE_ANIM )	// ʏۑ

// Aj[VL[f[^^Cv
#define MV1_ANIMKEY_DATATYPE_ROTATE					(0)				// ]
#define MV1_ANIMKEY_DATATYPE_ROTATE_X				(1)				// ]w
#define MV1_ANIMKEY_DATATYPE_ROTATE_Y				(2)				// ]x
#define MV1_ANIMKEY_DATATYPE_ROTATE_Z				(3)				// ]y
#define MV1_ANIMKEY_DATATYPE_SCALE					(5)				// g
#define MV1_ANIMKEY_DATATYPE_SCALE_X				(6)				// XP[w
#define MV1_ANIMKEY_DATATYPE_SCALE_Y				(7)				// XP[x
#define MV1_ANIMKEY_DATATYPE_SCALE_Z				(8)				// XP[y
#define MV1_ANIMKEY_DATATYPE_TRANSLATE				(10)			// sړ
#define MV1_ANIMKEY_DATATYPE_TRANSLATE_X			(11)			// sړw
#define MV1_ANIMKEY_DATATYPE_TRANSLATE_Y			(12)			// sړx
#define MV1_ANIMKEY_DATATYPE_TRANSLATE_Z			(13)			// sړy
#define MV1_ANIMKEY_DATATYPE_MATRIX4X4C				(15)			// S~SŝS( 0,0,0,1 )Œ
#define MV1_ANIMKEY_DATATYPE_MATRIX3X3				(17)			// R~Rs
#define MV1_ANIMKEY_DATATYPE_SHAPE					(18)			// VFCv
#define MV1_ANIMKEY_DATATYPE_OTHRE					(20)			// ̑

// ^C^Cv
#define MV1_ANIMKEY_TIME_TYPE_ONE					(0)				// ԏ͑Ŝň
#define MV1_ANIMKEY_TIME_TYPE_KEY					(1)				// ԏ͊eL[Ɉ

// Aj[VL[^Cv
#define MV1_ANIMKEY_TYPE_QUATERNION_X				(0)				// NH[^jI( Xt@C^Cv )
#define MV1_ANIMKEY_TYPE_VECTOR						(1)				// xN^[
#define MV1_ANIMKEY_TYPE_MATRIX4X4C					(2)				// S~SŝS( 0,0,0,1 )Œ
#define MV1_ANIMKEY_TYPE_MATRIX3X3					(3)				// R~Rs
#define MV1_ANIMKEY_TYPE_FLAT						(4)				// tbg
#define MV1_ANIMKEY_TYPE_LINEAR						(5)				// `
#define MV1_ANIMKEY_TYPE_BLEND						(6)				// 
#define MV1_ANIMKEY_TYPE_QUATERNION_VMD				(7)				// NH[^jI( VMD^Cv )

// `ʎwp`
#define DX_SCREEN_FRONT								(0xfffffffc)
#define DX_SCREEN_BACK								(0xfffffffe) 
#define DX_SCREEN_WORK 								(0xfffffffd)
#define DX_SCREEN_TEMPFRONT							(0xfffffff0)
#define DX_SCREEN_OTHER								(0xfffffffa)

#define DX_NONE_GRAPH								(0xfffffffb)	// OtBbNȂnh

// OtBbNF̉摜򉻊ɘa[h
#define DX_SHAVEDMODE_NONE							(0)				// 摜򉻊ɘasȂ
#define DX_SHAVEDMODE_DITHER						(1)				// fBUO
#define DX_SHAVEDMODE_DIFFUS						(2)				// 덷gU

// 摜̕ۑ^Cv
#define DX_IMAGESAVETYPE_BMP						(0)				// bitmap
#define DX_IMAGESAVETYPE_JPEG						(1)				// jpeg
#define DX_IMAGESAVETYPE_PNG						(2)				// Png
#define DX_IMAGESAVETYPE_DDS						(3)				// Direct Draw Surface

// TEhĐ`Ԏwp`
#define DX_PLAYTYPE_LOOPBIT							(0x0002)		// [vĐrbg
#define DX_PLAYTYPE_BACKBIT							(0x0001)		// obNOEhĐrbg

#define DX_PLAYTYPE_NORMAL							(0)												// m[}Đ
#define DX_PLAYTYPE_BACK				  			( DX_PLAYTYPE_BACKBIT )							// obNOEhĐ
#define DX_PLAYTYPE_LOOP							( DX_PLAYTYPE_LOOPBIT | DX_PLAYTYPE_BACKBIT )	// [vĐ

// Đ^Cv`
#define DX_MOVIEPLAYTYPE_BCANCEL					(0)				// {^LZ
#define DX_MOVIEPLAYTYPE_NORMAL						(1)				// {^LZȂ

// TEh̃^Cv
#define DX_SOUNDTYPE_NORMAL							(0)				// m[}TEh`
#define DX_SOUNDTYPE_STREAMSTYLE					(1)				// Xg[TEh`

// TEhf[^^Cṽ}N
#define DX_SOUNDDATATYPE_MEMNOPRESS					(0)				// kꂽSf[^͍Đn܂OɃTEhɂׂĉ𓀂Ai[
#define DX_SOUNDDATATYPE_MEMNOPRESS_PLUS			(1)				// kꂽSf[^̓VXeɊi[AĐȂ璀𓀂AŏIIɂׂăTEhɊi[(̌VXeɑ݂鈳kf[^͔j)
#define DX_SOUNDDATATYPE_MEMPRESS					(2)				// kꂽSf[^̓VXeɊi[AĐ镔𓀂ȂTEhɊi[(炵IƉ𓀂f[^͔ĵŉx𓀏s)
#define DX_SOUNDDATATYPE_FILE						(3)				// kꂽf[^̍Đ镔t@C璀ǂݍ݉𓀂ATEhɊi[(炵IƉ𓀂f[^͔ĵŉx𓀏s)

// TEh̎擾Đԃ^Cv
#define DX_SOUNDCURRENTTIME_TYPE_LOW_LEVEL			(0)				// ჌xAPIgpĂ萳mȍĐԂ擾
#define DX_SOUNDCURRENTTIME_TYPE_SOFT				(1)				// API͎gpA\tgEFAxł̍ĐԂ擾

// ǂݍݏ̃^Cv
#define DX_READSOUNDFUNCTION_PCM					(1 << 0)		// PCM ̓ǂݍݏ
#define DX_READSOUNDFUNCTION_OGG					(1 << 1)		// Ogg Vorbis ̓ǂݍݏ
#define DX_READSOUNDFUNCTION_OPUS					(1 << 2)		// Opus ̓ǂݍݏ
#define DX_READSOUNDFUNCTION_DEFAULT_NUM			(3)				// ˑ̓ǂݍݏ^Cv̐

// RcTEho[uGtFNg̃vZbg
#define DX_REVERB_PRESET_DEFAULT					(0)				// ftHg
#define DX_REVERB_PRESET_GENERIC					(1)				// ʓIȋ
#define DX_REVERB_PRESET_PADDEDCELL					(2)				// _aҎ(H)
#define DX_REVERB_PRESET_ROOM						(3)				// 
#define DX_REVERB_PRESET_BATHROOM					(4)				// oX[
#define DX_REVERB_PRESET_LIVINGROOM					(5)				// rO[
#define DX_REVERB_PRESET_STONEROOM					(6)				// ΂̕
#define DX_REVERB_PRESET_AUDITORIUM					(7)				// u
#define DX_REVERB_PRESET_CONCERTHALL				(8)				// RT[gz[
#define DX_REVERB_PRESET_CAVE						(9)				// 
#define DX_REVERB_PRESET_ARENA						(10)			// 
#define DX_REVERB_PRESET_HANGAR						(11)			// i[
#define DX_REVERB_PRESET_CARPETEDHALLWAY			(12)			// J[ybg~ꂽ
#define DX_REVERB_PRESET_HALLWAY					(13)			// 
#define DX_REVERB_PRESET_STONECORRIDOR				(14)			// ΂̘L
#define DX_REVERB_PRESET_ALLEY						(15)			// ʂ
#define DX_REVERB_PRESET_FOREST						(16)			// X
#define DX_REVERB_PRESET_CITY						(17)			// ss
#define DX_REVERB_PRESET_MOUNTAINS					(18)			// R
#define DX_REVERB_PRESET_QUARRY						(19)			// ̐Ώ
#define DX_REVERB_PRESET_PLAIN						(20)			// 
#define DX_REVERB_PRESET_PARKINGLOT					(21)			// ԏ
#define DX_REVERB_PRESET_SEWERPIPE					(22)			// 
#define DX_REVERB_PRESET_UNDERWATER					(23)			// ʉ
#define DX_REVERB_PRESET_SMALLROOM					(24)			// 
#define DX_REVERB_PRESET_MEDIUMROOM					(25)			// 
#define DX_REVERB_PRESET_LARGEROOM					(26)			// 啔
#define DX_REVERB_PRESET_MEDIUMHALL					(27)			// z[
#define DX_REVERB_PRESET_LARGEHALL					(28)			// z[
#define DX_REVERB_PRESET_PLATE						(29)			// 

#define DX_REVERB_PRESET_NUM						(30)			// vZbg̐

// }XNߐF[h
#define DX_MASKTRANS_WHITE							(0)				// }XN摜̔𓧉ߐFƂ
#define DX_MASKTRANS_BLACK							(1)				// }XN摜̍𓧉ߐFƂ
#define DX_MASKTRANS_NONE							(2) 			// ߐFȂ

// }XN摜`l
#define DX_MASKGRAPH_CH_A							(0)				// At@
#define DX_MASKGRAPH_CH_R							(1)				// 
#define DX_MASKGRAPH_CH_G							(2)				// 
#define DX_MASKGRAPH_CH_B							(3)				// 

// yobt@݃[h
#define DX_ZWRITE_MASK								(0)				// ߂Ȃ悤Ƀ}XN
#define DX_ZWRITE_CLEAR								(1)				// ߂悤Ƀ}XNNA

// r[h
#define DX_CMP_NEVER								(1)				// FALSE
#define DX_CMP_LESS									(2)				// Src <  Dest		DrawAlpha <  TestParam
#define DX_CMP_EQUAL								(3)				// Src == Dest		DrawAlpha == TestParam
#define DX_CMP_LESSEQUAL							(4)				// Src <= Dest		DrawAlpha <= TestParam
#define DX_CMP_GREATER								(5)				// Src >  Dest		DrawAlpha >  TestParam
#define DX_CMP_NOTEQUAL								(6)				// Src != Dest		DrawAlpha != TestParam
#define DX_CMP_GREATEREQUAL							(7)				// Src >= Dest		DrawAlpha >= TestParam
#define DX_CMP_ALWAYS								(8)				// TRUE
#define DX_ZCMP_DEFAULT								( DX_CMP_LESSEQUAL )
#define DX_ZCMP_REVERSE								( DX_CMP_GREATEREQUAL )

// VF[fBO[h
#define DX_SHADEMODE_FLAT							(1)				// D_D3DSHADE_FLAT
#define DX_SHADEMODE_GOURAUD						(2)				// D_D3DSHADE_GOURAUD

// tHO[h
#define DX_FOGMODE_NONE								(0)				// D_D3DFOG_NONE
#define DX_FOGMODE_EXP								(1)				// D_D3DFOG_EXP
#define DX_FOGMODE_EXP2								(2)				// D_D3DFOG_EXP2
#define DX_FOGMODE_LINEAR							(3)				// D_D3DFOG_LINEAR

// }eA^Cv
#define DX_MATERIAL_TYPE_NORMAL									(0)	// W}eA
#define DX_MATERIAL_TYPE_TOON									(1)	// gD[_Op}eA
#define DX_MATERIAL_TYPE_TOON_2									(2)	// gD[_Op}eA_^CvQ( MMD݊ )
#define DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_UNORM				(3)	// }eÃXyLF̋Px̎w͈̔͂̒l 0.0f ` 1.0f ̒lɐKďރ}eA
#define DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_CLIP_UNORM			(4)	// DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_UNORM Ɂww̒l̏ꍇ͏ޒl 0.0f ɂxƂ}eA
#define DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_CMP_GREATEREQUAL	(5)	// }eÃXyLF̋Pxw臒lȏ ̏ꍇ 1.0f Ȁꍇ 0.0f ރ}eA
#define DX_MATERIAL_TYPE_MAT_SPEC_POWER_UNORM					(6)	// }eÃXyLnCCg̑Nx̎w͈̔͂̒l 0.0f ` 1.0f ̒lɐKďރ}eA
#define DX_MATERIAL_TYPE_MAT_SPEC_POWER_CLIP_UNORM				(7)	// DX_MATERIAL_TYPE_MAT_SPEC_POWER_UNORM Ɂww̒l̏ꍇ͏ޒl 0.0f ɂxƂ}eA
#define DX_MATERIAL_TYPE_MAT_SPEC_POWER_CMP_GREATEREQUAL		(8)	// }eÃXyLnCCg̑Nxw臒lȏ ̏ꍇ 1.0f Ȁꍇ 0.0f ރ}eA
#define DX_MATERIAL_TYPE_NUM									(9)

// }eAuh^Cv
#define DX_MATERIAL_BLENDTYPE_TRANSLUCENT			(0)				// At@
#define DX_MATERIAL_BLENDTYPE_ADDITIVE				(1)				// Z
#define DX_MATERIAL_BLENDTYPE_MODULATE				(2)				// Z
#define DX_MATERIAL_BLENDTYPE_NONE					(3)				// 

// eNX`AhX^Cv
#define DX_TEXADDRESS_WRAP							(1)				// D_D3DTADDRESS_WRAP
#define DX_TEXADDRESS_MIRROR						(2)				// D_D3DTADDRESS_MIRROR
#define DX_TEXADDRESS_CLAMP							(3)				// D_D3DTADDRESS_CLAMP
#define DX_TEXADDRESS_BORDER						(4)				// D_D3DTADDRESS_BORDER
#define DX_TEXADDRESS_NUM							(5)				// eNX`AhX^Cv̐

// VF[_[^Cv
#define DX_SHADERTYPE_VERTEX						(0)				// _VF[_[
#define DX_SHADERTYPE_PIXEL							(1)				// sNZVF[_[
#define DX_SHADERTYPE_GEOMETRY						(2)				// WIgVF[_[
#define DX_SHADERTYPE_COMPUTE						(3)				// Rs[gVF[_[
#define DX_SHADERTYPE_DOMAIN						(4)				// hCVF[_[
#define DX_SHADERTYPE_HULL							(5)				// nVF[_[

// _f[^^Cv
#define DX_VERTEX_TYPE_NORMAL_3D					(0)				// VERTEX3D\̌`
#define DX_VERTEX_TYPE_SHADER_3D					(1)				// VERTEX3DSHADER\̌`
#define DX_VERTEX_TYPE_NUM							(2)

// CfbNXf[^^Cv
#define DX_INDEX_TYPE_16BIT							(0)				// 16bitCfbNX
#define DX_INDEX_TYPE_32BIT							(1)				// 32bitCfbNX

// ft@Cǂݍݎ̕Z[h
#define DX_LOADMODEL_PHYSICS_DISABLE				(1)				// ZgpȂ
#define DX_LOADMODEL_PHYSICS_LOADCALC				(0)				// ǂݍݎɌvZ
#define DX_LOADMODEL_PHYSICS_REALTIME				(2)				// svZ

// ft@Cǂݍݎ̕ZO[h̃[h
#define DX_LOADMODEL_PHYSICS_DISABLENAMEWORD_ALWAYS	(0)						// SẴt@Cɑ΂Ė[hKp
#define DX_LOADMODEL_PHYSICS_DISABLENAMEWORD_DISABLEPHYSICSFILEONLY	(1)		// vmdt@C NP ܂߂uZṽt@Cɑ΂Ă̂ݖ[hKp( ̏ꍇA[hKpȂ̂ɂĂ͕Zs )
#define DX_LOADMODEL_PHYSICS_DISABLENAMEWORD_NUM	(2)

// PMD, PMX t@Cǂݍݎ̃Aj[V FPS [h(  IK ̐xɉe܂ )
#define DX_LOADMODEL_PMD_PMX_ANIMATION_FPSMODE_30	(0)				// Aj[V 30FPS œǂݍ( IK̐x:  f[^TCY: )( ftHg )
#define DX_LOADMODEL_PMD_PMX_ANIMATION_FPSMODE_60	(1)				// Aj[V 60FPS œǂݍ( IK̐x:  f[^TCY: )

// f̔vfӏɊւ`惂[h
#define DX_SEMITRANSDRAWMODE_ALWAYS					(0)				// ǂ֌WȂ`悷
#define DX_SEMITRANSDRAWMODE_SEMITRANS_ONLY			(1)				// ̂̂̂ݕ`悷
#define DX_SEMITRANSDRAWMODE_NOT_SEMITRANS_ONLY		(2)				// ł͂Ȃ̂̂ݕ`悷

// L[u}bv̖ʔԍ
#define DX_CUBEMAP_FACE_POSITIVE_X					(0)
#define DX_CUBEMAP_FACE_NEGATIVE_X					(1)
#define DX_CUBEMAP_FACE_POSITIVE_Y					(2)
#define DX_CUBEMAP_FACE_NEGATIVE_Y					(3)
#define DX_CUBEMAP_FACE_POSITIVE_Z					(4)
#define DX_CUBEMAP_FACE_NEGATIVE_Z					(5)

// |S`^Cv
#define DX_PRIMTYPE_POINTLIST						(1)				// D_D3DPT_POINTLIST
#define DX_PRIMTYPE_LINELIST						(2)				// D_D3DPT_LINELIST
#define DX_PRIMTYPE_LINESTRIP						(3)				// D_D3DPT_LINESTRIP
#define DX_PRIMTYPE_TRIANGLELIST					(4)				// D_D3DPT_TRIANGLELIST
#define DX_PRIMTYPE_TRIANGLESTRIP					(5)				// D_D3DPT_TRIANGLESTRIP
#define DX_PRIMTYPE_TRIANGLEFAN						(6)				// D_D3DPT_TRIANGLEFAN
#define DX_PRIMTYPE_MIN								(1)
#define DX_PRIMTYPE_MAX								(6)

// Cg^Cv
#define DX_LIGHTTYPE_D3DLIGHT_POINT					(1)				// D_D3DLIGHT_POINT
#define DX_LIGHTTYPE_D3DLIGHT_SPOT					(2)				// D_D3DLIGHT_SPOT
#define DX_LIGHTTYPE_D3DLIGHT_DIRECTIONAL			(3)				// D_D3DLIGHT_DIRECTIONAL
#define DX_LIGHTTYPE_POINT							(1)				// D_D3DLIGHT_POINT
#define DX_LIGHTTYPE_SPOT							(2)				// D_D3DLIGHT_SPOT
#define DX_LIGHTTYPE_DIRECTIONAL					(3)				// D_D3DLIGHT_DIRECTIONAL

// Live2D ̃VF[_[
#define DX_LIVE2D_SHADER_SETUP_MASK_VERTEX								(0)				// }XN摜p_VF[_[
#define DX_LIVE2D_SHADER_SETUP_MASK_PIXEL								(1)				// }XN摜psNZVF[_[
#define DX_LIVE2D_SHADER_NORMAL_VERTEX									(2)				// W̒_VF[_[
#define DX_LIVE2D_SHADER_NORMAL_VERTEX_MASKED							(3)				// W̒_VF[_[ + }XN摜
#define DX_LIVE2D_SHADER_NORMAL_PIXEL									(4)				// W̃sNZVF[_[
#define DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED							(5)				// W̃sNZVF[_[ + }XN摜
#define DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED_INVERTED					(6)				// W̃sNZVF[_[ + }XN摜( }XN摜̒l𔽓]Ďgp )
#define DX_LIVE2D_SHADER_NORMAL_PIXEL_PREMULALPHA						(7)				// W̃sNZVF[_[ + eNX`摜Zς݃At@
#define DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED_PREMULALPHA				(8)				// W̃sNZVF[_[ + eNX`摜Zς݃At@ + }XN摜
#define DX_LIVE2D_SHADER_NORMAL_PIXEL_MASKED_INVERTEX_PREMULALPHA		(9)				// W̃sNZVF[_[ + eNX`摜Zς݃At@ + }XN摜( }XN摜̒l𔽓]Ďgp )
#define DX_LIVE2D_SHADER_NUM											(10)			// VF[_[̐

// OtBbNC[WtH[}bg̒`
#define DX_GRAPHICSIMAGE_FORMAT_3D_PAL4						(0)		// PUFpbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_PAL8						(1)		// QTUFpbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_PAL4				(2)		// `lPUFpbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_PAL8				(3)		// `lQTUFpbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_PAL4			(4)		// eXgPUFpbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_PAL8			(5)		// eXgQTUFpbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_RGB16					(6)		// PUrbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_RGB32					(7)		// RQrbgJ[W
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_RGB16				(8)		// `ltPUrbgJ[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHA_RGB32				(9)		// `ltRQrbgJ[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_RGB16			(10)	// eXgtPUrbgJ[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ALPHATEST_RGB32			(11)	// eXgtRQrbgJ[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DXT1						(12)	// DXT1
#define DX_GRAPHICSIMAGE_FORMAT_3D_DXT2						(13)	// DXT2
#define DX_GRAPHICSIMAGE_FORMAT_3D_DXT3						(14)	// DXT3
#define DX_GRAPHICSIMAGE_FORMAT_3D_DXT4						(15)	// DXT4
#define DX_GRAPHICSIMAGE_FORMAT_3D_DXT5 					(16)	// DXT5
#define DX_GRAPHICSIMAGE_FORMAT_3D_BC7_UNORM 				(17)	// BC7 UNORM
#define DX_GRAPHICSIMAGE_FORMAT_3D_BC7_UNORM_SRGB			(18)	// BC7 UNORM SRGB
#define DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM0				(19)	// vbgtH[ˑtH[}bgO
#define DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM1				(20)	// vbgtH[ˑtH[}bgP
#define DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM2				(21)	// vbgtH[ˑtH[}bgQ
#define DX_GRAPHICSIMAGE_FORMAT_3D_PLATFORM3				(22)	// vbgtH[ˑtH[}bgR
#define DX_GRAPHICSIMAGE_FORMAT_3D_YUV	 					(23)	// xtutH[}bg
#define DX_GRAPHICSIMAGE_FORMAT_3D_ABGR_I16					(24)	// ARGB16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ABGR_F16					(25)	// ARGB_16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ABGR_F32					(26)	// ARGB_32rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ONE_I8					(27)	// P`l8rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ONE_I16					(28)	// P`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ONE_F16					(29)	// P`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_ONE_F32					(30)	// P`l32rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_TWO_I8					(31)	// Q`l8rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_TWO_I16					(32)	// Q`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_TWO_F16					(33)	// Q`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_TWO_F32					(34)	// Q`l32rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_RGB16			(35)	// `\PUrbgJ[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_RGB32			(36)	// `\RQrbgJ[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ALPHA_RGB32	(37)	// `\tRQrbgJ[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ABGR_I16		(38)	// `\ARGB16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ABGR_F16		(39)	// `\ARGB_16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ABGR_F32		(40)	// `\ARGB_32rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_I8			(41)	// `\P`l8rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_I16		(42)	// `\P`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_F16		(43)	// `\P`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_ONE_F32		(44)	// `\P`l32rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_I8			(45)	// `\Q`l8rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_I16		(46)	// `\Q`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_F16		(47)	// `\Q`l16rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_DRAWVALID_TWO_F32		(48)	// `\Q`l32rbg^J[
#define DX_GRAPHICSIMAGE_FORMAT_3D_NUM						(49)
#define DX_GRAPHICSIMAGE_FORMAT_2D							(50)	// W( DirectDrawSurface ̏ꍇ͂̂ )
#define DX_GRAPHICSIMAGE_FORMAT_R5G6B5						(51)	// R5G6B5( MEMIMG p )
#define DX_GRAPHICSIMAGE_FORMAT_X8A8R5G6B5					(52)	// X8A8R5G6B5( MEMIMG p )
#define DX_GRAPHICSIMAGE_FORMAT_X8R8G8B8					(53)	// X8R8G8B8( MEMIMG p )
#define DX_GRAPHICSIMAGE_FORMAT_A8R8G8B8					(54)	// A8R8G8B8( MEMIMG p )

#define DX_GRAPHICSIMAGE_FORMAT_NUM							(55)	// OtBbNtH[}bg̎ނ̐

// {C[W̃sNZtH[}bg
#define DX_BASEIMAGE_FORMAT_NORMAL					(0)				// ʂ̉摜
#define DX_BASEIMAGE_FORMAT_DXT1					(1)				// cwsP
#define DX_BASEIMAGE_FORMAT_DXT2					(2)				// cwsQ
#define DX_BASEIMAGE_FORMAT_DXT3					(3)				// cwsR
#define DX_BASEIMAGE_FORMAT_DXT4					(4)				// cwsS
#define DX_BASEIMAGE_FORMAT_DXT5					(5)				// cwsT
#define DX_BASEIMAGE_FORMAT_BC7_UNORM				(6)				// abV UNORM
#define DX_BASEIMAGE_FORMAT_BC7_UNORM_SRGB			(7)				// abV UNORM SRGB
#define DX_BASEIMAGE_FORMAT_PLATFORM0				(8)				// vbgtH[ˑtH[}bgO
#define DX_BASEIMAGE_FORMAT_PLATFORM1				(9)				// vbgtH[ˑtH[}bgP
#define DX_BASEIMAGE_FORMAT_PLATFORM2				(10)			// vbgtH[ˑtH[}bgQ
#define DX_BASEIMAGE_FORMAT_PLATFORM3				(11)			// vbgtH[ˑtH[}bgR
#define DX_BASEIMAGE_FORMAT_YUV						(12)			// xtu

// [r[̃T[tFX[h
#define DX_MOVIESURFACE_NORMAL						(0)
#define DX_MOVIESURFACE_OVERLAY						(1)
#define DX_MOVIESURFACE_FULLCOLOR					(2)

// SetUserScreenImage œnʂ̃sNZtH[}bg
#define DX_USER_SCREEN_PIXEL_FORMAT_R5G6B5			(0)				// R5G6B5( cwCu̕`֐gpł܂( \tgEFA_O[h ) )
#define DX_USER_SCREEN_PIXEL_FORMAT_R5G5B5X1		(1)				// R5G5B5X1( cwCu̕`֐͎gpłȂȂ܂ )
#define DX_USER_SCREEN_PIXEL_FORMAT_X1R5G5B5		(2)				// X1R5G5B5( cwCu̕`֐͎gpłȂȂ܂ )
#define DX_USER_SCREEN_PIXEL_FORMAT_X8B8G8R8		(3)				// X8B8G8R8( cwCu̕`֐͎gpłȂȂ܂ )
#define DX_USER_SCREEN_PIXEL_FORMAT_X8R8G8B8		(4)				// X8R8G8B8( cwCu̕`֐gpł܂( \tgEFA_O[h ) )
#define DX_USER_SCREEN_PIXEL_FORMAT_NUM				(5)

// EChẺsʒuݒ^Cv
#define DX_WIN_ZTYPE_NORMAL							(0)				// ʏݒ
#define DX_WIN_ZTYPE_BOTTOM							(1)				// SẴEChËԉɔzu
#define DX_WIN_ZTYPE_TOP							(2)				// SẴEChËԎOɔzu
#define DX_WIN_ZTYPE_TOPMOST						(3)				// SẴEChËԎOɔzu( EChEANeBuł͂ȂƂőOʂɕ\ )

// c[o[̃{^̏
#define TOOLBUTTON_STATE_ENABLE						(0)				// ͉\ȏ
#define TOOLBUTTON_STATE_PRESSED					(1)				// Ă
#define TOOLBUTTON_STATE_DISABLE					(2)				// ͕s\ȏ
#define TOOLBUTTON_STATE_PRESSED_DISABLE			(3)				// ĂԂŁA͕s\ȏ
#define TOOLBUTTON_STATE_NUM						(4)				// c[o[̃{^̏Ԃ̐

// c[o[̃{^̃^Cv
#define TOOLBUTTON_TYPE_NORMAL						(0)				// ʂ̃{^
#define TOOLBUTTON_TYPE_CHECK						(1)				// Ƃɂnm^nee؂ւ{^
#define TOOLBUTTON_TYPE_GROUP						(2)				// ʂ TOOLBUTTON_TYPE_GROUP ^Cṽ{^ƂneeɂȂ^Cṽ{^(O[v̋؂͌Ԃ)
#define TOOLBUTTON_TYPE_SEP							(3)				// ({^ł͂܂)
#define TOOLBUTTON_TYPE_NUM							(4)				// c[o[̃{^̃^Cv̐

// ej[̂hc
#define MENUITEM_IDTOP								(0xabababab)

// j[ɒǉۂ̃^Cv
#define MENUITEM_ADD_CHILD							(0)				// w̍ڂ̎qƂĒǉ
#define MENUITEM_ADD_INSERT							(1)				// w̍ڂƎw̍ڂ̍ڂ̊Ԃɒǉ

// j[̉ɕt}[N^Cv
#define MENUITEM_MARK_NONE							(0)				// t
#define MENUITEM_MARK_CHECK							(1)				// `FbN}[N
#define MENUITEM_MARK_RADIO							(2)				// WI{^

// ϊ^Cv`
#define DX_NUMMODE_10								(0)				// POi
#define DX_NUMMODE_16								(1)				// PUi
#define DX_STRMODE_NOT0								(2)				// 󂫂OŖ߂Ȃ
#define DX_STRMODE_USE0								(3)				// 󂫂OŖ߂

// CheckHitKeyAll Œׂ̓^Cv
#define DX_CHECKINPUT_KEY							(0x0001)		// L[͂𒲂ׂ
#define DX_CHECKINPUT_PAD							(0x0002)		// pbh͂𒲂ׂ
#define DX_CHECKINPUT_MOUSE							(0x0004)		// }EX{^͂𒲂ׂ
#define DX_CHECKINPUT_ALL							(DX_CHECKINPUT_KEY | DX_CHECKINPUT_PAD | DX_CHECKINPUT_MOUSE)	// ׂĂ̓͂𒲂ׂ

// pbh͎擾p[^
#define DX_INPUT_KEY_PAD1							(0x1001)		// L[͂ƃpbhP
#define DX_INPUT_PAD1								(0x0001)		// pbhP
#define DX_INPUT_PAD2								(0x0002)		// pbhQ
#define DX_INPUT_PAD3								(0x0003)		// pbhR
#define DX_INPUT_PAD4								(0x0004)		// pbhS
#define DX_INPUT_PAD5								(0x0005)		// pbhT
#define DX_INPUT_PAD6								(0x0006)		// pbhU
#define DX_INPUT_PAD7								(0x0007)		// pbhV
#define DX_INPUT_PAD8								(0x0008)		// pbhW
#define DX_INPUT_PAD9								(0x0009)		// pbhX
#define DX_INPUT_PAD10								(0x000a)		// pbhPO
#define DX_INPUT_PAD11								(0x000b)		// pbhPP
#define DX_INPUT_PAD12								(0x000c)		// pbhPQ
#define DX_INPUT_PAD13								(0x000d)		// pbhPR
#define DX_INPUT_PAD14								(0x000e)		// pbhPS
#define DX_INPUT_PAD15								(0x000f)		// pbhPT
#define DX_INPUT_PAD16								(0x0010)		// pbhPU
#define DX_INPUT_KEY								(0x1000)		// L[

// Q[Rg[[^Cv
#define DX_PADTYPE_OTHER							(0)
#define DX_PADTYPE_XBOX_360							(1)
#define DX_PADTYPE_XBOX_ONE							(2)
#define DX_PADTYPE_DUAL_SHOCK_3						(3)
#define DX_PADTYPE_DUAL_SHOCK_4						(4)
#define DX_PADTYPE_DUAL_SENSE						(5)
#define DX_PADTYPE_SWITCH_JOY_CON_L					(6)
#define DX_PADTYPE_SWITCH_JOY_CON_R					(7)
#define DX_PADTYPE_SWITCH_PRO_CTRL					(8)
#define DX_PADTYPE_SWITCH_HORI_PAD					(9)
#define DX_PADTYPE_NUM								(10)

// ^b`̓ڐGoΉő吔
#define TOUCHINPUTPOINT_MAX							(16)

// pbh͒`
#define PAD_INPUT_DOWN								(0x00000001)	// `FbN}XN
#define PAD_INPUT_LEFT								(0x00000002)	// `FbN}XN
#define PAD_INPUT_RIGHT								(0x00000004)	// `FbN}XN
#define PAD_INPUT_UP								(0x00000008)	// `FbN}XN
#define PAD_INPUT_A									(0x00000010)	// `{^`FbN}XN
#define PAD_INPUT_B									(0x00000020)	// a{^`FbN}XN
#define PAD_INPUT_C									(0x00000040)	// b{^`FbN}XN
#define PAD_INPUT_X									(0x00000080)	// w{^`FbN}XN
#define PAD_INPUT_Y									(0x00000100)	// x{^`FbN}XN
#define PAD_INPUT_Z									(0x00000200)	// y{^`FbN}XN
#define PAD_INPUT_L									(0x00000400)	// k{^`FbN}XN
#define PAD_INPUT_R									(0x00000800)	// q{^`FbN}XN
#define PAD_INPUT_START								(0x00001000)	// rs`qs{^`FbN}XN
#define PAD_INPUT_M									(0x00002000)	// l{^`FbN}XN
#define PAD_INPUT_D									(0x00004000)
#define PAD_INPUT_F									(0x00008000)
#define PAD_INPUT_G									(0x00010000)
#define PAD_INPUT_H									(0x00020000)
#define PAD_INPUT_I									(0x00040000)
#define PAD_INPUT_J									(0x00080000)
#define PAD_INPUT_K									(0x00100000)
#define PAD_INPUT_LL								(0x00200000)
#define PAD_INPUT_N									(0x00400000)
#define PAD_INPUT_O									(0x00800000)
#define PAD_INPUT_P									(0x01000000)
#define PAD_INPUT_RR								(0x02000000)
#define PAD_INPUT_S									(0x04000000)
#define PAD_INPUT_T									(0x08000000)
#define PAD_INPUT_U									(0x10000000)
#define PAD_INPUT_V									(0x20000000)
#define PAD_INPUT_W									(0x40000000)
#define PAD_INPUT_XX								(0x80000000)

#define PAD_INPUT_1									(0x00000010)
#define PAD_INPUT_2									(0x00000020)
#define PAD_INPUT_3									(0x00000040)
#define PAD_INPUT_4									(0x00000080)
#define PAD_INPUT_5									(0x00000100)
#define PAD_INPUT_6									(0x00000200)
#define PAD_INPUT_7									(0x00000400)
#define PAD_INPUT_8									(0x00000800)
#define PAD_INPUT_9									(0x00001000)
#define PAD_INPUT_10								(0x00002000)
#define PAD_INPUT_11								(0x00004000)
#define PAD_INPUT_12								(0x00008000)
#define PAD_INPUT_13								(0x00010000)
#define PAD_INPUT_14								(0x00020000)
#define PAD_INPUT_15								(0x00040000)
#define PAD_INPUT_16								(0x00080000)
#define PAD_INPUT_17								(0x00100000)
#define PAD_INPUT_18								(0x00200000)
#define PAD_INPUT_19								(0x00400000)
#define PAD_INPUT_20								(0x00800000)
#define PAD_INPUT_21								(0x01000000)
#define PAD_INPUT_22								(0x02000000)
#define PAD_INPUT_23								(0x04000000)
#define PAD_INPUT_24								(0x08000000)
#define PAD_INPUT_25								(0x10000000)
#define PAD_INPUT_26								(0x20000000)
#define PAD_INPUT_27								(0x40000000)
#define PAD_INPUT_28								(0x80000000)

// XInput{^͒`
#define XINPUT_BUTTON_DPAD_UP						(0)				// fW^{^
#define XINPUT_BUTTON_DPAD_DOWN						(1)				// fW^{^
#define XINPUT_BUTTON_DPAD_LEFT						(2)				// fW^{^
#define XINPUT_BUTTON_DPAD_RIGHT					(3)				// fW^{^E
#define XINPUT_BUTTON_START							(4)				// START{^
#define XINPUT_BUTTON_BACK							(5)				// BACK{^
#define XINPUT_BUTTON_LEFT_THUMB					(6)				// XeBbN
#define XINPUT_BUTTON_RIGHT_THUMB					(7)				// EXeBbN
#define XINPUT_BUTTON_LEFT_SHOULDER					(8)				// LB{^
#define XINPUT_BUTTON_RIGHT_SHOULDER				(9)				// RB{^
#define XINPUT_BUTTON_A								(12)			// A{^
#define XINPUT_BUTTON_B								(13)			// B{^
#define XINPUT_BUTTON_X								(14)			// X{^
#define XINPUT_BUTTON_Y								(15)			// Y{^

// }EX͒`
#define MOUSE_INPUT_LEFT							(0x0001)		// }EX{^
#define MOUSE_INPUT_RIGHT							(0x0002)		// }EXE{^
#define MOUSE_INPUT_MIDDLE							(0x0004)		// }EX{^
#define MOUSE_INPUT_1								(0x0001)		// }EXP{^
#define MOUSE_INPUT_2								(0x0002)		// }EXQ{^
#define MOUSE_INPUT_3								(0x0004)		// }EXR{^
#define MOUSE_INPUT_4								(0x0008)		// }EXS{^
#define MOUSE_INPUT_5								(0x0010)		// }EXT{^
#define MOUSE_INPUT_6								(0x0020)		// }EXU{^
#define MOUSE_INPUT_7								(0x0040)		// }EXV{^
#define MOUSE_INPUT_8								(0x0080)		// }EXW{^

// }EX̃O^Cv
#define MOUSE_INPUT_LOG_DOWN						(0)				// {^
#define MOUSE_INPUT_LOG_UP							(1)				// {^𗣂

// L[`
#define KEY_INPUT_BACK								(0x0E)			// BackSpaceL[	D_DIK_BACK
#define KEY_INPUT_TAB								(0x0F)			// TabL[			D_DIK_TAB
#define KEY_INPUT_RETURN							(0x1C)			// EnterL[		D_DIK_RETURN

#define KEY_INPUT_LSHIFT							(0x2A)			// ShiftL[		D_DIK_LSHIFT
#define KEY_INPUT_RSHIFT							(0x36)			// EShiftL[		D_DIK_RSHIFT
#define KEY_INPUT_LCONTROL							(0x1D)			// CtrlL[		D_DIK_LCONTROL
#define KEY_INPUT_RCONTROL							(0x9D)			// ECtrlL[		D_DIK_RCONTROL
#define KEY_INPUT_ESCAPE							(0x01)			// EscL[			D_DIK_ESCAPE
#define KEY_INPUT_SPACE								(0x39)			// Xy[XL[		D_DIK_SPACE
#define KEY_INPUT_PGUP								(0xC9)			// PageUpL[		D_DIK_PGUP
#define KEY_INPUT_PGDN								(0xD1)			// PageDownL[		D_DIK_PGDN
#define KEY_INPUT_END								(0xCF)			// EndL[			D_DIK_END
#define KEY_INPUT_HOME								(0xC7)			// HomeL[			D_DIK_HOME
#define KEY_INPUT_LEFT								(0xCB)			// L[			D_DIK_LEFT
#define KEY_INPUT_UP								(0xC8)			// L[			D_DIK_UP
#define KEY_INPUT_RIGHT								(0xCD)			// EL[			D_DIK_RIGHT
#define KEY_INPUT_DOWN								(0xD0)			// L[			D_DIK_DOWN
#define KEY_INPUT_INSERT							(0xD2)			// InsertL[		D_DIK_INSERT
#define KEY_INPUT_DELETE							(0xD3)			// DeleteL[		D_DIK_DELETE

#define KEY_INPUT_MINUS								(0x0C)			// |L[			D_DIK_MINUS
#define KEY_INPUT_YEN								(0x7D)			// L[			D_DIK_YEN
#define KEY_INPUT_PREVTRACK							(0x90)			// OL[			D_DIK_PREVTRACK
#define KEY_INPUT_PERIOD							(0x34)			// DL[			D_DIK_PERIOD
#define KEY_INPUT_SLASH								(0x35)			// ^L[			D_DIK_SLASH
#define KEY_INPUT_LALT								(0x38)			// AltL[		D_DIK_LALT
#define KEY_INPUT_RALT								(0xB8)			// EAltL[		D_DIK_RALT
#define KEY_INPUT_SCROLL							(0x46)			// ScrollLockL[	D_DIK_SCROLL
#define KEY_INPUT_SEMICOLON							(0x27)			// GL[			D_DIK_SEMICOLON
#define KEY_INPUT_COLON								(0x92)			// FL[			D_DIK_COLON
#define KEY_INPUT_LBRACKET							(0x1A)			// mL[			D_DIK_LBRACKET
#define KEY_INPUT_RBRACKET							(0x1B)			// nL[			D_DIK_RBRACKET
#define KEY_INPUT_AT								(0x91)			// L[			D_DIK_AT
#define KEY_INPUT_BACKSLASH							(0x2B)			// _L[			D_DIK_BACKSLASH
#define KEY_INPUT_COMMA								(0x33)			// CL[			D_DIK_COMMA
#define KEY_INPUT_KANJI								(0x94)			// L[			D_DIK_KANJI
#define KEY_INPUT_CONVERT							(0x79)			// ϊL[			D_DIK_CONVERT
#define KEY_INPUT_NOCONVERT							(0x7B)			// ϊL[		D_DIK_NOCONVERT
#define KEY_INPUT_KANA								(0x70)			// JiL[			D_DIK_KANA
#define KEY_INPUT_APPS								(0xDD)			// AvP[Vj[L[		D_DIK_APPS
#define KEY_INPUT_CAPSLOCK							(0x3A)			// CaspLockL[		D_DIK_CAPSLOCK
#define KEY_INPUT_SYSRQ								(0xB7)			// PrintScreenL[	D_DIK_SYSRQ
#define KEY_INPUT_PAUSE								(0xC5)			// PauseBreakL[	D_DIK_PAUSE
#define KEY_INPUT_LWIN								(0xDB)			// WinL[		D_DIK_LWIN
#define KEY_INPUT_RWIN								(0xDC)			// EWinL[		D_DIK_RWIN

#define KEY_INPUT_NUMLOCK							(0x45)			// eL[NumLockL[		D_DIK_NUMLOCK
#define KEY_INPUT_NUMPAD0							(0x52)			// eL[O				D_DIK_NUMPAD0
#define KEY_INPUT_NUMPAD1							(0x4F)			// eL[P				D_DIK_NUMPAD1
#define KEY_INPUT_NUMPAD2							(0x50)			// eL[Q				D_DIK_NUMPAD2
#define KEY_INPUT_NUMPAD3							(0x51)			// eL[R				D_DIK_NUMPAD3
#define KEY_INPUT_NUMPAD4							(0x4B)			// eL[S				D_DIK_NUMPAD4
#define KEY_INPUT_NUMPAD5							(0x4C)			// eL[T				D_DIK_NUMPAD5
#define KEY_INPUT_NUMPAD6							(0x4D)			// eL[U				D_DIK_NUMPAD6
#define KEY_INPUT_NUMPAD7							(0x47)			// eL[V				D_DIK_NUMPAD7
#define KEY_INPUT_NUMPAD8							(0x48)			// eL[W				D_DIK_NUMPAD8
#define KEY_INPUT_NUMPAD9							(0x49)			// eL[X				D_DIK_NUMPAD9
#define KEY_INPUT_MULTIPLY							(0x37)			// eL[L[			D_DIK_MULTIPLY
#define KEY_INPUT_ADD								(0x4E)			// eL[{L[			D_DIK_ADD
#define KEY_INPUT_SUBTRACT							(0x4A)			// eL[|L[			D_DIK_SUBTRACT
#define KEY_INPUT_DECIMAL							(0x53)			// eL[DL[			D_DIK_DECIMAL
#define KEY_INPUT_DIVIDE							(0xB5)			// eL[^L[			D_DIK_DIVIDE
#define KEY_INPUT_NUMPADENTER						(0x9C)			// eL[̃G^[L[	D_DIK_NUMPADENTER

#define KEY_INPUT_F1								(0x3B)			// ePL[			D_DIK_F1
#define KEY_INPUT_F2								(0x3C)			// eQL[			D_DIK_F2
#define KEY_INPUT_F3								(0x3D)			// eRL[			D_DIK_F3
#define KEY_INPUT_F4								(0x3E)			// eSL[			D_DIK_F4
#define KEY_INPUT_F5								(0x3F)			// eTL[			D_DIK_F5
#define KEY_INPUT_F6								(0x40)			// eUL[			D_DIK_F6
#define KEY_INPUT_F7								(0x41)			// eVL[			D_DIK_F7
#define KEY_INPUT_F8								(0x42)			// eWL[			D_DIK_F8
#define KEY_INPUT_F9								(0x43)			// eXL[			D_DIK_F9
#define KEY_INPUT_F10								(0x44)			// ePOL[		D_DIK_F10
#define KEY_INPUT_F11								(0x57)			// ePPL[		D_DIK_F11
#define KEY_INPUT_F12								(0x58)			// ePQL[		D_DIK_F12

#define KEY_INPUT_A									(0x1E)			// `L[			D_DIK_A
#define KEY_INPUT_B									(0x30)			// aL[			D_DIK_B
#define KEY_INPUT_C									(0x2E)			// bL[			D_DIK_C
#define KEY_INPUT_D									(0x20)			// cL[			D_DIK_D
#define KEY_INPUT_E									(0x12)			// dL[			D_DIK_E
#define KEY_INPUT_F									(0x21)			// eL[			D_DIK_F
#define KEY_INPUT_G									(0x22)			// fL[			D_DIK_G
#define KEY_INPUT_H									(0x23)			// gL[			D_DIK_H
#define KEY_INPUT_I									(0x17)			// hL[			D_DIK_I
#define KEY_INPUT_J									(0x24)			// iL[			D_DIK_J
#define KEY_INPUT_K									(0x25)			// jL[			D_DIK_K
#define KEY_INPUT_L									(0x26)			// kL[			D_DIK_L
#define KEY_INPUT_M									(0x32)			// lL[			D_DIK_M
#define KEY_INPUT_N									(0x31)			// mL[			D_DIK_N
#define KEY_INPUT_O									(0x18)			// nL[			D_DIK_O
#define KEY_INPUT_P									(0x19)			// oL[			D_DIK_P
#define KEY_INPUT_Q									(0x10)			// pL[			D_DIK_Q
#define KEY_INPUT_R									(0x13)			// qL[			D_DIK_R
#define KEY_INPUT_S									(0x1F)			// rL[			D_DIK_S
#define KEY_INPUT_T									(0x14)			// sL[			D_DIK_T
#define KEY_INPUT_U									(0x16)			// tL[			D_DIK_U
#define KEY_INPUT_V									(0x2F)			// uL[			D_DIK_V
#define KEY_INPUT_W									(0x11)			// vL[			D_DIK_W
#define KEY_INPUT_X									(0x2D)			// wL[			D_DIK_X
#define KEY_INPUT_Y									(0x15)			// xL[			D_DIK_Y
#define KEY_INPUT_Z									(0x2C)			// yL[			D_DIK_Z

#define KEY_INPUT_0 								(0x0B)			// OL[			D_DIK_0
#define KEY_INPUT_1									(0x02)			// PL[			D_DIK_1
#define KEY_INPUT_2									(0x03)			// QL[			D_DIK_2
#define KEY_INPUT_3									(0x04)			// RL[			D_DIK_3
#define KEY_INPUT_4									(0x05)			// SL[			D_DIK_4
#define KEY_INPUT_5									(0x06)			// TL[			D_DIK_5
#define KEY_INPUT_6									(0x07)			// UL[			D_DIK_6
#define KEY_INPUT_7									(0x08)			// VL[			D_DIK_7
#define KEY_INPUT_8									(0x09)			// WL[			D_DIK_8
#define KEY_INPUT_9									(0x0A)			// XL[			D_DIK_9

// AXL[Rg[L[R[h
#define CTRL_CODE_BS								(0x08)			// obNXy[X
#define CTRL_CODE_TAB								(0x09)			// ^u
#define CTRL_CODE_CR								(0x0d)			// s
#define CTRL_CODE_DEL								(0x10)			// cdkL[

#define CTRL_CODE_COPY								(0x03)			// Rs[
#define CTRL_CODE_PASTE								(0x16)			// y[Xg
#define CTRL_CODE_CUT								(0x18)			// Jbg
#define CTRL_CODE_ALL								(0x01)			// SđI

#define CTRL_CODE_LEFT								(0x1d)			// L[
#define CTRL_CODE_RIGHT								(0x1c)			// L[
#define CTRL_CODE_UP								(0x1e)			// L[
#define CTRL_CODE_DOWN								(0x1f)			// L[

#define CTRL_CODE_HOME								(0x1a)			// gnld{^
#define CTRL_CODE_END								(0x19)			// dmc{^
#define CTRL_CODE_PAGE_UP							(0x17)			// o`fd to
#define CTRL_CODE_PAGE_DOWN							(0x15)			// o`fd cnvm

#define CTRL_CODE_ESC								(0x1b)			// drbL[
#define CTRL_CODE_CMP								(0x20)			// R[h~l

// SetKeyInputStringColor2 ɓnFύXΏۂw肷邽߂̎ʎq
#define DX_KEYINPSTRCOLOR_NORMAL_STR					(0)			// ͕̐F
#define DX_KEYINPSTRCOLOR_NORMAL_STR_EDGE				(1)			// ͕̉̐F
#define DX_KEYINPSTRCOLOR_NORMAL_CURSOR					(2)			// hldgp̃J[\̐F
#define DX_KEYINPSTRCOLOR_SELECT_STR					(3)			// ͕̑I𕔕( SHIFTL[Ȃ獶EL[őI )̐F
#define DX_KEYINPSTRCOLOR_SELECT_STR_EDGE				(4)			// ͕̑I𕔕( SHIFTL[Ȃ獶EL[őI )̉̐F
#define DX_KEYINPSTRCOLOR_SELECT_STR_BACK				(5)			// ͕̑I𕔕( SHIFTL[Ȃ獶EL[őI )̎̐F
#define DX_KEYINPSTRCOLOR_IME_STR						(6)			// hldgp͕̓̐F
#define DX_KEYINPSTRCOLOR_IME_STR_EDGE					(7)			// hldgp͕̓̉̐F
#define DX_KEYINPSTRCOLOR_IME_STR_BACK					(8)			// hldgp͕̓̎̐F
#define DX_KEYINPSTRCOLOR_IME_CURSOR					(9)			// hldgp̃J[\̐F
#define DX_KEYINPSTRCOLOR_IME_LINE						(10)		// hldgp̕ϊ̉̐F
#define DX_KEYINPSTRCOLOR_IME_SELECT_STR				(11)		// hldgp̑IΏۂ̕ϊ╶̐F
#define DX_KEYINPSTRCOLOR_IME_SELECT_STR_EDGE			(12)		// hldgp̑IΏۂ̕ϊ╶̉̐F
#define DX_KEYINPSTRCOLOR_IME_SELECT_STR_BACK			(13)		// hldgp̑IΏۂ̕ϊ╶̎̐F
#define DX_KEYINPSTRCOLOR_IME_CONV_WIN_STR				(14)		// hldgp̕ϊEChE̐̕F
#define DX_KEYINPSTRCOLOR_IME_CONV_WIN_STR_EDGE			(15)		// hldgp̕ϊEChẺ̐̕F
#define DX_KEYINPSTRCOLOR_IME_CONV_WIN_SELECT_STR		(16)		// hldgp̕ϊEChEőIĂ镶̐F
#define DX_KEYINPSTRCOLOR_IME_CONV_WIN_SELECT_STR_EDGE	(17)		// hldgp̕ϊEChEőIĂ镶̉̐F
#define DX_KEYINPSTRCOLOR_IME_CONV_WIN_SELECT_STR_BACK	(18)		// hldgp̕ϊEChEőIĂ镶̎̐F
#define DX_KEYINPSTRCOLOR_IME_CONV_WIN_EDGE				(19)		// hldgp̕ϊEChẺ̐F
#define DX_KEYINPSTRCOLOR_IME_CONV_WIN_BACK				(20)		// hldgp̕ϊEChẺn̐F
#define DX_KEYINPSTRCOLOR_IME_MODE_STR					(21)		// hldgp̓̓[h̐F(wSpЂ炪ȁx)
#define DX_KEYINPSTRCOLOR_IME_MODE_STR_EDGE				(22)		// hldgp̓̓[h̉̐F
#define DX_KEYINPSTRCOLOR_NUM							(23)

// ͏͕̓EɒBĂԂŁA̖[œ͂sꂽꍇ̏[h
#define DX_KEYINPSTR_ENDCHARAMODE_OVERWRITE				(0)			// EɒBĂԂŕ̖[ŕ͂ꂽꍇ́AŌ̕㏑( ftHg )
#define DX_KEYINPSTR_ENDCHARAMODE_NOTCHANGE				(1)			// EɒBĂԂŕ̖[ŕ͂ꂽꍇ́AωȂ

// ^b`plf[^̃c[^Cv
#define DX_TOUCHINPUT_TOOL_TYPE_UNKNOWN					(0)			// s
#define DX_TOUCHINPUT_TOOL_TYPE_FINGER					(1)			// w
#define DX_TOUCHINPUT_TOOL_TYPE_STYLUS					(2)			// X^CXy
#define DX_TOUCHINPUT_TOOL_TYPE_MOUSE					(3)			// }EX
#define DX_TOUCHINPUT_TOOL_TYPE_ERASER					(4)			// S

// tXN[𑜓x[h`
#define DX_FSRESOLUTIONMODE_BORDERLESS_WINDOW		(0)				// ztXN[[h( ۂɂ̓tXN[[hɂA{[_[XEBhEfXNgbvʂςɊg債ĉzIɃtXN[[h郂[h )
#define DX_FSRESOLUTIONMODE_DESKTOP					(1)				// j^[̉ʃ[hfXNgbvʂƓɂĂcwCuʂg債ĕ\郂[h
#define DX_FSRESOLUTIONMODE_NATIVE					(2)				// j^[̉𑜓xcwCuʂ̉𑜓xɍ킹郂[h
#define DX_FSRESOLUTIONMODE_MAXIMUM					(3)				// j^[̉𑜓xőɂĂcwCuʂg債ĕ\郂[h

// tXN[g僂[h`
#define DX_FSSCALINGMODE_BILINEAR					(0)				// oCjA[h( sNZŃsNZƃsNZ̋؂肪͂肵Ȃ )
#define DX_FSSCALINGMODE_NEAREST					(1)				// ŋߓ_[h( sNZlp\ )

// SetGraphMode ߂l`
#define DX_CHANGESCREEN_OK							(0)				// ʕύX͐
#define DX_CHANGESCREEN_RETURN						(-1)			// ʂ̕ύX͎sẢʃ[hɖ߂ꂽ
#define DX_CHANGESCREEN_DEFAULT						(-2)			// ʂ̕ύX͎sftHg̉ʃ[hɕύXꂽ
#define DX_CHANGESCREEN_REFRESHNORMAL				(-3)			// ʂ̕ύX͐AtbV[g̕ύX͎s

// Xg[f[^ǂݍݏR[hȗ֘A
#define STTELL( st )								((st)->ReadShred.Tell( (st)->DataPoint ))
#define STSEEK( st, pos, type )						((st)->ReadShred.Seek( (st)->DataPoint, (pos), (type) ))
#define STREAD( buf, length, num, st )				((st)->ReadShred.Read( (buf), (length), (num), (st)->DataPoint ))
#define STWRITE( buf, length, num, st )				((st)->ReadShred.Write( (buf), (length), (num), (st)->DataPoint ))
#define STEOF( st )									((st)->ReadShred.Eof( (st)->DataPoint ))
#define STCLOSE( st )								((st)->ReadShred.Close( (st)->DataPoint ))

// Xg[f[^̃V[N^Cv`
#define STREAM_SEEKTYPE_SET							(SEEK_SET)
#define STREAM_SEEKTYPE_END							(SEEK_END)
#define STREAM_SEEKTYPE_CUR							(SEEK_CUR)

// OtBbN[h̃C[W^Cv
#define LOADIMAGE_TYPE_FILE							(0)				// C[W̓t@Cł
#define LOADIMAGE_TYPE_MEM							(1)				// C[W̓ł
#define LOADIMAGE_TYPE_NONE							(-1)			// C[W͖



#ifndef DX_NON_NETWORK

// HTTP G[
#define HTTP_ERR_SERVER								(0)				// T[o[G[
#define HTTP_ERR_NOTFOUND							(1)				// t@CȂ
#define HTTP_ERR_MEMORY								(2)				// mۂ̎s
#define HTTP_ERR_LOST								(3)				// rŐؒfꂽ
#define HTTP_ERR_NONE								(-1)			// G[͕񍐂ĂȂ

// HTTP ̌
#define HTTP_RES_COMPLETE							(0)				// 
#define HTTP_RES_STOP								(1)				// ~
#define HTTP_RES_ERROR								(2)				// G[I
#define HTTP_RES_NOW								(-1)			// ݐis

#endif // DX_NON_NETWORK

#define DX_DEFINE_END

// f[^^`-------------------------------------------------------------------

#if defined( __cplusplus ) && defined( DX_COMPILE_TYPE_C_LANGUAGE )
extern "C" {
#endif

// WAVEFORMATEX ̒`
#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_

typedef struct tWAVEFORMATEX
{
	WORD					wFormatTag ;					// tH[}bg( WAVE_FORMAT_PCM( l 1 )  )
	WORD					nChannels ;						// `l
	DWORD					nSamplesPerSec ;				// Pbӂ̃Tv
	DWORD					nAvgBytesPerSec ;				// Pbӂ̃oCg( PCM̏ꍇ nSamplesPerSec * nBlockAlign )
	WORD					nBlockAlign ;					// S`l̂PTv킹oCg( wBitsPerSample / 8 * nChannels )
	WORD					wBitsPerSample ;				// PTvӂ̃rbg
	WORD					cbSize ;						// g̃oCg( g񂪖ꍇ 0 )
} WAVEFORMATEX, *PWAVEFORMATEX, NEAR *NPWAVEFORMATEX, FAR *LPWAVEFORMATEX ;

#endif // _WAVEFORMATEX_

// WAVEFORMAT ̒`
#ifndef WAVE_FORMAT_PCM

typedef struct waveformat_tag
{
	WORD					wFormatTag ;					// tH[}bg( WAVE_FORMAT_PCM( l 1 )  )
	WORD					nChannels ;						// `l
	DWORD					nSamplesPerSec ;				// Pbӂ̃Tv
	DWORD					nAvgBytesPerSec ;				// Pbӂ̃oCg( PCM̏ꍇ nSamplesPerSec * nBlockAlign )
	WORD					nBlockAlign ;					// S`l̂PTv킹oCg( wBitsPerSample / 8 * nChannels )
} WAVEFORMAT, *PWAVEFORMAT, NEAR *NPWAVEFORMAT, FAR *LPWAVEFORMAT ;

#define WAVE_FORMAT_PCM		1

#endif // WAVE_FORMAT_PCM

#ifndef DX_NON_NAMESPACE

namespace DxLib
{

#endif // DX_NON_NAMESPACE

#define DX_STRUCT_START

// hld͕̕`ɕKvȏ̓̕ߏ
typedef struct tagIMEINPUTCLAUSEDATA
{
	int						Position ;						// ڂ
	int						Length ;						// 
} IMEINPUTCLAUSEDATA, *LPIMEINPUTCLAUSEDATA ;

// hld͕̕`ɕKvȏ
typedef struct tagIMEINPUTDATA
{
	const TCHAR *				InputString ;				// ͒̕

	int							CursorPosition ;			// J[\͕̓񒆂̈ʒu(oCgP)

	const IMEINPUTCLAUSEDATA *	ClauseData ;				// ߏ
	int							ClauseNum ;					// ߏ̐
	int							SelectClause ;				// I𒆂̕( -1 ̏ꍇ͂ǂ̕߂ɂĂȂ( ɃJ[\ ) )

	int							CandidateNum ;				// ϊ̐( 0̏ꍇ͕ϊł͂Ȃ )
	const TCHAR **				CandidateList ;				// ϊ╶񃊃Xg( FԖڂ̌`悷ꍇ  DrawString( 0, 0, data.CandidateList[ n ], GetColor(255,255,255) ); )
	int							SelectCandidate ;			// I𒆂̕ϊ

	int							ConvertFlag ;				// ϊǂ( TRUE:ϊ  FALSE:ϊł͂Ȃ( PʂŃJ[\ړł ) )
} IMEINPUTDATA, *LPIMEINPUTDATA ;

// `敶ꕶ̏
typedef struct tagDRAWCHARINFO
{
	TCHAR					Char[ 14 ] ;					// 
	WORD					Bytes ;							// ̃oCg
	float					DrawX, DrawY ;					// `ʒu
	float					SizeX, SizeY ;					// `TCY
} DRAWCHARINFO, *LPDRAWCHARINFO ;

// ʃ[hf[^^
typedef struct tagDISPLAYMODEDATA
{
	int						Width ;							// 𑜓x
	int						Height ;						// 𑜓x
	int						ColorBitDepth ;					// Frbg[x
	int						RefreshRate ;					// tbV[g( -1 ̏ꍇ͋Kl )
} DISPLAYMODEDATA, *LPDISPLAYMODEDATA ;

// ^Cf[^^
typedef struct tagDATEDATA
{
	int						Year ;							// N
	int						Mon ;							// 
	int						Day ;							// 
	int						Hour ;							// 
	int						Min ;							// 
	int						Sec ;							// b
} DATEDATA, *LPDATEDATA ;

// t@C\
typedef struct tagFILEINFO
{
	TCHAR					Name[ 260 ] ;					// IuWFNg
	int						DirFlag ;						// fBNgǂ( TRUE:fBNg  FALSE:t@C )
	LONGLONG				Size ;							// TCY
	DATEDATA				CreationTime ;					// 쐬
	DATEDATA				LastWriteTime ;					// ŏIXV
} FILEINFO, *LPFILEINFO ;

// t@C\́i wchar_t  j
typedef struct tagFILEINFOW
{
	wchar_t					Name[ 260 ] ;					// IuWFNg
	int						DirFlag ;						// fBNgǂ( TRUE:fBNg  FALSE:t@C )
	LONGLONG				Size ;							// TCY
	DATEDATA				CreationTime ;					// 쐬
	DATEDATA				LastWriteTime ;					// ŏIXV
} FILEINFOW, *LPFILEINFOW ;

// s\
typedef struct tagMATRIX
{
	float					m[4][4] ;
} MATRIX, *LPMATRIX ;

typedef struct tagMATRIX_D
{
	double					m[4][4] ;
} MATRIX_D, *LPMATRIX_D ;

// xNgf[^^
typedef struct tagVECTOR
{
	float					x, y, z ;
} VECTOR, *LPVECTOR, FLOAT3, *LPFLOAT3 ;

typedef struct tagVECTOR_D
{
	double					x, y, z ;
} VECTOR_D, *LPVECTOR_D, DOUBLE3, *LPDOUBLE3 ;

// FLOAT2f[^^
typedef struct tagFLOAT2
{
	float					u, v ;
} FLOAT2 ;

// float ^̃J[l
typedef struct tagCOLOR_F
{
	float					r, g, b, a ;
} COLOR_F, *LPCOLOR_F ;

// unsigned char ^̃J[l
typedef struct tagCOLOR_U8
{
	BYTE					b, g, r, a ;
} COLOR_U8 ;

// FLOAT4f[^^
typedef struct tagFLOAT4
{
	float					x, y, z, w ;
} FLOAT4, *LPFLOAT4 ;

// DOUBLE4f[^^
typedef struct tagDOUBLE4
{
	double					x, y, z, w ;
} DOUBLE4, *LPDOUBLE4 ;

// INT4f[^^
typedef struct tagINT4
{
	int						x, y, z, w ;
} INT4 ;

#ifndef DX_NOTUSE_DRAWFUNCTION

// Qc`Ɏgp钸_f[^^(DrawPrimitive2Dp)
typedef struct tagVERTEX2D
{
	VECTOR					pos ;
	float					rhw ;
	COLOR_U8				dif ;
	float					u, v ;
} VERTEX2D, *LPVERTEX2D ; 

// Qc`Ɏgp钸_f[^^(DrawPrimitive2DToShaderp)
typedef struct tagVERTEX2DSHADER
{
	VECTOR					pos ;
	float					rhw ;
	COLOR_U8				dif ;
	COLOR_U8				spc ;
	float					u, v ;
	float					su, sv ;
} VERTEX2DSHADER, *LPVERTEX2DSHADER ; 

// Qc`Ɏgp钸_f[^^(Jp)
typedef struct tagVERTEX
{
	float					x, y ;
	float					u, v ;
	unsigned char			b, g, r, a ;
} VERTEX ;

// Rc`Ɏgp钸_f[^^( o[Ŵ )
typedef struct tagVERTEX_3D
{
	VECTOR					pos ;
	unsigned char			b, g, r, a ;
	float					u, v ;
} VERTEX_3D, *LPVERTEX_3D ;

// Rc`Ɏgp钸_f[^^
typedef struct tagVERTEX3D
{
	VECTOR					pos ;							// W
	VECTOR					norm ;							// @
	COLOR_U8				dif ;							// fBt[YJ[
	COLOR_U8				spc ;							// XyLJ[
	float					u, v ;							// eNX`W
	float					su, sv ;						// ⏕eNX`W
} VERTEX3D, *LPVERTEX3D ;

// Rc`Ɏgp钸_f[^^( DrawPrimitive3DToShaderp )
// Ӂcoϐɒǉ邩܂̂ŁA錾̏( VERTEX3DSHADER Vertex = { 0.0f, 0.0f, ... Ƃ悤Ȃ )͂Ȃǂł
typedef struct tagVERTEX3DSHADER
{
	VECTOR					pos ;							// W
	FLOAT4					spos ;							// ⏕W
	VECTOR					norm ;							// @
	VECTOR					tan ;							// ڐ
	VECTOR					binorm ;						// ]@
	COLOR_U8				dif ;							// fBt[YJ[
	COLOR_U8				spc ;							// XyLJ[
	float					u, v ;							// eNX`W
	float					su, sv ;						// ⏕eNX`W
} VERTEX3DSHADER, *LPVERTEX3DSHADER ;

// Cgp[^
typedef struct tagLIGHTPARAM
{
	int						LightType ;						// Cg̃^Cv( DX_LIGHTTYPE_D3DLIGHT_POINT  )
	COLOR_F					Diffuse ;						// fBt[YJ[
	COLOR_F					Specular ;						// XyLJ[
	COLOR_F					Ambient ;						// ArGgF
	VECTOR					Position ;						// ʒu
	VECTOR					Direction ;						// 
	float					Range ;							// L
	float					Falloff ;						// tH[It 1.0f ɂĂ̂D܂
	float					Attenuation0 ;					// ɂ錸WO
	float					Attenuation1 ;					// ɂ錸WP
	float					Attenuation2 ;					// ɂ錸WQ
	float					Theta ;							// X|bgCg̓R[̏Ɩpx( WA )
	float					Phi ;							// X|bgCg̊OR[̏Ɩpx
} LIGHTPARAM ;

// }eAp[^
typedef struct tagMATERIALPARAM
{
	COLOR_F					Diffuse ;						// fBt[YJ[
	COLOR_F					Ambient ;						// ArGgJ[
	COLOR_F					Specular ;						// XyLJ[
	COLOR_F					Emissive ;						// G~bVuJ[
	float					Power ;							// XyLnCCg̑Nx
} MATERIALPARAM ;

#endif // DX_NOTUSE_DRAWFUNCTION

// Cqbg`FbNʊi[p\
typedef struct tagHITRESULT_LINE
{
	int						HitFlag ;						// ǂ( 1:  0:Ȃ )
	VECTOR					Position ;						// W
} HITRESULT_LINE ;

// Cqbg`FbNʊi[p\
typedef struct tagHITRESULT_LINE_D
{
	int						HitFlag ;						// ǂ( 1:  0:Ȃ )
	VECTOR_D				Position ;						// W
} HITRESULT_LINE_D ;

// ֐ Segment_Segment_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagSEGMENT_SEGMENT_RESULT
{
	float					SegA_SegB_MinDist_Square ;		// `Ɛałڋ߂WԂ̋̓

	float					SegA_MinDist_Pos1_Pos2_t ;		// `Ɛaɍłڋ߂W̐` t ( 0.0f ` 1.0f Aŋߓ_W = ( SegAPos2 - SegAPos1 ) * t + SegAPos1 )
	float					SegB_MinDist_Pos1_Pos2_t ;		// a`ɍłڋ߂W̐a t ( 0.0f ` 1.0f Aŋߓ_W = ( SegBPos2 - SegBPos1 ) * t + SegBPos1 )

	VECTOR					SegA_MinDist_Pos ;				// `aɍłڋ߂`̍W
	VECTOR					SegB_MinDist_Pos ;				// a`ɍłڋ߂a̍W
} SEGMENT_SEGMENT_RESULT ;

// ֐ Segment_Segment_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagSEGMENT_SEGMENT_RESULT_D
{
	double					SegA_SegB_MinDist_Square ;		// `Ɛałڋ߂WԂ̋̓

	double					SegA_MinDist_Pos1_Pos2_t ;		// `Ɛaɍłڋ߂W̐` t ( 0.0 ` 1.0 Aŋߓ_W = ( SegAPos2 - SegAPos1 ) * t + SegAPos1 )
	double					SegB_MinDist_Pos1_Pos2_t ;		// a`ɍłڋ߂W̐a t ( 0.0 ` 1.0 Aŋߓ_W = ( SegBPos2 - SegBPos1 ) * t + SegBPos1 )

	VECTOR_D				SegA_MinDist_Pos ;				// `aɍłڋ߂`̍W
	VECTOR_D				SegB_MinDist_Pos ;				// a`ɍłڋ߂a̍W
} SEGMENT_SEGMENT_RESULT_D ;

// ֐ Segment_Point_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagSEGMENT_POINT_RESULT
{
	float					Seg_Point_MinDist_Square ;		// Ɠ_łڋ߂WԂ̋̓
	float					Seg_MinDist_Pos1_Pos2_t ;		// _ɍłڋ߂W̐ t ( 0.0f ` 1.0f Aŋߓ_W = ( SegPos2 - SegPos1 ) * t + SegPos1 )
	VECTOR					Seg_MinDist_Pos ;				// _ɍłڋ߂̍W
} SEGMENT_POINT_RESULT ;

// ֐ Segment_Point_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagSEGMENT_POINT_RESULT_D
{
	double					Seg_Point_MinDist_Square ;		// Ɠ_łڋ߂WԂ̋̓
	double					Seg_MinDist_Pos1_Pos2_t ;		// _ɍłڋ߂W̐ t ( 0.0 ` 1.0 Aŋߓ_W = ( SegPos2 - SegPos1 ) * t + SegPos1 )
	VECTOR_D				Seg_MinDist_Pos ;				// _ɍłڋ߂̍W
} SEGMENT_POINT_RESULT_D ;

// ֐ Segment_Triangle_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagSEGMENT_TRIANGLE_RESULT
{
	float					Seg_Tri_MinDist_Square ;		// ƎOp`łڋ߂WԂ̋̓

	float					Seg_MinDist_Pos1_Pos2_t ;		// Op`ɍłڋ߂W̐ t ( 0.0f ` 1.0f Aŋߓ_W = ( SegPos2 - SegPos1 ) * t + SegPos1 )
	VECTOR					Seg_MinDist_Pos ;				// Op`ɍłڋ߂̍W

	float					Tri_MinDist_Pos1_w ;			// Op`ɍłڋ߂W̎Op`WP̏d( ŋߓ_W = TriPos1 * TriPos1_w + TriPos2 * TriPos2_w + TriPos3 * TriPos3_w )
	float					Tri_MinDist_Pos2_w ;			// Op`ɍłڋ߂W̎Op`WQ̏d
	float					Tri_MinDist_Pos3_w ;			// Op`ɍłڋ߂W̎Op`WȐd
	VECTOR					Tri_MinDist_Pos ;				// Op`ɍłڋ߂Op`̍W
} SEGMENT_TRIANGLE_RESULT ;

// ֐ Segment_Triangle_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagSEGMENT_TRIANGLE_RESULT_D
{
	double					Seg_Tri_MinDist_Square ;		// ƎOp`łڋ߂WԂ̋̓

	double					Seg_MinDist_Pos1_Pos2_t ;		// Op`ɍłڋ߂W̐ t ( 0.0 ` 1.0 Aŋߓ_W = ( SegPos2 - SegPos1 ) * t + SegPos1 )
	VECTOR_D				Seg_MinDist_Pos ;				// Op`ɍłڋ߂̍W

	double					Tri_MinDist_Pos1_w ;			// Op`ɍłڋ߂W̎Op`WP̏d( ŋߓ_W = TriPos1 * TriPos1_w + TriPos2 * TriPos2_w + TriPos3 * TriPos3_w )
	double					Tri_MinDist_Pos2_w ;			// Op`ɍłڋ߂W̎Op`WQ̏d
	double					Tri_MinDist_Pos3_w ;			// Op`ɍłڋ߂W̎Op`WȐd
	VECTOR_D				Tri_MinDist_Pos ;				// Op`ɍłڋ߂Op`̍W
} SEGMENT_TRIANGLE_RESULT_D ;

// ֐ Triangle_Point_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagTRIANGLE_POINT_RESULT
{
	float					Tri_Pnt_MinDist_Square ;		// Op`Ɠ_łڋ߂WԂ̋̓

	float					Tri_MinDist_Pos1_w ;			// Op`_ɍłڋ߂W̎Op`WP̏d( ŋߓ_W = TriPos1 * TriPos1_w + TriPos2 * TriPos2_w + TriPos3 * TriPos3_w )
	float					Tri_MinDist_Pos2_w ;			// Op`_ɍłڋ߂W̎Op`WQ̏d
	float					Tri_MinDist_Pos3_w ;			// Op`_ɍłڋ߂W̎Op`WȐd
	VECTOR					Tri_MinDist_Pos ;				// Op`_ɍłڋ߂Op`̍W
} TRIANGLE_POINT_RESULT ;

// ֐ Triangle_Point_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagTRIANGLE_POINT_RESULT_D
{
	double					Tri_Pnt_MinDist_Square ;		// Op`Ɠ_łڋ߂WԂ̋̓

	double					Tri_MinDist_Pos1_w ;			// Op`_ɍłڋ߂W̎Op`WP̏d( ŋߓ_W = TriPos1 * TriPos1_w + TriPos2 * TriPos2_w + TriPos3 * TriPos3_w )
	double					Tri_MinDist_Pos2_w ;			// Op`_ɍłڋ߂W̎Op`WQ̏d
	double					Tri_MinDist_Pos3_w ;			// Op`_ɍłڋ߂W̎Op`WȐd
	VECTOR_D				Tri_MinDist_Pos ;				// Op`_ɍłڋ߂Op`̍W
} TRIANGLE_POINT_RESULT_D ;

// ֐ Plane_Point_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagPLANE_POINT_RESULT
{
	int						Pnt_Plane_Normal_Side ;			// _ʂ̖@̑ɂ邩ǂ( 1:@̑ɂ  0:@ƔΑɂ )
	float					Plane_Pnt_MinDist_Square ;		// ʂƓ_̋
	VECTOR					Plane_MinDist_Pos ;				// ʏ̓_Ƃ̍ŋߓ_W
} PLANE_POINT_RESULT ;

// ֐ Plane_Point_Analyse ̌ʂ󂯎ׂ̍\
typedef struct tagPLANE_POINT_RESULT_D
{
	int						Pnt_Plane_Normal_Side ;			// _ʂ̖@̑ɂ邩ǂ( 1:@̑ɂ  0:@ƔΑɂ )
	double					Plane_Pnt_MinDist_Square ;		// ʂƓ_̋
	VECTOR_D				Plane_MinDist_Pos ;				// ʏ̓_Ƃ̍ŋߓ_W
} PLANE_POINT_RESULT_D ;

#ifndef DX_NOTUSE_DRAWFUNCTION

// RWʑp|S
typedef struct tagMV1_COLL_RESULT_POLY
{
	int						HitFlag ;						// ( MV1CollCheck_Line ł̂ݗL )qbgtO( 1:qbg  0:qbgȂ )
	VECTOR					HitPosition ;					// ( MV1CollCheck_Line ł̂ݗL )qbgW

	int						FrameIndex ;					// |S܂܂t[̔ԍ
	int						MeshIndex ;						// |S܂܂郁bV̔ԍ( bVPʂŔ肵ꍇ̂ݗL )
	int						PolygonIndex ;					// |S̔ԍ
	int						MaterialIndex ;					// |SgpĂ}eA̔ԍ
	VECTOR					Position[ 3 ] ;					// |S`O_̍W
	VECTOR					Normal ;						// |S̖@
	float					PositionWeight[ 3 ] ;			// ẂA|S̎O_ꂼǂ̊ŉeĂ邩A̒l( W = Position[ 0 ] * PositionWeight[ 0 ] + Position[ 1 ] * PositionWeight[ 1 ] + Position[ 2 ] * PositionWeight[ 2 ] )
	int						PosMaxWeightFrameIndex[ 3 ] ;	// |S̍Wꂼłe󂯂Ăt[̔ԍ
} MV1_COLL_RESULT_POLY ;

// RWʑp|Sz
typedef struct tagMV1_COLL_RESULT_POLY_DIM
{
	int						HitNum ;						// qbg|S̐
	MV1_COLL_RESULT_POLY *	Dim ;							// qbg|S̔z( HitNum݂ )
} MV1_COLL_RESULT_POLY_DIM ;

// QƗp_\
typedef struct tagMV1_REF_VERTEX
{
	VECTOR					Position ;						// ʒu
	VECTOR					Normal ;						// @
	FLOAT2					TexCoord[ 2 ] ;					// eNX`W
	COLOR_U8				DiffuseColor ;					// fBt[YJ[
	COLOR_U8				SpecularColor ;					// XyLJ[
	int						MaxWeightFrameIndex ;			// ł傫ȉe^Ăt[( XLjObVp )
} MV1_REF_VERTEX ;

// QƗp|S\
typedef struct tagMV1_REF_POLYGON
{
	unsigned short			FrameIndex ;					// ̃|SĂt[
	unsigned short			MeshIndex ;						// ̃|SĂ郁bV
	unsigned short			MaterialIndex ;					// gpĂ}eA
	unsigned short			VIndexTarget ;					// VIndex wCfbNX̎QƐ( 1:t[  0:fS )
	int						VIndex[ 3 ] ;					// Rp`|S𐬂Qƒ_̃CfbNX
	VECTOR					MinPosition ;					// |S𐬂_W̍ŏl
	VECTOR					MaxPosition ;					// |S𐬂_W̍ől
} MV1_REF_POLYGON ;

// QƗp|Sf[^\
typedef struct tagMV1_REF_POLYGONLIST
{
	int						PolygonNum ;					// QƗp|S̐
	int						VertexNum ;						// _̐
	VECTOR					MinPosition ;					// _W̍ŏl
	VECTOR					MaxPosition ;					// _W̍ől
	MV1_REF_POLYGON	*		Polygons ;						// QƗp|Sz
	MV1_REF_VERTEX *		Vertexs ;						// QƗp_z
} MV1_REF_POLYGONLIST ;

#endif // DX_NOTUSE_DRAWFUNCTION




// RcTEho[uGtFNgp[^\
// ( ߂ MSDN  XAUDIO2FX_REVERB_PARAMETERS \̂̉قڈpĂ܂ )
typedef struct tagSOUND3D_REVERB_PARAM
{
	float					WetDryMix ;						// o[uƂȂo͂̊( w\͈ 0.0f ` 100.0f )

	unsigned int			ReflectionsDelay ;				// _CNg pXɑ΂鏉˂̒xԁAPʂ̓~b( w\͈ 0 ` 300 )
	BYTE					ReverbDelay ;					// ˂ɑ΂郊o[u̒xԁAPʂ̓~b( w\͈ 0 ` 85 )
	BYTE					RearDelay ;						// o͂щEo͂̒xԁAPʂ̓~b( w\͈ 0 ` 5 )

	BYTE					PositionLeft ;					// V~[VԂɂ鎋҂ɑ΂鍶͂̈ʒu( w\͈ 0 ` 30 )
															// PositionLeft ŏlɐݒ肵ꍇA͎͂҂̋߂ɔzu܂B
															// ̈ʒuł́ATEh tB[hɂď˂DɂȂAc͎܂āAUȂ܂B
															// PositionLeft őlɐݒ肵ꍇA͂̓V~[VŎ҂őʒuɔzu܂B
															// PositionLeft ͎c (̎c) ɉeA҂ɑ΂鉹̌̈ʒû݂ɉe܂B
	BYTE					PositionRight ;					// PositionLeft Ɠʂ̉E͒l( w\͈ 0 ` 30 )AE͂ɂ̂݉e^
	BYTE					PositionMatrixLeft ;			// 王҂܂ł̋ɂCvbV𑝌l( w\͈ 0 ` 30 )
	BYTE					PositionMatrixRight ;			// 王҂܂ł̋ɂCvbV𑝌ܒl( w\͈ 0 ` 30 )
	BYTE					EarlyDiffusion ;				// X̕ǂ̔˓l( w\͈ 0 ` 15 )A( ȕ\ʂV~[gɂ͏Ȓlݒ肵AU̕\ʂV~[gɂ͑傫Ȓlݒ肵܂B)
	BYTE					LateDiffusion ;					// X̕ǂ̃o[ul( w\͈ 0 ` 15 )A( ȕ\ʂV~[gɂ͏Ȓlݒ肵AU̕\ʂV~[gɂ͑傫Ȓlݒ肵܂B)
	BYTE					LowEQGain ;						// 1 kHz ɂ錸ԂɂĒǧԒl( w\͈ 0 ` 12 )
															// lƃQC (dB) ̊֌W
															// l          0  1  2  3  4  5  6  7  8  9 10 11 12
															// QC(dB) -8 -7 -6 -5 -4 -3 -2 -1  0 +1 +2 +3 +4
															// LowEQGain ̒l 8 ̏ꍇAǧԂ 1 kHz ɂ錸ԂȂ邱ƂɒӂĂ
	BYTE					LowEQCutoff ;					// LowEQGain p[^[ɂ萧䂳郍[pX tB^[̐ܓ_g̐ݒl( w\͈ 0 ` 9 )
															// lƎg (Hz) ̊֌W
															// l          0   1   2   3   4   5   6   7   8   9
															// g(Hz) 50 100 150 200 250 300 350 400 450 500
	BYTE					HighEQGain ;					// 1 kHz ɂ錸ԂɂčǧԒl( w\͈ 0 ` 8 )
															// lƃQC (dB) ̊֌W
															// l          0  1  2  3  4  5  6  7 8
															// QC(dB) -8 -7 -6 -5 -4 -3 -2 -1 0
															// 0 ɐݒ肷ƁAg̉ 1 kHz ̏ꍇƓŌ܂Bőlɐݒ肷ƁAg̉ 1 kHz ̏ꍇ͂邩ɍŌ܂B
	BYTE					HighEQCutoff ;					// HighEQGain p[^[ɂ萧䂳nCpX tB^[̐ܓ_gݒl( w\͈ 0 ` 14 )
															// lƎg (kHz) ̊֌W
															// l          0    1    2     3    4     5    6     7    8     9   10    11   12    13   14
															// g(kHz) 1  1.5    2   2.5    3   3.5    4   4.5    5   5.5    6   6.5    7   7.5    8

	float					RoomFilterFreq ;				// GtFNg̃[pX tB^[̐ܓ_gAPʂ Hz ( w\͈ 20.0f ` 20000.0f )
	float					RoomFilterMain ;				// ˂ƌtB[hc̗ɓKp郍[pX tB^[̃pX ohxxAPʂ dB ( w\͈ -100.0f ` 0.0f )
	float					RoomFilterHF ;					// ܓ_g (RoomFilterFreq) ł̏˂ƌtB[hc̗ɓKp郍[pX tB^[̃pX ohxxAPʂ dB ( w\͈ -100.0f ` 0.0f )
	float					ReflectionsGain ;				// ˂̋x/x𒲐lAPʂ dB ( w\͈ -100.0f ` 20.0f )
	float					ReverbGain ;					// o[űx/x𒲐lAPʂ dB ( w\͈ -100.0f ` 20.0f )
	float					DecayTime ;						// 1 kHz ɂcԁAPʂ͕b ( w\͈ 0.1f ` lɂȂ )ÁAt XP[̓͐M 60 dB ܂ł̎ԂłB
	float					Density ;						// tB[hc̃[hx𐧌lAPʂ̓p[Zg( w\͈ 0.0f ` 100.0f )
															// F (colorless) ̋Ԃł́ADensity ől (100.0f ) ɐݒ肷Kv܂B
															// Density ƁATEh͂ (`tB^[Kpꂽ) ɂȂ܂B
															// ̓TCV~[VƂɗLȃGtFNgłB
	float					RoomSize ;						// Ԃ̌̃TCYAPʂ̓tB[g( w\͈ 1.0f (30.48 cm) ` 100.0f (30.48 m) )
} SOUND3D_REVERB_PARAM ;





// Xg[f[^p֐|C^\̃^CvQ
typedef struct tagSTREAMDATASHREDTYPE2
{
	DWORD_PTR				(*Open		)( const TCHAR *Path, int UseCacheFlag, int BlockReadFlag, int UseASyncReadFlag ) ;
	int						(*Close		)( DWORD_PTR Handle ) ;
	LONGLONG				(*Tell		)( DWORD_PTR Handle ) ;
	int						(*Seek		)( DWORD_PTR Handle, LONGLONG SeekPoint, int SeekType ) ;
	size_t					(*Read		)( void *Buffer, size_t BlockSize, size_t DataNum, DWORD_PTR Handle ) ;
	int						(*Eof		)( DWORD_PTR Handle ) ;
	int						(*IdleCheck	)( DWORD_PTR Handle ) ;
	int						(*ChDir		)( const TCHAR *Path ) ;
	int						(*GetDir	)( TCHAR *Buffer ) ;
	int						(*GetDirS	)( TCHAR *Buffer, size_t BufferSize ) ;
	DWORD_PTR				(*FindFirst	)( const TCHAR *FilePath, FILEINFO *Buffer ) ;		// ߂l: -1=G[  -1ȊO=FindHandle
	int						(*FindNext	)( DWORD_PTR FindHandle, FILEINFO *Buffer ) ;		// ߂l: -1=G[  0=
	int						(*FindClose	)( DWORD_PTR FindHandle ) ;							// ߂l: -1=G[  0=
} STREAMDATASHREDTYPE2 ;

// Xg[f[^p֐|C^\̃^CvQ wchar_t gp
typedef struct tagSTREAMDATASHREDTYPE2W
{
	DWORD_PTR				(*Open		)( const wchar_t *Path, int UseCacheFlag, int BlockReadFlag, int UseASyncReadFlag ) ;
	int						(*Close		)( DWORD_PTR Handle ) ;
	LONGLONG				(*Tell		)( DWORD_PTR Handle ) ;
	int						(*Seek		)( DWORD_PTR Handle, LONGLONG SeekPoint, int SeekType ) ;
	size_t					(*Read		)( void *Buffer, size_t BlockSize, size_t DataNum, DWORD_PTR Handle ) ;
	int						(*Eof		)( DWORD_PTR Handle ) ;
	int						(*IdleCheck	)( DWORD_PTR Handle ) ;
	int						(*IsDXA		)( DWORD_PTR Handle ) ;									// ߂l: -1=G[  0=cwA[JCut@C̃t@Cł͂Ȃ  1=cwA[JCut@C̃t@C
	int						(*ChDir		)( const wchar_t *Path ) ;
	int						(*GetDir	)( wchar_t *Buffer ) ;
	int						(*GetDirS	)( wchar_t *Buffer, size_t BufferSize ) ;
	DWORD_PTR				(*FindFirst	)( const wchar_t *FilePath, FILEINFOW *Buffer ) ;		// ߂l: -1=G[  -1ȊO=FindHandle
	int						(*FindNext	)( DWORD_PTR FindHandle, FILEINFOW *Buffer ) ;			// ߂l: -1=G[  0=
	int						(*FindClose	)( DWORD_PTR FindHandle ) ;								// ߂l: -1=G[  0=
} STREAMDATASHREDTYPE2W ;

// Xg[f[^p֐|C^\
typedef struct tagSTREAMDATASHRED
{
	LONGLONG				(*Tell		)( DWORD_PTR StreamDataPoint ) ;
	int						(*Seek		)( DWORD_PTR StreamDataPoint, LONGLONG SeekPoint, int SeekType ) ;
	size_t					(*Read		)( void *Buffer, size_t BlockSize, size_t DataNum, DWORD_PTR StreamDataPoint ) ;
//	size_t					(*Write		)( void *Buffer, size_t BlockSize, size_t DataNum, DWORD_PTR StreamDataPoint ) ;
	int						(*Eof		)( DWORD_PTR StreamDataPoint ) ;
	int						(*IdleCheck	)( DWORD_PTR StreamDataPoint ) ;
	int						(*Close		)( DWORD_PTR StreamDataPoint ) ;
} STREAMDATASHRED, *LPSTREAMDATASHRED ;

// Xg[f[^pf[^\
typedef struct tagSTREAMDATA
{
	STREAMDATASHRED			ReadShred ;
	DWORD_PTR				DataPoint ;
} STREAMDATA ;





// pbg\
typedef struct tagCOLORPALETTEDATA
{
	unsigned char			Blue ;
	unsigned char			Green ;
	unsigned char			Red ;
	unsigned char			Alpha ;
} COLORPALETTEDATA ;

// J[\\
typedef struct tagCOLORDATA
{
	unsigned char			Format ;										// tH[}bg( DX_BASEIMAGE_FORMAT_NORMAL  )

	unsigned char			ChannelNum ;									// `l
	unsigned char			ChannelBitDepth ;								// P`lӂ̃rbg[x
	unsigned char			FloatTypeFlag ;									// _^ǂ( TRUE:_^  FALSE:^ )
	unsigned char			PixelByte ;										// PsNZ̃oCg

	// ȉ ChannelNum  ChannelBitDepth  0 ̎̂ݗL
	unsigned char			ColorBitDepth ;									// rbg[x
	unsigned char			NoneLoc, NoneWidth ;							// gĂȂrbg̃AhXƕ
	unsigned char			RedWidth, GreenWidth, BlueWidth, AlphaWidth ;	// eF̃rbg
	unsigned char			RedLoc	, GreenLoc  , BlueLoc  , AlphaLoc   ;	// eF̔zuĂrbgAhX
	unsigned int			RedMask , GreenMask , BlueMask , AlphaMask  ;	// eF̃rbg}XN
	unsigned int			NoneMask ;										// gĂȂrbg̃}XN
	int						MaxPaletteNo ;									// gpĂpbgԍ̍ől( 0 ̏ꍇ 255 Ƃ݂Ȃ )

	// memo : Ƀo[ϐǉ DxBaseImage.cpp  NS_GraphColorMatchBltVer2 ̃AZuł̃pbgf[^QƂ̃elCKv
	COLORPALETTEDATA		Palette[ 256 ] ;								// pbg( ColorBitDepth Wȉ̏ꍇ̂ݗL )
} COLORDATA, *LPCOLORDATA ;

// {C[Wf[^\
typedef struct tagBASEIMAGE
{
	COLORDATA				ColorData ;						// F
	int						Width, Height, Pitch ;			// AAsb`
	void					*GraphData ;					// OtBbNC[W
	int						MipMapCount ;					// ~bv}bv̐
	int						GraphDataCount ;				// OtBbNC[W̐
} BASEIMAGE, GRAPHIMAGE, *LPGRAPHIMAGE ;

// `f[^^
typedef struct tagRECTDATA
{
	int						x1, y1, x2, y2 ;				// W
	unsigned int			color ;							// F
	int						pal ;							// p[^
} RECTDATA, *LPRECTDATA ;

// Cf[^^
typedef struct tagLINEDATA
{
	int						x1, y1, x2, y2 ;				// W
	unsigned int			color ;							// F
	int						pal ;							// p[^
} LINEDATA, *LPLINEDATA ;

// Wf[^^
typedef struct tagPOINTDATA
{
	int						x, y ;							// W
	unsigned int			color ;							// F
	int						pal ;							// p[^
} POINTDATA, *LPPOINTDATA ;

// ̃f[^^
typedef struct tagCUBEDATA
{
	VECTOR					Pos1 ;							// W1
	VECTOR					Pos2 ;							// W2
	COLOR_U8				DifColor ;						// fBt[YJ[
	COLOR_U8				SpcColor ;						// XyLJ[
} CUBEDATA, *LPCUBEDATA ;

#ifndef DX_NOTUSE_DRAWFUNCTION

// C[WtH[}bgf[^
typedef struct tagIMAGEFORMATDESC
{
	unsigned char			TextureFlag ;					// eNX`AtO( TRUE:eNX`  FALSE:WT[tFX )
	unsigned char			CubeMapTextureFlag ;			// L[u}bveNX`AtO( TRUE:L[u}bveNX`@FALSE:ȊO )
	unsigned char			AlphaChFlag ;					// `l͂邩AtO	( TRUE:  FALSE:Ȃ )
	unsigned char			DrawValidFlag ;					// `\AtO( TRUE:\  FALSE:s\ )
	unsigned char			SystemMemFlag ;					// VXeɑ݂Ă邩AtO( TRUE:VXe  FALSE:uq`l )( WT[tFX̎̂ݗL )
	unsigned char			UseManagedTextureFlag ;			// }l[WheNX`gp邩AtO
	unsigned char			UseLinearMapTextureFlag ;		// eNX`̃f[^zuɃjAIłꍇ̓f[^zujAɂ邩ǂ( TRUE:jA\ȏꍇ̓jAɂ  FALSE:jA\ȏꍇɃjAw肵Ȃ )
	unsigned char			PlatformTextureFormat ;			// ˑ̃eNX`tH[}bg𒼐ڎw肷邽߂Ɏgp邽߂̕ϐ( DX_TEXTUREFORMAT_DIRECT3D9_R8G8B8 Ȃ )

	unsigned char			BaseFormat ;					// {tH[}bg( DX_BASEIMAGE_FORMAT_NORMAL  )
	unsigned char			MipMapCount ;					// ~bv}bv̐
	unsigned char			AlphaTestFlag ;					// eXg`l͂邩AtO( TRUE:  FALSE:Ȃ )( eNX`̏ꍇ̂ݗL )
	unsigned char			FloatTypeFlag ;					// _^ǂ
	unsigned char			ColorBitDepth ;					// F[x( eNX`̏ꍇ̂ݗL )
	unsigned char			ChannelNum ;					// `l̐
	unsigned char			ChannelBitDepth ;				// P`lӂ̃rbg[x( eNX`̏ꍇ̂ݗLA0 ̏ꍇ ColorBitDepth gp )
	unsigned char			BlendGraphFlag ;				// uhp摜AtO
	unsigned char			UsePaletteFlag ;				// pbggpĂ邩AtO( SystemMemFlag  TRUE ̏ꍇ̂ݗL )

	unsigned char			MSSamples ;						// }`TvO( `Ώۂ̏ꍇgp )
	unsigned char			MSQuality ;						// }`TvONIeB( `Ώۂ̏ꍇgp )
} IMAGEFORMATDESC ;

#endif // DX_NOTUSE_DRAWFUNCTION

// DirectInput ̃WCpbh͏
typedef struct tagDINPUT_JOYSTATE
{
	int						X ;								// XeBbN̂wp[^( -1000`1000 )
	int						Y ;								// XeBbN̂xp[^( -1000`1000 )
	int						Z ;								// XeBbN̂yp[^( -1000`1000 )
	int						Rx ;							// XeBbN̂w]p[^( -1000`1000 )
	int						Ry ;							// XeBbN̂x]p[^( -1000`1000 )
	int						Rz ;							// XeBbN̂y]p[^( -1000`1000 )
	int						Slider[ 2 ] ;					// XC_[( 0`65535 )
	unsigned int			POV[ 4 ] ;						// nbgXCb`S( 0xffffffff:͂Ȃ 0: 4500:E 9000:E 13500:E 18000: 22500: 27000: 31500: )
	unsigned char			Buttons[ 32 ] ;					// {^RQ( ꂽ{^ 128 ɂȂ )
} DINPUT_JOYSTATE ;

// XInput ̃WCpbh͏
typedef struct tagXINPUT_STATE
{
	unsigned char			Buttons[ 16 ] ;					// {^PU( Yɂ XINPUT_BUTTON_DPAD_UP gpA0:ĂȂ  1:Ă )
	unsigned char			LeftTrigger ;					// gK[( 0`255 )
	unsigned char			RightTrigger ;					// EgK[( 0`255 )
	short					ThumbLX ;						// XeBbN̉l( -32768 ` 32767 )
	short					ThumbLY ;						// XeBbN̏cl( -32768 ` 32767 )
	short					ThumbRX ;						// EXeBbN̉l( -32768 ` 32767 )
	short					ThumbRY ;						// EXeBbN̏cl( -32768 ` 32767 )
} XINPUT_STATE ;

// ^b`pl̂Pӏ̃^b`̏
typedef struct tagTOUCHINPUTPOINT
{
	DWORD					Device ;						// ^b`ꂽfoCX
	DWORD					ID ;							// ^b`𔻕ʂ邽߂̂hc
	int						PositionX ;						// ^b`ꂽWX
	int						PositionY ;						// ^b`ꂽWY
	float					Pressure ;						// 
	float					Orientation ;					// ʂ̏[ɑ΂ړ_̕ʊp
	float					Tilt ;							// ʂ̐ɑ΂ړ_̍xp
	int						ToolType ;						// c[^Cv( DX_TOUCHINPUT_TOOL_TYPE_UNKNOWN Ȃ )
} TOUCHINPUTPOINT ;

// ^b`pl̃^b`̏
typedef struct tagTOUCHINPUTDATA
{
	LONGLONG				Time ;							// ̎

	unsigned int			Source ;
	int						PointNum ;						// Lȃ^b`̐
	TOUCHINPUTPOINT			Point[ TOUCHINPUTPOINT_MAX ] ;	// ^b`
} TOUCHINPUTDATA ;






// WinSocketsgp̃AhXwp\
typedef struct tagIPDATA
{
	unsigned char			d1, d2, d3, d4 ;				// AhXl
} IPDATA, *LPIPDATA ;

typedef struct tagIPDATA_IPv6
{
	union
	{
		unsigned char			Byte[ 16 ] ;
		unsigned short			Word[ 8 ] ;
	} ;
	unsigned long				ScopeID ;
} IPDATA_IPv6 ;

#define DX_STRUCT_END


#ifndef DX_NON_NAMESPACE

}

#endif // DX_NON_NAMESPACE

// ֐vg^Cv錾------------------------------------------------------------------

#ifdef WINDOWS_DESKTOP_OS
#include "DxFunctionWin.h"
#endif // WINDOWS_DESKTOP_OS

#ifdef __ANDROID__
#include "DxFunctionAndroid.h"
#endif // __ANDROID__

#ifdef __APPLE__
    #include "TargetConditionals.h"
    #if TARGET_OS_IPHONE
		#include "DxFunctioniOS.h"
	#endif
#endif // __APPLE__






#ifndef DX_NON_NAMESPACE

namespace DxLib
{

#endif // DX_NON_NAMESPACE

#define DX_FUNCTION_START

// DxSystem.cpp֐vg^Cv錾

// In֐
extern	int			DxLib_Init( void ) ;													// Cus
extern	int			DxLib_End( void ) ;														// Cugp̌ns

extern	int			DxLib_GlobalStructInitialize( void ) ;									// Cu̓ŎgpĂ\̂[āADxLib_Init ̑Oɍsݒ𖳌( DxLib_Init ̑Oł̂ݗL )
extern	int			DxLib_IsInit( void ) ;													// CuĂ邩ǂ擾( ߂l: TRUE=Ă  FALSE=ĂȂ )

// G[֌W֐
extern	int			GetLastErrorCode( void ) ;												// ŌɔG[̃G[R[h擾( ߂l@0:G[ĂȂA̓G[R[ho͂ɑΉG[ĂȂ@@0ȊOFG[R[hADX_ERRORCODE_WIN_DESKTOP_24BIT_COLOR Ȃ )
extern	int			GetLastErrorMessage( TCHAR *StringBuffer, int StringBufferBytes ) ;		// ŌɔG[̃G[bZ[Ww̕obt@Ɏ擾

// bZ[W֐
extern	int			ProcessMessage( void ) ;												// EChEỸbZ[W[vɑ鏈s

// ݒn֐
extern	int			SetAlwaysRunFlag( int Flag ) ;											// AvANeBuԂłs邩ǂݒ肷( TRUE:s  FALSE:~( ftHg ) )
extern	int			SetNotDrawFlag( int Flag ) ;											// cwCu̕`@\gǂݒ肷( TRUE:gpȂ  FALSE:gp( ftHg ) )
extern	int			SetNotSoundFlag( int Flag ) ;											// cwCũTEh@\gǂݒ肷( TRUE:gpȂ  FALSE:gp( ftHg ) )
extern	int			SetNotInputFlag( int Flag ) ;											// cwCu̓͏Ԃ̎擾@\gǂݒ肷( TRUE:gpȂ  FALSE:gp( ftHg ) )

// EGCgn֐
extern	int			WaitTimer( int WaitTime ) ;												// w̎ԂƂ߂
#ifndef DX_NON_INPUT
extern	int			WaitKey( void ) ;														// L[̓͑҂s
#endif // DX_NON_INPUT
extern	int			SleepThread( int WaitTime ) ;											// w̎ԂXbh𖰂点

// JE^yю擾n֐
extern	int			GetNowCount(							int UseRDTSCFlag DEFAULTPARAM( = FALSE ) ) ;	// ~bPʂ̐xJE^݂̌̒l𓾂
extern	LONGLONG	GetNowHiPerformanceCount(				int UseRDTSCFlag DEFAULTPARAM( = FALSE ) ) ;	// GetNowCount̍xo[W( ʕbPʂ̐xJE^݂̌̒l𓾂 )
extern	ULONGLONG	GetNowSysPerformanceCount(				void ) ;						// OS񋟂鍂xJE^݂̌̒l𓾂
extern	ULONGLONG	GetSysPerformanceFrequency(				void ) ;						// OS񋟂鍂xJE^̎g( 1bӂ̃JEg )𓾂
extern	ULONGLONG	ConvSysPerformanceCountToSeconds(		ULONGLONG Count ) ;				// OS񋟂鍂xJE^̒lb̒lɕϊ
extern	ULONGLONG	ConvSysPerformanceCountToMilliSeconds(	ULONGLONG Count ) ;				// OS񋟂鍂xJE^̒l~b̒lɕϊ
extern	ULONGLONG	ConvSysPerformanceCountToMicroSeconds(	ULONGLONG Count ) ;				// OS񋟂鍂xJE^̒l}CNb̒lɕϊ
extern	ULONGLONG	ConvSysPerformanceCountToNanoSeconds(	ULONGLONG Count ) ;				// OS񋟂鍂xJE^̒limb̒lɕϊ
extern	ULONGLONG	ConvSecondsToSysPerformanceCount(		ULONGLONG Seconds ) ;			// b̒lOS񋟂鍂xJE^̒lɕϊ
extern	ULONGLONG	ConvMilliSecondsToSysPerformanceCount(	ULONGLONG MilliSeconds ) ;		// ~b̒lOS񋟂鍂xJE^̒lɕϊ
extern	ULONGLONG	ConvMicroSecondsToSysPerformanceCount(	ULONGLONG MicroSeconds ) ;		// }CNb̒lOS񋟂鍂xJE^̒lɕϊ
extern	ULONGLONG	ConvNanoSecondsToSysPerformanceCount(	ULONGLONG NanoSeconds ) ;		// imb̒lOS񋟂鍂xJE^̒lɕϊ
extern	int			GetDateTime(							DATEDATA *DateBuf ) ;			// ݎ擾 

// 擾
extern	int			GetRand( int RandMax ) ;												// 擾( RandMax : Ԃėl̍ől )
extern	int			SRand(	 int Seed ) ;													// ̏lݒ肷

#ifndef DX_NON_MERSENNE_TWISTER
extern	DWORD		GetMersenneTwisterRand( void ) ;										// ZkEcCX^[ASYŐꂽl𖳉HŎ擾

extern	DWORD_PTR	CreateRandHandle( int Seed DEFAULTPARAM( = -1 ) ) ;						// nh쐬( ߂l@0ȊO:nh@0:G[ )
extern	int			DeleteRandHandle( DWORD_PTR RandHandle ) ;								// nh폜
extern	int			SRandHandle( DWORD_PTR RandHandle, int Seed ) ;							// nh̏lĐݒ肷
extern	int			GetRandHandle( DWORD_PTR RandHandle, int RandMax ) ;					// nhgpė擾( RandMax : Ԃėl̍ől )
extern	DWORD		GetMersenneTwisterRandHandle( DWORD_PTR RandHandle ) ;					// nhgpăZkEcCX^[ASYŐꂽl𖳉HŎ擾

#endif // DX_NON_MERSENNE_TWISTER

// obe[֘A
extern	int			GetBatteryLifePercent( void ) ;											// dr̎cʂ % Ŏ擾( ߂lF 100=t[d  0=[dcʖ )

// Nbv{[h֌W
extern	int			GetClipboardText(			TCHAR *DestBuffer, int DestBufferBytes DEFAULTPARAM( = -1 ) ) ;		// Nbv{[hɊi[ĂeLXgf[^ǂݏo( DestBuffer:i[obt@̐擪AhX   ߂l  -1:Nbv{[hɃeLXgf[^  -1ȊO:Nbv{[hɊi[Ă镶f[^̃TCY( P:byte ) ) 
extern	int			SetClipboardText(			const TCHAR *Text                    ) ;	// Nbv{[hɃeLXgf[^i[
extern	int			SetClipboardTextWithStrLen(	const TCHAR *Text, size_t TextLength ) ;	// Nbv{[hɃeLXgf[^i[

// init@C֌W
extern	int			GetPrivateProfileStringDx(                 const TCHAR *AppName,                       const TCHAR *KeyName,                       const TCHAR *Default,                       TCHAR *ReturnedStringBuffer, size_t ReturnedStringBufferBytes, const TCHAR *IniFilePath,                           int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileString ̂cwCu
extern	int			GetPrivateProfileStringDxWithStrLen(       const TCHAR *AppName, size_t AppNameLength, const TCHAR *KeyName, size_t KeyNameLength, const TCHAR *Default, size_t DefaultLength, TCHAR *ReturnedStringBuffer, size_t ReturnedStringBufferBytes, const TCHAR *IniFilePath, size_t IniFilePathLength, int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileString ̂cwCu
extern	int			GetPrivateProfileIntDx(                    const TCHAR *AppName,                       const TCHAR *KeyName,                       int          Default,                                                                                      const TCHAR *IniFilePath,                           int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileInt ̂cwCu
extern	int			GetPrivateProfileIntDxWithStrLen(          const TCHAR *AppName, size_t AppNameLength, const TCHAR *KeyName, size_t KeyNameLength, int          Default,                                                                                      const TCHAR *IniFilePath, size_t IniFilePathLength, int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileInt ̂cwCu
extern	int			GetPrivateProfileStringDxForMem(           const TCHAR *AppName,                       const TCHAR *KeyName,                       const TCHAR *Default,                       TCHAR *ReturnedStringBuffer, size_t ReturnedStringBufferBytes, const void *IniFileImage, size_t IniFileImageBytes, int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileStringDx ̃ǂݍޔ
extern	int			GetPrivateProfileStringDxForMemWithStrLen( const TCHAR *AppName, size_t AppNameLength, const TCHAR *KeyName, size_t KeyNameLength, const TCHAR *Default, size_t DefaultLength, TCHAR *ReturnedStringBuffer, size_t ReturnedStringBufferBytes, const void *IniFileImage, size_t IniFileImageBytes, int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileStringDx ̃ǂݍޔ
extern	int			GetPrivateProfileIntDxForMem(              const TCHAR *AppName,                       const TCHAR *KeyName,                       int          Default,                                                                                      const void *IniFileImage, size_t IniFileImageBytes, int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileIntDx ̃ǂݍޔ
extern	int			GetPrivateProfileIntDxForMemWithStrLen(    const TCHAR *AppName, size_t AppNameLength, const TCHAR *KeyName, size_t KeyNameLength, int          Default,                                                                                      const void *IniFileImage, size_t IniFileImageBytes, int IniFileCharCodeFormat DEFAULTPARAM( = -1 ) /* DX_CHARCODEFORMAT_SHIFTJIS A-1 ŃftHg */ ) ;		// GetPrivateProfileIntDx ̃ǂݍޔ

#if defined( __APPLE__ ) || defined( __ANDROID__ )

// [Av𑗐M[ҏWԂŋN
// MailAddr    : ( NULL Ŗ )A[AhXꍇ̓J}w,xŋ؂Ă
// MailCCAddr  : CC ̈( NULL Ŗ )A[AhXꍇ̓J}w,xŋ؂Ă
// MailBCCAddr : BCC ̈( NULL Ŗ )A[AhXꍇ̓J}w,xŋ؂Ă
// Subject     : ^Cg( NULL Ŗ )A[AhXꍇ̓J}w,xŋ؂Ă
// Text        : {( NULL Ŗ )A[AhXꍇ̓J}w,xŋ؂Ă
extern	int			MailApp_Send(           const TCHAR *MailAddr DEFAULTPARAM( = NULL ) ,                                             const TCHAR *MailCCAddr DEFAULTPARAM( = NULL ) ,                                               const TCHAR *MailBCCAddr DEFAULTPARAM( = NULL ) ,                                                const TCHAR *Subject DEFAULTPARAM( = NULL ) ,                                            const TCHAR *Text DEFAULTPARAM( = NULL )                                         ) ;
extern	int			MailApp_SendWithStrLen( const TCHAR *MailAddr DEFAULTPARAM( = NULL ) , size_t MailAddrLength DEFAULTPARAM( = 0 ) , const TCHAR *MailCCAddr DEFAULTPARAM( = NULL ) , size_t MailCCAddrLength DEFAULTPARAM( = 0 ) , const TCHAR *MailBCCAddr DEFAULTPARAM( = NULL ) , size_t MailBCCAddrLength DEFAULTPARAM( = 0 ) , const TCHAR *Subject DEFAULTPARAM( = NULL ) , size_t SubjectLength DEFAULTPARAM( = 0 ) , const TCHAR *Text DEFAULTPARAM( = NULL ) , size_t TextLength DEFAULTPARAM( = 0 ) ) ;

#endif // defined( __APPLE__ ) || defined( __ANDROID__ )











// DxLog.cpp֐vg^Cv錾

#ifndef DX_NON_LOG
// Ot@C֐
extern	int			LogFileAdd(				const TCHAR *String ) ;							// Ot@C( Log.txt ) ɕo͂
extern	int			LogFileAddWithStrLen(	const TCHAR *String, size_t StringLength ) ;	// Ot@C( Log.txt ) ɕo͂
extern 	int			LogFileFmtAdd(			const TCHAR *FormatString , ... ) ;				// t Ot@C( Log.txt ) ɕo͂(  printf Ɠ )
extern	int			LogFileTabAdd(			void ) ;										// Ot@C( Log.txt ) ɏo͂镶̑Oɕt^u̐₷
extern	int			LogFileTabSub(			void ) ;										// Ot@C( Log.txt ) ɏo͂镶̑Oɕt^u̐炷
extern	int			ErrorLogAdd(			const TCHAR *String ) ;							// LogFileAdd ̋̊֐
extern 	int			ErrorLogFmtAdd(			const TCHAR *FormatString , ... ) ;				// LogFileFmtAdd ̋̊֐
extern	int			ErrorLogTabAdd(			void ) ;										// LogFileTabAdd ̋̊֐
extern	int			ErrorLogTabSub(			void ) ;										// LogFileTabSub ̋̊֐
extern	int			SetUseTimeStampFlag(	int UseFlag ) ;									// Ot@C( Log.txt ) ɏo͂镶̑OɋNĂ̎Ԃt邩ǂݒ肷( TRUE:t( ftHg)  FALSE:tȂ )
extern 	int			AppLogAdd(				const TCHAR *String , ... ) ;					// LogFileFmtAdd Ɠ@\̊֐

// Oo͐ݒ֐
extern	int			SetOutApplicationLogValidFlag(	          int Flag ) ;													// Ot@C( Log.txt ) 쐬邩ǂݒ肷( TRUE:쐬( ftHg )  FALSE:쐬Ȃ )ADxLib_Init ̑Oł̂ݎgp\@
extern	int			SetOutApplicationSystemLogValidFlag(      int Flag ) ;													// Ot@C( Log.txt ) ɂcwCũOo͂sǂݒ肷( TRUE:cwCũOo͂s( ftHg )  FALSE:cwCũOo͂sȂ )
extern	int			SetApplicationLogFileName(                const TCHAR *FileName ) ;										// Ot@C̖Oݒ肷( Log.txt ȊOɂꍇɎgp )
extern	int			SetApplicationLogFileNameWithStrLen(      const TCHAR *FileName, size_t FileNameLength ) ;				// Ot@C̖Oݒ肷( Log.txt ȊOɂꍇɎgp )
extern	int			SetApplicationLogSaveDirectory(	          const TCHAR *DirectoryPath ) ;								// Ot@C( Log.txt ) ۑfBNgpXݒ肷
extern	int			SetApplicationLogSaveDirectoryWithStrLen( const TCHAR *DirectoryPath, size_t DirectoryPathLength ) ;	// Ot@C( Log.txt ) ۑfBNgpXݒ肷
extern	int			SetUseDateNameLogFile(			          int Flag ) ;													// Ot@Cɓt邩ǂZbg( TRUE:t  FALSE:tȂ( ftHg ) )

#ifndef DX_NON_PRINTF_DX

// Oo͋@\֐
extern	int			SetLogDrawOutFlag(	 int DrawFlag ) ;									// printfDx ̌ʂʂɏo͂邩ǂݒ肷ATRUE:o͂s  FALSE:o͂sȂ( printfDx sƓ SetLogDrawOutFlag( TRUE ) ; Ă΂܂ )
extern 	int			GetLogDrawFlag(		 void ) ;											// printfDx ̌ʂʂɏo͂邩ǂ̐ݒ擾( ߂l  TRUE:o͂s  FALSE:o͂sȂ )
extern	int			SetLogFontSize(		 int Size ) ;										// printfDx ̌ʂʂɏo͂ۂɎgptHg̃TCYݒ肷
extern	int			SetLogFontHandle(	 int FontHandle ) ;									// printfDx ̌ʂʂɏo͂ۂɎgptHg̃nhύX
extern	int			SetLogDrawArea(		 int x1, int y1, int x2, int y2 ) ;					// printfDx ̌ʂʂɏo͂ۂ̕`悷̈ݒ肷

// ȈՉʏo͊֐
extern 	int			printfDx(			 const TCHAR *FormatString , ... ) ;												// printf Ɠŉʂɕ\邽߂̊֐
extern	int			putsDx(				 const TCHAR *String, int NewLine DEFAULTPARAM( = TRUE ) ) ;						// puts Ɠŉʂɕ\邽߂̊֐
extern	int			putsDxWithStrLen(	 const TCHAR *String, size_t StringLength, int NewLine DEFAULTPARAM( = TRUE ) ) ;	// puts Ɠŉʂɕ\邽߂̊֐
extern	int			clsDx(				 void ) ;																			// printfDx ̌ʂZbg邽߂̊֐
extern	int			setPrintColorDx(     int Color, int EdgeColor DEFAULTPARAM( = 0 ) ) ;													// printf  puts ŕ\镶̐Fw肷
#endif // DX_NON_PRINTF_DX

#endif // DX_NON_LOG












#ifndef DX_NON_ASYNCLOAD

// DxASyncLoad.cpp֐vg^Cv錾

// 񓯊ǂݍ݊֌W
extern	int			SetUseASyncLoadFlag(			int Flag ) ;										// ǂݍݏn̊֐Ŕ񓯊ǂݍ݂sǂݒ肷( 񓯊ǂݍ݂ɑΉĂ֐̂ݗL )( TRUE:񓯊ǂݍ݂s  FALSE:񓯊ǂݍ݂sȂ( ftHg ) )
extern	int			GetUseASyncLoadFlag(			void ) ;											// ǂݍݏn̊֐Ŕ񓯊ǂݍ݂sǂ擾( 񓯊ǂݍ݂ɑΉĂ֐̂ݗL )( TRUE:񓯊ǂݍ݂s  FALSE:񓯊ǂݍ݂sȂ( ftHg ) )
extern	int			CheckHandleASyncLoad(			int Handle ) ;										// nh̔񓯊ǂݍ݂Ă邩ǂ擾( TRUE:܂ĂȂ  FALSE:Ă  -1:G[ )
extern	int			GetHandleASyncLoadResult(		int Handle ) ;										// nh̔񓯊ǂݍݏ̖߂l擾( 񓯊ǂݍݒ̏ꍇ͈O̔񓯊ǂݍݏ̖߂lԂĂ܂ )
extern	int			SetASyncLoadFinishDeleteFlag(	int Handle ) ;										// nh̔񓯊ǂݍݏnh폜tO𗧂Ă
extern	int			SetASyncLoadFinishCallback(		int Handle, void ( *Callback )( int Handle, void *Data ), void *Data ) ;	// nh̔񓯊ǂݍݏĂ΂֐Zbg
extern	int			WaitHandleASyncLoad(			int Handle ) ;										// w̃nh̔񓯊ǂݍݏI܂ő҂
extern	int			WaitHandleASyncLoadAll(			void ) ;											// SĂ̔񓯊ǂݍ݃f[^ǂݍݏI܂ő҂
extern	int			GetASyncLoadNum(				void ) ;											// 񓯊ǂݍݒ̏̐擾
extern	int			SetASyncLoadThreadNum(			int ThreadNum ) ;									// 񓯊ǂݍݏsXbh̐ݒ肷( ThreadNum Ɏwł鐔 1 ` 32 )

#endif // DX_NON_ASYNCLOAD











// DxHandle.cpp֐vg^Cv錾

extern	int			SetDeleteHandleFlag(		int Handle, int *DeleteFlag ) ;							// nh폜ꂽƂɁ|Pݒ肳ϐo^
extern	int			GetHandleNum(				int HandleType /* DX_HANDLETYPE_GRAPH */ ) ;			// w̃^Cṽnh̐擾
extern	int			GetMaxHandleNum(			int HandleType /* DX_HANDLETYPE_GRAPH */ ) ;			// w̃^CṽnhőŊ쐬ł邩擾
extern	int			DumpHandleInfo(				int HandleType /* DX_HANDLETYPE_GRAPH */ ) ;			// w̃^Cv̑Snh̏Oɏo͂














// }EX֌W֐
extern	int			SetMouseDispFlag(		int DispFlag ) ;												// }EX|C^̕\Ԃݒ肷( DispFlag:}EX|C^\邩ǂ( TRUE:\  FALSE:\Ȃ )
extern	int			SetMouseDispIgnoreMenuFlag(	int IgnoreMenuFlag ) ;										// }EX|C^̕\Ԃɂăj[̕\Ԃ𖳎邩ǂݒ肷( TRUE:j[̕\Ԃ𖳎  FALSE:j[̕\Ԃl( ftHg ) )
#ifndef DX_NON_INPUT
extern	int			GetMousePoint(			int *XBuf, int *YBuf ) ;										// }EX|C^̈ʒu擾
extern	int			SetMousePoint(			int PointX, int PointY ) ;										// }EX|C^̈ʒuݒ肷
extern	int			GetMouseInput(			void ) ;														// }EX̃{^̉Ԃ擾
extern	int			GetMouseWheelRotVol(	int CounterReset DEFAULTPARAM( = TRUE ) ) ;						// }EXzC[̉]ʂ擾
extern	int			GetMouseHWheelRotVol(	int CounterReset DEFAULTPARAM( = TRUE ) ) ;						// }EXzC[̉]ʂ擾
extern	float		GetMouseWheelRotVolF(	int CounterReset DEFAULTPARAM( = TRUE ) ) ;						// }EXzC[̉]ʂ擾( ߂l float ^ )
extern	float		GetMouseHWheelRotVolF(	int CounterReset DEFAULTPARAM( = TRUE ) ) ;						// }EXzC[̉]ʂ擾( ߂l float ^ )
extern	int			GetMouseInputLog(		int *Button, int *ClickX, int *ClickY, int LogDelete DEFAULTPARAM( = TRUE ) ) ;					// }EX̃{^擾( Button:ꂽ{^( MOUSE_INPUT_LEFT  )i[ϐ̃AhX  ClickX:ꂽ̂wWi[ϐ̃AhX  ClickY:ꂽ̂xWi[ϐ̃AhX   LogDelete:擾O폜邩ǂ( TRUE:폜  FALSE:폜ȂA܂莟ɂ̊֐Ă΂ꂽƂɓl擾邱ƂɂȂ )@@߂l  0:ꂽ擾ł@-1:ꂽ񂪖A܂ǑĂяo( ܂͋Nŏ̌Ăяo )̊ԂɈx}EX̃{^Ȃ )
extern	int			GetMouseInputLog2(		int *Button, int *ClickX, int *ClickY, int *LogType, int LogDelete DEFAULTPARAM( = TRUE ) ) ;	// }EX̃{^藣肵擾( Button:ꂽ藣ꂽ肵{^( MOUSE_INPUT_LEFT  )i[ϐ̃AhX  ClickX:ꂽ藣ꂽ肵̂wWi[ϐ̃AhX  ClickY:ꂽ藣ꂽ肵̂xWi[ϐ̃AhX  LogTypeFꂽ̂( MOUSE_INPUT_LOG_DOWN )ꂽ̂( MOUSE_INPUT_LOG_UP )Ȁi[ϐ̃AhX  LogDelete:擾ꂽ藣ꂽ肵O폜邩ǂ( TRUE:폜  FALSE:폜ȂA܂莟ɂ̊֐Ă΂ꂽƂɓl擾邱ƂɂȂ )@@߂l  0:ꂽ藣ꂽ肵擾ł@-1:ꂽ藣ꂽ肵񂪖A܂ǑĂяo( ܂͋Nŏ̌Ăяo )̊ԂɈx}EX̃{^ꂽ藣ꂽ肵Ȃ )
#endif // DX_NON_INPUT












// ^b`pl͊֌W֐
#ifndef DX_NON_INPUT
extern	int				GetTouchInputNum( void ) ;																				// ^b`Ă鐔擾
extern	int				GetTouchInput( int InputNo, int *PositionX, int *PositionY, int *ID DEFAULTPARAM( = NULL ) , int *Device DEFAULTPARAM( = NULL ) , float *Pressure DEFAULTPARAM( = NULL ) ) ;		// ^b`̏擾

extern	int				GetTouchInputLogNum( void ) ;																			// XgbNĂ^b`̐擾
extern	int				ClearTouchInputLog( void ) ;																			// XgbNĂ^b`NA
extern	TOUCHINPUTDATA	GetTouchInputLogOne( int PeekFlag DEFAULTPARAM( = FALSE ) ) ;											// XgbNĂ^b`񂩂ԌÂЂƂ擾
extern	int				GetTouchInputLog( TOUCHINPUTDATA *TouchData, int GetNum, int PeekFlag DEFAULTPARAM( = FALSE ) ) ;		// XgbNĂ^b`񂩂ÂɎw萔obt@Ɏ擾( ߂l  -1:G[  0ȏ:擾̐ )

extern	int				GetTouchInputDownLogNum( void ) ;																		// XgbNĂ^b`n߂̐擾
extern	int				ClearTouchInputDownLog( void ) ;																		// XgbNĂ^b`n߂NA
extern	TOUCHINPUTPOINT	GetTouchInputDownLogOne( int PeekFlag DEFAULTPARAM( = FALSE ) ) ;										// XgbNĂ^b`n߂񂩂ԌÂЂƂ擾
extern	int				GetTouchInputDownLog( TOUCHINPUTPOINT *PointData, int GetNum, int PeekFlag DEFAULTPARAM( = FALSE ) ) ;	// XgbNĂ^b`n߂񂩂ÂɎw萔obt@Ɏ擾( ߂l  -1:G[  0ȏ:擾̐ )

extern	int				GetTouchInputUpLogNum( void ) ;																			// XgbNĂ^b`ꂽ̐擾
extern	int				ClearTouchInputUpLog( void ) ;																			// XgbNĂ^b`ꂽNA
extern	TOUCHINPUTPOINT	GetTouchInputUpLogOne( int PeekFlag DEFAULTPARAM( = FALSE ) ) ;											// XgbNĂ^b`ꂽ񂩂ԌÂЂƂ擾
extern	int				GetTouchInputUpLog( TOUCHINPUTPOINT *PointData, int GetNum, int PeekFlag DEFAULTPARAM( = FALSE ) ) ;	// XgbNĂ^b`ꂽ񂩂ÂɎw萔obt@Ɏ擾( ߂l  -1:G[  0ȏ:擾̐ )

#endif // DX_NON_INPUT















// DxMemory.cpp֐vg^Cv錾

// mیn֐
extern	void*		DxAlloc(						               size_t AllocSize ,                    const char *File DEFAULTPARAM( = NULL ) , int Line DEFAULTPARAM( = -1 ) ) ;	// w̃TCỸmۂ( AllocSize:mۂ郁̃TCY( P:byte )  File:DxAllocĂ񂾃\[Xt@C( fobOp )  Line:DxAllocĂ񂾃\[Xt@C̍sԍ( fobOp )@@߂l  NULL:̊mێs   NULLȊO:mۂ̈̐擪AhX )
extern	void*		DxAllocAligned(					               size_t AllocSize , size_t Alignment , const char *File DEFAULTPARAM( = NULL ) , int Line DEFAULTPARAM( = -1 ) ) ;	// w̃TCỸmۂ( ACw )( AllocSize:mۂ郁̃TCY( P:byte )  Alignment:mۂ郁̈̃AhXl̔{  File:DxAllocĂ񂾃\[Xt@C( fobOp )  Line:DxAllocĂ񂾃\[Xt@C̍sԍ( fobOp )@@߂l  NULL:̊mێs   NULLȊO:mۂ̈̐擪AhX )
extern	void*		DxCalloc(						               size_t AllocSize ,                    const char *File DEFAULTPARAM( = NULL ) , int Line DEFAULTPARAM( = -1 ) ) ;	// w̃TCỸmۂāAOŖ߂AɂOŖ߂ȊO DxAlloc Ɠ͓
extern	void*		DxCallocAligned(				               size_t AllocSize , size_t Alignment , const char *File DEFAULTPARAM( = NULL ) , int Line DEFAULTPARAM( = -1 ) ) ;	// w̃TCỸmۂāAOŖ߂AɂOŖ߂ȊO DxAllocAligned Ɠ͓
extern	void*		DxRealloc(						void *Memory , size_t AllocSize ,                    const char *File DEFAULTPARAM( = NULL ) , int Line DEFAULTPARAM( = -1 ) ) ;	// ̍Ċmۂs( Memory:Ċmۂs̈̐擪AhX( DxAlloc ̖߂l )  AllocSize:VmۃTCY@FileLine ̐ DxAlloc ̒߂̒ʂ @߂l NULL:̍Ċmێs@NULLȊO:ĊmۂV̈̐擪AhX@)
extern	void*		DxReallocAligned(				void *Memory , size_t AllocSize , size_t Alignment , const char *File DEFAULTPARAM( = NULL ) , int Line DEFAULTPARAM( = -1 ) ) ;	// ̍Ċmۂs( ACw )( Memory:Ċmۂs̈̐擪AhX( DxAlloc ̖߂l )  AllocSize:VmۃTCY   Alignment:Vmۂ郁̈̃AhXl̔{@FileLine ̐ DxAlloc ̒߂̒ʂ @߂l NULL:̍Ċmێs@NULLȊO:ĊmۂV̈̐擪AhX@)
extern	void		DxFree(							void *Memory ) ;																				// ( Memory:郁̈̐擪AhX( DxAlloc ̖߂l ) )
extern	size_t		DxSetAllocSizeTrap(				size_t Size ) ;																					// 񋓑Ώۂɂ郁̊mۗeʂZbg
extern	int			DxSetAllocPrintFlag(			int Flag ) ;																					// cwCuŃmۂs鎞ɏo͂邩ǂZbg
extern	size_t		DxGetAllocSize(					void ) ;																						// DxAlloc  DxCalloc ŊmۂĂ郁TCY擾
extern	int			DxGetAllocNum(					void ) ;																						// DxAlloc  DxCalloc ŊmۂĂ郁̐擾
extern	void		DxDumpAlloc(					void ) ;																						// DxAlloc  DxCalloc ŊmۂĂ郁񋓂
extern	void		DxDrawAlloc(					int x, int y, int Width, int Height ) ;															// DxAlloc  DxCalloc ŊmۂĂ郁̏󋵂`悷
extern	int			DxErrorCheckAlloc(				void ) ;																						// mۂ񂪔j󂳂ĂȂׂ( -1:j󂠂  0:Ȃ )
extern	int			DxSetAllocSizeOutFlag(			int Flag ) ;																					// mہAsxɊmۂĂ郁̗eʂo͂邩ǂ̃tOZbg
extern	int			DxSetAllocMemoryErrorCheckFlag(	int Flag ) ;																					// ̊mہAsxɊmۂĂ郁mۏ񂪔jĂȂׂ邩ǂ̃tOZbg














// DxBaseFunc.cpp ֐vg^Cv錾

// R[h֌W
extern	int				GetCharBytes( int CharCodeFormat /* DX_CHARCODEFORMAT_SHIFTJIS  */ , const void *String ) ;	// ̐擪̃̕oCg擾
extern	int				ConvertStringCharCodeFormat( int SrcCharCodeFormat /* DX_CHARCODEFORMAT_SHIFTJIS  */ , const void *SrcString, int DestCharCodeFormat /* DX_CHARCODEFORMAT_SHIFTJIS  */ , void *DestStringBuffer ) ;		// ̕R[h`ʂ̕R[h`ɕϊ
extern	int				SetUseCharCodeFormat( int CharCodeFormat /* DX_CHARCODEFORMAT_SHIFTJIS  */ ) ;		// ̈̕R[h`ݒ肷( `n֐Ƃ̑ꕔ֐ )( UNICODEłł͖ )
extern	int				GetUseCharCodeFormat( void ) ;															// ̈̕R[h`擾( ߂lFR[h`( DX_CHARCODEFORMAT_SHIFTJIS  ) )( UNICODEłł͖ )
extern	int				Get_wchar_t_CharCodeFormat( void ) ;													// wchar_t^̕R[h`擾( ߂lF DX_CHARCODEFORMAT_UTF16LE Ȃ )

// ֌W
extern	void			strcpyDx(      TCHAR *Dest,                   const TCHAR *Src ) ;						// strcpy Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strcpy_sDx(    TCHAR *Dest, size_t DestBytes, const TCHAR *Src ) ;						// strcpy_s Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpcpyDx(     TCHAR *Dest,                   const TCHAR *Src, int Pos ) ;				// ʒuwt strcpyAPos ̓Rs[Jnʒu@( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpcpy_sDx(   TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Pos ) ;				// ʒuwt strcpy_sAPos ̓Rs[Jnʒu@( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpcpy2Dx(    TCHAR *Dest,                   const TCHAR *Src, int Pos ) ;				// ʒuwt strcpyAPos ̓Rs[Jnʒu( Sp 1  )@( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpcpy2_sDx(  TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Pos ) ;				// ʒuwt strcpy_sAPos ̓Rs[Jnʒu( Sp 1  )@( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strncpyDx(     TCHAR *Dest,                   const TCHAR *Src, int Num ) ;				// strncpy Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strncpy_sDx(   TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Num ) ;				// strncpy_s Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strncpy2Dx(    TCHAR *Dest,                   const TCHAR *Src, int Num ) ;				// strncpy  Num ( Sp 1  )ɂȂ́AI[ɕKk( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strncpy2_sDx(  TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Num ) ;				// strncpy_s  Num ( Sp 1  )ɂȂ́AI[ɕKk( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strrncpyDx(    TCHAR *Dest,                   const TCHAR *Src, int Num ) ;				// strncpy ̏̕I[̕w( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strrncpy_sDx(  TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Num ) ;				// strncpy_s ̏̕I[̕w( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strrncpy2Dx(   TCHAR *Dest,                   const TCHAR *Src, int Num ) ;				// strncpy ̏̕I[̕( Sp 1  )wŁAI[ɕKk( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strrncpy2_sDx( TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Num ) ;				// strncpy_s ̏̕I[̕( Sp 1  )wŁAI[ɕKk( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpncpyDx(    TCHAR *Dest,                   const TCHAR *Src, int Pos, int Num ) ;	// strncpy ̃Rs[JnʒuwŁAPos ̓Rs[JnʒuANum ͕( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpncpy_sDx(  TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Pos, int Num ) ;	// strncpy_s ̃Rs[JnʒuwŁAPos ̓Rs[JnʒuANum ͕( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpncpy2Dx(   TCHAR *Dest,                   const TCHAR *Src, int Pos, int Num ) ;	// strncpy ̃Rs[JnʒuwŁAPos ̓Rs[Jnʒu( Sp 1  )ANum ͕( Sp 1  )AI[ɕKk( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strpncpy2_sDx( TCHAR *Dest, size_t DestBytes, const TCHAR *Src, int Pos, int Num ) ;	// strncpy_s ̃Rs[JnʒuwŁAPos ̓Rs[Jnʒu( Sp 1  )ANum ͕( Sp 1  )AI[ɕKk( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strcatDx(      TCHAR *Dest,                   const TCHAR *Src ) ;						// strcat Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	void			strcat_sDx(    TCHAR *Dest, size_t DestBytes, const TCHAR *Src ) ;						// strcat_s Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	size_t			strlenDx(      const TCHAR *Str ) ;												// strlen Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	size_t			strlen2Dx(     const TCHAR *Str ) ;												// strlen ̖߂l( Sp 1  )ɂȂ( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strcmpDx(      const TCHAR *Str1, const TCHAR *Str2 ) ;							// strcmp Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				stricmpDx(     const TCHAR *Str1, const TCHAR *Str2 ) ;							// stricmp Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strncmpDx(     const TCHAR *Str1, const TCHAR *Str2, int Num ) ;				// strncmp Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strncmp2Dx(    const TCHAR *Str1, const TCHAR *Str2, int Num ) ;				// strncmp  Num ( Sp 1  )ɂȂ( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strpncmpDx(    const TCHAR *Str1, const TCHAR *Str2, int Pos, int Num ) ;		// strncmp ̔rJnʒuwŁAPos  Str1 ̔rJnʒuANum ( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strpncmp2Dx(   const TCHAR *Str1, const TCHAR *Str2, int Pos, int Num ) ;		// strncmp ̔rJnʒuwŁAPos  Str1 ̔rJnʒu( Sp 1  )ANum ( Sp 1  )( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	DWORD			strgetchrDx(   const TCHAR *Str, int Pos, int *CharNums DEFAULTPARAM( = NULL ) ) ;	// ̎ẅʒu̕R[h擾APos ͎擾ʒuACharNums ͕ϐ̃AhXA߂l͕R[h( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	DWORD			strgetchr2Dx(  const TCHAR *Str, int Pos, int *CharNums DEFAULTPARAM( = NULL ) ) ;	// ̎ẅʒu̕R[h擾APos ͎擾ʒu( Sp 1  )ACharNums ͕ϐ̃AhXA߂l͕R[h( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strputchrDx(   TCHAR *Str, int Pos, DWORD CharCode ) ;							// ̎ẅʒuɕR[hށAPos ͏ވʒuACharCode ͕R[hA߂l͏񂾕( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strputchr2Dx(  TCHAR *Str, int Pos, DWORD CharCode ) ;							// ̎ẅʒuɕR[hށAPos ͏ވʒu( Sp 1  )ACharCode ͕R[hA߂l͏񂾕( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	const TCHAR *	strposDx(      const TCHAR *Str, int Pos ) ;									// ̎ẅʒũAhX擾APos ͎擾ʒu@( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	const TCHAR *	strpos2Dx(     const TCHAR *Str, int Pos ) ;									// ̎ẅʒũAhX擾APos ͎擾ʒu( Sp 1  )@( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	const TCHAR *	strstrDx(      const TCHAR *Str1, const TCHAR *Str2 ) ;							// strstr Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strstr2Dx(     const TCHAR *Str1, const TCHAR *Str2 ) ;							// strstr ̖߂l擪̕( Sp 1  ) ɂȂ( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	const TCHAR *	strrstrDx(     const TCHAR *Str1, const TCHAR *Str2 ) ;							// strrstr Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strrstr2Dx(    const TCHAR *Str1, const TCHAR *Str2 ) ;							// strrstr ̖߂l擪̕( Sp 1  ) ɂȂ( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	const TCHAR *	strchrDx(      const TCHAR *Str, DWORD CharCode ) ;								// strchr Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strchr2Dx(     const TCHAR *Str, DWORD CharCode ) ;								// strchr ̖߂l擪̕( Sp 1  ) ɂȂ( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	const TCHAR *	strrchrDx(     const TCHAR *Str, DWORD CharCode ) ;								// strrchr Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				strrchr2Dx(    const TCHAR *Str, DWORD CharCode ) ;								// strrchr ̖߂l擪̕( Sp 1  ) ɂȂ( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	TCHAR *			struprDx(      TCHAR *Str ) ;													// strupr Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				vsprintfDx(    TCHAR *Buffer,                    const TCHAR *FormatString, va_list Arg ) ;	// vsprintf Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				vsnprintfDx(   TCHAR *Buffer, size_t BufferSize, const TCHAR *FormatString, va_list Arg ) ;	// vsnprintf Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				sprintfDx(     TCHAR *Buffer,                    const TCHAR *FormatString, ... ) ;			// sprintf Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				snprintfDx(    TCHAR *Buffer, size_t BufferSize, const TCHAR *FormatString, ... ) ;			// snprintf Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	TCHAR *			itoaDx(        int Value, TCHAR *Buffer,                     int Radix ) ;		// itoa Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	TCHAR *			itoa_sDx(      int Value, TCHAR *Buffer, size_t BufferBytes, int Radix ) ;		// itoa_s Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				atoiDx(        const TCHAR *Str ) ;												// atoi Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ ) 
extern	double			atofDx(        const TCHAR *Str ) ;												// atof Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				vsscanfDx(     const TCHAR *String, const TCHAR *FormatString, va_list Arg ) ;	// vsscanf Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )
extern	int				sscanfDx(      const TCHAR *String, const TCHAR *FormatString, ... ) ;			// sscanf Ɠ̋@\( }`oCgłł͕R[h`Ƃ SetUseCharCodeFormat Őݒ肵`gp܂ )


















// DxNetwork.cpp֐vg^Cv錾

#ifndef DX_NON_NETWORK

// ʐM֌W
extern	int			ProcessNetMessage(				int RunReleaseProcess DEFAULTPARAM( = FALSE ) ) ;										// ʐMbZ[W̏֐

extern	int			GetHostIPbyName(				const TCHAR *HostName,							IPDATA      *IPDataBuf, int IPDataBufLength DEFAULTPARAM( = 1 ) , int *IPDataGetNum DEFAULTPARAM( = NULL ) ) ;		// cmrT[o[găzXghoAhX擾( IPv4 )
extern	int			GetHostIPbyNameWithStrLen(		const TCHAR *HostName, size_t HostNameLength,	IPDATA      *IPDataBuf, int IPDataBufLength DEFAULTPARAM( = 1 ) , int *IPDataGetNum DEFAULTPARAM( = NULL ) ) ;		// cmrT[o[găzXghoAhX擾( IPv4 )
extern	int			GetHostIPbyName_IPv6(			const TCHAR *HostName,							IPDATA_IPv6 *IPDataBuf, int IPDataBufLength DEFAULTPARAM( = 1 ) , int *IPDataGetNum DEFAULTPARAM( = NULL ) ) ;		// cmrT[o[găzXghoAhX擾( IPv6 )
extern	int			GetHostIPbyName_IPv6WithStrLen(	const TCHAR *HostName, size_t HostNameLength,	IPDATA_IPv6 *IPDataBuf, int IPDataBufLength DEFAULTPARAM( = 1 ) , int *IPDataGetNum DEFAULTPARAM( = NULL ) ) ;		// cmrT[o[găzXghoAhX擾( IPv6 )
extern 	int			ConnectNetWork(					IPDATA      IPData, int Port DEFAULTPARAM( = -1 ) ) ;									// }Vɐڑ( IPv4 )
extern	int			ConnectNetWork_IPv6(			IPDATA_IPv6 IPData, int Port DEFAULTPARAM( = -1 ) ) ;									// }Vɐڑ( IPv6 )
extern 	int			ConnectNetWork_ASync(			IPDATA      IPData, int Port DEFAULTPARAM( = -1 ) ) ;									// }Vɐڑ( IPv4 )A񓯊
extern	int			ConnectNetWork_IPv6_ASync(		IPDATA_IPv6 IPData, int Port DEFAULTPARAM( = -1 ) ) ;									// }Vɐڑ( IPv6 )A񓯊
extern 	int			PreparationListenNetWork(		int Port DEFAULTPARAM( = -1 ) ) ;														// ڑ󂯂Ԃɂ( IPv4 )
extern 	int			PreparationListenNetWork_IPv6(	int Port DEFAULTPARAM( = -1 ) ) ;														// ڑ󂯂Ԃɂ( IPv6 )
extern 	int			StopListenNetWork(				void ) ;																				// ڑ󂯂Ԃ̉
extern 	int			CloseNetWork(					int NetHandle ) ;																		// ڑI

extern 	int			GetNetWorkAcceptState(			int NetHandle ) ;																		// ڑԂ擾
extern 	int			GetNetWorkDataLength(			int NetHandle ) ;																		// Mf[^̗ʂ𓾂
extern	int			GetNetWorkSendDataLength(		int NetHandle ) ;																		// M̃f[^̗ʂ𓾂 
extern 	int			GetNewAcceptNetWork(			void ) ;																				// VɐڑʐM𓾂
extern 	int			GetLostNetWork(					void ) ;																				// ڑؒfꂽʐM𓾂
extern 	int			GetNetWorkIP(					int NetHandle, IPDATA      *IpBuf ) ;													// ڑ̂ho𓾂( IPv4 )
extern 	int			GetNetWorkIP_IPv6(				int NetHandle, IPDATA_IPv6 *IpBuf ) ;													// ڑ̂ho𓾂( IPv6 )
extern	int			GetMyIPAddress(					IPDATA      *IpBuf, int IpBufLength DEFAULTPARAM( = 1 ) , int *IpNum DEFAULTPARAM( = NULL ) ) ;			// IPv4𓾂
extern	int			GetMyIPAddress_IPv6(			IPDATA_IPv6 *IpBuf, int IpBufLength DEFAULTPARAM( = 1 ) , int *IpNum DEFAULTPARAM( = NULL ) ) ;			// IPv6𓾂
extern	int			SetConnectTimeOutWait(			int Time ) ;																			// ڑ̃^CAEg܂ł̎Ԃݒ肷
extern	int			SetUseDXNetWorkProtocol(		int Flag ) ;																			// cwCu̒ʐM`ԂgǂZbg
extern	int			GetUseDXNetWorkProtocol(		void ) ; 																				// cwCu̒ʐM`Ԃgǂ擾
extern	int			SetUseDXProtocol(				int Flag ) ;																			// SetUseDXNetWorkProtocol ̕ʖ
extern	int			GetUseDXProtocol(				void ) ; 																				// GetUseDXNetWorkProtocol ̕ʖ
extern	int			SetNetWorkCloseAfterLostFlag(	int Flag ) ;																			// ڑؒfꂽɐڑnh邩ǂ̃tOZbg
extern	int			GetNetWorkCloseAfterLostFlag(	void ) ;																				// ڑؒfꂽɐڑnh邩ǂ̃tO擾
//extern	int			SetProxySetting( int UseFlag, const char *Address, int Port ) ;														// gssoʐMŎgpvLVݒs
//extern	int			GetProxySetting( int *UseFlagBuffer, char *AddressBuffer, int *PortBuffer ) ;										// gssoʐMŎgpvLVݒ擾
//extern	int			SetIEProxySetting( void ) ;																							// hd̃vLVݒK

extern 	int			NetWorkRecv(			int NetHandle, void *Buffer, int Length ) ;														// Mf[^ǂݍ
extern	int			NetWorkRecvToPeek(		int NetHandle, void *Buffer, int Length ) ;														// Mf[^ǂݍށAǂݍ񂾃f[^̓obt@폜Ȃ
extern	int			NetWorkRecvBufferClear(	int NetHandle ) ;																				// Mf[^NA
extern 	int			NetWorkSend(			int NetHandle, const void *Buffer, int Length ) ;												// f[^𑗐M

extern	int			MakeUDPSocket(			int RecvPort DEFAULTPARAM( = -1 ) ) ;															// UDPgpʐMs\Pbgnh쐬( RecvPort  -1 ɂƑMp̃\PbgnhɂȂ܂ )
extern	int			MakeUDPSocket_IPv6(		int RecvPort DEFAULTPARAM( = -1 ) ) ;															// UDPgpʐMs\Pbgnh쐬( RecvPort  -1 ɂƑMp̃\PbgnhɂȂ܂ )( IPv6 )
extern	int			DeleteUDPSocket(		int NetUDPHandle ) ;																			// UDPgpʐMs\Pbgnh폜
extern	int			NetWorkSendUDP(			int NetUDPHandle, IPDATA       SendIP, int SendPort,  const void *Buffer, int Length ) ;			// UDPgpʐMŎŵhoɃf[^𑗐MALength ͍ő65507ASendPort  -1 ɂ MakeUDPSocket  RecvPort œn|[ggp܂( ߂l  0ȏ;Młf[^TCY  -1:G[  -2:Mf[^傫  -3:MłĂȂ  )
extern	int			NetWorkSendUDP_IPv6(	int NetUDPHandle, IPDATA_IPv6  SendIP, int SendPort,  const void *Buffer, int Length ) ;			// UDPgpʐMŎŵhoɃf[^𑗐MALength ͍ő65507ASendPort  -1 ɂ MakeUDPSocket  RecvPort œn|[ggp܂( ߂l  0ȏ;Młf[^TCY  -1:G[  -2:Mf[^傫  -3:MłĂȂ  )( IPv6 )
extern	int			NetWorkRecvUDP(			int NetUDPHandle, IPDATA      *RecvIP, int *RecvPort,       void *Buffer, int Length, int Peek ) ;	// UDPgpʐMŃf[^MAPeek  TRUE nƎMɐĂf[^ML[폜܂( ߂l  0ȏ:Mf[^̃TCY  -1:G[  -2:obt@̃TCYȂ  -3:Mf[^Ȃ )
extern	int			NetWorkRecvUDP_IPv6(	int NetUDPHandle, IPDATA_IPv6 *RecvIP, int *RecvPort,       void *Buffer, int Length, int Peek ) ;	// UDPgpʐMŃf[^MAPeek  TRUE nƎMɐĂf[^ML[폜܂( ߂l  0ȏ:Mf[^̃TCY  -1:G[  -2:obt@̃TCYȂ  -3:Mf[^Ȃ )( IPv6 )
//extern int		CheckNetWorkSendUDP(	int NetUDPHandle ) ;																			// UDPgpʐMŃf[^MłԂǂ𒲂ׂ( ߂l  -1:G[  TRUE:M\  FALSE:Ms\ )
extern	int			CheckNetWorkRecvUDP(	int NetUDPHandle ) ;																			// UDPgpʐMŐVȎMf[^݂邩ǂ𒲂ׂ( ߂l  -1:G[  TRUE:Mf[^  FALSE:Mf[^Ȃ )

/*	gps
extern	int			HTTP_FileDownload(			const char *FileURL, const char *SavePath DEFAULTPARAM( = NULL ) , void **SaveBufferP DEFAULTPARAM( = NULL ) , int *FileSize DEFAULTPARAM( = NULL ) , char **ParamList DEFAULTPARAM( = NULL ) ) ;						// HTTP gpălbg[Ñt@C_E[h
extern	int			HTTP_GetFileSize(			const char *FileURL ) ;																		// HTTP gpălbg[Ñt@C̃TCY𓾂

extern	int			HTTP_StartFileDownload(		const char *FileURL, const char *SavePath, void **SaveBufferP DEFAULTPARAM( = NULL ) , char **ParamList DEFAULTPARAM( = NULL ) ) ;	// HTTP gplbg[Ñt@C_E[h鏈Jn
extern	int			HTTP_StartGetFileSize(		const char *FileURL ) ;																		// HTTP gplbg[Ñt@C̃TCY𓾂鏈Jn
extern	int			HTTP_Close(					int HttpHandle ) ;																			// HTTP ̏IAnh
extern	int			HTTP_CloseAll(				void ) ;																					// SẴnhɑ΂ HTTP_Close s
extern	int			HTTP_GetState(				int HttpHandle ) ;																			// HTTP ݂̌̏Ԃ𓾂( NET_RES_COMPLETE  )
extern	int			HTTP_GetError(				int HttpHandle ) ;																			// HTTP ŃG[ꍇAG[̓e𓾂( HTTP_ERR_NONE  )
extern	int			HTTP_GetDownloadFileSize(	int HttpHandle ) ;																			// HTTP őΏۂƂȂĂt@C̃TCY𓾂( ߂l: -1 = G[EႵ͂܂t@C̃TCY擾ĂȂ  0ȏ = t@C̃TCY )
extern	int			HTTP_GetDownloadedFileSize( int HttpHandle ) ;																			// HTTP ŊɃ_E[ht@C̃TCY擾

extern	int			fgetsForNetHandle(			int NetHandle, char *strbuffer ) ;															// fgets ̃lbg[Nnh( -1:擾ł 0:擾ł )
extern	int			URLAnalys(					const char *URL, char *HostBuf DEFAULTPARAM( = NULL ) , char *PathBuf DEFAULTPARAM( = NULL ) , char *FileNameBuf DEFAULTPARAM( = NULL ) , int *PortBuf DEFAULTPARAM( = NULL ) ) ;	// tqk͂
extern	int			URLConvert(					char *URL, int ParamConvert DEFAULTPARAM( = TRUE ) , int NonConvert DEFAULTPARAM( = FALSE ) ) ;				// HTTP ɓnȂLgꂽn悤ȕɕϊ( ߂l: -1 = G[  0ȏ = ϊ̃̕TCY )
extern	int			URLParamAnalysis(			char **ParamList, char **ParamStringP ) ;													// HTTP pp[^Xg̃p[^쐬( ߂l:  -1 = G[  0ȏ = p[^̒̕ )
*/

#endif // DX_NON_NETWORK
















// DxInputString.cpp֐vg^Cv錾

#ifndef DX_NON_INPUTSTRING

// R[hobt@֌W
extern	int			StockInputChar(		TCHAR CharCode ) ;								// R[hobt@ɕR[hXgbN
extern	int			ClearInputCharBuf(	void ) ;										// R[hobt@NA
extern	TCHAR		GetInputChar(		int DeleteFlag ) ;								// R[hobt@ɗ܂f[^當R[h擾
extern	TCHAR		GetInputCharWait(	int DeleteFlag ) ;								// R[hobt@ɗ܂f[^當R[h擾Aobt@ɂȂɂR[hȂꍇ͕R[hobt@Ɉꕶ܂܂ő҂

extern	int			GetOneChar(			TCHAR *CharBuffer, int DeleteFlag ) ;			// R[hobt@ɗ܂f[^P擾
extern	int			GetOneCharWait(		TCHAR *CharBuffer, int DeleteFlag ) ;			// R[hobt@ɗ܂f[^P擾Aobt@ɉR[hȂꍇ͕R[hobt@Ɉꕶ܂܂ő҂
extern	int			GetCtrlCodeCmp(		TCHAR Char ) ;									// w̕R[hAXL[Rg[R[hׂ

#ifndef DX_NON_KEYEX

extern	int			DrawIMEInputString(				int x, int y,                                 int SelectStringNum , int DrawCandidateList DEFAULTPARAM( = TRUE ) ) ;	// ʏɓ͒̕`悷
extern	int			DrawIMEInputExtendString(		int x, int y, double ExRateX, double ExRateY, int SelectStringNum , int DrawCandidateList DEFAULTPARAM( = TRUE ) ) ;	// ʏɓ͒̕`悷( g嗦t )
extern	int			SetUseIMEFlag(					int UseFlag ) ;							// hldgp邩ǂݒ肷
extern	int			GetUseIMEFlag(					void ) ;								// hldgp邩ǂ̐ݒ擾
extern	int			SetInputStringMaxLengthIMESync(	int Flag ) ;							// hldœ͂łő啶 MakeKeyInput ̐ݒɍ킹邩ǂZbg( TRUE:킹  FALSE:킹Ȃ(ftHg) )
extern	int			SetIMEInputStringMaxLength(		int Length ) ;							// hldňxɓ͂łő啶ݒ肷( 0:Ȃ  1ȏ:w̕Ő )

#endif // DX_NON_KEYEX

#endif // DX_NON_INPUTSTRING

extern	int			GetStringPoint(				const TCHAR *String,                      int Point ) ;		// SpAp藐钆w̕ł̔p𓾂
extern	int			GetStringPointWithStrLen(	const TCHAR *String, size_t StringLength, int Point ) ;		// SpAp藐钆w̕ł̔p𓾂
extern	int			GetStringPoint2(			const TCHAR *String,                      int Point ) ;		// SpAp藐钆w̔pł̕𓾂
extern	int			GetStringPoint2WithStrLen(	const TCHAR *String, size_t StringLength, int Point ) ;		// SpAp藐钆w̔pł̕𓾂
extern	int			GetStringLength(			const TCHAR *String ) ;										// SpAp藐钆當擾

#ifndef DX_NON_FONT
extern	int			DrawObtainsString(						int x, int y, int AddY, const TCHAR *String,                      unsigned int StrColor, unsigned int StrEdgeColor DEFAULTPARAM( = 0 ) , int FontHandle DEFAULTPARAM( = -1 ) , unsigned int SelectBackColor DEFAULTPARAM( = 0xffffffff ) , unsigned int SelectStrColor DEFAULTPARAM( = 0 ) , unsigned int SelectStrEdgeColor DEFAULTPARAM( = 0xffffffff ) , int SelectStart DEFAULTPARAM( = -1 ) , int SelectEnd DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`
extern	int			DrawObtainsNString(						int x, int y, int AddY, const TCHAR *String, size_t StringLength, unsigned int StrColor, unsigned int StrEdgeColor DEFAULTPARAM( = 0 ) , int FontHandle DEFAULTPARAM( = -1 ) , unsigned int SelectBackColor DEFAULTPARAM( = 0xffffffff ) , unsigned int SelectStrColor DEFAULTPARAM( = 0 ) , unsigned int SelectStrEdgeColor DEFAULTPARAM( = 0xffffffff ) , int SelectStart DEFAULTPARAM( = -1 ) , int SelectEnd DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`
extern	int			DrawObtainsString_CharClip(				int x, int y, int AddY, const TCHAR *String,                      unsigned int StrColor, unsigned int StrEdgeColor DEFAULTPARAM( = 0 ) , int FontHandle DEFAULTPARAM( = -1 ) , unsigned int SelectBackColor DEFAULTPARAM( = 0xffffffff ) , unsigned int SelectStrColor DEFAULTPARAM( = 0 ) , unsigned int SelectStrEdgeColor DEFAULTPARAM( = 0xffffffff ) , int SelectStart DEFAULTPARAM( = -1 ) , int SelectEnd DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`( NbvP )
extern	int			DrawObtainsNString_CharClip(			int x, int y, int AddY, const TCHAR *String, size_t StringLength, unsigned int StrColor, unsigned int StrEdgeColor DEFAULTPARAM( = 0 ) , int FontHandle DEFAULTPARAM( = -1 ) , unsigned int SelectBackColor DEFAULTPARAM( = 0xffffffff ) , unsigned int SelectStrColor DEFAULTPARAM( = 0 ) , unsigned int SelectStrEdgeColor DEFAULTPARAM( = 0xffffffff ) , int SelectStart DEFAULTPARAM( = -1 ) , int SelectEnd DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`( NbvP )
extern	int			DrawObtainsString_WordClip(				int x, int y, int AddY, const TCHAR *String,                      unsigned int StrColor, unsigned int StrEdgeColor DEFAULTPARAM( = 0 ) , int FontHandle DEFAULTPARAM( = -1 ) , unsigned int SelectBackColor DEFAULTPARAM( = 0xffffffff ) , unsigned int SelectStrColor DEFAULTPARAM( = 0 ) , unsigned int SelectStrEdgeColor DEFAULTPARAM( = 0xffffffff ) , int SelectStart DEFAULTPARAM( = -1 ) , int SelectEnd DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`( NbvPP )
extern	int			DrawObtainsNString_WordClip(			int x, int y, int AddY, const TCHAR *String, size_t StringLength, unsigned int StrColor, unsigned int StrEdgeColor DEFAULTPARAM( = 0 ) , int FontHandle DEFAULTPARAM( = -1 ) , unsigned int SelectBackColor DEFAULTPARAM( = 0xffffffff ) , unsigned int SelectStrColor DEFAULTPARAM( = 0 ) , unsigned int SelectStrEdgeColor DEFAULTPARAM( = 0xffffffff ) , int SelectStart DEFAULTPARAM( = -1 ) , int SelectEnd DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`( NbvPP )
extern	int			GetObtainsStringCharPosition(			int x, int y, int AddY, const TCHAR *String, int StrLen, int *PosX, int *PosY, int FontHandle DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`悵ꍇ̖̕[̍W擾
extern	int			GetObtainsStringCharPosition_CharClip(	int x, int y, int AddY, const TCHAR *String, int StrLen, int *PosX, int *PosY, int FontHandle DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`悵ꍇ̖̕[̍W擾( NbvP )
extern	int			GetObtainsStringCharPosition_WordClip(	int x, int y, int AddY, const TCHAR *String, int StrLen, int *PosX, int *PosY, int FontHandle DEFAULTPARAM( = -1 ) , int *LineCount DEFAULTPARAM( = NULL ) ) ;		// `\̈Ɏ܂悤ɉsȂ當`悵ꍇ̖̕[̍W擾( NbvPP )
#endif // DX_NON_FONT
extern	int			DrawObtainsBox(					int x1, int y1, int x2, int y2, int AddY, unsigned int Color, int FillFlag ) ;																																										// `\̈Ɏ܂悤ɕ␳Ȃ``

#ifndef DX_NON_INPUTSTRING

#ifndef DX_NON_KEYEX

extern	int			InputStringToCustom(			int x, int y, size_t BufLength, TCHAR *StrBuffer, int CancelValidFlag, int SingleCharOnlyFlag, int NumCharOnlyFlag, int DoubleCharOnlyFlag DEFAULTPARAM( = FALSE ) , int EnableNewLineFlag DEFAULTPARAM( = FALSE ) , int DisplayCandidateList DEFAULTPARAM( = TRUE ) ) ;		// ͎̓擾

extern	int			KeyInputString(					int x, int y, size_t CharMaxLength, TCHAR *StrBuffer, int CancelValidFlag ) ;													// ͎̓擾
extern	int			KeyInputSingleCharString(		int x, int y, size_t CharMaxLength, TCHAR *StrBuffer, int CancelValidFlag ) ;													// p݂͎̂̓擾
extern	int			KeyInputNumber(					int x, int y, int MaxNum, int MinNum, int CancelValidFlag ) ;																	// l͎̓擾

extern	int			GetIMEInputModeStr(				TCHAR *GetBuffer ) ;																											// IME̓̓[h擾
extern	const IMEINPUTDATA* GetIMEInputData(		void ) ;																														// IMEœ͒̏̕擾
extern	int			SetIMEInputString(				const TCHAR *String ) ;																											// IMEœ͒̕ύX( IMEŕ͒ł͂Ȃꍇ͉N܂ )
extern	int			SetIMEInputStringWithStrLen(	const TCHAR *String, size_t StringLength ) ;																					// IMEœ͒̕ύX( IMEŕ͒ł͂Ȃꍇ͉N܂ )
extern	int			SetKeyInputStringColor(			ULONGLONG NmlStr, ULONGLONG NmlCur, ULONGLONG IMEStrBack, ULONGLONG IMECur, ULONGLONG IMELine, ULONGLONG IMESelectStr, ULONGLONG IMEModeStr , ULONGLONG NmlStrE DEFAULTPARAM( = 0 ) , ULONGLONG IMESelectStrE DEFAULTPARAM( = 0 ) , ULONGLONG IMEModeStrE DEFAULTPARAM( = 0 ) , ULONGLONG IMESelectWinE DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) ,	ULONGLONG IMESelectWinF DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) , ULONGLONG SelectStrBackColor DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) , ULONGLONG SelectStrColor DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) , ULONGLONG SelectStrEdgeColor DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) , ULONGLONG IMEStr DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) , ULONGLONG IMEStrE DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) ) ;	// ( SetKeyInputStringColor2 ̋֐ )InputString֐gp̊̕eFύX
extern	int			SetKeyInputStringColor2(		int TargetColor /* DX_KEYINPSTRCOLOR_NORMAL_STR  */ , unsigned int Color ) ;													// InputString֐gp̊̕eFύX
extern	int			ResetKeyInputStringColor2(		int TargetColor /* DX_KEYINPSTRCOLOR_NORMAL_STR  */ ) ;																		// SetKeyInputStringColor2 Őݒ肵FftHgɖ߂
extern	int			SetKeyInputStringFont(			int FontHandle ) ;																												// L[͕`֘AŎgptHg̃nhύX(-1ŃftHg̃tHgnh)
extern	int			SetKeyInputStringEndCharaMode(	int EndCharaMode /* DX_KEYINPSTR_ENDCHARAMODE_OVERWRITE  */ ) ;																// L[͕񏈗͕̓EɒBĂԂŁA̖[œ͂sꂽꍇ̏[hύX
extern	int			DrawKeyInputModeString(			int x, int y ) ;																												// ̓[h`悷

extern	int			InitKeyInput(					void ) ;																														// L[̓f[^
extern	int			MakeKeyInput(					size_t MaxStrLength, int CancelValidFlag, int SingleCharOnlyFlag, int NumCharOnlyFlag, int DoubleCharOnlyFlag DEFAULTPARAM( = FALSE ) , int EnableNewLineFlag DEFAULTPARAM( = FALSE ) ) ;			// VL[̓nh̍쐬
extern	int			DeleteKeyInput(					int InputHandle ) ;																												// L[̓nh̍폜
extern	int			SetActiveKeyInput(				int InputHandle ) ;																												// w̃L[̓nhANeBuɂ( -1 w肷ƃANeBuȃL[̓nhԂɂȂ܂ )
extern	int			GetActiveKeyInput(				void ) ;																														// ݃ANeBuɂȂĂL[̓nh擾
extern	int			CheckKeyInput(					int InputHandle ) ;																												// L[̓nh̓͂IĂ邩擾
extern	int			ReStartKeyInput(				int InputHandle ) ;																												// ͂L[̓nhēxҏWԂɖ߂
extern	int			ProcessActKeyInput(				void ) ;																														// L[̓nh֐
extern	int			DrawKeyInputString(				int x, int y,                                 int InputHandle , int DrawCandidateList DEFAULTPARAM( = TRUE ) ) ;				// L[̓nh̓͒̕`
extern	int			DrawKeyInputExtendString(		int x, int y, double ExRateX, double ExRateY, int InputHandle , int DrawCandidateList DEFAULTPARAM( = TRUE ) ) ;				// L[̓nh̓͒̕`( g嗦wt )
extern	int			SetKeyInputDrawArea(			int x1, int y1, int x2, int y2, int InputHandle ) ;																				// L[̓nh̓͒`悷ۂ̕`͈͂ݒ肷

extern	int			SetKeyInputSelectArea(			int  SelectStart, int  SelectEnd, int InputHandle ) ;																			// L[̓nh̎ẅ̗IԂɂ( SelectStart  SelectEnd  -1 w肷ƑIԂ܂ )
extern	int			GetKeyInputSelectArea(			int *SelectStart, int *SelectEnd, int InputHandle ) ;																			// L[̓nh̑Ï擾
extern	int			SetKeyInputDrawStartPos(		int DrawStartPos, int InputHandle ) ;																							// L[̓nh̕`Jnʒuݒ肷
extern	int			GetKeyInputDrawStartPos(		int InputHandle ) ;																												// L[̓nh̕`Jnʒu擾
extern	int			SetKeyInputCursorBrinkTime(		int Time ) ;																													// L[̓nh̃L[͎̃J[\̓_ł鑁Zbg
extern	int			SetKeyInputCursorBrinkFlag(		int Flag ) ;																													// L[̓nh̃L[͎̃J[\_ł邩ǂZbg
extern	int			SetKeyInputString(				const TCHAR *String,                      int InputHandle ) ;																	// L[̓nhɎw̕Zbg
extern	int			SetKeyInputStringWithStrLen(	const TCHAR *String, size_t StringLength, int InputHandle ) ;																	// L[̓nhɎw̕Zbg
extern	int			SetKeyInputNumber(				int   Number,                             int InputHandle ) ;																	// L[̓nhɎw̐l𕶎ɒuăZbg
extern	int			SetKeyInputNumberToFloat(		float Number,                             int InputHandle ) ;																	// L[̓nhɎw̕_l𕶎ɒuăZbg
extern	int			GetKeyInputString(				TCHAR *StrBuffer,                         int InputHandle ) ;																	// L[̓nh̓͒̕擾
extern	int			GetKeyInputNumber(				int InputHandle ) ;																												// L[̓nh̓͒̕𐮐lƂĎ擾
extern	float		GetKeyInputNumberToFloat(		int InputHandle ) ;																												// L[̓nh̓͒̕𕂓_lƂĎ擾
extern	int			SetKeyInputCursorPosition(		int Position,        int InputHandle ) ;																						// L[̓nȟ݂̃J[\ʒuݒ肷
extern	int			GetKeyInputCursorPosition(		int InputHandle ) ;																												// L[̓nȟ݂̃J[\ʒu擾

#endif // DX_NON_KEYEX

#endif // DX_NON_INPUTSTRING










// DxFile.cpp֐vg^Cv錾

// t@CANZX֐
extern	int			FileRead_open(						const TCHAR *FilePath,                        int ASync DEFAULTPARAM( = FALSE ) ) ;	// t@CJ
extern	int			FileRead_open_WithStrLen(			const TCHAR *FilePath, size_t FilePathLength, int ASync DEFAULTPARAM( = FALSE ) ) ;	// t@CJ
extern	int			FileRead_open_mem(					const void *FileImage, size_t FileImageSize ) ;					// ɓWJꂽt@CJ
extern	LONGLONG	FileRead_size(						const TCHAR *FilePath ) ;										// t@C̃TCY擾
extern	LONGLONG	FileRead_size_WithStrLen(			const TCHAR *FilePath, size_t FilePathLength ) ;				// t@C̃TCY擾
extern	LONGLONG	FileRead_size_handle(				int FileHandle ) ;												// t@C̃TCY擾( t@Cnhgp )
extern	int			FileRead_close(						int FileHandle ) ;												// t@C
extern	LONGLONG	FileRead_tell(						int FileHandle ) ;												// t@C|C^̓ǂݍ݈ʒu擾
extern	int			FileRead_seek(						int FileHandle , LONGLONG Offset , int Origin ) ;				// t@C|C^̓ǂݍ݈ʒuύX
extern	int			FileRead_read(						void *Buffer , int ReadSize , int FileHandle ) ;				// t@Cf[^ǂݍ
extern	int			FileRead_idle_chk(					int FileHandle ) ;												// t@Cǂݍ݂Ă邩ǂ擾
extern	int			FileRead_eof(						int FileHandle ) ;												// t@C̓ǂݍ݈ʒuI[ɒBĂ邩ǂ擾
extern	int			FileRead_set_format(				int FileHandle, int CharCodeFormat /* DX_CHARCODEFORMAT_SHIFTJIS  */ ) ;	// t@C̕R[h`ݒ肷( eLXgt@Cp )
extern	int			FileRead_gets(						TCHAR *Buffer , int BufferSize , int FileHandle ) ;				// t@C當ǂݏo
extern	TCHAR		FileRead_getc(						int FileHandle ) ;												// t@Cꕶǂݏo
extern	int			FileRead_scanf(						int FileHandle , const TCHAR *Format , ... ) ;					// t@C珑ꂽf[^ǂݏo

extern	DWORD_PTR	FileRead_createInfo(				const TCHAR *ObjectPath ) ;										// t@Cnh쐬( ߂l  -1:G[  -1ȊO:t@Cnh )
extern	DWORD_PTR	FileRead_createInfo_WithStrLen(		const TCHAR *ObjectPath, size_t ObjectPathLength ) ;			// t@Cnh쐬( ߂l  -1:G[  -1ȊO:t@Cnh )
extern	int			FileRead_getInfoNum(				DWORD_PTR FileInfoHandle ) ;									// t@Cnh̃t@C̐擾
extern	int			FileRead_getInfo(					int Index , FILEINFO *Buffer , DWORD_PTR FileInfoHandle ) ;		// t@Cnh̃t@C̏擾
extern	int			FileRead_deleteInfo(				DWORD_PTR FileInfoHandle ) ;									// t@Cnh폜

extern	DWORD_PTR	FileRead_findFirst(					const TCHAR *FilePath,                        FILEINFO *Buffer ) ; // w̃t@C̓tH_̏擾At@Cnh쐬( ߂l: -1=G[  -1ȊO=t@Cnh )
extern	DWORD_PTR	FileRead_findFirst_WithStrLen(		const TCHAR *FilePath, size_t FilePathLength, FILEINFO *Buffer ) ; // w̃t@C̓tH_̏擾At@Cnh쐬( ߂l: -1=G[  -1ȊO=t@Cnh )
extern	int			FileRead_findNext(					DWORD_PTR FindHandle, FILEINFO *Buffer ) ;						// ̍v鎟̃t@C̏擾( ߂l: -1=G[  0= )
extern	int			FileRead_findClose(					DWORD_PTR FindHandle ) ;										// t@Cnh( ߂l: -1=G[  0= )

extern	int			FileRead_fullyLoad(					const TCHAR *FilePath ) ;										// w̃t@C̓eSăɓǂݍ݁Ȁ̃ANZXɕKvȃnhԂ( ߂l  -1:G[  -1ȊO:nh )AgInh FileRead_fullyLoad_delete ō폜Kv܂
extern	int			FileRead_fullyLoad_WithStrLen(		const TCHAR *FilePath, size_t FilePathLength ) ;				// w̃t@C̓eSăɓǂݍ݁Ȁ̃ANZXɕKvȃnhԂ( ߂l  -1:G[  -1ȊO:nh )AgInh FileRead_fullyLoad_delete ō폜Kv܂
extern	int			FileRead_fullyLoad_delete(			int FLoadHandle ) ;												// FileRead_fullyLoad œǂݍ񂾃t@C̃nh폜
extern	const void*	FileRead_fullyLoad_getImage(		int FLoadHandle ) ;												// FileRead_fullyLoad œǂݍ񂾃t@C̓ei[AhX擾
extern	LONGLONG	FileRead_fullyLoad_getSize(			int FLoadHandle ) ;												// FileRead_fullyLoad œǂݍ񂾃t@C̃TCY擾

// ݒ֌W֐
extern	int			GetStreamFunctionDefault(			void ) ;														// cwCuŃXg[f[^ANZXɎgp֐ftHĝׂ̂( TRUE:ftHĝ  FALSE:ftHgł͂Ȃ )
extern	int			ChangeStreamFunction(				const STREAMDATASHREDTYPE2  *StreamThread  ) ;					// cwCuŃXg[f[^ANZXɎgp֐ύX
extern	int			ChangeStreamFunctionW(				const STREAMDATASHREDTYPE2W *StreamThreadW ) ;					// cwCuŃXg[f[^ANZXɎgp֐ύX( wchar_t gp )

// ⏕֌W֐
extern int			ConvertFullPath(					const TCHAR *Src,                   TCHAR *Dest, const TCHAR *CurrentDir DEFAULTPARAM( = NULL )                                              ) ;	// tpXł͂ȂpXtpXɕϊ( CurrentDir ̓tpXłKv(Ɂw\xĂĂǂ) )( CurrentDir  NULL ̏ꍇ݂͌̃JgfBNggp )
extern int			ConvertFullPathWithStrLen(			const TCHAR *Src, size_t SrcLength, TCHAR *Dest, const TCHAR *CurrentDir DEFAULTPARAM( = NULL ), size_t CurrentDirLength DEFAULTPARAM( = 0 ) ) ;












// DxInput.cpp֐vg^Cv錾

#ifndef DX_NON_INPUT

// ͏Ԏ擾֐
extern	int			CheckHitKey(							int KeyCode ) ;															// L[{[h̉Ԃ擾
extern	int			CheckHitKeyAll(							int CheckType DEFAULTPARAM( = DX_CHECKINPUT_ALL ) ) ;					// ǂꂩłL[Ă邩ǂ擾( Ă߂l 0 ȊOɂȂ )
extern	int			GetHitKeyStateAll(						DX_CHAR *KeyStateArray ) ;												// ׂẴL[̉Ԃ擾( KeyStateBuf:char^256̔z̐擪AhX )
extern	int			GetHitKeyStateAllEx(					int *KeyStateArray ) ;													// ׂẴL[̉Ԃ擾( KeyStateBuf:int^256̔z̐擪AhXA͔z̑Svf 0 ĂKv܂Az̊evf̏ԁ@0:ĂȂ@1FꂽP߁@2ȏFꑱĂ񐔁@-1FėꂽP߁@-2ȉFėẲ )
extern	int			GetJoypadNum(							void ) ;																// WCpbhڑĂ鐔擾
extern	int			GetJoypadButtonNum(						int InputType ) ;														// WCpbh̃{^̐擾
extern	int			GetJoypadInputState(					int InputType ) ;														// WCpbh̓͏Ԃ擾
extern	int			GetJoypadAnalogInput(					int *XBuf, int *YBuf, int InputType ) ;									// WCpbh̃AiOIȃXeBbN͏𓾂
extern	int			GetJoypadAnalogInputRight(				int *XBuf, int *YBuf, int InputType ) ;									// ( gp񐄏 )WCpbh̃AiOIȃXeBbN͏𓾂(EXeBbNp)
extern	int			GetJoypadDirectInputState(				int InputType, DINPUT_JOYSTATE *DInputState ) ;							// DirectInput 瓾WCpbh̐̃f[^擾( DX_INPUT_KEY  DX_INPUT_KEY_PAD1 ȂǁAL[{[hރ^Cv InputType ɓnƃG[ƂȂ -1 Ԃ )
extern	int			CheckJoypadXInput(						int InputType ) ;														// w̓̓foCX XInput ɑΉĂ邩ǂ擾( ߂l  TRUE:XInputΉ̓̓foCX  FALSE:XInputΉ̓̓foCX   -1:G[ )( DX_INPUT_KEY  DX_INPUT_KEY_PAD1 ȂǁAL[{[hރ^Cv InputType ɓnƃG[ƂȂ -1 Ԃ )
extern	int			GetJoypadType(							int InputType ) ;														// WCpbh̃^Cv擾( ߂l  -1:G[  0ȏ:WCpbh^Cv( DX_PADTYPE_XBOX_360 Ȃ ) )
extern	int			GetJoypadXInputState(					int InputType, XINPUT_STATE *XInputState ) ;							// XInput 瓾̓foCX( Xbox360Rg[ )̐̃f[^擾( XInputΉ̃pbh̏ꍇ̓G[ƂȂ -1 ԂADX_INPUT_KEY  DX_INPUT_KEY_PAD1 ȂǁAL[{[hރ^Cv InputType ɓnƃG[ƂȂ -1 Ԃ )
extern	int			SetJoypadInputToKeyInput(				int InputType, int PadInput, int KeyInput1, int KeyInput2 DEFAULTPARAM( = -1 ) , int KeyInput3 DEFAULTPARAM( = -1 ) , int KeyInput4 DEFAULTPARAM( = -1 )  ) ; // WCpbh̓͂ɑΉL[{[h̓͂ݒ肷( InputType:ݒύXpbh̎ʎq( DX_INPUT_PAD1 )@@PadInput:ݒύXpbh{^̎ʎq( PAD_INPUT_1  )@@KeyInput1:PadInput ƂɂL[R[h( KEY_INPUT_A Ȃ )̂P@@KeyInput2:̂QA-1ŐݒȂ@@KeyInput3:̂RA-1ŐݒȂ@@KeyInput4:̂SA-1ŐݒȂ )
extern	int			SetJoypadDeadZone(						int InputType, double Zone ) ;											// WCpbh̖][̐ݒs( InputType:ݒύXpbh̎ʎq( DX_INPUT_PAD1 )   Zone:V][( 0.0 ` 1.0 )AftHgl 0.35 )
extern	double		GetJoypadDeadZone(						int InputType ) ;														// WCpbh̖][̐ݒ擾( InputType:ݒύXpbh̎ʎq( DX_INPUT_PAD1 )   ߂l:][( 0.0 ` 1.0 ) )
extern	int			SetJoypadDefaultDeadZoneAll(			double Zone ) ;															// WCpbh̃ftHg̖][ݒ肷( Zone:V][( 0.0 ` 1.0 )AftHgl 0.35 )
extern	double		GetJoypadDefaultDeadZoneAll(			void ) ;																// WCpbh̃ftHg̖][擾( ߂l:][( 0.0 ` 1.0 ) )
extern	int			StartJoypadVibration(					int InputType, int Power, int Time, int EffectIndex DEFAULTPARAM( = -1 ) ) ;	// WCpbh̐UJn
extern	int			StopJoypadVibration(					int InputType, int EffectIndex DEFAULTPARAM( = -1 ) ) ;					// WCpbh̐U~
extern	int			GetJoypadPOVState(						int InputType, int POVNumber ) ;										// WCpbĥonu͂̏Ԃ𓾂( ߂l@wPOVf[^̊pxAPʂ͊px̂POO{( 90xȂ 9000 ) Sʒuɂꍇ -1 Ԃ )
extern	int			ReSetupJoypad(							void ) ;																// WCpbh̍ăZbgAbvs( VɐڑꂽWCpbh猟o )
extern	int			ReSetupInputSystem(						void ) ;																// ̓VXe̍ăZbgAbvs( ߂l  0:I  -1:G[ )

extern	int			SetUseJoypadVibrationFlag(				int Flag ) ;															// WCpbh̐U@\gp邩ǂݒ肷( TRUE:gp@@FALSE:gpȂ )

#endif // DX_NON_INPUT







#ifndef DX_NOTUSE_DRAWFUNCTION

// 摜n֐vg^Cv錾

// OtBbNnh쐬֌W֐
extern	int			MakeGraph(							int SizeX, int SizeY, int NotUse3DFlag DEFAULTPARAM( = FALSE ) ) ;			// wTCỸOtBbNnh쐬
extern	int			MakeScreen(							int SizeX, int SizeY, int UseAlphaChannel DEFAULTPARAM( = FALSE ) ) ;		// SetDrawScreen ŕ`ΏۂɂłOtBbNnh쐬
extern	int			DerivationGraph(					int   SrcX, int   SrcY, int   Width, int   Height, int SrcGraphHandle ) ;	// w̃OtBbNnh̎w蕔𔲂oĐVȃOtBbNnh쐬
extern	int			DerivationGraphF(					float SrcX, float SrcY, float Width, float Height, int SrcGraphHandle ) ;	// w̃OtBbNnh̎w蕔𔲂oĐVȃOtBbNnh쐬( float )
extern	int			DeleteGraph(						int GrHandle ) ;															// OtBbNnh폜
extern	int			DeleteSharingGraph(					int GrHandle ) ;															// w̃OtBbNnhƁAOtBbNnhhĂOtBbNnh( DerivationGraph ŔhnhALoadDivGraph ǂݍō쐬ꂽ̃nh )xɍ폜
extern	int			GetGraphNum(						void ) ;																	// LȃOtBbNnh̐擾
extern	int			FillGraph(							int GrHandle, int Red, int Green, int Blue, int Alpha DEFAULTPARAM( = 255 ) ) ;											// OtBbNnhw̐FœhԂ
extern	int			FillRectGraph(						int GrHandle, int x, int y, int Width, int Height, int Red, int Green, int Blue, int Alpha DEFAULTPARAM( = 255 ) ) ;	// OtBbNnh̎w͈̔͂w̐FœhԂ
extern	int			SetGraphLostFlag(					int GrHandle, int *LostFlag ) ;												// w̃OtBbNnh폜ꂽۂ 1 ɂϐ̃AhXݒ肷
extern	int			InitGraph(							void ) ;																	// ׂẴOtBbNnh폜
extern	int			ReloadFileGraphAll(					void ) ;																	// t@C摜ǂݍ񂾑SẴOtBbNnhɂāAēxt@C摜ǂݍ

// VhE}bvnh֌W֐
extern	int			MakeShadowMap(						int SizeX, int SizeY ) ;													// VhE}bvnh쐬
extern	int			DeleteShadowMap(					int SmHandle ) ;															// VhE}bvnh폜
extern	int			SetShadowMapLightDirection(			int SmHandle, VECTOR Direction ) ;											// VhE}bvz肷郉Cg̕ݒ肷
extern	int			ShadowMap_DrawSetup(				int SmHandle ) ;															// VhE}bvւ̕`̏s
extern	int			ShadowMap_DrawEnd(					void ) ;																	// VhE}bvւ̕`I
extern	int			SetUseShadowMap(					int SmSlotIndex, int SmHandle ) ;											// `ŎgpVhE}bvw肷ALȃXbg͂O`QASmHandle  -1 nƎw̃Xbg̃VhE}bv
extern	int			SetShadowMapDrawArea(				int SmHandle, VECTOR MinPosition, VECTOR MaxPosition ) ;					// VhE}bvɕ`悷ۂ͈̔͂ݒ肷( ̊֐ŕ`͈͂ݒ肵Ȃꍇ͎g債͈͂`͈͂ƂȂ )
extern	int			ResetShadowMapDrawArea(				int SmHandle ) ;															// SetShadowMapDrawArea ̐ݒ
extern	int			SetShadowMapAdjustDepth(			int SmHandle, float Depth ) ;												// VhE}bvgp`掞̕␳[xݒ肷
extern	int			GetShadowMapViewProjectionMatrix(	int SmHandle, MATRIX *MatrixBuffer ) ;										// VhE}bv쐬KpɎgpr[sƎˉesZs擾
extern	int			TestDrawShadowMap(					int SmHandle, int x1, int y1, int x2, int y2 ) ;							// VhE}bvʂɃeXg`悷

// OtBbNnhւ̉摜]֐
extern	int			BltBmpToGraph(						const COLORDATA *BmpColorData, HBITMAP RgbBmp, HBITMAP AlphaBmp,                                                                      int CopyPointX, int CopyPointY,                              int  GrHandle ) ;					// alo̓eOtBbNnhɓ]
extern	int			BltBmpToDivGraph(					const COLORDATA *BmpColorData, HBITMAP RgbBmp, HBITMAP AlphaBmp,                                                                      int AllNum, int XNum, int YNum, int Width, int Height, const int *GrHandle, int ReverseFlag ) ;	// alo̓e𕪊쐬OtBbNnhɓ]
extern	int			BltBmpOrGraphImageToGraph(			const COLORDATA *BmpColorData, HBITMAP RgbBmp, HBITMAP AlphaBmp, int BmpFlag, const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int CopyPointX, int CopyPointY,                              int  GrHandle ) ;					// alo  BASEIMAGE OtBbNnhɓ]
extern	int			BltBmpOrGraphImageToGraph2(			const COLORDATA *BmpColorData, HBITMAP RgbBmp, HBITMAP AlphaBmp, int BmpFlag, const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, const RECT *SrcRect, int DestX, int DestY,                   int  GrHandle ) ;					// alo  BASEIMAGE ̎ẅ̗OtBbNnhɓ]
extern	int			BltBmpOrGraphImageToDivGraph(		const COLORDATA *BmpColorData, HBITMAP RgbBmp, HBITMAP AlphaBmp, int BmpFlag, const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, int   Width, int   Height, const int *GrHandle, int ReverseFlag ) ;	// alo  BASEIMAGE 𕪊쐬OtBbNnhɓ]
extern	int			BltBmpOrGraphImageToDivGraphF(		const COLORDATA *BmpColorData, HBITMAP RgbBmp, HBITMAP AlphaBmp, int BmpFlag, const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, float Width, float Height, const int *GrHandle, int ReverseFlag ) ;	// alo  BASEIMAGE 𕪊쐬OtBbNnhɓ]( float^ )

// 摜OtBbNnh쐬֐
extern	int			LoadBmpToGraph(						const TCHAR *FileName,                        int TextureFlag, int ReverseFlag, int SurfaceMode DEFAULTPARAM( = DX_MOVIESURFACE_NORMAL ) ) ;											// 摜t@COtBbNnh쐬
extern	int			LoadBmpToGraphWithStrLen(			const TCHAR *FileName, size_t FileNameLength, int TextureFlag, int ReverseFlag, int SurfaceMode DEFAULTPARAM( = DX_MOVIESURFACE_NORMAL ) ) ;											// 摜t@COtBbNnh쐬
extern	int			LoadGraph(							const TCHAR *FileName,                        int NotUse3DFlag DEFAULTPARAM( = FALSE ) ) ;																				// 摜t@COtBbNnh쐬
extern	int			LoadGraphWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int NotUse3DFlag DEFAULTPARAM( = FALSE ) ) ;																				// 摜t@COtBbNnh쐬
extern	int			LoadReverseGraph(					const TCHAR *FileName,                        int NotUse3DFlag DEFAULTPARAM( = FALSE ) ) ;																				// 摜t@C𔽓]̂ŃOtBbNnh쐬
extern	int			LoadReverseGraphWithStrLen(			const TCHAR *FileName, size_t FileNameLength, int NotUse3DFlag DEFAULTPARAM( = FALSE ) ) ;																				// 摜t@C𔽓]̂ŃOtBbNnh쐬
extern	int			LoadDivGraph(						const TCHAR *FileName,                        int AllNum, int XNum, int YNum, int   XSize, int   YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , int   XStride DEFAULTPARAM( = 0 ) , int   YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadDivGraphWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, int   XSize, int   YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , int   XStride DEFAULTPARAM( = 0 ) , int   YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadDivGraphF(						const TCHAR *FileName,                        int AllNum, int XNum, int YNum, float XSize, float YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , float XStride DEFAULTPARAM( = 0 ) , float YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadDivGraphFWithStrLen(			const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, float XSize, float YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , float XStride DEFAULTPARAM( = 0 ) , float YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadDivBmpToGraph(					const TCHAR *FileName,                        int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, int *HandleArray, int TextureFlag, int ReverseFlag , int   XStride DEFAULTPARAM( = 0 ) , int   YStride DEFAULTPARAM( = 0 ) ) ;			// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadDivBmpToGraphWithStrLen(		const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, int *HandleArray, int TextureFlag, int ReverseFlag , int   XStride DEFAULTPARAM( = 0 ) , int   YStride DEFAULTPARAM( = 0 ) ) ;			// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadDivBmpToGraphF(					const TCHAR *FileName,                        int AllNum, int XNum, int YNum, float SizeX, float SizeY, int *HandleArray, int TextureFlag, int ReverseFlag , float XStride DEFAULTPARAM( = 0 ) , float YStride DEFAULTPARAM( = 0 ) ) ;			// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadDivBmpToGraphFWithStrLen(		const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, float SizeX, float SizeY, int *HandleArray, int TextureFlag, int ReverseFlag , float XStride DEFAULTPARAM( = 0 ) , float YStride DEFAULTPARAM( = 0 ) ) ;			// 摜t@C𕪊ăOtBbNnh쐬
extern	int			LoadReverseDivGraph(				const TCHAR *FileName,                        int AllNum, int XNum, int YNum, int   XSize, int   YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , int   XStride DEFAULTPARAM( = 0 ) , int   YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𔽓]̂𕪊ăOtBbNnh쐬
extern	int			LoadReverseDivGraphWithStrLen(		const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, int   XSize, int   YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , int   XStride DEFAULTPARAM( = 0 ) , int   YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𔽓]̂𕪊ăOtBbNnh쐬
extern	int			LoadReverseDivGraphF(				const TCHAR *FileName,                        int AllNum, int XNum, int YNum, float XSize, float YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , float XStride DEFAULTPARAM( = 0 ) , float YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𔽓]̂𕪊ăOtBbNnh쐬
extern	int			LoadReverseDivGraphFWithStrLen(		const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, float XSize, float YSize, int *HandleArray, int NotUse3DFlag DEFAULTPARAM( = FALSE ) , float XStride DEFAULTPARAM( = 0 ) , float YStride DEFAULTPARAM( = 0 ) ) ;	// 摜t@C𔽓]̂𕪊ăOtBbNnh쐬
extern	int			LoadBlendGraph(						const TCHAR *FileName ) ;																																				// 摜t@CuhpOtBbNnh쐬
extern	int			LoadBlendGraphWithStrLen(			const TCHAR *FileName, size_t FileNameLength ) ;																														// 摜t@CuhpOtBbNnh쐬

extern	int			CreateGraphFromMem(					const void *RGBFileImage, int RGBFileImageSize,               const void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AlphaFileImageSize DEFAULTPARAM( = 0 ) ,                  int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																			// ̉摜C[WOtBbNnh쐬
extern	int			ReCreateGraphFromMem(				const void *RGBFileImage, int RGBFileImageSize, int GrHandle, const void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AlphaFileImageSize DEFAULTPARAM( = 0 ) ,                  int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																			// ̉摜C[W̃OtBbNnhɃf[^]
extern	int			CreateDivGraphFromMem(				const void *RGBFileImage, int RGBFileImageSize, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY,       int *HandleArray,               int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AlphaFileImageSize DEFAULTPARAM( = 0 ) ) ;			// ̉摜C[W番OtBbNnh쐬
extern	int			CreateDivGraphFFromMem(				const void *RGBFileImage, int RGBFileImageSize, int AllNum, int XNum, int YNum, float SizeX, float SizeY,       int *HandleArray,               int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AlphaFileImageSize DEFAULTPARAM( = 0 ) ) ;			// ̉摜C[W番OtBbNnh쐬( float )
extern	int			ReCreateDivGraphFromMem(			const void *RGBFileImage, int RGBFileImageSize, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, const int *HandleArray,               int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AlphaFileImageSize DEFAULTPARAM( = 0 ) ) ;			// ̉摜C[W̕OtBbNnhɃf[^]
extern	int			ReCreateDivGraphFFromMem(			const void *RGBFileImage, int RGBFileImageSize, int AllNum, int XNum, int YNum, float SizeX, float SizeY, const int *HandleArray,               int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AlphaFileImageSize DEFAULTPARAM( = 0 ) ) ;			// ̉摜C[W̕OtBbNnhɃf[^]( float )
extern	int			CreateGraphFromBmp(					const BITMAPINFO *RGBBmpInfo, const void *RGBBmpImage,               const BITMAPINFO *AlphaBmpInfo DEFAULTPARAM( = NULL ) , const void *AlphaBmpImage DEFAULTPARAM( = NULL ) , int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																			// rbg}bvf[^OtBbNnh쐬
extern	int			ReCreateGraphFromBmp(				const BITMAPINFO *RGBBmpInfo, const void *RGBBmpImage, int GrHandle, const BITMAPINFO *AlphaBmpInfo DEFAULTPARAM( = NULL ) , const void *AlphaBmpImage DEFAULTPARAM( = NULL ) , int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																			// rbg}bvf[^̃OtBbNnhɃf[^]
extern	int			CreateDivGraphFromBmp(				const BITMAPINFO *RGBBmpInfo, const void *RGBBmpImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY,       int *HandleArray,        int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const BITMAPINFO *AlphaBmpInfo DEFAULTPARAM( = NULL ) , const void *AlphaBmpImage DEFAULTPARAM( = NULL ) ) ;	// rbg}bvf[^番OtBbNnh쐬
extern	int			CreateDivGraphFFromBmp(				const BITMAPINFO *RGBBmpInfo, const void *RGBBmpImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY,       int *HandleArray,        int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const BITMAPINFO *AlphaBmpInfo DEFAULTPARAM( = NULL ) , const void *AlphaBmpImage DEFAULTPARAM( = NULL ) ) ;	// rbg}bvf[^番OtBbNnh쐬( float )
extern	int			ReCreateDivGraphFromBmp(			const BITMAPINFO *RGBBmpInfo, const void *RGBBmpImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, const int *HandleArray,        int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const BITMAPINFO *AlphaBmpInfo DEFAULTPARAM( = NULL ) , const void *AlphaBmpImage DEFAULTPARAM( = NULL ) ) ;	// rbg}bvf[^̕OtBbNnhɃf[^]
extern	int			ReCreateDivGraphFFromBmp(			const BITMAPINFO *RGBBmpInfo, const void *RGBBmpImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY, const int *HandleArray,        int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , const BITMAPINFO *AlphaBmpInfo DEFAULTPARAM( = NULL ) , const void *AlphaBmpImage DEFAULTPARAM( = NULL ) ) ;	// rbg}bvf[^̕OtBbNnhɃf[^]( float )
extern	int			CreateDXGraph(						const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage,                                                                                 int TextureFlag ) ;																									// {C[Wf[^TCYoAɍOtBbNnh쐬
extern	int			CreateGraphFromGraphImage(			const BASEIMAGE *RgbBaseImage,                                                                                                                  int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^OtBbNnh쐬
extern	int			ReCreateGraphFromGraphImage(		const BASEIMAGE *RgbBaseImage,                                  int GrHandle,                                                                   int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̃OtBbNnhɃf[^]
extern	int			CreateDivGraphFromGraphImage(		      BASEIMAGE *RgbBaseImage,                                  int AllNum, int XNum, int YNum, int   SizeX, int   SizeY,       int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^番OtBbNnh쐬
extern	int			CreateDivGraphFFromGraphImage(		      BASEIMAGE *RgbBaseImage,                                  int AllNum, int XNum, int YNum, float SizeX, float SizeY,       int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^番OtBbNnh쐬( float )
extern	int			ReCreateDivGraphFromGraphImage(		      BASEIMAGE *RgbBaseImage,                                  int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, const int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̕OtBbNnhɃf[^]
extern	int			ReCreateDivGraphFFromGraphImage(	      BASEIMAGE *RgbBaseImage,                                  int AllNum, int XNum, int YNum, float SizeX, float SizeY, const int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̕OtBbNnhɃf[^]( float )
#ifndef DX_COMPILE_TYPE_C_LANGUAGE
extern	int			CreateGraphFromGraphImage(			const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage,                                                                                 int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^OtBbNnh쐬
extern	int			ReCreateGraphFromGraphImage(		const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int GrHandle,                                                                   int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̃OtBbNnhɃf[^]
extern	int			CreateDivGraphFromGraphImage(		      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY,       int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^番OtBbNnh쐬
extern	int			CreateDivGraphFFromGraphImage(		      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY,       int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^番OtBbNnh쐬( float )
extern	int			ReCreateDivGraphFromGraphImage(		      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, const int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̕OtBbNnhɃf[^]
extern	int			ReCreateDivGraphFFromGraphImage(	      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY, const int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̕OtBbNnhɃf[^]( float )
#endif // DX_COMPILE_TYPE_C_LANGUAGE
extern	int			CreateGraphFromGraphImage2(			const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage,                                                                                 int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^OtBbNnh쐬
extern	int			ReCreateGraphFromGraphImage2(		const BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int GrHandle,                                                                   int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̃OtBbNnhɃf[^]
extern	int			CreateDivGraphFromGraphImage2(		      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY,       int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^番OtBbNnh쐬
extern	int			CreateDivGraphFFromGraphImage2(		      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY,       int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^番OtBbNnh쐬( float )
extern	int			ReCreateDivGraphFromGraphImage2(	      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, const int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̕OtBbNnhɃf[^]
extern	int			ReCreateDivGraphFFromGraphImage2(	      BASEIMAGE *RgbBaseImage, const BASEIMAGE *AlphaBaseImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY, const int *HandleArray, int TextureFlag DEFAULTPARAM( = TRUE ) , int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																// {C[Wf[^̕OtBbNnhɃf[^]( float )
extern	int			CreateGraph(						int Width, int Height, int Pitch, const void *RGBImage, const void *AlphaImage DEFAULTPARAM( = NULL ) , int GrHandle DEFAULTPARAM( = -1 ) ) ;																																		// ̃rbg}bvC[WOtBbNnh쐬
extern	int			CreateDivGraph(						int Width, int Height, int Pitch, const void *RGBImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, int *HandleArray, const void *AlphaImage DEFAULTPARAM( = NULL ) ) ;																								// ̃rbg}bvC[W番OtBbNnh쐬
extern	int			CreateDivGraphF(					int Width, int Height, int Pitch, const void *RGBImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY, int *HandleArray, const void *AlphaImage DEFAULTPARAM( = NULL ) ) ;																								// ̃rbg}bvC[W番OtBbNnh쐬( float )
extern	int			ReCreateGraph(						int Width, int Height, int Pitch, const void *RGBImage, int GrHandle, const void *AlphaImage DEFAULTPARAM( = NULL ) ) ;																																								// ̃rbg}bvC[WOtBbNnhč쐬
#ifndef DX_NON_SOFTIMAGE
extern	int			CreateBlendGraphFromSoftImage(		int SIHandle ) ;																														// \tgEGAňC[Wuhp摜OtBbNnh쐬( -1:G[  -1ȊO:uhpOtBbNnh )
extern	int			CreateGraphFromSoftImage(			int SIHandle ) ;																														// \tgEGAňC[WOtBbNnh쐬( -1:G[  -1ȊO:OtBbNnh )
extern	int			CreateGraphFromRectSoftImage(		int SIHandle, int x, int y, int SizeX, int SizeY ) ;																					// \tgEGAňC[W̎ẅ̗găOtBbNnh쐬( -1:G[  -1ȊO:OtBbNnh )
extern	int			ReCreateGraphFromSoftImage(			int SIHandle, int GrHandle ) ;																											// \tgEGAňC[W̃OtBbNnhɉ摜f[^]
extern	int			ReCreateGraphFromRectSoftImage(		int SIHandle, int x, int y, int SizeX, int SizeY, int GrHandle ) ;																		// \tgEGAňC[W̃OtBbNnhɉ摜f[^]
extern	int			CreateDivGraphFromSoftImage(		int SIHandle, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, int *HandleArray ) ;											// \tgEGAňC[W番OtBbNnh쐬
extern	int			CreateDivGraphFFromSoftImage(		int SIHandle, int AllNum, int XNum, int YNum, float SizeX, float SizeY, int *HandleArray ) ;											// \tgEGAňC[W番OtBbNnh쐬( float )
extern	int			ReCreateDivGraphFromSoftImage(		int SIHandle, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, const int *HandleArray ) ;										// \tgEGAňC[W̕OtBbNnhɃf[^]
extern	int			ReCreateDivGraphFFromSoftImage(	    int SIHandle, int AllNum, int XNum, int YNum, float SizeX, float SizeY, const int *HandleArray ) ;										// \tgEGAňC[W̕OtBbNnhɃf[^]( float )
#endif // DX_NON_SOFTIMAGE
extern	int			CreateGraphFromBaseImage(			const BASEIMAGE *BaseImage ) ;																											// {C[Wf[^OtBbNnh쐬
extern	int			CreateGraphFromRectBaseImage(		const BASEIMAGE *BaseImage, int x, int y, int SizeX, int SizeY ) ;																		// {C[Wf[^̎ẅ̗găOtBbNnh쐬
extern	int			ReCreateGraphFromBaseImage(			const BASEIMAGE *BaseImage,                                     int GrHandle ) ;														// {C[Wf[^̃OtBbNnhɉ摜f[^]
extern	int			ReCreateGraphFromRectBaseImage(		const BASEIMAGE *BaseImage, int x, int y, int SizeX, int SizeY, int GrHandle ) ;														// {C[Wf[^̎ẅ̗gĊ̃OtBbNnhɉ摜f[^]
extern	int			CreateDivGraphFromBaseImage(		      BASEIMAGE *BaseImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, int *HandleArray ) ;								// {C[Wf[^番OtBbNnh쐬
extern	int			CreateDivGraphFFromBaseImage(		      BASEIMAGE *BaseImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY, int *HandleArray ) ;								// {C[Wf[^番OtBbNnh쐬( float )
extern	int			ReCreateDivGraphFromBaseImage(		      BASEIMAGE *BaseImage, int AllNum, int XNum, int YNum, int   SizeX, int   SizeY, const int *HandleArray ) ;						// {C[Wf[^̕OtBbNnhɃf[^]
extern	int			ReCreateDivGraphFFromBaseImage(	          BASEIMAGE *BaseImage, int AllNum, int XNum, int YNum, float SizeX, float SizeY, const int *HandleArray ) ;						// {C[Wf[^̕OtBbNnhɃf[^]( float )
extern	int			ReloadGraph(						const TCHAR *FileName,                        int GrHandle, int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																		// 摜t@COtBbNnh։摜f[^]
extern	int			ReloadGraphWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int GrHandle, int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;																		// 摜t@COtBbNnh։摜f[^]
extern	int			ReloadDivGraph(						const TCHAR *FileName,                        int AllNum, int XNum, int YNum, int   XSize, int   YSize, const int *HandleArray, int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜t@COtBbNnh։摜f[^𕪊]
extern	int			ReloadDivGraphWithStrLen(			const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, int   XSize, int   YSize, const int *HandleArray, int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜t@COtBbNnh։摜f[^𕪊]
extern	int			ReloadDivGraphF(					const TCHAR *FileName,                        int AllNum, int XNum, int YNum, float XSize, float YSize, const int *HandleArray, int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜t@COtBbNnh։摜f[^𕪊]( float )
extern	int			ReloadDivGraphFWithStrLen(			const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, float XSize, float YSize, const int *HandleArray, int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜t@COtBbNnh։摜f[^𕪊]( float )
extern	int			ReloadReverseGraph(					const TCHAR *FileName,                        int GrHandle ) ;																			// ReloadGraph ̉摜]ǉ
extern	int			ReloadReverseGraphWithStrLen(		const TCHAR *FileName, size_t FileNameLength, int GrHandle ) ;																			// ReloadGraph ̉摜]ǉ
extern	int			ReloadReverseDivGraph(				const TCHAR *FileName,                        int AllNum, int XNum, int YNum, int   XSize, int   YSize, const int *HandleArray ) ;		// ReloadDivGraph ̉摜]ǉ
extern	int			ReloadReverseDivGraphWithStrLen(	const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, int   XSize, int   YSize, const int *HandleArray ) ;		// ReloadDivGraph ̉摜]ǉ
extern	int			ReloadReverseDivGraphF(				const TCHAR *FileName,                        int AllNum, int XNum, int YNum, float XSize, float YSize, const int *HandleArray ) ;		// ReloadDivGraph ̉摜]ǉ( float )
extern	int			ReloadReverseDivGraphFWithStrLen(	const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, float XSize, float YSize, const int *HandleArray ) ;		// ReloadDivGraph ̉摜]ǉ( float )

// OtBbNnh쐬ݒW֐
extern	int			SetGraphColorBitDepth(						int ColorBitDepth ) ;							// SetCreateGraphColorBitDepth ̋
extern 	int			GetGraphColorBitDepth(						void ) ;										// GetCreateGraphColorBitDepth ̋
extern	int			SetCreateGraphColorBitDepth(				int BitDepth ) ;								// 쐬OtBbNnh̐F[xݒ肷
extern	int			GetCreateGraphColorBitDepth(				void ) ;										// 쐬OtBbNnh̐F[x擾
extern	int			SetCreateGraphChannelBitDepth(				int BitDepth ) ;								// 쐬OtBbNnĥP`lӂ̃rbg[xݒ肷
extern	int			GetCreateGraphChannelBitDepth(				void ) ;										// 쐬OtBbNnĥP`lӂ̃rbg[x擾
extern	int			SetCreateGraphInitGraphDelete(				int Flag ) ;									// 쐬OtBbNnh InitGraph() ō폜邩ݒ肷( Flag  TRUE:InitGraphō폜(ftHg)  FALSE:InitGraphō폜Ȃ )
extern	int			GetCreateGraphInitGraphDelete(				void ) ;										// 쐬OtBbNnh InitGraph() ō폜邩擾( Flag  TRUE:InitGraphō폜(ftHg)  FALSE:InitGraphō폜Ȃ )
extern	int			SetCreateGraphHandle(						int GrHandle ) ;								// 쐬OtBbNnh̃nhlݒ肷AOȉ̒lnƐݒ( ݂ȂOtBbNnh̒l̏ꍇ̂ݗL )
extern	int			GetCreateGraphHandle(						void ) ;										// 쐬OtBbNnh̃nhl擾
extern	int			SetCreateDivGraphHandle(					const int *HandleArray, int HandleNum ) ;		// 쐬OtBbNnh̃nhlݒ肷ALoadDivGraph ̕摜ǂݍݗpAHandleArray  NULL nƐݒ( ݂ȂOtBbNnh̒l̏ꍇ̂ݗL )
extern	int			GetCreateDivGraphHandle(					int *HandleArray ) ;							// 쐬OtBbNnh̃nhl擾ALoadDivGraph ̕摜ǂݍݗpA߂l SetCreateDivGraphHandle ̈ HandleNum ɓnlAHandleArray  NULL ł
extern	int			SetDrawValidGraphCreateFlag(				int Flag ) ;									// SetDrawScreen ɈƂēn( `ΏۂƂĎgpł )OtBbNnh쐬邩ǂݒ肷( TRUE:`\OtBbNnh쐬  FLASE:ʏ̃OtBbNnh쐬( ftHg ) )
extern	int			GetDrawValidGraphCreateFlag(				void ) ;										// SetDrawScreen ɈƂēn( `ΏۂƂĎgpł )OtBbNnh쐬邩ǂݒ擾
extern	int			SetDrawValidFlagOf3DGraph(					int Flag ) ;									// SetDrawValidGraphCreateFlag ̋
extern	int			SetLeftUpColorIsTransColorFlag(				int Flag ) ;									// 摜t@COtBbNnh쐬ۂɉ摜̐F𓧉ߐFƂĈǂݒ肷( TRUE:ߐFƂĈ @FALSE:ߐFƂĈȂ( ftHg ) )
extern	int			SetUsePaletteGraphFlag(						int Flag ) ;									// ǂݍމ摜pbg摜̏ꍇApbg摜ƂĎgpłꍇ̓pbg摜ƂĎgp邩ǂݒ肷( TRUE:pbg摜ƂĎgpłꍇ̓pbg摜ƂĎgp( ftHg )  FALSE:pbg摜ƂĎgpłꍇpbg摜ƂĂ͎gpȂ( ʏ^Cv̉摜ɕϊĎgp ) )
extern	int			SetUseBlendGraphCreateFlag(					int Flag ) ;									// uhp摜쐬邩ǂ( v͉摜̐ԐƂĈǂ )̐ݒs( TRUE:uh摜Ƃēǂݍ  FALSE:ʏ摜Ƃēǂݍ( ftHg ) )
extern	int			GetUseBlendGraphCreateFlag(					void ) ;										// uhp摜쐬邩ǂ( v͉摜̐ԐƂĈǂ )̐ݒ擾
extern	int			SetUseAlphaTestGraphCreateFlag(				int Flag ) ;									// At@eXggpOtBbNnh쐬邩ǂݒ肷( TRUE:At@eXggp( ftHg )  FALSE:At@eXggpȂ )
extern	int			GetUseAlphaTestGraphCreateFlag(				void ) ;										// At@eXggpOtBbNnh쐬邩ǂ擾
extern	int			SetUseAlphaTestFlag(						int Flag ) ;									// SetUseAlphaTestGraphCreateFlag ̋
extern	int			GetUseAlphaTestFlag(						void ) ;										// GetUseAlphaTestGraphCreateFlag ̋
extern	int			SetCubeMapTextureCreateFlag(				int Flag ) ;									// L[u}bveNX`쐬邩ǂ̃tOݒ肷
extern	int			GetCubeMapTextureCreateFlag(				void ) ;										// L[u}bveNX`쐬邩ǂ̃tO擾
extern	int			SetUseNoBlendModeParam(						int Flag ) ;									// SetDrawBlendMode ֐̑ DX_BLENDMODE_NOBLEND ۂɁAftHgł͓͑łQTTw肵ƂɂȂ邪A̎QTTȂǂݒ肷( TRUE:Ȃ(̒lgp)   FALSE:(̒l͖ 255 Ɏgp)(ftHg) )`lt摜ɑ΂ĕ`sꍇ݈̂Ӗ֐
extern	int			SetDrawValidAlphaChannelGraphCreateFlag(	int Flag ) ;									// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )`ltOtBbNnh쐬邩ǂݒ肷( SetDrawValidGraphCreateFlag ֐ŕ`ΏۂƂĎgpłOtBbNnh쐬悤ɐݒ肳ĂȂƌʂ܂ )( TRUE:`lt   FALSE:`lȂ( ftHg ) )
extern	int			GetDrawValidAlphaChannelGraphCreateFlag(	void ) ;										// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )`ltOtBbNnh쐬邩ǂ擾
extern	int			SetDrawValidFloatTypeGraphCreateFlag(		int Flag ) ;									// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )sNZtH[}bg_^̃OtBbNnh쐬邩ǂݒ肷( SetDrawValidGraphCreateFlag ֐ŕ`ΏۂƂĎgpłOtBbNnh쐬悤ɐݒ肳ĂȂƌʂ܂ )AOtBbNXfoCX_^̃sNZtH[}bgɑΉĂȂꍇ̓OtBbNnh̍쐬Ɏs( TRUE:_^@@FALSE:^( ftHg ) )
extern	int			GetDrawValidFloatTypeGraphCreateFlag(		void ) ;										// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )sNZtH[}bg_^̃OtBbNnh쐬邩ǂ擾
extern	int			SetDrawValidGraphCreateZBufferFlag(			int Flag ) ;									// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnh쐬ۂɐp̂yobt@쐬邩ǂݒ肷( TRUE:p̂yobt@쐬( ftHg )  FALSE:p̂yobt@͍쐬Ȃ )
extern	int			GetDrawValidGraphCreateZBufferFlag(			void ) ;										// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnh쐬ۂɐp̂yobt@쐬邩ǂ擾
extern	int			SetCreateDrawValidGraphZBufferBitDepth(		int BitDepth ) ;								// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnhɓKpyobt@̃rbg[xݒ肷( BitDepth:rbg[x( w\Ȓl 16, 24, 32 ̉ꂩ( SetDrawValidGraphCreateFlag ֐ŕ`ΏۂƂĎgpłOtBbNnh쐬悤ɐݒ肳ĂȂƌʂ܂ )
extern	int			GetCreateDrawValidGraphZBufferBitDepth(		void ) ;										// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnhɓKpyobt@̃rbg[x擾
extern	int			SetCreateDrawValidGraphMipLevels(			int MipLevels ) ;								// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnhɓKpMipMap̃xݒ肷
extern	int			GetCreateDrawValidGraphMipLevels(			void ) ;										// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnhɓKpMipMap̃x擾
extern	int			SetCreateDrawValidGraphChannelNum(			int ChannelNum ) ;								// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnhɓKpF̃`lݒ肷( ChannelNum:`l( w\Ȓl 1, 2, 4 ̉ꂩ( SetDrawValidGraphCreateFlag ֐ŕ`ΏۂƂĎgpłOtBbNnh쐬悤ɐݒ肳ĂȂƌʂ܂ )
extern	int			GetCreateDrawValidGraphChannelNum(			void ) ;										// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnhɓKpF̃`l擾
extern	int			SetCreateDrawValidGraphMultiSample(			int Samples, int Quality ) ;					// SetDrawScreen ̈Ƃēn( `ΏۂƂĎgpł )OtBbNnhɓKp}`TvO( A`GCAVO )ݒs( Samples:}`TvɎgphbg( قǏdȂ܂ )  Quality:}`Tv̕i )
extern	int			SetDrawValidMultiSample(					int Samples, int Quality ) ;					// SetCreateDrawValidGraphMultiSample ̋
extern	int			GetMultiSampleQuality(						int Samples ) ;									// w̃}`TvŎgpłőNIeBl擾( ߂l}CiX̏ꍇ͈̃TvgpłȂƂ܂ )
extern	int			SetUseTransColor(							int Flag ) ;									// ߐF@\gp邩ǂݒ肷( TRUE:gp( ftHg )  FALSE:gpȂ )
extern	int			SetUseTransColorGraphCreateFlag(			int Flag ) ;									// ߐF@\gp邱ƂOƂ摜f[^̓ǂݍݏsǂݒ肷( TRUE ɂ SetDrawMode( DX_DRAWMODE_BILINEAR ); Ԃ DrawGraphF ̕_^W󂯎֐ŏ_ȉ̒lw肵ꍇɔ`挋ʂ̕sRɘaʂ܂ ( ftHg FALSE ) )
extern 	int			SetUseGraphAlphaChannel(					int Flag ) ;									// SetUseAlphaChannelGraphCreateFlag ̋
extern 	int			GetUseGraphAlphaChannel(					void ) ;										// GetUseAlphaChannelGraphCreateFlag ̋
extern 	int			SetUseAlphaChannelGraphCreateFlag(			int Flag ) ;									// `ltOtBbNnh쐬邩ǂݒ肷( TRUE:`lt   FALSE:`l )
extern 	int			GetUseAlphaChannelGraphCreateFlag(			void ) ;										// `ltOtBbNnh쐬邩ǂ擾( TRUE:`lt   FALSE:`l )
extern	int			SetUseNotManageTextureFlag(					int Flag ) ;									// Direct3D ̊ǗeNX`@\gpOtBbNnh쐬邩ǂݒ肷( TRUE:Ǘ@\gp( ftHg )  FALSE:Ǘ@\gpȂ )AǗ@\gpƃOtBbNXfoCX̂uq`leʈȏ̉摜ƂłɃVXe̎gpʂ܂
extern	int			GetUseNotManageTextureFlag(					void ) ;										// Direct3D ̊ǗeNX`@\gpOtBbNnh쐬邩ǂ擾
extern	int			SetUsePlatformTextureFormat(				int PlatformTextureFormat ) ;					// 쐬OtBbNnhŎgpˑ̃eNX`tH[}bgw肷( Direct3D9Ȃ DX_TEXTUREFORMAT_DIRECT3D9_R8G8B8 ȂǁA0 nƉ )
extern	int			GetUsePlatformTextureFormat(				void ) ;										// 쐬OtBbNnhŎgpˑ̃eNX`tH[}bg擾
extern	int			SetTransColor(								int Red, int Green, int Blue ) ;				// 쐬OtBbNnhɓKp铧ߐFݒ肷( Red,Green,Blue:ߐF̂RFŕ\( eFO`QTT ) )
extern	int			GetTransColor(								int *Red, int *Green, int *Blue ) ;				// 쐬OtBbNnhɓKp铧ߐF擾
extern	int			SetUseDivGraphFlag(							int Flag ) ;									// Q̂ł͂ȂTCỶ摜𕡐̃eNX`gpĂuq`l̖ʂȂǂݒ肷( TRUE:̃eNX`gp   FALSE:Ȃׂꖇ̃eNX`ōς܂( ftHg ) )ÃeNX`gpꍇ͂uq`leʂ̐ߖ񂪂łɑx̒ቺoCjAtB^O`掞ɃeNX`ƃeNX`̋ڂǂƂ킩铙̕Q܂
extern	int			SetUseAlphaImageLoadFlag(					int Flag ) ;									// LoadGraph Ȃǂ̍ۂɃt@C̖ _a tAt@`lp̉摜t@Cǉœǂݍޏsǂݒ肷( TRUE:s( ftHg )  FALSE:sȂ )
extern	int			SetUseMaxTextureSize(						int Size ) ;									// gpeNX`[̍őTCYݒ肷( ftHgł̓OtBbNXfoCXΉĂőeNX`[TCYA 0 nƃftHgݒɂȂ܂ )
extern	int			SetUseGraphBaseDataBackup(					int Flag ) ;									// OtBbNnh쐬ۂɎgp摜f[^̃obNAbv Direct3DDevice ̃foCXXgɎgp邩ǂݒ肷( TRUE:obNAbv( ftHg )  FALSE:obNAbvȂ )AobNAbvȂƃ̐ߖɂȂ܂AAɊ|鎞ԂȂÃt@CC[WOtBbNnh쐬ꍇ͎AłȂȂǂ̕Q܂
extern	int			GetUseGraphBaseDataBackup(					void ) ;										// OtBbNnh쐬ۂɎgp摜f[^̃obNAbv Direct3DDevice ̃foCXXgɎgp邩ǂ擾
extern	int			SetUseSystemMemGraphCreateFlag(				int Flag ) ;									// ( ݌ʂȂ )OtBbNnh摜f[^VXeɍ쐬邩ǂݒ肷( TRUE:VXeɍ쐬  FALSE:uq`lɍ쐬( ftHg ) )
extern	int			GetUseSystemMemGraphCreateFlag(				void ) ;										// ( ݌ʂȂ )OtBbNnh摜f[^VXeɍ쐬邩ǂ擾
extern	int			SetUseLoadDivGraphSizeCheckFlag(			int Flag ) ;									// LoadDivGraph n̕摜ǂݍ݊֐ŃTCỸ`FbNsǂݒ肷( Flag:TRUE( `FbNs(ftHg) )  FALSE:`FbNsȂ )
extern	int			GetUseLoadDivGraphSizeCheckFlag(			void ) ;										// LoadDivGraph n̕摜ǂݍ݊֐ŃTCỸ`FbNsǂ̐ݒ擾

// 摜֌W֐
extern	const unsigned int* GetFullColorImage(				int GrHandle ) ;																// w̃OtBbNnĥ`qfaWC[W擾( ݓt@COtBbNnhœǂݍ񂾏ꍇ̂ݎgp\ )

extern	int			GraphLock(						int GrHandle, int *PitchBuf, void **DataPointBuf, COLORDATA **ColorDataPP DEFAULTPARAM( = NULL ), int WriteOnly DEFAULTPARAM( = FALSE ) ) ;	// OtBbN̈̃bN
extern	int			GraphUnLock(					int GrHandle ) ;																							// OtBbN̈̃bN

extern	int			SetUseGraphZBuffer(				int GrHandle, int UseFlag, int BitDepth DEFAULTPARAM( = -1 ) ) ;						// OtBbNnhp̂yobt@ǂݒ肷( GrHandle:ΏۂƂȂOtBbNnh( `ΏۂƂĎgp\ȃOtBbNnĥݗL )  UseFlag:p̂yobt@ǂ( TRUE:( ftHg )  FALSE:Ȃ )  BitDepth:rbg[x( 16 or 24 or 32 ) )
extern	int			CopyGraphZBufferImage(			int DestGrHandle, int SrcGrHandle ) ;													// OtBbNnĥyobt@̏Ԃʂ̃OtBbNnĥyobt@ɃRs[( DestGrHandle  SrcGrHandle yobt@Ă`ΏۂɂłOtBbNnhŁATCYłA}`TvO( A`GCAX )ݒ肪Ƃ )

extern	int			SetDeviceLostDeleteGraphFlag(	int GrHandle, int DeleteFlag ) ;														// OtBbNXfoCX̃foCXXgɎw̃OtBbNnh폜邩ǂݒ肷( TRUE:foCXXgɍ폜  FALSE:foCXXgĂ폜Ȃ )

extern	int			GetGraphSize(					int GrHandle, int   *SizeXBuf, int   *SizeYBuf ) ;										// OtBbNnh摜̃TCY𓾂
extern	int			GetGraphSizeF(					int GrHandle, float *SizeXBuf, float *SizeYBuf ) ;										// OtBbNnh摜̃TCY𓾂( float^ )
extern	int			GetGraphTextureSize(			int GrHandle, int   *SizeXBuf, int   *SizeYBuf ) ;										// OtBbNnhڂ̃eNX`̃TCY𓾂
extern	int			GetGraphUseBaseGraphArea(		int GrHandle, int   *UseX,     int   *UseY,    int *UseSizeX, int *UseSizeY ) ;			// LoadDivGraph  DerivationGraph Ō摜̈ꕔgpĂꍇɁAw̃OtBbNnhgpĂ錳摜͈̔͂擾
extern	int			GetGraphMipmapCount(			int GrHandle ) ;																		// OtBbNnheNX`̃~bv}bvx擾
extern	int			GetGraphFilePath(				int GrHandle, TCHAR *FilePathBuffer ) ;													// OtBbNnh摜t@Cǂݍ܂ĂꍇẢ摜̃t@CpX擾
extern	int			CheckDrawValidGraph(			int GrHandle ) ;																		// w̃OtBbNnh`Ώۂɂł( SetDrawScreen ̈ɓn )OtBbNnhǂ擾( ߂l@TRUE:`ΏۂɂłOtBbNnh@FALSE:`ΏۂɂłȂOtBbNnh )

extern	const COLORDATA* GetTexColorData(			int AlphaCh, int AlphaTest, int ColorBitDepth, int DrawValid DEFAULTPARAM( = FALSE ) ) ;	// J[f[^𓾂
#ifndef DX_COMPILE_TYPE_C_LANGUAGE
extern	const COLORDATA* GetTexColorData(			const IMAGEFORMATDESC *Format ) ;														// tH[}bgɊÂJ[f[^𓾂
extern	const COLORDATA* GetTexColorData(			int FormatIndex /* DX_GRAPHICSIMAGE_FORMAT_3D_RGB32  */ ) ;							// w̃tH[}bgCfbNX̃J[f[^𓾂
#endif // DX_COMPILE_TYPE_C_LANGUAGE
extern	const COLORDATA* GetTexColorData2(			const IMAGEFORMATDESC *Format ) ;														// tH[}bgɊÂJ[f[^𓾂
extern	const COLORDATA* GetTexColorData3(			int FormatIndex /* DX_GRAPHICSIMAGE_FORMAT_3D_RGB32  */ ) ;							// w̃tH[}bgCfbNX̃J[f[^𓾂
extern	int			GetMaxGraphTextureSize(			int *SizeX, int *SizeY ) ;																// OtBbNXfoCXΉĂőeNX`TCY擾
extern	int			GetValidRestoreShredPoint(		void ) ;																				// OtBbNnh̉摜𕜌֐o^Ă邩ǂ擾( TRUE:o^Ă  FALSE:o^ĂȂ )
extern	int			GetCreateGraphColorData(		COLORDATA *ColorData, IMAGEFORMATDESC *Format ) ;										// ( ݌ʂȂ )ꂩVɃOtBbN쐬ꍇɎgpJ[擾

// 摜pbg֌W֐( \tgEGA摜̂ݎgp\ )
extern	int			GetGraphPalette(				int GrHandle, int ColorIndex, int *Red, int *Green, int *Blue ) ;						// OtBbNnh̃pbg擾( \tgEGA_O[hŁApbg摜̏ꍇ̂ݎgp\ )
extern  int			GetGraphOriginalPalette(		int GrHandle, int ColorIndex, int *Red, int *Green, int *Blue ) ;						// OtBbNnh SetGraphPalette ŕύXÕpbg擾( \tgEGA_O[hŁApbg摜̏ꍇ̂ݎgp\ )
extern	int			SetGraphPalette(				int GrHandle, int ColorIndex, unsigned int Color ) ;									// OtBbNnh̃pbgύX( \tgEGA_O[hŁApbg摜̏ꍇ̂ݎgp\ )
extern	int			ResetGraphPalette(				int GrHandle ) ;																		// SetGraphPalette ŕύXpbgSČɖ߂( \tgEGA_O[hŁApbg摜̏ꍇ̂ݎgp\ )

// }``֐
extern	int			DrawLine(         int   x1, int   y1, int   x2, int   y2,                                         unsigned int Color, int   Thickness DEFAULTPARAM( = 1 )    ) ;							// `悷
extern	int			DrawLineAA(       float x1, float y1, float x2, float y2,                                         unsigned int Color, float Thickness DEFAULTPARAM( = 1.0f ) ) ;							// `悷( A`GCAXt )
extern	int			DrawBox(          int   x1, int   y1, int   x2, int   y2,                                         unsigned int Color, int FillFlag, int   LineThickness DEFAULTPARAM( = 1 )    ) ;			// lp``悷
extern	int			DrawBoxAA(        float x1, float y1, float x2, float y2,                                         unsigned int Color, int FillFlag, float LineThickness DEFAULTPARAM( = 1.0f ) ) ;			// lp``悷( A`GCAXt )
extern	int			DrawFillBox(      int   x1, int   y1, int   x2, int   y2,                                         unsigned int Color ) ;																	// ghԂlp``悷
extern	int			DrawLineBox(      int   x1, int   y1, int   x2, int   y2,                                         unsigned int Color, int LineThickness DEFAULTPARAM( = 1 ) ) ;								// g̎lp`̕` 
extern	int			DrawCircle(       int   x,  int   y,  int   r,                                                    unsigned int Color, int FillFlag DEFAULTPARAM( = TRUE ), int   LineThickness DEFAULTPARAM( = 1 )    ) ;	// ~`悷
extern	int			DrawCircleAA(     float x,  float y,  float r,            int posnum,                             unsigned int Color, int FillFlag DEFAULTPARAM( = TRUE ), float LineThickness DEFAULTPARAM( = 1.0f ), double Angle DEFAULTPARAM( = 0.0 ) ) ;	// ~`悷( A`GCAXt )
extern	int			DrawOval(         int   x,  int   y,  int   rx, int   ry,                                         unsigned int Color, int FillFlag,        int   LineThickness DEFAULTPARAM( = 1 )    ) ;	// ȉ~`悷
extern	int			DrawOvalAA(       float x,  float y,  float rx, float ry, int posnum,                             unsigned int Color, int FillFlag,        float LineThickness DEFAULTPARAM( = 1.0f ) ) ;	// ȉ~`悷( A`GCAXt )
extern	int			DrawOval_Rect(    int   x1, int   y1, int   x2, int   y2,                                         unsigned int Color, int FillFlag ) ;														// w̋`Ɏ܂~( ȉ~ )`悷
extern	int			DrawTriangle(     int   x1, int   y1, int   x2, int   y2, int   x3, int   y3,                     unsigned int Color, int FillFlag ) ;														// Op``悷
extern	int			DrawTriangleAA(   float x1, float y1, float x2, float y2, float x3, float y3,                     unsigned int Color, int FillFlag, float LineThickness DEFAULTPARAM( = 1.0f ) ) ;			// Op``悷( A`GCAXt )
extern	int			DrawQuadrangle(   int   x1, int   y1, int   x2, int   y2, int   x3, int   y3, int   x4, int   y4, unsigned int Color, int FillFlag ) ;														// lp``悷
extern	int			DrawQuadrangleAA( float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, unsigned int Color, int FillFlag, float LineThickness DEFAULTPARAM( = 1.0f ) ) ;			// lp``悷( A`GCAXt )
extern	int			DrawRoundRect(    int   x1, int   y1, int   x2, int   y2, int   rx, int   ry,                     unsigned int Color, int FillFlag ) ;														// p̊ۂlp``悷
extern	int			DrawRoundRectAA(  float x1, float y1, float x2, float y2, float rx, float ry, int posnum,         unsigned int Color, int FillFlag, float LineThickness DEFAULTPARAM( = 1.0f ) ) ;			// p̊ۂlp``悷( A`GCAXt )
extern	int			BeginAADraw(      void ) ;																																									// DrawTriangleAA Ȃǂ̃A`GCAXt}``̏s
extern	int			EndAADraw(        void ) ;																																									// DrawTriangleAA Ȃǂ̃A`GCAXt}``̌ns
extern 	int			DrawPixel(        int   x,  int   y,                                                              unsigned int Color ) ;																	// _`悷

extern	int			Paint(			int x, int y, unsigned int FillColor, ULONGLONG BoundaryColor DEFAULTPARAM( = ULL_PARAM( 0xffffffffffffffff ) ) ) ;				// w_狫EFƂ܂œhԂ(EF -1 ɂƎw_̐F̗̈hԂ)

extern 	int			DrawPixelSet(   const POINTDATA *PointDataArray, int Num ) ;																					// _̏W`悷
extern	int			DrawLineSet(    const LINEDATA *LineDataArray,   int Num ) ;																					// ̏W`悷
extern	int			DrawBoxSet(     const RECTDATA *RectDataArray,   int Num ) ;																					// `̏W`悷

extern	int			DrawPixel3D(     VECTOR   Pos,                                                                 unsigned int Color ) ;							// Rc̓_`悷
extern	int			DrawPixel3DD(    VECTOR_D Pos,                                                                 unsigned int Color ) ;							// Rc̓_`悷
extern	int			DrawLine3D(      VECTOR   Pos1,   VECTOR   Pos2,                                               unsigned int Color ) ;							// Rc̐`悷
extern	int			DrawLine3DD(     VECTOR_D Pos1,   VECTOR_D Pos2,                                               unsigned int Color ) ;							// Rc̐`悷
extern	int			DrawTriangle3D(  VECTOR   Pos1,   VECTOR   Pos2, VECTOR   Pos3,                                unsigned int Color, int FillFlag ) ;				// Rc̎Op``悷
extern	int			DrawTriangle3DD( VECTOR_D Pos1,   VECTOR_D Pos2, VECTOR_D Pos3,                                unsigned int Color, int FillFlag ) ;				// Rc̎Op``悷
extern	int			DrawCube3D(      VECTOR   Pos1,   VECTOR   Pos2,                            unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rĉ̗`悷
extern	int			DrawCube3DD(     VECTOR_D Pos1,   VECTOR_D Pos2,                            unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rĉ̗`悷
extern	int			DrawCubeSet3D(   CUBEDATA *CubeDataArray, int Num, int FillFlag ) ;																				// Rĉ̗̏W`悷
extern	int			DrawSphere3D(    VECTOR   CenterPos,                  float  r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̋̂`悷
extern	int			DrawSphere3DD(   VECTOR_D CenterPos,                  double r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̋̂`悷
extern	int			DrawCapsule3D(   VECTOR   Pos1,   VECTOR   Pos2,      float  r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̃JvZ`悷
extern	int			DrawCapsule3DD(  VECTOR_D Pos1,   VECTOR_D Pos2,      double r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̃JvZ`悷
extern	int			DrawCylinder3D(  VECTOR   Pos1,   VECTOR   Pos2,      float  r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̉~`悷
extern	int			DrawCylinder3DD( VECTOR_D Pos1,   VECTOR_D Pos2,      double r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̉~`悷
extern	int			DrawTube3D(      VECTOR   Pos1,   VECTOR   Pos2,      float  r1, float  r2, int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̓`悷
extern	int			DrawTube3DD(     VECTOR_D Pos1,   VECTOR_D Pos2,      double r1, double r2, int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̓`悷
extern	int			DrawCone3D(      VECTOR   TopPos, VECTOR   BottomPos, float  r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̉~`悷
extern	int			DrawCone3DD(     VECTOR_D TopPos, VECTOR_D BottomPos, double r,             int DivNum, unsigned int DifColor, unsigned int SpcColor, int FillFlag ) ;		// Rc̉~`悷

// 摜`֐
extern	int			LoadGraphScreen(           int x, int y, const TCHAR *GraphName,                         int TransFlag ) ;										// 摜t@Cǂ݂ŉʂɕ`悷
extern	int			LoadGraphScreenWithStrLen( int x, int y, const TCHAR *GraphName, size_t GraphNameLength, int TransFlag ) ;										// 摜t@Cǂ݂ŉʂɕ`悷

extern	int			DrawGraph(                int x, int y,                                                                 int GrHandle, int TransFlag ) ;																							// 摜̓{`
extern	int			DrawExtendGraph(          int x1, int y1, int x2, int y2,                                               int GrHandle, int TransFlag ) ;																							// 摜̊g`
extern	int			DrawRotaGraph(            int x, int y,                 double ExRate,                    double Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`
extern	int			DrawRotaGraph2(           int x, int y, int cx, int cy, double ExtRate,                   double Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`Q( ]Swt )
extern	int			DrawRotaGraph3(           int x, int y, int cx, int cy, double ExtRateX, double ExtRateY, double Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ; 	// 摜̉]`R( ]Swt{cg嗦ʎw )
extern	int			DrawRotaGraphFast(        int x, int y,                 float  ExRate,                    float  Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRotaGraphFast2(       int x, int y, int cx, int cy, float  ExtRate,                   float  Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`Q( ]Swt )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRotaGraphFast3(       int x, int y, int cx, int cy, float  ExtRateX, float  ExtRateY, float  Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ; 	// 摜̉]`R( ]Swt{cg嗦ʎw )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawModiGraph(            int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4,               int GrHandle, int TransFlag ) ;																							// 摜̎Rό``
extern	int			DrawTurnGraph(            int x, int y,                                                                 int GrHandle, int TransFlag ) ;																							// 摜̍E]`
extern	int			DrawReverseGraph(         int x, int y,                                                                 int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̔]`

extern	int			DrawGraphF(               float xf, float yf,                                                                       int GrHandle, int TransFlag ) ;															// 摜̕`( Ww肪 float  )
extern	int			DrawExtendGraphF(         float x1f, float y1f, float x2f, float y2f,                                               int GrHandle, int TransFlag ) ;															// 摜̊g`( Ww肪 float  )
extern	int			DrawRotaGraphF(           float xf, float yf,                       double ExRate,                    double Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`( Ww肪 float  )
extern	int			DrawRotaGraph2F(          float xf, float yf, float cxf, float cyf, double ExtRate,                   double Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`Q( ]Swt )( Ww肪 float  )
extern	int			DrawRotaGraph3F(          float xf, float yf, float cxf, float cyf, double ExtRateX, double ExtRateY, double Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ; 	// 摜̉]`R( ]Swt{cg嗦ʎw )( Ww肪 float  )
extern	int			DrawRotaGraphFastF(       float xf, float yf,                       float  ExRate,                    float  Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`( Ww肪 float  )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRotaGraphFast2F(      float xf, float yf, float cxf, float cyf, float  ExtRate,                   float  Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̉]`Q( ]Swt )( Ww肪 float  )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRotaGraphFast3F(      float xf, float yf, float cxf, float cyf, float  ExtRateX, float  ExtRateY, float  Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ; 	// 摜̉]`R( ]Swt{cg嗦ʎw )( Ww肪 float  )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawModiGraphF(           float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4,           int GrHandle, int TransFlag ) ;															// 摜̎Rό``( Ww肪 float  )
extern	int			DrawTurnGraphF(           float xf, float yf,                                                                       int GrHandle, int TransFlag ) ;															// 摜̍E]`( Ww肪 float  )
extern	int			DrawReverseGraphF(        float xf, float yf,                                                                       int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̔]`( Ww肪 float  )

extern	int			DrawChipMap(              int Sx, int Sy, int XNum, int YNum, const int *MapData, int ChipTypeNum, int MapDataPitch, const int *ChipGrHandle, int TransFlag ) ;																											// `bv摜gQc}bv`
#ifndef DX_COMPILE_TYPE_C_LANGUAGE
extern	int			DrawChipMap(              int MapWidth, int MapHeight,        const int *MapData, int ChipTypeNum,                   const int *ChipGrHandle, int TransFlag, int MapDrawPointX, int MapDrawPointY, int MapDrawWidth, int MapDrawHeight, int ScreenX, int ScreenY ) ;	// `bv摜gQc}bv`
#endif // DX_COMPILE_TYPE_C_LANGUAGE
extern	int			DrawChipMap2(             int MapWidth, int MapHeight,        const int *MapData, int ChipTypeNum,                   const int *ChipGrHandle, int TransFlag, int MapDrawPointX, int MapDrawPointY, int MapDrawWidth, int MapDrawHeight, int ScreenX, int ScreenY ) ;	// `bv摜gQc}bv`
extern	int			DrawTile(                 int x1, int y1, int x2, int y2, int Tx, int Ty, double ExtRate, double Angle, int GrHandle, int TransFlag ) ;																																	// 摜ẅɃ^Cɕ`悷

extern	int			DrawRectGraph(            int DestX,  int DestY,                          int SrcX, int SrcY, int    Width, int    Height,                         int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;				// 摜̎w`݂̂𓙔{`
extern	int			DrawRectExtendGraph(      int DestX1, int DestY1, int DestX2, int DestY2, int SrcX, int SrcY, int SrcWidth, int SrcHeight,                         int GraphHandle, int TransFlag ) ;																	// 摜̎w`݂̂g`
extern	int			DrawRectRotaGraph(        int x, int y, int SrcX, int SrcY, int Width, int Height, double ExtRate, double Angle,                                   int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;				// 摜̎w`݂̂]`
extern	int			DrawRectRotaGraph2(       int x, int y, int SrcX, int SrcY, int Width, int Height, int cx, int cy, double ExtRate,  double Angle,                  int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;				// 摜̎w`݂̂]`Q( ]Swt )
extern	int			DrawRectRotaGraph3(       int x, int y, int SrcX, int SrcY, int Width, int Height, int cx, int cy, double ExtRateX, double ExtRateY, double Angle, int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;				// 摜̎w`݂̂]`R( ]Swt{cg嗦ʎw )
extern	int			DrawRectRotaGraphFast(    int x, int y, int SrcX, int SrcY, int Width, int Height, float ExtRate, float Angle,                                     int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;				// 摜̎w`݂̂]`( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRectRotaGraphFast2(   int x, int y, int SrcX, int SrcY, int Width, int Height, int cx, int cy, float ExtRate,  float Angle,                    int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;				// 摜̎w`݂̂]`Q( ]Swt )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRectRotaGraphFast3(   int x, int y, int SrcX, int SrcY, int Width, int Height, int cx, int cy, float ExtRateX, float ExtRateY, float Angle,    int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;				// 摜̎w`݂̂]`R( ]Swt{cg嗦ʎw )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRectModiGraph(        int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int SrcX, int SrcY, int Width, int Height,               int GraphHandle, int TransFlag ) ;																	// 摜̎w`݂̂Rό``

extern	int			DrawRectGraphF(           float DestX,  float DestY,                              int   SrcX, int   SrcY, int    Width, int    Height,                           int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂𓙔{`( Ww肪 float  )
extern	int			DrawRectGraphF2(          float DestX,  float DestY,                              float SrcX, float SrcY, float  Width, float  Height,                           int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂𓙔{`( Ww肪 float ( 摜W̎w float  ) )
extern	int			DrawRectExtendGraphF(     float DestX1, float DestY1, float DestX2, float DestY2, int   SrcX, int   SrcY, int SrcWidth, int SrcHeight,                           int GraphHandle, int TransFlag ) ;														// 摜̎w`݂̂g`( Ww肪 float  )
extern	int			DrawRectExtendGraphF2(    float DestX1, float DestY1, float DestX2, float DestY2, float SrcX, float SrcY, float SrcWidth, float SrcHeight,                   int GraphHandle, int TransFlag ) ;															// 摜̎w`݂̂g`( Ww肪 float ( 摜W̎w float  ) )
extern	int			DrawRectRotaGraphF(       float x, float y, int SrcX, int SrcY, int Width, int Height,                       double ExtRate,                   double Angle, int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂]`( Ww肪 float  )
extern	int			DrawRectRotaGraph2F(      float x, float y, int SrcX, int SrcY, int Width, int Height, float cxf, float cyf, double ExtRate,                   double Angle, int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂]`Q( ]Swt )( Ww肪 float  )
extern	int			DrawRectRotaGraph3F(      float x, float y, int SrcX, int SrcY, int Width, int Height, float cxf, float cyf, double ExtRateX, double ExtRateY, double Angle, int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂]`R( ]Swt{cg嗦ʎw )( Ww肪 float  )
extern	int			DrawRectRotaGraphFastF(   float x, float y, int SrcX, int SrcY, int Width, int Height,                       float ExtRate,                    float  Angle, int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂]`( Ww肪 float  )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRectRotaGraphFast2F(  float x, float y, int SrcX, int SrcY, int Width, int Height, float cxf, float cyf, float ExtRate,                    float  Angle, int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂]`Q( ]Swt )( Ww肪 float  )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRectRotaGraphFast3F(  float x, float y, int SrcX, int SrcY, int Width, int Height, float cxf, float cyf, float ExtRateX,  float  ExtRateY, float  Angle, int GraphHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜̎w`݂̂]`R( ]Swt{cg嗦ʎw )( Ww肪 float  )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRectModiGraphF(       float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int SrcX, int SrcY, int Width, int Height,         int GraphHandle, int TransFlag ) ;															// 摜̎w`݂̂Rό``( Ww肪 float  )

extern	int			DrawBlendGraph(           int   x, int   y, int GrHandle, int TransFlag,                 int BlendGraph, int BorderParam, int BorderRange ) ;									// uh摜ƍĉ摜𓙔{`悷
extern	int			DrawBlendGraphF(          float x, float y, int GrHandle, int TransFlag,                 int BlendGraph, int BorderParam, int BorderRange ) ;									// uh摜ƍĉ摜𓙔{`悷( Ww肪 float  )
extern	int			DrawBlendGraphPos(        int   x, int   y, int GrHandle, int TransFlag, int bx, int by, int BlendGraph, int BorderParam, int BorderRange ) ;									// uh摜ƍĉ摜𓙔{`悷( uh摜̋N_Ww肷t )

extern	int			DrawCircleGauge(          int   CenterX, int   CenterY, double Percent, int GrHandle, double StartPercent DEFAULTPARAM( = 0.0 ) , double Scale DEFAULTPARAM( = 1.0 ) , int ReverseX DEFAULTPARAM( = FALSE ) , int ReverseY DEFAULTPARAM( = FALSE ) ) ;										// ~OtIȕ`s( GrHandle ̉摜̏㉺E̒[͓ߐFɂĂKv܂ )
extern	int			DrawCircleGaugeF(         float CenterX, float CenterY, double Percent, int GrHandle, double StartPercent DEFAULTPARAM( = 0.0 ) , double Scale DEFAULTPARAM( = 1.0 ) , int ReverseX DEFAULTPARAM( = FALSE ) , int ReverseY DEFAULTPARAM( = FALSE ) ) ;										// ~OtIȕ`s( GrHandle ̉摜̏㉺E̒[͓ߐFɂĂKv܂ )( Ww肪 float  )

extern	int			DrawGraphToZBuffer(       int X, int Y,                                                                 int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂ĉ摜̓{`
extern	int			DrawTurnGraphToZBuffer(   int x, int y,                                                                 int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂ĉ摜̍E]`
extern	int			DrawReverseGraphToZBuffer( int x, int y,                                                                int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// yobt@ɑ΂ĉ摜̔]`
extern	int			DrawExtendGraphToZBuffer( int x1, int y1, int x2, int y2,                                               int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂ĉ摜̊g`
extern	int			DrawRotaGraphToZBuffer(   int x, int y, double ExRate, double Angle,                                    int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// yobt@ɑ΂ĉ摜̉]`
extern	int			DrawRotaGraph2ToZBuffer(  int x, int y, int cx, int cy, double ExtRate,                   double Angle, int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// yobt@ɑ΂ĉ摜̉]`Q( ]Swt )
extern	int			DrawRotaGraph3ToZBuffer(  int x, int y, int cx, int cy, double ExtRateX, double ExtRateY, double Angle, int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ; 	// yobt@ɑ΂ĉ摜̉]`R( ]Swt{cg嗦ʎw )
extern	int			DrawRotaGraphFastToZBuffer(  int x, int y, float ExRate, float Angle,                                   int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// yobt@ɑ΂ĉ摜̉]`( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRotaGraphFast2ToZBuffer( int x, int y, int cx, int cy, float ExtRate,                  float Angle, int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;	// yobt@ɑ΂ĉ摜̉]`Q( ]Swt )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawRotaGraphFast3ToZBuffer( int x, int y, int cx, int cy, float ExtRateX, float ExtRateY, float Angle, int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ; 	// yobt@ɑ΂ĉ摜̉]`R( ]Swt{cg嗦ʎw )( ŁAWvZ̃ASYȗĂ܂A`挋ʂɕss΂̕ł )
extern	int			DrawModiGraphToZBuffer(   int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4,               int GrHandle, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂ĉ摜̎Rό``
extern	int			DrawBoxToZBuffer(         int x1, int y1, int x2, int y2,                                               int FillFlag, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂ċ`̕`
extern	int			DrawCircleToZBuffer(      int x, int y, int r,                                                          int FillFlag, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂ĉ~̕`
extern	int			DrawTriangleToZBuffer(    int x1, int y1, int x2, int y2, int x3, int y3,                               int FillFlag, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂ĎOp``悷 
extern	int			DrawQuadrangleToZBuffer(  int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4,               int FillFlag, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂Ďlp``悷
extern	int			DrawRoundRectToZBuffer(   int x1, int y1, int x2, int y2, int rx, int ry,                               int FillFlag, int WriteZMode /* DX_ZWRITE_MASK  */ ) ;														// yobt@ɑ΂Ċp̊ۂlp``悷

extern	int			DrawPolygon(                             const VERTEX    *VertexArray, int PolygonNum,                                                                                                       int GrHandle, int TransFlag, int UVScaling DEFAULTPARAM( = FALSE ) ) ;		// Qc|S`悷( Vertex:Op``钸_z̐擪AhX( _̐̓|S̐~R )  PolygonNum:`悷|S̐  GrHandle:gpOtBbNnh  TransFlag:ߐFsǂ( TRUE:s  FALSE:sȂ )  UVScaling:{FALSEOK )
extern	int			DrawPolygon2D(                           const VERTEX2D  *VertexArray, int PolygonNum,                                                                                                       int GrHandle, int TransFlag ) ;							// Qc|S`悷
extern	int			DrawPolygon3D(                           const VERTEX3D  *VertexArray, int PolygonNum,                                                                                                       int GrHandle, int TransFlag ) ;							// Rc|S`悷
extern	int			DrawPolygonIndexed2D(                    const VERTEX2D  *VertexArray, int VertexNum, const unsigned short *IndexArray, int PolygonNum,                                                      int GrHandle, int TransFlag ) ;							// Qc|S`悷( _CfbNXgp )
extern	int			DrawPolygon32bitIndexed2D(               const VERTEX2D  *VertexArray, int VertexNum, const unsigned int   *IndexArray, int PolygonNum,                                                      int GrHandle, int TransFlag ) ;							// Qc|S`悷( _CfbNXgp )
extern	int			DrawPolygonIndexed3D(                    const VERTEX3D  *VertexArray, int VertexNum, const unsigned short *IndexArray, int PolygonNum,                                                      int GrHandle, int TransFlag ) ;							// Rc|S`悷( _CfbNXgp )
extern	int			DrawPolygon32bitIndexed3D(               const VERTEX3D  *VertexArray, int VertexNum, const unsigned int   *IndexArray, int PolygonNum,                                                      int GrHandle, int TransFlag ) ;							// Rc|S`悷( _CfbNXgp )
extern	int			DrawPolygonIndexed3DBase(                const VERTEX_3D *VertexArray, int VertexNum, const unsigned short *IndexArray, int IndexNum,   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Rc|S`悷( _CfbNXgp )( o[Wp )
extern	int			DrawPolygon32bitIndexed3DBase(           const VERTEX_3D *VertexArray, int VertexNum, const unsigned int   *IndexArray, int IndexNum,   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Rc|S`悷( _CfbNXgp )( o[Wp )
extern	int			DrawPolygon3DBase(                       const VERTEX_3D *VertexArray, int VertexNum,                                                   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Rc|S`悷( o[Wp )
#ifndef DX_COMPILE_TYPE_C_LANGUAGE
extern	int			DrawPolygon3D(                           const VERTEX_3D *VertexArray, int PolygonNum,                                                                                                       int GrHandle, int TransFlag ) ;							// Rc|S`悷( o[Wp )
#endif // DX_COMPILE_TYPE_C_LANGUAGE
extern	int			DrawPolygon3D2(                          const VERTEX_3D *VertexArray, int PolygonNum,                                                                                                       int GrHandle, int TransFlag ) ;							// Rc|S`悷( o[Wp )

extern	int			DrawPolygonBase(                         const VERTEX    *VertexArray, int VertexNum,                                                   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag, int UVScaling DEFAULTPARAM( = FALSE ) ) ;		// Qcv~eBu`悷
extern	int			DrawPrimitive2D(                         const VERTEX2D  *VertexArray, int VertexNum,                                                   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Qcv~eBu`悷
extern	int			DrawPrimitive3D(                         const VERTEX3D  *VertexArray, int VertexNum,                                                   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Rcv~eBu`悷
extern	int			DrawPrimitiveIndexed2D(                  const VERTEX2D  *VertexArray, int VertexNum, const unsigned short *IndexArray, int IndexNum,   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Qcv~eBu`悷(_CfbNXgp)
extern	int			DrawPrimitive32bitIndexed2D(             const VERTEX2D  *VertexArray, int VertexNum, const unsigned int   *IndexArray, int IndexNum,   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Qcv~eBu`悷(_CfbNXgp)
extern	int			DrawPrimitiveIndexed3D(                  const VERTEX3D  *VertexArray, int VertexNum, const unsigned short *IndexArray, int IndexNum,   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Rcv~eBu`悷(_CfbNXgp)
extern	int			DrawPrimitive32bitIndexed3D(             const VERTEX3D  *VertexArray, int VertexNum, const unsigned int   *IndexArray, int IndexNum,   int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int GrHandle, int TransFlag ) ;							// Rcv~eBu`悷(_CfbNXgp)

extern	int			DrawPolygon3D_UseVertexBuffer(           int VertexBufHandle,                                                                                                                                                               int GrHandle, int TransFlag ) ;		// _obt@gpĂRc|S`悷
extern	int			DrawPrimitive3D_UseVertexBuffer(         int VertexBufHandle,                     int PrimitiveType  /* DX_PRIMTYPE_TRIANGLELIST  */,                                                                                     int GrHandle, int TransFlag ) ;		// _obt@gpĂRcv~eBu`悷
extern	int			DrawPrimitive3D_UseVertexBuffer2(        int VertexBufHandle,                     int PrimitiveType  /* DX_PRIMTYPE_TRIANGLELIST  */,                 int StartVertex, int UseVertexNum,                                  int GrHandle, int TransFlag ) ;		// _obt@gpĂRcv~eBu`悷
extern	int			DrawPolygonIndexed3D_UseVertexBuffer(    int VertexBufHandle, int IndexBufHandle,                                                                                                                                           int GrHandle, int TransFlag ) ;		// _obt@ƃCfbNXobt@gpĂRc|S`悷
extern	int			DrawPrimitiveIndexed3D_UseVertexBuffer(  int VertexBufHandle, int IndexBufHandle, int PrimitiveType  /* DX_PRIMTYPE_TRIANGLELIST  */,                                                                                     int GrHandle, int TransFlag ) ;		// _obt@ƃCfbNXobt@gpĂRcv~eBu`悷
extern	int			DrawPrimitiveIndexed3D_UseVertexBuffer2( int VertexBufHandle, int IndexBufHandle, int PrimitiveType  /* DX_PRIMTYPE_TRIANGLELIST  */, int BaseVertex, int StartVertex, int UseVertexNum, int StartIndex, int UseIndexNum, int GrHandle, int TransFlag ) ;		// _obt@ƃCfbNXobt@gpĂRcv~eBu`悷

extern	int			DrawGraph3D(                             float x, float y, float z,                                                                     int GrHandle, int TransFlag ) ;																// 摜̂Rc`
extern	int			DrawExtendGraph3D(                       float x, float y, float z, double ExRateX, double ExRateY,                                     int GrHandle, int TransFlag ) ;																// 摜̊gRc`
extern	int			DrawRotaGraph3D(                         float x, float y, float z, double ExRate, double Angle,                                        int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;		// 摜̉]Rc`
extern	int			DrawRota2Graph3D(                        float x, float y, float z, float cx, float cy, double ExtRateX, double ExtRateY, double Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;		// 摜̉]Rc`(]Sw^)
extern	int			DrawModiBillboard3D(                     VECTOR Pos, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4,    int GrHandle, int TransFlag ) ;																// 摜̎Rό`Rc`
extern	int			DrawBillboard3D(                         VECTOR Pos, float cx, float cy, float Size, float Angle,                                       int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;		// Rcԏɉ摜`


// `ݒ֌W֐
extern	int			SetDrawMode(						int DrawMode ) ;												// `惂[hݒ肷
extern	int			GetDrawMode(						void ) ;														// `惂[h擾
extern	int			SetDrawBlendMode(					int BlendMode, int BlendParam ) ;								// `uh[hݒ肷
extern	int			GetDrawBlendMode(					int *BlendMode, int *BlendParam ) ;								// `uh[h擾
extern	int			SetDrawCustomBlendMode(				int BlendEnable, int SrcBlendRGB /* DX_BLEND_SRC_COLOR  */, int DestBlendRGB /* DX_BLEND_SRC_COLOR  */, int BlendOpRGB /* DX_BLENDOP_ADD  */, int SrcBlendA /* DX_BLEND_SRC_COLOR  */, int DestBlendA /* DX_BLEND_SRC_COLOR  */, int BlendOpA /* DX_BLENDOP_ADD  */, int BlendParam ) ;		// JX^uh[hݒ肷
extern	int			GetDrawCustomBlendMode(				int *BlendEnable, int *SrcBlendRGB, int *DestBlendRGB, int *BlendOpRGB, int *SrcBlendA, int *DestBlendA, int *BlendOpA, int *BlendParam ) ;																																								// JX^uh[h擾
extern	int			SetDrawAlphaTest(					int TestMode, int TestParam ) ;									// `掞̃At@eXg̐ݒs( TestMode:eXg[h( DX_CMP_GREATER -1ŃftHgɖ߂ )  TestParam:`At@lƂ̔rɎgpl( 0`255 ) )
extern	int			GetDrawAlphaTest(					int *TestMode, int *TestParam ) ;								// `掞̃At@eXg̐ݒ擾( TestMode:eXg[h( DX_CMP_GREATER -1ŃftHgɖ߂ )  TestParam:`At@lƂ̔rɎgpl( 0`255 ) )
extern	int			SetBlendGraph(						int BlendGraph, int BorderParam, int BorderRange ) ;			// ( SetBlendGraphParam  BlendType = DX_BLENDGRAPHTYPE_WIPE ̏s֐ )`揈ɕ`悷摜ƃuh郿`lt摜Zbg( BlendGraph  -1 Ńuh@\𖳌 )
extern	int			SetBlendGraphParam(					int BlendGraph, int BlendType, ... ) ;							// `揈ɕ`悷摜ƃuh摜̃uhݒsABlendGraph  -1 ɂΐݒȀꍇ BlendType Ƃ̌̃p[^͖
//		int			SetBlendGraphParam(					int BlendGraph, int BlendType = DX_BLENDGRAPHTYPE_NORMAL, int Ratio = ( 0( uhO )`255( uhPOO ) ) ) ;
//		int			SetBlendGraphParam(					int BlendGraph, int BlendType = DX_BLENDGRAPHTYPE_WIPE, int BorderParam = Eʒu(O`QTT), int BorderRange = E(włl͂PAUSAPQWAQTT̂S) ) ;
//		int			SetBlendGraphParam(					int BlendGraph, int BlendType = DX_BLENDGRAPHTYPE_ALPHA ) ;
extern	int			SetBlendGraphPosition(				int x, int y ) ;												// uh摜̋N_WZbg
extern	int			SetBlendGraphPositionMode(			int BlendGraphPositionMode /* DX_BLENDGRAPH_POSMODE_DRAWGRAPH Ȃ */ ) ;	// uh摜̓KW[hݒ肷
extern	int			SetDrawBright(						int RedBright, int GreenBright, int BlueBright ) ;				// `Pxݒ肷
extern	int			GetDrawBright(						int *Red, int *Green, int *Blue ) ;								// `Px擾
extern	int			SetDrawAddColor(					int Red, int Green, int Blue ) ;								// `J[ɉZFݒ肷( Red, Green, Blue : ZF( 0 = 0%  255 = 100%  -255 = -100% ) ( }CiX̒lŌZł܂ ) )
extern	int			GetDrawAddColor(					int *Red, int *Green, int *Blue ) ;								// `J[ɉZF擾
extern	int			SetWriteAlphaChannelFlag(			int Flag ) ;													// `̃At@`l̓e邩ݒ肷( FALSE:Ȃ  TRUE:( ftHg ) )
extern	int			GetWriteAlphaChannelFlag(			void ) ;														// `̃At@`l̓e邩擾( FALSE:Ȃ  TRUE:( ftHg ) )
extern	int			CheckSeparateAlphaBlendEnable(		void ) ;														// `̃At@`l̓eȂƂł邩ǂ擾( TRUE:ȂƂł  FALSE:ȂƂłȂ )
extern	int			SetIgnoreDrawGraphColor(			int EnableFlag ) ;												// `悷摜̂qfa𖳎邩ǂw肷( EnableFlag:̋@\gǂ( TRUE:g  FALSE:gȂ( ftHg ) )
extern	int			GetIgnoreDrawGraphColor(			void ) ;														// `悷摜̂qfa𖳎邩ǂ擾( ߂l  ̋@\gǂ( TRUE:g  FALSE:gȂ )
extern	int			SetMaxAnisotropy(					int MaxAnisotropy ) ;											// őٕlݒ肷
extern	int			GetMaxAnisotropy(					void ) ;														// őٕl擾
extern	int			SetUseLarge3DPositionSupport(		int UseFlag ) ;													// RcŎgpWl 10000000.0f Ȃǂ̑傫ȒlɂȂĂ`̕}鏈gp邩ǂݒ肷ADxLib_Init ̌ĂяoOł̂ݎgp\( TRUE:`̕}鏈gp( CPUׂオ܂ )@@FALSE:`̕}鏈͎gpȂ( ftHg ) )

extern	int			SetUseZBufferFlag(					int Flag ) ;													// yobt@gp邩ǂݒ肷( QcƂRc`ɉe )( TRUE:yobt@gp  FALSE:yobt@gpȂ( ftHg ) )
extern	int			SetWriteZBufferFlag(				int Flag ) ;													// yobt@ɏ݂sǂݒ肷( QcƂRc`ɉe )( TRUE:݂s  FALSE:݂sȂ( ftHg ) )
extern	int			SetZBufferCmpType(					int CmpType /* DX_CMP_NEVER  */ ) ;							// yobt@̂ylƏނylƂ̔r[hݒ肷( QcƂRc`ɉe )( CmpType:DX_CMP_NEVER( ftHg:DX_CMP_LESSEQUAL ) )
extern	int			SetZBias(							int Bias ) ;													// ނyl̃oCAXݒ肷( QcƂRc`ɉe )( Bias:oCAXl( ftHg:0 ) )
extern	int			SetUseZBuffer3D(					int Flag ) ;													// yobt@gp邩ǂݒ肷( Rc`݂̂ɉe )( TRUE:yobt@gp  FALSE:yobt@gpȂ( ftHg ) )
extern	int			SetWriteZBuffer3D(					int Flag ) ;													// yobt@ɏ݂sǂݒ肷( Rc`݂̂ɉe )( TRUE:݂s  FALSE:݂sȂ( ftHg ) )
extern	int			SetZBufferCmpType3D(				int CmpType /* DX_CMP_NEVER  */ ) ;							// yobt@̂ylƏނylƂ̔r[hݒ肷( Rc`݂̂ɉe )( CmpType:DX_CMP_NEVER( ftHg:DX_CMP_LESSEQUAL ) )
extern	int			SetZBias3D(							int Bias ) ;													// ނyl̃oCAXݒ肷( Rc`݂̂ɉe )( Bias:oCAXl( ftHg:0 ) )
extern	int			SetDrawZ(							float Z ) ;														// Qc`łyobt@ɏނylݒ肷( Z:ނyl( ftHg:0.2f ) )
extern	int			SetUseReversedZ(					int Flag ) ;													// yobt@ɏނylWƔ]l( o[Xy )ɂ邩ǂݒ肷ADxLib_InitsÔݎgp\( TRUE:]lɂ@FALSE:ʏ̒lɂ( ftHg ) )

extern	int			SetDrawArea(						int x1, int y1, int x2, int y2 ) ;								// `\̈̐ݒ肷
extern	int			GetDrawArea(						RECT *Rect ) ;													// `\̈擾
extern	int			SetDrawAreaFull(					void ) ;														// `\̈`ΏۉʑŜɂ
extern	int			SetDraw3DScale(						float Scale ) ;													// Rc`̊g嗦ݒ肷

extern	int			SetRestoreShredPoint(				void (* ShredPoint )( void ) ) ;								// SetRestoreGraphCallback ̋
extern	int			SetRestoreGraphCallback(			void (* Callback )( void ) ) ;									// OtBbNnh֐o^
extern	int			RunRestoreShred(					void ) ;														// OtBbN֐s
extern	int			SetGraphicsDeviceRestoreCallbackFunction( void (* Callback )( void *Data ), void *CallbackData ) ;	// OtBbNXfoCXXg畜AۂɌĂ΂R[obN֐ݒ肷
extern	int			SetGraphicsDeviceLostCallbackFunction(    void (* Callback )( void *Data ), void *CallbackData ) ;	// OtBbNXfoCXXg畜AOɌĂ΂R[obN֐ݒ肷

extern	int			SetTransformTo2D(					const MATRIX   *Matrix ) ;										// Qc`Ɏgpϊsݒ肷
extern	int			SetTransformTo2DD(					const MATRIX_D *Matrix ) ;										// Qc`Ɏgpϊsݒ肷
extern	int			ResetTransformTo2D(					void ) ;														// Qc`pɎgpϊs̐ݒԂɖ߂
extern	int			SetTransformToWorld(				const MATRIX   *Matrix ) ;										// [JW烏[hWɕϊ邽߂̍sݒ肷
extern	int			SetTransformToWorldD(				const MATRIX_D *Matrix ) ;										// [JW烏[hWɕϊ邽߂̍sݒ肷
extern	int			GetTransformToWorldMatrix(			      MATRIX   *MatBuf ) ;										// [JW烏[hWɕϊ邽߂̍s擾
extern	int			GetTransformToWorldMatrixD(			      MATRIX_D *MatBuf ) ;										// [JW烏[hWɕϊ邽߂̍s擾
extern	int			SetTransformToView(					const MATRIX   *Matrix ) ;										// [hWr[Wɕϊ邽߂̍sݒ肷
extern	int			SetTransformToViewD(				const MATRIX_D *Matrix ) ;										// [hWr[Wɕϊ邽߂̍sݒ肷
extern	int			GetTransformToViewMatrix(			      MATRIX   *MatBuf ) ;										// [hWr[Wɕϊ邽߂̍s擾
extern	int			GetTransformToViewMatrixD(			      MATRIX_D *MatBuf ) ;										// [hWr[Wɕϊ邽߂̍s擾
extern	int			SetTransformToProjection(			const MATRIX   *Matrix ) ;										// r[WvWFNVWɕϊ邽߂̍sݒ肷
extern	int			SetTransformToProjectionD(			const MATRIX_D *Matrix ) ;										// r[WvWFNVWɕϊ邽߂̍sݒ肷
extern	int			GetTransformToProjectionMatrix(		      MATRIX   *MatBuf ) ;										// r[WvWFNVWɕϊ邽߂̍s擾
extern	int			GetTransformToProjectionMatrixD(	      MATRIX_D *MatBuf ) ;										// r[WvWFNVWɕϊ邽߂̍s擾
extern	int			SetTransformToViewport(				const MATRIX   *Matrix ) ;										// r[|[gsݒ肷
extern	int			SetTransformToViewportD(			const MATRIX_D *Matrix ) ;										// r[|[gsݒ肷
extern	int			GetTransformToViewportMatrix(	    MATRIX   *MatBuf ) ;											// r[|[gs擾
extern	int			GetTransformToViewportMatrixD(	    MATRIX_D *MatBuf ) ;											// r[|[gs擾
extern	int			GetTransformToAPIViewportMatrix(    MATRIX   *MatBuf ) ;											// Direct3DŎKpr[|[gs擾
extern	int			GetTransformToAPIViewportMatrixD(   MATRIX_D *MatBuf ) ;											// Direct3DŎKpr[|[gs擾
extern	int			SetDefTransformMatrix(				void ) ;														// ftHg̕ϊsݒ肷
extern	int			GetTransformPosition(				VECTOR   *LocalPos, float  *x, float  *y ) ;					// [JWXN[W擾
extern	int			GetTransformPositionD(				VECTOR_D *LocalPos, double *x, double *y ) ;					// [JWXN[W擾
extern	float		GetBillboardPixelSize(				VECTOR   WorldPos, float  WorldSize ) ;							// [hԏ̃r{[h̃TCYXN[ɓeꍇ̃sNZPʂ̃TCY擾
extern	double		GetBillboardPixelSizeD(				VECTOR_D WorldPos, double WorldSize ) ;							// [hԏ̃r{[h̃TCYXN[ɓeꍇ̃sNZPʂ̃TCY擾
extern	VECTOR		ConvWorldPosToViewPos(				VECTOR   WorldPos ) ;											// [hWr[Wɕϊ
extern	VECTOR_D	ConvWorldPosToViewPosD(				VECTOR_D WorldPos ) ;											// [hWr[Wɕϊ
extern	VECTOR		ConvWorldPosToScreenPos(			VECTOR   WorldPos ) ;											// [hWXN[Wɕϊ
extern	VECTOR_D	ConvWorldPosToScreenPosD(			VECTOR_D WorldPos ) ;											// [hWXN[Wɕϊ
extern	FLOAT4		ConvWorldPosToScreenPosPlusW(		VECTOR   WorldPos ) ;											// [hWXN[WɕϊAŌ̂wxyWvŊO̒l𓾂
extern	DOUBLE4		ConvWorldPosToScreenPosPlusWD(		VECTOR_D WorldPos ) ;											// [hWXN[WɕϊAŌ̂wxyWvŊO̒l𓾂
extern	VECTOR		ConvScreenPosToWorldPos(			VECTOR   ScreenPos ) ;											// XN[W[hWɕϊ
extern	VECTOR_D	ConvScreenPosToWorldPosD(			VECTOR_D ScreenPos ) ;											// XN[W[hWɕϊ
extern	VECTOR		ConvScreenPosToWorldPos_ZLinear(	VECTOR   ScreenPos ) ;											// XN[W[hWɕϊ( ZW` )
extern	VECTOR_D	ConvScreenPosToWorldPos_ZLinearD(	VECTOR_D ScreenPos ) ;											// XN[W[hWɕϊ( ZW` )

extern	int			SetUseCullingFlag(					int Flag ) ;													// SetUseBackCulling ̋
extern	int			SetUseBackCulling(					int Flag /* DX_CULLING_LEFT  */ ) ;							// |SJO[hݒ肷
extern	int			GetUseBackCulling(					void ) ;														// |SJO[h擾
extern	int			SetUseRightHandClippingProcess(		int Flag ) ;													// EWñNbsOsݒ肷( TRUE:EWñNbsOs  FALSE:WñNbsOs( ftHg ) )
extern	int			GetUseRightHandClippingProcess(		void ) ;														// EWñNbsOs擾( TRUE:EWñNbsOs  FALSE:WñNbsOs( ftHg ) )

extern	int			SetTextureAddressMode(				int Mode /* DX_TEXADDRESS_WRAP  */ , int Stage DEFAULTPARAM( = -1 ) ) ;	// eNX`AhX[hݒ肷
extern	int			SetTextureAddressModeUV(			int ModeU, int ModeV, int Stage DEFAULTPARAM( = -1 ) ) ;					// eNX`AhX[hݒ肷( U  V ʁXɐݒ肷 )
extern	int			SetTextureAddressTransform(			float TransU, float TransV, float ScaleU, float ScaleV, float RotCenterU, float RotCenterV, float Rotate ) ;	// eNX`Wϊp[^ݒ肷
extern	int			SetTextureAddressTransformMatrix(	MATRIX Matrix ) ;												// eNX`Wϊsݒ肷
extern	int			ResetTextureAddressTransform(		void ) ;														// eNX`WϊݒZbg

extern	int			SetFogEnable(						int Flag ) ;													// tHOLɂ邩ǂݒ肷( TRUE:L  FALSE: )
extern	int			GetFogEnable(						void ) ;														// tHOLǂ擾( TRUE:L  FALSE: )
extern	int			SetFogMode(							int Mode /* DX_FOGMODE_NONE  */ ) ;							// tHO[hݒ肷
extern	int			GetFogMode(							void ) ;														// tHO[h擾
extern	int			SetFogColor(						int  r, int  g, int  b ) ;										// tHOJ[ݒ肷
extern	int			GetFogColor(						int *r, int *g, int *b ) ;										// tHOJ[擾
extern	int			SetFogStartEnd(						float  start, float  end ) ;									// tHOn܂鋗ƏI鋗ݒ肷( 0.0f ` 1.0f )
extern	int			GetFogStartEnd(						float *start, float *end ) ;									// tHOn܂鋗ƏI鋗擾( 0.0f ` 1.0f )
extern	int			SetFogDensity(						float density ) ;												// tHO̖xݒ肷( 0.0f ` 1.0f )
extern	float		GetFogDensity(						void ) ;														// tHO̖x擾( 0.0f ` 1.0f )

extern	int			SetVerticalFogEnable(				int Flag ) ;													// tHOLɂ邩ǂݒ肷( TRUE:L  FALSE: )
extern	int			GetVerticalFogEnable(				void ) ;														// tHOLǂ擾( TRUE:L  FALSE: )
extern	int			SetVerticalFogMode(					int Mode /* DX_FOGMODE_NONE  */ ) ;							// tHO[hݒ肷
extern	int			GetVerticalFogMode(					void ) ;														// tHO[h擾
extern	int			SetVerticalFogColor(				int  r, int  g, int  b ) ;										// tHOJ[ݒ肷
extern	int			GetVerticalFogColor(				int *r, int *g, int *b ) ;										// tHOJ[擾
extern	int			SetVerticalFogStartEnd(				float  start, float  end ) ;									// tHOn܂鋗ƏI鋗ݒ肷( 0.0f ` 1.0f )
extern	int			GetVerticalFogStartEnd(				float *start, float *end ) ;									// tHOn܂鋗ƏI鋗擾( 0.0f ` 1.0f )
extern	int			SetVerticalFogDensity(				float start, float density ) ;									// tHOn܂鏈Ɩxݒ肷( 0.0f ` 1.0f )
extern	int			GetVerticalFogDensity(				float *start, float *density ) ;								// tHO̎n܂鏈Ɩx擾( 0.0f ` 1.0f )


// ʊ֌W֐
#ifndef DX_COMPILE_TYPE_C_LANGUAGE
extern	unsigned int	GetPixel(									int x, int y ) ;																// wW̐F擾
#endif // DX_COMPILE_TYPE_C_LANGUAGE
extern	unsigned int	GetPixelDX(									int x, int y ) ;																// wW̐F擾
extern	COLOR_F			GetPixelF(									int x, int y ) ;																// wW̐F擾( float^ )
extern	int				SetBackgroundColor(							int Red,  int  Green, int  Blue, int  Alpha DEFAULTPARAM( = 0 )    ) ;			// CEChE̔wiFݒ肷( Red,Green,Blue,Alpha:ꂼ O`QTT )
extern	int				GetBackgroundColor(							int *Red, int *Green, int *Blue, int *Alpha DEFAULTPARAM( = NULL ) ) ;			// CEChE̔wiF擾( Red,Green,Blue,Alpha:ꂼ O`QTT )
extern	int				GetDrawScreenGraph(							                             int x1, int y1, int x2, int y2,                       int GrHandle, int UseClientFlag DEFAULTPARAM( = TRUE ) ) ;	// `̉ʂẅ̉摜OtBbNnhɓ]
extern	int				BltDrawValidGraph(							int TargetDrawValidGrHandle, int x1, int y1, int x2, int y2, int DestX, int DestY, int DestGrHandle ) ;							// SetDrawScreen ŕ`ΏۂɂłOtBbNnhẅ̉摜ʂ̃OtBbNnhɓ]
extern	int				ScreenFlip(									void ) ;																		// ʂƕ\ʂ̓e
extern 	int				ScreenCopy(									void ) ;																		// ʂ̓e\ʂɓ]
extern	int				WaitVSync(									int SyncNum ) ;																	// M҂
extern	int				ClearDrawScreen(					        const RECT *ClearRect DEFAULTPARAM( = NULL ) ) ;												// ʂNA
extern	int				ClearDrawScreenZBuffer(						const RECT *ClearRect DEFAULTPARAM( = NULL ) ) ;												// ʂ̂yobt@NA
extern	int				ClsDrawScreen(								void ) ;																		// ClearDrawScreen̋
extern	int				SetDrawScreen(								int DrawScreen ) ;																// `ʂݒ肷( MakeScreen ō쐬OtBbNnhnƂł܂ )
extern	int				GetDrawScreen(								void ) ;																		// `ʂ擾
extern	int				GetActiveGraph(								void ) ;																		// GetDrawScreen ̋
extern	int				SetUseSetDrawScreenSettingReset(			int UseFlag ) ;																	// SetDrawScreen sۂɃJ`͈͂̐ݒZbg邩ݒ肷( UseFlag  TRUE:Zbg( ftHg )  FALSE:ZbgȂ )
extern	int				GetUseSetDrawScreenSettingReset(			void ) ;																		// SetDrawScreen sۂɃJ`͈͂̐ݒZbg邩擾
extern	int				SetDrawZBuffer(								int DrawScreen ) ;																// `yobt@̃Zbg( DrawScreen t̂yobt@`yobt@ɂADrawScreen  -1 ɂƃftHg̕`yobt@ɖ߂ )
extern	int				SetGraphMode(								int ScreenSizeX, int ScreenSizeY, int ColorBitDepth, int RefreshRate DEFAULTPARAM( = 60 ) ) ;	// ʃ[hݒ肷
extern	int				SetUserScreenImage(							void *Image, int PixelFormat /* DX_USER_SCREEN_PIXEL_FORMAT_R5G6B5  */ ) ;	// ʂ̃C[WZbg( DxLib_Init ̑OŌĂԕKv( DxLib_Init ̑OɈxłĂł΁ADxLib_Init  Image ̃AhX݂̂̕ύXړIŌĂԂƂ͉\ )APixelFormat  DX_USER_SCREEN_PIXEL_FORMAT_R5G6B5  DX_USER_SCREEN_PIXEL_FORMAT_X8R8G8B8 ̓ȊOw肵ꍇ͂cwCu̕`֐͈؎gpłȂȂ܂ )
extern	int				SetFullScreenResolutionMode(				int ResolutionMode /* DX_FSRESOLUTIONMODE_NATIVE  */ ) ;						// tXN[𑜓x[hݒ肷
extern	int				GetFullScreenResolutionMode(				int *ResolutionMode, int *UseResolutionMode ) ;									// tXN[𑜓x[h擾( UseResolutionMode ͎ۂɎgpĂ𑜓x[h( Ⴆ DX_FSRESOLUTIONMODE_NATIVE w肵ĂĂj^w̉𑜓xɑΉĂȂꍇ UseResolutionMode  DX_FSRESOLUTIONMODE_DESKTOP  DX_FSRESOLUTIONMODE_MAXIMUM ɂȂ܂ ) )
extern	int				GetUseFullScreenResolutionMode(				void ) ;																		// tXN[𑜓x[h擾( GetFullScreenResolutionMode  UseResolutionMode Ŏ擾łlԂ֐ )
extern	int				SetFullScreenScalingMode(					int ScalingMode /* DX_FSSCALINGMODE_NEAREST  */ , int FitScaling DEFAULTPARAM( = FALSE ) ) ;	// tXN[[h̉ʊg僂[hݒ肷
extern	int				SetEmulation320x240(						int Flag ) ;																	// USOSWỎʂłRQOQSỎʉ𑜓xɂ邩ǂݒ肷AUSOSWOȊỎ𑜓xł͖( TRUE:L  FALSE: )
extern	int				SetZBufferSize(								int ZBufferSizeX, int ZBufferSizeY ) ;											// ʗp̂yobt@̃TCYݒ肷
extern	int				SetZBufferBitDepth(							int BitDepth ) ;																// ʗp̂yobt@̃rbg[xݒ肷( 16 or 24 or 32 )
extern	int				SetWaitVSyncFlag(							int Flag ) ;																	// ScreenFlip sɂurxmb҂邩ǂݒ肷
extern	int				GetWaitVSyncFlag(							void ) ;																		// ScreenFlip sɂurxmb҂邩ǂ擾
extern	int				SetFullSceneAntiAliasingMode(				int Samples, int Quality ) ;													// ʂ̃tXN[A`GCAX[h̐ݒs( DxLib_Init ̑Oł̂ݎgp\ )
extern	int				SetGraphDisplayArea(						int x1, int y1, int x2, int y2 ) ;												// ScreenFlip ɕ\ʑŜɓ]闠ʂ̗̈ݒ肷( DxLib_Init ̑Oł̂ݎgp\ )
extern	int				SetChangeScreenModeGraphicsSystemResetFlag(	int Flag ) ;																	// ʃ[hύX( ƃEChE[hύX )ɃOtBbNXVXe̐ݒOtBbNnhZbg邩ǂݒ肷( TRUE:Zbg( ftHg )  FALSE:ZbgȂ )
extern	int				GetScreenState(								int *SizeX, int *SizeY, int *ColorBitDepth ) ;									// ݂̉ʂ̉𑜓xƃJ[rbg𓾂 
extern	int				GetDrawScreenSize(							int *XBuf, int *YBuf ) ;														// `̃TCY擾
extern	int				GetScreenBitDepth(							void ) ;																		// ʂ̃J[rbg擾
extern	int				GetColorBitDepth(							void ) ;																		// GetScreenBitDepth ̋
extern	int				GetChangeDisplayFlag(						void ) ;																		// ʃ[hύXĂ邩ǂ擾
extern	int				GetVideoMemorySize(							int *AllSize, int *FreeSize ) ;													// rfI̗eʂ𓾂
extern	int				GetVideoMemorySizeEx(						ULONGLONG *TotalSize, ULONGLONG *UseSize ) ;									// rfI̗eʂ𓾂( 64bit )
extern	int				GetRefreshRate(								void ) ;																		// ݂̉ʂ̃tbV[g擾
extern	int				GetDisplayNum(								void ) ;																		// fBXvC̐擾
extern	int				GetDisplayInfo(								int DisplayIndex, int *DesktopRectX, int *DesktopRectY, int *DesktopSizeX, int *DesktopSizeY, int *IsPrimary, int *DesktopRefreshRate DEFAULTPARAM( = NULL ) ) ;	// fBXvC̃fXNgbvł̋`ʒu擾
extern	int				GetDisplayModeNum(							int DisplayIndex DEFAULTPARAM( = 0 ) ) ;										// ύX\ȃfBXvC[h̐擾
extern	DISPLAYMODEDATA	GetDisplayMode(								int ModeIndex, int DisplayIndex DEFAULTPARAM( = 0 ) ) ;							// ύX\ȃfBXvC[h̏擾( ModeIndex  0 ` GetDisplayModeNum ̖߂l-1 )
extern	DISPLAYMODEDATA	GetFullScreenUseDisplayMode(				void ) ;																		// tXN[[hŋNĂꍇ̎gpĂfBXvC[h̏擾( ztXN[[h̏ꍇ͎擾łȂ )
extern	int				GetDisplayMaxResolution(					int *SizeX, int *SizeY, int DisplayIndex DEFAULTPARAM( = 0 ) ) ;				// fBXvC̍ő𑜓x擾
extern	const COLORDATA* GetDispColorData(							void ) ;																		// fBXvC̃J[f[^AhX擾
extern	int				GetMultiDrawScreenNum(						void ) ;																		// ɕ`sƂłʂ̐擾
extern	int				GetDrawFloatCoordType(						void ) ;																		// DrawGraphF ̕_lōWw肷֐ɂW^Cv擾( ߂l : DX_DRAWFLOATCOORDTYPE_DIRECT3D9 Ȃ )

// ̑ݒ֌W֐
extern	int			SetUseNormalDrawShader(						int Flag ) ;									// ʏ`ɃvO}uVF[_[gp邩ǂݒ肷( TRUE:gp( ftHg )  FALSE:gpȂ )
extern	int			SetUseSoftwareRenderModeFlag(				int Flag ) ;									// \tgEGA_O[hgp邩ǂݒ肷( TRUE:gp  FALSE:gpȂ( ftHg ) )( DxLib_Init ̑OɌĂԕKv܂ )
extern	int			SetNotUse3DFlag(							int Flag ) ;									// ( ʂSetUseSoftwareRenderModeFlag gpĉ )Rc@\gȂǂݒ肷
extern	int			SetUse3DFlag(								int Flag ) ;									// ( ʂSetUseSoftwareRenderModeFlag gpĉ )Rc@\gǂݒ肷
extern	int			GetUse3DFlag(								void ) ;										// `ɂRc@\gǂ擾
extern	int			SetScreenMemToVramFlag(						int Flag ) ;									// ( ʂSetUseSoftwareRenderModeFlag gpĉ )ʂ̃sNZf[^uq`lɒuǂݒ肷
extern	int			GetScreenMemToSystemMemFlag(				void ) ;										// ʂ̃sNZf[^VXeɑ݂邩擾

extern	int			SetWindowDrawRect(							const RECT *DrawRect ) ;						// ʏgpȂ
extern	int			RestoreGraphSystem(							void ) ;										// cwCũOtBbNX֘A̕As
extern	int			SetUseHardwareVertexProcessing(				int Flag ) ;									// n[hEGA̒_Z@\gp邩ǂݒ肷( TRUE:gp( ftHg )  FALSE:gpȂ )( DxLib_Init ̑OɌĂԕKv܂ )
extern	int			SetUsePixelLighting(						int Flag ) ;									// sNZPʂŃCeBOsǂݒ肷Av ShaderModel 3.0( TRUE:sNZPʂ̃CeBOs  FALSE:_Pʂ̃CeBOs( ftHg ) )
extern	int			SetUseOldDrawModiGraphCodeFlag(				int Flag ) ;									// Âo[W DrawModiGraph ֐̃R[hgp邩ǂݒ肷
extern	int			SetUseVramFlag(								int Flag ) ;									// ( ݌ʂȂ )uq`lgp邩̃tOZbg
extern	int			GetUseVramFlag(								void ) ;										// ( ݌ʂȂ )QcOtBbNT[tFX쐬ɃVXe[gp邩̃tO擾
extern	int			SetBasicBlendFlag(							int Flag ) ;									// ( ݌ʂȂ )ȗuhsۂ̃tOZbg
extern	int			SetUseBasicGraphDraw3DDeviceMethodFlag(		int Flag ) ;									// ( ݌ʂȂ )P}`̕`ɂRcfoCX̋@\gp邩ǂݒ肷
extern	int			SetUseDisplayIndex(							int Index ) ;									// cwCũEChE\fBXvCfoCXݒ肷( -1 w肷ƃ}EXJ[\fBXvCfoCXɂcwCũEChE\ )
extern	int			RenderVertex(								void ) ;										// _obt@ɗ܂_f[^`悷( pr )

// `ptH[}X֌W֐
extern	int			GetDrawCallCount(							void ) ;										// OX ScreenFlip ĂяoAO ScreenFlip Ăяo܂ł̊Ԃɍsꂽ`R[̉񐔂擾
extern	float		GetFPS(										void ) ;										// t[[g( PbԂɌĂ΂ ScreenFlip ̉ )擾

#ifndef DX_NON_SAVEFUNCTION

// `ʕۑ֐
// Jpeg_Quality         = 0:掿`100:掿
// Png_CompressionLevel = 0:k`  9:ōk
extern	int			SaveDrawScreen(                 int x1, int y1, int x2, int y2, const TCHAR *FileName,                        int SaveType DEFAULTPARAM( = DX_IMAGESAVETYPE_BMP ) , int Jpeg_Quality DEFAULTPARAM( = 80 ) , int Jpeg_Sample2x1 DEFAULTPARAM( = TRUE ) , int Png_CompressionLevel DEFAULTPARAM( = -1 ) ) ;	// ݕ`ΏۂɂȂĂʂt@Cŕۑ
extern	int			SaveDrawScreenWithStrLen(       int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength, int SaveType DEFAULTPARAM( = DX_IMAGESAVETYPE_BMP ) , int Jpeg_Quality DEFAULTPARAM( = 80 ) , int Jpeg_Sample2x1 DEFAULTPARAM( = TRUE ) , int Png_CompressionLevel DEFAULTPARAM( = -1 ) ) ;	// ݕ`ΏۂɂȂĂʂt@Cŕۑ
extern	int			SaveDrawScreenToBMP(            int x1, int y1, int x2, int y2, const TCHAR *FileName                        ) ;																																// ݕ`ΏۂɂȂĂʂalo`ŕۑ
extern	int			SaveDrawScreenToBMPWithStrLen(  int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength ) ;																																// ݕ`ΏۂɂȂĂʂalo`ŕۑ
extern	int			SaveDrawScreenToDDS(            int x1, int y1, int x2, int y2, const TCHAR *FileName                        ) ;																																// ݕ`ΏۂɂȂĂʂccr`ŕۑ
extern	int			SaveDrawScreenToDDSWithStrLen(  int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength ) ;																																// ݕ`ΏۂɂȂĂʂccr`ŕۑ
extern	int			SaveDrawScreenToJPEG(           int x1, int y1, int x2, int y2, const TCHAR *FileName,                        int Quality DEFAULTPARAM( = 80 ) , int Sample2x1 DEFAULTPARAM( = TRUE ) ) ;																						// ݕ`ΏۂɂȂĂʂiodf`ŕۑ Quality = 掿Al傫قǒሳk掿,0`100 
extern	int			SaveDrawScreenToJPEGWithStrLen( int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength, int Quality DEFAULTPARAM( = 80 ) , int Sample2x1 DEFAULTPARAM( = TRUE ) ) ;																						// ݕ`ΏۂɂȂĂʂiodf`ŕۑ Quality = 掿Al傫قǒሳk掿,0`100 
extern	int			SaveDrawScreenToPNG(            int x1, int y1, int x2, int y2, const TCHAR *FileName,                        int CompressionLevel DEFAULTPARAM( = -1 ) ) ;																						// ݕ`ΏۂɂȂĂʂomf`ŕۑ CompressionLevel = kAl傫قǍkׁAO͖k,0`9
extern	int			SaveDrawScreenToPNGWithStrLen(  int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength, int CompressionLevel DEFAULTPARAM( = -1 ) ) ;																						// ݕ`ΏۂɂȂĂʂomf`ŕۑ CompressionLevel = kAl傫قǍkׁAO͖k,0`9

// `ΏۂɂłOtBbNnhۑ֐
// Jpeg_Quality         = 0:掿`100:掿
// Png_CompressionLevel = 0:k`  9:ōk
extern	int			SaveDrawValidGraph(                 int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName,                        int SaveType DEFAULTPARAM( = DX_IMAGESAVETYPE_BMP ) , int Jpeg_Quality DEFAULTPARAM( = 80 ) , int Jpeg_Sample2x1 DEFAULTPARAM( = TRUE ) , int Png_CompressionLevel DEFAULTPARAM( = -1 ) ) ;		// `ΏۂɂłOtBbNnht@Cŕۑ
extern	int			SaveDrawValidGraphWithStrLen(       int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength, int SaveType DEFAULTPARAM( = DX_IMAGESAVETYPE_BMP ) , int Jpeg_Quality DEFAULTPARAM( = 80 ) , int Jpeg_Sample2x1 DEFAULTPARAM( = TRUE ) , int Png_CompressionLevel DEFAULTPARAM( = -1 ) ) ;		// `ΏۂɂłOtBbNnht@Cŕۑ
extern	int			SaveDrawValidGraphToBMP(            int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName                        ) ;																																// `ΏۂɂłOtBbNnhalo`ŕۑ
extern	int			SaveDrawValidGraphToBMPWithStrLen(  int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength ) ;																																// `ΏۂɂłOtBbNnhalo`ŕۑ
extern	int			SaveDrawValidGraphToDDS(            int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName                        ) ;																																// `ΏۂɂłOtBbNnhccr`ŕۑ
extern	int			SaveDrawValidGraphToDDSWithStrLen(  int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength ) ;																																// `ΏۂɂłOtBbNnhccr`ŕۑ
extern	int			SaveDrawValidGraphToJPEG(           int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName,                        int Quality DEFAULTPARAM( = 80 ) , int Sample2x1 DEFAULTPARAM( = TRUE ) ) ;																						// `ΏۂɂłOtBbNnhiodf`ŕۑ Quality = 掿Al傫قǒሳk掿,0`100 
extern	int			SaveDrawValidGraphToJPEGWithStrLen( int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength, int Quality DEFAULTPARAM( = 80 ) , int Sample2x1 DEFAULTPARAM( = TRUE ) ) ;																						// `ΏۂɂłOtBbNnhiodf`ŕۑ Quality = 掿Al傫قǒሳk掿,0`100 
extern	int			SaveDrawValidGraphToPNG(            int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName,                        int CompressionLevel DEFAULTPARAM( = -1 ) ) ;																					// `ΏۂɂłOtBbNnhomf`ŕۑ CompressionLevel = kAl傫قǍkׁAO͖k,0`9
extern	int			SaveDrawValidGraphToPNGWithStrLen(  int GrHandle, int x1, int y1, int x2, int y2, const TCHAR *FileName, size_t FileNameLength, int CompressionLevel DEFAULTPARAM( = -1 ) ) ;																					// `ΏۂɂłOtBbNnhomf`ŕۑ CompressionLevel = kAl傫قǍkׁAO͖k,0`9

#endif // DX_NON_SAVEFUNCTION

// _obt@֌W֐
extern	int			CreateVertexBuffer(		int VertexNum, int VertexType /* DX_VERTEX_TYPE_NORMAL_3D  */ ) ;						// _obt@쐬( -1:G[  0ȏ:_obt@nh )
extern	int			DeleteVertexBuffer(		int VertexBufHandle ) ;																	// _obt@폜
extern	int			InitVertexBuffer(		void ) ;																				// ׂĂ̒_obt@폜
extern	int			SetVertexBufferData(	int SetIndex, const void *VertexArray, int VertexNum, int VertexBufHandle ) ;			// _obt@ɒ_f[^]
extern	void *		GetBufferVertexBuffer(	int VertexBufHandle ) ;																	// _obt@nh̒_obt@̃AhX擾
extern	int			UpdateVertexBuffer(		int VertexBufHandle, int UpdateStartIndex, int UpdateVertexNum ) ;						// _obt@nh̒_obt@ւ̕ύXKp( GetBufferVertexBuffer Ŏ擾obt@ւ̕ύX𔽉f )
extern	int			CreateIndexBuffer(		int IndexNum, int IndexType /* DX_INDEX_TYPE_16BIT  */  ) ;							// CfbNXobt@쐬( -1:G[@0ȏFCfbNXobt@nh )
extern	int			DeleteIndexBuffer(		int IndexBufHandle ) ;																	// CfbNXobt@폜
extern	int			InitIndexBuffer(		void ) ;																				// ׂẴCfbNXobt@폜
extern	int			SetIndexBufferData(		int SetIndex, const void *IndexArray, int IndexNum, int IndexBufHandle ) ;				// CfbNXobt@ɃCfbNXf[^]
extern	void *		GetBufferIndexBuffer(	int IndexBufHandle ) ;																	// CfbNXobt@nh̃CfbNXobt@̃AhX擾
extern	int			UpdateIndexBuffer(		int IndexBufHandle, int UpdateStartIndex, int UpdateIndexNum ) ;						// CfbNXobt@nh̃CfbNXobt@ւ̕ύXKp( GetBufferIndexBuffer Ŏ擾obt@ւ̕ύX𔽉f )
extern	int			GetMaxPrimitiveCount(	void ) ;																				// OtBbNXfoCXΉĂxɕ`łv~eBu̍ő吔擾
extern	int			GetMaxVertexIndex(		void ) ;																				// OtBbNXfoCXΉĂxɎgp邱Ƃ̂łő咸_擾

// VF[_[֌W֐
extern	int			GetValidShaderVersion(			void ) ;												// gpłVF[_[̃o[W擾( 0=gȂ  200=VF[_[fQDOgp\  300=VF[_[fRDOgp\ )

extern	int			LoadVertexShader(				const TCHAR *FileName                        ) ;		// _VF[_[oCit@Cǂݍݒ_VF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadVertexShaderWithStrLen(		const TCHAR *FileName, size_t FileNameLength ) ;		// _VF[_[oCit@Cǂݍݒ_VF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadGeometryShader(				const TCHAR *FileName                        ) ;		// WIgVF[_[oCit@Cǂݍ݃WIgVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadGeometryShaderWithStrLen(	const TCHAR *FileName, size_t FileNameLength ) ;		// WIgVF[_[oCit@Cǂݍ݃WIgVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadPixelShader(				const TCHAR *FileName                        ) ;		// sNZVF[_[oCit@Cǂݍ݃sNZVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadPixelShaderWithStrLen(		const TCHAR *FileName, size_t FileNameLength ) ;		// sNZVF[_[oCit@Cǂݍ݃sNZVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadVertexShaderFromMem(		const void *ImageAddress, int ImageSize ) ;				// ɓǂݍ܂ꂽ_VF[_[oCi璸_VF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadGeometryShaderFromMem(		const void *ImageAddress, int ImageSize ) ;				// ɓǂݍ܂ꂽWIgVF[_[oCiWIgVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			LoadPixelShaderFromMem(			const void *ImageAddress, int ImageSize ) ;				// ɓǂݍ܂ꂽsNZVF[_[oCisNZVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh )
extern	int			DeleteShader(					int ShaderHandle ) ;									// VF[_[nh̍폜( _VF[_[EsNZVF[_[ )
extern	int			InitShader(						void ) ;												// VF[_[nhSč폜( _VF[_[nhEsNZVF[_[nhǂׂč폜 )

extern	int			GetConstIndexToShader(                     const TCHAR *ConstantName,                            int ShaderHandle ) ;	// w̖O萔gpVF[_[萔̔ԍ擾
extern	int			GetConstIndexToShaderWithStrLen(           const TCHAR *ConstantName, size_t ConstantNameLength, int ShaderHandle ) ;	// w̖O萔gpVF[_[萔̔ԍ擾
extern	int			GetConstCountToShader(                     const TCHAR *ConstantName,                            int ShaderHandle ) ;	// w̖O萔gpVF[_[萔̐擾
extern	int			GetConstCountToShaderWithStrLen(           const TCHAR *ConstantName, size_t ConstantNameLength, int ShaderHandle ) ;	// w̖O萔gpVF[_[萔̐擾
extern	const FLOAT4 *GetConstDefaultParamFToShader(           const TCHAR *ConstantName,                            int ShaderHandle ) ;	// w̖O_萔̃ftHgp[^i[Ă郁AhX擾
extern	const FLOAT4 *GetConstDefaultParamFToShaderWithStrLen( const TCHAR *ConstantName, size_t ConstantNameLength, int ShaderHandle ) ;	// w̖O_萔̃ftHgp[^i[Ă郁AhX擾
extern	int			SetVSConstSF(         int ConstantIndex,       float  Param ) ;						// _VF[_[ float ^萔ݒ肷
extern	int			SetVSConstF(          int ConstantIndex,       FLOAT4 Param ) ;						// _VF[_[ float ^萔ݒ肷
extern	int			SetVSConstFMtx(       int ConstantIndex,       MATRIX Param ) ;						// _VF[_[ float ^萔ɍsݒ肷
extern	int			SetVSConstFMtxT(      int ConstantIndex,       MATRIX Param ) ;						// _VF[_[ float ^萔ɓ]usݒ肷
extern	int			SetVSConstSI(         int ConstantIndex,       int    Param ) ;						// _VF[_[ int   ^萔ݒ肷
extern	int			SetVSConstI(          int ConstantIndex,       INT4   Param ) ;						// _VF[_[ int   ^萔ݒ肷
extern	int			SetVSConstB(          int ConstantIndex,       BOOL   Param ) ;						// _VF[_[ BOOL  ^萔ݒ肷
extern	int			SetVSConstSFArray(    int ConstantIndex, const float  *ParamArray, int ParamNum ) ;	// _VF[_[ float ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetVSConstFArray(     int ConstantIndex, const FLOAT4 *ParamArray, int ParamNum ) ;	// _VF[_[ float ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetVSConstFMtxArray(  int ConstantIndex, const MATRIX *ParamArray, int ParamNum ) ;	// _VF[_[ float ^萔ɍsݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetVSConstFMtxTArray( int ConstantIndex, const MATRIX *ParamArray, int ParamNum ) ;	// _VF[_[ float ^萔ɓ]usݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetVSConstSIArray(    int ConstantIndex, const int    *ParamArray, int ParamNum ) ;	// _VF[_[ int   ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetVSConstIArray(     int ConstantIndex, const INT4   *ParamArray, int ParamNum ) ;	// _VF[_[ int   ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetVSConstBArray(     int ConstantIndex, const BOOL   *ParamArray, int ParamNum ) ;	// _VF[_[ BOOL  ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			ResetVSConstF(        int ConstantIndex, int ParamNum ) ;							// _VF[_[ float ^萔̐ݒZbg
extern	int			ResetVSConstI(        int ConstantIndex, int ParamNum ) ;							// _VF[_[ int   ^萔̐ݒZbg
extern	int			ResetVSConstB(        int ConstantIndex, int ParamNum ) ;							// _VF[_[ BOOL  ^萔̐ݒZbg

extern	int			SetPSConstSF(         int ConstantIndex,       float  Param ) ;						// sNZVF[_[ float ^萔ݒ肷
extern	int			SetPSConstF(          int ConstantIndex,       FLOAT4 Param ) ;						// sNZVF[_[ float ^萔ݒ肷
extern	int			SetPSConstFMtx(       int ConstantIndex,       MATRIX Param ) ;						// sNZVF[_[ float ^萔ɍsݒ肷
extern	int			SetPSConstFMtxT(      int ConstantIndex,       MATRIX Param ) ;						// sNZVF[_[ float ^萔ɓ]usݒ肷
extern	int			SetPSConstSI(         int ConstantIndex,       int    Param ) ;						// sNZVF[_[ int   ^萔ݒ肷
extern	int			SetPSConstI(          int ConstantIndex,       INT4   Param ) ;						// sNZVF[_[ int   ^萔ݒ肷
extern	int			SetPSConstB(          int ConstantIndex,       BOOL   Param ) ;						// sNZVF[_[ BOOL  ^萔ݒ肷
extern	int			SetPSConstSFArray(    int ConstantIndex, const float  *ParamArray, int ParamNum ) ;	// sNZVF[_[ float ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetPSConstFArray(     int ConstantIndex, const FLOAT4 *ParamArray, int ParamNum ) ;	// sNZVF[_[ float ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetPSConstFMtxArray(  int ConstantIndex, const MATRIX *ParamArray, int ParamNum ) ;	// sNZVF[_[ float ^萔ɍsݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetPSConstFMtxTArray( int ConstantIndex, const MATRIX *ParamArray, int ParamNum ) ;	// sNZVF[_[ float ^萔ɓ]usݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetPSConstSIArray(    int ConstantIndex, const int    *ParamArray, int ParamNum ) ;	// sNZVF[_[ int   ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetPSConstIArray(     int ConstantIndex, const INT4   *ParamArray, int ParamNum ) ;	// sNZVF[_[ int   ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			SetPSConstBArray(     int ConstantIndex, const BOOL   *ParamArray, int ParamNum ) ;	// sNZVF[_[ BOOL  ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ )
extern	int			ResetPSConstF(        int ConstantIndex, int ParamNum ) ;							// sNZVF[_[ float ^萔̐ݒZbg
extern	int			ResetPSConstI(        int ConstantIndex, int ParamNum ) ;							// sNZVF[_[ int   ^萔̐ݒZbg
extern	int			ResetPSConstB(        int ConstantIndex, int ParamNum ) ;							// sNZVF[_[ BOOL  ^萔̐ݒZbg

extern	int			SetRenderTargetToShader( int TargetIndex, int DrawScreen, int SurfaceIndex DEFAULTPARAM( = 0 ) , int MipLevel DEFAULTPARAM( = 0 ) ) ;	// VF[_[gp`ł̕`ݒ肷( DrawScreen  -1 nƖ )
extern	int			SetUseTextureToShader(   int StageIndex, int GraphHandle ) ;						// VF[_[gp`ŎgpOtBbNnhݒ肷
extern	int			SetUseVertexShader(      int ShaderHandle ) ;										// VF[_[gp`Ɏgp钸_VF[_[ݒ肷( -1nƉ )
extern	int			SetUseGeometryShader(    int ShaderHandle ) ;										// VF[_[gp`ɎgpWIgVF[_[ݒ肷( -1nƉ )
extern	int			SetUsePixelShader(       int ShaderHandle ) ;										// VF[_[gp`ɎgpsNZVF[_[ݒ肷( -1nƉ )

extern	int			CalcPolygonBinormalAndTangentsToShader(             VERTEX3DSHADER *VertexArray, int PolygonNum ) ;														// |S̒_̐ڐƏ]@tuWvZăZbg
extern	int			CalcPolygonIndexedBinormalAndTangentsToShader(      VERTEX3DSHADER *VertexArray, int VertexNum, const unsigned short *IndexArray, int PolygonNum ) ;	// |S̒_̐ڐƏ]@tuWvZăZbg( _CfbNXgp )
extern	int			CalcPolygon32bitIndexedBinormalAndTangentsToShader( VERTEX3DSHADER *VertexArray, int VertexNum, const unsigned int   *IndexArray, int PolygonNum ) ;	// |S̒_̐ڐƏ]@tuWvZăZbg( _CfbNXgp )

extern	int			DrawBillboard3DToShader( VECTOR Pos, float cx, float cy, float Size, float Angle, int GrHandle, int TransFlag, int ReverseXFlag DEFAULTPARAM( = FALSE ) , int ReverseYFlag DEFAULTPARAM( = FALSE ) ) ;							// VF[_[găr{[h`悷
extern	int			DrawPolygon2DToShader(                const VERTEX2DSHADER *VertexArray, int PolygonNum ) ;																											// VF[_[gĂQc|S`悷
extern	int			DrawPolygon3DToShader(                const VERTEX3DSHADER *VertexArray, int PolygonNum ) ;																											// VF[_[gĂRc|S`悷
extern	int			DrawPolygonIndexed2DToShader(         const VERTEX2DSHADER *VertexArray, int VertexNum, const unsigned short *IndexArray, int PolygonNum ) ;															// VF[_[gĂQc|S`悷( _CfbNXgp )
extern	int			DrawPolygon32bitIndexed2DToShader(    const VERTEX2DSHADER *VertexArray, int VertexNum, const unsigned int   *IndexArray, int PolygonNum ) ;															// VF[_[gĂQc|S`悷( _CfbNXgp )
extern	int			DrawPolygonIndexed3DToShader(         const VERTEX3DSHADER *VertexArray, int VertexNum, const unsigned short *IndexArray, int PolygonNum ) ;															// VF[_[gĂRc|S`悷( _CfbNXgp )
extern	int			DrawPolygon32bitIndexed3DToShader(    const VERTEX3DSHADER *VertexArray, int VertexNum, const unsigned int   *IndexArray, int PolygonNum ) ;															// VF[_[gĂRc|S`悷( _CfbNXgp )
extern	int			DrawPrimitive2DToShader(              const VERTEX2DSHADER *VertexArray, int VertexNum,                                                 int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;		// VF[_[gĂQcv~eBu`悷
extern	int			DrawPrimitive3DToShader(              const VERTEX3DSHADER *VertexArray, int VertexNum,                                                 int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;		// VF[_[gĂRcv~eBu`悷
extern	int			DrawPrimitiveIndexed2DToShader(       const VERTEX2DSHADER *VertexArray, int VertexNum, const unsigned short *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;		// VF[_[gĂQcv~eBu`悷( _CfbNXgp )
extern	int			DrawPrimitive32bitIndexed2DToShader(  const VERTEX2DSHADER *VertexArray, int VertexNum, const unsigned int   *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;		// VF[_[gĂQcv~eBu`悷( _CfbNXgp )
extern	int			DrawPrimitiveIndexed3DToShader(       const VERTEX3DSHADER *VertexArray, int VertexNum, const unsigned short *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;		// VF[_[gĂRcv~eBu`悷( _CfbNXgp )
extern	int			DrawPrimitive32bitIndexed3DToShader(  const VERTEX3DSHADER *VertexArray, int VertexNum, const unsigned int   *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;		// VF[_[gĂRcv~eBu`悷( _CfbNXgp )
extern	int			DrawPolygon2DToShader2(               const VERTEX2D *VertexArray, int PolygonNum ) ;																												// VF[_[gĂQc|S`悷( _f[^ VERTEX2D )
extern	int			DrawPolygon3DToShader2(               const VERTEX3D *VertexArray, int PolygonNum ) ;																												// VF[_[gĂRc|S`悷( _f[^ VERTEX3D )
extern	int			DrawPolygonIndexed2DToShader2(        const VERTEX2D *VertexArray, int VertexNum, const unsigned short *IndexArray, int PolygonNum ) ;																// VF[_[gĂQc|S`悷( _CfbNXgp )( _f[^ VERTEX2D )
extern	int			DrawPolygon32bitIndexed2DToShader2(   const VERTEX2D *VertexArray, int VertexNum, const unsigned int   *IndexArray, int PolygonNum ) ;																// VF[_[gĂQc|S`悷( _CfbNXgp )( _f[^ VERTEX2D )
extern	int			DrawPolygonIndexed3DToShader2(        const VERTEX3D *VertexArray, int VertexNum, const unsigned short *IndexArray, int PolygonNum ) ;																// VF[_[gĂRc|S`悷( _CfbNXgp )( _f[^ VERTEX3D )
extern	int			DrawPolygon32bitIndexed3DToShader2(   const VERTEX3D *VertexArray, int VertexNum, const unsigned int   *IndexArray, int PolygonNum ) ;																// VF[_[gĂRc|S`悷( _CfbNXgp )( _f[^ VERTEX3D )
extern	int			DrawPrimitive2DToShader2(             const VERTEX2D *VertexArray, int VertexNum,                                                 int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;			// VF[_[gĂQcv~eBu`悷( _f[^ VERTEX2D )
extern	int			DrawPrimitive3DToShader2(             const VERTEX3D *VertexArray, int VertexNum,                                                 int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;			// VF[_[gĂRcv~eBu`悷( _f[^ VERTEX3D )
extern	int			DrawPrimitiveIndexed2DToShader2(      const VERTEX2D *VertexArray, int VertexNum, const unsigned short *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;			// VF[_[gĂQcv~eBu`悷( _CfbNXgp )( _f[^ VERTEX2D )
extern	int			DrawPrimitive32bitIndexed2DToShader2( const VERTEX2D *VertexArray, int VertexNum, const unsigned int   *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;			// VF[_[gĂQcv~eBu`悷( _CfbNXgp )( _f[^ VERTEX2D )
extern	int			DrawPrimitiveIndexed3DToShader2(      const VERTEX3D *VertexArray, int VertexNum, const unsigned short *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;			// VF[_[gĂRcv~eBu`悷( _CfbNXgp )( _f[^ VERTEX3D )
extern	int			DrawPrimitive32bitIndexed3DToShader2( const VERTEX3D *VertexArray, int VertexNum, const unsigned int   *IndexArray, int IndexNum, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;			// VF[_[gĂRcv~eBu`悷( _CfbNXgp )( _f[^ VERTEX3D )
extern	int			DrawPolygon3DToShader_UseVertexBuffer(           int VertexBufHandle ) ;																															// VF[_[gĂRc|S`悷( _obt@gp )
extern	int			DrawPolygonIndexed3DToShader_UseVertexBuffer(    int VertexBufHandle, int IndexBufHandle ) ;																										// VF[_[gĂRc|S`悷( _obt@ƃCfbNXobt@gp )
extern	int			DrawPrimitive3DToShader_UseVertexBuffer(         int VertexBufHandle,                     int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;													// VF[_[gĂRcv~eBu`悷( _obt@gp )
extern	int			DrawPrimitive3DToShader_UseVertexBuffer2(        int VertexBufHandle,                     int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int StartVertex, int UseVertexNum ) ;				// VF[_[gĂRcv~eBu`悷( _obt@gp )
extern	int			DrawPrimitiveIndexed3DToShader_UseVertexBuffer(  int VertexBufHandle, int IndexBufHandle, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */ ) ;													// VF[_[gĂRcv~eBu`悷( _obt@ƃCfbNXobt@gp )
extern	int			DrawPrimitiveIndexed3DToShader_UseVertexBuffer2( int VertexBufHandle, int IndexBufHandle, int PrimitiveType /* DX_PRIMTYPE_TRIANGLELIST  */, int BaseVertex, int StartVertex, int UseVertexNum, int StartIndex, int UseIndexNum ) ;		// VF[_[gĂRcv~eBu`悷( _obt@ƃCfbNXobt@gp )

// VF[_[p萔obt@֌W֐
extern	int			InitShaderConstantBuffer(		void ) ;																					// SẴVF[_[p萔obt@nh폜
extern	int			CreateShaderConstantBuffer(		int BufferSize ) ;																			// VF[_[p萔obt@nh
extern	int			DeleteShaderConstantBuffer(		int SConstBufHandle ) ;																		// VF[_[p萔obt@nh폜
extern	void *		GetBufferShaderConstantBuffer(	int SConstBufHandle ) ;																		// VF[_[p萔obt@nh̒萔obt@̃AhX擾
extern	int			UpdateShaderConstantBuffer(		int SConstBufHandle ) ;																		// VF[_[p萔obt@nh̒萔obt@ւ̕ύXKp
extern	int			SetShaderConstantBuffer(		int SConstBufHandle, int TargetShader /* DX_SHADERTYPE_VERTEX Ȃ */ , int Slot ) ;		// VF[_[p萔obt@nh̒萔obt@w̃VF[_[̎w̃XbgɃZbg

// tB^[֌W֐
#ifndef DX_NON_FILTER
extern	int			SetGraphFilterBltBlendMode( int BlendMode /* DX_BLENDMODE_ALPHA Ȃ */ ) ;												// GraphFilterBlt  GraphBlendBlt ̌ʂ]ɓ]ۂ̃uh[hݒ肷( őΉĂ̂ DX_BLENDMODE_NOBLEND  DX_BLENDMODE_ALPHA ̂ )
extern	int			SetGraphBlendScalingFilterMode( int IsBilinearFilter ) ;																// GraphBlend  GrHandle  BlendGrHandle ̃TCYقȂꍇɓKpgtB^[[hݒ肷( IsBilinearFilter  TRUE:oCjAtB^[(ftHg)  FALSE:jAXgtB^[ )

extern	int			GraphFilter(         int    GrHandle,                                                                                                               int FilterType /* DX_GRAPH_FILTER_GAUSS  */ , ... ) ;		// 摜ɃtB^[s
extern	int			GraphFilterBlt(      int SrcGrHandle, int DestGrHandle,                                                                                             int FilterType /* DX_GRAPH_FILTER_GAUSS  */ , ... ) ;		// 摜̃tB^[t]s
extern	int			GraphFilterRectBlt(  int SrcGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int DestX,  int DestY,                          int FilterType /* DX_GRAPH_FILTER_GAUSS  */ , ... ) ;		// 摜̃tB^[t]s( `w )
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_MONO, int Cb = F( -255 ` 255 ), int Cr = ԐF( -255 ` 255 ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_GAUSS, int PixelWidth = gpsNZ( 8 , 16 , 32 ̉ꂩ ), int Param = ڂp[^( 100 Ŗ1sNZ̕ ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_DOWN_SCALE, int DivNum = ̃TCỶ̂PAƂl( 1 , 2 , 4 , 8 ̉ꂩ ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_BRIGHT_CLIP, int CmpType = Nbv^Cv( DX_CMP_LESS:CmpParamȉNbv    DX_CMP_GREATER:CmpParamȏNbv ), int CmpParam = Nbvp[^( 0 ` 255 ), int ClipFillFlag = NbvsNZhԂǂ( TRUE:hԂ  FALSE:hԂȂ ), unsigned int ClipFillColor = NbvsNZɓhFl( GetColor Ŏ擾 )( ClipFillFlag  FALSE ̏ꍇ͎gpȂ ), int ClipFillAlpha = NbvsNZɓh郿l( 0 ` 255 )( ClipFillFlag  FALSE ̏ꍇ͎gpȂ ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_BRIGHT_SCALE, int MinBright = ϊɐ^ÂɂȂ閾邳( 0 ` 255 ), int MaxBright = ϊɐ^ɂȂ閾邳( 0 ` 255 ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_HSB, int HueType = Hue ̈Ӗ( 0:Βl  1:Βl ), int Hue = Fp[^( HueType  0 ̏ꍇ = sNZ̐Fɑ΂鑊Βl( -180 ` 180 )   HueType  1 ̏ꍇ = F̐Βl( 0 ` 360 ) ), int Saturation = ʓx( -255 ` ), int Bright = Px( -255 ` 255 ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_INVERT ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_LEVEL, int Min = ϊ̉l( 0 ` 255 ), int Max = ϊ̏l( 0 ` 255 ), int Gamma = K}l( 100 ŃK}␳A0 Ƃȉ̒l͕s ), int AfterMin = ϊ̍Œl( 0 ` 255 ), int AfterMax = ϊ̍ől( 0 ` 255 ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_TWO_COLOR, int Threshold = 臒l( 0 ` 255 ), unsigned int LowColor = 臒llႩsNZ̕ϊ̐Fl( GetColor Ŏ擾 ), int LowAlpha = 臒llႩsNZ̕ϊ̃l( 0 ` 255 ), unsigned int HighColor = 臒llsNZ̕ϊ̐Fl( GetColor Ŏ擾 ), int HighAlpha = 臒llsNZ̕ϊ̃l( 0 ` 255 ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_GRADIENT_MAP, int MapGrHandle = Of[V}bṽOtBbNnh( 摜̋PxOf[V}bv摜 x WZo܂̂ŏc1dotłnj ), int Reverse = Of[V}bvE]tO( TRUE : Of[V}bvE]Ďg  FALSE : E]Ȃ ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_REPLACEMENT, int TargetR, int TargetG, int TargetB, int TargetA = uΏۂ̐F( 0`255 ), int R, int G, int B, int A = u̐F( 0`255 ) ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_BILATERAL_BLUR ) ;			// oCeu[
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_PREMUL_ALPHA ) ;			// ʏ̃At@`lt摜Zς݃At@摜ɕϊtB^
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_INTERP_ALPHA ) ;			// Zς݃摜ʏ̃At@`lt摜ɕϊtB^
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_YUV_TO_RGB ) ;				// YUVJ[RGBJ[ɕϊtB^
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_Y2UV1_TO_RGB, int UVGrHandle = YUVJ[UV݂̂ŁAYɑ΂ĉ𑜓x( Ⴕ 4  1 )̃OtBbNnh( U=R, V=G ) ) ;		// YUVJ[RGBJ[ɕϊtB^( UV Y̔E͂ŜP( EcЕႵ͗ )̉𑜓xȂꍇp )
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_YUV_TO_RGB_RRA ) ;				// YUVJ[RGBJ[ɕϊtB^( ER̒lAt@lƂĈ )
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_Y2UV1_TO_RGB_RRA, int UVGrHandle = YUVJ[UV݂̂ŁAYɑ΂ĉ𑜓x( Ⴕ 4  1 )̃OtBbNnh( U=R, V=G ) ) ;		// YUVJ[RGBJ[ɕϊtB^( UV Y̔E͂ŜP( EcЕႵ͗ )̉𑜓xȂꍇp )( ER̒lAt@lƂĈ )
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_BICUBIC_SCALE, int DestSizeX = XP[ỎsNZ, int DestSizeY = XP[ȌcsNZ ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_LANCZOS3_SCALE, int DestSizeX = XP[ỎsNZ, int DestSizeY = XP[ȌcsNZ ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_SSAO, int ColorWithDepthGrHandle = Zobt@܂܂J[obt@, float KernelRadius = Օ𒲂ׂ͈, float MinDistance = Օ肷ŏ[xl, float MaxDistance = Օ肷ő[xl, float Strength = Օ̉e̋, int OcclusionColor = IN[WJ[, float OcclusionPower = IN[WJ[̋ ) ;
//		int			GraphFilter( int GrHandle, int FilterType = DX_GRAPH_FILTER_FLOAT_COLOR_SCALE, float ColorScaleR = Ԑւ̃XP[Ol, float ColorScaleG = ΐւ̃XP[Ol, float ColorScaleB = ւ̃XP[Ol, float ColorScaleA = ւ̃XP[Ol, float ColorPreSubR = ԐɃXP[O|OɌZl, float ColorPreSubG = ΐɃXP[O|OɌZl, float ColorPreSubB = ɃXP[O|OɌZl, float ColorPreSubA = ɃXP[O|OɌZl ) ;

extern	int			GraphBlend(         int    GrHandle, int BlendGrHandle,                                                                                                                                         int BlendRatio /* uhʂ̉ex( 0:O  255:POO ) */ , int BlendType /* DX_GRAPH_BLEND_ADD  */ , ... ) ;	// ̉摜uh
extern	int			GraphBlendBlt(      int SrcGrHandle, int BlendGrHandle, int DestGrHandle,                                                                                                                       int BlendRatio /* uhʂ̉ex( 0:O  255:POO ) */ , int BlendType /* DX_GRAPH_BLEND_ADD  */ , ... ) ;	// ̉摜uhČʂw̉摜ɏo͂
extern	int			GraphBlendRectBlt(  int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX,  int BlendY,                            int DestX, int DestY, int BlendRatio /* uhʂ̉ex( 0:O  255:POO ) */ , int BlendType /* DX_GRAPH_BLEND_ADD  */ , ... ) ;	// ̉摜uhČʂw̉摜ɏo͂( `w )
extern	int			GraphBlendRectBlt2( int SrcGrHandle, int BlendGrHandle, int DestGrHandle, int SrcX1, int SrcY1, int SrcX2, int SrcY2, int BlendX1, int BlendY1, int BlendX2, int BlendY2, int DestX, int DestY, int BlendRatio /* uhʂ̉ex( 0:O  255:POO ) */ , int BlendType /* DX_GRAPH_BLEND_ADD  */ , ... ) ;	// ̉摜uhČʂw̉摜ɏo͂( `wAuh摜`w )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_NORMAL ) ; // ʏ
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_RGBA_SELECT_MIX, int SelectR = ( o͂̐ԕƂȂ鐬 DX_RGBA_SELECT_SRC_R  ), int SelectG = ( o̗͂ΐƂȂ鐬 DX_RGBA_SELECT_SRC_R  ), int SelectB = ( o͂̐ƂȂ鐬 DX_RGBA_SELECT_SRC_R  ), int SelectA = ( o͂̃ƂȂ鐬 DX_RGBA_SELECT_SRC_R  ) ) ;	// RGBA̗vfIč
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_MULTIPLE ) ;	// Z
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_DIFFERENCE ) ;	// Z
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_ADD ) ;		  	// Z
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_SCREEN ) ;	// XN[
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_OVERLAY ) ;	// I[o[C
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_DODGE ) ;	// Ă
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_BURN ) ;	// Ă
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_DARKEN ) ;	// r()
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_LIGHTEN ) ;	// r()
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_SOFTLIGHT ) ;	// \tgCg
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_HARDLIGHT ) ;	// n[hCg
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_EXCLUSION ) ;	// O
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_NORMAL_ALPHACH ) ;	// `lt摜̒ʏ퍇
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_ADD_ALPHACH ) ;	// `lt摜̉Z
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_MULTIPLE_A_ONLY ) ;	// At@`l݂̂̏Z
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_MASK ) ;	// }XN( SrcGrHandle  BlendGrHandle ʏ`悵ŁASrcGrHandle  A D )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_NORMAL ) ; // ʏ( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_RGBA_SELECT_MIX ) ; // RGBA̗vfIč( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_MULTIPLE ) ; // Z( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_DIFFERENCE ) ; // Z( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_ADD ) ; // Z( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_SCREEN ) ; // XN[( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_OVERLAY ) ; // I[o[C( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_DODGE ) ; // Ă( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_BURN ) ; // Ă( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_DARKEN ) ; // r()( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_LIGHTEN ) ; // r()( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_SOFTLIGHT ) ; // \tgCg( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_HARDLIGHT ) ; // n[hCg( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_EXCLUSION ) ; // O( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_NORMAL_ALPHACH ) ; // `lt摜̒ʏ퍇( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_ADD_ALPHACH ) ; // `lt摜̉Z( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_MULTIPLE_A_ONLY ) ;	// At@`l݂̂̏Z( Zς݃摜p )
//		int			GraphBlend( int GrHandle, int BlendGrHandle, int BlendRatio, int BlendType = DX_GRAPH_BLEND_PMA_MASK ) ;	// }XN( DX_GRAPH_BLEND_MASK  Zς݃摜p )
#endif // DX_NON_FILTER

#ifndef DX_NON_MOVIE
// [r[OtBbN֌W֐
extern	int			PlayMovie(							const TCHAR *FileName,                        int ExRate, int PlayType ) ;	// t@C̍Đ
extern	int			PlayMovieWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int ExRate, int PlayType ) ;	// t@C̍Đ
extern	int			GetMovieImageSize_File(             const TCHAR *FileName,                        int *SizeX, int *SizeY ) ;	// t@C̉sNZƏcsNZ擾
extern	int			GetMovieImageSize_File_WithStrLen(  const TCHAR *FileName, size_t FileNameLength, int *SizeX, int *SizeY ) ;	// t@C̉sNZƏcsNZ擾
extern	int			GetMovieImageSize_Mem(              const void *FileImage, int FileImageSize, int *SizeX, int *SizeY ) ;		// ɓWJꂽt@C̉sNZƏcsNZ擾
extern	int			OpenMovieToGraph(					const TCHAR *FileName,                        int FullColor DEFAULTPARAM( = TRUE ) ) ;		// t@CJ
extern	int			OpenMovieToGraphWithStrLen(			const TCHAR *FileName, size_t FileNameLength, int FullColor DEFAULTPARAM( = TRUE ) ) ;		// t@CJ
extern 	int			PlayMovieToGraph(					int GraphHandle, int PlayType DEFAULTPARAM( = DX_PLAYTYPE_BACK ) , int SysPlay DEFAULTPARAM( = 0 ) ) ;		// t@CgpOtBbNnh̓t@C̍ĐJn
extern 	int			PauseMovieToGraph(					int GraphHandle, int SysPause DEFAULTPARAM( = 0 ) ) ;										// t@CgpOtBbNnh̓t@C̍Đ~
extern	int			AddMovieFrameToGraph(				int GraphHandle, unsigned int FrameNum ) ;									// t@C̍Đt[i߂A߂Ƃ͏oȂ( t@C~ԂŁA Ogg Theora ̂ݗL )
extern	int			SeekMovieToGraph(					int GraphHandle, int Time ) ;												// t@C̍Đʒuݒ肷(~bP)
extern	int			SetPlaySpeedRateMovieToGraph(		int GraphHandle, double SpeedRate ) ;										// t@C̍Đxݒ肷( 1.0 = {  2.0 = Q{ )Aꕔ̃t@CtH[}bĝ݂ŗLȋ@\ł
extern 	int			GetMovieStateToGraph(				int GraphHandle ) ;															// t@C̍ĐԂ𓾂
extern	int			SetMovieVolumeToGraph(				int Volume, int GraphHandle ) ;												// t@C̉ʂݒ肷(0`10000)
extern	int			GetMovieVolumeToGraph(				            int GraphHandle ) ;												// t@C̉ʂ擾(0`10000)
extern	int			ChangeMovieVolumeToGraph(			int Volume, int GraphHandle ) ;												// t@C̉ʂݒ肷(0`255)
extern	int			GetMovieVolumeToGraph2(				            int GraphHandle ) ;												// t@C̉ʂ擾(0`255)
extern	const BASEIMAGE* GetMovieBaseImageToGraph(		int GraphHandle, int *ImageUpdateFlag DEFAULTPARAM( = NULL ) , int ImageUpdateFlagSetOnly DEFAULTPARAM( = FALSE ) ) ;	// t@C̊{C[Wf[^擾( ImageUpdateFlag  int ^ϐ̃AhXnƁAC[WXVꂽꍇ 1 AXVĂȂꍇ 0 i[܂A ImageUpdateFlagSetOnly  TRUE ɂƖ߂l BASEIMAGE ͗Lȉ摜f[^ł͂ȂȂ܂ABASEIMAGE ̍XVs܂̂ŁAImageUpdateFlag 𗘗pĉ摜XVꂽǂ`FbNꍇ TRUE ɂĂ )
extern	int			GetMovieTotalFrameToGraph(			int GraphHandle ) ;															// t@C̑t[𓾂( Ogg Theora  mp4 ł̂ݗL )
extern	int			TellMovieToGraph(					int GraphHandle ) ;															// t@C̍Đʒu擾(~bP)
extern	int			TellMovieToGraphToFrame(			int GraphHandle ) ;															// t@C̍Đʒu擾(t[P)
extern	int			SeekMovieToGraphToFrame(			int GraphHandle, int Frame ) ;												// t@C̍Đʒuݒ肷(t[P)
extern	LONGLONG	GetOneFrameTimeMovieToGraph(		int GraphHandle ) ;															// t@ĈPt[̎Ԃ擾(߂lFPt[̎(P:}CNb))
extern	int			GetLastUpdateTimeMovieToGraph(		int GraphHandle ) ;															// t@C̃C[WŌɍXVԂ𓾂(~bP)
extern	int			UpdateMovieToGraph(					int GraphHandle ) ;															// t@C̍XVs
extern	int			SetMovieRightImageAlphaFlag(		int Flag ) ;																// ǂݍޓt@Cf̉E̐ԐƂĈǂZbg( TRUE:ƂĈ  FALSE:ƂĈȂ( ftHg ) )
extern	int			SetMovieColorA8R8G8B8Flag(			int Flag ) ;																// ǂݍޓt@C32bitJ[ꍇAA8R8G8B8 `ƂĈǂZbgA32bitJ[ł͂Ȃt@Cɑ΂Ă͖( Flag  TRUE:A8R8G8B8ƂĈ  FALSE:X8R8G8B8ƂĈ( ftHg ) )
extern	int			SetMovieUseYUVFormatSurfaceFlag(	int Flag ) ;																// xtutH[}bg̃T[tFXgpłꍇ͂xtutH[}bg̃T[tFXgp邩ǂݒ肷( TRUE:gp( ftHg ) FALSE:qfatH[}bg̃T[tFXgp )
#endif // DX_NON_MOVIE

// J֌W֐
extern	int			SetCameraNearFar(					float  Near, float  Far ) ;												// J NearNbvʂ FarNbvʂ̋ݒ肷
extern	int			SetCameraNearFarD(					double Near, double Far ) ;												// J NearNbvʂ FarNbvʂ̋ݒ肷
extern	int			SetCameraPositionAndTarget_UpVecY(  VECTOR    Position, VECTOR   Target ) ;									// J̎_A_AAbvxNgݒ肷( AbvxNg͂x瓱o )
extern	int			SetCameraPositionAndTarget_UpVecYD( VECTOR_D  Position, VECTOR_D Target ) ;									// J̎_A_AAbvxNgݒ肷( AbvxNg͂x瓱o )
extern	int			SetCameraPositionAndTargetAndUpVec( VECTOR    Position, VECTOR   TargetPosition, VECTOR   UpVector ) ;		// J̎_A_AAbvxNgݒ肷
extern	int			SetCameraPositionAndTargetAndUpVecD( VECTOR_D Position, VECTOR_D TargetPosition, VECTOR_D UpVector ) ;		// J̎_A_AAbvxNgݒ肷
extern	int			SetCameraPositionAndAngle(			VECTOR   Position, float  VRotate, float  HRotate, float  TRotate ) ;	// J̎_A_AAbvxNgݒ肷( _ƃAbvxNg͐]pxA]pxAP]px瓱o )
extern	int			SetCameraPositionAndAngleD(			VECTOR_D Position, double VRotate, double HRotate, double TRotate ) ;	// J̎_A_AAbvxNgݒ肷( _ƃAbvxNg͐]pxA]pxAP]px瓱o )
extern	int			SetCameraViewMatrix(				MATRIX   ViewMatrix ) ;													// r[s𒼐ڐݒ肷
extern	int			SetCameraViewMatrixD(				MATRIX_D ViewMatrix ) ;													// r[s𒼐ڐݒ肷
extern	int			SetCameraScreenCenter(				float x, float y ) ;													// ʏɂJĂf̒S̍Wݒ肷
extern	int			SetCameraScreenCenterD(				double x, double y ) ;													// ʏɂJĂf̒S̍Wݒ肷

extern	int			SetupCamera_Perspective(			float  Fov ) ;															// ߖ@JZbgAbv
extern	int			SetupCamera_PerspectiveD(			double Fov ) ;															// ߖ@JZbgAbv
extern	int			SetupCamera_Ortho(					float  Size ) ;															// ˉeJZbgAbv
extern	int			SetupCamera_OrthoD(					double Size ) ;															// ˉeJZbgAbv
extern	int			SetupCamera_ProjectionMatrix(		MATRIX   ProjectionMatrix ) ;											// ˉes𒼐ڐݒ肷
extern	int			SetupCamera_ProjectionMatrixD(		MATRIX_D ProjectionMatrix ) ;											// ˉes𒼐ڐݒ肷
extern	int			SetCameraDotAspect(					float  DotAspect ) ;													// J̃hbgAXyNgݒ肷
extern	int			SetCameraDotAspectD(				double DotAspect ) ;													// J̃hbgAXyNgݒ肷

extern	int			CheckCameraViewClip(				VECTOR   CheckPos ) ;													// w̍WJ̎EɓĂ邩ǂ𔻒肷( ߂l TRUE:EɓĂȂ  FALSE:EɓĂ )
extern	int			CheckCameraViewClipD(				VECTOR_D CheckPos ) ;													// w̍WJ̎EɓĂ邩ǂ𔻒肷( ߂l TRUE:EɓĂȂ  FALSE:EɓĂ )
extern	int			CheckCameraViewClip_Dir(			VECTOR   CheckPos ) ;													// w̍WJ̎EɓĂ邩ǂ𔻒肷A߂lŊOĂm邱Ƃł( ߂l 0:EɓĂ  0ȊO:EɓĂȂ( DX_CAMERACLIP_LEFT  DX_CAMERACLIP_RIGHT  or Zōꂽ́Aand ZŕmFł ) )
extern	int			CheckCameraViewClip_DirD(			VECTOR_D CheckPos ) ;													// w̍WJ̎EɓĂ邩ǂ𔻒肷A߂lŊOĂm邱Ƃł( ߂l 0:EɓĂ  0ȊO:EɓĂȂ( DX_CAMERACLIP_LEFT  DX_CAMERACLIP_RIGHT  or Zōꂽ́Aand ZŕmFł ) )
extern	int			CheckCameraViewClip_Box(			VECTOR   BoxPos1, VECTOR   BoxPos2 ) ;									// ̍Wŕ\{bNXJ̎EɓĂ邩ǂ𔻒肷( ߂l TRUE:EɓĂȂ  FALSE:EɓĂ )
extern	int			CheckCameraViewClip_BoxD(			VECTOR_D BoxPos1, VECTOR_D BoxPos2 ) ;									// ̍Wŕ\{bNXJ̎EɓĂ邩ǂ𔻒肷( ߂l TRUE:EɓĂȂ  FALSE:EɓĂ )

extern	float		GetCameraNear(						void ) ;																// J Near Nbvʂ̋擾
extern	double		GetCameraNearD(						void ) ;																// J Near Nbvʂ̋擾
extern	float		GetCameraFar(						void ) ;																// J Far Nbvʂ̋擾
extern	double		GetCameraFarD(						void ) ;																// J Far Nbvʂ̋擾

extern	VECTOR		GetCameraPosition(					void ) ;																// J̈ʒu擾
extern	VECTOR_D	GetCameraPositionD(					void ) ;																// J̈ʒu擾
extern	VECTOR		GetCameraTarget(					void ) ;																// J̒_擾
extern	VECTOR_D	GetCameraTargetD(					void ) ;																// J̒_擾
extern	VECTOR		GetCameraUpVector(					void ) ;																// J̐ʕɐȏ̃xNg擾
extern	VECTOR_D	GetCameraUpVectorD(					void ) ;																// J̐ʕɐȏ̃xNg擾
extern	VECTOR		GetCameraDownVector(				void ) ;																// J̐ʕɐȉ̃xNg擾
extern	VECTOR_D	GetCameraDownVectorD(				void ) ;																// J̐ʕɐȉ̃xNg擾
extern	VECTOR		GetCameraRightVector(				void ) ;																// J̐ʕɐȉẼxNg擾
extern	VECTOR_D	GetCameraRightVectorD(				void ) ;																// J̐ʕɐȉẼxNg擾
extern	VECTOR		GetCameraLeftVector(				void ) ;																// J̐ʕɐȍ̃xNg擾
extern	VECTOR_D	GetCameraLeftVectorD(				void ) ;																// J̐ʕɐȍ̃xNg擾
extern	VECTOR		GetCameraFrontVector(				void ) ;																// J̐ʕ̃xNg擾
extern	VECTOR_D	GetCameraFrontVectorD(				void ) ;																// J̐ʕ̃xNg擾
extern	VECTOR		GetCameraBackVector(				void ) ;																// J̌̃xNg擾
extern	VECTOR_D	GetCameraBackVectorD(				void ) ;																// J̌̃xNg擾
extern	float		GetCameraAngleHRotate(				void ) ;																// J̐̌擾
extern	double		GetCameraAngleHRotateD(				void ) ;																// J̐̌擾
extern	float		GetCameraAngleVRotate(				void ) ;																// J̐̌擾
extern	double		GetCameraAngleVRotateD(				void ) ;																// J̐̌擾
extern	float		GetCameraAngleTRotate(				void ) ;																// J̌̔Ppx擾
extern	double		GetCameraAngleTRotateD(				void ) ;																// J̌̔Ppx擾

extern	MATRIX		GetCameraViewMatrix(				void ) ;																// r[s擾
extern	MATRIX_D	GetCameraViewMatrixD(				void ) ;																// r[s擾
extern	MATRIX		GetCameraBillboardMatrix(			void ) ;																// r{[hs擾
extern	MATRIX_D	GetCameraBillboardMatrixD(			void ) ;																// r{[hs擾
extern	int			GetCameraScreenCenter(				float  *x, float  *y ) ;												// ʏɂJĂf̒S̍W擾
extern	int			GetCameraScreenCenterD(				double *x, double *y ) ;												// ʏɂJĂf̒S̍W擾
extern	float		GetCameraFov(						void ) ;																// J̎p擾
extern	double		GetCameraFovD(						void ) ;																// J̎p擾
extern	float		GetCameraSize(						void ) ;																// J̎TCY擾
extern	double		GetCameraSizeD(						void ) ;																// J̎TCY擾
extern	MATRIX		GetCameraProjectionMatrix(			void ) ;																// ˉes擾
extern	MATRIX_D	GetCameraProjectionMatrixD(			void ) ;																// ˉes擾
extern	float		GetCameraDotAspect(					void ) ;																// J̃hbgAXyNg𓾂
extern	double		GetCameraDotAspectD(				void ) ;																// J̃hbgAXyNg𓾂
extern	MATRIX		GetCameraViewportMatrix(			void ) ;																// r[|[gs擾
extern	MATRIX_D	GetCameraViewportMatrixD(			void ) ;																// r[|[gs擾
extern	MATRIX		GetCameraAPIViewportMatrix(			void ) ;																// Direct3DŎKpr[|[gs擾
extern	MATRIX_D	GetCameraAPIViewportMatrixD(		void ) ;																// Direct3DŎKpr[|[gs擾

// Cg֌W֐
extern	int			SetUseLighting(				int Flag ) ;																	// CeBOgp邩ǂݒ肷
extern	int			SetMaterialUseVertDifColor( int UseFlag ) ;																	// Rc`̃CeBOvZŒ_J[̃fBt[YJ[gp邩ǂݒ肷
extern	int			SetMaterialUseVertSpcColor( int UseFlag ) ;																	// Rc`̃CeBOvZŒ_J[̃XyLJ[gp邩ǂݒ肷
extern	int			SetMaterialParam(			MATERIALPARAM Material ) ;														// Rc`̃CeBOvZŎgp}eAp[^ݒ肷
extern	int			SetUseSpecular(				int UseFlag ) ;																	// Rc`ɃXyLgp邩ǂݒ肷
extern	int			SetGlobalAmbientLight(		COLOR_F Color ) ;																// O[oArGgCgJ[ݒ肷
extern	int			SetUseLightAngleAttenuation( int UseFlag ) ;																// Rc`̃CeBOvZŊpxsǂݒ肷( TRUE:pxs( ftHg )  FALSE:pxsȂ )
extern	int			SetUseHalfLambertLighting(	 int UseFlag ) ;																	// Rc`̃CeBOvZŃn[to[ggp邩ǂݒ肷( TRUE:n[to[ggp  FALSE:n[to[ggpȂ( ftHg ) )

extern	int			ChangeLightTypeDir(			VECTOR Direction ) ;															// ftHgCg̃^CvfBNViCgɂ
extern	int			ChangeLightTypeSpot(		VECTOR Position, VECTOR Direction, float OutAngle, float InAngle, float Range, float Atten0, float Atten1, float Atten2 ) ;	// ftHgCg̃^CvX|bgCgɂ
extern	int			ChangeLightTypePoint(		VECTOR Position, float Range, float Atten0, float Atten1, float Atten2 ) ;		// ftHgCg̃^Cv|CgCgɂ
extern	int			GetLightType(				void ) ;																		// ftHgCg̃^Cv擾( ߂l DX_LIGHTTYPE_DIRECTIONAL  )
extern	int			SetLightEnable(				int EnableFlag ) ;																// ftHgCggp邩ǂݒ肷
extern	int			GetLightEnable(				void ) ;																		// ftHgCggp邩ǂ擾( ߂l@TRUE:L  FALSE: )
extern	int			SetLightDifColor(			COLOR_F Color ) ;																// ftHgCg̃fBt[YJ[ݒ肷
extern	COLOR_F		GetLightDifColor(			void ) ;																		// ftHgCg̃fBt[YJ[擾
extern	int			SetLightSpcColor(			COLOR_F Color ) ;																// ftHgCg̃XyLJ[ݒ肷
extern	COLOR_F		GetLightSpcColor(			void ) ;																		// ftHgCg̃XyLJ[擾
extern	int			SetLightAmbColor(			COLOR_F Color ) ;																// ftHgCg̃ArGgJ[ݒ肷
extern	COLOR_F		GetLightAmbColor(			void ) ;																		// ftHgCg̃ArGgJ[擾
extern	int			SetLightDirection(			VECTOR Direction ) ;															// ftHgCg̕ݒ肷
extern	VECTOR		GetLightDirection(			void ) ;																		// ftHgCg̕擾
extern	int			SetLightPosition(			VECTOR Position ) ;																// ftHgCg̈ʒuݒ肷
extern	VECTOR		GetLightPosition(			void ) ;																		// ftHgCg̈ʒu擾
extern	int			SetLightRangeAtten(			float Range, float Atten0, float Atten1, float Atten2 ) ;						// ftHgCg̋p[^ݒ肷( LAWOAPAQ )
extern	int			GetLightRangeAtten(			float *Range, float *Atten0, float *Atten1, float *Atten2 )	;					// ftHgCg̋p[^擾( LAWOAPAQ )
extern	int			SetLightAngle(				float OutAngle, float InAngle ) ;												// ftHgCg̃X|bgCg̃p[^ݒ肷( OR[pxAR[px )
extern	int			GetLightAngle(				float *OutAngle, float *InAngle ) ;												// ftHgCg̃X|bgCg̃p[^擾( OR[pxAR[px )
extern	int			SetLightUseShadowMap(		int SmSlotIndex, int UseFlag ) ;												// ftHgCg SetUseShadowMap Ŏw肵VhE}bvKp邩ǂݒ肷( SmSlotIndex:VhE}bvXbg( SetUseShadowMap ̑ɐݒ肷l ) UseFlag:Kpɂ邩ǂ̃tO( TRUE:Kp( ftHg )  FALSE:KpȂ ) )

extern	int			CreateDirLightHandle(       VECTOR Direction ) ;															// fBNViCgnh쐬
extern	int			CreateSpotLightHandle(      VECTOR Position, VECTOR Direction, float OutAngle, float InAngle, float Range, float Atten0, float Atten1, float Atten2 ) ;	// X|bgCgnh쐬
extern	int			CreatePointLightHandle(     VECTOR Position, float Range, float Atten0, float Atten1, float Atten2 ) ;		// |CgCgnh쐬
extern	int			DeleteLightHandle(          int LHandle ) ;																	// Cgnh폜
extern	int			DeleteLightHandleAll(       void ) ;																		// CgnhSč폜
extern	int			SetLightTypeHandle(         int LHandle, int LightType ) ;													// Cgnh̃Cg̃^CvύX( DX_LIGHTTYPE_DIRECTIONAL  )
extern	int			SetLightEnableHandle(       int LHandle, int EnableFlag ) ;													// Cgnh̃Cgʂ̗LAݒ肷( TRUE:L  FALSE: )
extern	int			SetLightDifColorHandle(     int LHandle, COLOR_F Color ) ;													// Cgnh̃Cg̃fBt[YJ[ݒ肷
extern	int			SetLightSpcColorHandle(     int LHandle, COLOR_F Color ) ;													// Cgnh̃Cg̃XyLJ[ݒ肷
extern	int			SetLightAmbColorHandle(     int LHandle, COLOR_F Color ) ;													// Cgnh̃Cg̃ArGgJ[ݒ肷
extern	int			SetLightDirectionHandle(    int LHandle, VECTOR Direction ) ;												// Cgnh̃Cg̕ݒ肷
extern	int			SetLightPositionHandle(     int LHandle, VECTOR Position ) ;												// Cgnh̃Cg̈ʒuݒ肷
extern	int			SetLightRangeAttenHandle(   int LHandle, float Range, float Atten0, float Atten1, float Atten2 ) ;			// Cgnh̃Cg̋p[^ݒ肷( LAWOAPAQ )
extern	int			SetLightAngleHandle(        int LHandle, float OutAngle, float InAngle ) ;									// Cgnh̃Cg̃X|bgCg̃p[^ݒ肷( OR[pxAR[px )
extern	int			SetLightUseShadowMapHandle(	int LHandle, int SmSlotIndex, int UseFlag ) ;									// Cgnh̃Cg SetUseShadowMap Ŏw肵VhE}bvKp邩ǂݒ肷( SmSlotIndex:VhE}bvXbg( SetUseShadowMap ̑ɐݒ肷l ) UseFlag:Kpɂ邩ǂ̃tO( TRUE:Kp( ftHg )  FALSE:KpȂ ) )
extern	int			GetLightTypeHandle(         int LHandle ) ;																	// Cgnh̃Cg̃^Cv擾( ߂l DX_LIGHTTYPE_DIRECTIONAL  )
extern	int			GetLightEnableHandle(       int LHandle ) ;																	// Cgnh̃Cgʂ̗LA擾( TRUE:L  FALSE: )
extern	COLOR_F		GetLightDifColorHandle(     int LHandle ) ;																	// Cgnh̃Cg̃fBt[YJ[擾
extern	COLOR_F		GetLightSpcColorHandle(     int LHandle ) ;																	// Cgnh̃Cg̃XyLJ[擾
extern	COLOR_F		GetLightAmbColorHandle(     int LHandle ) ;																	// Cgnh̃Cg̃ArGgJ[擾
extern	VECTOR		GetLightDirectionHandle(    int LHandle ) ;																	// Cgnh̃Cg̕擾
extern	VECTOR		GetLightPositionHandle(     int LHandle ) ;																	// Cgnh̃Cg̈ʒu擾
extern	int			GetLightRangeAttenHandle(   int LHandle, float *Range, float *Atten0, float *Atten1, float *Atten2 ) ;		// Cgnh̃Cg̋p[^擾( LAWOAPAQ )
extern	int			GetLightAngleHandle(        int LHandle, float *OutAngle, float *InAngle ) ;								// Cgnh̃Cg̃X|bgCg̃p[^擾( OR[pxAR[px )

extern	int			GetEnableLightHandleNum(	void ) ;																		// LɂȂĂ郉Cgnh̐擾
extern	int			GetEnableLightHandle(		int Index ) ;																	// LɂȂĂ郉Cgnh擾

// F擾p֐
extern	int			GetTexFormatIndex(			const IMAGEFORMATDESC *Format ) ;												// eNX`tH[}bg̃CfbNX𓾂








// DxMask.cpp ֐vg^Cv錾

#ifndef DX_NON_MASK

// }XN֌W 
extern	int			CreateMaskScreen(					void ) ;																						// }XNXN[쐬
extern	int			DeleteMaskScreen(					void ) ;																						// }XNXN[폜
extern	int			DrawMaskToDirectData(				int x, int y, int Width, int Height, const void *MaskData , int TransMode ) ;					// }XNXN[Ƀ̃rbg}bvf[^]( MaskData  1byte  1dot \PC Width byte ̃f[^z̐擪AhX )
extern	int			DrawFillMaskToDirectData(			int x1, int y1, int x2, int y2,  int Width, int Height, const void *MaskData ) ;				// }XNXN[Ƀ̃rbg}bvf[^Ŏw`hԂ悤ɓ]

extern	int			SetUseMaskScreenFlag(				int ValidFlag ) ;																				// }XNXN[gp邩ǂݒ肷( ValidFlag:gp邩ǂ( TRUE:gp  FALSE:gpȂ( ftHg ) )
extern	int			GetUseMaskScreenFlag(				void ) ;																						// }XNXN[gp邩ǂ擾
extern	int			FillMaskScreen(						int Flag ) ;																					// }XNXN[w̐FœhԂ
extern	int			SetMaskScreenGraph(					int GraphHandle ) ;																				// }XNXN[ƂĎgpOtBbÑnhݒ肷A-1nƉ( œnOtBbNnh MakeScreen ō쐬uAt@`lt̕`ΏۂɂłOtBbNnhvłKv܂( At@`l}XNɎgp܂ ) )
extern	int			SetMaskScreenGraphUseChannel(		int UseChannel /* DX_MASKGRAPH_CH_A  */ ) ;													// }XNXN[ƂĎgpOtBbŃAǂ̃`l}XNƂĎgp邩ݒ肷( ftHg DX_MASKGRAPH_CH_AA ADX_MASKGRAPH_CH_AȊOgpꍇ̓OtBbNXfoCXVF[_[f2.0ȍ~ɑΉĂKv܂ )

extern	int			InitMask(							void ) ;																						// }XNnhׂč폜
extern	int			MakeMask(							int Width, int Height ) ;																		// }XNnh쐬
extern	int			GetMaskSize(						int *WidthBuf, int *HeightBuf, int MaskHandle ) ;												// }XNnh}XNC[W̃TCY擾
extern	int			GetMaskBaseImageInfo(				BASEIMAGE *BaseImage, int MaskHandle ) ;														// }XNnh}XNC[WBASEIMAGEf[^擾( tH[}bgύX悤ȑƐɓ삵ȂȂ܂AƁAReleaseBaseImage ͎sKv͂܂ )
extern	int			SetDataToMask(						int Width, int Height, const void *MaskData, int MaskHandle ) ;									// }XNnhɃrbg}bvC[W]
extern	int			DeleteMask(							int MaskHandle ) ;																				// }XNnh폜
extern	int			GraphImageBltToMask(				const BASEIMAGE *BaseImage, int ImageX, int ImageY, int MaskHandle ) ;							// }XNnhBASEIMAGEf[^]
extern	int			LoadMask(							const TCHAR *FileName                        ) ;																			// 摜t@Cǂݍ݃}XNnh쐬
extern	int			LoadMaskWithStrLen(					const TCHAR *FileName, size_t FileNameLength ) ;																			// 摜t@Cǂݍ݃}XNnh쐬
extern	int			LoadDivMask(						const TCHAR *FileName,                        int AllNum, int XNum, int YNum, int XSize, int YSize, int *HandleArray ) ;	// 摜t@C𕪊ǂݍ݂ă}XNnh쐬
extern	int			LoadDivMaskWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int AllNum, int XNum, int YNum, int XSize, int YSize, int *HandleArray ) ;	// 摜t@C𕪊ǂݍ݂ă}XNnh쐬
extern	int			CreateMaskFromMem(					const void *FileImage, int FileImageSize ) ;																				// ɂ摜t@CC[Wǂݍ݃}XNnh쐬
extern	int			CreateDivMaskFromMem(				const void *FileImage, int FileImageSize, int AllNum, int XNum, int YNum, int XSize, int YSize, int *HandleArray ) ;		// ɂ摜t@CC[W𕪊ǂݍ݂ă}XNnh쐬
extern	int			DrawMask(							int x, int y, int MaskHandle, int TransMode ) ;													// }XNXN[Ƀ}XNnh̎}XNC[W
#ifndef DX_NON_FONT
extern	int			DrawFormatStringMask(				int x, int y, int Flag,                 const TCHAR *FormatString, ... ) ;						// w肠̕}XNXN[ɕ`悷
extern	int			DrawFormatStringMaskToHandle(		int x, int y, int Flag, int FontHandle, const TCHAR *FormatString, ... ) ;						// w肠̕}XNXN[ɕ`悷( tHgnhw )( SetFontCacheToTextureFlag( FALSE ) ; ɂč쐬tHgnĥݎgp\ )
extern	int			DrawStringMask(						int x, int y, int Flag,                 const TCHAR *String ) ;									// }XNXN[ɕ`悷
extern	int			DrawNStringMask(					int x, int y, int Flag,                 const TCHAR *String, size_t StringLength ) ;			// }XNXN[ɕ`悷
extern	int			DrawStringMaskToHandle(				int x, int y, int Flag, int FontHandle, const TCHAR *String ) ;									// }XNXN[ɕ`悷( tHgnhw )( SetFontCacheToTextureFlag( FALSE ) ; ɂč쐬tHgnĥݎgp\ )
extern	int			DrawNStringMaskToHandle(			int x, int y, int Flag, int FontHandle, const TCHAR *String, size_t StringLength ) ;			// }XNXN[ɕ`悷( tHgnhw )( SetFontCacheToTextureFlag( FALSE ) ; ɂč쐬tHgnĥݎgp\ )
#endif // DX_NON_FONT
extern	int			DrawFillMask(						int x1, int y1, int x2, int y2, int MaskHandle ) ;												// }XNnh}XNC[W}XNXN[ςɕ`悷( ^Cɕׂ )
extern	int			SetMaskReverseEffectFlag(			int ReverseFlag ) ;																				// }XNC[W̐lɑ΂ʂt]( o[WƂׂ̌݊̈̋@\ )

extern 	int			GetMaskScreenData(					int x1, int y1, int x2, int y2, int MaskHandle ) ;												// }XNXN[̎w`}XNnhɓ]
extern	int			GetMaskUseFlag(						void ) ;																						// }XNXN[gpݒɂȂĂ邩ǂ擾

#endif // DX_NON_MASK

#endif // DX_NOTUSE_DRAWFUNCTION















// DxFont.cpp ֐vg^Cv錾

#ifndef DX_NON_FONT

// tHgA`֌W֐
extern	int			EnumFontName(                           TCHAR *NameBuffer, int NameBufferNum, int JapanOnlyFlag DEFAULTPARAM( = TRUE ) ) ;																				// gp\ȃtHg̖O񋓂( NameBuffer  64oCg؂ŖOi[܂ )
extern	int			EnumFontNameEx(                         TCHAR *NameBuffer, int NameBufferNum,                                                       int CharSet DEFAULTPARAM( = -1 ) /* DX_CHARSET_DEFAULT  */ ) ;	// gp\ȃtHg̖O񋓂( NameBuffer  64oCg؂ŖOi[܂ )( Zbgw )
extern	int			EnumFontNameEx2(						TCHAR *NameBuffer, int NameBufferNum, const TCHAR *EnumFontName,                            int CharSet DEFAULTPARAM( = -1 ) /* DX_CHARSET_DEFAULT  */ ) ;	// w̃tHg̃tHg񋓂
extern	int			EnumFontNameEx2WithStrLen(				TCHAR *NameBuffer, int NameBufferNum, const TCHAR *EnumFontName, size_t EnumFontNameLength, int CharSet DEFAULTPARAM( = -1 ) /* DX_CHARSET_DEFAULT  */ ) ;	// w̃tHg̃tHg񋓂
extern	int			CheckFontName(							const TCHAR *FontName,                        int CharSet DEFAULTPARAM( = -1 ) /* DX_CHARSET_DEFAULT  */ ) ;													// w̃tHg̃tHg݂邩ǂ`FbN( ߂l  TRUE:݂  FALSE:݂Ȃ )
extern	int			CheckFontNameWithStrLen(				const TCHAR *FontName, size_t FontNameLength, int CharSet DEFAULTPARAM( = -1 ) /* DX_CHARSET_DEFAULT  */ ) ;													// w̃tHg̃tHg݂邩ǂ`FbN( ߂l  TRUE:݂  FALSE:݂Ȃ )

extern	int			InitFontToHandle(                       void ) ;																						// SẴtHgnh폜

extern	int			CreateFontToHandle(						const TCHAR *FontName,                        int Size, int Thick, int FontType DEFAULTPARAM( = -1 ) , int CharSet DEFAULTPARAM( = -1 ) , int EdgeSize DEFAULTPARAM( = -1 ) , int Italic DEFAULTPARAM( = FALSE ) , int Handle DEFAULTPARAM( = -1 ) ) ;		// tHgnh쐬
extern	int			CreateFontToHandleWithStrLen(			const TCHAR *FontName, size_t FontNameLength, int Size, int Thick, int FontType DEFAULTPARAM( = -1 ) , int CharSet DEFAULTPARAM( = -1 ) , int EdgeSize DEFAULTPARAM( = -1 ) , int Italic DEFAULTPARAM( = FALSE ) , int Handle DEFAULTPARAM( = -1 ) ) ;		// tHgnh쐬
extern	int			LoadFontDataToHandle(					const TCHAR *FileName,                            int EdgeSize DEFAULTPARAM( = 0 ) ) ;			// tHgf[^t@CtHgnh쐬
extern	int			LoadFontDataToHandleWithStrLen(			const TCHAR *FileName, size_t FileNameLength,     int EdgeSize DEFAULTPARAM( = 0 ) ) ;			// tHgf[^t@CtHgnh쐬
extern	int			LoadFontDataFromMemToHandle(			const void *FontDataImage, int FontDataImageSize, int EdgeSize DEFAULTPARAM( = 0 ) ) ;			// ̃tHgf[^t@CC[WtHgnh쐬
extern	int			SetFontSpaceToHandle(                   int Pixel, int FontHandle ) ;																	// tHgnh̎ԂύX
extern	int			SetFontLineSpaceToHandle(               int Pixel, int FontHandle ) ;																	// tHgnh̍sԂύX
extern	int			SetFontCharCodeFormatToHandle(			int CharCodeFormat /* DX_CHARCODEFORMAT_SHIFTJIS  */ , int FontHandle ) ;						// w̃tHgnhgp֐̈ɓn̕R[h`ݒ肷( UNICODEłł͖ )
extern	int			DeleteFontToHandle(                     int FontHandle ) ;																				// tHgnh폜
extern	int			SetFontLostFlag(                        int FontHandle, int *LostFlag ) ;																// tHgnh폜ۂ TRUE ϐ̃AhXݒ肷
extern	int			AddFontImageToHandle(					int FontHandle, const TCHAR *Char,                    int GrHandle, int DrawX, int DrawY, int AddX ) ;	// w̑̕ɕ`悷OtBbNnho^
extern	int			AddFontImageToHandleWithStrLen(			int FontHandle, const TCHAR *Char, size_t CharLength, int GrHandle, int DrawX, int DrawY, int AddX ) ;	// w̑̕ɕ`悷OtBbNnho^
extern	int			SubFontImageToHandle(					int FontHandle, const TCHAR *Char                    ) ;												// w̑̕ɕ`悷OtBbNnh̓o^
extern	int			SubFontImageToHandleWithStrLen(			int FontHandle, const TCHAR *Char, size_t CharLength ) ;												// w̑̕ɕ`悷OtBbNnh̓o^
extern	int			AddSubstitutionFontToHandle(			int FontHandle, int SubstitutionFontHandle, int DrawX, int DrawY ) ;							// փtHgnh( FontHandle ɖ`悵悤ƂƂɑɎgptHgnh )o^
extern	int			SubSubstitutionFontToHandle(			int FontHandle, int SubstitutionFontHandle ) ;													// փtHgnh̓o^

extern	int			ChangeFont(                             const TCHAR *FontName,                        int CharSet DEFAULTPARAM( = -1 ) /* DX_CHARSET_SHFTJIS  */ ) ;	// ftHgtHgnhŎgptHgύX
extern	int			ChangeFontWithStrLen(                   const TCHAR *FontName, size_t FontNameLength, int CharSet DEFAULTPARAM( = -1 ) /* DX_CHARSET_SHFTJIS  */ ) ;	// ftHgtHgnhŎgptHgύX
extern	int			ChangeFontFromHandle(					int FontHandle ) ;																				// ftHgtHgnhƂĎgptHgnhύX
extern	int			ChangeFontType(                         int FontType ) ;																				// ftHgtHgnh̃tHg^Cv̕ύX
extern	const TCHAR *GetFontName(							void ) ;																						// ftHgtHgnh̃tHg擾
extern	int			SetFontSize(                            int FontSize ) ;																				// ftHgtHgnh̃TCYݒ肷
extern	int			GetFontSize(                            void ) ;																						// ftHgtHgnh̃TCY擾
extern	int			GetFontEdgeSize(                        void ) ;																						// ftHgtHgnh̉TCY擾
extern	int			SetFontThickness(                       int ThickPal ) ;																				// ftHgtHgnh̑ݒ肷
extern	int			SetFontSpace(                           int Pixel ) ;																					// ftHgtHgnh̎ԂύX
extern	int			GetFontSpace(                           void ) ;																						// ftHgtHgnh̎Ԃ擾
extern	int			SetFontLineSpace(                       int Pixel ) ;																					// ftHgtHgnh̍sԂύX
extern	int			GetFontLineSpace(                       void ) ;																						// ftHgtHgnh̍sԂ擾
extern	int			SetFontCharCodeFormat(					int CharCodeFormat /* DX_CHARCODEFORMAT_SHIFTJIS  */ ) ;										// ftHgtHgnhgp֐̈ɓn̕R[h`ݒ肷( UNICODEłł͖ )
extern	int			SetDefaultFontState(                    const TCHAR *FontName,                        int Size, int Thick, int FontType DEFAULTPARAM( = -1 ) , int CharSet DEFAULTPARAM( = -1 ) , int EdgeSize DEFAULTPARAM( = -1 ) , int Italic DEFAULTPARAM( = FALSE ) ) ;	// ftHgtHgnh̐ݒύX
extern	int			SetDefaultFontStateWithStrLen(          const TCHAR *FontName, size_t FontNameLength, int Size, int Thick, int FontType DEFAULTPARAM( = -1 ) , int CharSet DEFAULTPARAM( = -1 ) , int EdgeSize DEFAULTPARAM( = -1 ) , int Italic DEFAULTPARAM( = FALSE ) ) ;	// ftHgtHgnh̐ݒύX
extern	int			GetDefaultFontHandle(                   void ) ;																								// ftHgtHgnh擾
extern	int			GetFontMaxCacheCharNum(					void ) ;																								// ftHgtHgnh̃LbVł镶̐擾
extern	int			GetFontMaxWidth(                        void ) ;																								// ftHgtHgnh̍̕ő啝擾
extern	int			GetFontAscent(                          void ) ;																								// ftHgtHgnh̕`ʒux[XC܂ł̍擾
extern	int			GetDrawStringWidth(                     const TCHAR *String, int StrLen,          int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// ftHgtHgnhgp̕`敝擾
extern	int			GetDrawNStringWidth(                    const TCHAR *String, size_t StringLength, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// ftHgtHgnhgp̕`敝擾
extern	int			GetDrawFormatStringWidth(               const TCHAR *FormatString, ... ) ;																		// ftHgtHgnhgpt̕`敝擾
extern	int			GetDrawExtendStringWidth(               double ExRateX, const TCHAR *String, int StrLen,          int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;					// ftHgtHgnhgp̕`敝擾( g嗦t )
extern	int			GetDrawExtendNStringWidth(              double ExRateX, const TCHAR *String, size_t StringLength, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;					// ftHgtHgnhgp̕`敝擾( g嗦t )
extern	int			GetDrawExtendFormatStringWidth(         double ExRateX, const TCHAR *FormatString, ... ) ;														// ftHgtHgnhgpt̕`敝擾( g嗦t )
extern	int			GetDrawStringSize(                      int *SizeX, int *SizeY, int *LineCount, const TCHAR *String, int StrLen,          int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;											// ftHgtHgnhgp̕`敝EEs擾
extern	int			GetDrawNStringSize(                     int *SizeX, int *SizeY, int *LineCount, const TCHAR *String, size_t StringLength, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;											// ftHgtHgnhgp̕`敝EEs擾
extern	int			GetDrawFormatStringSize(                int *SizeX, int *SizeY, int *LineCount, const TCHAR *FormatString, ... ) ;																				// ftHgtHgnhgpt̕`敝EEs擾
extern	int			GetDrawExtendStringSize(                int *SizeX, int *SizeY, int *LineCount, double ExRateX, double ExRateY, const TCHAR *String, int StrLen,          int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// ftHgtHgnhgp̕`敝EEs擾( g嗦t )
extern	int			GetDrawExtendNStringSize(               int *SizeX, int *SizeY, int *LineCount, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// ftHgtHgnhgp̕`敝EEs擾( g嗦t )
extern	int			GetDrawExtendFormatStringSize(          int *SizeX, int *SizeY, int *LineCount, double ExRateX, double ExRateY, const TCHAR *FormatString, ... ) ;												// ftHgtHgnhgpt̕`敝EEs擾( g嗦t )
extern	int			GetDrawStringCharInfo(                  DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, const TCHAR *String, int StrLen,          int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// ftHgtHgnhgp̂P̏擾
extern	int			GetDrawNStringCharInfo(                 DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, const TCHAR *String, size_t StringLength, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// ftHgtHgnhgp̂P̏擾
extern	int			GetDrawFormatStringCharInfo(            DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, const TCHAR *FormatString, ... ) ;																		// ftHgtHgnhgpt̂P̏擾
extern	int			GetDrawExtendStringCharInfo(            DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, double ExRateX, double ExRateY, const TCHAR *String, int StrLen,          int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// ftHgtHgnhgp̂P̏擾
extern	int			GetDrawExtendNStringCharInfo(           DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// ftHgtHgnhgp̂P̏擾
extern	int			GetDrawExtendFormatStringCharInfo(      DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, double ExRateX, double ExRateY, const TCHAR *FormatString, ... ) ;										// ftHgtHgnhgpt̂P̏擾
extern	int			GetDrawStringKerningPairInfo(			const TCHAR *PairChar,                        int *KernAmount ) ;								// ftHgtHgnhgp̃̕yÃJ[jO擾( PairChar:J[jO𒲂ׂyAƂȂ2̕( 2ȏ゠Ă擪2gp܂ )  KernAmount:2ڂ̕{̈ʒu炸炷hbgint^ϐ̃AhX )
extern	int			GetDrawStringKerningPairInfoWithStrLen(	const TCHAR *PairChar, size_t PairCharLength, int *KernAmount ) ;								// ftHgtHgnhgp̃̕yÃJ[jO擾( PairChar:J[jO𒲂ׂyAƂȂ2̕( 2ȏ゠Ă擪2gp܂ )  KernAmount:2ڂ̕{̈ʒu炸炷hbgint^ϐ̃AhX )

extern	const TCHAR *GetFontNameToHandle(					int FontHandle ) ;																				// tHgnh̃tHg擾
extern	int			GetFontMaxCacheCharNumToHandle(			int FontHandle ) ;																				// tHgnh̃LbVł镶̐擾
extern	int			GetFontMaxWidthToHandle(                int FontHandle ) ;																				// tHgnh̍̕ő啝擾
extern	int			GetFontAscentToHandle(                  int FontHandle ) ;																				// tHgnh̕`ʒux[XC܂ł̍擾
extern	int			GetFontSizeToHandle(                    int FontHandle ) ;																				// tHgnh̃TCY擾
extern	int			GetFontEdgeSizeToHandle(                int FontHandle ) ;																				// tHgnh̉TCY擾
extern	int			GetFontSpaceToHandle(                   int FontHandle ) ;																				// tHgnh̎Ԃ擾
extern	int			GetFontLineSpaceToHandle(               int FontHandle ) ;																				// tHgnh̍sԂ擾
extern	int			GetFontCharInfo(                        int FontHandle, const TCHAR *Char,                    int *DrawX, int *DrawY, int *NextCharX, int *SizeX, int *SizeY ) ;	// tHgnh̎w̕̕`擾
extern	int			GetFontCharInfoWithStrLen(              int FontHandle, const TCHAR *Char, size_t CharLength, int *DrawX, int *DrawY, int *NextCharX, int *SizeX, int *SizeY ) ;	// tHgnh̎w̕̕`擾
extern	int			GetDrawStringWidthToHandle(             const TCHAR   *String, int StrLen,          int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;						// tHgnhgp̕`敝擾
extern	int			GetDrawNStringWidthToHandle(            const TCHAR   *String, size_t StringLength, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;						// tHgnhgp̕`敝擾
extern	int			GetDrawFormatStringWidthToHandle(       int FontHandle, const TCHAR *FormatString, ... ) ;																// tHgnhgpt̕`敝擾
extern	int			GetDrawExtendStringWidthToHandle(       double ExRateX, const TCHAR *String, int StrLen,          int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// tHgnhgp̕`敝擾
extern	int			GetDrawExtendNStringWidthToHandle(      double ExRateX, const TCHAR *String, size_t StringLength, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// tHgnhgp̕`敝擾
extern	int			GetDrawExtendFormatStringWidthToHandle( double ExRateX, int FontHandle, const TCHAR *FormatString, ... ) ;												// tHgnhgpt̕`敝擾
extern	int			GetDrawStringSizeToHandle(              int *SizeX, int *SizeY, int *LineCount, const TCHAR   *String, int StrLen,          int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;											// tHgnhgp̕`敝EEs擾
extern	int			GetDrawNStringSizeToHandle(             int *SizeX, int *SizeY, int *LineCount, const TCHAR   *String, size_t StringLength, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;											// tHgnhgp̕`敝EEs擾
extern	int			GetDrawFormatStringSizeToHandle(        int *SizeX, int *SizeY, int *LineCount, int FontHandle, const TCHAR *FormatString, ... ) ;																					// tHgnhgpt̕`敝EEs擾
extern	int			GetDrawExtendStringSizeToHandle(        int *SizeX, int *SizeY, int *LineCount, double ExRateX, double ExRateY, const TCHAR *String, int StrLen,          int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;				// tHgnhgp̕`敝EEs擾
extern	int			GetDrawExtendNStringSizeToHandle(       int *SizeX, int *SizeY, int *LineCount, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;				// tHgnhgp̕`敝EEs擾
extern	int			GetDrawExtendFormatStringSizeToHandle(  int *SizeX, int *SizeY, int *LineCount, double ExRateX, double ExRateY, int FontHandle, const TCHAR *FormatString, ... ) ;													// tHgnhgpt̕`敝EEs擾
extern	int			GetDrawStringCharInfoToHandle(              DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, const TCHAR *String, int StrLen,          int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// tHgnhgp̂P̏擾
extern	int			GetDrawNStringCharInfoToHandle(             DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, const TCHAR *String, size_t StringLength, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// tHgnhgp̂P̏擾
extern	int			GetDrawFormatStringCharInfoToHandle(        DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, int FontHandle, const TCHAR *FormatString, ... ) ;																		// tHgnhgpt̂P̏擾
extern	int			GetDrawExtendStringCharInfoToHandle(        DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, double ExRateX, double ExRateY, const TCHAR *String, int StrLen,          int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// tHgnhgp̂P̏擾
extern	int			GetDrawExtendNStringCharInfoToHandle(       DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// tHgnhgp̂P̏擾
extern	int			GetDrawExtendFormatStringCharInfoToHandle(  DRAWCHARINFO *InfoBuffer, size_t InfoBufferSize, double ExRateX, double ExRateY, int FontHandle, const TCHAR *FormatString, ... ) ;										// tHgnhgpt̂P̏擾
extern	int			GetDrawStringKerningPairInfoToHandle(	        const TCHAR *PairChar,                        int *KernAmount, int FontHandle ) ;		// tHgnhgp̃̕yÃJ[jO擾( PairChar:J[jO𒲂ׂyAƂȂ2̕( 2ȏ゠Ă擪2gp܂ )  KernAmount:2ڂ̕{̈ʒu炸炷hbgint^ϐ̃AhX )
extern	int			GetDrawStringKerningPairInfoToHandleWithStrLen(	const TCHAR *PairChar, size_t PairCharLength, int *KernAmount, int FontHandle ) ;		// tHgnhgp̃̕yÃJ[jO擾( PairChar:J[jO𒲂ׂyAƂȂ2̕( 2ȏ゠Ă擪2gp܂ )  KernAmount:2ڂ̕{̈ʒu炸炷hbgint^ϐ̃AhX )
extern	int			GetFontStateToHandle(                   TCHAR   *FontName, int *Size, int *Thick, int FontHandle, int *FontType DEFAULTPARAM( = NULL ) , int *CharSet DEFAULTPARAM( = NULL ) , int *EdgeSize DEFAULTPARAM( = NULL ) , int *Italic DEFAULTPARAM( = NULL ) ) ;						// tHgnh̏擾
extern	int			CheckFontCacheToTextureFlag(            int FontHandle ) ;																				// tHgnheNX`LbVgpĂ邩ǂ擾
extern	int			CheckFontChacheToTextureFlag(           int FontHandle ) ;																				// CheckFontCacheToTextureFlag ̌뎚
extern	int			CheckFontHandleValid(                   int FontHandle ) ;																				// tHgnhLǂ擾
extern	int			ClearFontCacheToHandle(					int FontHandle ) ;																				// tHgnh̃LbV

extern	int			SetFontCacheToTextureFlag(              int Flag ) ;																					// tHg̃LbVɃeNX`gp邩ǂݒ肷( TRUE:eNX`gp( ftHg )  FALSE:eNX`͎gpȂ )
extern	int			GetFontCacheToTextureFlag(              void ) ;																						// tHg̃LbVɃeNX`gp邩ǂݒ肷
extern	int			SetFontChacheToTextureFlag(             int Flag ) ;																					// SetFontCacheToTextureFlag ̌뎚
extern	int			GetFontChacheToTextureFlag(             void ) ;																						// GetFontCacheToTextureFlag ̌뎚
extern	int			SetFontCacheTextureColorBitDepth(		int ColorBitDepth ) ;																			// tHg̃LbVƂĎgpeNX`̃J[rbg[xݒ肷( 16  32 ̂ݎw\  ftHg 32 )
extern	int			GetFontCacheTextureColorBitDepth(		void ) ;																						// tHg̃LbVƂĎgpeNX`̃J[rbg[x擾
extern	int			SetFontCacheCharNum(                    int CharNum ) ;																					// tHgLbVŃLbVł镶ݒ肷
extern	int			GetFontCacheCharNum(                    void ) ;																						// tHgLbVŃLbVł镶擾( ߂l  0:ftHg  1ȏ:w蕶 )
extern	int			SetFontCacheUsePremulAlphaFlag(         int Flag ) ;																					// tHgLbVƂĕۑ摜̌`Zς݃`lt摜ɂ邩ǂݒ肷( TRUE:Zς݃gp  FLASE:Zς݃gpȂ( ftHg ) )
extern	int			GetFontCacheUsePremulAlphaFlag(         void ) ;																						// tHgLbVƂĕۑ摜̌`Zς݃`lt摜ɂ邩ǂ擾
extern	int			SetFontUseAdjustSizeFlag(               int Flag ) ;																					// tHg̃TCY␳鏈sǂݒ肷( Flag  TRUE:s( ftHg )  FALSE:sȂ )
extern	int			GetFontUseAdjustSizeFlag(               void ) ;																						// tHg̃TCY␳鏈sǂ擾
extern	int			SetFontOnlyDrawType(					int OnlyType ) ;																				// tHg̕`ŉ̂݁A͖{̂̂ݕ`sǂݒ肷( OnlyType  0:ʏ` 1:{̂̂ݕ` 2:̂ݕ` )
extern	int			GetFontOnlyDrawType(					void ) ;																						// tHg̕`ŉ̂݁A͖{̂̂ݕ`sǂ擾( ߂l  0:ʏ` 1:{̂̂ݕ` 2:̂ݕ` )
extern	int			SetFontIgnoreLFFlag(					int Flag ) ;																					// DrawString Ȃǂ \n 𖳎邩ǂݒ肷( TRUE :     FALSE : Ȃ( ftHg ) )
extern	int			GetFontIgnoreLFFlag(					void ) ;																						// DrawString Ȃǂ \n 𖳎邩ǂ擾( TRUE :     FALSE : Ȃ( ftHg ) )


// FontCacheStringDraw ̑ DrawString gĂ
extern	int			FontCacheStringDrawToHandle(            int x, int y, const TCHAR *StrData,                       unsigned int Color, unsigned int EdgeColor, BASEIMAGE *DestImage, const RECT *ClipRect /* NULL  */ , int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) , SIZE *DrawSizeP DEFAULTPARAM( = NULL ) ) ;
extern	int			FontCacheStringDrawToHandleWithStrLen(  int x, int y, const TCHAR *StrData, size_t StrDataLength, unsigned int Color, unsigned int EdgeColor, BASEIMAGE *DestImage, const RECT *ClipRect /* NULL  */ , int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) , SIZE *DrawSizeP DEFAULTPARAM( = NULL ) ) ;
extern	int			FontBaseImageBlt(                       int x, int y, const TCHAR *StrData,                       BASEIMAGE *DestImage, BASEIMAGE *DestEdgeImage,                 int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// {C[Wɕ`悷( ftHgtHgnhgp )
extern	int			FontBaseImageBltWithStrLen(             int x, int y, const TCHAR *StrData, size_t StrDataLength, BASEIMAGE *DestImage, BASEIMAGE *DestEdgeImage,                 int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// {C[Wɕ`悷( ftHgtHgnhgp )
extern	int			FontBaseImageBltToHandle(               int x, int y, const TCHAR *StrData,                       BASEIMAGE *DestImage, BASEIMAGE *DestEdgeImage, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// {C[Wɕ`悷
extern	int			FontBaseImageBltToHandleWithStrLen(     int x, int y, const TCHAR *StrData, size_t StrDataLength, BASEIMAGE *DestImage, BASEIMAGE *DestEdgeImage, int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// {C[Wɕ`悷

extern	int			MultiByteCharCheck(                     const char *Buf, int CharSet /* DX_CHARSET_SHFTJIS */ ) ;										// QoCgׂ( TRUE:QoCg  FALSE:PoCg )

// `֐
extern	int			DrawString(                             int x, int y,                                              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ`悷
extern	int			DrawNString(                            int x, int y,                                              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ`悷
extern	int			DrawVString(                            int x, int y,                                              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ`悷( c )
extern	int			DrawNVString(                           int x, int y,                                              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ`悷( c )
extern	int			DrawFormatString(                       int x, int y,                                 unsigned int Color,                         const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶`悷
extern	int			DrawFormatVString(                      int x, int y,                                 unsigned int Color,                         const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶`悷( c )
extern	int			DrawFormatString2(                      int x, int y,                                 unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶`悷( ̐Ft )
extern	int			DrawFormatVString2(                     int x, int y,                                 unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶`悷( ̐Ft )( c )
extern	int			DrawExtendString(                       int x, int y, double ExRateX, double ExRateY,              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ̊g`
extern	int			DrawExtendNString(                      int x, int y, double ExRateX, double ExRateY,              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ̊g`
extern	int			DrawExtendVString(                      int x, int y, double ExRateX, double ExRateY,              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ̊g`( c )
extern	int			DrawExtendNVString(                     int x, int y, double ExRateX, double ExRateY,              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;							// ftHgtHgnhgpĕ̊g`( c )
extern	int			DrawExtendFormatString(                 int x, int y, double ExRateX, double ExRateY, unsigned int Color,                         const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶g`悷
extern	int			DrawExtendFormatVString(                int x, int y, double ExRateX, double ExRateY, unsigned int Color,                         const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶g`悷( c )
extern	int			DrawExtendFormatString2(                int x, int y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶g`悷( ̐Ft )
extern	int			DrawExtendFormatVString2(               int x, int y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																	// ftHgtHgnhgpďw蕶g`悷( ̐Ft )( c )
extern	int			DrawRotaString(							int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL )                           ) ;		// ftHgtHgnhgpĕ]`悷
extern	int			DrawRotaNString(						int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL ) , size_t StringLength DEFAULTPARAM( = 0 ) ) ;		// ftHgtHgnhgpĕ]`悷
extern	int			DrawRotaFormatString(					int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *FormatString DEFAULTPARAM( = NULL ) , ...                     ) ;		// ftHgtHgnhgpďw蕶]`悷
extern	int			DrawModiString(							int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL )                           ) ;		// ftHgtHgnhgpĕό``悷
extern	int			DrawModiNString(						int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL ) , size_t StringLength DEFAULTPARAM( = 0 ) ) ;		// ftHgtHgnhgpĕό``悷
extern	int			DrawModiFormatString(					int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *FormatString DEFAULTPARAM( = NULL ) , ...                     ) ;		// ftHgtHgnhgpďw蕶ό``悷

extern	int			DrawStringF(                            float x, float y,                                              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ`悷( Ww肪 float  )
extern	int			DrawNStringF(                           float x, float y,                                              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ`悷( Ww肪 float  )
extern	int			DrawVStringF(                           float x, float y,                                              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ`悷( c )( Ww肪 float  )
extern	int			DrawNVStringF(                          float x, float y,                                              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ`悷( c )( Ww肪 float  )
extern	int			DrawFormatStringF(                      float x, float y,                                 unsigned int Color,                         const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶`悷( Ww肪 float  )
extern	int			DrawFormatVStringF(                     float x, float y,                                 unsigned int Color,                         const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶`悷( c )( Ww肪 float  )
extern	int			DrawFormatString2F(                     float x, float y,                                 unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶`悷( ̐Ft )( Ww肪 float  )
extern	int			DrawFormatVString2F(                    float x, float y,                                 unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶`悷( ̐Ft )( c )( Ww肪 float  )
extern	int			DrawExtendStringF(                      float x, float y, double ExRateX, double ExRateY,              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ̊g`( Ww肪 float  )
extern	int			DrawExtendNStringF(                     float x, float y, double ExRateX, double ExRateY,              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ̊g`( Ww肪 float  )
extern	int			DrawExtendVStringF(                     float x, float y, double ExRateX, double ExRateY,              const TCHAR *String,                      unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ̊g`( c )( Ww肪 float  )
extern	int			DrawExtendNVStringF(                    float x, float y, double ExRateX, double ExRateY,              const TCHAR *String, size_t StringLength, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;						// ftHgtHgnhgpĕ̊g`( c )( Ww肪 float  )
extern	int			DrawExtendFormatStringF(                float x, float y, double ExRateX, double ExRateY, unsigned int Color,                         const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶g`悷( Ww肪 float  )
extern	int			DrawExtendFormatVStringF(               float x, float y, double ExRateX, double ExRateY, unsigned int Color,                         const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶g`悷( c )( Ww肪 float  )
extern	int			DrawExtendFormatString2F(               float x, float y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶g`悷( ̐Ft )( Ww肪 float  )
extern	int			DrawExtendFormatVString2F(              float x, float y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, const TCHAR *FormatString, ... ) ;																// ftHgtHgnhgpďw蕶g`悷( ̐Ft )( c )( Ww肪 float  )
extern	int			DrawRotaStringF(						float x, float y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL )                           ) ;		// ftHgtHgnhgpĕ]`悷( Ww肪 float  )
extern	int			DrawRotaNStringF(						float x, float y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL ) , size_t StringLength DEFAULTPARAM( = 0 ) ) ;		// ftHgtHgnhgpĕ]`悷( Ww肪 float  )
extern	int			DrawRotaFormatStringF(					float x, float y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *FormatString DEFAULTPARAM( = NULL ) , ...                     ) ;		// ftHgtHgnhgpďw蕶]`悷( Ww肪 float  )
extern	int			DrawModiStringF(						float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL )                           ) ;		// ftHgtHgnhgpĕό``悷( Ww肪 float  )
extern	int			DrawModiNStringF(						float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL ) , size_t StringLength DEFAULTPARAM( = 0 ) ) ;		// ftHgtHgnhgpĕό``悷( Ww肪 float  )
extern	int			DrawModiFormatStringF(					float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *FormatString DEFAULTPARAM( = NULL ) , ...                     ) ;		// ftHgtHgnhgpďw蕶ό``悷( Ww肪 float  )

extern	int			DrawNumberToI(                          int x, int y,                          int    Num, int RisesNum, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// ftHgtHgnhgpĐ^̐l`悷
extern	int			DrawNumberToF(                          int x, int y,                          double Num, int Length,   unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// ftHgtHgnhgpĕ_^̐l`悷
extern	int			DrawNumberPlusToI(                      int x, int y, const TCHAR *NoteString, int    Num, int RisesNum, unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// ftHgtHgnhgpĐ^̐lƂ̐̕xɕ`悷
extern 	int			DrawNumberPlusToF(                      int x, int y, const TCHAR *NoteString, double Num, int Length,   unsigned int Color, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// ftHgtHgnhgpĕ_^̐lƂ̐̕xɕ`悷

extern	int			DrawStringToZBuffer(                    int x, int y, const TCHAR *String,                                                                                        int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕ`悷
extern	int			DrawNStringToZBuffer(                   int x, int y, const TCHAR *String, size_t StringLength,                                                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕ`悷
extern	int			DrawVStringToZBuffer(                   int x, int y, const TCHAR *String,                                                                                        int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕ`悷( c )
extern	int			DrawNVStringToZBuffer(                  int x, int y, const TCHAR *String, size_t StringLength,                                                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕ`悷( c )
extern	int			DrawFormatStringToZBuffer(              int x, int y,                                                                                        int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;									// ftHgtHgnhgpĂyobt@ɑ΂ďw蕶`悷
extern	int			DrawFormatVStringToZBuffer(             int x, int y,                                                                                        int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;									// ftHgtHgnhgpĂyobt@ɑ΂ďw蕶`悷( c )
extern	int			DrawExtendStringToZBuffer(              int x, int y, double ExRateX, double ExRateY, const TCHAR *String,                                                        int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕg`悷
extern	int			DrawExtendNStringToZBuffer(             int x, int y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength,                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕg`悷
extern	int			DrawExtendVStringToZBuffer(             int x, int y, double ExRateX, double ExRateY, const TCHAR *String,                                                        int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕg`悷( c )
extern	int			DrawExtendNVStringToZBuffer(            int x, int y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength,                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;												// ftHgtHgnhgpĂyobt@ɑ΂ĕg`悷( c )
extern	int			DrawExtendFormatStringToZBuffer(        int x, int y, double ExRateX, double ExRateY,                                                        int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;									// ftHgtHgnhgpĂyobt@ɑ΂ďw蕶g`悷
extern	int			DrawExtendFormatVStringToZBuffer(       int x, int y, double ExRateX, double ExRateY,                                                        int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;									// ftHgtHgnhgpĂyobt@ɑ΂ďw蕶g`悷( c )
extern	int			DrawRotaStringToZBuffer(				int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag , const TCHAR *String                            ) ;	// ftHgtHgnhgpĂyobt@ɑ΂ĕ]`悷
extern	int			DrawRotaNStringToZBuffer(				int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag , const TCHAR *String,       size_t StringLength ) ;	// ftHgtHgnhgpĂyobt@ɑ΂ĕ]`悷
extern	int			DrawRotaFormatStringToZBuffer(			int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag , const TCHAR *FormatString , ...                ) ;	// ftHgtHgnhgpĂyobt@ɑ΂ďw蕶]`悷
extern	int			DrawModiStringToZBuffer(				int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4,                                      int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag , const TCHAR *String                            ) ;	// ftHgtHgnhgpĂyobt@ɑ΂ĕό``悷
extern	int			DrawModiNStringToZBuffer(				int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4,                                      int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag , const TCHAR *String,       size_t StringLength ) ;	// ftHgtHgnhgpĂyobt@ɑ΂ĕό``悷
extern	int			DrawModiFormatStringToZBuffer(			int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4,                                      int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag , const TCHAR *FormatString , ...                ) ;	// ftHgtHgnhgpĂyobt@ɑ΂ďw蕶ό``悷


extern	int			DrawStringToHandle(                     int x, int y, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// tHgnhgpĕ`悷
extern	int			DrawNStringToHandle(                    int x, int y, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// tHgnhgpĕ`悷
extern	int			DrawVStringToHandle(                    int x, int y, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;																				// tHgnhgpĕ`悷( c )
extern	int			DrawNVStringToHandle(                   int x, int y, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;																				// tHgnhgpĕ`悷( c )
extern	int			DrawFormatStringToHandle(               int x, int y, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷
extern	int			DrawFormatVStringToHandle(              int x, int y, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷( c )
extern	int			DrawFormatString2ToHandle(              int x, int y, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷( ̐Ft )
extern	int			DrawFormatVString2ToHandle(             int x, int y, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷( ̐Ft )( c )
extern	int			DrawExtendStringToHandle(               int x, int y, double ExRateX, double ExRateY, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// tHgnhgpĕg`悷
extern	int			DrawExtendNStringToHandle(              int x, int y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// tHgnhgpĕg`悷
extern	int			DrawExtendVStringToHandle(              int x, int y, double ExRateX, double ExRateY, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;												// tHgnhgpĕg`悷( c )
extern	int			DrawExtendNVStringToHandle(             int x, int y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;												// tHgnhgpĕg`悷( c )
extern	int			DrawExtendFormatStringToHandle(         int x, int y, double ExRateX, double ExRateY, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷
extern	int			DrawExtendFormatVStringToHandle(        int x, int y, double ExRateX, double ExRateY, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷( c )
extern	int			DrawExtendFormatString2ToHandle(        int x, int y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷( ̐Ft )
extern	int			DrawExtendFormatVString2ToHandle(       int x, int y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷( ̐Ft )( c )
extern	int			DrawRotaStringToHandle(					int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *String                            ) ;		// tHgnhgpĕ]`悷
extern	int			DrawRotaNStringToHandle(				int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *String,       size_t StringLength ) ;		// tHgnhgpĕ]`悷
extern	int			DrawRotaFormatStringToHandle(			int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *FormatString, ...                 ) ;		// tHgnhgpďw蕶]`悷
extern	int			DrawModiStringToHandle(					int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *String                            ) ;	// tHgnhgpĕό``悷
extern	int			DrawModiNStringToHandle(				int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *String,       size_t StringLength ) ;	// tHgnhgpĕό``悷
extern	int			DrawModiFormatStringToHandle(			int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *FormatString, ...                 ) ;	// tHgnhgpďw蕶ό``悷

extern	int			DrawStringFToHandle(                    float x, float y, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// tHgnhgpĕ`悷( Ww肪 float  )
extern	int			DrawNStringFToHandle(                   float x, float y, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;									// tHgnhgpĕ`悷( Ww肪 float  )
extern	int			DrawVStringFToHandle(                   float x, float y, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;																				// tHgnhgpĕ`悷( c )( Ww肪 float  )
extern	int			DrawNVStringFToHandle(                  float x, float y, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;																				// tHgnhgpĕ`悷( c )( Ww肪 float  )
extern	int			DrawFormatStringFToHandle(              float x, float y, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷( Ww肪 float  )
extern	int			DrawFormatVStringFToHandle(             float x, float y, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷( c )( Ww肪 float  )
extern	int			DrawFormatString2FToHandle(             float x, float y, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷( ̐Ft )( Ww肪 float  )
extern	int			DrawFormatVString2FToHandle(            float x, float y, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																											// tHgnhgpďw蕶`悷( ̐Ft )( c )( Ww肪 float  )
extern	int			DrawExtendStringFToHandle(              float x, float y, double ExRateX, double ExRateY, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// tHgnhgpĕg`悷( Ww肪 float  )
extern	int			DrawExtendNStringFToHandle(             float x, float y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;	// tHgnhgpĕg`悷( Ww肪 float  )
extern	int			DrawExtendVStringFToHandle(             float x, float y, double ExRateX, double ExRateY, const TCHAR *String,                      unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;												// tHgnhgpĕg`悷( c )( Ww肪 float  )
extern	int			DrawExtendNVStringFToHandle(            float x, float y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;												// tHgnhgpĕg`悷( c )( Ww肪 float  )
extern	int			DrawExtendFormatStringFToHandle(        float x, float y, double ExRateX, double ExRateY, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷( Ww肪 float  )
extern	int			DrawExtendFormatVStringFToHandle(       float x, float y, double ExRateX, double ExRateY, unsigned int Color,                         int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷( c )( Ww肪 float  )
extern	int			DrawExtendFormatString2FToHandle(       float x, float y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷( ̐Ft )( Ww肪 float  )
extern	int			DrawExtendFormatVString2FToHandle(      float x, float y, double ExRateX, double ExRateY, unsigned int Color, unsigned int EdgeColor, int FontHandle, const TCHAR *FormatString, ... ) ;																			// tHgnhgpďw蕶g`悷( ̐Ft )( c )( Ww肪 float  )
extern	int			DrawRotaStringFToHandle(				float x, float y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL )                           ) ;		// tHgnhgpĕ]`悷( Ww肪 float  )
extern	int			DrawRotaNStringFToHandle(				float x, float y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *String       DEFAULTPARAM( = NULL ) , size_t StringLength DEFAULTPARAM( = 0 ) ) ;		// tHgnhgpĕ]`悷( Ww肪 float  )
extern	int			DrawRotaFormatStringFToHandle(			float x, float y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) , int VerticalFlag DEFAULTPARAM( = FALSE ) , const TCHAR *FormatString DEFAULTPARAM( = NULL ) , ...                     ) ;		// tHgnhgpďw蕶]`悷( Ww肪 float  )
extern	int			DrawModiStringFToHandle(				float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *String                            ) ;		// tHgnhgpĕό``悷( Ww肪 float  )
extern	int			DrawModiNStringFToHandle(				float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *String,       size_t StringLength ) ;		// tHgnhgpĕό``悷( Ww肪 float  )
extern	int			DrawModiFormatStringFToHandle(			float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, unsigned int Color, int FontHandle, unsigned int EdgeColor, int VerticalFlag, const TCHAR *FormatString, ...                 ) ;		// tHgnhgpďw蕶ό``悷( Ww肪 float  )

extern	int			DrawNumberToIToHandle(                  int x, int y,                          int    Num, int RisesNum, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// tHgnhgpĐ^̐l`悷
extern	int			DrawNumberToFToHandle(                  int x, int y,                          double Num, int Length,   unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// tHgnhgpĕ_^̐l`悷
extern	int			DrawNumberPlusToIToHandle(              int x, int y, const TCHAR *NoteString, int    Num, int RisesNum, unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// tHgnhgpĐ^̐lƂ̐̕xɕ`悷
extern	int			DrawNumberPlusToFToHandle(              int x, int y, const TCHAR *NoteString, double Num, int Length,   unsigned int Color, int FontHandle, unsigned int EdgeColor DEFAULTPARAM( = 0 ) ) ;											// tHgnhgpĕ_^̐lƂ̐̕xɕ`悷

extern	int			DrawStringToHandleToZBuffer(            int x, int y, const TCHAR *String,                      int FontHandle,                                                                   int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// tHgnhgpĂyobt@ɑ΂ĕ`悷
extern	int			DrawNStringToHandleToZBuffer(           int x, int y, const TCHAR *String, size_t StringLength, int FontHandle,                                                                   int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// tHgnhgpĂyobt@ɑ΂ĕ`悷
extern	int			DrawVStringToHandleToZBuffer(           int x, int y, const TCHAR *String,                      int FontHandle,                                                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;													// tHgnhgpĂyobt@ɑ΂ĕ`悷( c )
extern	int			DrawNVStringToHandleToZBuffer(          int x, int y, const TCHAR *String, size_t StringLength, int FontHandle,                                                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;													// tHgnhgpĂyobt@ɑ΂ĕ`悷( c )
extern	int			DrawFormatStringToHandleToZBuffer(      int x, int y, int FontHandle,                                                                                        int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;										// tHgnhgpĂyobt@ɑ΂ďw蕶`悷
extern	int			DrawFormatVStringToHandleToZBuffer(     int x, int y, int FontHandle,                                                                                        int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;										// tHgnhgpĂyobt@ɑ΂ďw蕶`悷( c )
extern	int			DrawExtendStringToHandleToZBuffer(      int x, int y, double ExRateX, double ExRateY, const TCHAR *String,                      int FontHandle,                                   int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// tHgnhgpĂyobt@ɑ΂ĕg`悷
extern	int			DrawExtendNStringToHandleToZBuffer(     int x, int y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, int FontHandle,                                   int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;			// tHgnhgpĂyobt@ɑ΂ĕg`悷
extern	int			DrawExtendVStringToHandleToZBuffer(     int x, int y, double ExRateX, double ExRateY, const TCHAR *String,                      int FontHandle,                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;													// tHgnhgpĂyobt@ɑ΂ĕg`悷( c )
extern	int			DrawExtendNVStringToHandleToZBuffer(    int x, int y, double ExRateX, double ExRateY, const TCHAR *String, size_t StringLength, int FontHandle,                                   int WriteZMode /* DX_ZWRITE_MASK  */ ) ;													// tHgnhgpĂyobt@ɑ΂ĕg`悷( c )
extern	int			DrawExtendFormatStringToHandleToZBuffer(   int x, int y, double ExRateX, double ExRateY, int FontHandle,                                                      int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;										// tHgnhgpĂyobt@ɑ΂ďw蕶g`悷
extern	int			DrawExtendFormatVStringToHandleToZBuffer(  int x, int y, double ExRateX, double ExRateY, int FontHandle,                                                      int WriteZMode /* DX_ZWRITE_MASK  */ , const TCHAR *FormatString, ... ) ;										// tHgnhgpĂyobt@ɑ΂ďw蕶g`悷( c )
extern	int			DrawRotaStringToHandleToZBuffer(		int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, int FontHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag, const TCHAR *String                            ) ;		// tHgnhgpĂyobt@ɑ΂ĕ]`悷
extern	int			DrawRotaNStringToHandleToZBuffer(		int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, int FontHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag, const TCHAR *String,       size_t StringLength ) ;		// tHgnhgpĂyobt@ɑ΂ĕ]`悷
extern	int			DrawRotaFormatStringToHandleToZBuffer(	int x, int y, double ExRateX, double ExRateY, double RotCenterX, double RotCenterY, double RotAngle, int FontHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag, const TCHAR *FormatString, ...                 ) ;		// tHgnhgpĂyobt@ɑ΂ďw蕶]`悷
extern	int			DrawModiStringToHandleToZBuffer(		int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int FontHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag, const TCHAR *String                            ) ;											// tHgnhgpĂyobt@ɑ΂ĕό``悷
extern	int			DrawModiNStringToHandleToZBuffer(		int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int FontHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag, const TCHAR *String,       size_t StringLength ) ;											// tHgnhgpĂyobt@ɑ΂ĕό``悷
extern	int			DrawModiFormatStringToHandleToZBuffer(	int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int FontHandle, int WriteZMode /* DX_ZWRITE_MASK  */ , int VerticalFlag, const TCHAR *FormatString, ...                 ) ;											// tHgnhgpĂyobt@ɑ΂ďw蕶ό``悷

#endif // DX_NON_FONT








// DxMath.cpp ֐vg^Cv錾

// ZCu
extern	int			ConvertMatrixFtoD(             MATRIX_D *Out, const MATRIX   *In ) ;															// float^vf̍sdouble^vf̍sɕϊ
extern	int			ConvertMatrixDtoF(             MATRIX   *Out, const MATRIX_D *In ) ;															// double^vf̍sfloat^vf̍sɕϊ
extern	int			CreateIdentityMatrix(          MATRIX   *Out ) ;																				// Pʍs쐬
extern	int			CreateIdentityMatrixD(         MATRIX_D *Out ) ;																				// Pʍs쐬
extern	int			CreateLookAtMatrix(            MATRIX   *Out, const VECTOR   *Eye, const VECTOR   *At, const VECTOR   *Up ) ;					// r[s쐬
extern	int			CreateLookAtMatrixD(           MATRIX_D *Out, const VECTOR_D *Eye, const VECTOR_D *At, const VECTOR_D *Up ) ;					// r[s쐬
extern	int			CreateLookAtMatrix2(           MATRIX   *Out, const VECTOR   *Eye, double XZAngle, double Oira ) ;								// r[s쐬(]lŎw)
extern	int			CreateLookAtMatrix2D(          MATRIX_D *Out, const VECTOR_D *Eye, double XZAngle, double Oira ) ;								// r[s쐬(]lŎw)
extern	int			CreateLookAtMatrixRH(          MATRIX   *Out, const VECTOR   *Eye, const VECTOR   *At, const VECTOR   *Up ) ;					// r[s쐬(EWnp)
extern	int			CreateLookAtMatrixRHD(         MATRIX_D *Out, const VECTOR_D *Eye, const VECTOR_D *At, const VECTOR_D *Up ) ;					// r[s쐬(EWnp)
extern	int			CreateMultiplyMatrix(          MATRIX   *Out, const MATRIX   *In1, const MATRIX   *In2 ) ;										// s̐ς߂
extern	int			CreateMultiplyMatrixD(         MATRIX_D *Out, const MATRIX_D *In1, const MATRIX_D *In2 ) ;										// s̐ς߂
extern	int			CreatePerspectiveFovMatrix(    MATRIX   *Out, float  fov,  float  zn, float  zf, float  aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬
extern	int			CreatePerspectiveFovMatrixD(   MATRIX_D *Out, double fov,  double zn, double zf, double aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬
extern	int			CreatePerspectiveFovMatrixRH(  MATRIX   *Out, float  fov,  float  zn, float  zf, float  aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬(EWnp)
extern	int			CreatePerspectiveFovMatrixRHD( MATRIX_D *Out, double fov,  double zn, double zf, double aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬(EWnp)
extern	int			CreateOrthoMatrix(             MATRIX   *Out, float  size, float  zn, float  zf, float  aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬
extern	int			CreateOrthoMatrixD(            MATRIX_D *Out, double size, double zn, double zf, double aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬
extern	int			CreateOrthoMatrixRH(           MATRIX   *Out, float  size, float  zn, float  zf, float  aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬(EWnp)
extern	int			CreateOrthoMatrixRHD(          MATRIX_D *Out, double size, double zn, double zf, double aspect DEFAULTPARAM( = -1.0f ) ) ;		// ˉes쐬(EWnp)
extern	int			CreateScalingMatrix(           MATRIX   *Out, float  sx, float  sy, float  sz ) ;												// XP[Os쐬
extern	int			CreateScalingMatrixD(          MATRIX_D *Out, double sx, double sy, double sz ) ;												// XP[Os쐬
extern	int			CreateRotationXMatrix(         MATRIX   *Out, float  Angle ) ;																	// w𒆐SƂ]s쐬
extern	int			CreateRotationXMatrixD(        MATRIX_D *Out, double Angle ) ;																	// w𒆐SƂ]s쐬
extern	int			CreateRotationYMatrix(         MATRIX   *Out, float  Angle ) ;																	// x𒆐SƂ]s쐬
extern	int			CreateRotationYMatrixD(        MATRIX_D *Out, double Angle ) ;																	// x𒆐SƂ]s쐬
extern	int			CreateRotationZMatrix(         MATRIX   *Out, float  Angle ) ;																	// y𒆐SƂ]s쐬
extern	int			CreateRotationZMatrixD(        MATRIX_D *Out, double Angle ) ;																	// y𒆐SƂ]s쐬
extern	int			CreateTranslationMatrix(       MATRIX   *Out, float  x, float  y, float  z ) ;													// sړs쐬
extern	int			CreateTranslationMatrixD(      MATRIX_D *Out, double x, double y, double z ) ;													// sړs쐬
extern	int			CreateTransposeMatrix(         MATRIX   *Out, const MATRIX   *In ) ;															// ]us쐬
extern	int			CreateTransposeMatrixD(        MATRIX_D *Out, const MATRIX_D *In ) ;															// ]us쐬
extern	int			CreateInverseMatrix(           MATRIX   *Out, const MATRIX   *In ) ;															// ts쐬
extern	int			CreateInverseMatrixD(          MATRIX_D *Out, const MATRIX_D *In ) ;															// ts쐬
extern	int			CreateViewportMatrix(          MATRIX   *Out, float  CenterX, float  CenterY, float  Width, float  Height ) ;					// r[|[gs쐬
extern	int			CreateViewportMatrixD(         MATRIX_D *Out, double CenterX, double CenterY, double Width, double Height ) ;					// r[|[gs쐬
extern	int			CreateRotationXYZMatrix(       MATRIX   *Out, float  XRot, float  YRot, float  ZRot ) ;											// w]x]y]s쐬
extern	int			CreateRotationXYZMatrixD(      MATRIX_D *Out, double XRot, double YRot, double ZRot ) ;											// w]x]y]s쐬
extern	int			CreateRotationXZYMatrix(       MATRIX   *Out, float  XRot, float  YRot, float  ZRot ) ;											// w]y]x]s쐬
extern	int			CreateRotationXZYMatrixD(      MATRIX_D *Out, double XRot, double YRot, double ZRot ) ;											// w]y]x]s쐬
extern	int			CreateRotationYXZMatrix(       MATRIX   *Out, float  XRot, float  YRot, float  ZRot ) ;											// x]w]y]s쐬
extern	int			CreateRotationYXZMatrixD(      MATRIX_D *Out, double XRot, double YRot, double ZRot ) ;											// x]w]y]s쐬
extern	int			CreateRotationYZXMatrix(       MATRIX   *Out, float  XRot, float  YRot, float  ZRot ) ;											// x]y]w]s쐬
extern	int			CreateRotationYZXMatrixD(      MATRIX_D *Out, double XRot, double YRot, double ZRot ) ;											// x]y]w]s쐬
extern	int			CreateRotationZXYMatrix(       MATRIX   *Out, float  XRot, float  YRot, float  ZRot ) ;											// y]w]x]s쐬
extern	int			CreateRotationZXYMatrixD(      MATRIX_D *Out, double XRot, double YRot, double ZRot ) ;											// y]w]x]s쐬
extern	int			CreateRotationZYXMatrix(       MATRIX   *Out, float  XRot, float  YRot, float  ZRot ) ;											// y]x]w]s쐬
extern	int			CreateRotationZYXMatrixD(      MATRIX_D *Out, double XRot, double YRot, double ZRot ) ;											// y]x]w]s쐬
extern	int			GetMatrixXYZRotation(          const MATRIX   *In, float  *OutXRot, float  *OutYRot, float  *OutZRot ) ;						// s񂩂wxy]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixXYZRotationD(         const MATRIX_D *In, double *OutXRot, double *OutYRot, double *OutZRot ) ;						// s񂩂wxy]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixXZYRotation(          const MATRIX   *In, float  *OutXRot, float  *OutYRot, float  *OutZRot ) ;						// s񂩂wyx]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixXZYRotationD(         const MATRIX_D *In, double *OutXRot, double *OutYRot, double *OutZRot ) ;						// s񂩂wyx]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixYXZRotation(          const MATRIX   *In, float  *OutXRot, float  *OutYRot, float  *OutZRot ) ;						// s񂩂xwy]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixYXZRotationD(         const MATRIX_D *In, double *OutXRot, double *OutYRot, double *OutZRot ) ;						// s񂩂xwy]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixYZXRotation(          const MATRIX   *In, float  *OutXRot, float  *OutYRot, float  *OutZRot ) ;						// s񂩂xyw]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixYZXRotationD(         const MATRIX_D *In, double *OutXRot, double *OutYRot, double *OutZRot ) ;						// s񂩂xyw]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixZXYRotation(          const MATRIX   *In, float  *OutXRot, float  *OutYRot, float  *OutZRot ) ;						// s񂩂ywx]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixZXYRotationD(         const MATRIX_D *In, double *OutXRot, double *OutYRot, double *OutZRot ) ;						// s񂩂ywx]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixZYXRotation(          const MATRIX   *In, float  *OutXRot, float  *OutYRot, float  *OutZRot ) ;						// s񂩂yxw]̒l擾( ߂l@-1:WobN  0: )
extern	int			GetMatrixZYXRotationD(         const MATRIX_D *In, double *OutXRot, double *OutYRot, double *OutZRot ) ;						// s񂩂yxw]̒l擾( ߂l@-1:WobN  0: )
extern	int			VectorConvertFtoD(             VECTOR_D *Out, const VECTOR   *In ) ;															// float^̃xNgdouble^̃xNgɕϊ
extern	int			VectorConvertDtoF(             VECTOR   *Out, const VECTOR_D *In ) ;															// double^̃xNgfloat^̃xNgɕϊ
extern	int			VectorNormalize(               VECTOR   *Out, const VECTOR   *In ) ;															// xNg𐳋K
extern	int			VectorNormalizeD(              VECTOR_D *Out, const VECTOR_D *In ) ;															// xNg𐳋K
extern	int			VectorScale(                   VECTOR   *Out, const VECTOR   *In, float  Scale ) ;												// xNgXJ[{
extern	int			VectorScaleD(                  VECTOR_D *Out, const VECTOR_D *In, double Scale ) ;												// xNgXJ[{
extern	int			VectorMultiply(                VECTOR   *Out, const VECTOR   *In1, const VECTOR   *In2 ) ;										// xNg̊|Z
extern	int			VectorMultiplyD(               VECTOR_D *Out, const VECTOR_D *In1, const VECTOR_D *In2 ) ;										// xNg̊|Z
extern	int			VectorSub(                     VECTOR   *Out, const VECTOR   *In1, const VECTOR   *In2 ) ;										// Out = In1 - In2 ̃xNgvZ 
extern	int			VectorSubD(                    VECTOR_D *Out, const VECTOR_D *In1, const VECTOR_D *In2 ) ;										// Out = In1 - In2 ̃xNgvZ 
extern	int			VectorAdd(                     VECTOR   *Out, const VECTOR   *In1, const VECTOR   *In2 ) ;										// Out = In1 + In2 ̃xNgvZ 
extern	int			VectorAddD(                    VECTOR_D *Out, const VECTOR_D *In1, const VECTOR_D *In2 ) ;										// Out = In1 + In2 ̃xNgvZ 
extern	int			VectorOuterProduct(            VECTOR   *Out, const VECTOR   *In1, const VECTOR   *In2 ) ;										// In1In2̊OςvZ
extern	int			VectorOuterProductD(           VECTOR_D *Out, const VECTOR_D *In1, const VECTOR_D *In2 ) ;										// In1In2̊OςvZ
extern	float 		VectorInnerProduct(            const VECTOR   *In1, const VECTOR   *In2 ) ;														// In1In2̓ςvZ
extern	double		VectorInnerProductD(           const VECTOR_D *In1, const VECTOR_D *In2 ) ;														// In1In2̓ςvZ
extern	int			VectorRotationX(               VECTOR   *Out, const VECTOR   *In, double Angle ) ;												// xNĝwɂ]s
extern	int			VectorRotationXD(              VECTOR_D *Out, const VECTOR_D *In, double Angle ) ;												// xNĝwɂ]s
extern	int			VectorRotationY(               VECTOR   *Out, const VECTOR   *In, double Angle ) ;												// xNĝxɂ]s
extern	int			VectorRotationYD(              VECTOR_D *Out, const VECTOR_D *In, double Angle ) ;												// xNĝxɂ]s
extern	int			VectorRotationZ(               VECTOR   *Out, const VECTOR   *In, double Angle ) ;												// xNĝyɂ]s
extern	int			VectorRotationZD(              VECTOR_D *Out, const VECTOR_D *In, double Angle ) ;												// xNĝyɂ]s
extern	int			VectorTransform(               VECTOR   *Out, const VECTOR   *InVec, const MATRIX   *InMatrix ) ;								// xNgs4x4sZ( w  1 Ɖ )
extern	int			VectorTransformD(              VECTOR_D *Out, const VECTOR_D *InVec, const MATRIX_D *InMatrix ) ;								// xNgs4x4sZ( w  1 Ɖ )
extern	int			VectorTransformSR(             VECTOR   *Out, const VECTOR   *InVec, const MATRIX   *InMatrix ) ;								// xNgs4x4s̉]݂̂Z
extern	int			VectorTransformSRD(            VECTOR_D *Out, const VECTOR_D *InVec, const MATRIX_D *InMatrix ) ;								// xNgs4x4s̉]݂̂Z
extern	int			VectorTransform4(              VECTOR   *Out, float  *V4Out, const VECTOR   *InVec, const float  *V4In, const MATRIX   *InMatrix ) ; // xNgs4x4sZ( w ̗vfn )
extern	int			VectorTransform4D(             VECTOR_D *Out, double *V4Out, const VECTOR_D *InVec, const double *V4In, const MATRIX_D *InMatrix ) ; // xNgs4x4sZ( w ̗vfn )

extern	int			Segment_Segment_Analyse(      const VECTOR   *SegmentAPos1, const VECTOR   *SegmentAPos2, const VECTOR   *SegmentBPos1, const VECTOR   *SegmentBPos2, SEGMENT_SEGMENT_RESULT   *Result ) ;								// ̐̍Őڋߓ_͂
extern	int			Segment_Segment_AnalyseD(     const VECTOR_D *SegmentAPos1, const VECTOR_D *SegmentAPos2, const VECTOR_D *SegmentBPos1, const VECTOR_D *SegmentBPos2, SEGMENT_SEGMENT_RESULT_D *Result ) ;								// ̐̍Őڋߓ_͂
extern	int			Segment_Point_Analyse(        const VECTOR   *SegmentPos1, const VECTOR   *SegmentPos2, const VECTOR   *PointPos, SEGMENT_POINT_RESULT   *Result ) ;																	// Ɠ_̍Őڋߓ_͂
extern	int			Segment_Point_AnalyseD(       const VECTOR_D *SegmentPos1, const VECTOR_D *SegmentPos2, const VECTOR_D *PointPos, SEGMENT_POINT_RESULT_D *Result ) ;																	// Ɠ_̍Őڋߓ_͂
extern	int			Segment_Triangle_Analyse(     const VECTOR   *SegmentPos1, const VECTOR   *SegmentPos2, const VECTOR   *TrianglePos1, const VECTOR   *TrianglePos2, const VECTOR   *TrianglePos3, SEGMENT_TRIANGLE_RESULT   *Result ) ;	// ƎOp`̍Őڋߓ_͂
extern	int			Segment_Triangle_AnalyseD(    const VECTOR_D *SegmentPos1, const VECTOR_D *SegmentPos2, const VECTOR_D *TrianglePos1, const VECTOR_D *TrianglePos2, const VECTOR_D *TrianglePos3, SEGMENT_TRIANGLE_RESULT_D *Result ) ;	// ƎOp`̍Őڋߓ_͂
extern	int			Triangle_Point_Analyse(       const VECTOR   *TrianglePos1, const VECTOR   *TrianglePos2, const VECTOR   *TrianglePos3, const VECTOR   *PointPos, TRIANGLE_POINT_RESULT   *Result ) ;									// Op`Ɠ_̍Őڋߓ_͂
extern	int			Triangle_Point_AnalyseD(      const VECTOR_D *TrianglePos1, const VECTOR_D *TrianglePos2, const VECTOR_D *TrianglePos3, const VECTOR_D *PointPos, TRIANGLE_POINT_RESULT_D *Result ) ;									// Op`Ɠ_̍Őڋߓ_͂
extern	int			Plane_Point_Analyse(          const VECTOR   *PlanePos, const VECTOR   *PlaneNormal, const VECTOR   *PointPos, PLANE_POINT_RESULT   *Result ) ;																			// ʂƓ_̍ŋߓ_͂
extern	int			Plane_Point_AnalyseD(         const VECTOR_D *PlanePos, const VECTOR_D *PlaneNormal, const VECTOR_D *PointPos, PLANE_POINT_RESULT_D *Result ) ;																			// ʂƓ_̍ŋߓ_͂

extern	void		TriangleBarycenter(           VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3, VECTOR   Position, float  *TrianglePos1Weight, float  *TrianglePos2Weight, float  *TrianglePos3Weight ) ;	// w̍WOp`̏dS߂
extern	void		TriangleBarycenterD(          VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3, VECTOR_D Position, double *TrianglePos1Weight, double *TrianglePos2Weight, double *TrianglePos3Weight ) ;	// w̍WOp`̏dS߂

extern	float 		Segment_Segment_MinLength(           VECTOR   SegmentAPos1, VECTOR   SegmentAPos2, VECTOR   SegmentBPos1, VECTOR   SegmentBPos2 ) ;														// ̐̍ŋߓ_Ԃ̋𓾂
extern	double		Segment_Segment_MinLengthD(          VECTOR_D SegmentAPos1, VECTOR_D SegmentAPos2, VECTOR_D SegmentBPos1, VECTOR_D SegmentBPos2 ) ;														// ̐̍ŋߓ_Ԃ̋𓾂
extern	float 		Segment_Segment_MinLength_Square(    VECTOR   SegmentAPos1, VECTOR   SegmentAPos2, VECTOR   SegmentBPos1, VECTOR   SegmentBPos2 ) ;														// ̐̍ŋߓ_Ԃ̋̓𓾂
extern	double		Segment_Segment_MinLength_SquareD(   VECTOR_D SegmentAPos1, VECTOR_D SegmentAPos2, VECTOR_D SegmentBPos1, VECTOR_D SegmentBPos2 ) ;														// ̐̍ŋߓ_Ԃ̋̓𓾂
extern	float 		Segment_Triangle_MinLength(          VECTOR   SegmentPos1, VECTOR   SegmentPos2, VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3 ) ;								// ƎOp`̍ŋߓ_Ԃ̋𓾂 
extern	double		Segment_Triangle_MinLengthD(         VECTOR_D SegmentPos1, VECTOR_D SegmentPos2, VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3 ) ;								// ƎOp`̍ŋߓ_Ԃ̋𓾂 
extern	float 		Segment_Triangle_MinLength_Square(   VECTOR   SegmentPos1, VECTOR   SegmentPos2, VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3 ) ;								// ƎOp`̍ŋߓ_Ԃ̋̓𓾂 
extern	double		Segment_Triangle_MinLength_SquareD(  VECTOR_D SegmentPos1, VECTOR_D SegmentPos2, VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3 ) ;								// ƎOp`̍ŋߓ_Ԃ̋̓𓾂 
extern	float 		Segment_Point_MinLength(             VECTOR   SegmentPos1, VECTOR   SegmentPos2, VECTOR   PointPos ) ;																					// Ɠ_̈ԋ߂𓾂
extern	double		Segment_Point_MinLengthD(            VECTOR_D SegmentPos1, VECTOR_D SegmentPos2, VECTOR_D PointPos ) ;																					// Ɠ_̈ԋ߂𓾂
extern	float 		Segment_Point_MinLength_Square(      VECTOR   SegmentPos1, VECTOR   SegmentPos2, VECTOR   PointPos ) ;																					// Ɠ_̈ԋ߂̓𓾂
extern	double		Segment_Point_MinLength_SquareD(     VECTOR_D SegmentPos1, VECTOR_D SegmentPos2, VECTOR_D PointPos ) ;																					// Ɠ_̈ԋ߂̓𓾂
extern	float 		Triangle_Point_MinLength(            VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3, VECTOR   PointPos ) ;															// Op`Ɠ_̈ԋ߂𓾂
extern	double		Triangle_Point_MinLengthD(           VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3, VECTOR_D PointPos ) ;															// Op`Ɠ_̈ԋ߂𓾂
extern	float 		Triangle_Point_MinLength_Square(     VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3, VECTOR   PointPos ) ;															// Op`Ɠ_̈ԋ߂̓𓾂
extern	double		Triangle_Point_MinLength_SquareD(    VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3, VECTOR_D PointPos ) ;															// Op`Ɠ_̈ԋ߂̓𓾂
extern	float 		Triangle_Triangle_MinLength(         VECTOR   Triangle1Pos1, VECTOR   Triangle1Pos2, VECTOR   Triangle1Pos3, VECTOR   Triangle2Pos1, VECTOR   Triangle2Pos2, VECTOR   Triangle2Pos3 ) ;	// ̎Op`̍ŋߓ_Ԃ̋𓾂
extern	double		Triangle_Triangle_MinLengthD(        VECTOR_D Triangle1Pos1, VECTOR_D Triangle1Pos2, VECTOR_D Triangle1Pos3, VECTOR_D Triangle2Pos1, VECTOR_D Triangle2Pos2, VECTOR_D Triangle2Pos3 ) ;	// ̎Op`̍ŋߓ_Ԃ̋𓾂
extern	float 		Triangle_Triangle_MinLength_Square(  VECTOR   Triangle1Pos1, VECTOR   Triangle1Pos2, VECTOR   Triangle1Pos3, VECTOR   Triangle2Pos1, VECTOR   Triangle2Pos2, VECTOR   Triangle2Pos3 ) ;	// ̎Op`̍ŋߓ_Ԃ̋̓𓾂
extern	double		Triangle_Triangle_MinLength_SquareD( VECTOR_D Triangle1Pos1, VECTOR_D Triangle1Pos2, VECTOR_D Triangle1Pos3, VECTOR_D Triangle2Pos1, VECTOR_D Triangle2Pos2, VECTOR_D Triangle2Pos3 ) ;	// ̎Op`̍ŋߓ_Ԃ̋̓𓾂
extern	VECTOR  	Plane_Point_MinLength_Position(      VECTOR   PlanePos, VECTOR   PlaneNormal, VECTOR   PointPos ) ;																						// _Ɉԋ߂ʏ̍W𓾂
extern	VECTOR_D	Plane_Point_MinLength_PositionD(     VECTOR_D PlanePos, VECTOR_D PlaneNormal, VECTOR_D PointPos ) ;																						// _Ɉԋ߂ʏ̍W𓾂
extern	float 		Plane_Point_MinLength(               VECTOR   PlanePos, VECTOR   PlaneNormal, VECTOR   PointPos ) ;																						// ʂƓ_̈ԋ߂𓾂
extern	double		Plane_Point_MinLengthD(              VECTOR_D PlanePos, VECTOR_D PlaneNormal, VECTOR_D PointPos ) ;																						// ʂƓ_̈ԋ߂𓾂

extern	HITRESULT_LINE   HitCheck_Line_Triangle(         VECTOR   LinePos1, VECTOR   LinePos2, VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3 ) ;										// Op`Ɛ̓蔻
extern	HITRESULT_LINE_D HitCheck_Line_TriangleD(        VECTOR_D LinePos1, VECTOR_D LinePos2, VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3 ) ;										// Op`Ɛ̓蔻
extern	int			HitCheck_Triangle_Triangle(          VECTOR   Triangle1Pos1, VECTOR   Triangle1Pos2, VECTOR   Triangle1Pos3, VECTOR   Triangle2Pos1, VECTOR   Triangle2Pos2, VECTOR   Triangle2Pos3 ) ;	// Op`ƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Triangle_TriangleD(         VECTOR_D Triangle1Pos1, VECTOR_D Triangle1Pos2, VECTOR_D Triangle1Pos3, VECTOR_D Triangle2Pos1, VECTOR_D Triangle2Pos2, VECTOR_D Triangle2Pos3 ) ;	// Op`ƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Triangle_Triangle_2D(       VECTOR   Triangle1Pos1, VECTOR   Triangle1Pos2, VECTOR   Triangle1Pos3, VECTOR   Triangle2Pos1, VECTOR   Triangle2Pos2, VECTOR   Triangle2Pos3 ) ;	// Op`ƎOp`̓蔻( Qc )( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Triangle_TriangleD_2D(      VECTOR_D Triangle1Pos1, VECTOR_D Triangle1Pos2, VECTOR_D Triangle1Pos3, VECTOR_D Triangle2Pos1, VECTOR_D Triangle2Pos2, VECTOR_D Triangle2Pos3 ) ;	// Op`ƎOp`̓蔻( Qc )( TRUE:Ă  FALSE:ĂȂ )
extern	HITRESULT_LINE   HitCheck_Line_Cube(             VECTOR   LinePos1, VECTOR   LinePos2, VECTOR   CubePos1, VECTOR   CubePos2 );																		// Ɣ̓蔻
extern	HITRESULT_LINE_D HitCheck_Line_CubeD(            VECTOR_D LinePos1, VECTOR_D LinePos2, VECTOR_D CubePos1, VECTOR_D CubePos2 );																		// Ɣ̓蔻
extern	int			HitCheck_Point_Cone(                 VECTOR   PointPos, VECTOR   ConeTopPos, VECTOR   ConeBottomPos, float  ConeR ) ;																	// _Ɖ~̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Point_ConeD(                VECTOR_D PointPos, VECTOR_D ConeTopPos, VECTOR_D ConeBottomPos, double ConeR ) ;																	// _Ɖ~̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Line_Sphere(                VECTOR   LinePos1, VECTOR   LinePos2, VECTOR   SphereCenterPos, float  SphereR ) ;																	// Ƌ̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Line_SphereD(               VECTOR_D LinePos1, VECTOR_D LinePos2, VECTOR_D SphereCenterPos, double SphereR ) ;																	// Ƌ̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Sphere_Sphere(              VECTOR   Sphere1CenterPos, float  Sphere1R, VECTOR   Sphere2CenterPos, float  Sphere2R ) ;															// Ƌ̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Sphere_SphereD(             VECTOR_D Sphere1CenterPos, double Sphere1R, VECTOR_D Sphere2CenterPos, double Sphere2R ) ;															// Ƌ̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Sphere_Capsule(             VECTOR   SphereCenterPos, float  SphereR, VECTOR   CapPos1, VECTOR   CapPos2, float  CapR ) ;														// ƃJvZ̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Sphere_CapsuleD(            VECTOR_D SphereCenterPos, double SphereR, VECTOR_D CapPos1, VECTOR_D CapPos2, double CapR ) ;														// ƃJvZ̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Sphere_Triangle(            VECTOR   SphereCenterPos, float  SphereR, VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3 ) ;									// ƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Sphere_TriangleD(           VECTOR_D SphereCenterPos, double SphereR, VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3 ) ;									// ƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Capsule_Capsule(            VECTOR   Cap1Pos1, VECTOR   Cap1Pos2, float  Cap1R, VECTOR   Cap2Pos1, VECTOR   Cap2Pos2, float  Cap2R ) ;											// JvZm̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Capsule_CapsuleD(           VECTOR_D Cap1Pos1, VECTOR_D Cap1Pos2, double Cap1R, VECTOR_D Cap2Pos1, VECTOR_D Cap2Pos2, double Cap2R ) ;											// JvZm̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Capsule_Triangle(           VECTOR   CapPos1, VECTOR   CapPos2, float  CapR, VECTOR   TrianglePos1, VECTOR   TrianglePos2, VECTOR   TrianglePos3 ) ;							// JvZƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ )
extern	int			HitCheck_Capsule_TriangleD(          VECTOR_D CapPos1, VECTOR_D CapPos2, double CapR, VECTOR_D TrianglePos1, VECTOR_D TrianglePos2, VECTOR_D TrianglePos3 ) ;							// JvZƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ )

// ̑
extern	int			RectClipping( RECT *Rect, const RECT *ClippuRect ) ;									// `̃NbsO
extern	int			RectAdjust(   RECT *Rect ) ;															// ` left  right l傫ꍇȂǂ̌␳
extern	int			GetRectSize(  const RECT *Rect, int *Width, int *Height ) ;								// `̕ƍ߂

// \Lȗ
extern	MATRIX		MGetIdent(          void ) ;															// Pʍs擾
extern	MATRIX_D	MGetIdentD(         void ) ;															// Pʍs擾
extern	MATRIX		MMult(              MATRIX   In1, MATRIX   In2 ) ;										// s̏Zs
extern	MATRIX_D	MMultD(             MATRIX_D In1, MATRIX_D In2 ) ;										// s̏Zs
extern	MATRIX		MScale(             MATRIX   InM, float  Scale ) ;										// s̃XP[Os
extern	MATRIX_D	MScaleD(            MATRIX_D InM, double Scale ) ;										// s̃XP[Os
extern	MATRIX		MAdd(               MATRIX   In1, MATRIX   In2 ) ;										// s̑Zs
extern	MATRIX_D	MAddD(              MATRIX_D In1, MATRIX_D In2 ) ;										// s̑Zs
extern	MATRIX		MGetScale(          VECTOR   Scale ) ;													// gs擾
extern	MATRIX_D	MGetScaleD(         VECTOR_D Scale ) ;													// gs擾
extern	MATRIX		MGetRotX(           float  XAxisRotate ) ;												// w]s擾
extern	MATRIX_D	MGetRotXD(          double XAxisRotate ) ;												// w]s擾
extern	MATRIX		MGetRotY(           float  YAxisRotate ) ;												// x]s擾
extern	MATRIX_D	MGetRotYD(          double YAxisRotate ) ;												// x]s擾
extern	MATRIX		MGetRotZ(           float  ZAxisRotate ) ;												// y]s擾
extern	MATRIX_D	MGetRotZD(          double ZAxisRotate ) ;												// y]s擾
extern	MATRIX		MGetRotAxis(        VECTOR   RotateAxis, float  Rotate ) ;								// w莲Ŏwpx]s擾
extern	MATRIX_D	MGetRotAxisD(       VECTOR_D RotateAxis, double Rotate ) ;								// w莲Ŏwpx]s擾
extern	MATRIX		MGetRotVec2(        VECTOR   In1, VECTOR   In2 ) ;										// In1 ̌ In2 ̌֕ϊ]s擾( In2  In1 ^t̃xNg̏ꍇ͉]͕s )
extern	MATRIX_D	MGetRotVec2D(       VECTOR_D In1, VECTOR_D In2 ) ;										// In1 ̌ In2 ̌֕ϊ]s擾( In2  In1 ^t̃xNg̏ꍇ͉]͕s )
extern	MATRIX		MGetTranslate(      VECTOR   Trans ) ;													// sړs擾
extern	MATRIX_D	MGetTranslateD(     VECTOR_D Trans ) ;													// sړs擾
extern	MATRIX		MGetAxis1(          VECTOR   XAxis, VECTOR   YAxis, VECTOR   ZAxis, VECTOR   Pos ) ;	// ŵR[J̃xNg{̃xNgɕϊs擾( x' = XAxis.x * x + YAixs.x * y + ZAxis.z * z + Pos.x   y' = XAxis.y * x + YAixs.y * y + ZAxis.y * z + Pos.y      z' = XAxis.z * x + YAixs.z * y + ZAxis.z * z + Pos.z )
extern	MATRIX_D	MGetAxis1D(         VECTOR_D XAxis, VECTOR_D YAxis, VECTOR_D ZAxis, VECTOR_D Pos ) ;	// ŵR[J̃xNg{̃xNgɕϊs擾( x' = XAxis.x * x + YAixs.x * y + ZAxis.z * z + Pos.x   y' = XAxis.y * x + YAixs.y * y + ZAxis.y * z + Pos.y      z' = XAxis.z * x + YAixs.z * y + ZAxis.z * z + Pos.z )
extern	MATRIX		MGetAxis2(          VECTOR   XAxis, VECTOR   YAxis, VECTOR   ZAxis, VECTOR   Pos ) ;	// {̃xNgŵRɓexNgɕϊs擾( x' = XAxis.x * ( x - Pos.x ) + XAxis.y * ( x - Pos.x ) + XAxis.z * ( x - Pos.x )    y' = YAxis.x * ( x - Pos.x ) + YAxis.y * ( x - Pos.x ) + YAxis.z * ( x - Pos.x )    z' = ZAxis.x * ( x - Pos.x ) + ZAxis.y * ( x - Pos.x ) + ZAxis.z * ( x - Pos.x ) )
extern	MATRIX_D	MGetAxis2D(         VECTOR_D XAxis, VECTOR_D YAxis, VECTOR_D ZAxis, VECTOR_D Pos ) ;	// {̃xNgŵRɓexNgɕϊs擾( x' = XAxis.x * ( x - Pos.x ) + XAxis.y * ( x - Pos.x ) + XAxis.z * ( x - Pos.x )    y' = YAxis.x * ( x - Pos.x ) + YAxis.y * ( x - Pos.x ) + YAxis.z * ( x - Pos.x )    z' = ZAxis.x * ( x - Pos.x ) + ZAxis.y * ( x - Pos.x ) + ZAxis.z * ( x - Pos.x ) )
extern	MATRIX		MTranspose(         MATRIX   InM ) ;													// ]us擾
extern	MATRIX_D	MTransposeD(        MATRIX_D InM ) ;													// ]us擾
extern	MATRIX		MInverse(           MATRIX   InM ) ;													// ts擾
extern	MATRIX_D	MInverseD(          MATRIX_D InM ) ;													// ts擾
extern  VECTOR		MGetSize(           MATRIX   InM ) ;													// gŝwAxAẙg嗦擾
extern  VECTOR_D	MGetSizeD(          MATRIX_D InM ) ;													// gŝwAxAẙg嗦擾
extern	MATRIX		MGetRotElem(        MATRIX   InM ) ;													// s̉]擾
extern	MATRIX_D	MGetRotElemD(       MATRIX_D InM ) ;													// s̉]擾

#ifdef __cplusplus

// s̕sړ擾
__inline VECTOR MGetTranslateElem( MATRIX &InM )
{
	VECTOR Result ;

	Result.x = InM.m[ 3 ][ 0 ] ;
	Result.y = InM.m[ 3 ][ 1 ] ;
	Result.z = InM.m[ 3 ][ 2 ] ;

	return Result ;
}

// s̕sړ擾
__inline VECTOR_D MGetTranslateElemD( MATRIX_D &InM )
{
	VECTOR_D Result ;

	Result.x = InM.m[ 3 ][ 0 ] ;
	Result.y = InM.m[ 3 ][ 1 ] ;
	Result.z = InM.m[ 3 ][ 2 ] ;

	return Result ;
}

// xNgl̕ϊ
__inline VECTOR_D VConvFtoD( const VECTOR &In )
{
	VECTOR_D Result ;

	Result.x = In.x ;
	Result.y = In.y ;
	Result.z = In.z ;

	return Result ;
}

__inline VECTOR VConvDtoF( const VECTOR_D &In )
{
	VECTOR Result ;

	Result.x = ( float )In.x ;
	Result.y = ( float )In.y ;
	Result.z = ( float )In.z ;

	return Result ;
}

#endif // __cplusplus

// xNgl̐
__inline VECTOR VGet( float x, float y, float z )
{
	VECTOR Result;
	Result.x = x ;
	Result.y = y ;
	Result.z = z ;
	return Result ;
}

__inline VECTOR_D VGetD( double x, double y, double z )
{
	VECTOR_D Result;
	Result.x = x ;
	Result.y = y ;
	Result.z = z ;
	return Result ;
}

__inline FLOAT2 F2Get( float u, float v )
{
	FLOAT2 Result;
	Result.u = u ;
	Result.v = v ;
	return Result ;
}

// SvfxNgl̐
__inline FLOAT4 F4Get( float x, float y, float z, float w )
{
	FLOAT4 Result;
	Result.x = x ;
	Result.y = y ;
	Result.z = z ;
	Result.w = w ;
	return Result ;
}

__inline DOUBLE4 D4Get( double x, double y, double z, double w )
{
	DOUBLE4 Result;
	Result.x = x ;
	Result.y = y ;
	Result.z = z ;
	Result.w = w ;
	return Result ;
}

#ifdef __cplusplus

// xNg̉Z
__inline VECTOR		VAdd( const VECTOR &In1, const VECTOR &In2 )
{
	VECTOR Result ;
	Result.x = In1.x + In2.x ;
	Result.y = In1.y + In2.y ;
	Result.z = In1.z + In2.z ;
	return Result ;
}

__inline VECTOR_D	VAddD( const VECTOR_D &In1, const VECTOR_D &In2 )
{
	VECTOR_D Result ;
	Result.x = In1.x + In2.x ;
	Result.y = In1.y + In2.y ;
	Result.z = In1.z + In2.z ;
	return Result ;
}

// xNǧZ
__inline VECTOR		VSub( const VECTOR &In1, const VECTOR &In2 )
{
	VECTOR Result ;
	Result.x = In1.x - In2.x ;
	Result.y = In1.y - In2.y ;
	Result.z = In1.z - In2.z ;
	return Result ;
}

__inline VECTOR_D	VSubD( const VECTOR_D &In1, const VECTOR_D &In2 )
{
	VECTOR_D Result ;
	Result.x = In1.x - In2.x ;
	Result.y = In1.y - In2.y ;
	Result.z = In1.z - In2.z ;
	return Result ;
}

__inline FLOAT2		F2Add( const FLOAT2 &In1, const FLOAT2 &In2 )
{
	FLOAT2 Result ;
	Result.u = In1.u + In2.u ;
	Result.v = In1.v + In2.v ;
	return Result ;
}

// SvfxNg̉Z
__inline FLOAT4		F4Add( const FLOAT4 &In1, const FLOAT4 &In2 )
{
	FLOAT4 Result ;
	Result.x = In1.x + In2.x ;
	Result.y = In1.y + In2.y ;
	Result.z = In1.z + In2.z ;
	Result.w = In1.w + In2.w ;
	return Result ;
}

__inline DOUBLE4	D4Add( const DOUBLE4 &In1, const DOUBLE4 &In2 )
{
	DOUBLE4 Result ;
	Result.x = In1.x + In2.x ;
	Result.y = In1.y + In2.y ;
	Result.z = In1.z + In2.z ;
	Result.w = In1.w + In2.w ;
	return Result ;
}

__inline FLOAT2		F2Sub( const FLOAT2 &In1, const FLOAT2 &In2 )
{
	FLOAT2 Result ;
	Result.u = In1.u - In2.u ;
	Result.v = In1.v - In2.v ;
	return Result ;
}

// SvfxNǧZ
__inline FLOAT4		F4Sub( const FLOAT4 &In1, const FLOAT4 &In2 )
{
	FLOAT4 Result ;
	Result.x = In1.x - In2.x ;
	Result.y = In1.y - In2.y ;
	Result.z = In1.z - In2.z ;
	Result.w = In1.w - In2.w ;
	return Result ;
}

__inline DOUBLE4	D4Sub( const DOUBLE4 &In1, const DOUBLE4 &In2 )
{
	DOUBLE4 Result ;
	Result.x = In1.x - In2.x ;
	Result.y = In1.y - In2.y ;
	Result.z = In1.z - In2.z ;
	Result.w = In1.w - In2.w ;
	return Result ;
}

// xNg̓
__inline float		VDot( const VECTOR &In1, const VECTOR &In2 )
{
	return In1.x * In2.x + In1.y * In2.y + In1.z * In2.z ;
}

__inline double		VDotD( const VECTOR_D &In1, const VECTOR_D &In2 )
{
	return In1.x * In2.x + In1.y * In2.y + In1.z * In2.z ;
}

// xNg̊O
__inline VECTOR		VCross( const VECTOR &In1, const VECTOR &In2 )
{
	VECTOR Result ;
	Result.x = In1.y * In2.z - In1.z * In2.y ;
	Result.y = In1.z * In2.x - In1.x * In2.z ;
	Result.z = In1.x * In2.y - In1.y * In2.x ;
	return Result ;
}

__inline VECTOR_D	VCrossD( const VECTOR_D &In1, const VECTOR_D &In2 )
{
	VECTOR_D Result ;
	Result.x = In1.y * In2.z - In1.z * In2.y ;
	Result.y = In1.z * In2.x - In1.x * In2.z ;
	Result.z = In1.x * In2.y - In1.y * In2.x ;
	return Result ;
}

// xNg̃XP[O
__inline VECTOR		VScale( const VECTOR &In, float Scale )
{
	VECTOR Result ;
	Result.x = In.x * Scale ;
	Result.y = In.y * Scale ;
	Result.z = In.z * Scale ;
	return Result ;
}

__inline VECTOR_D	VScaleD( const VECTOR_D &In, double Scale )
{
	VECTOR_D Result ;
	Result.x = In.x * Scale ;
	Result.y = In.y * Scale ;
	Result.z = In.z * Scale ;
	return Result ;
}

__inline FLOAT2		F2Scale( const FLOAT2 &In, float Scale )
{
	FLOAT2 Result ;
	Result.u = In.u * Scale ;
	Result.v = In.v * Scale ;
	return Result ;
}

// SvfxNg̃XP[O
__inline FLOAT4		F4Scale( const FLOAT4 &In, float Scale )
{
	FLOAT4 Result ;
	Result.x = In.x * Scale ;
	Result.y = In.y * Scale ;
	Result.z = In.z * Scale ;
	Result.w = In.w * Scale ;
	return Result ;
}

__inline DOUBLE4	D4Scale( const DOUBLE4 &In, double Scale )
{
	DOUBLE4 Result ;
	Result.x = In.x * Scale ;
	Result.y = In.y * Scale ;
	Result.z = In.z * Scale ;
	Result.w = In.w * Scale ;
	return Result ;
}

#endif // __cplusplus

// xNg̐K
extern VECTOR		VNorm(  VECTOR   In ) ;
extern VECTOR_D		VNormD( VECTOR_D In ) ;

// xNg̃TCY
extern float		VSize(  VECTOR   In ) ;
extern double		VSizeD( VECTOR_D In ) ;

#ifdef __cplusplus

// xNg̃TCŶQ
__inline float		VSquareSize(  const VECTOR   &In )
{
	return In.x * In.x + In.y * In.y + In.z * In.z ;
}

__inline double		VSquareSizeD( const VECTOR_D &In )
{
	return In.x * In.x + In.y * In.y + In.z * In.z ;
}

// sgWϊ
__inline VECTOR		VTransform( const VECTOR &InV, const MATRIX &InM )
{
	VECTOR Result ;
	Result.x = InV.x * InM.m[0][0] + InV.y * InM.m[1][0] + InV.z * InM.m[2][0] + InM.m[3][0] ;
	Result.y = InV.x * InM.m[0][1] + InV.y * InM.m[1][1] + InV.z * InM.m[2][1] + InM.m[3][1] ;
	Result.z = InV.x * InM.m[0][2] + InV.y * InM.m[1][2] + InV.z * InM.m[2][2] + InM.m[3][2] ;
	return Result ;
}

__inline VECTOR_D	VTransformD( const VECTOR_D &InV, const MATRIX_D &InM )
{
	VECTOR_D Result ;
	Result.x = InV.x * InM.m[0][0] + InV.y * InM.m[1][0] + InV.z * InM.m[2][0] + InM.m[3][0] ;
	Result.y = InV.x * InM.m[0][1] + InV.y * InM.m[1][1] + InV.z * InM.m[2][1] + InM.m[3][1] ;
	Result.z = InV.x * InM.m[0][2] + InV.y * InM.m[1][2] + InV.z * InM.m[2][2] + InM.m[3][2] ;
	return Result ;
}

// sgWϊ( XP[O{]̂ )
__inline VECTOR		VTransformSR( const VECTOR &InV, const MATRIX &InM )
{
	VECTOR Result ;
	Result.x = InV.x * InM.m[0][0] + InV.y * InM.m[1][0] + InV.z * InM.m[2][0] ;
	Result.y = InV.x * InM.m[0][1] + InV.y * InM.m[1][1] + InV.z * InM.m[2][1] ;
	Result.z = InV.x * InM.m[0][2] + InV.y * InM.m[1][2] + InV.z * InM.m[2][2] ;
	return Result ;
}

__inline VECTOR_D	VTransformSRD( const VECTOR_D &InV, const MATRIX_D &InM )
{
	VECTOR_D Result ;
	Result.x = InV.x * InM.m[0][0] + InV.y * InM.m[1][0] + InV.z * InM.m[2][0] ;
	Result.y = InV.x * InM.m[0][1] + InV.y * InM.m[1][1] + InV.z * InM.m[2][1] ;
	Result.z = InV.x * InM.m[0][2] + InV.y * InM.m[1][2] + InV.z * InM.m[2][2] ;
	return Result ;
}

#endif // __cplusplus

// ̃xNgp̃RTCl𓾂
extern	float		VCos(  VECTOR   In1, VECTOR   In2 ) ;
extern	double		VCosD( VECTOR_D In1, VECTOR_D In2 ) ;

// ̃xNgp̊px𓾂( PʁFWA )
extern	float		VRad(  VECTOR   In1, VECTOR   In2 ) ;
extern	double		VRadD( VECTOR_D In1, VECTOR_D In2 ) ;


#ifdef __cplusplus

// 2̃NH[^jȈŽʂԂ
__inline FLOAT4 QTCross( const FLOAT4 &A, const FLOAT4 &B )
{
    FLOAT4 Result ;
    Result.w = A.w * B.w - ( A.x * B.x + A.y * B.y + A.z * B.z ) ;
	Result.x = B.x * A.w + A.x * B.w + ( A.y * B.z - A.z * B.y ) ;
	Result.y = B.y * A.w + A.y * B.w + ( A.z * B.x - A.x * B.z ) ;
	Result.z = B.z * A.w + A.z * B.w + ( A.x * B.y - A.y * B.x ) ;
    return Result ;
}
__inline DOUBLE4 QTCrossD( const DOUBLE4 &A, const DOUBLE4 &B )
{
    DOUBLE4 Result ;
    Result.w = A.w * B.w - ( A.x * B.x + A.y * B.y + A.z * B.z ) ;
	Result.x = B.x * A.w + A.x * B.w + ( A.y * B.z - A.z * B.y ) ;
	Result.y = B.y * A.w + A.y * B.w + ( A.z * B.x - A.x * B.z ) ;
	Result.z = B.z * A.w + A.z * B.w + ( A.x * B.y - A.y * B.x ) ;
    return Result ;
}

// NH[^jIԂ
__inline FLOAT4 QTConj( const FLOAT4 &A )
{
	FLOAT4 Result ;
	Result.w =  A.w ;
	Result.x = -A.x ;
	Result.y = -A.y ;
	Result.z = -A.z ;
	return Result ;
}
__inline DOUBLE4 QTConjD( const DOUBLE4 &A )
{
	DOUBLE4 Result ;
	Result.w =  A.w ;
	Result.x = -A.x ;
	Result.y = -A.y ;
	Result.z = -A.z ;
	return Result ;
}

#endif // __cplusplus

// ]\NH[^jIԂ
extern FLOAT4  QTRot(  VECTOR   Axis, float  Angle ) ;
extern DOUBLE4 QTRotD( VECTOR_D Axis, double Angle ) ;

// 3ԏ̓_Cӂ̎̎ɔCӂ̊px]֐
extern VECTOR   VRotQ(  VECTOR   P, VECTOR   Axis, float  Angle ) ;
extern VECTOR_D VRotQD( VECTOR_D P, VECTOR_D Axis, double Angle ) ;










// DxBaseImage.cpp ֐vg^Cv錾

// {C[Wf[^̃[h{cha֌W
extern	int			CreateGraphImageOrDIBGraph(            const TCHAR *FileName,                        const void *DataImage, int DataImageSize, int DataImageType /* LOADIMAGE_TYPE_FILE  */ , int BmpFlag, int ReverseFlag, BASEIMAGE *BaseImage, BITMAPINFO **BmpInfo, void **GraphData ) ;					// 摜t@CႵ̓ɓWJꂽ摜t@CC[Wǂݍ݁A{C[Wf[^Ⴕ͂alof[^\z
extern	int			CreateGraphImageOrDIBGraphWithStrLen(  const TCHAR *FileName, size_t FileNameLength, const void *DataImage, int DataImageSize, int DataImageType /* LOADIMAGE_TYPE_FILE  */ , int BmpFlag, int ReverseFlag, BASEIMAGE *BaseImage, BITMAPINFO **BmpInfo, void **GraphData ) ;					// 摜t@CႵ̓ɓWJꂽ摜t@CC[Wǂݍ݁A{C[Wf[^Ⴕ͂alof[^\z
extern	int			CreateGraphImageType2(                 STREAMDATA *Src, BASEIMAGE *Dest ) ;																																																						// 摜f[^\zXg[ǂݍݗpf[^gpĊ{C[Wf[^\z
extern	int			CreateBmpInfo(                         BITMAPINFO *BmpInfo, int Width, int Height, int Pitch, const void *SrcGrData, void **DestGrData ) ;																																						// 24bitJ[`̃rbg}bvf[^alof[^\z
extern	int			GetImageSize_File(                     const TCHAR *FileName,                        int *SizeX, int *SizeY ) ;																																													// 摜t@C̉sNZƏcsNZ擾
extern	int			GetImageSize_FileWithStrLen(           const TCHAR *FileName, size_t FileNameLength, int *SizeX, int *SizeY ) ;																																													// 摜t@C̉sNZƏcsNZ擾
extern	int			GetImageSize_Mem(                      const void *FileImage, int FileImageSize, int *SizeX, int *SizeY ) ;																																														// ɓWJꂽ摜t@C̉sNZƏcsNZ擾
extern	unsigned int GetGraphImageFullColorCode(           const BASEIMAGE *GraphImage, int x, int y ) ;																																																			// {C[Wf[^̎wW̃tJ[R[h擾
extern	int			CreateGraphImage_plus_Alpha(           const TCHAR *FileName,                        const void *RgbImage, int RgbImageSize, int RgbImageType, const void *AlphaImage, int AlphaImageSize, int AlphaImageType, BASEIMAGE *RgbGraphImage, BASEIMAGE *AlphaGraphImage, int ReverseFlag ) ;		// 摜t@CႵ̓ɓWJꂽ摜t@CC[Wǂݍ݁A{C[Wf[^\z
extern	int			CreateGraphImage_plus_AlphaWithStrLen( const TCHAR *FileName, size_t FileNameLength, const void *RgbImage, int RgbImageSize, int RgbImageType, const void *AlphaImage, int AlphaImageSize, int AlphaImageType, BASEIMAGE *RgbGraphImage, BASEIMAGE *AlphaGraphImage, int ReverseFlag ) ;		// 摜t@CႵ̓ɓWJꂽ摜t@CC[Wǂݍ݁A{C[Wf[^\z
extern	int			ReverseGraphImage(                     BASEIMAGE *GraphImage ) ;																																																								// {C[Wf[^E]

//extern int		AddUserGraphLoadFunction( int ( *UserLoadFunc )( FILE *fp, BITMAPINFO **BmpInfo, void **GraphData ) ) ;																						// [U[`̉摜f[^ǂݍ݊֐o^
//extern int		AddUserGraphLoadFunction2( int ( *UserLoadFunc )( void *Image, int ImageSize, int ImageType, BITMAPINFO **BmpInfo, void **GraphData ) ) ;													// [U[`̉摜f[^ǂݍ݊֐o^
//extern int		AddUserGraphLoadFunction3( int ( *UserLoadFunc )( void *DataImage, int DataImageSize, int DataImageType, int BmpFlag, BASEIMAGE *BaseImage, BITMAPINFO **BmpInfo, void **GraphData ) ) ;	// [U[`̉摜f[^ǂݍ݊֐Ver3o^
extern	int			AddUserGraphLoadFunction4( int (* UserLoadFunc )( STREAMDATA *Src, BASEIMAGE *BaseImage ) ) ; 																								// [U[`̉摜f[^ǂݍ݊֐Ver4o^
//extern int		SubUserGraphLoadFunction( int ( *UserLoadFunc )( FILE *fp, BITMAPINFO **BmpInfo, void **GraphData ) ) ;																						// [U[`̉摜f[^ǂݍ݊֐o^疕
//extern int		SubUserGraphLoadFunction2( int ( *UserLoadFunc )( void *Image, int ImageSize, int ImageType, BITMAPINFO **BmpInfo, void **GraphData ) ) ;													// [U[`̉摜f[^ǂݍ݊֐o^疕
//extern int		SubUserGraphLoadFunction3( int ( *UserLoadFunc )( void *DataImage, int DataImageSize, int DataImageType, int BmpFlag, BASEIMAGE *BaseImage, BITMAPINFO **BmpInfo, void **GraphData ) ) ;	// [U[`̉摜f[^ǂݍ݊֐Ver3o^疕
extern	int			SubUserGraphLoadFunction4( int (* UserLoadFunc )( STREAMDATA *Src, BASEIMAGE *BaseImage ) ) ; 																								// [U[`̉摜f[^ǂݍ݊֐Ver4o^疕

extern	int			SetUseFastLoadFlag(              int Flag ) ;														// ǂݍ݃[`gp邩ǂݒ肷( TRUE:gp( ftHg )  FALSE:gpȂ )
extern	int			SetGraphDataShavedMode(          int ShavedMode /* DX_SHAVEDMODE_NONE  */ ) ;						// 摜F̉摜򉻊ɘa[hݒ肷( ftHgł͊ɘa DX_SHAVEDMODE_NONE )
extern	int			GetGraphDataShavedMode(          void ) ;															// 摜F̉摜򉻊ɘa[h擾
extern	int			SetUsePremulAlphaConvertLoad(    int UseFlag ) ;													// 摜t@CǂݍݎɏZς݃At@摜ɕϊ邩ǂݒ肷( TRUE:ϊs  FALSE:ϊsȂ( ftHg ) )
extern	int			GetUsePremulAlphaConvertLoad(    void ) ;															// 摜t@CǂݍݎɏZς݃At@摜ɕϊ邩ǂ擾( TRUE:ϊs  FALSE:ϊsȂ( ftHg ) )
extern	int			SetUseConvertNormalFormatLoad(   int UseFlag ) ;													// 摜t@Cǂݍݎ DX_BASEIMAGE_FORMAT_NORMAL ȊǑ`̃C[W DX_BASEIMAGE_FORMAT_NORMAL `̃C[Wɕϊ邩ǂݒ肷( TRUE:ϊs  FALSE:ϊsȂȂ( ftHg ) )
extern	int			GetUseConvertNormalFormatLoad(   void ) ;															// 摜t@Cǂݍݎ DX_BASEIMAGE_FORMAT_NORMAL ȊǑ`̃C[W DX_BASEIMAGE_FORMAT_NORMAL `̃C[Wɕϊ邩ǂ擾( TRUE:ϊs  FALSE:ϊsȂȂ( ftHg ) )

// {C[Wf[^\̊֌W
extern	int			CreateBaseImage(                 const TCHAR *FileName,                        const void *FileImage, int FileImageSize, int DataType /*=LOADIMAGE_TYPE_FILE*/ , BASEIMAGE *BaseImage,  int ReverseFlag ) ;			// 摜t@CႵ̓ɓWJꂽ摜t@CC[W{C[Wf[^\z
extern	int			CreateBaseImageWithStrLen(       const TCHAR *FileName, size_t FileNameLength, const void *FileImage, int FileImageSize, int DataType /*=LOADIMAGE_TYPE_FILE*/ , BASEIMAGE *BaseImage,  int ReverseFlag ) ;			// 摜t@CႵ̓ɓWJꂽ摜t@CC[W{C[Wf[^\z
extern	int			CreateGraphImage(                const TCHAR *FileName,                        const void *DataImage, int DataImageSize, int DataImageType,                      BASEIMAGE *GraphImage, int ReverseFlag ) ;			// CreateBaseImage ̋
extern	int			CreateBaseImageToFile(           const TCHAR *FileName,                                                                                                          BASEIMAGE *BaseImage,  int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜t@C{C[Wf[^\z
extern	int			CreateBaseImageToFileWithStrLen( const TCHAR *FileName, size_t FileNameLength,                                                                                   BASEIMAGE *BaseImage,  int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;	// 摜t@C{C[Wf[^\z
extern	int			CreateBaseImageToMem(                                                          const void *FileImage, int FileImageSize,                                         BASEIMAGE *BaseImage,  int ReverseFlag DEFAULTPARAM( = FALSE ) ) ;	// ɓWJꂽ摜t@CC[W{C[Wf[^\z
extern	int			CreateARGBF32ColorBaseImage(     int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// `qfae`l 32bit _^ J[̊{C[Wf[^쐬
extern	int			CreateARGBF16ColorBaseImage(     int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// `qfae`l 16bit _^ J[̊{C[Wf[^쐬
extern	int			CreateXRGB8ColorBaseImage(       int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// wqfaWJ[̊{C[Wf[^쐬
extern	int			CreateARGB8ColorBaseImage(       int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// `qfaWJ[̊{C[Wf[^쐬
extern	int			CreateRGBA8ColorBaseImage(       int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// qfa`WJ[̊{C[Wf[^쐬
extern	int			CreateABGR8ColorBaseImage(       int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// `afqWJ[̊{C[Wf[^쐬
extern	int			CreateBGRA8ColorBaseImage(       int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// afq`WJ[̊{C[Wf[^쐬
extern	int			CreateARGB4ColorBaseImage(       int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// `qfaSJ[̊{C[Wf[^쐬
extern	int			CreateA1R5G5B5ColorBaseImage(    int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// `PqTfTaTJ[̊{C[Wf[^쐬
extern	int			CreateX1R5G5B5ColorBaseImage(    int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// wPqTfTaTJ[̊{C[Wf[^쐬
extern	int			CreateR5G5B5A1ColorBaseImage(    int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// qTfTaT`PJ[̊{C[Wf[^쐬
extern	int			CreateR5G6B5ColorBaseImage(      int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// qTfUaTJ[̊{C[Wf[^쐬
extern	int			CreateRGB8ColorBaseImage(        int SizeX, int SizeY,                             BASEIMAGE *BaseImage ) ;																							// qfaWJ[̊{C[Wf[^쐬
extern	int			CreatePAL8ColorBaseImage(        int SizeX, int SizeY,                             BASEIMAGE *BaseImage, int UseAlpha DEFAULTPARAM( = FALSE ) ) ;													// pbgWrbgJ[̊{C[Wf[^쐬
extern	int			CreateColorDataBaseImage(        int SizeX, int SizeY, const COLORDATA *ColorData, BASEIMAGE *BaseImage ) ;																							// w̃J[tH[}bg̊{C[Wf[^쐬
extern	int			GetBaseImageGraphDataSize(       const BASEIMAGE *BaseImage ) ;																																		// {C[Wf[^̃C[WTCY擾( PʁFbyte )
extern	int			DerivationBaseImage(             const BASEIMAGE *BaseImage, int x1, int y1, int x2, int y2, BASEIMAGE *NewBaseImage ) ;																			// {C[Wf[^̎w̕g{C[Wf[^̏쐬( BaseImage ɂ̓tH[}bg DX_BASEIMAGE_FORMAT_NORMAL Ń~bv}bvgpĂȂ摜̂ݎgp\ )

extern	int			ReleaseBaseImage(                BASEIMAGE *BaseImage ) ;																																			// {C[Wf[^̌ns
extern	int			ReleaseGraphImage(               BASEIMAGE *GraphImage ) ;																																			// ReleaseBaseImage ̋

extern	int			ConvertNormalFormatBaseImage(    BASEIMAGE *BaseImage, int ReleaseOrigGraphData DEFAULTPARAM( = TRUE ) ) ;																							// DX_BASEIMAGE_FORMAT_NORMAL ȊǑ`̃C[W DX_BASEIMAGE_FORMAT_NORMAL `̃C[Wɕϊ
extern	int			ConvertPremulAlphaBaseImage(     BASEIMAGE *BaseImage ) ;																																			// ʏ̃`lt摜Zς݃`lt摜ɕϊ( sNZtH[}bg ARGB8 ȊȌꍇ ARGB8 ɕϊ܂ )
extern	int			ConvertInterpAlphaBaseImage(     BASEIMAGE *BaseImage ) ;																																			// Zς݃`lt摜ʏ̃`lt摜ɕϊ( sNZtH[}bg ARGB8 ȊȌꍇ ARGB8 ɕϊ܂ )

extern	int			GetDrawScreenBaseImage(          int x1, int y1, int x2, int y2, BASEIMAGE *BaseImage ) ;																											// `Ώۂ̉ʂẅ{C[Wf[^ɓ]
extern	int			GetDrawScreenBaseImageDestPos(   int x1, int y1, int x2, int y2, BASEIMAGE *BaseImage, int DestX, int DestY ) ;																						// `Ώۂ̉ʂẅ{C[Wf[^ɓ]( ]Ww )
extern	int			FillBaseImage(                         BASEIMAGE *BaseImage, int r, int g, int b, int a ) ;																											// {C[Wf[^w̐FœhԂ
extern	int			FillRectBaseImage(                     BASEIMAGE *BaseImage, int x, int y, int w, int h, int r, int g, int b, int a ) ;																				// {C[Wf[^̎ẅ̗w̐FœhԂ
extern	int			ClearRectBaseImage(                    BASEIMAGE *BaseImage, int x, int y, int w, int h ) ;																											// {C[Wf[^̎ẅ̗ONA
extern	int			GetPaletteBaseImage(             const BASEIMAGE *BaseImage, int PaletteNo, int *r, int *g, int *b, int *a ) ;																						// {C[Wf[^̃pbg擾
extern	int			SetPaletteBaseImage(                   BASEIMAGE *BaseImage, int PaletteNo, int  r, int  g, int  b, int  a ) ;																						// {C[Wf[^̃pbgZbg
extern	int			SetPixelPalCodeBaseImage(              BASEIMAGE *BaseImage, int x, int y, int palNo ) ;																											// {C[Wf[^̎w̍W̐FR[hύX(pbg摜p)
extern	int			GetPixelPalCodeBaseImage(        const BASEIMAGE *BaseImage, int x, int y ) ;																														// {C[Wf[^̎w̍W̐FR[h擾(pbg摜p)
extern	int			SetPixelBaseImage(                     BASEIMAGE *BaseImage, int x, int y, int    r, int    g, int    b, int    a ) ;																				// {C[Wf[^̎w̍W̐FύX(eFvf͂O`QTT)
extern	int			SetPixelBaseImageF(                    BASEIMAGE *BaseImage, int x, int y, float  r, float  g, float  b, float  a ) ;																				// {C[Wf[^̎w̍W̐FύX(eFvf͕_)
extern	int			GetPixelBaseImage(               const BASEIMAGE *BaseImage, int x, int y, int   *r, int   *g, int   *b, int   *a ) ;																				// {C[Wf[^̎w̍W̐F擾(eFvf͂O`QTT)
extern	int			GetPixelBaseImageF(              const BASEIMAGE *BaseImage, int x, int y, float *r, float *g, float *b, float *a ) ;																				// {C[Wf[^̎w̍W̐F擾(eFvf͕_)
extern	int			DrawLineBaseImage(                     BASEIMAGE *BaseImage, int x1, int y1, int x2, int y2, int r, int g, int b, int a ) ;																			// {C[Wf[^̎w̍Wɐ`悷(eFvf͂O`QTT)
extern	int			DrawCircleBaseImage(                   BASEIMAGE *BaseImage, int x, int y, int radius, int r, int g, int b, int a, int FillFlag DEFAULTPARAM( = TRUE ) ) ;											// {C[Wf[^̎w̍Wɉ~`悷(eFvf͂O`QTT)
extern	int			BltBaseImage(                          int SrcX, int SrcY, int SrcSizeX, int SrcSizeY, int DestX, int DestY, BASEIMAGE *SrcBaseImage, BASEIMAGE *DestBaseImage ) ;									// {C[Wf[^ʂ̊{C[Wf[^ɓ]
#ifndef DX_COMPILE_TYPE_C_LANGUAGE
extern	int			BltBaseImage(                                                                          int DestX, int DestY, BASEIMAGE *SrcBaseImage, BASEIMAGE *DestBaseImage ) ;									// {C[Wf[^ʂ̊{C[Wf[^ɓ]
#endif // DX_COMPILE_TYPE_C_LANGUAGE
extern	int			BltBaseImage2(                                                                         int DestX, int DestY, BASEIMAGE *SrcBaseImage, BASEIMAGE *DestBaseImage ) ;									// {C[Wf[^ʂ̊{C[Wf[^ɓ]
extern	int			BltBaseImageWithTransColor(            int SrcX, int SrcY, int SrcSizeX, int SrcSizeY, int DestX, int DestY, BASEIMAGE *SrcBaseImage, BASEIMAGE *DestBaseImage, int Tr, int Tg, int Tb, int Ta ) ;	// {C[Wf[^ʂ̊{C[Wf[^ɓߐFtœ]
extern	int			BltBaseImageWithAlphaBlend(            int SrcX, int SrcY, int SrcSizeX, int SrcSizeY, int DestX, int DestY, BASEIMAGE *SrcBaseImage, BASEIMAGE *DestBaseImage, int Opacity DEFAULTPARAM( = 255 ) ) ;	// {C[Wf[^ʂ̊{C[Wf[^ɃAt@l̃uhlœ]( Opacity ͓x : 0( S ) ` 255( Ss ) )( o͐悪 ARGB8 `ȊȌꍇ̓G[ɂȂ܂ )
extern	int			ReverseBaseImageH(                     BASEIMAGE *BaseImage ) ;																																		// {C[Wf[^E]
extern	int			ReverseBaseImageV(                     BASEIMAGE *BaseImage ) ;																																		// {C[Wf[^㉺]
extern	int			ReverseBaseImage(                      BASEIMAGE *BaseImage ) ;																																		// {C[Wf[^㉺E]
extern	int			CheckPixelAlphaBaseImage(        const BASEIMAGE *BaseImage ) ;																																		// {C[Wf[^Ɋ܂܂sNZ̃At@l`FbN( ߂l   -1:G[  0:摜ɃAt@  1:摜ɃAt@Aׂčő(255)l  2:摜ɃAt@A݂At@l͍ŏ(0)ƍő(255)͍ŏ(0)̂݁@3:摜ɃAt@AŏƍőȊO̒Ԃ̒l )  
extern	int			GetBaseImageUseMaxPaletteNo(     const BASEIMAGE *BaseImage ) ;																																		// {C[Wf[^ŎgpĂpbgԍ̍ől擾( pbg摜ł͖ꍇ -1 Ԃ )

#ifndef DX_NON_JPEGREAD
extern	int			ReadJpegExif(                    const TCHAR *JpegFilePath,                            BYTE *ExifBuffer_Array, size_t ExifBufferSize ) ;															// JPEGt@C Exif擾AExifBuffer  NULL ɓnƁA߂l̏̃TCŶݎ擾ł܂( ߂l  -1:G[  -1ȊOFExif̃TCY )
extern	int			ReadJpegExifWithStrLen(          const TCHAR *JpegFilePath, size_t JpegFilePathLength, BYTE *ExifBuffer_Array, size_t ExifBufferSize ) ;															// JPEGt@C Exif擾AExifBuffer  NULL ɓnƁA߂l̏̃TCŶݎ擾ł܂( ߂l  -1:G[  -1ȊOFExif̃TCY )
#endif // DX_NON_JPEGREAD

#ifndef DX_NON_SAVEFUNCTION

extern	int			SaveBaseImageToBmp(              const TCHAR *FilePath,                        const BASEIMAGE *BaseImage ) ;																						// {C[Wf[^alo摜Ƃĕۑ
extern	int			SaveBaseImageToBmpWithStrLen(    const TCHAR *FilePath, size_t FilePathLength, const BASEIMAGE *BaseImage ) ;																						// {C[Wf[^alo摜Ƃĕۑ
extern	int			SaveBaseImageToDds(              const TCHAR *FilePath,                        const BASEIMAGE *BaseImage ) ;																						// {C[Wf[^ccr摜Ƃĕۑ
extern	int			SaveBaseImageToDdsWithStrLen(    const TCHAR *FilePath, size_t FilePathLength, const BASEIMAGE *BaseImage ) ;																						// {C[Wf[^ccr摜Ƃĕۑ
#ifndef DX_NON_PNGREAD
extern	int			SaveBaseImageToPng(              const TCHAR *FilePath,                        BASEIMAGE *BaseImage, int CompressionLevel ) ;																		// {C[Wf[^omf摜Ƃĕۑ
extern	int			SaveBaseImageToPngWithStrLen(    const TCHAR *FilePath, size_t FilePathLength, BASEIMAGE *BaseImage, int CompressionLevel ) ;																		// {C[Wf[^omf摜Ƃĕۑ
#endif // DX_NON_PNGREAD
#ifndef DX_NON_JPEGREAD
extern	int			SaveBaseImageToJpeg(             const TCHAR *FilePath,                        BASEIMAGE *BaseImage, int Quality, int Sample2x1 ) ;																	// {C[Wf[^iodf摜Ƃĕۑ
extern	int			SaveBaseImageToJpegWithStrLen(   const TCHAR *FilePath, size_t FilePathLength, BASEIMAGE *BaseImage, int Quality, int Sample2x1 ) ;																	// {C[Wf[^iodf摜Ƃĕۑ
#endif // DX_NON_JPEGREAD

#endif // DX_NON_SAVEFUNCTION

// {C[W`
extern	int			DrawBaseImage(					int x, int y, BASEIMAGE *BaseImage ) ;																																// {C[Wf[^`悷

// J[}b`OȂC[Wf[^ԓ]s Ver2
extern int			GraphColorMatchBltVer2(       void *DestGraphData, int DestPitch,  const COLORDATA *DestColorData,
											const void *SrcGraphData,  int SrcPitch,   const COLORDATA *SrcColorData,
											const void *AlphaMask,     int AlphaPitch, const COLORDATA *AlphaColorData,
											POINT DestPoint, const RECT *SrcRect, int ReverseFlag,
											int TransColorAlphaTestFlag, unsigned int TransColor,
											int ImageShavedMode, int AlphaOnlyFlag DEFAULTPARAM( = FALSE ) ,
											int RedIsAlphaFlag DEFAULTPARAM( = FALSE ) , int TransColorNoMoveFlag DEFAULTPARAM( = FALSE ) ,
											int Pal8ColorMatch DEFAULTPARAM( = FALSE ) ) ;


// F擾֌W
extern	COLOR_F			GetColorF(               float Red, float Green, float Blue, float Alpha ) ;													// _^̃J[l쐬
extern	COLOR_U8		GetColorU8(              int Red, int Green, int Blue, int Alpha ) ;															// ȂWrbg̃J[l쐬
extern	unsigned int	GetColor(                int Red, int Green, int Blue ) ;																		// DrawPixel ̕`֐ŎgpJ[l擾
extern	int				GetColor2(               unsigned int Color, int *Red, int *Green, int *Blue ) ;												// J[lԁA΁A̒l擾
extern	unsigned int	GetColor3(               const COLORDATA *ColorData, int Red, int Green, int Blue, int Alpha DEFAULTPARAM( = 255 ) ) ;			// w̃sNZtH[}bgɑΉJ[l𓾂
extern	unsigned int	GetColor4(               const COLORDATA *DestColorData, const COLORDATA* SrcColorData, unsigned int SrcColor ) ;				// w̃J[tH[}bg̃J[lʂ̃J[tH[}bg̃J[lɕϊ
extern	int				GetColor5(               const COLORDATA *ColorData, unsigned int Color, int *Red, int *Green, int *Blue, int *Alpha DEFAULTPARAM( = NULL ) ) ;	// w̃J[tH[}bg̃J[lԁA΁AAAt@̒l擾
extern	int				CreatePaletteColorData(  COLORDATA *ColorDataBuf ) ;																			// pbgJ[̃J[tH[}bg\z
extern	int				CreateARGBF32ColorData(  COLORDATA *ColorDataBuf ) ;																			// `qfae`l 32bit _^J[̃J[tH[}bg\z
extern	int				CreateARGBF16ColorData(  COLORDATA *ColorDataBuf ) ;																			// `qfae`l 16bit _^J[̃J[tH[}bg\z
extern	int				CreateXRGB8ColorData(    COLORDATA *ColorDataBuf ) ;																			// wqfaWJ[̃J[tH[}bg\z
extern	int				CreateARGB8ColorData(    COLORDATA *ColorDataBuf ) ;																			// `qfaWJ[̃J[tH[}bg\z
extern	int				CreateRGBA8ColorData(    COLORDATA *ColorDataBuf ) ;																			// qfa`WJ[̃J[tH[}bg\z
extern	int				CreateABGR8ColorData(    COLORDATA *ColorDataBuf ) ;																			// `afqWJ[̃J[tH[}bg\z
extern	int				CreateBGRA8ColorData(    COLORDATA *ColorDataBuf ) ;																			// afq`WJ[̃J[tH[}bg\z
extern	int				CreateBGR8ColorData(     COLORDATA *ColorDataBuf ) ;																			// afqWJ[̃J[tH[}bg\z
extern	int				CreateARGB4ColorData(    COLORDATA *ColorDataBuf ) ;																			// `qfaSJ[̃J[tH[}bg\z
extern	int				CreateA1R5G5B5ColorData( COLORDATA *ColorDataBuf ) ;																			// `PqTfTaTJ[̃J[tH[}bg\z
extern	int				CreateX1R5G5B5ColorData( COLORDATA *ColorDataBuf ) ;																			// wPqTfTaTJ[̃J[tH[}bg\z
extern	int				CreateR5G5B5A1ColorData( COLORDATA *ColorDataBuf ) ;																			// qTfTaT`PJ[̃J[tH[}bg\z
extern	int				CreateR5G6B5ColorData(   COLORDATA *ColorDataBuf ) ;																			// qTfUaTJ[̃J[tH[}bg\z
extern	int				CreateFullColorData(     COLORDATA *ColorDataBuf ) ;																			// QSrbgJ[̃J[tH[}bg\z
extern	int				CreateGrayColorData(     COLORDATA *ColorDataBuf ) ;																			// O[XP[̃J[tH[}bg\z
extern	int				CreatePal8ColorData(     COLORDATA *ColorDataBuf, int UseAlpha DEFAULTPARAM( = FALSE ) ) ;										// pbgQTUF̃J[tH[}bg\z
extern	int				CreateColorData(         COLORDATA *ColorDataBuf, int ColorBitDepth,
										         DWORD RedMask, DWORD GreenMask, DWORD BlueMask, DWORD AlphaMask,
												 int ChannelNum DEFAULTPARAM( = 0 ), int ChannelBitDepth DEFAULTPARAM( = 0 ), int FloatTypeFlag DEFAULTPARAM( = FALSE ) ) ;				// J[tH[}bg쐬
extern	void			SetColorDataNoneMask(    COLORDATA *ColorData ) ;																				// NoneMask ȊO̗vf𖄂߂ COLORDATA \̂̏ NoneMask Zbg
extern	int				CmpColorData(            const COLORDATA *ColorData1, const COLORDATA *ColorData2 ) ;											// ̃J[tH[}bgǂׂ( ߂l@TRUE:  FALSE:Ȃ )













// DxSoftImage.cpp֐vg^Cv錾
#ifndef DX_NON_SOFTIMAGE
extern	int			InitSoftImage(                        void ) ;																			// \tgEGAC[WnhSč폜
extern	int			LoadSoftImage(                        const TCHAR *FileName                        ) ;									// 摜t@Cǂݍ݃\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )
extern	int			LoadSoftImageWithStrLen(              const TCHAR *FileName, size_t FileNameLength ) ;									// 摜t@Cǂݍ݃\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )
extern	int			LoadARGB8ColorSoftImage(              const TCHAR *FileName                        ) ;									// 摜t@Cǂݍ݃\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )( ǂݍ񂾉摜 RGBA8 ȊÕtH[}bgꍇ RGBA8 J[ɕϊ )
extern	int			LoadARGB8ColorSoftImageWithStrLen(    const TCHAR *FileName, size_t FileNameLength ) ;									// 摜t@Cǂݍ݃\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )( ǂݍ񂾉摜 RGBA8 ȊÕtH[}bgꍇ RGBA8 J[ɕϊ )
extern	int			LoadXRGB8ColorSoftImage(              const TCHAR *FileName                        ) ;									// 摜t@Cǂݍ݃\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )( ǂݍ񂾉摜 XGBA8 ȊÕtH[}bgꍇ XGBA8 J[ɕϊ )
extern	int			LoadXRGB8ColorSoftImageWithStrLen(    const TCHAR *FileName, size_t FileNameLength ) ;									// 摜t@Cǂݍ݃\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )( ǂݍ񂾉摜 XGBA8 ȊÕtH[}bgꍇ XGBA8 J[ɕϊ )
extern	int			LoadSoftImageToMem(                   const void *FileImage, int FileImageSize ) ;										// ɓWJꂽ摜t@CC[W\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )
extern	int			LoadARGB8ColorSoftImageToMem(         const void *FileImage, int FileImageSize ) ;										// ɓWJꂽ摜t@CC[W\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )( ǂݍ񂾉摜 RGBA8 ȊÕtH[}bgꍇ RGBA8 J[ɕϊ )
extern	int			LoadXRGB8ColorSoftImageToMem(         const void *FileImage, int FileImageSize ) ;										// ɓWJꂽ摜t@CC[W\tgEGAC[Wnh쐬( -1:G[  -1ȊO:C[Wnh )( ǂݍ񂾉摜 XGBA8 ȊÕtH[}bgꍇ XGBA8 J[ɕϊ )
extern	int			MakeSoftImage(                        int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( -1:G[  -1ȊO:C[Wnh )
extern	int			MakeARGBF32ColorSoftImage(            int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( RGBA e`l 32bit _^ J[ )
extern	int			MakeARGBF16ColorSoftImage(            int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( RGBA e`l 16bit _^ J[ )
extern	int			MakeXRGB8ColorSoftImage(              int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( XRGB8 J[ )
extern	int			MakeARGB8ColorSoftImage(              int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( RGBA8 J[ )
extern	int			MakeRGBA8ColorSoftImage(              int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( RGBA8 J[ )
extern	int			MakeABGR8ColorSoftImage(              int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( ABGR8 J[ )
extern	int			MakeBGRA8ColorSoftImage(              int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( BGRA8 J[ )
extern	int			MakeARGB4ColorSoftImage(              int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( ARGB4 J[ )
extern	int			MakeA1R5G5B5ColorSoftImage(           int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( A1R5G5B5 J[ )
extern	int			MakeX1R5G5B5ColorSoftImage(           int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( X1R5G5B5 J[ )
extern	int			MakeR5G5B5A1ColorSoftImage(           int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( R5G5B5A1 J[ )
extern	int			MakeR5G6B5ColorSoftImage(             int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( R5G6B5 J[ )
extern	int			MakeRGB8ColorSoftImage(               int SizeX, int SizeY ) ;															// \tgEGAC[Wnh̍쐬( RGB8 J[ )
extern	int			MakePAL8ColorSoftImage(               int SizeX, int SizeY, int UseAlpha DEFAULTPARAM( = FALSE ) ) ;					// \tgEGAC[Wnh̍쐬( pbgQTUF J[ )
extern	int			MakeColorDataSoftImage(               int SizeX, int SizeY, const COLORDATA *ColorData ) ;								// \tgEGAC[Wnh̍쐬( COLORDATA ŃtH[}bgw )

extern	int			DeleteSoftImage(                      int SIHandle ) ;																	// \tgEGAC[Wnh̍폜

extern	int			GetSoftImageSize(                     int SIHandle, int *Width, int *Height ) ;											// \tgEGAC[Wnh̃TCY擾
extern	int			CheckPaletteSoftImage(                int SIHandle ) ;																	// \tgEGAC[Wnhpbg摜ǂ擾( TRUE:pbg摜  FALSE:pbg摜Ȃ )
extern	int			CheckAlphaSoftImage(                  int SIHandle ) ;																	// \tgEGAC[Wnh̃tH[}bgɃvf邩ǂ擾( TRUE:  FALSE:Ȃ )
extern	int			CheckPixelAlphaSoftImage(             int SIHandle ) ;																	// \tgEGAC[WnhɊ܂܂sNZ̃l`FbN( ߂l   -1:G[  0:摜Ƀ  1:摜ɃAׂčő(255)l  2:摜ɃA݂郿l͍ŏ(0)ƍő(255)͍ŏ(0)̂݁@3:摜ɃAŏƍőȊO̒Ԃ̒l )  

extern	int			GetDrawScreenSoftImage(               int x1, int y1, int x2, int y2, int SIHandle ) ;									// `Ώۂ̉ʂẅ\tgEGAC[Wnhɓ]
extern	int			GetDrawScreenSoftImageDestPos(        int x1, int y1, int x2, int y2, int SIHandle, int DestX, int DestY ) ;			// `Ώۂ̉ʂẅ\tgEGAC[Wnhɓ]( ]Ww )
extern	int			FillSoftImage(                        int SIHandle, int r, int g, int b, int a ) ;										// \tgEGAC[WnhwFœhԂ(eFvf͂O`QTT)
extern	int			ClearRectSoftImage(                   int SIHandle, int x, int y, int w, int h ) ;										// \tgEGAC[Wnh̎ẅ̗ONA
extern	int			GetPaletteSoftImage(                  int SIHandle, int PaletteNo, int *r, int *g, int *b, int *a ) ;					// \tgEGAC[Wnh̃pbg擾(eFvf͂O`QTT)
extern	int			SetPaletteSoftImage(                  int SIHandle, int PaletteNo, int  r, int  g, int  b, int  a ) ;					// \tgEGAC[Wnh̃pbgݒ肷(eFvf͂O`QTT)
extern	int			DrawPixelPalCodeSoftImage(            int SIHandle, int x, int y, int palNo ) ;											// \tgEGAC[Wnh̎wWɃhbg`悷(pbg摜pALl͂O`QTT)
extern	int			GetPixelPalCodeSoftImage(             int SIHandle, int x, int y ) ;													// \tgEGAC[Wnh̎wW̐FR[h擾(pbg摜pA߂l͂O`QTT)
extern	void		*GetImageAddressSoftImage(            int SIHandle ) ;																	// \tgEGAC[Wnh̉摜i[Ă郁̈̐擪AhX擾
extern	int			GetPitchSoftImage(                    int SIHandle ) ;																	// \tgEGAC[Wnh̃Ɋi[Ă摜f[^1Cӂ̃oCg擾
extern	int			DrawPixelSoftImage(                   int SIHandle, int x, int y, int    r, int    g, int    b, int    a ) ;			// \tgEGAC[Wnh̎wWɃhbg`悷(eFvf͂O`QTT)
extern	int			DrawPixelSoftImageF(                  int SIHandle, int x, int y, float  r, float  g, float  b, float  a ) ;			// \tgEGAC[Wnh̎wWɃhbg`悷(eFvf͕_)
extern	void		DrawPixelSoftImage_Unsafe_XRGB8(      int SIHandle, int x, int y, int    r, int    g, int    b ) ;						// \tgEGAC[Wnh̎wWɃhbg`悷(eFvf͂O`QTT)AG[`FbNȂɍłA͈͊O̍W ARGB8 ȊÕtH[}bg̃\tgnhnƕsȃANZXŋI܂
extern	void		DrawPixelSoftImage_Unsafe_ARGB8(      int SIHandle, int x, int y, int    r, int    g, int    b, int    a ) ;			// \tgEGAC[Wnh̎wWɃhbg`悷(eFvf͂O`QTT)AG[`FbNȂɍłA͈͊O̍W XRGB8 ȊÕtH[}bg̃\tgnhnƕsȃANZXŋI܂
extern	int			GetPixelSoftImage(                    int SIHandle, int x, int y, int   *r, int   *g, int   *b, int   *a ) ;			// \tgEGAC[Wnh̎wW̐F擾(eFvf͂O`QTT)
extern	int			GetPixelSoftImageF(                   int SIHandle, int x, int y, float *r, float *g, float *b, float *a ) ;			// \tgEGAC[Wnh̎wW̐F擾(eFvf͕_)
extern	void		GetPixelSoftImage_Unsafe_XRGB8(       int SIHandle, int x, int y, int   *r, int   *g, int   *b ) ;						// \tgEGAC[Wnh̎wW̐F擾(eFvf͂O`QTT)AG[`FbNȂɍłA͈͊O̍W XRGB8 ȊÕtH[}bg̃\tgnhnƕsȃANZXŋI܂
extern	void		GetPixelSoftImage_Unsafe_ARGB8(       int SIHandle, int x, int y, int   *r, int   *g, int   *b, int   *a ) ;			// \tgEGAC[Wnh̎wW̐F擾(eFvf͂O`QTT)AG[`FbNȂɍłA͈͊O̍W ARGB8 ȊÕtH[}bg̃\tgnhnƕsȃANZXŋI܂
extern	int			DrawLineSoftImage(                    int SIHandle, int x1, int y1, int x2, int y2, int r, int g, int b, int a ) ;		// \tgEGAC[Wnh̎wWɐ`悷(eFvf͂O`QTT)
extern	int			DrawCircleSoftImage(                  int SIHandle, int x, int y, int radius, int r, int g, int b, int a, int FillFlag DEFAULTPARAM( = TRUE ) ) ;	// \tgEGAC[Wnh̎wWɉ~`悷(eFvf͂O`QTT)
extern	int			BltSoftImage(                         int SrcX, int SrcY, int SrcSizeX, int SrcSizeY, int SrcSIHandle, int DestX, int DestY, int DestSIHandle ) ;										// \tgEGAC[Wnhʂ̃\tgEGAC[Wnhɓ]
extern	int			BltSoftImageWithTransColor(           int SrcX, int SrcY, int SrcSizeX, int SrcSizeY, int SrcSIHandle, int DestX, int DestY, int DestSIHandle, int Tr, int Tg, int Tb, int Ta ) ;		// \tgEGAC[Wnhʂ̃\tgEGAC[WnhɓߐFtœ]
extern	int			BltSoftImageWithAlphaBlend(           int SrcX, int SrcY, int SrcSizeX, int SrcSizeY, int SrcSIHandle, int DestX, int DestY, int DestSIHandle, int Opacity DEFAULTPARAM( = 255 ) ) ;	// \tgEGAC[Wnhʂ̃\tgEGAC[WnhɃAt@l̃uhlœ]( Opacity ͓x : 0( S ) ` 255( Ss ) )( o͐悪 ARGB8 `ȊȌꍇ̓G[ɂȂ܂ )
extern	int			ReverseSoftImageH(                    int SIHandle ) ;																	// \tgEGAC[WnhE]
extern	int			ReverseSoftImageV(                    int SIHandle ) ;																	// \tgEGAC[Wnh㉺]
extern	int			ReverseSoftImage(                     int SIHandle ) ;																	// \tgEGAC[Wnh㉺E]
extern	int			ConvertPremulAlphaSoftImage(          int SIHandle ) ;																	// ʏ̃`lt摜Zς݃`lt摜ɕϊ( sNZtH[}bg ARGB8 ȊȌꍇ ARGB8 ɕϊ܂ )
extern	int			ConvertInterpAlphaSoftImage(          int SIHandle ) ;																	// Zς݃`lt摜ʏ̃`lt摜ɕϊ( sNZtH[}bg ARGB8 ȊȌꍇ ARGB8 ɕϊ܂ )

#ifndef DX_NON_FONT
extern	int			BltStringSoftImage(                   int x, int y, const TCHAR *StrData,                       int DestSIHandle, int DestEdgeSIHandle DEFAULTPARAM( = -1 ) ,                        int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;		// \tgEGAC[Wnhɕ`悷( ftHgtHgnhgp )
extern	int			BltStringSoftImageWithStrLen(         int x, int y, const TCHAR *StrData, size_t StrDataLength, int DestSIHandle, int DestEdgeSIHandle DEFAULTPARAM( = -1 ) ,                        int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;		// \tgEGAC[Wnhɕ`悷( ftHgtHgnhgp )
extern	int			BltStringSoftImageToHandle(           int x, int y, const TCHAR *StrData,                       int DestSIHandle, int DestEdgeSIHandle /* KvȂꍇ -1 */ , int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;		// \tgEGAC[Wnhɕ`悷( tHgnhgp )
extern	int			BltStringSoftImageToHandleWithStrLen( int x, int y, const TCHAR *StrData, size_t StrDataLength, int DestSIHandle, int DestEdgeSIHandle /* KvȂꍇ -1 */ , int FontHandle, int VerticalFlag DEFAULTPARAM( = FALSE ) ) ;		// \tgEGAC[Wnhɕ`悷( tHgnhgp )
#endif // DX_NON_FONT

extern	int			DrawSoftImage(                        int x, int y, int SIHandle ) ;														// \tgEGAC[Wnhʂɕ`悷

#ifndef DX_NON_SAVEFUNCTION

extern	int			SaveSoftImageToBmp(                   const TCHAR *FilePath,                        int SIHandle ) ;											// \tgEGAC[Wnhalo摜t@CƂĕۑ
extern	int			SaveSoftImageToBmpWithStrLen(         const TCHAR *FilePath, size_t FilePathLength, int SIHandle ) ;											// \tgEGAC[Wnhalo摜t@CƂĕۑ
extern	int			SaveSoftImageToDds(                   const TCHAR *FilePath,                        int SIHandle ) ;											// \tgEGAC[Wnhccr摜t@CƂĕۑ
extern	int			SaveSoftImageToDdsWithStrLen(         const TCHAR *FilePath, size_t FilePathLength, int SIHandle ) ;											// \tgEGAC[Wnhccr摜t@CƂĕۑ
#ifndef DX_NON_PNGREAD
extern	int			SaveSoftImageToPng(                   const TCHAR *FilePath,                        int SIHandle, int CompressionLevel ) ;						// \tgEGAC[Wnhomf摜t@CƂĕۑ CompressionLevel = kAl傫قǍkׁAO͖k,0`9
extern	int			SaveSoftImageToPngWithStrLen(         const TCHAR *FilePath, size_t FilePathLength, int SIHandle, int CompressionLevel ) ;						// \tgEGAC[Wnhomf摜t@CƂĕۑ CompressionLevel = kAl傫قǍkׁAO͖k,0`9
#endif // DX_NON_PNGREAD
#ifndef DX_NON_JPEGREAD
extern	int			SaveSoftImageToJpeg(                  const TCHAR *FilePath,                        int SIHandle, int Quality, int Sample2x1 ) ;				// \tgEGAC[Wnhiodf摜t@CƂĕۑ Quality = 掿Al傫قǒሳk掿,0`100 
extern	int			SaveSoftImageToJpegWithStrLen(        const TCHAR *FilePath, size_t FilePathLength, int SIHandle, int Quality, int Sample2x1 ) ;				// \tgEGAC[Wnhiodf摜t@CƂĕۑ Quality = 掿Al傫قǒሳk掿,0`100 
#endif // DX_NON_JPEGREAD

#endif // DX_NON_SAVEFUNCTION

#endif // DX_NON_SOFTIMAGE


















#ifndef DX_NON_SOUND

// DxSound.cpp֐vg^Cv錾

// TEhf[^Ǘn֐
extern	int			InitSoundMem(                        void ) ;																					// SẴTEhnh폜

extern	int			AddSoundData(                        int Handle DEFAULTPARAM( = -1 ) ) ;																											// TEhnh쐬
extern	int			AddStreamSoundMem(                   STREAMDATA *Stream, int LoopNum,  int SoundHandle, int StreamDataType, int *CanStreamCloseFlag, int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// Xg[Đ^CṽTEhnhɃXg[f[^ĐΏۂɒǉ
extern	int			AddStreamSoundMemToMem(              const void *FileImage, size_t FileImageSize, int LoopNum,  int SoundHandle, int StreamDataType, int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// Xg[Đ^CṽTEhnhɃɓWJTEht@CC[WĐΏۂɒǉ
extern	int			AddStreamSoundMemToFile(             const TCHAR *WaveFile,                            int LoopNum,  int SoundHandle, int StreamDataType, int UnionHandle DEFAULTPARAM( = -1 ) ) ;	// Xg[Đ^CṽTEhnhɃTEht@CĐΏۂɒǉ
extern	int			AddStreamSoundMemToFileWithStrLen(   const TCHAR *WaveFile, size_t WaveFilePathLength, int LoopNum,  int SoundHandle, int StreamDataType, int UnionHandle DEFAULTPARAM( = -1 ) ) ;	// Xg[Đ^CṽTEhnhɃTEht@CĐΏۂɒǉ
extern	int			SetupStreamSoundMem(                 int SoundHandle ) ;																		// Xg[Đ^CṽTEhnh̍Đ
extern	int			PlayStreamSoundMem(                  int SoundHandle, int PlayType DEFAULTPARAM( = DX_PLAYTYPE_LOOP ) , int TopPositionFlag DEFAULTPARAM( = TRUE ) ) ;	// Xg[Đ^CṽTEhnh̍ĐJn
extern	int			CheckStreamSoundMem(                 int SoundHandle ) ;																		// Xg[Đ^CṽTEhnh̍ĐԂ擾
extern	int			StopStreamSoundMem(                  int SoundHandle, int IsNextLoopEnd DEFAULTPARAM( = FALSE ) ) ;								// Xg[Đ^CṽTEhnh̍Đ~
extern	int			SetStreamSoundCurrentPosition(       LONGLONG Byte, int SoundHandle ) ;															// TEhnh̍ĐʒuoCgPʂŕύX(Đ~܂Ă鎞̂ݗL)
extern	LONGLONG	GetStreamSoundCurrentPosition(       int SoundHandle ) ;																		// TEhnh̍ĐʒuoCgPʂŎ擾
extern	int			SetStreamSoundCurrentTime(           LONGLONG Time, int SoundHandle ) ;															// TEhnh̍Đʒu~bPʂŐݒ肷(k`̏ꍇ͐ݒ肳Ȃꍇ)
extern	LONGLONG	GetStreamSoundCurrentTime(           int SoundHandle ) ;																		// TEhnh̍Đʒu~bPʂŎ擾(k`̏ꍇ͐lԂĂȂꍇ)
extern	int			ProcessStreamSoundMem(               int SoundHandle ) ;																		// Xg[Đ^CṽTEhnh̎Iȏs֐( ŎIɌĂ΂܂ )
extern	int			ProcessStreamSoundMemAll(            void ) ;																					// LȃXg[Đ^CṽTEhnhɑ΂ ProcessStreamSoundMem s( ŎIɌĂ΂܂ )


extern	int			LoadSoundMem2(                       const TCHAR *FileName1,                         const TCHAR *FileName2                         ) ;	// Otƃ[vɕꂽTEht@Cǂݍ݃TEhnh쐬
extern	int			LoadSoundMem2WithStrLen(             const TCHAR *FileName1, size_t FileName1Length, const TCHAR *FileName2, size_t FileName2Length ) ;	// Otƃ[vɕꂽTEht@Cǂݍ݃TEhnh쐬
extern	int			LoadBGM(                             const TCHAR *FileName                        ) ;													// ɂaflǂݍ݃TEhnh쐬̂ɓK֐
extern	int			LoadBGMWithStrLen(                   const TCHAR *FileName, size_t FileNameLength ) ;													// ɂaflǂݍ݃TEhnh쐬̂ɓK֐

extern	int			LoadSoundMemBase(                    const TCHAR *FileName,                        int BufferNum,                      int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// TEht@CTEhnh쐬
extern	int			LoadSoundMemBaseWithStrLen(          const TCHAR *FileName, size_t FileNameLength, int BufferNum,                      int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// TEht@CTEhnh쐬
extern	int			LoadSoundMem(                        const TCHAR *FileName,                        int BufferNum DEFAULTPARAM( = 3 ) , int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// LoadSoundMemBase ̕ʖ֐
extern	int			LoadSoundMemWithStrLen(              const TCHAR *FileName, size_t FileNameLength, int BufferNum DEFAULTPARAM( = 3 ) , int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// LoadSoundMemBase ̕ʖ֐
extern	int			LoadSoundMemToBufNumSitei(           const TCHAR *FileName,                        int BufferNum ) ;									// LoadSoundMem gpĉ
extern	int			LoadSoundMemToBufNumSiteiWithStrLen( const TCHAR *FileName, size_t FileNameLength, int BufferNum ) ;									// LoadSoundMem gpĉ
extern	int			DuplicateSoundMem(                   int SrcSoundHandle, int BufferNum DEFAULTPARAM( = 3 ) ) ;											// TEhf[^gpTEhnh쐬( DX_SOUNDDATATYPE_MEMNOPRESS ^CṽTEhnĥ݉\ )

extern	int			LoadSoundMemByMemImageBase(          const void *FileImage, size_t FileImageSize, int BufferNum,                      int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// ɓWJꂽTEht@CC[WTEhnh쐬
extern	int			LoadSoundMemByMemImage(              const void *FileImage, size_t FileImageSize, int BufferNum DEFAULTPARAM( = 3 ) , int UnionHandle DEFAULTPARAM( = -1 ) ) ;		// LoadSoundMemByMemImageBase ̕ʖ֐
extern	int			LoadSoundMemByMemImage2(             const void *WaveImage, size_t WaveImageSize, const WAVEFORMATEX *WaveFormat, size_t WaveHeaderSize ) ;	// ɓWJꂽoblf[^TEhnh쐬
extern	int			LoadSoundMemByMemImageToBufNumSitei( const void *FileImage, size_t FileImageSize, int BufferNum ) ;										// LoadSoundMemByMemImageBase gpĉ
extern	int			LoadSoundMem2ByMemImage(             const void *FileImage1, size_t FileImageSize1, const void *FileImage2, size_t FileImageSize2 ) ;	// Otƃ[vɕꂽ̃ɓWJꂽTEht@CC[WTEhnh쐬
extern	int			LoadSoundMemFromSoftSound(           int SoftSoundHandle, int BufferNum DEFAULTPARAM( = 3 ) ) ;											// \tgEGATEhnhTEhf[^TEhnh쐬

extern	int			DeleteSoundMem(                      int SoundHandle ) ;																		// TEhnh폜

extern	int			PlaySoundMem(                        int SoundHandle, int PlayType, int TopPositionFlag DEFAULTPARAM( = TRUE ) ) ;				// TEhnhĐ
extern	int			StopSoundMem(                                                                        int SoundHandle, int IsNextLoopEnd DEFAULTPARAM( = FALSE ) ) ;	// TEhnh̍Đ~( IsNextLoopEnd  TRUE ɂƎ̃[vĨ^C~Oŉ~߂ )
extern	int			CheckSoundMem(                                                                       int SoundHandle ) ;						// TEhnhĐǂ擾
extern	int			SetPanSoundMem(                      int PanPal,                                     int SoundHandle ) ;						// TEhnh̃pݒ肷( 1001fVxP 0 ` 10000 )
extern	int			ChangePanSoundMem(                   int PanPal,                                     int SoundHandle ) ;						// TEhnh̃pݒ肷( -255 ` 255 )
extern	int			GetPanSoundMem(                                                                      int SoundHandle ) ;						// TEhnh̃p擾
extern	int			SetVolumeSoundMem(                   int VolumePal,                                  int SoundHandle ) ;						// TEhnh̃{[ݒ肷( 1001fVxP 0 ` 10000 ) 
extern	int			ChangeVolumeSoundMem(                int VolumePal,                                  int SoundHandle ) ;						// TEhnh̃{[ݒ肷( 0 ` 255 )
extern	int			GetVolumeSoundMem(                                                                   int SoundHandle ) ;						// TEhnh̃{[擾( 1001fVxP 0 ` 10000 )
extern	int			GetVolumeSoundMem2(                                                                  int SoundHandle ) ;						// TEhnh̃{[擾( 0 ` 255 )
extern	int			SetChannelVolumeSoundMem(            int Channel, int VolumePal,                     int SoundHandle ) ;						// TEhnh̎w̃`l̃{[ݒ肷( 1001fVxP 0 ` 10000 )
extern	int			ChangeChannelVolumeSoundMem(         int Channel, int VolumePal,                     int SoundHandle ) ;						// TEhnh̎w̃`l̃{[ݒ肷( 0 ` 255 )
extern	int			GetChannelVolumeSoundMem(            int Channel,                                    int SoundHandle ) ;						// TEhnh̎w̃`l̃{[擾( 1001fVxP 0 ` 10000 )
extern	int			GetChannelVolumeSoundMem2(           int Channel,                                    int SoundHandle ) ;						// TEhnh̎w̃`l̃{[擾( 0 ` 255 )
extern	int			SetFrequencySoundMem(                int FrequencyPal,                               int SoundHandle ) ;						// TEhnh̍Đgݒ肷
extern	int			GetFrequencySoundMem(                                                                int SoundHandle ) ;						// TEhnh̍Đg擾
extern	int			ResetFrequencySoundMem(                                                              int SoundHandle ) ;						// TEhnh̍Đgǂݍݒ̏Ԃɖ߂

extern	int			SetNextPlayPanSoundMem(              int PanPal,                                     int SoundHandle ) ;						// TEhnh̎̍Đɂ̂ݎgppݒ肷( 1001fVxP 0 ` 10000 )
extern	int			ChangeNextPlayPanSoundMem(           int PanPal,                                     int SoundHandle ) ;						// TEhnh̎̍Đɂ̂ݎgppݒ肷( -255 ` 255 )
extern	int			SetNextPlayVolumeSoundMem(           int VolumePal,                                  int SoundHandle ) ;						// TEhnh̎̍Đɂ̂ݎgp{[ݒ肷( 1001fVxP 0 ` 10000 )
extern	int			ChangeNextPlayVolumeSoundMem(        int VolumePal,                                  int SoundHandle ) ;						// TEhnh̎̍Đɂ̂ݎgp{[ݒ肷( 0 ` 255 )
extern	int			SetNextPlayChannelVolumeSoundMem(    int Channel, int VolumePal,                     int SoundHandle ) ;						// TEhnh̎̍Đɂ̂ݎgp`l̃{[ݒ肷( 1001fVxP 0 ` 10000 )
extern	int			ChangeNextPlayChannelVolumeSoundMem( int Channel, int VolumePal,                     int SoundHandle ) ;						// TEhnh̎̍Đɂ̂ݎgp`l̃{[ݒ肷( 0 ` 255 )
extern	int			SetNextPlayFrequencySoundMem(        int FrequencyPal,                               int SoundHandle ) ;						// TEhnh̎̍Đɂ̂ݎgpĐgݒ肷

extern	int			SetCurrentPositionSoundMem(          LONGLONG SamplePosition,                        int SoundHandle ) ;						// TEhnh̍ĐʒuTvPʂŐݒ肷(Đ~܂Ă鎞̂ݗL)
extern	LONGLONG	GetCurrentPositionSoundMem(                                                          int SoundHandle ) ;						// TEhnh̍ĐʒuTvPʂŎ擾
extern	int			SetSoundCurrentPosition(             LONGLONG Byte,                                  int SoundHandle ) ;						// TEhnh̍ĐʒuoCgPʂŐݒ肷(Đ~܂Ă鎞̂ݗL)
extern	LONGLONG	GetSoundCurrentPosition(                                                             int SoundHandle ) ;						// TEhnh̍ĐʒuoCgPʂŎ擾
extern	int			SetSoundCurrentTime(                 LONGLONG Time,                                  int SoundHandle ) ;						// TEhnh̍Đʒu~bPʂŐݒ肷(k`̏ꍇ͐ݒ肳Ȃꍇ)
extern	LONGLONG	GetSoundCurrentTime(                                                                 int SoundHandle ) ;						// TEhnh̍Đʒu~bPʂŎ擾(k`̏ꍇ͐lԂĂȂꍇ)
extern	LONGLONG	GetSoundTotalSample(                                                                 int SoundHandle ) ;						// TEhnh̉̑ԂTvPʂŎ擾
extern	LONGLONG	GetSoundTotalTime(                                                                   int SoundHandle ) ;						// TEhnh̉̑Ԃ~bPʂŎ擾

extern	int			SetLoopPosSoundMem(                  LONGLONG LoopTime,                              int SoundHandle ) ;						// SetLoopTimePosSoundMem ̕ʖ֐
extern	int			SetLoopTimePosSoundMem(              LONGLONG LoopTime,                              int SoundHandle ) ;						// TEhnhɃ[vʒuݒ肷(~bP)
extern	int			SetLoopSamplePosSoundMem(            LONGLONG LoopSamplePosition,                    int SoundHandle ) ;						// TEhnhɃ[vʒuݒ肷(TvP)

extern	int			SetLoopStartTimePosSoundMem(         LONGLONG LoopStartTime,                         int SoundHandle ) ;						// TEhnhɃ[vJnʒuݒ肷(~bP)
extern	int			SetLoopStartSamplePosSoundMem(       LONGLONG LoopStartSamplePosition,               int SoundHandle ) ;						// TEhnhɃ[vJnʒuݒ肷(TvP)

extern	int			SetLoopAreaTimePosSoundMem(          LONGLONG  LoopStartTime, LONGLONG  LoopEndTime,                     int SoundHandle ) ;	// TEhnhɃ[v͈͂ݒ肷(~bP)
extern	int			GetLoopAreaTimePosSoundMem(          LONGLONG *LoopStartTime, LONGLONG *LoopEndTime,                     int SoundHandle ) ;	// TEhnhɃ[v͈͂擾(~bP)
extern	int			SetLoopAreaSamplePosSoundMem(        LONGLONG  LoopStartSamplePosition, LONGLONG  LoopEndSamplePosition, int SoundHandle ) ;	// TEhnhɃ[v͈͂ݒ肷(TvP)
extern	int			GetLoopAreaSamplePosSoundMem(        LONGLONG *LoopStartSamplePosition, LONGLONG *LoopEndSamplePosition, int SoundHandle ) ;	// TEhnhɃ[v͈͂擾(TvP)

extern	int			SetPlayFinishDeleteSoundMem(         int DeleteFlag,                                 int SoundHandle ) ;						// TEhnh̍ĐI玩IɃnh폜邩ǂݒ肷

extern	int			Set3DReverbParamSoundMem(            const SOUND3D_REVERB_PARAM *Param,              int SoundHandle ) ;						// TEhnĥRcTEhp̃o[up[^ݒ肷
extern	int			Set3DPresetReverbParamSoundMem(      int PresetNo /* DX_REVERB_PRESET_DEFAULT  */ , int SoundHandle ) ;						// TEhnĥRcTEhp̃o[up[^vZbggpĐݒ肷
extern	int			Set3DReverbParamSoundMemAll(         const SOUND3D_REVERB_PARAM *Param, int PlaySoundOnly DEFAULTPARAM( = FALSE ) ) ;					// SĂ̂RcTEh̃TEhnhɃo[up[^ݒ肷( PlaySoundOnly TRUE:Đ̃TEhɂ̂ݐݒ肷  FALSE:ĐĂȂTEhɂݒ肷 )
extern	int			Set3DPresetReverbParamSoundMemAll(   int PresetNo /* DX_REVERB_PRESET_DEFAULT  */ , int PlaySoundOnly DEFAULTPARAM( = FALSE )  ) ;	// SĂ̂RcTEh̃TEhnhɃo[up[^vZbggpĐݒ肷( PlaySoundOnly TRUE:Đ̃TEhɂ̂ݐݒ肷  FALSE:ĐĂȂTEhɂݒ肷 )
extern	int			Get3DReverbParamSoundMem(            SOUND3D_REVERB_PARAM *ParamBuffer,              int SoundHandle ) ;						// TEhnhɐݒ肳ĂRcTEhp̃o[up[^擾
extern	int			Get3DPresetReverbParamSoundMem(      SOUND3D_REVERB_PARAM *ParamBuffer, int PresetNo /* DX_REVERB_PRESET_DEFAULT  */ ) ;		// vZbĝRcTEhp̃o[up[^擾

extern	int			Set3DPositionSoundMem(               VECTOR Position,                                int SoundHandle ) ;						// TEhnĥRcTEhp̍Đʒuݒ肷
extern	int			Set3DRadiusSoundMem(                 float Radius,                                   int SoundHandle ) ;						// TEhnĥRcTEhp̉鋗ݒ肷
extern	int			Set3DVelocitySoundMem(               VECTOR Velocity,                                int SoundHandle ) ;						// TEhnĥRcTEhp̈ړxݒ肷

extern	int			SetNextPlay3DPositionSoundMem(       VECTOR Position,                                int SoundHandle ) ;						// TEhnh̎̍Đ݂̂ɎgpRcTEhp̍Đʒuݒ肷
extern	int			SetNextPlay3DRadiusSoundMem(         float Radius,                                   int SoundHandle ) ;						// TEhnh̎̍Đ݂̂ɎgpRcTEhp̉鋗ݒ肷
extern	int			SetNextPlay3DVelocitySoundMem(       VECTOR Velocity,                                int SoundHandle ) ;						// TEhnh̎̍Đ݂̂ɎgpRcTEhp̈ړxݒ肷


// ֐
extern	int			GetMP3TagInfo(           const TCHAR *FileName,                        TCHAR *TitleBuffer, size_t TitleBufferBytes, TCHAR *ArtistBuffer, size_t ArtistBufferBytes, TCHAR *AlbumBuffer, size_t AlbumBufferBytes, TCHAR *YearBuffer, size_t YearBufferBytes, TCHAR *CommentBuffer, size_t CommentBufferBytes, TCHAR *TrackBuffer, size_t TrackBufferBytes, TCHAR *GenreBuffer, size_t GenreBufferBytes, int *PictureGrHandle ) ;		// MP3t@C̃^O擾
extern	int			GetMP3TagInfoWithStrLen( const TCHAR *FileName, size_t FileNameLength, TCHAR *TitleBuffer, size_t TitleBufferBytes, TCHAR *ArtistBuffer, size_t ArtistBufferBytes, TCHAR *AlbumBuffer, size_t AlbumBufferBytes, TCHAR *YearBuffer, size_t YearBufferBytes, TCHAR *CommentBuffer, size_t CommentBufferBytes, TCHAR *TrackBuffer, size_t TrackBufferBytes, TCHAR *GenreBuffer, size_t GenreBufferBytes, int *PictureGrHandle ) ;		// MP3t@C̃^O擾
#ifndef DX_NON_OGGVORBIS
extern	int			GetOggCommentNum(           const TCHAR *FileName                        ) ;																																	// Oggt@C̃Rg̐擾
extern	int			GetOggCommentNumWithStrLen( const TCHAR *FileName, size_t FileNameLength ) ;																																	// Oggt@C̃Rg̐擾
extern	int			GetOggComment(              const TCHAR *FileName,                        int CommentIndex, TCHAR *CommentNameBuffer, size_t CommentNameBufferBytes, TCHAR *CommentBuffer, size_t CommentBufferBytes ) ;		// Oggt@C̃Rg擾
extern	int			GetOggCommentWithStrLen(    const TCHAR *FileName, size_t FileNameLength, int CommentIndex, TCHAR *CommentNameBuffer, size_t CommentNameBufferBytes, TCHAR *CommentBuffer, size_t CommentBufferBytes ) ;		// Oggt@C̃Rg擾
#endif // DX_NON_OGGVORBIS
						

// ݒ֌W֐
extern	int			SetCreateSoundDataType(              int SoundDataType ) ;																		// 쐬TEhnh̍Đ^Cvݒ肷( DX_SOUNDDATATYPE_MEMNOPRESS  )
extern	int			GetCreateSoundDataType(              void ) ;																					// 쐬TEhnh̍Đ^Cv擾( DX_SOUNDDATATYPE_MEMNOPRESS  )
extern	int			SetCreateSoundPitchRate(             float Cents ) ;																			// 쐬TEhnh̃sb`( ̒ςɉύX )[gݒ肷( Pʂ̓Zg( 100.0fŔA1200.0fłPIN^[ )AvX̒lŉA}CiX̒lŉႭȂ܂ )
extern	float		GetCreateSoundPitchRate(             void ) ;																					// 쐬TEhnh̃sb`( ̒ςɉύX )[g擾( Pʂ̓Zg( 100.0fŔA1200.0fłPIN^[ )AvX̒lŉA}CiX̒lŉႭȂ܂ )
extern	int			SetCreateSoundTimeStretchRate(       float Rate ) ;																				// 쐬TEhnh̃^CXgb`( ςɉ̒ύX )[gݒ肷( Pʂ͔{A2.0f ŉ̒Q{ɁA0.5f ŉ̒ɂȂ܂ )
extern	float		GetCreateSoundTimeStretchRate(       void ) ;																					// 쐬TEhnh̃^CXgb`( ςɉ̒ύX )[g擾( Pʂ͔{A2.0f ŉ̒Q{ɁA0.5f ŉ̒ɂȂ܂ )
extern	int			SetCreateSoundLoopAreaTimePos(       LONGLONG  LoopStartTime,           LONGLONG  LoopEndTime ) ;								// 쐬TEhnh̃[v͈͂ݒ肷( ~bP )
extern	int			GetCreateSoundLoopAreaTimePos(       LONGLONG *LoopStartTime,           LONGLONG *LoopEndTime ) ;								// 쐬TEhnh̃[v͈͂擾( ~bP )
extern	int			SetCreateSoundLoopAreaSamplePos(     LONGLONG  LoopStartSamplePosition, LONGLONG  LoopEndSamplePosition ) ;						// 쐬TEhnh̃[v͈͂ݒ肷( TvP )
extern	int			GetCreateSoundLoopAreaSamplePos(     LONGLONG *LoopStartSamplePosition, LONGLONG *LoopEndSamplePosition ) ;						// 쐬TEhnh̃[v͈͂擾( TvP )
extern	int			SetCreateSoundIgnoreLoopAreaInfo(    int IgnoreFlag ) ;																			// LoadSoundMem ȂǂœǂݍރTEhf[^Ƀ[v͈͏񂪂Ă邩ǂݒ肷( TRUE:  FALSE:Ȃ( ftHg ) )
extern	int			GetCreateSoundIgnoreLoopAreaInfo(    void ) ;																					// LoadSoundMem ȂǂœǂݍރTEhf[^Ƀ[v͈͏񂪂Ă邩ǂ擾( TRUE:  FALSE:Ȃ( ftHg ) )
extern	int			SetDisableReadSoundFunctionMask(     int Mask ) ;																				// gpȂTEhf[^ǂݍݏ̃}XNݒ肷( DX_READSOUNDFUNCTION_PCM  )
extern	int			GetDisableReadSoundFunctionMask(     void ) ;																					// gpȂTEhf[^ǂݍݏ̃}XN擾( DX_READSOUNDFUNCTION_PCM  )
extern	int			SetEnableSoundCaptureFlag(           int Flag ) ;																				// TEhLv`OƂ邩ǂݒ肷
extern	int			SetUseOldVolumeCalcFlag(             int Flag ) ;																				// ChangeVolumeSoundMem, ChangeNextPlayVolumeSoundMem, ChangeMovieVolumeToGraph ̉ʌvZ Ver3.10cȑÔ̂gp邩ǂݒ肷( TRUE:Ver3.10cȑǑvZgp  FALSE:3.10dȍ~̌vZgp( ftHg ) )
extern	int			SetSoundCurrentTimeType(             int Type /* DX_SOUNDCURRENTTIME_TYPE_LOW_LEVEL Ȃ */ ) ;									// GetSoundCurrentTime ȂǂgpꍇɎ擾łĐԂ̃^Cvݒ肷
extern	int			GetSoundCurrentTimeType(             void ) ;																					// GetSoundCurrentTime ȂǂgpꍇɎ擾łĐԂ̃^Cv擾

extern	int			SetCreate3DSoundFlag(                     int Flag ) ;																			// ɍ쐬TEhnhRcTEhpɂ邩ǂݒ肷( TRUE:RcTEhpɂ  FALSE:RcTEhpɂȂ( ftHg ) )
extern	int			Set3DSoundOneMetre(                       float Distance ) ;																	// RcԂ̂P[gɑ鋗ݒ肷ADxLib_Init ĂяoOł̂݌Ăяo\( ftHg:1.0f )
extern	int			Set3DSoundListenerPosAndFrontPos_UpVecY(  VECTOR Position, VECTOR FrontPosition ) ;												// RcTEh̃Xi[̈ʒuƃXi[̑Oʒuݒ肷( Xi[̏͂xŒ )
extern	int			Set3DSoundListenerPosAndFrontPosAndUpVec( VECTOR Position, VECTOR FrontPosition, VECTOR UpVector ) ;							// RcTEh̃Xi[̈ʒuƃXi[̑OʒuƃXi[̏ݒ肷
extern	int			Set3DSoundListenerVelocity(               VECTOR Velocity ) ;																	// RcTEh̃Xi[̈ړxݒ肷
extern	int			Set3DSoundListenerConeAngle(              float InnerAngle, float OuterAngle ) ;												// RcTEh̃Xi[̉px͈͂ݒ肷
extern	int			Set3DSoundListenerConeVolume(             float InnerAngleVolume, float OuterAngleVolume ) ;									// RcTEh̃Xi[̉px͈͂̉ʔ{ݒ肷

#ifndef DX_NON_BEEP
// BEEPĐp
extern	int			SetBeepFrequency(					int Freq ) ;																				// r[vgݒ֐
extern	int			PlayBeep(							void ) ;																					// r[vĐ
extern	int			StopBeep(							void ) ;																					// r[v~߂
#endif // DX_NON_BEEP

// bp[֐
extern	int			PlaySoundFile(						const TCHAR *FileName,                        int PlayType ) ;								// TEht@CĐ
extern	int			PlaySoundFileWithStrLen(			const TCHAR *FileName, size_t FileNameLength, int PlayType ) ;								// TEht@CĐ
#ifndef DX_COMPILE_TYPE_C_LANGUAGE
extern	int			PlaySound(							const TCHAR *FileName,                        int PlayType ) ;								// PlaySoundFile ̋
extern	int			PlaySoundWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int PlayType ) ;								// PlaySoundFile ̋
#endif // DX_COMPILE_TYPE_C_LANGUAGE
extern	int			PlaySoundDX(						const TCHAR *FileName,                        int PlayType ) ;								// PlaySoundFile ̋
extern	int			PlaySoundDXWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int PlayType ) ;								// PlaySoundFile ̋
extern	int			CheckSoundFile(						void ) ;																					// TEht@C̍Đǂ擾
extern	int			CheckSound(							void ) ;																					// CheckSoundFile ̋
extern	int			StopSoundFile(						void ) ;																					// TEht@C̍Đ~
extern	int			StopSound(							void ) ;																					// StopSoundFile ̋
extern	int			SetVolumeSoundFile(					int VolumePal ) ;																			// TEht@C̉ʂݒ肷
extern	int			SetVolumeSound(						int VolumePal ) ;																			// SetVolumeSound ̋

// \tgEGATEhn֐
extern	int			InitSoftSound(						void ) ;																					// \tgEGAňg`f[^nhׂč폜
extern	int			LoadSoftSound(						const TCHAR *FileName                        ) ;											// \tgEGAňg`f[^nhTEht@C쐬
extern	int			LoadSoftSoundWithStrLen(			const TCHAR *FileName, size_t FileNameLength ) ;											// \tgEGAňg`f[^nhTEht@C쐬
extern	int			LoadSoftSoundFromMemImage(			const void *FileImage, size_t FileImageSize ) ;												// \tgEGAňg`f[^nhɓWJꂽTEht@CC[W쐬
extern	int			MakeSoftSound(						int UseFormat_SoftSoundHandle, LONGLONG SampleNum ) ;										// \tgEGAň̔g`f[^nh쐬( tH[}bg͈̃\tgEGATEhnhƓ̂ɂ )
extern	int			MakeSoftSound2Ch16Bit44KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:2 ʎqrbg:16bit TvOg:44.1KHz )
extern	int			MakeSoftSound2Ch16Bit22KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:2 ʎqrbg:16bit TvOg:22KHz )
extern	int			MakeSoftSound2Ch8Bit44KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:2 ʎqrbg: 8bit TvOg:44.1KHz )
extern	int			MakeSoftSound2Ch8Bit22KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:2 ʎqrbg: 8bit TvOg:22KHz )
extern	int			MakeSoftSound1Ch16Bit44KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:1 ʎqrbg:16bit TvOg:44.1KHz )
extern	int			MakeSoftSound1Ch16Bit22KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:1 ʎqrbg:16bit TvOg:22KHz )
extern	int			MakeSoftSound1Ch8Bit44KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:1 ʎqrbg: 8bit TvOg:44.1KHz )
extern	int			MakeSoftSound1Ch8Bit22KHz(			LONGLONG SampleNum ) ;																		// \tgEGAň̔g`f[^nh쐬( `l:1 ʎqrbg: 8bit TvOg:22KHz )
extern	int			MakeSoftSoundCustom(				int ChannelNum, int BitsPerSample, int SamplesPerSec, LONGLONG SampleNum, int IsFloatType DEFAULTPARAM( = 0 ) ) ;	// \tgEGAň̔g`f[^nh쐬
extern	int			DeleteSoftSound(					int SoftSoundHandle ) ;																		// \tgEGAňg`f[^nh폜
#ifndef DX_NON_SAVEFUNCTION
extern	int			SaveSoftSound(						int SoftSoundHandle, const TCHAR *FileName                        ) ;						// \tgEGAňg`f[^nhWAVEt@C(PCM)`ŕۑ
extern	int			SaveSoftSoundWithStrLen(			int SoftSoundHandle, const TCHAR *FileName, size_t FileNameLength ) ;						// \tgEGAňg`f[^nhWAVEt@C(PCM)`ŕۑ
#endif // DX_NON_SAVEFUNCTION
extern	LONGLONG	GetSoftSoundSampleNum(				int SoftSoundHandle ) ;																		// \tgEGAňg`f[^nh̃Tv擾
extern	int			GetSoftSoundFormat(					int SoftSoundHandle, int *Channels, int *BitsPerSample, int *SamplesPerSec, int *IsFloatType DEFAULTPARAM( = NULL ) ) ;				// \tgEGAňg`f[^nh̃tH[}bg擾
extern	int			ReadSoftSoundData(					int SoftSoundHandle, LONGLONG SamplePosition, int   *Channel1, int   *Channel2 ) ;			// \tgEGAňg`f[^nh̃Tvǂݎ
extern	int			ReadSoftSoundDataF(					int SoftSoundHandle, LONGLONG SamplePosition, float *Channel1, float *Channel2 ) ;			// \tgEGAňg`f[^nh̃Tvǂݎ( float^ )
extern	int			WriteSoftSoundData(					int SoftSoundHandle, LONGLONG SamplePosition, int    Channel1, int    Channel2 ) ;			// \tgEGAňg`f[^nh̃Tv
extern	int			WriteSoftSoundDataF(				int SoftSoundHandle, LONGLONG SamplePosition, float  Channel1, float  Channel2 ) ;			// \tgEGAňg`f[^nh̃Tv( float^ )
extern	int			WriteTimeStretchSoftSoundData(		int SrcSoftSoundHandle, int DestSoftSoundHandle ) ;											// \tgEGAňg`f[^nh̔g`f[^ςɃf[^̒ύX
extern	int			WritePitchShiftSoftSoundData(		int SrcSoftSoundHandle, int DestSoftSoundHandle ) ;											// \tgEGAňg`f[^nh̔g`f[^̒ύX
extern	void*		GetSoftSoundDataImage(				int SoftSoundHandle ) ;																		// \tgEGAňg`f[^nh̔g`C[Wi[Ă郁AhX擾
extern	int			GetFFTVibrationSoftSound(			int SoftSoundHandle, int Channel, LONGLONG SamplePosition, int SampleNum, float *Buffer_Array, int BufferLength ) ;									// \tgEGAňg`f[^nh̎w͈̔͂t[GϊsAeg̐U擾( SampleNum  16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536 ̉ꂩłKv܂AChannel  -1 ɂƓ̃`lʂɂȂ܂ )
extern	int			GetFFTVibrationSoftSoundBase(		int SoftSoundHandle, int Channel, LONGLONG SamplePosition, int SampleNum, float *RealBuffer_Array, float *ImagBuffer_Array, int BufferLength ) ;	// \tgEGAňg`f[^nh̎w͈̔͂t[GϊsAeg̐U擾Aʂ̎ƋʁXɎ擾邱Ƃło[W( SampleNum  16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536 ̉ꂩłKv܂AChannel  -1 ɂƓ̃`lʂɂȂ܂ )

extern	int			InitSoftSoundPlayer(				void ) ;																					// \tgEGAňg`f[^̃vC[nhׂĉ
extern	int			MakeSoftSoundPlayer(				int UseFormat_SoftSoundHandle ) ;															// \tgEGAňg`f[^̃vC[nh쐬( tH[}bg͈̃\tgEGATEhnhƓ̂ɂ )
extern	int			MakeSoftSoundPlayer2Ch16Bit44KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:2 ʎqrbg:16bit TvOg:44.1KHz )
extern	int			MakeSoftSoundPlayer2Ch16Bit22KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:2 ʎqrbg:16bit TvOg:22KHz )
extern	int			MakeSoftSoundPlayer2Ch8Bit44KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:2 ʎqrbg: 8bit TvOg:44.1KHz )
extern	int			MakeSoftSoundPlayer2Ch8Bit22KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:2 ʎqrbg: 8bit TvOg:22KHz )
extern	int			MakeSoftSoundPlayer1Ch16Bit44KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:1 ʎqrbg:16bit TvOg:44.1KHz )
extern	int			MakeSoftSoundPlayer1Ch16Bit22KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:1 ʎqrbg:16bit TvOg:22KHz )
extern	int			MakeSoftSoundPlayer1Ch8Bit44KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:1 ʎqrbg: 8bit TvOg:44.1KHz )
extern	int			MakeSoftSoundPlayer1Ch8Bit22KHz(	void ) ;																					// \tgEGAňg`f[^̃vC[nh쐬( `l:1 ʎqrbg: 8bit TvOg:22KHz )
extern	int			MakeSoftSoundPlayerCustom(			int ChannelNum, int BitsPerSample, int SamplesPerSec ) ;									// \tgEGAňg`f[^̃vC[nh쐬
extern	int			DeleteSoftSoundPlayer(				int SSoundPlayerHandle ) ;																	// \tgEGAňg`f[^̃vC[nh폜
extern	int			AddDataSoftSoundPlayer(				int SSoundPlayerHandle, int SoftSoundHandle, LONGLONG AddSamplePosition, int AddSampleNum ) ;	// \tgEGAňg`f[^̃vC[nhɔg`f[^ǉ( tH[}bgł͂Ȃꍇ̓G[ )
extern	int			AddDirectDataSoftSoundPlayer(		int SSoundPlayerHandle, const void *SoundData, int AddSampleNum ) ;							// \tgEGAňg`f[^̃vC[nhɃvC[ΉtH[}bg̐g`f[^ǉ
extern	int			AddOneDataSoftSoundPlayer(			int SSoundPlayerHandle, int Channel1, int Channel2 ) ;										// \tgEGAňg`f[^̃vC[nhɔg`f[^ǉ
extern	int			GetSoftSoundPlayerFormat(			int SSoundPlayerHandle, int *Channels, int *BitsPerSample, int *SamplesPerSec ) ;			// \tgEGAňg`f[^̃vC[nhf[^tH[}bg擾
extern	int			StartSoftSoundPlayer(				int SSoundPlayerHandle ) ;																	// \tgEGAňg`f[^̃vC[nh̍ĐJn
extern	int			CheckStartSoftSoundPlayer(			int SSoundPlayerHandle ) ;																	// \tgEGAňg`f[^̃vC[nh̍ĐJnĂ邩擾( TRUE:JnĂ  FALSE:~Ă )
extern	int			StopSoftSoundPlayer(				int SSoundPlayerHandle ) ;																	// \tgEGAňg`f[^̃vC[nh̍Đ~
extern	int			ResetSoftSoundPlayer(				int SSoundPlayerHandle ) ;																	// \tgEGAňg`f[^̃vC[nh̏ԂԂɖ߂( ǉꂽg`f[^͍폜AĐԂꍇ͒~ )
extern	int			GetStockDataLengthSoftSoundPlayer(	int SSoundPlayerHandle, int *SoundBufferStockSamples DEFAULTPARAM( = NULL ) ) ;					// \tgEGAňg`f[^̃vC[nhɒǉg`f[^ł܂ĐpTEhobt@ɓ]ĂȂg`f[^̃Tv擾ASoundBufferStockSamples w肷ƍĐpTEhobt@ŖĐ̃TEhf[^̃Tv܂
extern	int			CheckSoftSoundPlayerNoneData(		int SSoundPlayerHandle ) ;																	// \tgEGAňg`f[^̃vC[nhɍĐpTEhobt@ɓ]ĂȂg`f[^AĐpTEhobt@ɂf[^ȊOǂ擾( TRUE:f[^ȊO  FALSE:Lf[^ )




// lhch֐
extern	int			DeleteMusicMem(						int MusicHandle ) ;																			// lhchnh폜
extern	int			LoadMusicMem(						const TCHAR *FileName                        ) ;											// lhcht@Cǂݍ݂lhchnh쐬
extern	int			LoadMusicMemWithStrLen(				const TCHAR *FileName, size_t FileNameLength ) ;											// lhcht@Cǂݍ݂lhchnh쐬
extern	int			LoadMusicMemByMemImage(				const void *FileImage, size_t FileImageSize ) ;												// ɓWJꂽlhcht@CC[Wlhchnh쐬
extern	int			PlayMusicMem(						int MusicHandle, int PlayType ) ;															// lhchnh̉tJn
extern	int			StopMusicMem(						int MusicHandle ) ;																			// lhchnh̉t~
extern	int			CheckMusicMem(						int MusicHandle ) ;																			// lhchnhtǂ擾( TRUE:t  FALSE:~ )
extern	int			SetVolumeMusicMem(					int Volume, int MusicHandle ) ;																// lhchnh̍ĐʂZbg
extern	int			GetMusicMemPosition(				int MusicHandle ) ;																			// lhchnȟ݂̍Đʒu擾
extern	int			InitMusicMem(						void ) ;																					// lhchnhׂč폜
extern	int			ProcessMusicMem(					void ) ;																					// lhchnh̎I( ŌĂ΂܂ )

extern	int			PlayMusic(							const TCHAR *FileName,                        int PlayType ) ;								// lhcht@Ct
extern	int			PlayMusicWithStrLen(				const TCHAR *FileName, size_t FileNameLength, int PlayType ) ;								// lhcht@Ct
extern	int			PlayMusicByMemImage(				const void *FileImage, size_t FileImageSize,  int PlayType ) ;								// ɓWJĂlhcht@Ct
extern	int			SetVolumeMusic(						int Volume ) ;																				// lhch̍ĐʂZbg
extern	int			StopMusic(							void ) ;																					// lhcht@C̉t~
extern	int			CheckMusic(							void ) ;																					// lhcht@Ctۂ擾
extern	int			GetMusicPosition(					void ) ;																					// lhcȟ݂̍Đʒu擾

extern	int			SelectMidiMode(						int Mode ) ;																				// lhch̍Đ`ݒ肷

#endif // DX_NON_SOUND










// DxArchive_.cpp ֐ vg^Cv錾
extern	int			SetUseDXArchiveFlag(				int Flag ) ;															// cwA[JCut@C̓ǂݍ݋@\gǂݒ肷( FALSE:gpȂ  TRUE:gp )
extern	int			SetDXArchivePriority(				int Priority DEFAULTPARAM( = 0 ) ) ;													// ̂cwA[JCut@CƃtH_݂ꍇAǂD悳邩ݒ肷( 1:tH_D@ 0:cwA[JCut@CD( ftHg ) )
extern	int			SetDXArchiveExtension(				const TCHAR *Extension DEFAULTPARAM( = NULL ) ) ;										// cwA[JCut@C̊gqݒ肷( Extension:gq )
extern	int			SetDXArchiveExtensionWithStrLen(	const TCHAR *Extension DEFAULTPARAM( = NULL ) , size_t ExtensionLength DEFAULTPARAM( = 0 ) ) ;			// cwA[JCut@C̊gqݒ肷( Extension:gq )
extern	int			SetDXArchiveKeyString(				const TCHAR *KeyString DEFAULTPARAM( = NULL ) ) ;										// cwA[JCut@Čݒ肷( KeyString: )
extern	int			SetDXArchiveKeyStringWithStrLen(	const TCHAR *KeyString DEFAULTPARAM( = NULL ) , size_t KeyStringLength DEFAULTPARAM( = 0 ) ) ;			// cwA[JCut@Čݒ肷( KeyString: )

extern	int			DXArchivePreLoad(					const TCHAR *FilePath,                        int ASync DEFAULTPARAM( = FALSE ) ) ;		// ŵcw`t@Cۂƃɓǂݍ( ߂l  -1:G[  0: )
extern	int			DXArchivePreLoadWithStrLen(			const TCHAR *FilePath, size_t FilePathLength, int ASync DEFAULTPARAM( = FALSE ) ) ;		// ŵcw`t@Cۂƃɓǂݍ( ߂l  -1:G[  0: )
extern	int			DXArchiveCheckIdle(					const TCHAR *FilePath                        ) ;						// ŵcw`t@C̎Oǂݍ݂ǂ擾( ߂l  TRUE: FALSE:܂ )
extern	int			DXArchiveCheckIdleWithStrLen(		const TCHAR *FilePath, size_t FilePathLength ) ;						// ŵcw`t@C̎Oǂݍ݂ǂ擾( ߂l  TRUE: FALSE:܂ )
extern	int			DXArchiveRelease(					const TCHAR *FilePath                        ) ;						// ŵcw`t@C
extern	int			DXArchiveReleaseWithStrLen(			const TCHAR *FilePath, size_t FilePathLength ) ;						// ŵcw`t@C
extern	int			DXArchiveCheckFile(					const TCHAR *FilePath,                        const TCHAR *TargetFilePath                              ) ;	// cw`t@C̒Ɏw̃t@C݂邩ǂ𒲂ׂATargetFilePath ͂cw`t@CJgtH_Ƃꍇ̃pX( ߂l:  -1=G[  0:  1: )
extern	int			DXArchiveCheckFileWithStrLen(		const TCHAR *FilePath, size_t FilePathLength, const TCHAR *TargetFilePath, size_t TargetFilePathLength ) ;	// cw`t@C̒Ɏw̃t@C݂邩ǂ𒲂ׂATargetFilePath ͂cw`t@CJgtH_Ƃꍇ̃pX( ߂l:  -1=G[  0:  1: )
extern	int			DXArchiveSetMemImage(				void *ArchiveImage, int ArchiveImageSize, const TCHAR *EmulateFilePath,                               int ArchiveImageCopyFlag DEFAULTPARAM( = FALSE ) , int ArchiveImageReadOnly DEFAULTPARAM( = TRUE ) ) ;	// ɓWJꂽcw`t@Cw̃t@CpXɂ邱Ƃɂ( EmulateFilePath ͌Ă dxa t@C̃pXAႦ΂cw`t@CC[W Image.dxa Ƃt@C c:\Temp ɂ邱Ƃɂꍇ EmulateFilePath  "c:\\Temp\\Image.dxa" nASetDXArchiveExtension ŊgqύXĂꍇ EmulateFilePath ɓnt@CpX̊gqɍ킹Kv )
extern	int			DXArchiveSetMemImageWithStrLen(		void *ArchiveImage, int ArchiveImageSize, const TCHAR *EmulateFilePath, size_t EmulateFilePathLength, int ArchiveImageCopyFlag DEFAULTPARAM( = FALSE ) , int ArchiveImageReadOnly DEFAULTPARAM( = TRUE ) ) ;	// ɓWJꂽcw`t@Cw̃t@CpXɂ邱Ƃɂ( EmulateFilePath ͌Ă dxa t@C̃pXAႦ΂cw`t@CC[W Image.dxa Ƃt@C c:\Temp ɂ邱Ƃɂꍇ EmulateFilePath  "c:\\Temp\\Image.dxa" nASetDXArchiveExtension ŊgqύXĂꍇ EmulateFilePath ɓnt@CpX̊gqɍ킹Kv )
extern	int			DXArchiveReleaseMemImage(			void *ArchiveImage ) ;													// DXArchiveSetMemImage ̐ݒ

extern	DWORD		HashCRC32(							const void *SrcData, size_t SrcDataSize ) ;								// oCif[^ CRC32 ̃nbVlvZ





















// DxModel.cpp ֐ vg^Cv錾

#ifndef DX_NON_MODEL

// f̓ǂݍ݁E֌W
extern	int			MV1LoadModel(						const TCHAR *FileName ) ;											// f̓ǂݍ( -1:G[  0ȏ:fnh )
extern	int			MV1LoadModelWithStrLen(				const TCHAR *FileName, size_t FileNameLength ) ;					// f̓ǂݍ( -1:G[  0ȏ:fnh )
extern	int			MV1LoadModelFromMem(				const void *FileImage, int FileSize, int (* FileReadFunc )( const TCHAR *FilePath, void **FileImageAddr, int *FileSize, void *FileReadFuncData ), int (* FileReleaseFunc )( void *MemoryAddr, void *FileReadFuncData ), void *FileReadFuncData DEFAULTPARAM( = NULL ) ) ;	// ̃ft@CC[WƓƎ̓ǂݍ݃[`gpăfǂݍ
extern	int			MV1DuplicateModel(					int SrcMHandle ) ;													// w̃fƓf{f[^gpăf쐬( -1:G[  0ȏ:fnh )
extern	int			MV1CreateCloneModel(				int SrcMHandle ) ;													// w̃ff{f[^܂ߕ( MV1DuplicateModel ̓f{f[^͋L܂Ã͕fƂ͈؋Lf[^̖fnh쐬܂ )( -1:G[  0ȏ:fnh )
extern	int			MV1CreateSimpleModel(				VERTEX3D *Vertex, int VertexNum, unsigned int *Index, int IndexNum, MATERIALPARAM *Material, int GrHandle ) ;		// w̒_f[^ƃ}eAAeNX`gpVvȂRcf̃nh쐬

extern	int			MV1DeleteModel(						int MHandle ) ;														// f폜
extern	int			MV1InitModel(						void ) ;															// ׂẴf폜

extern	int			MV1SetLoadModelReMakeNormal(						int Flag ) ;														// fǂݍލۂɖ@̍ČvZsǂݒ肷( TRUE:s  FALSE:sȂ( ftHg ) )
extern	int			MV1SetLoadModelReMakeNormalSmoothingAngle(			float SmoothingAngle DEFAULTPARAM( = 1.562069f ) ) ;				// fǂݍލۂɍs@̍ČvZŎgpX[WOpxݒ肷( Pʂ̓WA )
extern	int			MV1SetLoadModelIgnoreScaling(						int Flag ) ;														// fǂݍލۂɃXP[Of[^𖳎邩ǂݒ肷( TRUE:  FALSE:Ȃ( ftHg ) )
extern	int			MV1SetLoadModelPositionOptimize(					int Flag ) ;														// fǂݍލۂɍWf[^̍œKsǂݒ肷( TRUE:s  FALSE:sȂ( ftHg ) )
extern	int			MV1SetLoadModelNotEqNormalSide_AddZeroAreaPolygon(	int Flag ) ;														// fǂݍލۂɃ|S̕ӂڂĂāA@̕قȂӂɖʐςÕ|S𖄂ߍނǂݒ肷( TRUE:ߍށ@FALSE:ߍ܂Ȃ( ftHg ) )A( MV1t@C̓ǂݍ݂ł͂̊֐̐ݒ͖A|S̖ߍ݂͎s܂ )
extern	int			MV1SetLoadModelUsePhysicsMode(						int PhysicsMode /* DX_LOADMODEL_PHYSICS_LOADCALC  */ ) ;			// ǂݍރf̕Z[hݒ肷
extern	int			MV1SetLoadModelPhysicsWorldGravity(					float Gravity ) ;													// ǂݍރf̕ZɓKpd̓p[^ݒ肷
extern	float		MV1GetLoadModelPhysicsWorldGravity(					void ) ;															// ǂݍރf̕ZɓKpd̓p[^擾
extern	int			MV1SetLoadCalcPhysicsWorldGravity(					int GravityNo, VECTOR Gravity ) ;									// ǂݍރf̕Z[hOvZ( DX_LOADMODEL_PHYSICS_LOADCALC )ꍇɓKpd͂̐ݒ
extern	VECTOR		MV1GetLoadCalcPhysicsWorldGravity(					int GravityNo ) ;													// ǂݍރf̕Z[hOvZ( DX_LOADMODEL_PHYSICS_LOADCALC )ꍇɓKpd͂擾
extern	int			MV1SetLoadModelPhysicsCalcPrecision(				int Precision ) ;													// ǂݍރf̕Z[hOvZ( DX_LOADMODEL_PHYSICS_LOADCALC )ꍇɓKp镨Z̎Ԑis̐xݒ肷( 0:60FPS  1:120FPS  2:240FPS  3:480FPS  4:960FPS  5:1920FPS )
extern	int			MV1SetLoadModel_PMD_PMX_AnimationFPSMode(			int FPSMode /* DX_LOADMODEL_PMD_PMX_ANIMATION_FPSMODE_30  */ ) ;	// PMD, PMX t@Cǂݍ񂾍ۂ̃Aj[V FPS [hݒ肷
extern	int			MV1AddLoadModelDisablePhysicsNameWord(				const TCHAR *NameWord ) ;											// ǂݍރf̕Z̍̂̂ݖɂ邽߂̖Õ[hǉAǉł郏[h̍ő咷 63 Aǉł郏[h͍̐ő 256 
extern	int			MV1AddLoadModelDisablePhysicsNameWordWithStrLen(	const TCHAR *NameWord, size_t NameWordLength ) ;					// ǂݍރf̕Z̍̂̂ݖɂ邽߂̖Õ[hǉAǉł郏[h̍ő咷 63 Aǉł郏[h͍̐ő 256 
extern	int			MV1ResetLoadModelDisablePhysicsNameWord(			void ) ;															// MV1AddLoadModelDisablePhysicsNameWord Œǉ̖̂[hZbgĖ[h̏Ԃɖ߂
extern	int			MV1SetLoadModelDisablePhysicsNameWordMode(			int DisableNameWordMode /* DX_LOADMODEL_PHYSICS_DISABLENAMEWORD_ALWAYS  */ ) ;	// MV1AddLoadModelDisablePhysicsNameWord Œǉ̖̂[h̓Kp[ύX
extern	int			MV1SetLoadModelAnimFilePath(						const TCHAR *FileName ) ;											// ǂݍރfɓKpAj[Vt@C̃pXݒ肷ANULLnƐݒ胊Zbg( ݂ PMD,PMX ݂̂Ɍʂ )
extern	int			MV1SetLoadModelAnimFilePathWithStrLen(				const TCHAR *FileName, size_t FileNameLength ) ;					// ǂݍރfɓKpAj[Vt@C̃pXݒ肷ANULLnƐݒ胊Zbg( ݂ PMD,PMX ݂̂Ɍʂ )
extern	int			MV1SetLoadModelUsePackDraw(							int Flag ) ;														// ǂݍރf𓯎`ɑΉ邩ǂݒ肷( TRUE:Ή  FALSE:ΉȂ( ftHg ) )A( uΉvɂƕ`悪ɂȂ\ɏVRAM܂ )
extern	int			MV1SetLoadModelTriangleListUseMaxBoneNum(			int UseMaxBoneNum ) ;												// ǂݍރf̂ЂƂ̃gCAOXgŎgpłő{[ݒ肷( UseMaxBoneNum Ŏwłl͈̔͂ 8 ` 54A 0 w肷ƃftHgɖ߂ )
extern	int			MV1SetLoadModelTextureLoad(							int Flag ) ;														// ǂݍރfŎgpeNX`t@Cǂݍނǂݒ肷( TRUE:ǂݍ(ftHg) FALSE:ǂݍ܂Ȃ )
extern	int			MV1SetLoadModelIgnoreIK(							int IgnoreFlag ) ;													// ǂݍރfIK𖳎邩ǂݒ肷( TRUE:  FALSE:Ȃ(ftHg) )

// fۑ֌W
extern	int			MV1SaveModelToMV1File(				int MHandle, const TCHAR *FileName,                        int SaveType DEFAULTPARAM( = MV1_SAVETYPE_NORMAL ) , int AnimMHandle DEFAULTPARAM( = -1 ) , int AnimNameCheck DEFAULTPARAM( = TRUE ) , int Normal8BitFlag DEFAULTPARAM( = 1 ) , int Position16BitFlag DEFAULTPARAM( = 1 ) , int Weight8BitFlag DEFAULTPARAM( = 0 ) , int Anim16BitFlag DEFAULTPARAM( = 1 ) ) ;		// w̃pXɃfۑ( ߂l  0:  -1:s  -2:gĂȂAj[V )
extern	int			MV1SaveModelToMV1FileWithStrLen(	int MHandle, const TCHAR *FileName, size_t FileNameLength, int SaveType DEFAULTPARAM( = MV1_SAVETYPE_NORMAL ) , int AnimMHandle DEFAULTPARAM( = -1 ) , int AnimNameCheck DEFAULTPARAM( = TRUE ) , int Normal8BitFlag DEFAULTPARAM( = 1 ) , int Position16BitFlag DEFAULTPARAM( = 1 ) , int Weight8BitFlag DEFAULTPARAM( = 0 ) , int Anim16BitFlag DEFAULTPARAM( = 1 ) ) ;		// w̃pXɃfۑ( ߂l  0:  -1:s  -2:gĂȂAj[V )
#ifndef DX_NON_SAVEFUNCTION
extern	int			MV1SaveModelToXFile(				int MHandle, const TCHAR *FileName,                        int SaveType DEFAULTPARAM( = MV1_SAVETYPE_NORMAL ) , int AnimMHandle DEFAULTPARAM( = -1 ) , int AnimNameCheck DEFAULTPARAM( = TRUE ) ) ;	// w̃pXɃfwt@C`ŕۑ( ߂l  0:  -1:s  -2:gĂȂAj[V )
extern	int			MV1SaveModelToXFileWithStrLen(		int MHandle, const TCHAR *FileName, size_t FileNameLength, int SaveType DEFAULTPARAM( = MV1_SAVETYPE_NORMAL ) , int AnimMHandle DEFAULTPARAM( = -1 ) , int AnimNameCheck DEFAULTPARAM( = TRUE ) ) ;	// w̃pXɃfwt@C`ŕۑ( ߂l  0:  -1:s  -2:gĂȂAj[V )
#endif // DX_NON_SAVEFUNCTION

// f`֌W
extern	int			MV1DrawModel(						int MHandle ) ;														// f`悷
extern	int			MV1DrawFrame(						int MHandle, int FrameIndex ) ;										// f̎w̃t[`悷
extern	int			MV1DrawMesh(						int MHandle, int MeshIndex ) ;										// f̎w̃bV`悷
extern	int			MV1DrawTriangleList(				int MHandle, int TriangleListIndex ) ;								// f̎w̃gCAOXg`悷
extern	int			MV1DrawModelDebug(					int MHandle, unsigned int Color, int IsNormalLine, float NormalLineLength, int IsPolyLine, int IsCollisionBox ) ;	// f̃fobO`

// `ݒ֌W
extern	int			MV1SetUseOrigShader(				int UseFlag ) ;														// f̕` SetUseVertexShader, SetUsePixelShader Ŏw肵VF[_[gp邩ǂݒ肷( TRUE:gp  FALSE:gpȂ( ftHg ) )
extern	int			MV1SetDrawMode(						int DrawMode /* DX_MV1_DRAWMODE_NORMAL  */ ) ;					// f̕`惂[h̐ݒ
extern	int			MV1SetSemiTransDrawMode(			int DrawMode /* DX_SEMITRANSDRAWMODE_ALWAYS  */ ) ;				// f̔vf镔ɂĂ̕`惂[hݒ肷

// f{֌W
extern	MATRIX		MV1GetLocalWorldMatrix(				int MHandle ) ;														// f̃[JW烏[hWɕϊs𓾂
extern	MATRIX_D	MV1GetLocalWorldMatrixD(			int MHandle ) ;														// f̃[JW烏[hWɕϊs𓾂
extern	int			MV1SetPosition(						int MHandle, VECTOR   Position ) ;									// f̍WZbg
extern	int			MV1SetPositionD(					int MHandle, VECTOR_D Position ) ;									// f̍WZbg
extern	VECTOR		MV1GetPosition(						int MHandle ) ;														// f̍W擾
extern	VECTOR_D	MV1GetPositionD(					int MHandle ) ;														// f̍W擾
extern	int			MV1SetScale(						int MHandle, VECTOR Scale ) ;										// f̊glZbg
extern	VECTOR		MV1GetScale(						int MHandle ) ;														// f̊gl擾
extern	int			MV1SetRotationXYZ(					int MHandle, VECTOR Rotate ) ;										// f̉]lZbg( X]Y]Z] )
extern	VECTOR		MV1GetRotationXYZ(					int MHandle ) ;														// f̉]l擾( X]Y]Z] )
extern	int			MV1SetRotationZYAxis(				int MHandle, VECTOR ZAxisDirection, VECTOR YAxisDirection, float ZAxisTwistRotate ) ;	// f̂yƂx̌Zbg
extern	int			MV1SetRotationYUseDir(				int MHandle, VECTOR Direction, float OffsetYAngle ) ;				// f̂x̉]lw̃xNǧɐݒ肷AfZ̃}CiXĂ邱Ƃz肷̂ŁAł͂Ȃꍇ OffsetYAngle ŕ␳Aw]Ay]͂OŌŒ
extern	int			MV1SetRotationMatrix(				int MHandle, MATRIX Matrix ) ;										// f̉]psZbg
extern	MATRIX		MV1GetRotationMatrix(				int MHandle ) ;														// f̉]ps擾
extern	int			MV1SetMatrix(						int MHandle, MATRIX   Matrix ) ;									// f̕ό`psZbg
extern	int			MV1SetMatrixD(						int MHandle, MATRIX_D Matrix ) ;									// f̕ό`psZbg
extern	MATRIX		MV1GetMatrix(						int MHandle ) ;														// f̕ό`ps擾
extern	MATRIX_D	MV1GetMatrixD(						int MHandle ) ;														// f̕ό`ps擾
extern	int			MV1SetVisible(						int MHandle, int VisibleFlag ) ;									// f̕\A\ԂύX( TRUE:\  FALSE:\ )
extern	int			MV1GetVisible(						int MHandle ) ;														// f̕\A\Ԃ擾( TRUE:\  FALSE:\ )
extern	int			MV1SetMeshCategoryVisible(			int MHandle, int MeshCategory, int VisibleFlag ) ;					// f̃bV̎( DX_MV1_MESHCATEGORY_NORMAL Ȃ )̕\A\ݒ肷( TRUE:\  FALSE:\ )
extern	int			MV1GetMeshCategoryVisible(			int MHandle, int MeshCategory ) ;									// f̃bV̎( DX_MV1_MESHCATEGORY_NORMAL Ȃ )̕\A\擾( TRUE:\  FALSE:\ )
extern	int			MV1SetDifColorScale(				int MHandle, COLOR_F Scale ) ;										// f̃fBt[YJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	COLOR_F		MV1GetDifColorScale(				int MHandle ) ;														// f̃fBt[YJ[̃XP[l擾( ftHgl 1.0f )
extern	int			MV1SetSpcColorScale(				int MHandle, COLOR_F Scale ) ;										// f̃XyLJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	COLOR_F		MV1GetSpcColorScale(				int MHandle ) ;														// f̃XyLJ[̃XP[l擾( ftHgl 1.0f )
extern	int			MV1SetEmiColorScale(				int MHandle, COLOR_F Scale ) ;										// f̃G~bVuJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	COLOR_F		MV1GetEmiColorScale(				int MHandle ) ;														// f̃G~bVuJ[̃XP[l擾( ftHgl 1.0f )
extern	int			MV1SetAmbColorScale(				int MHandle, COLOR_F Scale ) ;										// f̃ArGgJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	COLOR_F		MV1GetAmbColorScale(				int MHandle ) ;														// f̃ArGgJ[̃XP[l擾( ftHgl 1.0f )
extern	int			MV1GetSemiTransState(				int MHandle ) ;														// fɔvf邩ǂ擾( ߂l TRUE:  FALSE:Ȃ )
extern	int			MV1SetOpacityRate(					int MHandle, float Rate ) ;											// f̕sxݒ肷( s 1.0f `  0.0f )
extern	float		MV1GetOpacityRate(					int MHandle ) ;														// f̕sx擾( s 1.0f `  0.0f )
extern	int			MV1SetUseDrawMulAlphaColor(			int MHandle, int Flag ) ;											// f`悷ۂRGBlɑ΂AlZ邩ǂݒ肷( `挋ʂZς݃At@摜ɂȂ܂ )( Flag   TRUE:RGBlɑ΂AlZ  FALSE:ZȂ(ftHg) )
extern	int			MV1GetUseDrawMulAlphaColor(			int MHandle ) ;														// f`悷ۂRGBlɑ΂AlZ邩ǂ擾( `挋ʂZς݃At@摜ɂȂ܂ )( ߂l TRUE:RGBlɑ΂AlZ  FALSE:ZȂ(ftHg) )
extern	int			MV1SetUseZBuffer(					int MHandle, int Flag ) ;											// f`悷ۂɂyobt@gp邩ǂݒ肷
extern	int			MV1SetWriteZBuffer(					int MHandle, int Flag ) ;											// f`悷ۂɂyobt@ɏ݂sǂݒ肷
extern	int			MV1SetZBufferCmpType(				int MHandle, int CmpType /* DX_CMP_NEVER  */ ) ;					// f̕`掞̂yl̔r[hݒ肷
extern	int			MV1SetZBias(						int MHandle, int Bias ) ;											// f̕`掞̏ނyl̃oCAXݒ肷
extern	int			MV1SetUseVertDifColor(				int MHandle, int UseFlag ) ;										// f̊܂܂郁bV̒_fBt[YJ[}eÃfBt[YJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
extern	int			MV1SetUseVertSpcColor(				int MHandle, int UseFlag ) ;										// fɊ܂܂郁bV̒_XyLJ[}eÃXyLJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
extern	int			MV1SetSampleFilterMode(				int MHandle, int FilterMode ) ;										// f̃eNX`̃TvtB^[[hύX( FilterMode  DX_DRAWMODE_NEAREST  )
extern	int			MV1SetMaxAnisotropy(				int MHandle, int MaxAnisotropy ) ;									// fٕ̈tB^O̍ő原ݒ肷
extern	int			MV1SetWireFrameDrawFlag(			int MHandle, int Flag ) ;											// fC[t[ŕ`悷邩ǂݒ肷
extern	int			MV1RefreshVertColorFromMaterial(	int MHandle ) ;														// f̒_J[ݐݒ肳Ă}eÃJ[ɂ
extern	int			MV1SetPhysicsWorldGravity(			int MHandle, VECTOR Gravity ) ;										// f̕Z̏d͂ݒ肷
extern	int			MV1PhysicsCalculation(				int MHandle, float MillisecondTime ) ;								// f̕Zw莞ԕo߂Ɖ肵ČvZ( MillisecondTime Ŏw肷鎞Ԃ̒Pʂ̓~b )
extern	int			MV1PhysicsResetState(				int MHandle ) ;														// f̕Z̏ԂZbg( ʒu[vƂp )
extern	int			MV1SetPrioritizePhysicsOverAnimFlag( int MHandle, int Flag ) ;											// f̕ZAj[VD悷邩ǂݒ肷( TRUE:ZD悷  FALSE:Aj[VD悷( ftHg ) )
extern	int			MV1SetUseShapeFlag(					int MHandle, int UseFlag ) ;										// f̃VFCv@\gp邩ǂݒ肷( UseFlag  TRUE:gp( ftHg )  FALSE:gpȂ )
extern	int			MV1GetMaterialNumberOrderFlag(		int MHandle ) ;														// f̃}eAԍɃbV`悷邩ǂ̃tO擾( TRUE:}eAԍɕ`  FALSE:sbV̌㔼bV )

// Aj[V֌W
extern	int			MV1AttachAnim(						int MHandle, int AnimIndex, int AnimSrcMHandle DEFAULTPARAM( = -1 ) , int NameCheck DEFAULTPARAM( = TRUE ) ) ;		// Aj[VA^b`( ߂l  -1:G[  0ȏ:A^b`CfbNX )
extern	int			MV1DetachAnim(						int MHandle, int AttachIndex ) ;													// Aj[Vf^b`
extern	int			MV1SetAttachAnimTime(				int MHandle, int AttachIndex, float Time ) ;										// A^b`ĂAj[V̍ĐԂݒ肷
extern	float		MV1GetAttachAnimTime(				int MHandle, int AttachIndex ) ;													// A^b`ĂAj[V̍ĐԂ擾
extern	float		MV1GetAttachAnimTotalTime(			int MHandle, int AttachIndex ) ;													// A^b`ĂAj[V̑Ԃ𓾂
extern	int			MV1SetAttachAnimBlendRate(			int MHandle, int AttachIndex, float Rate DEFAULTPARAM( = 1.0f ) ) ;					// A^b`ĂAj[Ṽuhݒ肷
extern	float		MV1GetAttachAnimBlendRate(			int MHandle, int AttachIndex ) ;													// A^b`ĂAj[Ṽuh擾
extern	int			MV1SetAttachAnimBlendRateToFrame(	int MHandle, int AttachIndex, int FrameIndex, float Rate, int SetChild DEFAULTPARAM( = TRUE ) ) ;	// A^b`ĂAj[Ṽuhݒ肷( t[P )
extern	float		MV1GetAttachAnimBlendRateToFrame(	int MHandle, int AttachIndex, int FrameIndex ) ;									// A^b`ĂAj[Ṽuh擾( t[P )
extern	int			MV1SetAttachAnimTimeToFrame(		int MHandle, int AttachIndex, int FrameIndex, float Time, int SetChild DEFAULTPARAM( = TRUE ) ) ;	// A^b`ĂAj[V̍ĐԂݒ肷( t[P )( Time Ƀ}CiX̒lnƐݒ )
extern	float		MV1GetAttachAnimTimeToFrame(		int MHandle, int AttachIndex, int FrameIndex ) ;									// A^b`ĂAj[V̍ĐԂ擾( t[P )
extern	int			MV1GetAttachAnim(					int MHandle, int AttachIndex ) ;													// A^b`ĂAj[ṼAj[VCfbNX擾
extern	int			MV1SetAttachAnimUseShapeFlag(		int MHandle, int AttachIndex, int UseFlag ) ;										// A^b`ĂAj[ṼVFCvgp邩ǂݒ肷( UseFlag  TRUE:gp( ftHg )  FALSE:gpȂ )
extern	int			MV1GetAttachAnimUseShapeFlag(		int MHandle, int AttachIndex ) ;													// A^b`ĂAj[ṼVFCvgp邩ǂ擾
extern	VECTOR		MV1GetAttachAnimFrameLocalPosition(	int MHandle, int AttachIndex, int FrameIndex ) ;									// A^b`ĂAj[V̎w̃t[݂̌̃[JW擾
extern	MATRIX		MV1GetAttachAnimFrameLocalMatrix(	int MHandle, int AttachIndex, int FrameIndex ) ;									// A^b`ĂAj[V̎w̃t[݂̌̃[Jϊs擾

extern	int			MV1GetAnimNum(						int MHandle ) ;																		// Aj[V̐擾
extern	const TCHAR *MV1GetAnimName(					int MHandle, int AnimIndex ) ;														// wԍ̃Aj[V擾( NULL:G[ )
extern	int			MV1SetAnimName(						int MHandle, int AnimIndex, const TCHAR *AnimName                        ) ;		// wԍ̃Aj[VύX
extern	int			MV1SetAnimNameWithStrLen(			int MHandle, int AnimIndex, const TCHAR *AnimName, size_t AnimNameLength ) ;		// wԍ̃Aj[VύX
extern	int			MV1GetAnimIndex(					int MHandle, const TCHAR *AnimName                        ) ;						// w薼̃Aj[Vԍ擾( -1:G[ )
extern	int			MV1GetAnimIndexWithStrLen(			int MHandle, const TCHAR *AnimName, size_t AnimNameLength ) ;						// w薼̃Aj[Vԍ擾( -1:G[ )
extern	float		MV1GetAnimTotalTime(				int MHandle, int AnimIndex ) ;														// wԍ̃Aj[V̑Ԃ𓾂
extern	int			MV1GetAnimTargetFrameNum(			int MHandle, int AnimIndex ) ;														// w̃Aj[V^[QbgƂt[̐擾
extern	const TCHAR *MV1GetAnimTargetFrameName(			int MHandle, int AnimIndex, int AnimFrameIndex ) ;									// w̃Aj[V^[QbgƂt[̖O擾
extern	int			MV1GetAnimTargetFrame(				int MHandle, int AnimIndex, int AnimFrameIndex ) ;									// w̃Aj[V^[QbgƂt[̔ԍ擾
extern	int			MV1GetAnimTargetFrameKeySetNum(		int MHandle, int AnimIndex, int AnimFrameIndex ) ;									// w̃Aj[V^[QbgƂt[p̃Aj[VL[Zbg̐擾
extern	int			MV1GetAnimTargetFrameKeySet(		int MHandle, int AnimIndex, int AnimFrameIndex, int Index ) ;						// w̃Aj[V^[QbgƂt[p̃Aj[VL[ZbgL[ZbgCfbNX擾

extern	int			MV1GetAnimKeySetNum(				int MHandle ) ;																		// fɊ܂܂Aj[VL[Zbg̑𓾂 
extern	int			MV1GetAnimKeySetType(				int MHandle, int AnimKeySetIndex ) ;												// w̃Aj[VL[Zbg̃^Cv擾( MV1_ANIMKEY_TYPE_QUATERNION  )
extern	int			MV1GetAnimKeySetDataType(			int MHandle, int AnimKeySetIndex ) ;												// w̃Aj[VL[Zbg̃f[^^Cv擾( MV1_ANIMKEY_DATATYPE_ROTATE  )
extern	int			MV1GetAnimKeySetTimeType(			int MHandle, int AnimKeySetIndex ) ;												// w̃Aj[VL[Zbg̃L[̎ԃf[^^Cv擾( MV1_ANIMKEY_TIME_TYPE_ONE  )
extern	int			MV1GetAnimKeySetDataNum(			int MHandle, int AnimKeySetIndex ) ;												// w̃Aj[VL[Zbg̃L[̐擾
extern	float		MV1GetAnimKeyDataTime(				int MHandle, int AnimKeySetIndex, int Index ) ;										// w̃Aj[VL[Zbg̃L[̎Ԃ擾
extern	int			MV1GetAnimKeyDataIndexFromTime(		int MHandle, int AnimKeySetIndex, float Time ) ;									// w̃Aj[VL[Zbg̎w̎Ԃł̃L[̔ԍ擾
extern	FLOAT4		MV1GetAnimKeyDataToQuaternion(		int MHandle, int AnimKeySetIndex, int Index ) ;										// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_QUATERNION ł͖ꍇ͎s
extern	FLOAT4		MV1GetAnimKeyDataToQuaternionFromTime( int MHandle, int AnimKeySetIndex, float Time ) ;									// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_QUATERNION ł͖ꍇ͎s( Ԏw )
extern	VECTOR		MV1GetAnimKeyDataToVector(			int MHandle, int AnimKeySetIndex, int Index ) ;										// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_VECTOR ł͖ꍇ͎s
extern	VECTOR		MV1GetAnimKeyDataToVectorFromTime(	int MHandle, int AnimKeySetIndex, float Time ) ;									// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_VECTOR ł͖ꍇ͎s( Ԏw )
extern	MATRIX		MV1GetAnimKeyDataToMatrix(			int MHandle, int AnimKeySetIndex, int Index ) ;										// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_MATRIX4X4C  MV1_ANIMKEY_TYPE_MATRIX3X3 ł͖ꍇ͎s
extern	MATRIX		MV1GetAnimKeyDataToMatrixFromTime(	int MHandle, int AnimKeySetIndex, float Time ) ;									// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_MATRIX4X4C  MV1_ANIMKEY_TYPE_MATRIX3X3 ł͖ꍇ͎s( Ԏw )
extern	float		MV1GetAnimKeyDataToFlat(			int MHandle, int AnimKeySetIndex, int Index ) ;										// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_FLAT ł͖ꍇ͎s
extern	float		MV1GetAnimKeyDataToFlatFromTime(	int MHandle, int AnimKeySetIndex, float Time ) ;									// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_FLAT ł͖ꍇ͎s( Ԏw )
extern	float		MV1GetAnimKeyDataToLinear(			int MHandle, int AnimKeySetIndex, int Index ) ;										// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_LINEAR ł͖ꍇ͎s
extern	float		MV1GetAnimKeyDataToLinearFromTime(	int MHandle, int AnimKeySetIndex, float Time ) ;									// w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_LINEAR ł͖ꍇ͎s( Ԏw )

// }eA֌W
extern	int			MV1GetMaterialNum(					int MHandle ) ;															// fŎgpĂ}eA̐擾
extern	const TCHAR *MV1GetMaterialName(				int MHandle, int MaterialIndex ) ;										// w̃}eA̖O擾
extern	int			MV1SetMaterialTypeAll(				int MHandle,                    int Type ) ;							// SẴ}eÃ^CvύX( Type : DX_MATERIAL_TYPE_NORMAL Ȃ )
extern	int			MV1SetMaterialType(					int MHandle, int MaterialIndex, int Type ) ;							// w̃}eÃ^CvύX( Type : DX_MATERIAL_TYPE_NORMAL Ȃ )
extern	int			MV1GetMaterialType(					int MHandle, int MaterialIndex ) ;										// w̃}eÃ^Cv擾( ߂l : DX_MATERIAL_TYPE_NORMAL Ȃ )
extern	int			MV1SetMaterialTypeParamAll(			int MHandle,                    ... ) ;									// SẴ}eÃ^Cvʃp[^ύX( }eA^Cv DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_TWO_COLOR ȂǂŎgp )
extern	int			MV1SetMaterialTypeParam(			int MHandle, int MaterialIndex, ... ) ;									// w̃}eÃ^Cvʃp[^ύX( }eA^Cv DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_TWO_COLOR ȂǂŎgp )
//		int			MV1SetMaterialTypeParam(			int MHandle, int MaterialIndex, /* DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_UNORM            ̏ꍇ */ float MinParam = K̉l( ̒lȉ 0.0f ɂȂ ), float MaxParam = K̏l( ̒lȏオ 1.0f ɂȂ ) ) ;
//		int			MV1SetMaterialTypeParam(			int MHandle, int MaterialIndex, /* DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_CLIP_UNORM       ̏ꍇ */ float MinParam = K̉l( ̒lȉ 0.0f ɂȂ ), float MaxParam = K̏l( ̒lȏオ 1.0f ɂȂ ), float ClipParam = 臒l( ̒l 0.0f ɂȂ ) ) ;
//		int			MV1SetMaterialTypeParam(			int MHandle, int MaterialIndex, /* DX_MATERIAL_TYPE_MAT_SPEC_LUMINANCE_CMP_GREATEREQUAL ̏ꍇ */ float CmpParam = rl( ̒lȏ̏ꍇ 1.0f Ȁꍇ 0.0f ܂ ) ) ;
//		int			MV1SetMaterialTypeParam(			int MHandle, int MaterialIndex, /* DX_MATERIAL_TYPE_MAT_SPEC_POWER_UNORM                ̏ꍇ */ float MinParam = K̉l( ̒lȉ 0.0f ɂȂ ), float MaxParam = K̏l( ̒lȏオ 1.0f ɂȂ ) ) ;
//		int			MV1SetMaterialTypeParam(			int MHandle, int MaterialIndex, /* DX_MATERIAL_TYPE_MAT_SPEC_POWER_CLIP_UNORM           ̏ꍇ */ float MinParam = K̉l( ̒lȉ 0.0f ɂȂ ), float MaxParam = K̏l( ̒lȏオ 1.0f ɂȂ ), float ClipParam = 臒l( ̒l 0.0f ɂȂ ) ) ;
//		int			MV1SetMaterialTypeParam(			int MHandle, int MaterialIndex, /* DX_MATERIAL_TYPE_MAT_SPEC_POWER_CMP_GREATEREQUAL     ̏ꍇ */ float CmpParam = rl( ̒lȏ̏ꍇ 1.0f Ȁꍇ 0.0f ܂ ) ) ;
extern	int			MV1SetMaterialDifColor(				int MHandle, int MaterialIndex, COLOR_F Color ) ;						// w̃}eÃfBt[YJ[ݒ肷
extern	COLOR_F		MV1GetMaterialDifColor( 			int MHandle, int MaterialIndex ) ;										// w̃}eÃfBt[YJ[擾
extern	int			MV1SetMaterialSpcColor( 			int MHandle, int MaterialIndex, COLOR_F Color ) ;						// w̃}eÃXyLJ[ݒ肷
extern	COLOR_F		MV1GetMaterialSpcColor( 			int MHandle, int MaterialIndex ) ;										// w̃}eÃXyLJ[擾
extern	int			MV1SetMaterialEmiColor( 			int MHandle, int MaterialIndex, COLOR_F Color ) ;						// w̃}eÃG~bVuJ[ݒ肷
extern	COLOR_F		MV1GetMaterialEmiColor( 			int MHandle, int MaterialIndex ) ;										// w̃}eÃG~bVuJ[擾
extern	int			MV1SetMaterialAmbColor( 			int MHandle, int MaterialIndex, COLOR_F Color ) ;						// w̃}eÃArGgJ[ݒ肷
extern	COLOR_F		MV1GetMaterialAmbColor( 			int MHandle, int MaterialIndex ) ;										// w̃}eÃArGgJ[擾
extern	int			MV1SetMaterialSpcPower( 			int MHandle, int MaterialIndex, float Power ) ;							// w̃}eÃXyL̋ݒ肷
extern	float		MV1GetMaterialSpcPower( 			int MHandle, int MaterialIndex ) ;										// w̃}eÃXyL̋擾
extern	int			MV1SetMaterialDifMapTexture(		int MHandle, int MaterialIndex, int TexIndex ) ;						// w̃}eAŃfBt[Y}bvƂĎgpeNX`w肷
extern	int			MV1GetMaterialDifMapTexture(		int MHandle, int MaterialIndex ) ;										// w̃}eAŃfBt[Y}bvƂĎgpĂeNX`̃CfbNX擾
extern	int			MV1SetMaterialSubDifMapTexture(		int MHandle, int MaterialIndex, int TexIndex ) ;						// w̃}eAŃTufBt[Y}bvƂĎgpeNX`w肷
extern	int			MV1GetMaterialSubDifMapTexture(		int MHandle, int MaterialIndex ) ;										// w̃}eAŃTufBt[Y}bvƂĎgpĂeNX`̃CfbNX擾
extern	int			MV1SetMaterialSpcMapTexture(		int MHandle, int MaterialIndex, int TexIndex ) ;						// w̃}eAŃXyL}bvƂĎgpeNX`w肷
extern	int			MV1GetMaterialSpcMapTexture(		int MHandle, int MaterialIndex ) ;										// w̃}eAŃXyL}bvƂĎgpĂeNX`̃CfbNX擾
extern	int			MV1SetMaterialNormalMapTexture(		int MHandle, int MaterialIndex, int TexIndex ) ;						// w̃}eAŖ@}bvƂĎgpeNX`w肷
extern	int			MV1GetMaterialNormalMapTexture(		int MHandle, int MaterialIndex ) ;										// w̃}eAŖ@}bvƂĎgpĂeNX`̃CfbNX擾
extern	int			MV1SetMaterialDifGradTexture(		int MHandle, int MaterialIndex, int TexIndex ) ;						// w̃}eAŃgD[_ÕfBt[YOf[V}bvƂĎgpeNX`ݒ肷
extern	int			MV1GetMaterialDifGradTexture(		int MHandle, int MaterialIndex ) ;										// w̃}eAŃgD[_ÕfBt[YOf[V}bvƂĎgpeNX`擾
extern	int			MV1SetMaterialSpcGradTexture(		int MHandle, int MaterialIndex, int TexIndex ) ;						// w̃}eAŃgD[_ÕXyLOf[V}bvƂĎgpeNX`ݒ肷
extern	int			MV1GetMaterialSpcGradTexture(		int MHandle, int MaterialIndex ) ;										// w̃}eAŃgD[_ÕXyLOf[V}bvƂĎgpeNX`擾
extern	int			MV1SetMaterialSphereMapTexture(		int MHandle, int MaterialIndex, int TexIndex ) ;						// w̃}eAŃgD[_ÕXtBA}bvƂĎgpeNX`ݒ肷
extern	int			MV1GetMaterialSphereMapTexture(		int MHandle, int MaterialIndex ) ;										// w̃}eAŃgD[_ÕXtBA}bvƂĎgpeNX`擾
extern	int			MV1SetMaterialDifGradBlendTypeAll(	int MHandle,                    int BlendType ) ;						// SẴ}eÃgD[_OŎgpfBt[YOf[V}bvƃfBt[YJ[̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1SetMaterialDifGradBlendType(		int MHandle, int MaterialIndex, int BlendType ) ;						// w̃}eÃgD[_OŎgpfBt[YOf[V}bvƃfBt[YJ[̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1GetMaterialDifGradBlendType(		int MHandle, int MaterialIndex ) ;										// w̃}eÃgD[_OŎgpfBt[YOf[V}bvƃfBt[YJ[̍@擾( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1SetMaterialSpcGradBlendTypeAll(	int MHandle,                    int BlendType ) ;						// SẴ}eÃgD[_OŎgpXyLOf[V}bvƃXyLJ[̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1SetMaterialSpcGradBlendType(		int MHandle, int MaterialIndex, int BlendType ) ;						// w̃}eÃgD[_OŎgpXyLOf[V}bvƃXyLJ[̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1GetMaterialSpcGradBlendType(		int MHandle, int MaterialIndex ) ;										// w̃}eÃgD[_OŎgpXyLOf[V}bvƃXyLJ[̍@擾( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1SetMaterialSphereMapBlendTypeAll( int MHandle,                   int BlendType ) ;						// SẴ}eÃgD[_OŎgpXtBA}bv̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1SetMaterialSphereMapBlendType(	int MHandle, int MaterialIndex, int BlendType ) ;						// w̃}eÃgD[_OŎgpXtBA}bv̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1GetMaterialSphereMapBlendType(	int MHandle, int MaterialIndex ) ;										// w̃}eÃgD[_OŎgpXtBA}bv̍@擾( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ )
extern	int			MV1SetMaterialOutLineWidthAll(		int MHandle,                    float Width ) ;							// SẴ}eÃgD[_OŎgp֊s̑ݒ肷
extern	int			MV1SetMaterialOutLineWidth(			int MHandle, int MaterialIndex, float Width ) ;							// w̃}eÃgD[_OŎgp֊s̑ݒ肷
extern	float		MV1GetMaterialOutLineWidth(			int MHandle, int MaterialIndex ) ;										// w̃}eÃgD[_OŎgp֊s̑擾
extern	int			MV1SetMaterialOutLineDotWidthAll(	int MHandle,                    float Width ) ;							// SẴ}eÃgD[_OŎgp֊s̃hbgPʂ̑ݒ肷
extern	int			MV1SetMaterialOutLineDotWidth(		int MHandle, int MaterialIndex, float Width ) ;							// w̃}eÃgD[_OŎgp֊s̃hbgPʂ̑ݒ肷
extern	float		MV1GetMaterialOutLineDotWidth(		int MHandle, int MaterialIndex ) ;										// w̃}eÃgD[_OŎgp֊s̃hbgPʂ̑擾
extern	int			MV1SetMaterialOutLineColorAll(		int MHandle,                    COLOR_F Color ) ;						// SẴ}eÃgD[_OŎgp֊s̐Fݒ肷
extern	int			MV1SetMaterialOutLineColor(			int MHandle, int MaterialIndex, COLOR_F Color ) ;						// w̃}eÃgD[_OŎgp֊s̐Fݒ肷
extern	COLOR_F		MV1GetMaterialOutLineColor(			int MHandle, int MaterialIndex ) ;										// w̃}eÃgD[_OŎgp֊s̐F擾
extern	int			MV1SetMaterialDrawBlendModeAll(		int MHandle,                    int BlendMode ) ;						// SẴ}eA̕`uh[hݒ肷( DX_BLENDMODE_ALPHA  )
extern	int			MV1SetMaterialDrawBlendMode(		int MHandle, int MaterialIndex, int BlendMode ) ;						// w̃}eA̕`uh[hݒ肷( DX_BLENDMODE_ALPHA  )
extern	int			MV1GetMaterialDrawBlendMode(		int MHandle, int MaterialIndex ) ;										// w̃}eA̕`uh[h擾( DX_BLENDMODE_ALPHA  )
extern	int			MV1SetMaterialDrawBlendParamAll(	int MHandle,                    int BlendParam ) ;						// SẴ}eA̕`uhp[^ݒ肷
extern	int			MV1SetMaterialDrawBlendParam(		int MHandle, int MaterialIndex, int BlendParam ) ;						// w̃}eA̕`uhp[^ݒ肷
extern	int			MV1GetMaterialDrawBlendParam(		int MHandle, int MaterialIndex ) ;										// w̃}eA̕`uhp[^ݒ肷
extern	int			MV1SetMaterialDrawAlphaTestAll(		int MHandle,                    int Enable, int Mode, int Param ) ;		// SẴ}eA̕`掞̃At@eXg̐ݒs( Enable:eXgsǂ( TRUE:s  FALSE:sȂ( ftHg ) ) Mode:eXg[h( DX_CMP_GREATER )  Param:`At@lƂ̔rɎgpl( 0`255 ) )
extern	int			MV1SetMaterialDrawAlphaTest(		int MHandle, int MaterialIndex,	int Enable, int Mode, int Param ) ;		// w̃}eA̕`掞̃At@eXg̐ݒs( Enable:eXgsǂ( TRUE:s  FALSE:sȂ( ftHg ) ) Mode:eXg[h( DX_CMP_GREATER )  Param:`At@lƂ̔rɎgpl( 0`255 ) )
extern	int			MV1GetMaterialDrawAlphaTestEnable(	int MHandle, int MaterialIndex ) ;										// w̃}eA̕`掞̃At@eXgsǂ擾( ߂l  TRUE:At@eXgs  FALSE:At@eXgsȂ )
extern	int			MV1GetMaterialDrawAlphaTestMode(	int MHandle, int MaterialIndex ) ;										// w̃}eA̕`掞̃At@eXg̃eXg[h擾( ߂l  eXg[h( DX_CMP_GREATER ) )
extern	int			MV1GetMaterialDrawAlphaTestParam(	int MHandle, int MaterialIndex ) ;										// w̃}eA̕`掞̃At@eXg̕`At@nƂ̔rɎgpl( 0`255 )擾
extern	int			MV1SetMaterialDrawAddColorAll(		int MHandle,                    int Red, int Green, int Blue ) ;		// SẴ}eA̕`掞̉ZJ[ݒ肷
extern	int			MV1SetMaterialDrawAddColor(			int MHandle, int MaterialIndex, int Red, int Green, int Blue ) ;		// w̃}eA̕`掞̉ZJ[ݒ肷
extern	int			MV1GetMaterialDrawAddColor(			int MHandle, int MaterialIndex, int *Red, int *Green, int *Blue ) ;		// w̃}eA̕`掞̉ZJ[擾

// eNX`֌W
extern	int			MV1GetTextureNum(						int MHandle ) ;														// eNX`̐擾
extern	const TCHAR *MV1GetTextureName(						int MHandle, int TexIndex ) ;										// eNX`̖O擾
extern	int			MV1SetTextureColorFilePath(				int MHandle, int TexIndex, const TCHAR *FilePath                        ) ;	// J[eNX`̃t@CpXύX
extern	int			MV1SetTextureColorFilePathWithStrLen(	int MHandle, int TexIndex, const TCHAR *FilePath, size_t FilePathLength ) ;	// J[eNX`̃t@CpXύX
extern	const TCHAR *MV1GetTextureColorFilePath(			int MHandle, int TexIndex ) ;										// J[eNX`̃t@CpX擾
extern	int			MV1SetTextureAlphaFilePath(				int MHandle, int TexIndex, const TCHAR *FilePath                        ) ;	// At@eNX`̃t@CpXύX
extern	int			MV1SetTextureAlphaFilePathWithStrLen(	int MHandle, int TexIndex, const TCHAR *FilePath, size_t FilePathLength ) ;	// At@eNX`̃t@CpXύX
extern	const TCHAR *MV1GetTextureAlphaFilePath(			int MHandle, int TexIndex ) ;										// At@eNX`̃t@CpX擾
extern	int			MV1SetTextureGraphHandle(				int MHandle, int TexIndex, int GrHandle, int SemiTransFlag ) ;		// eNX`ŎgpOtBbNnhύX( GrHandle  -1 ɂƉ )
extern	int			MV1GetTextureGraphHandle(				int MHandle, int TexIndex ) ;										// eNX`̃OtBbNnh擾
extern	int			MV1SetTextureAddressMode(				int MHandle, int TexIndex, int AddrUMode, int AddrVMode ) ;			// eNX`̃AhX[hݒ肷( AddUMode ̒l DX_TEXADDRESS_WRAP  )
extern	int			MV1GetTextureAddressModeU(				int MHandle, int TexIndex ) ;										// eNX`̂tl̃AhX[h擾( ߂l:DX_TEXADDRESS_WRAP  )
extern	int			MV1GetTextureAddressModeV(				int MHandle, int TexIndex ) ;										// eNX`̂ul̃AhX[h擾( ߂l:DX_TEXADDRESS_WRAP  )
extern	int			MV1GetTextureWidth(						int MHandle, int TexIndex ) ;										// eNX`̕擾
extern	int			MV1GetTextureHeight(					int MHandle, int TexIndex ) ;										// eNX`̍擾
extern	int			MV1GetTextureSemiTransState(			int MHandle, int TexIndex ) ;										// eNX`ɔvf邩ǂ擾( ߂l  TRUE:  FALSE:Ȃ )
extern	int			MV1SetTextureBumpImageFlag(				int MHandle, int TexIndex, int Flag ) ;								// eNX`ŎgpĂ摜ov}bvǂݒ肷
extern	int			MV1GetTextureBumpImageFlag(				int MHandle, int TexIndex ) ;										// eNX`ov}bvǂ擾( ߂l  TRUE:ov}bv  FALSE:Ⴄ )
extern	int			MV1SetTextureBumpImageNextPixelLength(	int MHandle, int TexIndex, float Length ) ;							// ov}bv摜̏ꍇׂ̗̃sNZƂ̋ݒ肷
extern	float		MV1GetTextureBumpImageNextPixelLength(	int MHandle, int TexIndex ) ;										// ov}bv摜̏ꍇׂ̗̃sNZƂ̋擾
extern	int			MV1SetTextureSampleFilterMode(			int MHandle, int TexIndex, int FilterMode ) ;						// eNX`̃tB^O[hݒ肷
extern	int			MV1GetTextureSampleFilterMode(			int MHandle, int TexIndex ) ;										// eNX`̃tB^O[h擾( ߂l  DX_DRAWMODE_BILINEAR )
extern	int			MV1AddTexture(							int MHandle, const TCHAR *Name,                    const TCHAR *ColorFilePath,                             const TCHAR *AlphaFilePath DEFAULTPARAM( = NULL ) ,                                                  void *ColorFileImage DEFAULTPARAM( = NULL ) , void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AddressModeU DEFAULTPARAM( = DX_TEXADDRESS_WRAP ) , int AddressModeV DEFAULTPARAM( = DX_TEXADDRESS_WRAP ) , int FilterMode DEFAULTPARAM( = DX_DRAWMODE_ANISOTROPIC ) , int BumpImageFlag DEFAULTPARAM( = FALSE ) , float BumpImageNextPixelLength DEFAULTPARAM( = 0.1f ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , int Bmp32AllZeroAlphaToXRGB8Flag DEFAULTPARAM( = FALSE ) ) ;	// fŎgpeNX`ǉ
extern	int			MV1AddTextureWithStrLen(				int MHandle, const TCHAR *Name, size_t NameLength, const TCHAR *ColorFilePath, size_t ColorFilePathLength, const TCHAR *AlphaFilePath DEFAULTPARAM( = NULL ) , size_t AlphaFilePathLength DEFAULTPARAM( = 0 ) , void *ColorFileImage DEFAULTPARAM( = NULL ) , void *AlphaFileImage DEFAULTPARAM( = NULL ) , int AddressModeU DEFAULTPARAM( = DX_TEXADDRESS_WRAP ) , int AddressModeV DEFAULTPARAM( = DX_TEXADDRESS_WRAP ) , int FilterMode DEFAULTPARAM( = DX_DRAWMODE_ANISOTROPIC ) , int BumpImageFlag DEFAULTPARAM( = FALSE ) , float BumpImageNextPixelLength DEFAULTPARAM( = 0.1f ) , int ReverseFlag DEFAULTPARAM( = FALSE ) , int Bmp32AllZeroAlphaToXRGB8Flag DEFAULTPARAM( = FALSE ) ) ;	// fŎgpeNX`ǉ
extern	int			MV1AddTextureGraphHandle(				int MHandle, const TCHAR *Name,                    int GrHandle, int SemiTransFlag,                                                                                                                                                                                                                         int AddressModeU DEFAULTPARAM( = DX_TEXADDRESS_WRAP ) , int AddressModeV DEFAULTPARAM( = DX_TEXADDRESS_WRAP ) , int FilterMode DEFAULTPARAM( = DX_DRAWMODE_ANISOTROPIC ) ) ;																																																			// fŎgpeNX`ǉ( OtBbNnheNX`ƂĒǉ )

extern	int			MV1LoadTexture(							const TCHAR *FilePath                        ) ;					// Rcfɓ\t̂Ɍ摜̓ǂݍݕŉ摜ǂݍ( ߂l  -1:G[  0ȏ:OtBbNnh )
extern	int			MV1LoadTextureWithStrLen(				const TCHAR *FilePath, size_t FilePathLength ) ;					// Rcfɓ\t̂Ɍ摜̓ǂݍݕŉ摜ǂݍ( ߂l  -1:G[  0ȏ:OtBbNnh )

// t[֌W
extern	int			MV1GetFrameNum(						int MHandle ) ;															// t[̐擾
extern	int			MV1SearchFrame(						int MHandle, const TCHAR *FrameName                         ) ;			// t[̖O烂f̃t[̃t[CfbNX擾( ꍇ͖߂l-1 )
extern	int			MV1SearchFrameWithStrLen(			int MHandle, const TCHAR *FrameName, size_t FrameNameLength ) ;			// t[̖O烂f̃t[̃t[CfbNX擾( ꍇ͖߂l-1 )
extern	int			MV1SearchFrameChild(				int MHandle, int FrameIndex DEFAULTPARAM( = -1 ) , const TCHAR *ChildName DEFAULTPARAM( = NULL )                              ) ;	// t[̖Ow̃t[̎qt[̃t[CfbNX擾( Ow )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( ꍇ͖߂l-1 )
extern	int			MV1SearchFrameChildWithStrLen(		int MHandle, int FrameIndex DEFAULTPARAM( = -1 ) , const TCHAR *ChildName DEFAULTPARAM( = NULL ) , size_t ChildNameLength DEFAULTPARAM( = 0 ) ) ;	// t[̖Ow̃t[̎qt[̃t[CfbNX擾( Ow )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( ꍇ͖߂l-1 )
extern	const TCHAR *MV1GetFrameName(					int MHandle, int FrameIndex ) ;											// w̃t[̖O擾( G[̏ꍇ͖߂l NULL )
extern	int			MV1GetFrameName2(					int MHandle, int FrameIndex, TCHAR *StrBuffer ) ;						// w̃t[̖O擾( ߂l   -1:G[  -1ȊO:̃TCY )
extern	int			MV1GetFrameParent(					int MHandle, int FrameIndex ) ;											// w̃t[̐et[̃CfbNX𓾂( eȂꍇ -2 Ԃ )
extern	int			MV1GetFrameChildNum(				int MHandle, int FrameIndex DEFAULTPARAM( = -1 ) ) ;											// w̃t[̎qt[̐擾( FrameIndex  -1 ɂƐeȂt[̐ԂĂ )
extern	int			MV1GetFrameChild(					int MHandle, int FrameIndex DEFAULTPARAM( = -1 ) , int ChildIndex DEFAULTPARAM( = 0 ) ) ;		// w̃t[̎qt[̃t[CfbNX擾( ԍw )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( G[̏ꍇ͖߂l-1 )
extern	VECTOR		MV1GetFramePosition(				int MHandle, int FrameIndex ) ;											// w̃t[̍W擾
extern	VECTOR_D	MV1GetFramePositionD(				int MHandle, int FrameIndex ) ;											// w̃t[̍W擾
extern	MATRIX		MV1GetFrameBaseLocalMatrix(			int MHandle, int FrameIndex ) ;											// w̃t[̏Ԃł̍Wϊs擾
extern	MATRIX_D	MV1GetFrameBaseLocalMatrixD(		int MHandle, int FrameIndex ) ;											// w̃t[̏Ԃł̍Wϊs擾
extern	MATRIX		MV1GetFrameLocalMatrix(				int MHandle, int FrameIndex ) ;											// w̃t[̍Wϊs擾
extern	MATRIX_D	MV1GetFrameLocalMatrixD(			int MHandle, int FrameIndex ) ;											// w̃t[̍Wϊs擾
extern	MATRIX		MV1GetFrameLocalWorldMatrix(		int MHandle, int FrameIndex ) ;											// w̃t[̃[JW烏[hWɕϊs𓾂
extern	MATRIX_D	MV1GetFrameLocalWorldMatrixD(		int MHandle, int FrameIndex ) ;											// w̃t[̃[JW烏[hWɕϊs𓾂
extern	int			MV1SetFrameUserLocalMatrix(			int MHandle, int FrameIndex, MATRIX   Matrix ) ;						// w̃t[̍Wϊs( [Js )ݒ肷
extern	int			MV1SetFrameUserLocalMatrixD(		int MHandle, int FrameIndex, MATRIX_D Matrix ) ;						// w̃t[̍Wϊs( [Js )ݒ肷
extern	int			MV1ResetFrameUserLocalMatrix(		int MHandle, int FrameIndex ) ;											// w̃t[̍Wϊs( [Js )ftHgɖ߂
extern	int			MV1SetFrameUserLocalWorldMatrix(	int MHandle, int FrameIndex, MATRIX   Matrix ) ;						// w̃t[̍Wϊs( [JW烏[hWɕϊs )ݒ肷
extern	int			MV1SetFrameUserLocalWorldMatrixD(	int MHandle, int FrameIndex, MATRIX_D Matrix ) ;						// w̃t[̍Wϊs( [JW烏[hWɕϊs )ݒ肷
extern	int			MV1ResetFrameUserLocalWorldMatrix(	int MHandle, int FrameIndex ) ;											// w̃t[̍Wϊs( [JW烏[hWɕϊs )ftHgɖ߂
extern	VECTOR		MV1GetFrameMaxVertexLocalPosition(	int MHandle, int FrameIndex ) ;											// w̃t[bV_̃[JWł̍ől𓾂
extern	VECTOR_D	MV1GetFrameMaxVertexLocalPositionD(	int MHandle, int FrameIndex ) ;											// w̃t[bV_̃[JWł̍ől𓾂
extern	VECTOR		MV1GetFrameMinVertexLocalPosition(	int MHandle, int FrameIndex ) ;											// w̃t[bV_̃[JWł̍ŏl𓾂
extern	VECTOR_D	MV1GetFrameMinVertexLocalPositionD(	int MHandle, int FrameIndex ) ;											// w̃t[bV_̃[JWł̍ŏl𓾂
extern	VECTOR		MV1GetFrameAvgVertexLocalPosition(	int MHandle, int FrameIndex ) ;											// w̃t[bV_̃[JWł̕ϒl𓾂
extern	VECTOR_D	MV1GetFrameAvgVertexLocalPositionD(	int MHandle, int FrameIndex ) ;											// w̃t[bV_̃[JWł̕ϒl𓾂
extern	int			MV1GetFrameVertexNum(				int MHandle, int FrameIndex ) ;											// w̃t[Ɋ܂܂钸_̐擾
extern	int			MV1GetFrameTriangleNum(				int MHandle, int FrameIndex ) ;											// w̃t[Ɋ܂܂|S̐擾
extern	int			MV1GetFrameMeshNum(					int MHandle, int FrameIndex ) ;											// w̃t[bV̐擾
extern	int			MV1GetFrameMesh(					int MHandle, int FrameIndex, int Index ) ;								// w̃t[bṼbVCfbNX擾
extern	int			MV1SetFrameVisible(					int MHandle, int FrameIndex, int VisibleFlag ) ;						// w̃t[̕\A\ԂύX( TRUE:\  FALSE:\ )
extern	int			MV1GetFrameVisible(					int MHandle, int FrameIndex ) ;											// w̃t[̕\A\Ԃ擾( TRUE:\  FALSE:\ )
extern	int			MV1SetFrameDifColorScale(			int MHandle, int FrameIndex, COLOR_F Scale ) ;							// w̃t[̃fBt[YJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	int			MV1SetFrameSpcColorScale(			int MHandle, int FrameIndex, COLOR_F Scale ) ;							// w̃t[̃XyLJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	int			MV1SetFrameEmiColorScale(			int MHandle, int FrameIndex, COLOR_F Scale ) ;							// w̃t[̃G~bVuJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	int			MV1SetFrameAmbColorScale(			int MHandle, int FrameIndex, COLOR_F Scale ) ;							// w̃t[̃ArGgJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	COLOR_F		MV1GetFrameDifColorScale(			int MHandle, int FrameIndex ) ;											// w̃t[̃fBt[YJ[̃XP[l擾( ftHgl 1.0f )
extern	COLOR_F		MV1GetFrameSpcColorScale(			int MHandle, int FrameIndex ) ;											// w̃t[̃XyLJ[̃XP[l擾( ftHgl 1.0f )
extern	COLOR_F		MV1GetFrameEmiColorScale(			int MHandle, int FrameIndex ) ;											// w̃t[̃G~bVuJ[̃XP[l擾( ftHgl 1.0f )
extern	COLOR_F		MV1GetFrameAmbColorScale(			int MHandle, int FrameIndex ) ;											// w̃t[̃ArGgJ[̃XP[l擾( ftHgl 1.0f )
extern	int			MV1GetFrameSemiTransState(			int MHandle, int FrameIndex ) ;											// w̃t[ɔvf邩ǂ擾( ߂l TRUE:  FALSE:Ȃ )
extern	int			MV1SetFrameOpacityRate(				int MHandle, int FrameIndex, float Rate ) ;								// w̃t[̕sxݒ肷( s 1.0f `  0.0f )
extern	float		MV1GetFrameOpacityRate(				int MHandle, int FrameIndex ) ;											// w̃t[̕sx擾( s 1.0f `  0.0f )
extern	int			MV1SetFrameBaseVisible(				int MHandle, int FrameIndex, int VisibleFlag ) ;						// w̃t[̏\Ԃݒ肷( TRUE:\  FALSE:\ )
extern	int			MV1GetFrameBaseVisible(				int MHandle, int FrameIndex ) ;											// w̃t[̏\Ԃ擾( TRUE:\  FALSE:\ )
extern	int			MV1SetFrameTextureAddressTransform( int MHandle, int FrameIndex, float TransU, float TransV, float ScaleU, float ScaleV, float RotCenterU, float RotCenterV, float Rotate ) ;	// w̃t[̃eNX`Wϊp[^ݒ肷
extern	int			MV1SetFrameTextureAddressTransformMatrix( int MHandle, int FrameIndex, MATRIX Matrix ) ;					// w̃t[̃eNX`WϊsZbg
extern	int			MV1ResetFrameTextureAddressTransform( int MHandle, int FrameIndex ) ;										// w̃t[̃eNX`Wϊp[^Zbg

// bV֌W
extern	int			MV1GetMeshNum(						int MHandle ) ;															// fɊ܂܂郁bV̐擾
extern	int			MV1GetMeshMaterial(					int MHandle, int MeshIndex ) ;											// w胁bVgpĂ}eÃCfbNX擾
extern	int			MV1GetMeshVertexNum(				int MHandle, int MeshIndex ) ;											// w胁bVɊ܂܂钸_̐擾
extern	int			MV1GetMeshTriangleNum(				int MHandle, int MeshIndex ) ;											// w胁bVɊ܂܂Op`|S̐擾
extern	int			MV1SetMeshVisible(					int MHandle, int MeshIndex, int VisibleFlag ) ;							// w胁bV̕\A\ԂύX( TRUE:\  FALSE:\ )
extern	int			MV1GetMeshVisible(					int MHandle, int MeshIndex ) ;											// w胁bV̕\A\Ԃ擾( TRUE:\  FALSE:\ )
extern	int			MV1SetMeshDifColorScale(			int MHandle, int MeshIndex, COLOR_F Scale ) ;							// w̃bṼfBt[YJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	int			MV1SetMeshSpcColorScale( 			int MHandle, int MeshIndex, COLOR_F Scale ) ;							// w̃bṼXyLJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	int			MV1SetMeshEmiColorScale( 			int MHandle, int MeshIndex, COLOR_F Scale ) ;							// w̃bṼG~bVuJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	int			MV1SetMeshAmbColorScale( 			int MHandle, int MeshIndex, COLOR_F Scale ) ;							// w̃bṼArGgJ[̃XP[lݒ肷( ftHgl 1.0f )
extern	COLOR_F		MV1GetMeshDifColorScale( 			int MHandle, int MeshIndex ) ;											// w̃bṼfBt[YJ[̃XP[l擾( ftHgl 1.0f )
extern	COLOR_F		MV1GetMeshSpcColorScale( 			int MHandle, int MeshIndex ) ;											// w̃bṼXyLJ[̃XP[l擾( ftHgl 1.0f )
extern	COLOR_F		MV1GetMeshEmiColorScale( 			int MHandle, int MeshIndex ) ;											// w̃bṼG~bVuJ[̃XP[l擾( ftHgl 1.0f )
extern	COLOR_F		MV1GetMeshAmbColorScale( 			int MHandle, int MeshIndex ) ;											// w̃bṼArGgJ[̃XP[l擾( ftHgl 1.0f )
extern	int			MV1SetMeshOpacityRate( 				int MHandle, int MeshIndex, float Rate ) ;								// w̃bV̕sxݒ肷( s 1.0f `  0.0f )
extern	float		MV1GetMeshOpacityRate( 				int MHandle, int MeshIndex ) ;											// w̃bV̕sx擾( s 1.0f `  0.0f )
extern	int			MV1SetMeshDrawBlendMode( 			int MHandle, int MeshIndex, int BlendMode ) ;							// w̃bV̕`uh[hݒ肷( DX_BLENDMODE_ALPHA  )
extern	int			MV1SetMeshDrawBlendParam( 			int MHandle, int MeshIndex, int BlendParam ) ;							// w̃bV̕`uhp[^ݒ肷
extern	int			MV1GetMeshDrawBlendMode( 			int MHandle, int MeshIndex ) ;											// w̃bV̕`uh[h擾( DX_BLENDMODE_ALPHA  )
extern	int			MV1GetMeshDrawBlendParam( 			int MHandle, int MeshIndex ) ;											// w̃bV̕`uhp[^ݒ肷
extern	int			MV1SetMeshBaseVisible( 				int MHandle, int MeshIndex, int VisibleFlag ) ;							// w̃bV̏\Ԃݒ肷( TRUE:\  FALSE:\ )
extern	int			MV1GetMeshBaseVisible( 				int MHandle, int MeshIndex ) ;											// w̃bV̏\Ԃ擾( TRUE:\  FALSE:\ )
extern	int			MV1SetMeshBackCulling( 				int MHandle, int MeshIndex, int CullingFlag ) ;							// w̃bṼobNJOsǂݒ肷( DX_CULLING_LEFT  )
extern	int			MV1GetMeshBackCulling( 				int MHandle, int MeshIndex ) ;											// w̃bṼobNJOsǂ擾( DX_CULLING_LEFT  )
extern	VECTOR		MV1GetMeshMaxPosition( 				int MHandle, int MeshIndex ) ;											// w̃bVɊ܂܂|S̍ő働[JW擾
extern	VECTOR		MV1GetMeshMinPosition( 				int MHandle, int MeshIndex ) ;											// w̃bVɊ܂܂|S̍ŏ[JW擾
extern	int			MV1GetMeshTListNum( 				int MHandle, int MeshIndex ) ;											// w̃bVɊ܂܂gCAOXg̐擾
extern	int			MV1GetMeshTList( 					int MHandle, int MeshIndex, int Index ) ;								// w̃bVɊ܂܂gCAOXg̃CfbNX擾
extern	int			MV1GetMeshSemiTransState( 			int MHandle, int MeshIndex ) ;											// w̃bVɔvf邩ǂ擾( ߂l TRUE:  FALSE:Ȃ )
extern	int			MV1SetMeshUseVertDifColor( 			int MHandle, int MeshIndex, int UseFlag ) ;								// w̃bV̒_fBt[YJ[}eÃfBt[YJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
extern	int			MV1SetMeshUseVertSpcColor( 			int MHandle, int MeshIndex, int UseFlag ) ;								// w̃bV̒_XyLJ[}eÃXyLJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
extern	int			MV1GetMeshUseVertDifColor( 			int MHandle, int MeshIndex ) ;											// w̃bV̒_fBt[YJ[}eÃfBt[YJ[̑Ɏgp邩ǂ̐ݒ擾( ߂l  TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
extern	int			MV1GetMeshUseVertSpcColor( 			int MHandle, int MeshIndex ) ;											// w̃bV̒_XyLJ[}eÃXyLJ[̑Ɏgp邩ǂ̐ݒ擾( ߂l  TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
extern	int			MV1GetMeshShapeFlag(				int MHandle, int MeshIndex ) ;											// w̃bVVFCvbVǂ擾( ߂l TRUE:VFCvbV  FALSE:ʏ탁bV )

// VFCv֌W
extern	int			MV1GetShapeNum(						int MHandle ) ;															// fɊ܂܂VFCv̐擾
extern	int			MV1SearchShape(						int MHandle, const TCHAR *ShapeName                         ) ;			// VFCv̖O烂f̃VFCṽVFCvCfbNX擾( ꍇ͖߂l-1 )
extern	int			MV1SearchShapeWithStrLen(			int MHandle, const TCHAR *ShapeName, size_t ShapeNameLength ) ;			// VFCv̖O烂f̃VFCṽVFCvCfbNX擾( ꍇ͖߂l-1 )
extern	const TCHAR *MV1GetShapeName(					int MHandle, int ShapeIndex ) ;											// wVFCv̖O擾
extern	int			MV1GetShapeTargetMeshNum(			int MHandle, int ShapeIndex ) ;											// wVFCvΏۂƂĂ郁bV̐擾
extern	int			MV1GetShapeTargetMesh(				int MHandle, int ShapeIndex, int Index ) ;								// wVFCvΏۂƂĂ郁bṼbVCfbNX擾
extern	int			MV1SetShapeRate(					int MHandle, int ShapeIndex, float Rate, int Type DEFAULTPARAM( = DX_MV1_SHAPERATE_ADD ) ) ;	// wVFCv̗Lݒ肷( Rate  0.0f:0% ` 1.0f:100% )
extern	float		MV1GetShapeRate(					int MHandle, int ShapeIndex ) ;											// wVFCv̗L擾( ߂l  0.0f:0% ` 1.0f:100% )
extern	float		MV1GetShapeApplyRate(				int MHandle, int ShapeIndex ) ;											// wVFCv̗L擾( ߂l  0.0f:0% ` 1.0f:100% )( MV1SetShapeRate Ŏw肵l̂܂ܖ߂lƂȂ MV1GetShapeRate ƈقȂAj[ṼVFCvȂǂl߂lƂȂ܂ )

// gCAOXg֌W
extern	int			MV1GetTriangleListNum(						int MHandle ) ;																		// fɊ܂܂gCAOXg̐擾
extern	int			MV1GetTriangleListVertexType(				int MHandle, int TListIndex ) ;														// w̃gCAOXg̒_f[^^Cv擾( DX_MV1_VERTEX_TYPE_1FRAME  )
extern	int			MV1GetTriangleListPolygonNum(				int MHandle, int TListIndex ) ;														// w̃gCAOXgɊ܂܂|S̐擾
extern	int			MV1GetTriangleListVertexNum(				int MHandle, int TListIndex ) ;														// w̃gCAOXgɊ܂܂钸_f[^̐擾
extern	int			MV1GetTriangleListLocalWorldMatrixNum(		int MHandle, int TListIndex ) ;														// w̃gCAOXggpWϊs̐擾
extern	MATRIX		MV1GetTriangleListLocalWorldMatrix(			int MHandle, int TListIndex, int LWMatrixIndex ) ;									// w̃gCAOXggpWϊs( [J[h )擾
extern	int			MV1GetTriangleListPolygonVertexPosition(	int MHandle, int TListIndex, int PolygonIndex, VECTOR *VertexPositionArray DEFAULTPARAM( = NULL ) , float *MatrixWeightArray DEFAULTPARAM( = NULL ) ) ;	// w̃gCAOXg̎w̃|SgpĂ钸_̍W擾( ߂l  G[F-1  0ȏF|SgpĂ钸_̐ )
extern	int			MV1GetTriangleListUseMaterial(				int MHandle, int TListIndex ) ;														// w̃gCAOXggpĂ}eÃCfbNX擾

// RW֌W
extern	int							MV1SetupCollInfo(				int MHandle, int FrameIndex DEFAULTPARAM( = -1 ) , int XDivNum DEFAULTPARAM( = 32 ) , int YDivNum DEFAULTPARAM( = 8 ) , int ZDivNum DEFAULTPARAM( = 32 ) , int MeshIndex DEFAULTPARAM( = -1 ) ) ;		// RW\z
extern	int							MV1TerminateCollInfo(			int MHandle, int FrameIndex DEFAULTPARAM( = -1 ) , int MeshIndex DEFAULTPARAM( = -1 ) ) ;																// RW̌n
extern	int							MV1RefreshCollInfo(				int MHandle, int FrameIndex DEFAULTPARAM( = -1 ) , int MeshIndex DEFAULTPARAM( = -1 ) ) ;																// RWXV
extern	MV1_COLL_RESULT_POLY		MV1CollCheck_Line(				int MHandle, int FrameIndex, VECTOR PosStart, VECTOR PosEnd , int MeshIndex DEFAULTPARAM( = -1 ) ) ;					// ƃf̓蔻
extern	MV1_COLL_RESULT_POLY_DIM	MV1CollCheck_LineDim(			int MHandle, int FrameIndex, VECTOR PosStart, VECTOR PosEnd , int MeshIndex DEFAULTPARAM( = -1 ) ) ;					// ƃf̓蔻( ߂l MV1_COLL_RESULT_POLY_DIM )
extern	MV1_COLL_RESULT_POLY_DIM	MV1CollCheck_Sphere(			int MHandle, int FrameIndex, VECTOR CenterPos, float r , int MeshIndex DEFAULTPARAM( = -1 ) ) ;							// ƃf̓蔻
extern	MV1_COLL_RESULT_POLY_DIM	MV1CollCheck_Capsule(			int MHandle, int FrameIndex, VECTOR Pos1, VECTOR Pos2, float r , int MeshIndex DEFAULTPARAM( = -1 ) ) ;					// JvZƃf̓蔻
extern	MV1_COLL_RESULT_POLY_DIM	MV1CollCheck_Triangle(			int MHandle, int FrameIndex, VECTOR Pos1, VECTOR Pos2, VECTOR Pos3 , int MeshIndex DEFAULTPARAM( = -1 ) ) ;				// Op`ƃf̓蔻
extern	MV1_COLL_RESULT_POLY		MV1CollCheck_GetResultPoly(		MV1_COLL_RESULT_POLY_DIM ResultPolyDim, int PolyNo ) ;																	// RWʃ|Sz񂩂wԍ̃|S擾
extern	int							MV1CollResultPolyDimTerminate(	MV1_COLL_RESULT_POLY_DIM ResultPolyDim ) ;																				// RWʃ|Sžn

// QƗpbV֌W
extern	int					MV1SetupReferenceMesh(		int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly DEFAULTPARAM( = FALSE ) , int MeshIndex DEFAULTPARAM( = -1 ) ) ;					// QƗpbṼZbgAbv
extern	int					MV1TerminateReferenceMesh(	int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly DEFAULTPARAM( = FALSE ) , int MeshIndex DEFAULTPARAM( = -1 ) ) ;					// QƗpbV̌n
extern	int					MV1RefreshReferenceMesh(	int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly DEFAULTPARAM( = FALSE ) , int MeshIndex DEFAULTPARAM( = -1 ) ) ;					// QƗpbV̍XV
extern	MV1_REF_POLYGONLIST	MV1GetReferenceMesh(		int MHandle, int FrameIndex, int IsTransform, int IsPositionOnly DEFAULTPARAM( = FALSE ) , int MeshIndex DEFAULTPARAM( = -1 ) ) ;					// QƗpbV擾

#endif // DX_NON_MODEL
























// DxLive2DCubism4.cpp ֐ vg^Cv錾

#ifndef DX_NON_LIVE2D_CUBISM4

extern	int			Live2D_SetCubism4CoreDLLPath(           const TCHAR *CoreDLLFilePath ) ;								// Live2DCubismCore.dll ̃t@CpXݒ肷
extern	int			Live2D_SetCubism4CoreDLLPathWithStrLen( const TCHAR *CoreDLLFilePath, size_t CoreDLLFilePathLength ) ;	// Live2DCubismCore.dll ̃t@CpXݒ肷
extern	int			Live2D_SetCubism3CoreDLLPath(           const TCHAR *CoreDLLFilePath ) ;								// Live2DCubismCore.dll ̃t@CpXݒ肷
extern	int			Live2D_SetCubism3CoreDLLPathWithStrLen( const TCHAR *CoreDLLFilePath, size_t CoreDLLFilePathLength ) ;	// Live2DCubismCore.dll ̃t@CpXݒ肷

extern	int			Live2D_RenderBegin( void ) ;																			// Live2D ̕`揈Jn
extern	int			Live2D_RenderEnd( void ) ;																				// Live2D ̕`揈I

extern	int			Live2D_LoadModel(			const TCHAR *FilePath ) ;													// Live2D ̃ft@Cǂݍ( 0ȏ:Live2Dfnh  }CiXl:G[ )
extern	int			Live2D_LoadModelWithStrLen(	const TCHAR *FilePath, size_t FilePathLength ) ;							// Live2D ̃ft@Cǂݍ( 0ȏ:Live2Dfnh  }CiXl:G[ )
extern	int			Live2D_DeleteModel(			int Live2DModelHandle ) ;													// Live2D ̃f폜
extern	int			Live2D_InitModel(			void ) ;																	// ׂĂ Live2D ̃f폜

extern	int			Live2D_SetUserShader( int TargetShader /* DX_LIVE2D_SHADER_NORMAL_PIXEL  */ , int ShaderHandle DEFAULTPARAM( = -1 ) ) ;		// Live2D ̃f`ŎgpVF[_[ݒ肷( ShaderHandle  -1 nƐݒ )
extern	int			Live2D_DrawCallback( void ( *Callback )( int Live2DModelHandle, int TextureIndex, void *UserData ), void *UserData ) ;			// Live2D ̃f`̑OɌĂ΂R[obN֐ݒ肷 Callback  NULL nƐݒ )
extern	int			Live2D_SetUseAutoScaling( int UseFlag ) ;																// Live2D ̃f`ۂɁAʃTCYɉXP[Osݒ肷( UseFlag  TRUE:XP[Os( ftHg )  FALSE:XP[OsȂ )
extern	int			Live2D_SetUseAutoCentering( int UseFlag ) ;																// Live2D ̃fʂ̒Sɕ`悷邩ݒ肷( UseFlag   TRUE:ʂ̒Sɕ`悷( ftHg )   FALSE:ʂ̒Sɕ`悵Ȃ )
extern	int			Live2D_SetUseReverseYAxis( int UseFlag ) ;																// Live2D_Model_SetTranslate Ŏw肷镽sړl y ̌𔽓]邩ݒ肷( UseFlag   TRUE:]( ftHg )   FALSE:]Ȃ )

extern	int			Live2D_Model_Update(			int Live2DModelHandle, float DeltaTimeSeconds ) ;						// Live2D ̃f̏ԂXV
extern	int			Live2D_Model_SetTranslate(		int Live2DModelHandle, float x, float y ) ;								// Live2D ̃f̈ʒuݒ肷
extern	int			Live2D_Model_SetExtendRate(		int Live2DModelHandle, float ExRateX, float ExRateY ) ;					// Live2D ̃f̊g嗦ݒ肷
extern	int			Live2D_Model_SetRotate(			int Live2DModelHandle, float RotAngle ) ;								// Live2D ̃f̉]ݒ肷
extern	int			Live2D_Model_Draw(				int Live2DModelHandle ) ;												// Live2D ̃f`悷

extern	int			Live2D_Model_StartMotion(				int Live2DModelHandle, const TCHAR *group,						int no, float fadeInSeconds DEFAULTPARAM( = -1.0f ) , float fadeOutSeconds DEFAULTPARAM( = -1.0f ) , int isLoopFadeIn DEFAULTPARAM( = TRUE ) ) ;	// Live2D ̃f̎w̃[VĐ
extern	int			Live2D_Model_StartMotionWithStrLen(		int Live2DModelHandle, const TCHAR *group, size_t groupLength,	int no, float fadeInSeconds DEFAULTPARAM( = -1.0f ) , float fadeOutSeconds DEFAULTPARAM( = -1.0f ) , int isLoopFadeIn DEFAULTPARAM( = TRUE ) ) ;	// Live2D ̃f̎w̃[VĐ
extern	int			Live2D_Model_GetLastPlayMotionNo(		int Live2DModelHandle ) ;																			// Live2D ̃fōŌɍĐ[ṼO[v̔ԍ擾
extern	int			Live2D_Model_IsMotionFinished(			int Live2DModelHandle ) ;																			// Live2D ̃f̃[VĐIĂ邩擾( ߂l  TRUE:ĐIĂ  FALSE:Đ )
extern	float		Live2D_Model_GetMotionPlayTime(			int Live2DModelHandle ) ;																			// Live2D ̃f̃[VĐԂ擾
extern	int			Live2D_Model_SetExpression(				int Live2DModelHandle, const TCHAR *expressionID ) ;												// Live2D ̃f̎w̕\[Vݒ肷
extern	int			Live2D_Model_SetExpressionWithStrLen(	int Live2DModelHandle, const TCHAR *expressionID, size_t expressionIDLength ) ;						// Live2D ̃f̎w̕\[Vݒ肷
extern	int			Live2D_Model_HitTest(					int Live2DModelHandle, const TCHAR *hitAreaName,							float x, float y ) ;	// w̍W Live2D ̃f̎w̓蔻̋`͈͓肷( TRUE:`͈͓  FALSE:`͈͊O )
extern	int			Live2D_Model_HitTestWithStrLen(			int Live2DModelHandle, const TCHAR *hitAreaName, size_t hitAreaNameLength,	float x, float y ) ;	// w̍W Live2D ̃f̎w̓蔻̋`͈͓肷( TRUE:`͈͓  FALSE:`͈͊O )

extern	int			Live2D_Model_GetParameterCount(						int Live2DModelHandle ) ;																// Live2D ̃fɐݒ肳Ăp[^̐擾
extern	const TCHAR *Live2D_Model_GetParameterId(						int Live2DModelHandle, int index ) ;													// Live2D ̃fɐݒ肳Ăp[^ID擾
extern	float		Live2D_Model_GetParameterValue(						int Live2DModelHandle, const TCHAR *parameterId ) ;										// Live2D ̃fɐݒ肳Ăp[^擾
extern	float		Live2D_Model_GetParameterValueWithStrLen(			int Live2DModelHandle, const TCHAR *parameterId, size_t parameterIdLength ) ;			// Live2D ̃fɐݒ肳Ăp[^擾
extern	int			Live2D_Model_SetParameterValue(						int Live2DModelHandle, const TCHAR *parameterId,                           float value ) ;	// Live2D ̃fɐݒ肳Ăp[^ݒ肷
extern	int			Live2D_Model_SetParameterValueWithStrLen(			int Live2DModelHandle, const TCHAR *parameterId, size_t parameterIdLength, float value ) ;	// Live2D ̃fɐݒ肳Ăp[^ݒ肷

extern	int			Live2D_Model_GetHitAreasCount(						int Live2DModelHandle ) ;																// Live2D ̃fɐݒ肳ꂽ蔻̐擾
extern	const TCHAR *Live2D_Model_GetHitAreaName(						int Live2DModelHandle, int index ) ;													// Live2D ̃f̓蔻ɐݒ肳ꂽO擾
extern	const TCHAR *Live2D_Model_GetPhysicsFileName(					int Live2DModelHandle ) ;																// Live2D ̃f̕Zݒt@C̖O擾
extern	const TCHAR *Live2D_Model_GetPoseFileName(						int Live2DModelHandle ) ;																// Live2D ̃f̃p[c؂ւݒt@C̖O擾
extern	int			Live2D_Model_GetExpressionCount(					int Live2DModelHandle ) ;																// Live2D ̃f̕\ݒt@C̐擾
extern	const TCHAR *Live2D_Model_GetExpressionName(					int Live2DModelHandle, int index ) ;													// Live2D ̃f̕\ݒt@CʂID擾
extern	const TCHAR *Live2D_Model_GetExpressionFileName(				int Live2DModelHandle, int index ) ;													// Live2D ̃f̕\ݒt@C̖O擾
extern	int			Live2D_Model_GetMotionGroupCount(					int Live2DModelHandle ) ;																// Live2D ̃f̃[VO[v̐擾
extern	const TCHAR *Live2D_Model_GetMotionGroupName(					int Live2DModelHandle, int index ) ;													// Live2D ̃f̃[VO[v̖O擾
extern	int			Live2D_Model_GetMotionCount(						int Live2DModelHandle, const TCHAR *groupName ) ;										// Live2D ̃f̃[VO[vɊ܂܂郂[V̐擾
extern	int			Live2D_Model_GetMotionCountWithStrLen(				int Live2DModelHandle, const TCHAR *groupName, size_t groupNameLength ) ;				// Live2D ̃f̃[VO[vɊ܂܂郂[V̐擾
extern	const TCHAR *Live2D_Model_GetMotionFileName(					int Live2DModelHandle, const TCHAR *groupName,							int index ) ;	// Live2D ̃f̃O[vƃCfbNXl烂[Vt@C̖O擾
extern	const TCHAR *Live2D_Model_GetMotionFileNameWithStrLen(			int Live2DModelHandle, const TCHAR *groupName, size_t groupNameLength,	int index ) ;	// Live2D ̃f̃O[vƃCfbNXl烂[Vt@C̖O擾
extern	const TCHAR *Live2D_Model_GetMotionSoundFileName(				int Live2DModelHandle, const TCHAR *groupName,							int index ) ;	// Live2D ̃f̃[VɑΉTEht@C̖O擾
extern	const TCHAR *Live2D_Model_GetMotionSoundFileNameWithStrLen(		int Live2DModelHandle, const TCHAR *groupName, size_t groupNameLength,	int index ) ;	// Live2D ̃f̃[VɑΉTEht@C̖O擾
extern	float		Live2D_Model_GetMotionFadeInTimeValue(				int Live2DModelHandle, const TCHAR *groupName,							int index ) ;	// Live2D ̃f̃[VJñtF[hCԂ擾
extern	float		Live2D_Model_GetMotionFadeInTimeValueWithStrLen(	int Live2DModelHandle, const TCHAR *groupName, size_t groupNameLength,	int index ) ;	// Live2D ̃f̃[VJñtF[hCԂ擾
extern	float		Live2D_Model_GetMotionFadeOutTimeValue(				int Live2DModelHandle, const TCHAR *groupName,							int index ) ;	// Live2D ̃f̃[VĨtF[hAEgԂ擾
extern	float		Live2D_Model_GetMotionFadeOutTimeValueWithStrLen(	int Live2DModelHandle, const TCHAR *groupName, size_t groupNameLength,	int index ) ;	// Live2D ̃f̃[VĨtF[hAEgԂ擾
extern	const TCHAR *Live2D_Model_GetUserDataFile(						int Live2DModelHandle ) ;																// Live2D ̃f̃[Uf[^̃t@C擾
extern	int			Live2D_Model_GetEyeBlinkParameterCount(				int Live2DModelHandle ) ;																// Live2D ̃f̖ڃp`Ɋ֘Atꂽp[^̐擾
extern	const TCHAR *Live2D_Model_GetEyeBlinkParameterId(				int Live2DModelHandle, int index ) ;													// Live2D ̃f̖ڃp`Ɋ֘Atꂽp[^ID擾
extern	int			Live2D_Model_GetLipSyncParameterCount(				int Live2DModelHandle ) ;																// Live2D ̃f̃bvVNɊ֘Atꂽp[^̐擾
extern	const TCHAR *Live2D_Model_GetLipSyncParameterId(				int Live2DModelHandle, int index ) ;													// Live2D ̃f̃bvVNɊ֘Atꂽp[^ID擾
extern	float		Live2D_Model_GetCanvasWidth(						int Live2DModelHandle ) ;																// Live2D ̃f̃LoX̉擾
extern	float		Live2D_Model_GetCanvasHeight(						int Live2DModelHandle ) ;																// Live2D ̃f̃LoX̏c擾

#endif // DX_NON_LIVE2D_CUBISM4








#undef DX_FUNCTION_START
#define DX_FUNCTION_END
#undef DX_FUNCTION_END

#if defined( __cplusplus ) && defined( DX_COMPILE_TYPE_C_LANGUAGE )
}
#endif

#ifndef DX_NON_NAMESPACE

}

#endif // DX_NON_NAMESPACE

// l[Xy[X DxLib gp ------------------------------------------------------
#ifndef DX_NON_NAMESPACE
#ifndef DX_NON_USING_NAMESPACE_DXLIB

using namespace DxLib ;

#endif // DX_NON_USING_NAMESPACE_DXLIB
#endif // DX_NON_NAMESPACE

// cwCuł̂ݎgpwb_t@C̃CN[h -------------------------

#ifdef DX_MAKE
//	#include "DxStatic.h"
#endif

#endif // DX_LIB_H


